
#include <pthread.h>
#include <assert.h>
#include <stdlib.h>
#include <stdio.h>

#include "helgrind/helgrind.h"

typedef
   struct {
      void* (*child)(void*);
      char* arr;
      int firstoff;
      int lastoff;
      int skipoff;
   }
   Info;

pthread_mutex_t mx;

void* child8 ( void* infoV )
{
   int r, i, firstoff, lastoff, skipoff;
   char* arr;
   Info* info = (Info*)infoV;
   firstoff = info->firstoff;
   lastoff  = info->lastoff;
   skipoff  = info->skipoff;
   arr      = info->arr;
   assert( sizeof(char) == 1 );
   assert( info->child == &child8 );
   for (i = firstoff; i <= lastoff; i += 1) {
      char* ptr = (char*)&arr[i];
      if (i == skipoff) {
        *ptr = 0;
      } else {
        r= pthread_mutex_lock( &mx ); assert(!r);
        *ptr = 0;
        r= pthread_mutex_unlock( &mx ); assert(!r);
      }
   }
   return NULL;
}

void* child16 ( void* infoV )
{
   int r, i, firstoff, lastoff, skipoff;
   char* arr;
   Info* info = (Info*)infoV;
   firstoff = info->firstoff;
   lastoff  = info->lastoff;
   skipoff  = info->skipoff;
   arr      = info->arr;
   assert( sizeof(short) == 2 );
   assert( info->child == &child16 );
   for (i = firstoff; i <= lastoff; i += 2) {
      short* ptr = (short*)&arr[i];
      if (i == skipoff) {
        *ptr = 0;
      } else {
        r= pthread_mutex_lock( &mx ); assert(!r);
        *ptr = 0;
        r= pthread_mutex_unlock( &mx ); assert(!r);
      }
   }
   return NULL;
}

void* child32 ( void* infoV )
{
   int r, i, firstoff, lastoff, skipoff;
   char* arr;
   Info* info = (Info*)infoV;
   firstoff = info->firstoff;
   lastoff  = info->lastoff;
   skipoff  = info->skipoff;
   arr      = info->arr;
   assert( sizeof(int) == 4 );
   assert( info->child == &child32 );
   for (i = firstoff; i <= lastoff; i += 4) {
      int* ptr = (int*)&arr[i];
      if (i == skipoff) {
        *ptr = 0;
      } else {
        r= pthread_mutex_lock( &mx ); assert(!r);
        *ptr = 0;
        r= pthread_mutex_unlock( &mx ); assert(!r);
      }
   }
   return NULL;
}

void* child64 ( void* infoV )
{
   int r, i, firstoff, lastoff, skipoff;
   char* arr;
   Info* info = (Info*)infoV;
   firstoff = info->firstoff;
   lastoff  = info->lastoff;
   skipoff  = info->skipoff;
   arr      = info->arr;
   assert( sizeof(double) == 8 );
   assert( info->child == &child64 );
   for (i = firstoff; i <= lastoff; i += 8) {
      double* ptr = (double*)&arr[i];
      if (i == skipoff) {
        *ptr = 0;
      } else {
        r= pthread_mutex_lock( &mx ); assert(!r);
        *ptr = 0;
        r= pthread_mutex_unlock( &mx ); assert(!r);
      }
   }
   return NULL;
}


void* steer ( void* infoV );

#define MAXXX 100   /* re 100: should cover at least 2 cycles 
of length 1 << N_LINE_BITS */
/* This is all a bit subtle.  First, after every inner loop over the
   data, we have to VALGRIND_TC_CLEAN_MEMORY it to get it back to a
   decent starting state.  Because info.arr is 8-aligned (is asserted
   for), the address range painter will paint at top level granularity
   (8-byte), which means we are guaranteed to see any errors from the
   next iteration at the maximum granularity that their alignment
   allows.

   Also, the pthread_joins cause the shadow mem cache to be flushed
   each iteration.  Given that all trees are pulled up to 64-bit by
   the abovementioned VALGRIND_TC_CLEAN_MEMORY, I think this
   irrelevant.
*/

int main ( void )
{
  pthread_t t1, t2;
  Info info;
  int off;

  pthread_mutex_init( &mx, NULL );

  info.arr = malloc(MAXXX);
  assert(info.arr);

  /* ensure array is 8-aligned.  this is important, as per comment
  above. */
  assert(0 == (7 & (unsigned long)info.arr));

#if 1
  /* Test 8 bit granularity */

  fprintf(stderr, "\n");
  fprintf(stderr,
          "===========================================================\n");
  fprintf(stderr,
          "=== 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 8 ===\n");
  fprintf(stderr,
          "===========================================================\n");
  fprintf(stderr, "\n");
  for (off = 0; off < MAXXX-1; off++) {

     info.firstoff = off & 0;
     info.lastoff  = MAXXX - 1;
     info.skipoff  = off;
     info.child    = child8;

     fprintf(stderr, "---------- char gran, %d .. %d, skip %d ----------\n",
             info.firstoff, info.lastoff, info.skipoff );

     pthread_create( &t1, NULL, steer, (void*)&info );
     pthread_create( &t2, NULL, steer, (void*)&info );

     pthread_join( t1, NULL );
     pthread_join( t2, NULL );

     VALGRIND_HG_CLEAN_MEMORY(&info.arr[0], MAXXX);

  }
#endif
#if 1
  /* Test 16 bit granularity */

  fprintf(stderr, "\n");
  fprintf(stderr,
          "==========================================================\n");
  fprintf(stderr,
          "=== 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 16 ===\n");
  fprintf(stderr,
          "==========================================================\n");
  fprintf(stderr, "\n");
  for (off = 0; off < MAXXX-2; off++) {

     info.firstoff = off & 1;
     info.lastoff  = MAXXX - 2;
     info.skipoff  = off;
     info.child    = child16;

     fprintf(stderr, "---------- short gran, %d .. %d, skip %d ----------\n",
             info.firstoff, info.lastoff, info.skipoff );

     pthread_create( &t1, NULL, steer, (void*)&info );
     pthread_create( &t2, NULL, steer, (void*)&info );

     pthread_join( t1, NULL );
     pthread_join( t2, NULL );

     VALGRIND_HG_CLEAN_MEMORY(&info.arr[0], MAXXX);

  }
#endif
#if 1
  /* Test 32 bit granularity */

  fprintf(stderr, "\n");
  fprintf(stderr,
          "==========================================================\n");
  fprintf(stderr,
          "=== 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 ===\n");
  fprintf(stderr,
          "==========================================================\n");
  fprintf(stderr, "\n");
  for (off = 0; off < MAXXX-4; off++) {

     info.firstoff = off & 3;
     info.lastoff  = MAXXX - 4;
     info.skipoff  = off;
     info.child    = child32;

     fprintf(stderr, "---------- int gran, %d .. %d, skip %d ----------\n",
             info.firstoff, info.lastoff, info.skipoff );

     pthread_create( &t1, NULL, steer, (void*)&info );
     pthread_create( &t2, NULL, steer, (void*)&info );

     pthread_join( t1, NULL );
     pthread_join( t2, NULL );

     VALGRIND_HG_CLEAN_MEMORY(&info.arr[0], MAXXX);

  }
#endif
#if 1
  /* Test 64 bit granularity */

  fprintf(stderr, "\n");
  fprintf(stderr,
          "==========================================================\n");
  fprintf(stderr,
          "=== 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 64 ===\n");
  fprintf(stderr,
          "==========================================================\n");
  fprintf(stderr, "\n");
  for (off = 0; off < MAXXX-8; off++) {

     info.firstoff = off & 7;
     info.lastoff  = MAXXX - 8;
     info.skipoff  = off;
     info.child    = child64;

     fprintf(stderr, "---------- double gran, %d .. %d, skip %d ----------\n",
             info.firstoff, info.lastoff, info.skipoff );

     pthread_create( &t1, NULL, steer, (void*)&info );
     pthread_create( &t2, NULL, steer, (void*)&info );

     pthread_join( t1, NULL );
     pthread_join( t2, NULL );

     VALGRIND_HG_CLEAN_MEMORY(&info.arr[0], MAXXX);

  }
#endif
  free(info.arr);

  return 0;
}

void* steer ( void* infoV )
{
   Info* info = (Info*)infoV;
   int   wot  = info->skipoff;
   void*(*fn)(void*) = info->child;
   if (wot >= 500) goto halfway;

   __asm__ __volatile__("");
   if (wot == 0) return fn(info);
   __asm__ __volatile__("");
   if (wot == 1) return fn(info);
   __asm__ __volatile__("");
   if (wot == 2) return fn(info);
   __asm__ __volatile__("");
   if (wot == 3) return fn(info);
   __asm__ __volatile__("");
   if (wot == 4) return fn(info);
   __asm__ __volatile__("");
   if (wot == 5) return fn(info);
   __asm__ __volatile__("");
   if (wot == 6) return fn(info);
   __asm__ __volatile__("");
   if (wot == 7) return fn(info);
   __asm__ __volatile__("");
   if (wot == 8) return fn(info);
   __asm__ __volatile__("");
   if (wot == 9) return fn(info);
   __asm__ __volatile__("");
   if (wot == 10) return fn(info);
   __asm__ __volatile__("");
   if (wot == 11) return fn(info);
   __asm__ __volatile__("");
   if (wot == 12) return fn(info);
   __asm__ __volatile__("");
   if (wot == 13) return fn(info);
   __asm__ __volatile__("");
   if (wot == 14) return fn(info);
   __asm__ __volatile__("");
   if (wot == 15) return fn(info);
   __asm__ __volatile__("");
   if (wot == 16) return fn(info);
   __asm__ __volatile__("");
   if (wot == 17) return fn(info);
   __asm__ __volatile__("");
   if (wot == 18) return fn(info);
   __asm__ __volatile__("");
   if (wot == 19) return fn(info);
   __asm__ __volatile__("");
   if (wot == 20) return fn(info);
   __asm__ __volatile__("");
   if (wot == 21) return fn(info);
   __asm__ __volatile__("");
   if (wot == 22) return fn(info);
   __asm__ __volatile__("");
   if (wot == 23) return fn(info);
   __asm__ __volatile__("");
   if (wot == 24) return fn(info);
   __asm__ __volatile__("");
   if (wot == 25) return fn(info);
   __asm__ __volatile__("");
   if (wot == 26) return fn(info);
   __asm__ __volatile__("");
   if (wot == 27) return fn(info);
   __asm__ __volatile__("");
   if (wot == 28) return fn(info);
   __asm__ __volatile__("");
   if (wot == 29) return fn(info);
   __asm__ __volatile__("");
   if (wot == 30) return fn(info);
   __asm__ __volatile__("");
   if (wot == 31) return fn(info);
   __asm__ __volatile__("");
   if (wot == 32) return fn(info);
   __asm__ __volatile__("");
   if (wot == 33) return fn(info);
   __asm__ __volatile__("");
   if (wot == 34) return fn(info);
   __asm__ __volatile__("");
   if (wot == 35) return fn(info);
   __asm__ __volatile__("");
   if (wot == 36) return fn(info);
   __asm__ __volatile__("");
   if (wot == 37) return fn(info);
   __asm__ __volatile__("");
   if (wot == 38) return fn(info);
   __asm__ __volatile__("");
   if (wot == 39) return fn(info);
   __asm__ __volatile__("");
   if (wot == 40) return fn(info);
   __asm__ __volatile__("");
   if (wot == 41) return fn(info);
   __asm__ __volatile__("");
   if (wot == 42) return fn(info);
   __asm__ __volatile__("");
   if (wot == 43) return fn(info);
   __asm__ __volatile__("");
   if (wot == 44) return fn(info);
   __asm__ __volatile__("");
   if (wot == 45) return fn(info);
   __asm__ __volatile__("");
   if (wot == 46) return fn(info);
   __asm__ __volatile__("");
   if (wot == 47) return fn(info);
   __asm__ __volatile__("");
   if (wot == 48) return fn(info);
   __asm__ __volatile__("");
   if (wot == 49) return fn(info);
   __asm__ __volatile__("");
   if (wot == 50) return fn(info);
   __asm__ __volatile__("");
   if (wot == 51) return fn(info);
   __asm__ __volatile__("");
   if (wot == 52) return fn(info);
   __asm__ __volatile__("");
   if (wot == 53) return fn(info);
   __asm__ __volatile__("");
   if (wot == 54) return fn(info);
   __asm__ __volatile__("");
   if (wot == 55) return fn(info);
   __asm__ __volatile__("");
   if (wot == 56) return fn(info);
   __asm__ __volatile__("");
   if (wot == 57) return fn(info);
   __asm__ __volatile__("");
   if (wot == 58) return fn(info);
   __asm__ __volatile__("");
   if (wot == 59) return fn(info);
   __asm__ __volatile__("");
   if (wot == 60) return fn(info);
   __asm__ __volatile__("");
   if (wot == 61) return fn(info);
   __asm__ __volatile__("");
   if (wot == 62) return fn(info);
   __asm__ __volatile__("");
   if (wot == 63) return fn(info);
   __asm__ __volatile__("");
   if (wot == 64) return fn(info);
   __asm__ __volatile__("");
   if (wot == 65) return fn(info);
   __asm__ __volatile__("");
   if (wot == 66) return fn(info);
   __asm__ __volatile__("");
   if (wot == 67) return fn(info);
   __asm__ __volatile__("");
   if (wot == 68) return fn(info);
   __asm__ __volatile__("");
   if (wot == 69) return fn(info);
   __asm__ __volatile__("");
   if (wot == 70) return fn(info);
   __asm__ __volatile__("");
   if (wot == 71) return fn(info);
   __asm__ __volatile__("");
   if (wot == 72) return fn(info);
   __asm__ __volatile__("");
   if (wot == 73) return fn(info);
   __asm__ __volatile__("");
   if (wot == 74) return fn(info);
   __asm__ __volatile__("");
   if (wot == 75) return fn(info);
   __asm__ __volatile__("");
   if (wot == 76) return fn(info);
   __asm__ __volatile__("");
   if (wot == 77) return fn(info);
   __asm__ __volatile__("");
   if (wot == 78) return fn(info);
   __asm__ __volatile__("");
   if (wot == 79) return fn(info);
   __asm__ __volatile__("");
   if (wot == 80) return fn(info);
   __asm__ __volatile__("");
   if (wot == 81) return fn(info);
   __asm__ __volatile__("");
   if (wot == 82) return fn(info);
   __asm__ __volatile__("");
   if (wot == 83) return fn(info);
   __asm__ __volatile__("");
   if (wot == 84) return fn(info);
   __asm__ __volatile__("");
   if (wot == 85) return fn(info);
   __asm__ __volatile__("");
   if (wot == 86) return fn(info);
   __asm__ __volatile__("");
   if (wot == 87) return fn(info);
   __asm__ __volatile__("");
   if (wot == 88) return fn(info);
   __asm__ __volatile__("");
   if (wot == 89) return fn(info);
   __asm__ __volatile__("");
   if (wot == 90) return fn(info);
   __asm__ __volatile__("");
   if (wot == 91) return fn(info);
   __asm__ __volatile__("");
   if (wot == 92) return fn(info);
   __asm__ __volatile__("");
   if (wot == 93) return fn(info);
   __asm__ __volatile__("");
   if (wot == 94) return fn(info);
   __asm__ __volatile__("");
   if (wot == 95) return fn(info);
   __asm__ __volatile__("");
   if (wot == 96) return fn(info);
   __asm__ __volatile__("");
   if (wot == 97) return fn(info);
   __asm__ __volatile__("");
   if (wot == 98) return fn(info);
   __asm__ __volatile__("");
   if (wot == 99) return fn(info);
   __asm__ __volatile__("");
   if (wot == 100) return fn(info);
   __asm__ __volatile__("");
   if (wot == 101) return fn(info);
   __asm__ __volatile__("");
   if (wot == 102) return fn(info);
   __asm__ __volatile__("");
   if (wot == 103) return fn(info);
   __asm__ __volatile__("");
   if (wot == 104) return fn(info);
   __asm__ __volatile__("");
   if (wot == 105) return fn(info);
   __asm__ __volatile__("");
   if (wot == 106) return fn(info);
   __asm__ __volatile__("");
   if (wot == 107) return fn(info);
   __asm__ __volatile__("");
   if (wot == 108) return fn(info);
   __asm__ __volatile__("");
   if (wot == 109) return fn(info);
   __asm__ __volatile__("");
   if (wot == 110) return fn(info);
   __asm__ __volatile__("");
   if (wot == 111) return fn(info);
   __asm__ __volatile__("");
   if (wot == 112) return fn(info);
   __asm__ __volatile__("");
   if (wot == 113) return fn(info);
   __asm__ __volatile__("");
   if (wot == 114) return fn(info);
   __asm__ __volatile__("");
   if (wot == 115) return fn(info);
   __asm__ __volatile__("");
   if (wot == 116) return fn(info);
   __asm__ __volatile__("");
   if (wot == 117) return fn(info);
   __asm__ __volatile__("");
   if (wot == 118) return fn(info);
   __asm__ __volatile__("");
   if (wot == 119) return fn(info);
   __asm__ __volatile__("");
   if (wot == 120) return fn(info);
   __asm__ __volatile__("");
   if (wot == 121) return fn(info);
   __asm__ __volatile__("");
   if (wot == 122) return fn(info);
   __asm__ __volatile__("");
   if (wot == 123) return fn(info);
   __asm__ __volatile__("");
   if (wot == 124) return fn(info);
   __asm__ __volatile__("");
   if (wot == 125) return fn(info);
   __asm__ __volatile__("");
   if (wot == 126) return fn(info);
   __asm__ __volatile__("");
   if (wot == 127) return fn(info);
   __asm__ __volatile__("");
   if (wot == 128) return fn(info);
   __asm__ __volatile__("");
   if (wot == 129) return fn(info);
   __asm__ __volatile__("");
   if (wot == 130) return fn(info);
   __asm__ __volatile__("");
   if (wot == 131) return fn(info);
   __asm__ __volatile__("");
   if (wot == 132) return fn(info);
   __asm__ __volatile__("");
   if (wot == 133) return fn(info);
   __asm__ __volatile__("");
   if (wot == 134) return fn(info);
   __asm__ __volatile__("");
   if (wot == 135) return fn(info);
   __asm__ __volatile__("");
   if (wot == 136) return fn(info);
   __asm__ __volatile__("");
   if (wot == 137) return fn(info);
   __asm__ __volatile__("");
   if (wot == 138) return fn(info);
   __asm__ __volatile__("");
   if (wot == 139) return fn(info);
   __asm__ __volatile__("");
   if (wot == 140) return fn(info);
   __asm__ __volatile__("");
   if (wot == 141) return fn(info);
   __asm__ __volatile__("");
   if (wot == 142) return fn(info);
   __asm__ __volatile__("");
   if (wot == 143) return fn(info);
   __asm__ __volatile__("");
   if (wot == 144) return fn(info);
   __asm__ __volatile__("");
   if (wot == 145) return fn(info);
   __asm__ __volatile__("");
   if (wot == 146) return fn(info);
   __asm__ __volatile__("");
   if (wot == 147) return fn(info);
   __asm__ __volatile__("");
   if (wot == 148) return fn(info);
   __asm__ __volatile__("");
   if (wot == 149) return fn(info);
   __asm__ __volatile__("");
   if (wot == 150) return fn(info);
   __asm__ __volatile__("");
   if (wot == 151) return fn(info);
   __asm__ __volatile__("");
   if (wot == 152) return fn(info);
   __asm__ __volatile__("");
   if (wot == 153) return fn(info);
   __asm__ __volatile__("");
   if (wot == 154) return fn(info);
   __asm__ __volatile__("");
   if (wot == 155) return fn(info);
   __asm__ __volatile__("");
   if (wot == 156) return fn(info);
   __asm__ __volatile__("");
   if (wot == 157) return fn(info);
   __asm__ __volatile__("");
   if (wot == 158) return fn(info);
   __asm__ __volatile__("");
   if (wot == 159) return fn(info);
   __asm__ __volatile__("");
   if (wot == 160) return fn(info);
   __asm__ __volatile__("");
   if (wot == 161) return fn(info);
   __asm__ __volatile__("");
   if (wot == 162) return fn(info);
   __asm__ __volatile__("");
   if (wot == 163) return fn(info);
   __asm__ __volatile__("");
   if (wot == 164) return fn(info);
   __asm__ __volatile__("");
   if (wot == 165) return fn(info);
   __asm__ __volatile__("");
   if (wot == 166) return fn(info);
   __asm__ __volatile__("");
   if (wot == 167) return fn(info);
   __asm__ __volatile__("");
   if (wot == 168) return fn(info);
   __asm__ __volatile__("");
   if (wot == 169) return fn(info);
   __asm__ __volatile__("");
   if (wot == 170) return fn(info);
   __asm__ __volatile__("");
   if (wot == 171) return fn(info);
   __asm__ __volatile__("");
   if (wot == 172) return fn(info);
   __asm__ __volatile__("");
   if (wot == 173) return fn(info);
   __asm__ __volatile__("");
   if (wot == 174) return fn(info);
   __asm__ __volatile__("");
   if (wot == 175) return fn(info);
   __asm__ __volatile__("");
   if (wot == 176) return fn(info);
   __asm__ __volatile__("");
   if (wot == 177) return fn(info);
   __asm__ __volatile__("");
   if (wot == 178) return fn(info);
   __asm__ __volatile__("");
   if (wot == 179) return fn(info);
   __asm__ __volatile__("");
   if (wot == 180) return fn(info);
   __asm__ __volatile__("");
   if (wot == 181) return fn(info);
   __asm__ __volatile__("");
   if (wot == 182) return fn(info);
   __asm__ __volatile__("");
   if (wot == 183) return fn(info);
   __asm__ __volatile__("");
   if (wot == 184) return fn(info);
   __asm__ __volatile__("");
   if (wot == 185) return fn(info);
   __asm__ __volatile__("");
   if (wot == 186) return fn(info);
   __asm__ __volatile__("");
   if (wot == 187) return fn(info);
   __asm__ __volatile__("");
   if (wot == 188) return fn(info);
   __asm__ __volatile__("");
   if (wot == 189) return fn(info);
   __asm__ __volatile__("");
   if (wot == 190) return fn(info);
   __asm__ __volatile__("");
   if (wot == 191) return fn(info);
   __asm__ __volatile__("");
   if (wot == 192) return fn(info);
   __asm__ __volatile__("");
   if (wot == 193) return fn(info);
   __asm__ __volatile__("");
   if (wot == 194) return fn(info);
   __asm__ __volatile__("");
   if (wot == 195) return fn(info);
   __asm__ __volatile__("");
   if (wot == 196) return fn(info);
   __asm__ __volatile__("");
   if (wot == 197) return fn(info);
   __asm__ __volatile__("");
   if (wot == 198) return fn(info);
   __asm__ __volatile__("");
   if (wot == 199) return fn(info);
   __asm__ __volatile__("");
   if (wot == 200) return fn(info);
   __asm__ __volatile__("");
   if (wot == 201) return fn(info);
   __asm__ __volatile__("");
   if (wot == 202) return fn(info);
   __asm__ __volatile__("");
   if (wot == 203) return fn(info);
   __asm__ __volatile__("");
   if (wot == 204) return fn(info);
   __asm__ __volatile__("");
   if (wot == 205) return fn(info);
   __asm__ __volatile__("");
   if (wot == 206) return fn(info);
   __asm__ __volatile__("");
   if (wot == 207) return fn(info);
   __asm__ __volatile__("");
   if (wot == 208) return fn(info);
   __asm__ __volatile__("");
   if (wot == 209) return fn(info);
   __asm__ __volatile__("");
   if (wot == 210) return fn(info);
   __asm__ __volatile__("");
   if (wot == 211) return fn(info);
   __asm__ __volatile__("");
   if (wot == 212) return fn(info);
   __asm__ __volatile__("");
   if (wot == 213) return fn(info);
   __asm__ __volatile__("");
   if (wot == 214) return fn(info);
   __asm__ __volatile__("");
   if (wot == 215) return fn(info);
   __asm__ __volatile__("");
   if (wot == 216) return fn(info);
   __asm__ __volatile__("");
   if (wot == 217) return fn(info);
   __asm__ __volatile__("");
   if (wot == 218) return fn(info);
   __asm__ __volatile__("");
   if (wot == 219) return fn(info);
   __asm__ __volatile__("");
   if (wot == 220) return fn(info);
   __asm__ __volatile__("");
   if (wot == 221) return fn(info);
   __asm__ __volatile__("");
   if (wot == 222) return fn(info);
   __asm__ __volatile__("");
   if (wot == 223) return fn(info);
   __asm__ __volatile__("");
   if (wot == 224) return fn(info);
   __asm__ __volatile__("");
   if (wot == 225) return fn(info);
   __asm__ __volatile__("");
   if (wot == 226) return fn(info);
   __asm__ __volatile__("");
   if (wot == 227) return fn(info);
   __asm__ __volatile__("");
   if (wot == 228) return fn(info);
   __asm__ __volatile__("");
   if (wot == 229) return fn(info);
   __asm__ __volatile__("");
   if (wot == 230) return fn(info);
   __asm__ __volatile__("");
   if (wot == 231) return fn(info);
   __asm__ __volatile__("");
   if (wot == 232) return fn(info);
   __asm__ __volatile__("");
   if (wot == 233) return fn(info);
   __asm__ __volatile__("");
   if (wot == 234) return fn(info);
   __asm__ __volatile__("");
   if (wot == 235) return fn(info);
   __asm__ __volatile__("");
   if (wot == 236) return fn(info);
   __asm__ __volatile__("");
   if (wot == 237) return fn(info);
   __asm__ __volatile__("");
   if (wot == 238) return fn(info);
   __asm__ __volatile__("");
   if (wot == 239) return fn(info);
   __asm__ __volatile__("");
   if (wot == 240) return fn(info);
   __asm__ __volatile__("");
   if (wot == 241) return fn(info);
   __asm__ __volatile__("");
   if (wot == 242) return fn(info);
   __asm__ __volatile__("");
   if (wot == 243) return fn(info);
   __asm__ __volatile__("");
   if (wot == 244) return fn(info);
   __asm__ __volatile__("");
   if (wot == 245) return fn(info);
   __asm__ __volatile__("");
   if (wot == 246) return fn(info);
   __asm__ __volatile__("");
   if (wot == 247) return fn(info);
   __asm__ __volatile__("");
   if (wot == 248) return fn(info);
   __asm__ __volatile__("");
   if (wot == 249) return fn(info);
   __asm__ __volatile__("");
   if (wot == 250) return fn(info);
   __asm__ __volatile__("");
   if (wot == 251) return fn(info);
   __asm__ __volatile__("");
   if (wot == 252) return fn(info);
   __asm__ __volatile__("");
   if (wot == 253) return fn(info);
   __asm__ __volatile__("");
   if (wot == 254) return fn(info);
   __asm__ __volatile__("");
   if (wot == 255) return fn(info);
   __asm__ __volatile__("");
   if (wot == 256) return fn(info);
   __asm__ __volatile__("");
   if (wot == 257) return fn(info);
   __asm__ __volatile__("");
   if (wot == 258) return fn(info);
   __asm__ __volatile__("");
   if (wot == 259) return fn(info);
   __asm__ __volatile__("");
   if (wot == 260) return fn(info);
   __asm__ __volatile__("");
   if (wot == 261) return fn(info);
   __asm__ __volatile__("");
   if (wot == 262) return fn(info);
   __asm__ __volatile__("");
   if (wot == 263) return fn(info);
   __asm__ __volatile__("");
   if (wot == 264) return fn(info);
   __asm__ __volatile__("");
   if (wot == 265) return fn(info);
   __asm__ __volatile__("");
   if (wot == 266) return fn(info);
   __asm__ __volatile__("");
   if (wot == 267) return fn(info);
   __asm__ __volatile__("");
   if (wot == 268) return fn(info);
   __asm__ __volatile__("");
   if (wot == 269) return fn(info);
   __asm__ __volatile__("");
   if (wot == 270) return fn(info);
   __asm__ __volatile__("");
   if (wot == 271) return fn(info);
   __asm__ __volatile__("");
   if (wot == 272) return fn(info);
   __asm__ __volatile__("");
   if (wot == 273) return fn(info);
   __asm__ __volatile__("");
   if (wot == 274) return fn(info);
   __asm__ __volatile__("");
   if (wot == 275) return fn(info);
   __asm__ __volatile__("");
   if (wot == 276) return fn(info);
   __asm__ __volatile__("");
   if (wot == 277) return fn(info);
   __asm__ __volatile__("");
   if (wot == 278) return fn(info);
   __asm__ __volatile__("");
   if (wot == 279) return fn(info);
   __asm__ __volatile__("");
   if (wot == 280) return fn(info);
   __asm__ __volatile__("");
   if (wot == 281) return fn(info);
   __asm__ __volatile__("");
   if (wot == 282) return fn(info);
   __asm__ __volatile__("");
   if (wot == 283) return fn(info);
   __asm__ __volatile__("");
   if (wot == 284) return fn(info);
   __asm__ __volatile__("");
   if (wot == 285) return fn(info);
   __asm__ __volatile__("");
   if (wot == 286) return fn(info);
   __asm__ __volatile__("");
   if (wot == 287) return fn(info);
   __asm__ __volatile__("");
   if (wot == 288) return fn(info);
   __asm__ __volatile__("");
   if (wot == 289) return fn(info);
   __asm__ __volatile__("");
   if (wot == 290) return fn(info);
   __asm__ __volatile__("");
   if (wot == 291) return fn(info);
   __asm__ __volatile__("");
   if (wot == 292) return fn(info);
   __asm__ __volatile__("");
   if (wot == 293) return fn(info);
   __asm__ __volatile__("");
   if (wot == 294) return fn(info);
   __asm__ __volatile__("");
   if (wot == 295) return fn(info);
   __asm__ __volatile__("");
   if (wot == 296) return fn(info);
   __asm__ __volatile__("");
   if (wot == 297) return fn(info);
   __asm__ __volatile__("");
   if (wot == 298) return fn(info);
   __asm__ __volatile__("");
   if (wot == 299) return fn(info);
   __asm__ __volatile__("");
   if (wot == 300) return fn(info);
   __asm__ __volatile__("");
   if (wot == 301) return fn(info);
   __asm__ __volatile__("");
   if (wot == 302) return fn(info);
   __asm__ __volatile__("");
   if (wot == 303) return fn(info);
   __asm__ __volatile__("");
   if (wot == 304) return fn(info);
   __asm__ __volatile__("");
   if (wot == 305) return fn(info);
   __asm__ __volatile__("");
   if (wot == 306) return fn(info);
   __asm__ __volatile__("");
   if (wot == 307) return fn(info);
   __asm__ __volatile__("");
   if (wot == 308) return fn(info);
   __asm__ __volatile__("");
   if (wot == 309) return fn(info);
   __asm__ __volatile__("");
   if (wot == 310) return fn(info);
   __asm__ __volatile__("");
   if (wot == 311) return fn(info);
   __asm__ __volatile__("");
   if (wot == 312) return fn(info);
   __asm__ __volatile__("");
   if (wot == 313) return fn(info);
   __asm__ __volatile__("");
   if (wot == 314) return fn(info);
   __asm__ __volatile__("");
   if (wot == 315) return fn(info);
   __asm__ __volatile__("");
   if (wot == 316) return fn(info);
   __asm__ __volatile__("");
   if (wot == 317) return fn(info);
   __asm__ __volatile__("");
   if (wot == 318) return fn(info);
   __asm__ __volatile__("");
   if (wot == 319) return fn(info);
   __asm__ __volatile__("");
   if (wot == 320) return fn(info);
   __asm__ __volatile__("");
   if (wot == 321) return fn(info);
   __asm__ __volatile__("");
   if (wot == 322) return fn(info);
   __asm__ __volatile__("");
   if (wot == 323) return fn(info);
   __asm__ __volatile__("");
   if (wot == 324) return fn(info);
   __asm__ __volatile__("");
   if (wot == 325) return fn(info);
   __asm__ __volatile__("");
   if (wot == 326) return fn(info);
   __asm__ __volatile__("");
   if (wot == 327) return fn(info);
   __asm__ __volatile__("");
   if (wot == 328) return fn(info);
   __asm__ __volatile__("");
   if (wot == 329) return fn(info);
   __asm__ __volatile__("");
   if (wot == 330) return fn(info);
   __asm__ __volatile__("");
   if (wot == 331) return fn(info);
   __asm__ __volatile__("");
   if (wot == 332) return fn(info);
   __asm__ __volatile__("");
   if (wot == 333) return fn(info);
   __asm__ __volatile__("");
   if (wot == 334) return fn(info);
   __asm__ __volatile__("");
   if (wot == 335) return fn(info);
   __asm__ __volatile__("");
   if (wot == 336) return fn(info);
   __asm__ __volatile__("");
   if (wot == 337) return fn(info);
   __asm__ __volatile__("");
   if (wot == 338) return fn(info);
   __asm__ __volatile__("");
   if (wot == 339) return fn(info);
   __asm__ __volatile__("");
   if (wot == 340) return fn(info);
   __asm__ __volatile__("");
   if (wot == 341) return fn(info);
   __asm__ __volatile__("");
   if (wot == 342) return fn(info);
   __asm__ __volatile__("");
   if (wot == 343) return fn(info);
   __asm__ __volatile__("");
   if (wot == 344) return fn(info);
   __asm__ __volatile__("");
   if (wot == 345) return fn(info);
   __asm__ __volatile__("");
   if (wot == 346) return fn(info);
   __asm__ __volatile__("");
   if (wot == 347) return fn(info);
   __asm__ __volatile__("");
   if (wot == 348) return fn(info);
   __asm__ __volatile__("");
   if (wot == 349) return fn(info);
   __asm__ __volatile__("");
   if (wot == 350) return fn(info);
   __asm__ __volatile__("");
   if (wot == 351) return fn(info);
   __asm__ __volatile__("");
   if (wot == 352) return fn(info);
   __asm__ __volatile__("");
   if (wot == 353) return fn(info);
   __asm__ __volatile__("");
   if (wot == 354) return fn(info);
   __asm__ __volatile__("");
   if (wot == 355) return fn(info);
   __asm__ __volatile__("");
   if (wot == 356) return fn(info);
   __asm__ __volatile__("");
   if (wot == 357) return fn(info);
   __asm__ __volatile__("");
   if (wot == 358) return fn(info);
   __asm__ __volatile__("");
   if (wot == 359) return fn(info);
   __asm__ __volatile__("");
   if (wot == 360) return fn(info);
   __asm__ __volatile__("");
   if (wot == 361) return fn(info);
   __asm__ __volatile__("");
   if (wot == 362) return fn(info);
   __asm__ __volatile__("");
   if (wot == 363) return fn(info);
   __asm__ __volatile__("");
   if (wot == 364) return fn(info);
   __asm__ __volatile__("");
   if (wot == 365) return fn(info);
   __asm__ __volatile__("");
   if (wot == 366) return fn(info);
   __asm__ __volatile__("");
   if (wot == 367) return fn(info);
   __asm__ __volatile__("");
   if (wot == 368) return fn(info);
   __asm__ __volatile__("");
   if (wot == 369) return fn(info);
   __asm__ __volatile__("");
   if (wot == 370) return fn(info);
   __asm__ __volatile__("");
   if (wot == 371) return fn(info);
   __asm__ __volatile__("");
   if (wot == 372) return fn(info);
   __asm__ __volatile__("");
   if (wot == 373) return fn(info);
   __asm__ __volatile__("");
   if (wot == 374) return fn(info);
   __asm__ __volatile__("");
   if (wot == 375) return fn(info);
   __asm__ __volatile__("");
   if (wot == 376) return fn(info);
   __asm__ __volatile__("");
   if (wot == 377) return fn(info);
   __asm__ __volatile__("");
   if (wot == 378) return fn(info);
   __asm__ __volatile__("");
   if (wot == 379) return fn(info);
   __asm__ __volatile__("");
   if (wot == 380) return fn(info);
   __asm__ __volatile__("");
   if (wot == 381) return fn(info);
   __asm__ __volatile__("");
   if (wot == 382) return fn(info);
   __asm__ __volatile__("");
   if (wot == 383) return fn(info);
   __asm__ __volatile__("");
   if (wot == 384) return fn(info);
   __asm__ __volatile__("");
   if (wot == 385) return fn(info);
   __asm__ __volatile__("");
   if (wot == 386) return fn(info);
   __asm__ __volatile__("");
   if (wot == 387) return fn(info);
   __asm__ __volatile__("");
   if (wot == 388) return fn(info);
   __asm__ __volatile__("");
   if (wot == 389) return fn(info);
   __asm__ __volatile__("");
   if (wot == 390) return fn(info);
   __asm__ __volatile__("");
   if (wot == 391) return fn(info);
   __asm__ __volatile__("");
   if (wot == 392) return fn(info);
   __asm__ __volatile__("");
   if (wot == 393) return fn(info);
   __asm__ __volatile__("");
   if (wot == 394) return fn(info);
   __asm__ __volatile__("");
   if (wot == 395) return fn(info);
   __asm__ __volatile__("");
   if (wot == 396) return fn(info);
   __asm__ __volatile__("");
   if (wot == 397) return fn(info);
   __asm__ __volatile__("");
   if (wot == 398) return fn(info);
   __asm__ __volatile__("");
   if (wot == 399) return fn(info);
   __asm__ __volatile__("");
   if (wot == 400) return fn(info);
   __asm__ __volatile__("");
   if (wot == 401) return fn(info);
   __asm__ __volatile__("");
   if (wot == 402) return fn(info);
   __asm__ __volatile__("");
   if (wot == 403) return fn(info);
   __asm__ __volatile__("");
   if (wot == 404) return fn(info);
   __asm__ __volatile__("");
   if (wot == 405) return fn(info);
   __asm__ __volatile__("");
   if (wot == 406) return fn(info);
   __asm__ __volatile__("");
   if (wot == 407) return fn(info);
   __asm__ __volatile__("");
   if (wot == 408) return fn(info);
   __asm__ __volatile__("");
   if (wot == 409) return fn(info);
   __asm__ __volatile__("");
   if (wot == 410) return fn(info);
   __asm__ __volatile__("");
   if (wot == 411) return fn(info);
   __asm__ __volatile__("");
   if (wot == 412) return fn(info);
   __asm__ __volatile__("");
   if (wot == 413) return fn(info);
   __asm__ __volatile__("");
   if (wot == 414) return fn(info);
   __asm__ __volatile__("");
   if (wot == 415) return fn(info);
   __asm__ __volatile__("");
   if (wot == 416) return fn(info);
   __asm__ __volatile__("");
   if (wot == 417) return fn(info);
   __asm__ __volatile__("");
   if (wot == 418) return fn(info);
   __asm__ __volatile__("");
   if (wot == 419) return fn(info);
   __asm__ __volatile__("");
   if (wot == 420) return fn(info);
   __asm__ __volatile__("");
   if (wot == 421) return fn(info);
   __asm__ __volatile__("");
   if (wot == 422) return fn(info);
   __asm__ __volatile__("");
   if (wot == 423) return fn(info);
   __asm__ __volatile__("");
   if (wot == 424) return fn(info);
   __asm__ __volatile__("");
   if (wot == 425) return fn(info);
   __asm__ __volatile__("");
   if (wot == 426) return fn(info);
   __asm__ __volatile__("");
   if (wot == 427) return fn(info);
   __asm__ __volatile__("");
   if (wot == 428) return fn(info);
   __asm__ __volatile__("");
   if (wot == 429) return fn(info);
   __asm__ __volatile__("");
   if (wot == 430) return fn(info);
   __asm__ __volatile__("");
   if (wot == 431) return fn(info);
   __asm__ __volatile__("");
   if (wot == 432) return fn(info);
   __asm__ __volatile__("");
   if (wot == 433) return fn(info);
   __asm__ __volatile__("");
   if (wot == 434) return fn(info);
   __asm__ __volatile__("");
   if (wot == 435) return fn(info);
   __asm__ __volatile__("");
   if (wot == 436) return fn(info);
   __asm__ __volatile__("");
   if (wot == 437) return fn(info);
   __asm__ __volatile__("");
   if (wot == 438) return fn(info);
   __asm__ __volatile__("");
   if (wot == 439) return fn(info);
   __asm__ __volatile__("");
   if (wot == 440) return fn(info);
   __asm__ __volatile__("");
   if (wot == 441) return fn(info);
   __asm__ __volatile__("");
   if (wot == 442) return fn(info);
   __asm__ __volatile__("");
   if (wot == 443) return fn(info);
   __asm__ __volatile__("");
   if (wot == 444) return fn(info);
   __asm__ __volatile__("");
   if (wot == 445) return fn(info);
   __asm__ __volatile__("");
   if (wot == 446) return fn(info);
   __asm__ __volatile__("");
   if (wot == 447) return fn(info);
   __asm__ __volatile__("");
   if (wot == 448) return fn(info);
   __asm__ __volatile__("");
   if (wot == 449) return fn(info);
   __asm__ __volatile__("");
   if (wot == 450) return fn(info);
   __asm__ __volatile__("");
   if (wot == 451) return fn(info);
   __asm__ __volatile__("");
   if (wot == 452) return fn(info);
   __asm__ __volatile__("");
   if (wot == 453) return fn(info);
   __asm__ __volatile__("");
   if (wot == 454) return fn(info);
   __asm__ __volatile__("");
   if (wot == 455) return fn(info);
   __asm__ __volatile__("");
   if (wot == 456) return fn(info);
   __asm__ __volatile__("");
   if (wot == 457) return fn(info);
   __asm__ __volatile__("");
   if (wot == 458) return fn(info);
   __asm__ __volatile__("");
   if (wot == 459) return fn(info);
   __asm__ __volatile__("");
   if (wot == 460) return fn(info);
   __asm__ __volatile__("");
   if (wot == 461) return fn(info);
   __asm__ __volatile__("");
   if (wot == 462) return fn(info);
   __asm__ __volatile__("");
   if (wot == 463) return fn(info);
   __asm__ __volatile__("");
   if (wot == 464) return fn(info);
   __asm__ __volatile__("");
   if (wot == 465) return fn(info);
   __asm__ __volatile__("");
   if (wot == 466) return fn(info);
   __asm__ __volatile__("");
   if (wot == 467) return fn(info);
   __asm__ __volatile__("");
   if (wot == 468) return fn(info);
   __asm__ __volatile__("");
   if (wot == 469) return fn(info);
   __asm__ __volatile__("");
   if (wot == 470) return fn(info);
   __asm__ __volatile__("");
   if (wot == 471) return fn(info);
   __asm__ __volatile__("");
   if (wot == 472) return fn(info);
   __asm__ __volatile__("");
   if (wot == 473) return fn(info);
   __asm__ __volatile__("");
   if (wot == 474) return fn(info);
   __asm__ __volatile__("");
   if (wot == 475) return fn(info);
   __asm__ __volatile__("");
   if (wot == 476) return fn(info);
   __asm__ __volatile__("");
   if (wot == 477) return fn(info);
   __asm__ __volatile__("");
   if (wot == 478) return fn(info);
   __asm__ __volatile__("");
   if (wot == 479) return fn(info);
   __asm__ __volatile__("");
   if (wot == 480) return fn(info);
   __asm__ __volatile__("");
   if (wot == 481) return fn(info);
   __asm__ __volatile__("");
   if (wot == 482) return fn(info);
   __asm__ __volatile__("");
   if (wot == 483) return fn(info);
   __asm__ __volatile__("");
   if (wot == 484) return fn(info);
   __asm__ __volatile__("");
   if (wot == 485) return fn(info);
   __asm__ __volatile__("");
   if (wot == 486) return fn(info);
   __asm__ __volatile__("");
   if (wot == 487) return fn(info);
   __asm__ __volatile__("");
   if (wot == 488) return fn(info);
   __asm__ __volatile__("");
   if (wot == 489) return fn(info);
   __asm__ __volatile__("");
   if (wot == 490) return fn(info);
   __asm__ __volatile__("");
   if (wot == 491) return fn(info);
   __asm__ __volatile__("");
   if (wot == 492) return fn(info);
   __asm__ __volatile__("");
   if (wot == 493) return fn(info);
   __asm__ __volatile__("");
   if (wot == 494) return fn(info);
   __asm__ __volatile__("");
   if (wot == 495) return fn(info);
   __asm__ __volatile__("");
   if (wot == 496) return fn(info);
   __asm__ __volatile__("");
   if (wot == 497) return fn(info);
   __asm__ __volatile__("");
   if (wot == 498) return fn(info);
   __asm__ __volatile__("");
   if (wot == 499) return fn(info);
   __asm__ __volatile__("");
  halfway:
   if (wot == 500) return fn(info);
   __asm__ __volatile__("");
   if (wot == 501) return fn(info);
   __asm__ __volatile__("");
   if (wot == 502) return fn(info);
   __asm__ __volatile__("");
   if (wot == 503) return fn(info);
   __asm__ __volatile__("");
   if (wot == 504) return fn(info);
   __asm__ __volatile__("");
   if (wot == 505) return fn(info);
   __asm__ __volatile__("");
   if (wot == 506) return fn(info);
   __asm__ __volatile__("");
   if (wot == 507) return fn(info);
   __asm__ __volatile__("");
   if (wot == 508) return fn(info);
   __asm__ __volatile__("");
   if (wot == 509) return fn(info);
   __asm__ __volatile__("");
   if (wot == 510) return fn(info);
   __asm__ __volatile__("");
   if (wot == 511) return fn(info);
   __asm__ __volatile__("");
   if (wot == 512) return fn(info);
   __asm__ __volatile__("");
   if (wot == 513) return fn(info);
   __asm__ __volatile__("");
   if (wot == 514) return fn(info);
   __asm__ __volatile__("");
   if (wot == 515) return fn(info);
   __asm__ __volatile__("");
   if (wot == 516) return fn(info);
   __asm__ __volatile__("");
   if (wot == 517) return fn(info);
   __asm__ __volatile__("");
   if (wot == 518) return fn(info);
   __asm__ __volatile__("");
   if (wot == 519) return fn(info);
   __asm__ __volatile__("");
   if (wot == 520) return fn(info);
   __asm__ __volatile__("");
   if (wot == 521) return fn(info);
   __asm__ __volatile__("");
   if (wot == 522) return fn(info);
   __asm__ __volatile__("");
   if (wot == 523) return fn(info);
   __asm__ __volatile__("");
   if (wot == 524) return fn(info);
   __asm__ __volatile__("");
   if (wot == 525) return fn(info);
   __asm__ __volatile__("");
   if (wot == 526) return fn(info);
   __asm__ __volatile__("");
   if (wot == 527) return fn(info);
   __asm__ __volatile__("");
   if (wot == 528) return fn(info);
   __asm__ __volatile__("");
   if (wot == 529) return fn(info);
   __asm__ __volatile__("");
   if (wot == 530) return fn(info);
   __asm__ __volatile__("");
   if (wot == 531) return fn(info);
   __asm__ __volatile__("");
   if (wot == 532) return fn(info);
   __asm__ __volatile__("");
   if (wot == 533) return fn(info);
   __asm__ __volatile__("");
   if (wot == 534) return fn(info);
   __asm__ __volatile__("");
   if (wot == 535) return fn(info);
   __asm__ __volatile__("");
   if (wot == 536) return fn(info);
   __asm__ __volatile__("");
   if (wot == 537) return fn(info);
   __asm__ __volatile__("");
   if (wot == 538) return fn(info);
   __asm__ __volatile__("");
   if (wot == 539) return fn(info);
   __asm__ __volatile__("");
   if (wot == 540) return fn(info);
   __asm__ __volatile__("");
   if (wot == 541) return fn(info);
   __asm__ __volatile__("");
   if (wot == 542) return fn(info);
   __asm__ __volatile__("");
   if (wot == 543) return fn(info);
   __asm__ __volatile__("");
   if (wot == 544) return fn(info);
   __asm__ __volatile__("");
   if (wot == 545) return fn(info);
   __asm__ __volatile__("");
   if (wot == 546) return fn(info);
   __asm__ __volatile__("");
   if (wot == 547) return fn(info);
   __asm__ __volatile__("");
   if (wot == 548) return fn(info);
   __asm__ __volatile__("");
   if (wot == 549) return fn(info);
   __asm__ __volatile__("");
   if (wot == 550) return fn(info);
   __asm__ __volatile__("");
   if (wot == 551) return fn(info);
   __asm__ __volatile__("");
   if (wot == 552) return fn(info);
   __asm__ __volatile__("");
   if (wot == 553) return fn(info);
   __asm__ __volatile__("");
   if (wot == 554) return fn(info);
   __asm__ __volatile__("");
   if (wot == 555) return fn(info);
   __asm__ __volatile__("");
   if (wot == 556) return fn(info);
   __asm__ __volatile__("");
   if (wot == 557) return fn(info);
   __asm__ __volatile__("");
   if (wot == 558) return fn(info);
   __asm__ __volatile__("");
   if (wot == 559) return fn(info);
   __asm__ __volatile__("");
   if (wot == 560) return fn(info);
   __asm__ __volatile__("");
   if (wot == 561) return fn(info);
   __asm__ __volatile__("");
   if (wot == 562) return fn(info);
   __asm__ __volatile__("");
   if (wot == 563) return fn(info);
   __asm__ __volatile__("");
   if (wot == 564) return fn(info);
   __asm__ __volatile__("");
   if (wot == 565) return fn(info);
   __asm__ __volatile__("");
   if (wot == 566) return fn(info);
   __asm__ __volatile__("");
   if (wot == 567) return fn(info);
   __asm__ __volatile__("");
   if (wot == 568) return fn(info);
   __asm__ __volatile__("");
   if (wot == 569) return fn(info);
   __asm__ __volatile__("");
   if (wot == 570) return fn(info);
   __asm__ __volatile__("");
   if (wot == 571) return fn(info);
   __asm__ __volatile__("");
   if (wot == 572) return fn(info);
   __asm__ __volatile__("");
   if (wot == 573) return fn(info);
   __asm__ __volatile__("");
   if (wot == 574) return fn(info);
   __asm__ __volatile__("");
   if (wot == 575) return fn(info);
   __asm__ __volatile__("");
   if (wot == 576) return fn(info);
   __asm__ __volatile__("");
   if (wot == 577) return fn(info);
   __asm__ __volatile__("");
   if (wot == 578) return fn(info);
   __asm__ __volatile__("");
   if (wot == 579) return fn(info);
   __asm__ __volatile__("");
   if (wot == 580) return fn(info);
   __asm__ __volatile__("");
   if (wot == 581) return fn(info);
   __asm__ __volatile__("");
   if (wot == 582) return fn(info);
   __asm__ __volatile__("");
   if (wot == 583) return fn(info);
   __asm__ __volatile__("");
   if (wot == 584) return fn(info);
   __asm__ __volatile__("");
   if (wot == 585) return fn(info);
   __asm__ __volatile__("");
   if (wot == 586) return fn(info);
   __asm__ __volatile__("");
   if (wot == 587) return fn(info);
   __asm__ __volatile__("");
   if (wot == 588) return fn(info);
   __asm__ __volatile__("");
   if (wot == 589) return fn(info);
   __asm__ __volatile__("");
   if (wot == 590) return fn(info);
   __asm__ __volatile__("");
   if (wot == 591) return fn(info);
   __asm__ __volatile__("");
   if (wot == 592) return fn(info);
   __asm__ __volatile__("");
   if (wot == 593) return fn(info);
   __asm__ __volatile__("");
   if (wot == 594) return fn(info);
   __asm__ __volatile__("");
   if (wot == 595) return fn(info);
   __asm__ __volatile__("");
   if (wot == 596) return fn(info);
   __asm__ __volatile__("");
   if (wot == 597) return fn(info);
   __asm__ __volatile__("");
   if (wot == 598) return fn(info);
   __asm__ __volatile__("");
   if (wot == 599) return fn(info);
   __asm__ __volatile__("");
   if (wot == 600) return fn(info);
   __asm__ __volatile__("");
   if (wot == 601) return fn(info);
   __asm__ __volatile__("");
   if (wot == 602) return fn(info);
   __asm__ __volatile__("");
   if (wot == 603) return fn(info);
   __asm__ __volatile__("");
   if (wot == 604) return fn(info);
   __asm__ __volatile__("");
   if (wot == 605) return fn(info);
   __asm__ __volatile__("");
   if (wot == 606) return fn(info);
   __asm__ __volatile__("");
   if (wot == 607) return fn(info);
   __asm__ __volatile__("");
   if (wot == 608) return fn(info);
   __asm__ __volatile__("");
   if (wot == 609) return fn(info);
   __asm__ __volatile__("");
   if (wot == 610) return fn(info);
   __asm__ __volatile__("");
   if (wot == 611) return fn(info);
   __asm__ __volatile__("");
   if (wot == 612) return fn(info);
   __asm__ __volatile__("");
   if (wot == 613) return fn(info);
   __asm__ __volatile__("");
   if (wot == 614) return fn(info);
   __asm__ __volatile__("");
   if (wot == 615) return fn(info);
   __asm__ __volatile__("");
   if (wot == 616) return fn(info);
   __asm__ __volatile__("");
   if (wot == 617) return fn(info);
   __asm__ __volatile__("");
   if (wot == 618) return fn(info);
   __asm__ __volatile__("");
   if (wot == 619) return fn(info);
   __asm__ __volatile__("");
   if (wot == 620) return fn(info);
   __asm__ __volatile__("");
   if (wot == 621) return fn(info);
   __asm__ __volatile__("");
   if (wot == 622) return fn(info);
   __asm__ __volatile__("");
   if (wot == 623) return fn(info);
   __asm__ __volatile__("");
   if (wot == 624) return fn(info);
   __asm__ __volatile__("");
   if (wot == 625) return fn(info);
   __asm__ __volatile__("");
   if (wot == 626) return fn(info);
   __asm__ __volatile__("");
   if (wot == 627) return fn(info);
   __asm__ __volatile__("");
   if (wot == 628) return fn(info);
   __asm__ __volatile__("");
   if (wot == 629) return fn(info);
   __asm__ __volatile__("");
   if (wot == 630) return fn(info);
   __asm__ __volatile__("");
   if (wot == 631) return fn(info);
   __asm__ __volatile__("");
   if (wot == 632) return fn(info);
   __asm__ __volatile__("");
   if (wot == 633) return fn(info);
   __asm__ __volatile__("");
   if (wot == 634) return fn(info);
   __asm__ __volatile__("");
   if (wot == 635) return fn(info);
   __asm__ __volatile__("");
   if (wot == 636) return fn(info);
   __asm__ __volatile__("");
   if (wot == 637) return fn(info);
   __asm__ __volatile__("");
   if (wot == 638) return fn(info);
   __asm__ __volatile__("");
   if (wot == 639) return fn(info);
   __asm__ __volatile__("");
   if (wot == 640) return fn(info);
   __asm__ __volatile__("");
   if (wot == 641) return fn(info);
   __asm__ __volatile__("");
   if (wot == 642) return fn(info);
   __asm__ __volatile__("");
   if (wot == 643) return fn(info);
   __asm__ __volatile__("");
   if (wot == 644) return fn(info);
   __asm__ __volatile__("");
   if (wot == 645) return fn(info);
   __asm__ __volatile__("");
   if (wot == 646) return fn(info);
   __asm__ __volatile__("");
   if (wot == 647) return fn(info);
   __asm__ __volatile__("");
   if (wot == 648) return fn(info);
   __asm__ __volatile__("");
   if (wot == 649) return fn(info);
   __asm__ __volatile__("");
   if (wot == 650) return fn(info);
   __asm__ __volatile__("");
   if (wot == 651) return fn(info);
   __asm__ __volatile__("");
   if (wot == 652) return fn(info);
   __asm__ __volatile__("");
   if (wot == 653) return fn(info);
   __asm__ __volatile__("");
   if (wot == 654) return fn(info);
   __asm__ __volatile__("");
   if (wot == 655) return fn(info);
   __asm__ __volatile__("");
   if (wot == 656) return fn(info);
   __asm__ __volatile__("");
   if (wot == 657) return fn(info);
   __asm__ __volatile__("");
   if (wot == 658) return fn(info);
   __asm__ __volatile__("");
   if (wot == 659) return fn(info);
   __asm__ __volatile__("");
   if (wot == 660) return fn(info);
   __asm__ __volatile__("");
   if (wot == 661) return fn(info);
   __asm__ __volatile__("");
   if (wot == 662) return fn(info);
   __asm__ __volatile__("");
   if (wot == 663) return fn(info);
   __asm__ __volatile__("");
   if (wot == 664) return fn(info);
   __asm__ __volatile__("");
   if (wot == 665) return fn(info);
   __asm__ __volatile__("");
   if (wot == 666) return fn(info);
   __asm__ __volatile__("");
   if (wot == 667) return fn(info);
   __asm__ __volatile__("");
   if (wot == 668) return fn(info);
   __asm__ __volatile__("");
   if (wot == 669) return fn(info);
   __asm__ __volatile__("");
   if (wot == 670) return fn(info);
   __asm__ __volatile__("");
   if (wot == 671) return fn(info);
   __asm__ __volatile__("");
   if (wot == 672) return fn(info);
   __asm__ __volatile__("");
   if (wot == 673) return fn(info);
   __asm__ __volatile__("");
   if (wot == 674) return fn(info);
   __asm__ __volatile__("");
   if (wot == 675) return fn(info);
   __asm__ __volatile__("");
   if (wot == 676) return fn(info);
   __asm__ __volatile__("");
   if (wot == 677) return fn(info);
   __asm__ __volatile__("");
   if (wot == 678) return fn(info);
   __asm__ __volatile__("");
   if (wot == 679) return fn(info);
   __asm__ __volatile__("");
   if (wot == 680) return fn(info);
   __asm__ __volatile__("");
   if (wot == 681) return fn(info);
   __asm__ __volatile__("");
   if (wot == 682) return fn(info);
   __asm__ __volatile__("");
   if (wot == 683) return fn(info);
   __asm__ __volatile__("");
   if (wot == 684) return fn(info);
   __asm__ __volatile__("");
   if (wot == 685) return fn(info);
   __asm__ __volatile__("");
   if (wot == 686) return fn(info);
   __asm__ __volatile__("");
   if (wot == 687) return fn(info);
   __asm__ __volatile__("");
   if (wot == 688) return fn(info);
   __asm__ __volatile__("");
   if (wot == 689) return fn(info);
   __asm__ __volatile__("");
   if (wot == 690) return fn(info);
   __asm__ __volatile__("");
   if (wot == 691) return fn(info);
   __asm__ __volatile__("");
   if (wot == 692) return fn(info);
   __asm__ __volatile__("");
   if (wot == 693) return fn(info);
   __asm__ __volatile__("");
   if (wot == 694) return fn(info);
   __asm__ __volatile__("");
   if (wot == 695) return fn(info);
   __asm__ __volatile__("");
   if (wot == 696) return fn(info);
   __asm__ __volatile__("");
   if (wot == 697) return fn(info);
   __asm__ __volatile__("");
   if (wot == 698) return fn(info);
   __asm__ __volatile__("");
   if (wot == 699) return fn(info);
   __asm__ __volatile__("");
   if (wot == 700) return fn(info);
   __asm__ __volatile__("");
   if (wot == 701) return fn(info);
   __asm__ __volatile__("");
   if (wot == 702) return fn(info);
   __asm__ __volatile__("");
   if (wot == 703) return fn(info);
   __asm__ __volatile__("");
   if (wot == 704) return fn(info);
   __asm__ __volatile__("");
   if (wot == 705) return fn(info);
   __asm__ __volatile__("");
   if (wot == 706) return fn(info);
   __asm__ __volatile__("");
   if (wot == 707) return fn(info);
   __asm__ __volatile__("");
   if (wot == 708) return fn(info);
   __asm__ __volatile__("");
   if (wot == 709) return fn(info);
   __asm__ __volatile__("");
   if (wot == 710) return fn(info);
   __asm__ __volatile__("");
   if (wot == 711) return fn(info);
   __asm__ __volatile__("");
   if (wot == 712) return fn(info);
   __asm__ __volatile__("");
   if (wot == 713) return fn(info);
   __asm__ __volatile__("");
   if (wot == 714) return fn(info);
   __asm__ __volatile__("");
   if (wot == 715) return fn(info);
   __asm__ __volatile__("");
   if (wot == 716) return fn(info);
   __asm__ __volatile__("");
   if (wot == 717) return fn(info);
   __asm__ __volatile__("");
   if (wot == 718) return fn(info);
   __asm__ __volatile__("");
   if (wot == 719) return fn(info);
   __asm__ __volatile__("");
   if (wot == 720) return fn(info);
   __asm__ __volatile__("");
   if (wot == 721) return fn(info);
   __asm__ __volatile__("");
   if (wot == 722) return fn(info);
   __asm__ __volatile__("");
   if (wot == 723) return fn(info);
   __asm__ __volatile__("");
   if (wot == 724) return fn(info);
   __asm__ __volatile__("");
   if (wot == 725) return fn(info);
   __asm__ __volatile__("");
   if (wot == 726) return fn(info);
   __asm__ __volatile__("");
   if (wot == 727) return fn(info);
   __asm__ __volatile__("");
   if (wot == 728) return fn(info);
   __asm__ __volatile__("");
   if (wot == 729) return fn(info);
   __asm__ __volatile__("");
   if (wot == 730) return fn(info);
   __asm__ __volatile__("");
   if (wot == 731) return fn(info);
   __asm__ __volatile__("");
   if (wot == 732) return fn(info);
   __asm__ __volatile__("");
   if (wot == 733) return fn(info);
   __asm__ __volatile__("");
   if (wot == 734) return fn(info);
   __asm__ __volatile__("");
   if (wot == 735) return fn(info);
   __asm__ __volatile__("");
   if (wot == 736) return fn(info);
   __asm__ __volatile__("");
   if (wot == 737) return fn(info);
   __asm__ __volatile__("");
   if (wot == 738) return fn(info);
   __asm__ __volatile__("");
   if (wot == 739) return fn(info);
   __asm__ __volatile__("");
   if (wot == 740) return fn(info);
   __asm__ __volatile__("");
   if (wot == 741) return fn(info);
   __asm__ __volatile__("");
   if (wot == 742) return fn(info);
   __asm__ __volatile__("");
   if (wot == 743) return fn(info);
   __asm__ __volatile__("");
   if (wot == 744) return fn(info);
   __asm__ __volatile__("");
   if (wot == 745) return fn(info);
   __asm__ __volatile__("");
   if (wot == 746) return fn(info);
   __asm__ __volatile__("");
   if (wot == 747) return fn(info);
   __asm__ __volatile__("");
   if (wot == 748) return fn(info);
   __asm__ __volatile__("");
   if (wot == 749) return fn(info);
   __asm__ __volatile__("");
   if (wot == 750) return fn(info);
   __asm__ __volatile__("");
   if (wot == 751) return fn(info);
   __asm__ __volatile__("");
   if (wot == 752) return fn(info);
   __asm__ __volatile__("");
   if (wot == 753) return fn(info);
   __asm__ __volatile__("");
   if (wot == 754) return fn(info);
   __asm__ __volatile__("");
   if (wot == 755) return fn(info);
   __asm__ __volatile__("");
   if (wot == 756) return fn(info);
   __asm__ __volatile__("");
   if (wot == 757) return fn(info);
   __asm__ __volatile__("");
   if (wot == 758) return fn(info);
   __asm__ __volatile__("");
   if (wot == 759) return fn(info);
   __asm__ __volatile__("");
   if (wot == 760) return fn(info);
   __asm__ __volatile__("");
   if (wot == 761) return fn(info);
   __asm__ __volatile__("");
   if (wot == 762) return fn(info);
   __asm__ __volatile__("");
   if (wot == 763) return fn(info);
   __asm__ __volatile__("");
   if (wot == 764) return fn(info);
   __asm__ __volatile__("");
   if (wot == 765) return fn(info);
   __asm__ __volatile__("");
   if (wot == 766) return fn(info);
   __asm__ __volatile__("");
   if (wot == 767) return fn(info);
   __asm__ __volatile__("");
   if (wot == 768) return fn(info);
   __asm__ __volatile__("");
   if (wot == 769) return fn(info);
   __asm__ __volatile__("");
   if (wot == 770) return fn(info);
   __asm__ __volatile__("");
   if (wot == 771) return fn(info);
   __asm__ __volatile__("");
   if (wot == 772) return fn(info);
   __asm__ __volatile__("");
   if (wot == 773) return fn(info);
   __asm__ __volatile__("");
   if (wot == 774) return fn(info);
   __asm__ __volatile__("");
   if (wot == 775) return fn(info);
   __asm__ __volatile__("");
   if (wot == 776) return fn(info);
   __asm__ __volatile__("");
   if (wot == 777) return fn(info);
   __asm__ __volatile__("");
   if (wot == 778) return fn(info);
   __asm__ __volatile__("");
   if (wot == 779) return fn(info);
   __asm__ __volatile__("");
   if (wot == 780) return fn(info);
   __asm__ __volatile__("");
   if (wot == 781) return fn(info);
   __asm__ __volatile__("");
   if (wot == 782) return fn(info);
   __asm__ __volatile__("");
   if (wot == 783) return fn(info);
   __asm__ __volatile__("");
   if (wot == 784) return fn(info);
   __asm__ __volatile__("");
   if (wot == 785) return fn(info);
   __asm__ __volatile__("");
   if (wot == 786) return fn(info);
   __asm__ __volatile__("");
   if (wot == 787) return fn(info);
   __asm__ __volatile__("");
   if (wot == 788) return fn(info);
   __asm__ __volatile__("");
   if (wot == 789) return fn(info);
   __asm__ __volatile__("");
   if (wot == 790) return fn(info);
   __asm__ __volatile__("");
   if (wot == 791) return fn(info);
   __asm__ __volatile__("");
   if (wot == 792) return fn(info);
   __asm__ __volatile__("");
   if (wot == 793) return fn(info);
   __asm__ __volatile__("");
   if (wot == 794) return fn(info);
   __asm__ __volatile__("");
   if (wot == 795) return fn(info);
   __asm__ __volatile__("");
   if (wot == 796) return fn(info);
   __asm__ __volatile__("");
   if (wot == 797) return fn(info);
   __asm__ __volatile__("");
   if (wot == 798) return fn(info);
   __asm__ __volatile__("");
   if (wot == 799) return fn(info);
   __asm__ __volatile__("");
   if (wot == 800) return fn(info);
   __asm__ __volatile__("");
   if (wot == 801) return fn(info);
   __asm__ __volatile__("");
   if (wot == 802) return fn(info);
   __asm__ __volatile__("");
   if (wot == 803) return fn(info);
   __asm__ __volatile__("");
   if (wot == 804) return fn(info);
   __asm__ __volatile__("");
   if (wot == 805) return fn(info);
   __asm__ __volatile__("");
   if (wot == 806) return fn(info);
   __asm__ __volatile__("");
   if (wot == 807) return fn(info);
   __asm__ __volatile__("");
   if (wot == 808) return fn(info);
   __asm__ __volatile__("");
   if (wot == 809) return fn(info);
   __asm__ __volatile__("");
   if (wot == 810) return fn(info);
   __asm__ __volatile__("");
   if (wot == 811) return fn(info);
   __asm__ __volatile__("");
   if (wot == 812) return fn(info);
   __asm__ __volatile__("");
   if (wot == 813) return fn(info);
   __asm__ __volatile__("");
   if (wot == 814) return fn(info);
   __asm__ __volatile__("");
   if (wot == 815) return fn(info);
   __asm__ __volatile__("");
   if (wot == 816) return fn(info);
   __asm__ __volatile__("");
   if (wot == 817) return fn(info);
   __asm__ __volatile__("");
   if (wot == 818) return fn(info);
   __asm__ __volatile__("");
   if (wot == 819) return fn(info);
   __asm__ __volatile__("");
   if (wot == 820) return fn(info);
   __asm__ __volatile__("");
   if (wot == 821) return fn(info);
   __asm__ __volatile__("");
   if (wot == 822) return fn(info);
   __asm__ __volatile__("");
   if (wot == 823) return fn(info);
   __asm__ __volatile__("");
   if (wot == 824) return fn(info);
   __asm__ __volatile__("");
   if (wot == 825) return fn(info);
   __asm__ __volatile__("");
   if (wot == 826) return fn(info);
   __asm__ __volatile__("");
   if (wot == 827) return fn(info);
   __asm__ __volatile__("");
   if (wot == 828) return fn(info);
   __asm__ __volatile__("");
   if (wot == 829) return fn(info);
   __asm__ __volatile__("");
   if (wot == 830) return fn(info);
   __asm__ __volatile__("");
   if (wot == 831) return fn(info);
   __asm__ __volatile__("");
   if (wot == 832) return fn(info);
   __asm__ __volatile__("");
   if (wot == 833) return fn(info);
   __asm__ __volatile__("");
   if (wot == 834) return fn(info);
   __asm__ __volatile__("");
   if (wot == 835) return fn(info);
   __asm__ __volatile__("");
   if (wot == 836) return fn(info);
   __asm__ __volatile__("");
   if (wot == 837) return fn(info);
   __asm__ __volatile__("");
   if (wot == 838) return fn(info);
   __asm__ __volatile__("");
   if (wot == 839) return fn(info);
   __asm__ __volatile__("");
   if (wot == 840) return fn(info);
   __asm__ __volatile__("");
   if (wot == 841) return fn(info);
   __asm__ __volatile__("");
   if (wot == 842) return fn(info);
   __asm__ __volatile__("");
   if (wot == 843) return fn(info);
   __asm__ __volatile__("");
   if (wot == 844) return fn(info);
   __asm__ __volatile__("");
   if (wot == 845) return fn(info);
   __asm__ __volatile__("");
   if (wot == 846) return fn(info);
   __asm__ __volatile__("");
   if (wot == 847) return fn(info);
   __asm__ __volatile__("");
   if (wot == 848) return fn(info);
   __asm__ __volatile__("");
   if (wot == 849) return fn(info);
   __asm__ __volatile__("");
   if (wot == 850) return fn(info);
   __asm__ __volatile__("");
   if (wot == 851) return fn(info);
   __asm__ __volatile__("");
   if (wot == 852) return fn(info);
   __asm__ __volatile__("");
   if (wot == 853) return fn(info);
   __asm__ __volatile__("");
   if (wot == 854) return fn(info);
   __asm__ __volatile__("");
   if (wot == 855) return fn(info);
   __asm__ __volatile__("");
   if (wot == 856) return fn(info);
   __asm__ __volatile__("");
   if (wot == 857) return fn(info);
   __asm__ __volatile__("");
   if (wot == 858) return fn(info);
   __asm__ __volatile__("");
   if (wot == 859) return fn(info);
   __asm__ __volatile__("");
   if (wot == 860) return fn(info);
   __asm__ __volatile__("");
   if (wot == 861) return fn(info);
   __asm__ __volatile__("");
   if (wot == 862) return fn(info);
   __asm__ __volatile__("");
   if (wot == 863) return fn(info);
   __asm__ __volatile__("");
   if (wot == 864) return fn(info);
   __asm__ __volatile__("");
   if (wot == 865) return fn(info);
   __asm__ __volatile__("");
   if (wot == 866) return fn(info);
   __asm__ __volatile__("");
   if (wot == 867) return fn(info);
   __asm__ __volatile__("");
   if (wot == 868) return fn(info);
   __asm__ __volatile__("");
   if (wot == 869) return fn(info);
   __asm__ __volatile__("");
   if (wot == 870) return fn(info);
   __asm__ __volatile__("");
   if (wot == 871) return fn(info);
   __asm__ __volatile__("");
   if (wot == 872) return fn(info);
   __asm__ __volatile__("");
   if (wot == 873) return fn(info);
   __asm__ __volatile__("");
   if (wot == 874) return fn(info);
   __asm__ __volatile__("");
   if (wot == 875) return fn(info);
   __asm__ __volatile__("");
   if (wot == 876) return fn(info);
   __asm__ __volatile__("");
   if (wot == 877) return fn(info);
   __asm__ __volatile__("");
   if (wot == 878) return fn(info);
   __asm__ __volatile__("");
   if (wot == 879) return fn(info);
   __asm__ __volatile__("");
   if (wot == 880) return fn(info);
   __asm__ __volatile__("");
   if (wot == 881) return fn(info);
   __asm__ __volatile__("");
   if (wot == 882) return fn(info);
   __asm__ __volatile__("");
   if (wot == 883) return fn(info);
   __asm__ __volatile__("");
   if (wot == 884) return fn(info);
   __asm__ __volatile__("");
   if (wot == 885) return fn(info);
   __asm__ __volatile__("");
   if (wot == 886) return fn(info);
   __asm__ __volatile__("");
   if (wot == 887) return fn(info);
   __asm__ __volatile__("");
   if (wot == 888) return fn(info);
   __asm__ __volatile__("");
   if (wot == 889) return fn(info);
   __asm__ __volatile__("");
   if (wot == 890) return fn(info);
   __asm__ __volatile__("");
   if (wot == 891) return fn(info);
   __asm__ __volatile__("");
   if (wot == 892) return fn(info);
   __asm__ __volatile__("");
   if (wot == 893) return fn(info);
   __asm__ __volatile__("");
   if (wot == 894) return fn(info);
   __asm__ __volatile__("");
   if (wot == 895) return fn(info);
   __asm__ __volatile__("");
   if (wot == 896) return fn(info);
   __asm__ __volatile__("");
   if (wot == 897) return fn(info);
   __asm__ __volatile__("");
   if (wot == 898) return fn(info);
   __asm__ __volatile__("");
   if (wot == 899) return fn(info);
   __asm__ __volatile__("");
   if (wot == 900) return fn(info);
   __asm__ __volatile__("");
   if (wot == 901) return fn(info);
   __asm__ __volatile__("");
   if (wot == 902) return fn(info);
   __asm__ __volatile__("");
   if (wot == 903) return fn(info);
   __asm__ __volatile__("");
   if (wot == 904) return fn(info);
   __asm__ __volatile__("");
   if (wot == 905) return fn(info);
   __asm__ __volatile__("");
   if (wot == 906) return fn(info);
   __asm__ __volatile__("");
   if (wot == 907) return fn(info);
   __asm__ __volatile__("");
   if (wot == 908) return fn(info);
   __asm__ __volatile__("");
   if (wot == 909) return fn(info);
   __asm__ __volatile__("");
   if (wot == 910) return fn(info);
   __asm__ __volatile__("");
   if (wot == 911) return fn(info);
   __asm__ __volatile__("");
   if (wot == 912) return fn(info);
   __asm__ __volatile__("");
   if (wot == 913) return fn(info);
   __asm__ __volatile__("");
   if (wot == 914) return fn(info);
   __asm__ __volatile__("");
   if (wot == 915) return fn(info);
   __asm__ __volatile__("");
   if (wot == 916) return fn(info);
   __asm__ __volatile__("");
   if (wot == 917) return fn(info);
   __asm__ __volatile__("");
   if (wot == 918) return fn(info);
   __asm__ __volatile__("");
   if (wot == 919) return fn(info);
   __asm__ __volatile__("");
   if (wot == 920) return fn(info);
   __asm__ __volatile__("");
   if (wot == 921) return fn(info);
   __asm__ __volatile__("");
   if (wot == 922) return fn(info);
   __asm__ __volatile__("");
   if (wot == 923) return fn(info);
   __asm__ __volatile__("");
   if (wot == 924) return fn(info);
   __asm__ __volatile__("");
   if (wot == 925) return fn(info);
   __asm__ __volatile__("");
   if (wot == 926) return fn(info);
   __asm__ __volatile__("");
   if (wot == 927) return fn(info);
   __asm__ __volatile__("");
   if (wot == 928) return fn(info);
   __asm__ __volatile__("");
   if (wot == 929) return fn(info);
   __asm__ __volatile__("");
   if (wot == 930) return fn(info);
   __asm__ __volatile__("");
   if (wot == 931) return fn(info);
   __asm__ __volatile__("");
   if (wot == 932) return fn(info);
   __asm__ __volatile__("");
   if (wot == 933) return fn(info);
   __asm__ __volatile__("");
   if (wot == 934) return fn(info);
   __asm__ __volatile__("");
   if (wot == 935) return fn(info);
   __asm__ __volatile__("");
   if (wot == 936) return fn(info);
   __asm__ __volatile__("");
   if (wot == 937) return fn(info);
   __asm__ __volatile__("");
   if (wot == 938) return fn(info);
   __asm__ __volatile__("");
   if (wot == 939) return fn(info);
   __asm__ __volatile__("");
   if (wot == 940) return fn(info);
   __asm__ __volatile__("");
   if (wot == 941) return fn(info);
   __asm__ __volatile__("");
   if (wot == 942) return fn(info);
   __asm__ __volatile__("");
   if (wot == 943) return fn(info);
   __asm__ __volatile__("");
   if (wot == 944) return fn(info);
   __asm__ __volatile__("");
   if (wot == 945) return fn(info);
   __asm__ __volatile__("");
   if (wot == 946) return fn(info);
   __asm__ __volatile__("");
   if (wot == 947) return fn(info);
   __asm__ __volatile__("");
   if (wot == 948) return fn(info);
   __asm__ __volatile__("");
   if (wot == 949) return fn(info);
   __asm__ __volatile__("");
   if (wot == 950) return fn(info);
   __asm__ __volatile__("");
   if (wot == 951) return fn(info);
   __asm__ __volatile__("");
   if (wot == 952) return fn(info);
   __asm__ __volatile__("");
   if (wot == 953) return fn(info);
   __asm__ __volatile__("");
   if (wot == 954) return fn(info);
   __asm__ __volatile__("");
   if (wot == 955) return fn(info);
   __asm__ __volatile__("");
   if (wot == 956) return fn(info);
   __asm__ __volatile__("");
   if (wot == 957) return fn(info);
   __asm__ __volatile__("");
   if (wot == 958) return fn(info);
   __asm__ __volatile__("");
   if (wot == 959) return fn(info);
   __asm__ __volatile__("");
   if (wot == 960) return fn(info);
   __asm__ __volatile__("");
   if (wot == 961) return fn(info);
   __asm__ __volatile__("");
   if (wot == 962) return fn(info);
   __asm__ __volatile__("");
   if (wot == 963) return fn(info);
   __asm__ __volatile__("");
   if (wot == 964) return fn(info);
   __asm__ __volatile__("");
   if (wot == 965) return fn(info);
   __asm__ __volatile__("");
   if (wot == 966) return fn(info);
   __asm__ __volatile__("");
   if (wot == 967) return fn(info);
   __asm__ __volatile__("");
   if (wot == 968) return fn(info);
   __asm__ __volatile__("");
   if (wot == 969) return fn(info);
   __asm__ __volatile__("");
   if (wot == 970) return fn(info);
   __asm__ __volatile__("");
   if (wot == 971) return fn(info);
   __asm__ __volatile__("");
   if (wot == 972) return fn(info);
   __asm__ __volatile__("");
   if (wot == 973) return fn(info);
   __asm__ __volatile__("");
   if (wot == 974) return fn(info);
   __asm__ __volatile__("");
   if (wot == 975) return fn(info);
   __asm__ __volatile__("");
   if (wot == 976) return fn(info);
   __asm__ __volatile__("");
   if (wot == 977) return fn(info);
   __asm__ __volatile__("");
   if (wot == 978) return fn(info);
   __asm__ __volatile__("");
   if (wot == 979) return fn(info);
   __asm__ __volatile__("");
   if (wot == 980) return fn(info);
   __asm__ __volatile__("");
   if (wot == 981) return fn(info);
   __asm__ __volatile__("");
   if (wot == 982) return fn(info);
   __asm__ __volatile__("");
   if (wot == 983) return fn(info);
   __asm__ __volatile__("");
   if (wot == 984) return fn(info);
   __asm__ __volatile__("");
   if (wot == 985) return fn(info);
   __asm__ __volatile__("");
   if (wot == 986) return fn(info);
   __asm__ __volatile__("");
   if (wot == 987) return fn(info);
   __asm__ __volatile__("");
   if (wot == 988) return fn(info);
   __asm__ __volatile__("");
   if (wot == 989) return fn(info);
   __asm__ __volatile__("");
   if (wot == 990) return fn(info);
   __asm__ __volatile__("");
   if (wot == 991) return fn(info);
   __asm__ __volatile__("");
   if (wot == 992) return fn(info);
   __asm__ __volatile__("");
   if (wot == 993) return fn(info);
   __asm__ __volatile__("");
   if (wot == 994) return fn(info);
   __asm__ __volatile__("");
   if (wot == 995) return fn(info);
   __asm__ __volatile__("");
   if (wot == 996) return fn(info);
   __asm__ __volatile__("");
   if (wot == 997) return fn(info);
   __asm__ __volatile__("");
   if (wot == 998) return fn(info);
   __asm__ __volatile__("");
   if (wot == 999) return fn(info);
   __asm__ __volatile__("");
   assert(0);
   return 0; /* keep gcc happy on AIX */
}
