/*
  Copyright (C) 2004 Paul Mackerras <paulus@samba.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
  02111-1307, USA.

  The GNU General Public License is contained in the file COPYING.
*/
#include "vki_unistd.h"
#include "core_asm.h"

	.globl	VG_(do_syscall)
VG_(do_syscall):
	mr	0,3
	mr	3,4
	mr	4,5
	mr	5,6
	mr	6,7
	mr	7,8
	mr	8,9
	sc
	bnslr
	neg	3,3
	blr

/* int VG_(clone)(fn, child_stack, flags, arg, child_tid, parent_tid)	*/
/*		  r3, r4,	   r5,    r6,  r7,	  r8		*/

	.globl	VG_(clone)
VG_(clone):
	stwu	1,-32(1)
	stw	29,20(1)
	stw	30,24(1)
	stw	31,28(1)
	mr	30,3		/* function */
	mr	31,6		/* argument */
	mr	3,5		/* flags */
	rlwinm	4,4,0,~0xf	/* trim sp to multiple of 16 bytes */
	li	0,0
	stwu	0,-16(4)	/* make initial stack frame */
	mr	29,4
	mr	5,8		/* parent_tid */
	mr	6,2		/* child_threadptr */
	li	0,__NR_clone	/* child_tid already in r7 */
	sc
	bso	1f		/* if error */
	cmpwi	3,0
	beq	2f		/* if child */
9:	lwz	29,20(1)	/* parent - return */
	lwz	30,24(1)
	lwz	31,28(1)
	addi	1,1,32
	blr

	/* here we are the child */
	/* Note: 2.4 doesn't set the child stack pointer, so we do it here.
	   That does leave a small window for a signal to be delivered
	   on the wrong stack, unfortunately. */
2:	mr	1,29
	mtctr	30		/* function */
	mr	3,31		/* argument */
	bctrl			/* call it */
	li	0,__NR_exit	/* exit with result */
	sc
	.long	0		/* exit returned?? */

1:	neg	3,3		/* return -errno on error */
	b	9b

/*
	Perform a syscall for the client.  This will run a syscall
	with the client's specific per-thread signal mask.
	
	The structure of this function is such that, if the syscall is
	interrupted by a signal, we can determine exactly what
	execution state we were in with respect to the execution of
	the syscall by examining the value of NIP in the signal
	handler.  This means that we can always do the appropriate
	thing to precisely emulate the kernel's signal/syscall
	interactions.

	The syscall number is taken from the argument, even though it
	should also be in regs->m_gpr[0].  The syscall result is written
	back to regs->m_gpr[3]/m_xer/m_result on completion.
	
	Returns 0 if the syscall was successfully called (even if the
	syscall itself failed), or a -ve error code if one of the
	sigprocmasks failed (there's no way to determine which one
	failed).

	VGA_(interrupted_syscall)() does the thread state fixup in the
	case where we were interrupted by a signal.
	
	Prototype:

	Int VGA_(_client_syscall)(Int syscallno,		// r3
				  const vki_sigset_t *sysmask,	// r4
				        vki_sigset_t *postmask,	// r5
				  Int nsigwords,		// r6
				  ThreadState *tst)		// r7
				   
*/

/* from vki_arch.h */	
#define VKI_SIG_SETMASK	2
	
.globl VGA_(_client_syscall)
VGA_(_client_syscall):
	/* make a stack frame */
	stwu	1,-32(1)
	stw	31,28(1)
	stw	30,24(1)
	stw	29,20(1)
	stw	28,16(1)
	mr	31,3		/* syscall number */
	mr	30,7		/* thread state */
	mr	29,5		/* postmask */
	mr	28,6		/* nsigwords */

	/* set the signal mask for doing the system call */
1:	li	0,__NR_rt_sigprocmask
	li	3,VKI_SIG_SETMASK
	sc			/* set the mask */
	bso	7f		/* if the sigprocmask fails */

	/* load up syscall args from the threadstate */
	lwz	3,VGOFF_gpr+12(30)
	lwz	4,VGOFF_gpr+16(30)
	lwz	5,VGOFF_gpr+20(30)
	lwz	6,VGOFF_gpr+24(30)
	lwz	7,VGOFF_gpr+28(30)
	lwz	8,VGOFF_gpr+32(30)
	mr	0,31		/* syscall number */
2:	sc			/* do the syscall */

	/* put the result back in the threadstate */
3:	lwz	4,VGOFF_cr(30)
	rlwinm	4,4,0,4,2	/* clear SO bit */
	mr	5,3
	stw	3,VGOFF_gpr+12(30)
	bns+	6f		/* if no error */
	oris	4,4,0x1000	/* set SO bit if error */
	neg	5,5		/* negate error code */
6:	stw	4,VGOFF_cr(30)
	stw	5,VGOFF_result(30)

	/* block signals again */
4:	li	0,__NR_rt_sigprocmask
	li	3,VKI_SIG_SETMASK
	mr	4,29
	li	5,0
	mr	6,28
	sc
	bso	7f

	/* pop off stack frame */
5:	lwz	28,16(1)
	lwz	29,20(1)
	lwz	30,24(1)
	lwz	31,28(1)
	addi	1,1,32
	blr

7:	/* return -ve error code */
	neg	3,3
	b	5b

	.section .rodata

.globl VGA_(blksys_setup)
.globl VGA_(blksys_restart)
.globl VGA_(blksys_complete)
.globl VGA_(blksys_committed)
.globl VGA_(blksys_finished)
VGA_(blksys_setup):	.long 1b
VGA_(blksys_restart):	.long 2b
VGA_(blksys_complete):	.long 3b
VGA_(blksys_committed):	.long 4b
VGA_(blksys_finished):	.long 5b

	.previous
	
/* Let the linker know we don't need an executable stack */
	.section .note.GNU-stack,"",@progbits
