//    This is part of the iostream library, providing input/output for C++.
//    Copyright (C) 1991 Per Bothner.
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "ioprivate.h"

#include "ioconfig.h"
#define NAMES_HAVE_UNDERSCORE
#ifdef NAMES_HAVE_UNDERSCORE
#define UNDERSCORE "_"
#else
#define UNDERSCORE ""
#endif
#if 0 /*defined(__GNUC__)*/
// This hack was intended to trick gdb into thinking cin is really a
// istream (and not a _fake_istream), but doesn't seem to work.
#define STR_NAME(TYPE, NAME) TYPE __##NAME asm(UNDERSCORE #NAME)
#else
#define STR_NAME(TYPE, NAME) TYPE NAME
#define cin CIN
#define cout COUT
#define cerr CERR
#define clog CLOG
#endif
#include "iostream.h"
#undef cin
#undef cout
#undef cerr
#undef clog

#ifdef __GNUG__
#pragma implementation
#endif

int streambuf::sputn(const char* s, int n) // OPTIMIZE THIS!
{
    int count = 0;
    for (; count < n; count++) {
	if (sputc(*s++) == EOF)
	    break;
    }
    return count;
}

int streambuf::sgetn(char* s, int n) // OPTIMIZE THIS!
{
    int count = 0;
    for (; count < n; count++) {
	int ch = sbumpc();
	if (ch == EOF)
	    break;
	*s++ = ch;
    }
    return count;
}

int streambuf::sync()
{
    if (gptr() == egptr() && pptr() == pbase())
	return 0;
    return EOF;
}

int streambuf::pbackfail(int c)
{
    return EOF;
}

streambuf* streambuf::setbuf(char* p, int len)
{
    setb(p, p+len, 0);
    setp(0, 0);
    setg(0, 0, 0);
    return this;
}

// I'm unclear what seekpos is supposed to accomplish.
streampos streambuf::seekpos(streampos pos, int mode = ios::in|ios::out)
{
    return seekoff(pos, ios::beg, mode);
}

void streambuf::setb(char* b, char* eb, int a)
{
    if (_base && (_flags & _S_USER_BUF))
	free(_base);
    _base = b;
    _ebuf = eb;
    if (a)
	_flags &= ~_S_USER_BUF;
    else
	_flags |= _S_USER_BUF;
}

int streambuf::doallocate()
{
    char *buf = malloc(BUFSIZ);
    if (buf == NULL)
	return EOF;
    setb(buf, buf+BUFSIZ, 1);
    return 1;
}

streambuf::streambuf()
{
  _flags = _IO_MAGIC;
  _base = NULL;
  _ebuf = NULL;
  _eback = NULL;
  _gptr = NULL;
  _egptr = NULL;
  _pbase = NULL;
  _pptr = NULL;
  _epptr = NULL;
  _chain = NULL; // Not necessary.
}

streambuf::~streambuf()
{
    if (_base && !(_flags & _S_USER_BUF))
	free(_base);
}

int streambuf::underflow()
{
    return EOF;
}

int streambuf::overflow(int c = EOF)
{
    return EOF;
}

streamoff streambuf::seekoff(streamoff, seek_dir, int mode=ios::in|ios::out)
{
    return EOF;
}

int streambuf::sputbackc(char c)
{
    if (gptr() <= eback()) return pbackfail(c);
    gbump(-1);
    if (*gptr() != c)
	*gptr() = c;
    return (unsigned char)c;
}

extern char vt_filebuf[1] asm(FILEBUF_VT_NAME);

struct _fake_filebuf {
    struct __streambuf s;
    char* vtable;
    struct __file_fields f;
};

#define DEF_STD(NAME, FD, CHAIN, FLAGS) \
    _fake_filebuf NAME[1] = {{\
       { _IO_MAGIC+_S_IS_FILEBUF+FLAGS, 0, 0, 0, 0, 0, 0, 0, 0, CHAIN},\
       vt_filebuf, {0, 0, FD}}};

DEF_STD(_cin_sbuf, 0, 0, _S_CAN_READ);
DEF_STD(_cout_sbuf, 1, (streambuf*)_cin_sbuf, _S_CAN_WRITE);
DEF_STD(_cerr_sbuf, 2, (streambuf*)_cout_sbuf, _S_CAN_WRITE);

DEF_STD(not_open_filebuf, -1, (streambuf*)0, 0);

streambuf* __stream_list = (streambuf*)_cerr_sbuf;

static void flush_all()
{
    streambuf *stream;
    for (stream = __stream_list; stream != NULL; stream = stream->_chain)
	stream->overflow(EOF);
}

struct __io_defs {
    __io_defs() { }
    ~__io_defs() { flush_all(); }
};   
__io_defs io_defs__;


// Kludge to statically initialize the standard streams.

class ios_prefix {
    // Same fields as ios.
    streambuf *_strbuf;
    ostream* _tie;
    long _width;
    unsigned long _flags;
    char _fill;
    unsigned char _state;
    unsigned short _precision;
};

class _fake_istream {
    ios_prefix base;
    char filler[sizeof(struct istream)-sizeof(struct ios_prefix)];
};
class _fake_ostream {
    ios_prefix base;
    char filler[sizeof(struct ostream)-sizeof(struct ios_prefix)];
};

#define STD_STR(SBUF, TIE, EXTRA_FLAGS) \
 (streambuf*)SBUF, TIE, 0, ios::dont_close|ios::skipws|EXTRA_FLAGS, ' ', 0, 6

STR_NAME(_fake_ostream, cout)  = { STD_STR(_cout_sbuf, NULL, 0) };
STR_NAME(_fake_ostream, cerr) =
  { STD_STR(_cerr_sbuf, (ostream*)&cout, ios::unitbuf) };
STR_NAME(_fake_istream, cin)  = { STD_STR(_cin_sbuf,  (ostream*)&cout, 0) };

/* Only for (partial) compatibility with AT&T's library. */
STR_NAME(_fake_ostream, clog) = { STD_STR(_cerr_sbuf, (ostream*)&cout, 0) };
