//==========================================================================
//
//      plf_misc.c
//
//      HAL platform miscellaneous functions
//
//==========================================================================
//####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 1998, 1999, 2000, 2001, 2002 Red Hat, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License along
// with eCos; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
//
// As a special exception, if other files instantiate templates or use macros
// or inline functions from this file, or you compile this file and link it
// with other works to produce a work based on this file, this file does not
// by itself cause the resulting work to be covered by the GNU General Public
// License. However the source code for this file must still be made available
// in accordance with section (3) of the GNU General Public License.
//
// This exception does not invalidate any other reasons why a work based on
// this file might be covered by the GNU General Public License.
//
// Alternative licenses for eCos may be arranged by contacting Red Hat, Inc.
// at http://sources.redhat.com/ecos/ecos-license/
// -------------------------------------------
//####ECOSGPLCOPYRIGHTEND####
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    jskov
// Contributors: jskov
// Date:         2001-06-12
// Purpose:      HAL miscellaneous functions
// Description:  This file contains miscellaneous functions provided by the
//               HAL.
//
//####DESCRIPTIONEND####
//
//==========================================================================

#include <pkgconf/hal.h>

#include <cyg/hal/hal_if.h>             // interfacing API
#include <cyg/hal/plf_io.h>
#include <cyg/hal/hal_io.h>

//--------------------------------------------------------------------------
externC void cyg_hal_init_superIO(void);
externC void cyg_hal_sh_pcic_pci_init(void);

void
hal_platform_init(void)
{
    // Clear interrupt controller masks.
    HAL_WRITE_UINT16(CYGARC_REG_INTC_A, 0x0000);
    HAL_WRITE_UINT16(CYGARC_REG_INTC_B, 0x0000);
    HAL_WRITE_UINT16(CYGARC_REG_INTC_C, 0x0000);
    HAL_WRITE_UINT16(CYGARC_REG_INTC_D, 0x0000);
    HAL_WRITE_UINT16(CYGARC_REG_INTC_E, 0x0000);

    cyg_hal_sh_pcic_pci_init();

    cyg_hal_init_superIO();

    hal_if_init();
}

//--------------------------------------------------------------------------
// eof plf_misc.c
