/* monitor.c generated by valac 0.26.1, the Vala compiler
 * generated from monitor.vala, do not modify */

/*
 * Copyright © 2012 Canonical Ltd.
 *             By Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 * Based upon a C implementation (© 2010 Canonical Ltd) by:
 *  Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include "zeitgeist-datamodel.h"
#include <stdlib.h>
#include <string.h>


#define ZEITGEIST_TYPE_REMOTE_MONITOR (zeitgeist_remote_monitor_get_type ())
#define ZEITGEIST_REMOTE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_REMOTE_MONITOR, ZeitgeistRemoteMonitor))
#define ZEITGEIST_IS_REMOTE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_REMOTE_MONITOR))
#define ZEITGEIST_REMOTE_MONITOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZEITGEIST_TYPE_REMOTE_MONITOR, ZeitgeistRemoteMonitorIface))

typedef struct _ZeitgeistRemoteMonitor ZeitgeistRemoteMonitor;
typedef struct _ZeitgeistRemoteMonitorIface ZeitgeistRemoteMonitorIface;

#define ZEITGEIST_TYPE_REMOTE_MONITOR_PROXY (zeitgeist_remote_monitor_proxy_get_type ())

#define ZEITGEIST_TYPE_MONITOR (zeitgeist_monitor_get_type ())
#define ZEITGEIST_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_MONITOR, ZeitgeistMonitor))
#define ZEITGEIST_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_MONITOR, ZeitgeistMonitorClass))
#define ZEITGEIST_IS_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_MONITOR))
#define ZEITGEIST_IS_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_MONITOR))
#define ZEITGEIST_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_MONITOR, ZeitgeistMonitorClass))

typedef struct _ZeitgeistMonitor ZeitgeistMonitor;
typedef struct _ZeitgeistMonitorClass ZeitgeistMonitorClass;
typedef struct _ZeitgeistMonitorPrivate ZeitgeistMonitorPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ZeitgeistMonitorNotifyInsertData ZeitgeistMonitorNotifyInsertData;
typedef struct _ZeitgeistMonitorNotifyDeleteData ZeitgeistMonitorNotifyDeleteData;

struct _ZeitgeistRemoteMonitorIface {
	GTypeInterface parent_iface;
	void (*notify_insert) (ZeitgeistRemoteMonitor* self, GVariant* time_range, GVariant* events, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*notify_insert_finish) (ZeitgeistRemoteMonitor* self, GAsyncResult* _res_, GError** error);
	void (*notify_delete) (ZeitgeistRemoteMonitor* self, GVariant* time_range, guint32* event_ids, int event_ids_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*notify_delete_finish) (ZeitgeistRemoteMonitor* self, GAsyncResult* _res_, GError** error);
};

struct _ZeitgeistMonitor {
	GObject parent_instance;
	ZeitgeistMonitorPrivate * priv;
};

struct _ZeitgeistMonitorClass {
	GObjectClass parent_class;
};

struct _ZeitgeistMonitorPrivate {
	ZeitgeistTimeRange* _time_range;
	GPtrArray* _event_templates;
	char* monitor_path;
};

struct _ZeitgeistMonitorNotifyInsertData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ZeitgeistMonitor* self;
	GVariant* time_range;
	GVariant* events;
	GPtrArray* _tmp0_;
	GVariant* _tmp1_;
	GPtrArray* _tmp2_;
	ZeitgeistSimpleResultSet* result_set;
	ZeitgeistSimpleResultSet* _tmp3_;
	ZeitgeistTimeRange* _tmp4_;
	GVariant* _tmp5_;
	ZeitgeistTimeRange* _tmp6_;
	ZeitgeistSimpleResultSet* _tmp7_;
	GError* err;
	GError* _tmp8_;
	const gchar* _tmp9_;
	GError * _inner_error_;
};

struct _ZeitgeistMonitorNotifyDeleteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ZeitgeistMonitor* self;
	GVariant* time_range;
	guint32* event_ids;
	gint event_ids_length1;
	ZeitgeistTimeRange* _tmp0_;
	GVariant* _tmp1_;
	ZeitgeistTimeRange* _tmp2_;
	guint32* _tmp3_;
	gint _tmp3__length1;
	GError* err;
	GError* _tmp4_;
	const gchar* _tmp5_;
	GError * _inner_error_;
};


static gpointer zeitgeist_monitor_parent_class = NULL;
static gint zeitgeist_monitor_monitor_counter;
static gint zeitgeist_monitor_monitor_counter = 0;
static ZeitgeistRemoteMonitorIface* zeitgeist_monitor_zeitgeist_remote_monitor_parent_iface = NULL;

GType zeitgeist_remote_monitor_proxy_get_type (void) G_GNUC_CONST;
guint zeitgeist_remote_monitor_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType zeitgeist_remote_monitor_get_type (void) G_GNUC_CONST;
GType zeitgeist_monitor_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_MONITOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_MONITOR, ZeitgeistMonitorPrivate))
enum  {
	ZEITGEIST_MONITOR_DUMMY_PROPERTY,
	ZEITGEIST_MONITOR_TIME_RANGE,
	ZEITGEIST_MONITOR_EVENT_TEMPLATES
};
ZeitgeistMonitor* zeitgeist_monitor_new (ZeitgeistTimeRange* time_range, GPtrArray* event_templates);
ZeitgeistMonitor* zeitgeist_monitor_construct (GType object_type, ZeitgeistTimeRange* time_range, GPtrArray* event_templates);
void zeitgeist_monitor_set_time_range (ZeitgeistMonitor* self, ZeitgeistTimeRange* value);
void zeitgeist_monitor_set_event_templates (ZeitgeistMonitor* self, GPtrArray* value);
GPtrArray* zeitgeist_monitor_get_templates (ZeitgeistMonitor* self);
GPtrArray* zeitgeist_monitor_get_event_templates (ZeitgeistMonitor* self);
char* zeitgeist_monitor_get_path (ZeitgeistMonitor* self);
static void zeitgeist_monitor_real_notify_insert_data_free (gpointer _data);
static void zeitgeist_monitor_real_notify_insert (ZeitgeistRemoteMonitor* base, GVariant* time_range, GVariant* events, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean zeitgeist_monitor_real_notify_insert_co (ZeitgeistMonitorNotifyInsertData* _data_);
static void zeitgeist_monitor_real_notify_delete_data_free (gpointer _data);
static void zeitgeist_monitor_real_notify_delete (ZeitgeistRemoteMonitor* base, GVariant* time_range, guint32* event_ids, int event_ids_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean zeitgeist_monitor_real_notify_delete_co (ZeitgeistMonitorNotifyDeleteData* _data_);
ZeitgeistTimeRange* zeitgeist_monitor_get_time_range (ZeitgeistMonitor* self);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_POINTER_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void zeitgeist_monitor_finalize (GObject* obj);
static void _vala_zeitgeist_monitor_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_zeitgeist_monitor_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * zeitgeist_monitor_new
     *
     * Create a new monitor. Before you can receive signals from the monitor you
     * need to install it in the running Zeitgeist daemon by calling
     * zeitgeist_log_install_monitor().
     *
     * @param time_range The monitor will only listen for events with
     *     timestamps within this time range. Note that it is legal for
     *     applications to insert events that are "in the past".
     * @param event_templates A #GPtrArray of #ZeitgeistEvent<!-- -->s.
     *     Only listen for events that match any of these templates.
     *
     * @return A reference to a newly allocated monitor
     */
ZeitgeistMonitor* zeitgeist_monitor_construct (GType object_type, ZeitgeistTimeRange* time_range, GPtrArray* event_templates) {
	ZeitgeistMonitor * self = NULL;
	ZeitgeistTimeRange* _tmp0_ = NULL;
	GPtrArray* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	char* _tmp5_ = NULL;
	g_return_val_if_fail (time_range != NULL, NULL);
	g_return_val_if_fail (event_templates != NULL, NULL);
	self = (ZeitgeistMonitor*) g_object_new (object_type, NULL);
	_tmp0_ = time_range;
	zeitgeist_monitor_set_time_range (self, _tmp0_);
	_tmp1_ = event_templates;
	zeitgeist_monitor_set_event_templates (self, _tmp1_);
	_tmp2_ = zeitgeist_monitor_monitor_counter;
	zeitgeist_monitor_monitor_counter = _tmp2_ + 1;
	_tmp3_ = g_strdup_printf ("/org/gnome/zeitgeist/monitor/%i", _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (self->priv->monitor_path);
	self->priv->monitor_path = _tmp5_;
	_g_free0 (_tmp4_);
	_g_ptr_array_unref0 (event_templates);
	return self;
}


ZeitgeistMonitor* zeitgeist_monitor_new (ZeitgeistTimeRange* time_range, GPtrArray* event_templates) {
	return zeitgeist_monitor_construct (ZEITGEIST_TYPE_MONITOR, time_range, event_templates);
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


GPtrArray* zeitgeist_monitor_get_templates (ZeitgeistMonitor* self) {
	GPtrArray* result = NULL;
	GPtrArray* _tmp0_ = NULL;
	GPtrArray* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_event_templates;
	_tmp1_ = _g_ptr_array_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


char* zeitgeist_monitor_get_path (ZeitgeistMonitor* self) {
	char* result = NULL;
	const char* _tmp0_ = NULL;
	char* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->monitor_path;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void zeitgeist_monitor_real_notify_insert_data_free (gpointer _data) {
	ZeitgeistMonitorNotifyInsertData* _data_;
	_data_ = _data;
	_g_variant_unref0 (_data_->time_range);
	_g_variant_unref0 (_data_->events);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistMonitorNotifyInsertData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static void zeitgeist_monitor_real_notify_insert (ZeitgeistRemoteMonitor* base, GVariant* time_range, GVariant* events, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistMonitor * self;
	ZeitgeistMonitorNotifyInsertData* _data_;
	ZeitgeistMonitor* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	GVariant* _tmp3_ = NULL;
	GVariant* _tmp4_ = NULL;
	self = (ZeitgeistMonitor*) base;
	_data_ = g_slice_new0 (ZeitgeistMonitorNotifyInsertData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, zeitgeist_monitor_real_notify_insert);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, zeitgeist_monitor_real_notify_insert_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = time_range;
	_tmp2_ = _g_variant_ref0 (_tmp1_);
	_g_variant_unref0 (_data_->time_range);
	_data_->time_range = _tmp2_;
	_tmp3_ = events;
	_tmp4_ = _g_variant_ref0 (_tmp3_);
	_g_variant_unref0 (_data_->events);
	_data_->events = _tmp4_;
	zeitgeist_monitor_real_notify_insert_co (_data_);
}


static void zeitgeist_monitor_real_notify_insert_finish (ZeitgeistRemoteMonitor* base, GAsyncResult* _res_, GError** error) {
	ZeitgeistMonitorNotifyInsertData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean zeitgeist_monitor_real_notify_insert_co (ZeitgeistMonitorNotifyInsertData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _data_->events;
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = zeitgeist_events_from_variant (_data_->_tmp1_, &_data_->_inner_error_);
		_data_->_tmp0_ = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			if (_data_->_inner_error_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
				goto __catch13_zeitgeist_data_model_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = zeitgeist_simple_result_set_new (_data_->_tmp0_);
		_data_->result_set = _data_->_tmp3_;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->time_range;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = zeitgeist_time_range_new_from_variant (_data_->_tmp5_, &_data_->_inner_error_);
		_data_->_tmp4_ = _data_->_tmp6_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_object_unref0 (_data_->result_set);
			_g_ptr_array_unref0 (_data_->_tmp0_);
			if (_data_->_inner_error_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
				goto __catch13_zeitgeist_data_model_error;
			}
			_g_object_unref0 (_data_->result_set);
			_g_ptr_array_unref0 (_data_->_tmp0_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->result_set;
		g_signal_emit_by_name (_data_->self, "events-inserted", _data_->_tmp4_, (ZeitgeistResultSet*) _data_->_tmp7_);
		_g_object_unref0 (_data_->_tmp4_);
		_g_object_unref0 (_data_->result_set);
		_g_ptr_array_unref0 (_data_->_tmp0_);
	}
	goto __finally13;
	__catch13_zeitgeist_data_model_error:
	{
		_data_->err = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->err;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->_tmp8_->message;
		g_warning ("monitor.vala:123: %s", _data_->_tmp9_);
		_g_error_free0 (_data_->err);
	}
	__finally13:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void zeitgeist_monitor_real_notify_delete_data_free (gpointer _data) {
	ZeitgeistMonitorNotifyDeleteData* _data_;
	_data_ = _data;
	_g_variant_unref0 (_data_->time_range);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistMonitorNotifyDeleteData, _data_);
}


static void zeitgeist_monitor_real_notify_delete (ZeitgeistRemoteMonitor* base, GVariant* time_range, guint32* event_ids, int event_ids_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ZeitgeistMonitor * self;
	ZeitgeistMonitorNotifyDeleteData* _data_;
	ZeitgeistMonitor* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	guint32* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	self = (ZeitgeistMonitor*) base;
	_data_ = g_slice_new0 (ZeitgeistMonitorNotifyDeleteData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, zeitgeist_monitor_real_notify_delete);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, zeitgeist_monitor_real_notify_delete_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = time_range;
	_tmp2_ = _g_variant_ref0 (_tmp1_);
	_g_variant_unref0 (_data_->time_range);
	_data_->time_range = _tmp2_;
	_tmp3_ = event_ids;
	_tmp3__length1 = event_ids_length1;
	_data_->event_ids = _tmp3_;
	_data_->event_ids_length1 = _tmp3__length1;
	zeitgeist_monitor_real_notify_delete_co (_data_);
}


static void zeitgeist_monitor_real_notify_delete_finish (ZeitgeistRemoteMonitor* base, GAsyncResult* _res_, GError** error) {
	ZeitgeistMonitorNotifyDeleteData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean zeitgeist_monitor_real_notify_delete_co (ZeitgeistMonitorNotifyDeleteData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _data_->time_range;
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = zeitgeist_time_range_new_from_variant (_data_->_tmp1_, &_data_->_inner_error_);
		_data_->_tmp0_ = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			if (_data_->_inner_error_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
				goto __catch14_zeitgeist_data_model_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->_tmp3_ = NULL;
		_data_->_tmp3__length1 = 0;
		_data_->_tmp3_ = _data_->event_ids;
		_data_->_tmp3__length1 = _data_->event_ids_length1;
		g_signal_emit_by_name (_data_->self, "events-deleted", _data_->_tmp0_, _data_->_tmp3_, _data_->_tmp3__length1);
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally14;
	__catch14_zeitgeist_data_model_error:
	{
		_data_->err = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->err;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->_tmp4_->message;
		g_warning ("monitor.vala:138: %s", _data_->_tmp5_);
		_g_error_free0 (_data_->err);
	}
	__finally14:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


ZeitgeistTimeRange* zeitgeist_monitor_get_time_range (ZeitgeistMonitor* self) {
	ZeitgeistTimeRange* result;
	ZeitgeistTimeRange* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_time_range;
	result = _tmp0_;
	return result;
}


void zeitgeist_monitor_set_time_range (ZeitgeistMonitor* self, ZeitgeistTimeRange* value) {
	ZeitgeistTimeRange* _tmp0_ = NULL;
	ZeitgeistTimeRange* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_time_range);
	self->priv->_time_range = _tmp1_;
	g_object_notify ((GObject *) self, "time-range");
}


GPtrArray* zeitgeist_monitor_get_event_templates (ZeitgeistMonitor* self) {
	GPtrArray* result;
	GPtrArray* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_event_templates;
	result = _tmp0_;
	return result;
}


void zeitgeist_monitor_set_event_templates (ZeitgeistMonitor* self, GPtrArray* value) {
	GPtrArray* _tmp0_ = NULL;
	GPtrArray* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_ptr_array_ref0 (_tmp0_);
	_g_ptr_array_unref0 (self->priv->_event_templates);
	self->priv->_event_templates = _tmp1_;
	g_object_notify ((GObject *) self, "event-templates");
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__OBJECT_POINTER_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_POINTER_INT) (gpointer data1, gpointer arg_1, gpointer arg_2, gint arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_POINTER_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_POINTER_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_pointer (param_values + 2), g_value_get_int (param_values + 3), data2);
}


static void zeitgeist_monitor_class_init (ZeitgeistMonitorClass * klass) {
	zeitgeist_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistMonitorPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_zeitgeist_monitor_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_zeitgeist_monitor_set_property;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_monitor_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_MONITOR_TIME_RANGE, g_param_spec_object ("time-range", "time-range", "time-range", ZEITGEIST_TYPE_TIME_RANGE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_MONITOR_EVENT_TEMPLATES, g_param_spec_boxed ("event-templates", "event-templates", "event-templates", G_TYPE_PTR_ARRAY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	     * ZeitgeistMonitor::events-inserted:
	     *
	     * Emitted when events matching the event templates and with timestamps
	     * within the time range of the monitor has been inserted into the log.
	     *
	     * @param time_range A #ZeitgeistTimeRange that specifies the minimum and
	     *     maximum of the timestamps in @events
	     * @param events A #ZeitgeistResultSet holding the "ZeitgeistEvent"s that
	     *     have been inserted into the log
	     */
	g_signal_new ("events_inserted", ZEITGEIST_TYPE_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, ZEITGEIST_TYPE_TIME_RANGE, ZEITGEIST_TYPE_RESULT_SET);
	/**
	     * ZeitgeistMonitor::events-deleted:
	     *
	     * Emitted when events with timestamps within the time range of this
	     * monitor have been deleted from the log. Note that the deleted events
	     * may not match the event templates for the monitor.
	     *
	     * @param time_range A #ZeitgeistTimeRange that specifies the minimum and
	     *     maximum timestamps of the deleted events
	     * @param event_ids A #GArray of #guint32<!-- -->s holding the IDs of the
	     *     deleted events
	     */
	g_signal_new ("events_deleted", ZEITGEIST_TYPE_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_POINTER_INT, G_TYPE_NONE, 3, ZEITGEIST_TYPE_TIME_RANGE, G_TYPE_POINTER, G_TYPE_INT);
}


static void zeitgeist_monitor_zeitgeist_remote_monitor_interface_init (ZeitgeistRemoteMonitorIface * iface) {
	zeitgeist_monitor_zeitgeist_remote_monitor_parent_iface = g_type_interface_peek_parent (iface);
	iface->notify_insert = (void (*)(ZeitgeistRemoteMonitor*, GVariant*, GVariant*, GError**)) zeitgeist_monitor_real_notify_insert;
	iface->notify_insert_finish = zeitgeist_monitor_real_notify_insert_finish;
	iface->notify_delete = (void (*)(ZeitgeistRemoteMonitor*, GVariant*, guint32*, int, GError**)) zeitgeist_monitor_real_notify_delete;
	iface->notify_delete_finish = zeitgeist_monitor_real_notify_delete_finish;
}


static void zeitgeist_monitor_instance_init (ZeitgeistMonitor * self) {
	self->priv = ZEITGEIST_MONITOR_GET_PRIVATE (self);
}


static void zeitgeist_monitor_finalize (GObject* obj) {
	ZeitgeistMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_MONITOR, ZeitgeistMonitor);
	_g_object_unref0 (self->priv->_time_range);
	_g_ptr_array_unref0 (self->priv->_event_templates);
	_g_free0 (self->priv->monitor_path);
	G_OBJECT_CLASS (zeitgeist_monitor_parent_class)->finalize (obj);
}


/**
 * Listens for updates to the Zeitgeist event log
 *
 * A #Monitor listens for updates to the Zeitgeist event log
 * matching a given set of templates and with timestamps in some predefined
 * time range.
 *
 * A monitor must be installed into the running Zeitgeist daemon by calling
 * zeitgeist_log_install_monitor(). The monitor will not emit any of the
 * ::events-added or ::events-deleted signals before this.
 */
GType zeitgeist_monitor_get_type (void) {
	static volatile gsize zeitgeist_monitor_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_monitor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistMonitor), 0, (GInstanceInitFunc) zeitgeist_monitor_instance_init, NULL };
		static const GInterfaceInfo zeitgeist_remote_monitor_info = { (GInterfaceInitFunc) zeitgeist_monitor_zeitgeist_remote_monitor_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType zeitgeist_monitor_type_id;
		zeitgeist_monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistMonitor", &g_define_type_info, 0);
		g_type_add_interface_static (zeitgeist_monitor_type_id, ZEITGEIST_TYPE_REMOTE_MONITOR, &zeitgeist_remote_monitor_info);
		g_once_init_leave (&zeitgeist_monitor_type_id__volatile, zeitgeist_monitor_type_id);
	}
	return zeitgeist_monitor_type_id__volatile;
}


static void _vala_zeitgeist_monitor_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ZeitgeistMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_MONITOR, ZeitgeistMonitor);
	switch (property_id) {
		case ZEITGEIST_MONITOR_TIME_RANGE:
		g_value_set_object (value, zeitgeist_monitor_get_time_range (self));
		break;
		case ZEITGEIST_MONITOR_EVENT_TEMPLATES:
		g_value_set_boxed (value, zeitgeist_monitor_get_event_templates (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_zeitgeist_monitor_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ZeitgeistMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_MONITOR, ZeitgeistMonitor);
	switch (property_id) {
		case ZEITGEIST_MONITOR_TIME_RANGE:
		zeitgeist_monitor_set_time_range (self, g_value_get_object (value));
		break;
		case ZEITGEIST_MONITOR_EVENT_TEMPLATES:
		zeitgeist_monitor_set_event_templates (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



