/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WORKERS)

#include "JSWorkerNavigator.h"

#include "KURL.h"
#include "WorkerNavigator.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSWorkerNavigatorTableValues[] =
{
    { "appName", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerNavigatorAppName), (intptr_t)0, NoIntrinsic },
    { "appVersion", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerNavigatorAppVersion), (intptr_t)0, NoIntrinsic },
    { "platform", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerNavigatorPlatform), (intptr_t)0, NoIntrinsic },
    { "userAgent", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerNavigatorUserAgent), (intptr_t)0, NoIntrinsic },
    { "onLine", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWorkerNavigatorOnLine), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWorkerNavigatorTable = { 18, 15, JSWorkerNavigatorTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSWorkerNavigatorPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWorkerNavigatorPrototypeTable = { 1, 0, JSWorkerNavigatorPrototypeTableValues, 0 };
static const HashTable* getJSWorkerNavigatorPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSWorkerNavigatorPrototypeTable);
}

const ClassInfo JSWorkerNavigatorPrototype::s_info = { "WorkerNavigatorPrototype", &Base::s_info, 0, getJSWorkerNavigatorPrototypeTable, CREATE_METHOD_TABLE(JSWorkerNavigatorPrototype) };

JSObject* JSWorkerNavigatorPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWorkerNavigator>(exec, globalObject);
}

static const HashTable* getJSWorkerNavigatorTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSWorkerNavigatorTable);
}

const ClassInfo JSWorkerNavigator::s_info = { "WorkerNavigator", &Base::s_info, 0, getJSWorkerNavigatorTable , CREATE_METHOD_TABLE(JSWorkerNavigator) };

JSWorkerNavigator::JSWorkerNavigator(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WorkerNavigator> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSWorkerNavigator::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSWorkerNavigator::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSWorkerNavigatorPrototype::create(exec->globalData(), globalObject, JSWorkerNavigatorPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSWorkerNavigator::destroy(JSC::JSCell* cell)
{
    JSWorkerNavigator* thisObject = static_cast<JSWorkerNavigator*>(cell);
    thisObject->JSWorkerNavigator::~JSWorkerNavigator();
}

JSWorkerNavigator::~JSWorkerNavigator()
{
    releaseImplIfNotNull();
}

bool JSWorkerNavigator::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWorkerNavigator* thisObject = jsCast<JSWorkerNavigator*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSWorkerNavigator, Base>(exec, getJSWorkerNavigatorTable(exec), thisObject, propertyName, slot);
}

bool JSWorkerNavigator::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWorkerNavigator* thisObject = jsCast<JSWorkerNavigator*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSWorkerNavigator, Base>(exec, getJSWorkerNavigatorTable(exec), thisObject, propertyName, descriptor);
}

JSValue jsWorkerNavigatorAppName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerNavigator* castedThis = jsCast<JSWorkerNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WorkerNavigator* impl = static_cast<WorkerNavigator*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->appName());
    return result;
}


JSValue jsWorkerNavigatorAppVersion(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerNavigator* castedThis = jsCast<JSWorkerNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WorkerNavigator* impl = static_cast<WorkerNavigator*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->appVersion());
    return result;
}


JSValue jsWorkerNavigatorPlatform(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerNavigator* castedThis = jsCast<JSWorkerNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WorkerNavigator* impl = static_cast<WorkerNavigator*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->platform());
    return result;
}


JSValue jsWorkerNavigatorUserAgent(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerNavigator* castedThis = jsCast<JSWorkerNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WorkerNavigator* impl = static_cast<WorkerNavigator*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->userAgent());
    return result;
}


JSValue jsWorkerNavigatorOnLine(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWorkerNavigator* castedThis = jsCast<JSWorkerNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WorkerNavigator* impl = static_cast<WorkerNavigator*>(castedThis->impl());
    JSValue result = jsBoolean(impl->onLine());
    return result;
}


static inline bool isObservable(JSWorkerNavigator* jsWorkerNavigator)
{
    if (jsWorkerNavigator->hasCustomProperties())
        return true;
    return false;
}

bool JSWorkerNavigatorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSWorkerNavigator* jsWorkerNavigator = jsCast<JSWorkerNavigator*>(handle.get().asCell());
    if (!isObservable(jsWorkerNavigator))
        return false;
    WorkerNavigator* root = jsWorkerNavigator->impl();
    return visitor.containsOpaqueRoot(root);
}

void JSWorkerNavigatorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSWorkerNavigator* jsWorkerNavigator = jsCast<JSWorkerNavigator*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWorkerNavigator->impl(), jsWorkerNavigator);
    jsWorkerNavigator->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, WorkerNavigator* impl)
{
    return wrap<JSWorkerNavigator>(exec, globalObject, impl);
}

WorkerNavigator* toWorkerNavigator(JSC::JSValue value)
{
    return value.inherits(&JSWorkerNavigator::s_info) ? jsCast<JSWorkerNavigator*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WORKERS)
