; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -instcombine -S | FileCheck %s

; Infinity

define i1 @inf0(double %arg) {
; CHECK-LABEL: @inf0(
; CHECK-NEXT:    ret i1 false
;
  %tmp = fcmp ogt double %arg, 0x7FF0000000000000
  ret i1 %tmp
}

define i1 @inf1(double %arg) {
; CHECK-LABEL: @inf1(
; CHECK-NEXT:    ret i1 true
;
  %tmp = fcmp ule double %arg, 0x7FF0000000000000
  ret i1 %tmp
}

; Negative infinity

define i1 @ninf0(double %arg) {
; CHECK-LABEL: @ninf0(
; CHECK-NEXT:    ret i1 false
;
  %tmp = fcmp olt double %arg, 0xFFF0000000000000
  ret i1 %tmp
}

define i1 @ninf1(double %arg) {
; CHECK-LABEL: @ninf1(
; CHECK-NEXT:    ret i1 true
;
  %tmp = fcmp uge double %arg, 0xFFF0000000000000
  ret i1 %tmp
}

; NaNs

define i1 @nan0(double %arg) {
; CHECK-LABEL: @nan0(
; CHECK-NEXT:    ret i1 false
;
  %tmp = fcmp ord double %arg, 0x7FF00000FFFFFFFF
  ret i1 %tmp
}

define i1 @nan1(double %arg) {
; CHECK-LABEL: @nan1(
; CHECK-NEXT:    ret i1 false
;
  %tmp = fcmp oeq double %arg, 0x7FF00000FFFFFFFF
  ret i1 %tmp
}

define i1 @nan2(double %arg) {
; CHECK-LABEL: @nan2(
; CHECK-NEXT:    ret i1 false
;
  %tmp = fcmp olt double %arg, 0x7FF00000FFFFFFFF
  ret i1 %tmp
}

define i1 @nan3(double %arg) {
; CHECK-LABEL: @nan3(
; CHECK-NEXT:    ret i1 true
;
  %tmp = fcmp uno double %arg, 0x7FF00000FFFFFFFF
  ret i1 %tmp
}

define i1 @nan4(double %arg) {
; CHECK-LABEL: @nan4(
; CHECK-NEXT:    ret i1 true
;
  %tmp = fcmp une double %arg, 0x7FF00000FFFFFFFF
  ret i1 %tmp
}

define i1 @nan5(double %arg) {
; CHECK-LABEL: @nan5(
; CHECK-NEXT:    ret i1 true
;
  %tmp = fcmp ult double %arg, 0x7FF00000FFFFFFFF
  ret i1 %tmp
}

; Negative NaN.

define i1 @nnan0(double %arg) {
; CHECK-LABEL: @nnan0(
; CHECK-NEXT:    ret i1 false
;
  %tmp = fcmp ord double %arg, 0xFFF00000FFFFFFFF
  ret i1 %tmp
}

define i1 @nnan1(double %arg) {
; CHECK-LABEL: @nnan1(
; CHECK-NEXT:    ret i1 false
;
  %tmp = fcmp oeq double %arg, 0xFFF00000FFFFFFFF
  ret i1 %tmp
}

define i1 @nnan2(double %arg) {
; CHECK-LABEL: @nnan2(
; CHECK-NEXT:    ret i1 false
;
  %tmp = fcmp olt double %arg, 0xFFF00000FFFFFFFF
  ret i1 %tmp
}

define i1 @nnan3(double %arg) {
; CHECK-LABEL: @nnan3(
; CHECK-NEXT:    ret i1 true
;
  %tmp = fcmp uno double %arg, 0xFFF00000FFFFFFFF
  ret i1 %tmp
}

define i1 @nnan4(double %arg) {
; CHECK-LABEL: @nnan4(
; CHECK-NEXT:    ret i1 true
;
  %tmp = fcmp une double %arg, 0xFFF00000FFFFFFFF
  ret i1 %tmp
}

define i1 @nnan5(double %arg) {
; CHECK-LABEL: @nnan5(
; CHECK-NEXT:    ret i1 true
;
  %tmp = fcmp ult double %arg, 0xFFF00000FFFFFFFF
  ret i1 %tmp
}

; Negative zero.

define i1 @nzero0() {
; CHECK-LABEL: @nzero0(
; CHECK-NEXT:    ret i1 true
;
  %tmp = fcmp oeq double 0.0, -0.0
  ret i1 %tmp
}

define i1 @nzero1() {
; CHECK-LABEL: @nzero1(
; CHECK-NEXT:    ret i1 false
;
  %tmp = fcmp ogt double 0.0, -0.0
  ret i1 %tmp
}

; Misc.

define i1 @misc0(double %arg) {
; CHECK-LABEL: @misc0(
; CHECK-NEXT:    [[TMP:%.*]] = fcmp ord double %arg, 0.000000e+00
; CHECK-NEXT:    ret i1 [[TMP]]
;
  %tmp = fcmp oeq double %arg, %arg
  ret i1 %tmp
}

define i1 @misc1(double %arg) {
; CHECK-LABEL: @misc1(
; CHECK-NEXT:    ret i1 false
;
  %tmp = fcmp one double %arg, %arg
  ret i1 %tmp
}

