// RUN: llvm-mc -triple=amdgcn -mcpu=gfx1011 -show-encoding %s | FileCheck %s
// RUN: llvm-mc -triple=amdgcn -mcpu=gfx1012 -show-encoding %s | FileCheck %s

v_dot2c_f32_f16_e32 v5, v1, v2
// CHECK: encoding: [0x01,0x05,0x0a,0x04]

v_dot2c_f32_f16_e32 v255, v1, v2
// CHECK: encoding: [0x01,0x05,0xfe,0x05]

v_dot2c_f32_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x04,0x01,0xe4,0x00,0x00]

v_dot2c_f32_f16_dpp v255, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0xfe,0x05,0x01,0xe4,0x00,0x00]

v_dot2c_f32_f16_dpp v5, v255, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x04,0xff,0xe4,0x00,0x00]

v_dot2c_f32_f16_dpp v5, v1, v255  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0xfe,0x0b,0x04,0x01,0xe4,0x00,0x00]

v_dot2c_f32_f16_dpp v5, v1, v2  quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x04,0x01,0x1b,0x00,0x00]

v_dot2c_f32_f16_dpp v5, v1, v2  row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x04,0x01,0x40,0x01,0x00]

v_dot2c_f32_f16_dpp v5, v1, v2  row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x04,0x01,0x41,0x01,0x00]

v_dot2c_f32_f16_dpp v5, v1, v2  row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x04,0x01,0x01,0x01,0x00]

v_dot2c_f32_f16_dpp v5, v1, v2  row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x04,0x01,0x0f,0x01,0x00]

v_dot2c_f32_f16_dpp v5, v1, v2  row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x04,0x01,0x11,0x01,0x00]

v_dot2c_f32_f16_dpp v5, v1, v2  row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x04,0x01,0x1f,0x01,0x00]

v_dot2c_f32_f16_dpp v5, v1, v2  row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x04,0x01,0x21,0x01,0x00]

v_dot2c_f32_f16_dpp v5, v1, v2  row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x04,0x01,0x2f,0x01,0x00]

v_dot2c_f32_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x04,0x01,0xe4,0x00,0x10]

v_dot2c_f32_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x04,0x01,0xe4,0x00,0x30]

v_dot2c_f32_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x04,0x01,0xe4,0x00,0xf0]

v_dot2c_f32_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x04,0x01,0xe4,0x00,0xf0]

v_dot2c_f32_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: encoding: [0xfa,0x04,0x0a,0x04,0x01,0xe4,0x00,0x01]

v_dot2c_f32_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: encoding: [0xfa,0x04,0x0a,0x04,0x01,0xe4,0x00,0x03]

v_dot2c_f32_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: encoding: [0xfa,0x04,0x0a,0x04,0x01,0xe4,0x00,0x0f]

v_dot2c_f32_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: encoding: [0xfa,0x04,0x0a,0x04,0x01,0xe4,0x00,0x0f]

v_dot2c_f32_f16_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: encoding: [0xfa,0x04,0x0a,0x04,0x01,0xe4,0x08,0x00]

v_dot2c_f32_f16_dpp v5, -v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x04,0x01,0xe4,0x10,0x00]

v_dot2c_f32_f16_dpp v5, |v1|, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x04,0x01,0xe4,0x20,0x00]

v_dot2c_f32_f16_dpp v5, v1, -v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x04,0x01,0xe4,0x40,0x00]

v_dot2c_f32_f16_dpp v5, v1, |v2|  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x04,0x01,0xe4,0x80,0x00]

v_dot4c_i32_i8_e32 v5, v1, v2
// CHECK: encoding: [0x01,0x05,0x0a,0x1a]

v_dot4c_i32_i8_e32 v255, v1, v2
// CHECK: encoding: [0x01,0x05,0xfe,0x1b]

v_dot4c_i32_i8_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x1a,0x01,0xe4,0x00,0x00]

v_dot4c_i32_i8_dpp v255, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0xfe,0x1b,0x01,0xe4,0x00,0x00]

v_dot4c_i32_i8_dpp v5, v255, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x1a,0xff,0xe4,0x00,0x00]

v_dot4c_i32_i8_dpp v5, v1, v255  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0xfe,0x0b,0x1a,0x01,0xe4,0x00,0x00]

v_dot4c_i32_i8_dpp v5, v1, v2  quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x1a,0x01,0x1b,0x00,0x00]

v_dot4c_i32_i8_dpp v5, v1, v2  row_mirror row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x1a,0x01,0x40,0x01,0x00]

v_dot4c_i32_i8_dpp v5, v1, v2  row_half_mirror row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x1a,0x01,0x41,0x01,0x00]

v_dot4c_i32_i8_dpp v5, v1, v2  row_shl:1 row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x1a,0x01,0x01,0x01,0x00]

v_dot4c_i32_i8_dpp v5, v1, v2  row_shl:15 row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x1a,0x01,0x0f,0x01,0x00]

v_dot4c_i32_i8_dpp v5, v1, v2  row_shr:1 row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x1a,0x01,0x11,0x01,0x00]

v_dot4c_i32_i8_dpp v5, v1, v2  row_shr:15 row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x1a,0x01,0x1f,0x01,0x00]

v_dot4c_i32_i8_dpp v5, v1, v2  row_ror:1 row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x1a,0x01,0x21,0x01,0x00]

v_dot4c_i32_i8_dpp v5, v1, v2  row_ror:15 row_mask:0x0 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x1a,0x01,0x2f,0x01,0x00]

v_dot4c_i32_i8_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x1a,0x01,0xe4,0x00,0x10]

v_dot4c_i32_i8_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x1a,0x01,0xe4,0x00,0x30]

v_dot4c_i32_i8_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x1a,0x01,0xe4,0x00,0xf0]

v_dot4c_i32_i8_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0
// CHECK: encoding: [0xfa,0x04,0x0a,0x1a,0x01,0xe4,0x00,0xf0]

v_dot4c_i32_i8_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1
// CHECK: encoding: [0xfa,0x04,0x0a,0x1a,0x01,0xe4,0x00,0x01]

v_dot4c_i32_i8_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3
// CHECK: encoding: [0xfa,0x04,0x0a,0x1a,0x01,0xe4,0x00,0x03]

v_dot4c_i32_i8_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: encoding: [0xfa,0x04,0x0a,0x1a,0x01,0xe4,0x00,0x0f]

v_dot4c_i32_i8_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf
// CHECK: encoding: [0xfa,0x04,0x0a,0x1a,0x01,0xe4,0x00,0x0f]

v_dot4c_i32_i8_dpp v5, v1, v2  quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:0
// CHECK: encoding: [0xfa,0x04,0x0a,0x1a,0x01,0xe4,0x08,0x00]
