#include <unistd.h>

uid_t su_getuid(void);
uid_t su_geteuid(void);
gid_t su_getgid(void);
gid_t su_getegid(void);

#define getuid() 		su_getuid()
#define geteuid() 		su_geteuid()
#define getgid() 		su_getgid()
#define getegid() 		su_getegid()

int su_setuid(uid_t uid);
int su_seteuid(uid_t euid);
int su_setgid(gid_t gid);
int su_setegid(gid_t egid);
int su_setreuid(uid_t ruid, uid_t euid);
int su_setregid(gid_t rgid, gid_t egid);

#define setuid(a) 		su_setuid(a)
#define seteuid(a) 		su_seteuid(a)
#define setreuid(a,b) 	su_setreuid(a,b)
#define setgid(a) 		su_setgid(a)
#define setegid(a) 		su_setegid(a)
#define setregid(a,b) 	su_setregid(a,b)

int su_getgroups(int size, gid_t list[]);
int su_setgroups(int size, const gid_t *list);

#define getgroups(a,b)	su_getgroups(a,b)
#define setgroups(a,b)	su_setgroups(a,b)

int su_chown(const char *path, uid_t owner, gid_t group);
int su_fchown(int fd, uid_t owner, gid_t group);
int su_lchown(const char *path, uid_t owner, gid_t group);

#define chown(a,b,c)	su_chown(a,b,c)
#define fchown(a,b,c)	su_fchown(a,b,c)
#define lchown(a,b,c)	su_lchown(a,b,c)

