.\" Man page generated from reStructuredText.
.
.TH "KVNO" "1" " " "1.15.2" "MIT Kerberos"
.SH NAME
kvno \- print key version numbers of Kerberos principals
.
.nr rst2man-indent-level 0
.
.de1 rstReportMargin
\\$1 \\n[an-margin]
level \\n[rst2man-indent-level]
level margin: \\n[rst2man-indent\\n[rst2man-indent-level]]
-
\\n[rst2man-indent0]
\\n[rst2man-indent1]
\\n[rst2man-indent2]
..
.de1 INDENT
.\" .rstReportMargin pre:
. RS \\$1
. nr rst2man-indent\\n[rst2man-indent-level] \\n[an-margin]
. nr rst2man-indent-level +1
.\" .rstReportMargin post:
..
.de UNINDENT
. RE
.\" indent \\n[an-margin]
.\" old: \\n[rst2man-indent\\n[rst2man-indent-level]]
.nr rst2man-indent-level -1
.\" new: \\n[rst2man-indent\\n[rst2man-indent-level]]
.in \\n[rst2man-indent\\n[rst2man-indent-level]]u
..
.SH SYNOPSIS
.sp
\fBkvno\fP
[\fB\-c\fP \fIccache\fP]
[\fB\-e\fP \fIetype\fP]
[\fB\-q\fP]
[\fB\-h\fP]
[\fB\-P\fP]
[\fB\-S\fP \fIsname\fP]
[\fB\-U\fP \fIfor_user\fP]
\fIservice1 service2\fP ...
.SH DESCRIPTION
.sp
kvno acquires a service ticket for the specified Kerberos principals
and prints out the key version numbers of each.
.SH OPTIONS
.INDENT 0.0
.TP
.B \fB\-c\fP \fIccache\fP
Specifies the name of a credentials cache to use (if not the
default)
.TP
.B \fB\-e\fP \fIetype\fP
Specifies the enctype which will be requested for the session key
of all the services named on the command line.  This is useful in
certain backward compatibility situations.
.TP
.B \fB\-q\fP
Suppress printing output when successful.  If a service ticket
cannot be obtained, an error message will still be printed and
kvno will exit with nonzero status.
.TP
.B \fB\-h\fP
Prints a usage statement and exits.
.TP
.B \fB\-P\fP
Specifies that the \fIservice1 service2\fP ...  arguments are to be
treated as services for which credentials should be acquired using
constrained delegation.  This option is only valid when used in
conjunction with protocol transition.
.TP
.B \fB\-S\fP \fIsname\fP
Specifies that the \fIservice1 service2\fP ... arguments are
interpreted as hostnames, and the service principals are to be
constructed from those hostnames and the service name \fIsname\fP\&.
The service hostnames will be canonicalized according to the usual
rules for constructing service principals.
.TP
.B \fB\-U\fP \fIfor_user\fP
Specifies that protocol transition (S4U2Self) is to be used to
acquire a ticket on behalf of \fIfor_user\fP\&.  If constrained
delegation is not requested, the service name must match the
credentials cache client principal.
.UNINDENT
.SH ENVIRONMENT
.sp
kvno uses the following environment variable:
.INDENT 0.0
.TP
.B \fBKRB5CCNAME\fP
Location of the credentials (ticket) cache.
.UNINDENT
.SH FILES
.INDENT 0.0
.TP
.B \fB@CCNAME@\fP
Default location of the credentials cache
.UNINDENT
.SH SEE ALSO
.sp
\fIkinit(1)\fP, \fIkdestroy(1)\fP
.SH AUTHOR
MIT
.SH COPYRIGHT
1985-2017, MIT
.\" Generated by docutils manpage writer.
.
