/* sudoku-printer.c generated by valac 0.38.0.11-8bd7f, the Vala compiler
 * generated from sudoku-printer.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include "libsudoku.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <cairo.h>
#include <float.h>
#include <math.h>


#define TYPE_SUDOKU_PRINTER (sudoku_printer_get_type ())
#define SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinter))
#define SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))
#define IS_SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_PRINTER))
#define IS_SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_PRINTER))
#define SUDOKU_PRINTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))

typedef struct _SudokuPrinter SudokuPrinter;
typedef struct _SudokuPrinterClass SudokuPrinterClass;
typedef struct _SudokuPrinterPrivate SudokuPrinterPrivate;
enum  {
	SUDOKU_PRINTER_DUMMY_PROPERTY,
	SUDOKU_PRINTER_LAST_PROPERTY
};
static GParamSpec* sudoku_printer_properties[SUDOKU_PRINTER_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

struct _SudokuPrinter {
	GObject parent_instance;
	SudokuPrinterPrivate * priv;
};

struct _SudokuPrinterClass {
	GObjectClass parent_class;
};

struct _SudokuPrinterPrivate {
	GeeList* boards;
	GtkWindow* window;
	gint margin;
	gint n_sudokus;
	GtkPrintOperation* print_op;
};


static gpointer sudoku_printer_parent_class = NULL;

GType sudoku_printer_get_type (void) G_GNUC_CONST;
#define SUDOKU_PRINTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_PRINTER, SudokuPrinterPrivate))
#define SUDOKU_PRINTER_SUDOKUS_PER_PAGE 2
GtkPrintOperationResult sudoku_printer_print_sudoku (SudokuPrinter* self);
SudokuPrinter* sudoku_printer_new (GeeList* boards, GtkWindow* window);
SudokuPrinter* sudoku_printer_construct (GType object_type, GeeList* boards, GtkWindow* window);
static void sudoku_printer_begin_print_cb (SudokuPrinter* self, GtkPrintOperation* operation, GtkPrintContext* context);
static void _sudoku_printer_begin_print_cb_gtk_print_operation_begin_print (GtkPrintOperation* _sender, GtkPrintContext* context, gpointer self);
static void sudoku_printer_draw_page_cb (SudokuPrinter* self, GtkPrintOperation* operation, GtkPrintContext* context, gint page_nr);
static void _sudoku_printer_draw_page_cb_gtk_print_operation_draw_page (GtkPrintOperation* _sender, GtkPrintContext* context, gint page_nr, gpointer self);
static gdouble sudoku_printer_fit_squares_in_rectangle (SudokuPrinter* self, gdouble width, gdouble height, gint margin);
static void sudoku_printer_draw_sudoku (SudokuPrinter* self, cairo_t* cr, SudokuBoard* sudoku_board, gdouble size, gdouble offset_x, gdouble offset_y);
static void sudoku_printer_finalize (GObject * obj);


GtkPrintOperationResult sudoku_printer_print_sudoku (SudokuPrinter* self) {
	GtkPrintOperationResult result = 0;
	GError * _inner_error_ = NULL;
#line 36 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 99 "sudoku-printer.c"
	{
		GtkPrintOperationResult _result_ = 0;
		GtkPrintOperation* _tmp0_;
		GtkWindow* _tmp1_;
		GtkPrintOperationResult _tmp2_;
#line 40 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		_tmp0_ = self->priv->print_op;
#line 40 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		_tmp1_ = self->priv->window;
#line 40 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		_tmp2_ = gtk_print_operation_run (_tmp0_, GTK_PRINT_OPERATION_ACTION_PRINT_DIALOG, _tmp1_, &_inner_error_);
#line 40 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		_result_ = _tmp2_;
#line 40 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 115 "sudoku-printer.c"
			goto __catch5_g_error;
		}
#line 41 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		result = _result_;
#line 41 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		return result;
#line 122 "sudoku-printer.c"
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GtkWindow* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GtkMessageDialog* _tmp8_;
		GtkMessageDialog* _tmp9_;
#line 38 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		e = _inner_error_;
#line 38 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		_inner_error_ = NULL;
#line 45 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		_tmp3_ = self->priv->window;
#line 45 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		_tmp4_ = e;
#line 45 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		_tmp5_ = _tmp4_->message;
#line 45 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		_tmp6_ = g_strdup_printf ("%s\n%s", _ ("Error printing file:"), _tmp5_);
#line 45 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		_tmp7_ = _tmp6_;
#line 45 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		_tmp8_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp3_, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", _tmp7_);
#line 45 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		g_object_ref_sink (_tmp8_);
#line 45 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		_tmp9_ = _tmp8_;
#line 45 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		gtk_dialog_run ((GtkDialog*) _tmp9_);
#line 45 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		_g_object_unref0 (_tmp9_);
#line 45 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		_g_free0 (_tmp7_);
#line 38 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		_g_error_free0 (e);
#line 163 "sudoku-printer.c"
	}
	__finally5:
#line 38 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 38 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 38 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		g_clear_error (&_inner_error_);
#line 38 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		return 0;
#line 174 "sudoku-printer.c"
	}
#line 51 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	result = GTK_PRINT_OPERATION_RESULT_ERROR;
#line 51 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	return result;
#line 180 "sudoku-printer.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 56 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	return self ? g_object_ref (self) : NULL;
#line 187 "sudoku-printer.c"
}


static void _sudoku_printer_begin_print_cb_gtk_print_operation_begin_print (GtkPrintOperation* _sender, GtkPrintContext* context, gpointer self) {
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	sudoku_printer_begin_print_cb ((SudokuPrinter*) self, _sender, context);
#line 194 "sudoku-printer.c"
}


static void _sudoku_printer_draw_page_cb_gtk_print_operation_draw_page (GtkPrintOperation* _sender, GtkPrintContext* context, gint page_nr, gpointer self) {
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	sudoku_printer_draw_page_cb ((SudokuPrinter*) self, _sender, context, page_nr);
#line 201 "sudoku-printer.c"
}


SudokuPrinter* sudoku_printer_construct (GType object_type, GeeList* boards, GtkWindow* window) {
	SudokuPrinter * self = NULL;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GtkWindow* _tmp2_;
	GtkWindow* _tmp3_;
	GeeList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GtkPrintOperation* _tmp7_;
	GtkPrintOperation* _tmp8_;
	GtkPrintOperation* _tmp9_;
#line 54 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	g_return_val_if_fail (boards != NULL, NULL);
#line 54 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	g_return_val_if_fail (window != NULL, NULL);
#line 54 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	self = (SudokuPrinter*) g_object_new (object_type, NULL);
#line 56 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp0_ = boards;
#line 56 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 56 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (self->priv->boards);
#line 56 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	self->priv->boards = _tmp1_;
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp2_ = window;
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (self->priv->window);
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	self->priv->window = _tmp3_;
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	self->priv->margin = 25;
#line 59 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp4_ = boards;
#line 59 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
#line 59 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp6_ = _tmp5_;
#line 59 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	self->priv->n_sudokus = _tmp6_;
#line 61 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp7_ = gtk_print_operation_new ();
#line 61 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (self->priv->print_op);
#line 61 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	self->priv->print_op = _tmp7_;
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp8_ = self->priv->print_op;
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	g_signal_connect_object (_tmp8_, "begin-print", (GCallback) _sudoku_printer_begin_print_cb_gtk_print_operation_begin_print, self, 0);
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp9_ = self->priv->print_op;
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	g_signal_connect_object (_tmp9_, "draw-page", (GCallback) _sudoku_printer_draw_page_cb_gtk_print_operation_draw_page, self, 0);
#line 54 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	return self;
#line 265 "sudoku-printer.c"
}


SudokuPrinter* sudoku_printer_new (GeeList* boards, GtkWindow* window) {
#line 54 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	return sudoku_printer_construct (TYPE_SUDOKU_PRINTER, boards, window);
#line 272 "sudoku-printer.c"
}


static void sudoku_printer_begin_print_cb (SudokuPrinter* self, GtkPrintOperation* operation, GtkPrintContext* context) {
	gint pages = 0;
	gint _tmp0_;
	GtkPrintOperation* _tmp4_;
	gint _tmp5_;
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	g_return_if_fail (self != NULL);
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	g_return_if_fail (operation != NULL);
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	g_return_if_fail (context != NULL);
#line 68 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp0_ = self->priv->n_sudokus;
#line 68 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	pages = _tmp0_ / SUDOKU_PRINTER_SUDOKUS_PER_PAGE;
#line 69 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	while (TRUE) {
#line 293 "sudoku-printer.c"
		gint _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
#line 69 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		_tmp1_ = pages;
#line 69 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		_tmp2_ = self->priv->n_sudokus;
#line 69 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		if (!((_tmp1_ * SUDOKU_PRINTER_SUDOKUS_PER_PAGE) < _tmp2_)) {
#line 69 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			break;
#line 305 "sudoku-printer.c"
		}
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		_tmp3_ = pages;
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		pages = _tmp3_ + 1;
#line 311 "sudoku-printer.c"
	}
#line 72 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp4_ = operation;
#line 72 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp5_ = pages;
#line 72 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	gtk_print_operation_set_n_pages (_tmp4_, _tmp5_);
#line 319 "sudoku-printer.c"
}


static gpointer _cairo_reference0 (gpointer self) {
#line 77 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	return self ? cairo_reference (self) : NULL;
#line 326 "sudoku-printer.c"
}


static void sudoku_printer_draw_page_cb (SudokuPrinter* self, GtkPrintOperation* operation, GtkPrintContext* context, gint page_nr) {
	cairo_t* cr = NULL;
	GtkPrintContext* _tmp0_;
	cairo_t* _tmp1_;
	cairo_t* _tmp2_;
	gdouble width = 0.0;
	GtkPrintContext* _tmp3_;
	gdouble _tmp4_;
	gdouble height = 0.0;
	GtkPrintContext* _tmp5_;
	gdouble _tmp6_;
	gdouble best_square_size = 0.0;
	gdouble _tmp7_;
	gdouble _tmp8_;
	gint _tmp9_;
	gdouble _tmp10_;
	gint start = 0;
	gint _tmp11_;
	gint end = 0;
	gint _tmp12_;
	GeeList* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GeeList* sudokus_on_page = NULL;
	GeeList* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	GeeList* _tmp20_;
	gdouble left = 0.0;
	gdouble _tmp21_;
	gdouble _tmp22_;
	gdouble top = 0.0;
	gint _tmp23_;
#line 75 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	g_return_if_fail (self != NULL);
#line 75 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	g_return_if_fail (operation != NULL);
#line 75 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	g_return_if_fail (context != NULL);
#line 77 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp0_ = context;
#line 77 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp1_ = gtk_print_context_get_cairo_context (_tmp0_);
#line 77 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp2_ = _cairo_reference0 (_tmp1_);
#line 77 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	cr = _tmp2_;
#line 78 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp3_ = context;
#line 78 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp4_ = gtk_print_context_get_width (_tmp3_);
#line 78 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	width = _tmp4_;
#line 79 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp5_ = context;
#line 79 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp6_ = gtk_print_context_get_height (_tmp5_);
#line 79 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	height = _tmp6_;
#line 81 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp7_ = width;
#line 81 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp8_ = height;
#line 81 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp9_ = self->priv->margin;
#line 81 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp10_ = sudoku_printer_fit_squares_in_rectangle (self, _tmp7_, _tmp8_, _tmp9_);
#line 81 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	best_square_size = _tmp10_;
#line 83 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp11_ = page_nr;
#line 83 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	start = _tmp11_ * SUDOKU_PRINTER_SUDOKUS_PER_PAGE;
#line 84 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp12_ = start;
#line 84 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp13_ = self->priv->boards;
#line 84 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
#line 84 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp15_ = _tmp14_;
#line 84 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp16_ = MIN (_tmp12_ + SUDOKU_PRINTER_SUDOKUS_PER_PAGE, _tmp15_);
#line 84 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	end = _tmp16_;
#line 85 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp17_ = self->priv->boards;
#line 85 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp18_ = start;
#line 85 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp19_ = end;
#line 85 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp20_ = gee_list_slice (_tmp17_, _tmp18_, _tmp19_);
#line 85 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	sudokus_on_page = _tmp20_;
#line 87 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp21_ = width;
#line 87 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp22_ = best_square_size;
#line 87 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	left = (_tmp21_ - _tmp22_) / 2;
#line 88 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp23_ = self->priv->margin;
#line 88 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	top = (gdouble) _tmp23_;
#line 436 "sudoku-printer.c"
	{
		GeeList* _sudoku_list = NULL;
		GeeList* _tmp24_;
		GeeList* _tmp25_;
		gint _sudoku_size = 0;
		GeeList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint _sudoku_index = 0;
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		_tmp24_ = sudokus_on_page;
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		_tmp25_ = _g_object_ref0 (_tmp24_);
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		_sudoku_list = _tmp25_;
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		_tmp26_ = _sudoku_list;
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		_tmp27_ = gee_collection_get_size ((GeeCollection*) _tmp26_);
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		_tmp28_ = _tmp27_;
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		_sudoku_size = _tmp28_;
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		_sudoku_index = -1;
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		while (TRUE) {
#line 464 "sudoku-printer.c"
			gint _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
			SudokuBoard* sudoku = NULL;
			GeeList* _tmp32_;
			gint _tmp33_;
			gpointer _tmp34_;
			gchar* label = NULL;
			SudokuBoard* _tmp35_;
			DifficultyCategory _tmp36_;
			DifficultyCategory _tmp37_;
			gchar* _tmp38_;
			cairo_t* _tmp39_;
			cairo_t* _tmp40_;
			cairo_t* _tmp41_;
			cairo_text_extents_t extents = {0};
			cairo_t* _tmp42_;
			const gchar* _tmp43_;
			cairo_text_extents_t _tmp44_ = {0};
			cairo_t* _tmp45_;
			gdouble _tmp46_;
			cairo_text_extents_t _tmp47_;
			gdouble _tmp48_;
			gdouble _tmp49_;
			cairo_text_extents_t _tmp50_;
			gdouble _tmp51_;
			cairo_t* _tmp52_;
			const gchar* _tmp53_;
			cairo_t* _tmp54_;
			SudokuBoard* _tmp55_;
			gdouble _tmp56_;
			gdouble _tmp57_;
			gdouble _tmp58_;
			gdouble _tmp59_;
			gdouble _tmp60_;
			gint _tmp61_;
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp29_ = _sudoku_index;
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_sudoku_index = _tmp29_ + 1;
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp30_ = _sudoku_index;
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp31_ = _sudoku_size;
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			if (!(_tmp30_ < _tmp31_)) {
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				break;
#line 513 "sudoku-printer.c"
			}
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp32_ = _sudoku_list;
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp33_ = _sudoku_index;
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp34_ = gee_list_get (_tmp32_, _tmp33_);
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			sudoku = (SudokuBoard*) _tmp34_;
#line 92 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp35_ = sudoku;
#line 92 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp36_ = sudoku_board_get_difficulty_category (_tmp35_);
#line 92 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp37_ = _tmp36_;
#line 92 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp38_ = difficulty_category_to_string (_tmp37_);
#line 92 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			label = _tmp38_;
#line 93 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp39_ = cr;
#line 93 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			cairo_set_font_size (_tmp39_, (gdouble) 12);
#line 94 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp40_ = cr;
#line 94 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			cairo_select_font_face (_tmp40_, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
#line 95 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp41_ = cr;
#line 95 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			cairo_set_source_rgb (_tmp41_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
#line 97 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp42_ = cr;
#line 97 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp43_ = label;
#line 97 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			cairo_text_extents (_tmp42_, _tmp43_, &_tmp44_);
#line 97 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			extents = _tmp44_;
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp45_ = cr;
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp46_ = width;
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp47_ = extents;
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp48_ = _tmp47_.width;
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp49_ = top;
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp50_ = extents;
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp51_ = _tmp50_.height;
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			cairo_move_to (_tmp45_, (_tmp46_ - _tmp48_) / 2, _tmp49_ - (_tmp51_ / 2));
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp52_ = cr;
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp53_ = label;
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			cairo_show_text (_tmp52_, _tmp53_);
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp54_ = cr;
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp55_ = sudoku;
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp56_ = best_square_size;
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp57_ = left;
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp58_ = top;
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			sudoku_printer_draw_sudoku (self, _tmp54_, _tmp55_, _tmp56_, _tmp57_, _tmp58_);
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp59_ = top;
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp60_ = best_square_size;
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp61_ = self->priv->margin;
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			top = _tmp59_ + (_tmp60_ + (2 * _tmp61_));
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_g_free0 (label);
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_g_object_unref0 (sudoku);
#line 599 "sudoku-printer.c"
		}
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		_g_object_unref0 (_sudoku_list);
#line 603 "sudoku-printer.c"
	}
#line 75 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (sudokus_on_page);
#line 75 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_cairo_destroy0 (cr);
#line 609 "sudoku-printer.c"
}


static gdouble sudoku_printer_fit_squares_in_rectangle (SudokuPrinter* self, gdouble width, gdouble height, gint margin) {
	gdouble result = 0.0;
	gint n = 0;
	gdouble best_square_size = 0.0;
	gdouble square_size = 0.0;
#line 107 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 109 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	n = SUDOKU_PRINTER_SUDOKUS_PER_PAGE;
#line 110 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	best_square_size = 0.0;
#line 111 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	square_size = 0.0;
#line 626 "sudoku-printer.c"
	{
		gint n_across = 0;
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		n_across = 1;
#line 631 "sudoku-printer.c"
		{
			gboolean _tmp0_ = FALSE;
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp0_ = TRUE;
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			while (TRUE) {
#line 638 "sudoku-printer.c"
				gint _tmp2_;
				gint _tmp3_;
				gdouble n_down = 0.0;
				gint _tmp4_;
				gint _tmp5_;
				gdouble across_size = 0.0;
				gdouble _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				gdouble _tmp9_;
				gint _tmp10_;
				gdouble down_size = 0.0;
				gdouble _tmp11_;
				gdouble _tmp12_;
				gint _tmp13_;
				gdouble _tmp14_;
				gdouble _tmp15_;
				gdouble _tmp16_;
				gdouble _tmp17_;
				gdouble _tmp18_;
				gdouble _tmp19_;
				gdouble _tmp20_;
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				if (!_tmp0_) {
#line 663 "sudoku-printer.c"
					gint _tmp1_;
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					_tmp1_ = n_across;
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					n_across = _tmp1_ + 1;
#line 669 "sudoku-printer.c"
				}
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp0_ = FALSE;
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp2_ = n_across;
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp3_ = n;
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				if (!(_tmp2_ <= _tmp3_)) {
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					break;
#line 681 "sudoku-printer.c"
				}
#line 115 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp4_ = n;
#line 115 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp5_ = n_across;
#line 115 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				n_down = (gdouble) (_tmp4_ / _tmp5_);
#line 116 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp6_ = width;
#line 116 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp7_ = n_across;
#line 116 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp8_ = margin;
#line 116 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				across_size = _tmp6_ - ((_tmp7_ + 1) * _tmp8_);
#line 117 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp9_ = across_size;
#line 117 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp10_ = n_across;
#line 117 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				across_size = _tmp9_ / _tmp10_;
#line 118 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp11_ = height;
#line 118 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp12_ = n_down;
#line 118 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp13_ = margin;
#line 118 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				down_size = _tmp11_ - ((_tmp12_ + 1) * _tmp13_);
#line 119 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp14_ = down_size;
#line 119 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp15_ = n_down;
#line 119 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				down_size = _tmp14_ / _tmp15_;
#line 121 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp16_ = across_size;
#line 121 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp17_ = down_size;
#line 121 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp18_ = MIN (_tmp16_, _tmp17_);
#line 121 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				square_size = _tmp18_;
#line 122 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp19_ = square_size;
#line 122 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp20_ = best_square_size;
#line 122 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				if (_tmp19_ > _tmp20_) {
#line 731 "sudoku-printer.c"
					gdouble _tmp21_;
#line 123 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					_tmp21_ = square_size;
#line 123 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					best_square_size = _tmp21_;
#line 737 "sudoku-printer.c"
				}
			}
		}
	}
#line 126 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	result = best_square_size;
#line 126 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	return result;
#line 746 "sudoku-printer.c"
}


static void sudoku_printer_draw_sudoku (SudokuPrinter* self, cairo_t* cr, SudokuBoard* sudoku_board, gdouble size, gdouble offset_x, gdouble offset_y) {
#line 131 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	static const gint SUDOKU_SIZE = 9;
#line 132 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	static const gint N_BOXES = 3;
#line 133 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	static const gdouble PENCIL_GREY[] = {0.3, 0.3, 0.3};
#line 134 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	static const gdouble BACKGROUND_COLOR[] = {1.0, 1.0, 1.0};
#line 136 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	static const gdouble BORDER_COLOR[] = {1.0, 1.0, 1.0};
#line 137 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	static const gdouble LINE_COLOR[] = {0.0, 0.0, 0.0};
#line 763 "sudoku-printer.c"
	gdouble THIN = 0.0;
	gdouble _tmp0_;
	gdouble THICK = 0.0;
	gdouble _tmp1_;
	gdouble BORDER = 0.0;
	gdouble _tmp2_;
	gdouble WHITE_SPACE = 0.0;
	gdouble _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble SQUARE_SIZE = 0.0;
	gdouble _tmp8_;
	gint FONT_SIZE = 0;
	gdouble _tmp9_;
#line 146 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	static const cairo_font_weight_t FONT_WEIGHT = CAIRO_FONT_WEIGHT_NORMAL;
#line 782 "sudoku-printer.c"
	gdouble* outer = NULL;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	gdouble* _tmp16_;
	gint outer_length1;
	gint _outer_size_;
	cairo_t* _tmp17_;
	cairo_t* _tmp18_;
	gdouble* _tmp19_;
	gint _tmp19__length1;
	gdouble _tmp20_;
	gdouble* _tmp21_;
	gint _tmp21__length1;
	gdouble _tmp22_;
	gdouble _tmp23_;
	gdouble _tmp24_;
	cairo_t* _tmp25_;
	cairo_t* _tmp26_;
	cairo_t* _tmp27_;
	gdouble _tmp28_;
	cairo_t* _tmp29_;
	gdouble* _tmp30_;
	gint _tmp30__length1;
	gdouble _tmp31_;
	gdouble _tmp32_;
	gdouble* _tmp33_;
	gint _tmp33__length1;
	gdouble _tmp34_;
	gdouble _tmp35_;
	gdouble _tmp36_;
	gdouble _tmp37_;
	gdouble _tmp38_;
	gdouble _tmp39_;
	cairo_t* _tmp40_;
	gdouble _tmp41_;
	gdouble _tmp42_;
	gdouble _tmp43_;
	cairo_t* _tmp44_;
	cairo_t* _tmp45_;
	gdouble _tmp46_;
	gdouble _tmp47_;
	gdouble _tmp48_;
	cairo_t* _tmp49_;
	cairo_t* _tmp50_;
	cairo_t* _tmp51_;
	gdouble _tmp52_;
	cairo_t* _tmp53_;
	gdouble* _tmp54_;
	gint _tmp54__length1;
	gdouble _tmp55_;
	gdouble _tmp56_;
	gdouble _tmp57_;
	gdouble* _tmp58_;
	gint _tmp58__length1;
	gdouble _tmp59_;
	gdouble _tmp60_;
	gdouble _tmp61_;
	gdouble _tmp62_;
	gdouble _tmp63_;
	gdouble _tmp64_;
	gdouble _tmp65_;
	gdouble _tmp66_;
	gdouble _tmp67_;
	cairo_t* _tmp68_;
	gdouble _tmp69_;
	gdouble _tmp70_;
	gdouble _tmp71_;
	cairo_t* _tmp72_;
	gdouble* pos = NULL;
	gdouble* _tmp73_;
	gint pos_length1;
	gint _pos_size_;
	gdouble position = 0.0;
	gdouble _tmp74_;
	gdouble _tmp75_;
	gdouble* _tmp76_;
	gint _tmp76__length1;
	gdouble _tmp77_;
	gdouble _tmp78_;
	gdouble _tmp79_;
	gdouble last_line = 0.0;
	cairo_t* _tmp131_;
	gint _tmp132_;
	gchar* letter = NULL;
	gchar* _tmp133_;
	cairo_text_extents_t extents = {0};
	gint* sudoku = NULL;
	SudokuBoard* _tmp134_;
	gint _tmp135_;
	gint _tmp136_;
	gint* _tmp137_;
	gint sudoku_length1;
	gint sudoku_length2;
	gboolean invert = FALSE;
	GtkTextDirection _tmp138_;
#line 129 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	g_return_if_fail (self != NULL);
#line 129 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	g_return_if_fail (cr != NULL);
#line 129 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	g_return_if_fail (sudoku_board != NULL);
#line 139 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp0_ = size;
#line 139 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	THIN = _tmp0_ / 500.0;
#line 140 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp1_ = THIN;
#line 140 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	THICK = _tmp1_ * 5;
#line 141 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp2_ = THICK;
#line 141 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	BORDER = _tmp2_;
#line 142 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp3_ = size;
#line 142 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp4_ = BORDER;
#line 142 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp5_ = THICK;
#line 142 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp6_ = THICK;
#line 142 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp7_ = THIN;
#line 142 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	WHITE_SPACE = (((_tmp3_ - (2 * _tmp4_)) - (2 * _tmp5_)) - ((N_BOXES - 1) * _tmp6_)) - ((N_BOXES * 2) * _tmp7_);
#line 143 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp8_ = WHITE_SPACE;
#line 143 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	SQUARE_SIZE = _tmp8_ / SUDOKU_SIZE;
#line 145 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp9_ = SQUARE_SIZE;
#line 145 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	FONT_SIZE = ((gint) _tmp9_) / 2;
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp10_ = offset_x;
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp11_ = offset_x;
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp12_ = size;
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp13_ = offset_y;
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp14_ = offset_y;
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp15_ = size;
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp16_ = g_new0 (gdouble, 4);
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp16_[0] = _tmp10_;
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp16_[1] = _tmp11_ + _tmp12_;
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp16_[2] = _tmp13_;
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp16_[3] = _tmp14_ + _tmp15_;
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	outer = _tmp16_;
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	outer_length1 = 4;
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_outer_size_ = outer_length1;
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp17_ = cr;
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	cairo_set_source_rgb (_tmp17_, 1.0, 1.0, 1.0);
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp18_ = cr;
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp19_ = outer;
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp19__length1 = outer_length1;
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp20_ = _tmp19_[0];
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp21_ = outer;
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp21__length1 = outer_length1;
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp22_ = _tmp21_[2];
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp23_ = size;
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp24_ = size;
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	cairo_rectangle (_tmp18_, _tmp20_, _tmp22_, _tmp23_, _tmp24_);
#line 153 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp25_ = cr;
#line 153 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	cairo_fill (_tmp25_);
#line 156 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp26_ = cr;
#line 156 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	cairo_set_line_join (_tmp26_, CAIRO_LINE_JOIN_ROUND);
#line 157 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp27_ = cr;
#line 157 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp28_ = BORDER;
#line 157 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	cairo_set_line_width (_tmp27_, _tmp28_);
#line 158 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp29_ = cr;
#line 158 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp30_ = outer;
#line 158 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp30__length1 = outer_length1;
#line 158 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp31_ = _tmp30_[0];
#line 158 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp32_ = BORDER;
#line 158 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp33_ = outer;
#line 158 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp33__length1 = outer_length1;
#line 158 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp34_ = _tmp33_[2];
#line 158 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp35_ = BORDER;
#line 158 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp36_ = size;
#line 158 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp37_ = BORDER;
#line 158 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp38_ = size;
#line 158 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp39_ = BORDER;
#line 158 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	cairo_rectangle (_tmp29_, _tmp31_ + (_tmp32_ / 2.0), _tmp34_ + (_tmp35_ / 2.0), _tmp36_ - _tmp37_, _tmp38_ - _tmp39_);
#line 161 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp40_ = cr;
#line 161 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp41_ = BACKGROUND_COLOR[0];
#line 161 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp42_ = BACKGROUND_COLOR[1];
#line 161 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp43_ = BACKGROUND_COLOR[2];
#line 161 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	cairo_set_source_rgb (_tmp40_, _tmp41_, _tmp42_, _tmp43_);
#line 162 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp44_ = cr;
#line 162 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	cairo_fill_preserve (_tmp44_);
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp45_ = cr;
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp46_ = BORDER_COLOR[0];
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp47_ = BORDER_COLOR[1];
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp48_ = BORDER_COLOR[2];
#line 164 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	cairo_set_source_rgb (_tmp45_, _tmp46_, _tmp47_, _tmp48_);
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp49_ = cr;
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	cairo_stroke (_tmp49_);
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp50_ = cr;
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	cairo_set_line_join (_tmp50_, CAIRO_LINE_JOIN_MITER);
#line 169 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp51_ = cr;
#line 169 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp52_ = THICK;
#line 169 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	cairo_set_line_width (_tmp51_, _tmp52_);
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp53_ = cr;
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp54_ = outer;
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp54__length1 = outer_length1;
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp55_ = _tmp54_[0];
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp56_ = BORDER;
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp57_ = THICK;
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp58_ = outer;
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp58__length1 = outer_length1;
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp59_ = _tmp58_[2];
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp60_ = BORDER;
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp61_ = THICK;
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp62_ = size;
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp63_ = BORDER;
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp64_ = THICK;
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp65_ = size;
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp66_ = BORDER;
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp67_ = THICK;
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	cairo_rectangle (_tmp53_, (_tmp55_ + _tmp56_) + (_tmp57_ / 2.0), (_tmp59_ + _tmp60_) + (_tmp61_ / 2.0), (_tmp62_ - (_tmp63_ * 2)) - _tmp64_, (_tmp65_ - (_tmp66_ * 2)) - _tmp67_);
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp68_ = cr;
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp69_ = LINE_COLOR[0];
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp70_ = LINE_COLOR[1];
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp71_ = LINE_COLOR[2];
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	cairo_set_source_rgb (_tmp68_, _tmp69_, _tmp70_, _tmp71_);
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp72_ = cr;
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	cairo_stroke (_tmp72_);
#line 174 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp73_ = g_new0 (gdouble, SUDOKU_SIZE + 1);
#line 174 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	pos = _tmp73_;
#line 174 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	pos_length1 = SUDOKU_SIZE + 1;
#line 174 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_pos_size_ = pos_length1;
#line 175 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp74_ = BORDER;
#line 175 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp75_ = THICK;
#line 175 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	position = _tmp74_ + _tmp75_;
#line 176 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp76_ = pos;
#line 176 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp76__length1 = pos_length1;
#line 176 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp77_ = position;
#line 176 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp78_ = SQUARE_SIZE;
#line 176 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp76_[0] = _tmp77_ + (_tmp78_ / 2.0);
#line 176 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp79_ = _tmp76_[0];
#line 177 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	last_line = 0.0;
#line 1130 "sudoku-printer.c"
	{
		gint n = 0;
#line 179 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		n = 1;
#line 1135 "sudoku-printer.c"
		{
			gboolean _tmp80_ = FALSE;
#line 179 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp80_ = TRUE;
#line 179 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			while (TRUE) {
#line 1142 "sudoku-printer.c"
				gint _tmp82_;
				gint _tmp83_;
				gdouble* _tmp98_;
				gint _tmp98__length1;
				gint _tmp99_;
				gdouble _tmp100_;
				gdouble _tmp101_;
				gdouble _tmp102_;
				gdouble _tmp103_;
				cairo_t* _tmp104_;
				gdouble _tmp105_;
				gdouble _tmp106_;
				gdouble _tmp107_;
				gdouble _tmp108_;
				gdouble _tmp109_;
				cairo_t* _tmp110_;
				gdouble _tmp111_;
				gdouble _tmp112_;
				gdouble _tmp113_;
				gdouble _tmp114_;
				gdouble _tmp115_;
				gdouble _tmp116_;
				cairo_t* _tmp117_;
				gdouble _tmp118_;
				gdouble _tmp119_;
				gdouble _tmp120_;
				gdouble _tmp121_;
				gdouble _tmp122_;
				cairo_t* _tmp123_;
				gdouble _tmp124_;
				gdouble _tmp125_;
				gdouble _tmp126_;
				gdouble _tmp127_;
				gdouble _tmp128_;
				gdouble _tmp129_;
				cairo_t* _tmp130_;
#line 179 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				if (!_tmp80_) {
#line 1181 "sudoku-printer.c"
					gint _tmp81_;
#line 179 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					_tmp81_ = n;
#line 179 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					n = _tmp81_ + 1;
#line 1187 "sudoku-printer.c"
				}
#line 179 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp80_ = FALSE;
#line 179 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp82_ = n;
#line 179 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				if (!(_tmp82_ <= SUDOKU_SIZE)) {
#line 179 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					break;
#line 1197 "sudoku-printer.c"
				}
#line 181 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp83_ = n;
#line 181 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				if ((_tmp83_ % N_BOXES) == 0) {
#line 1203 "sudoku-printer.c"
					cairo_t* _tmp84_;
					gdouble _tmp85_;
					gdouble _tmp86_;
					gdouble _tmp87_;
					gdouble _tmp88_;
					gdouble _tmp89_;
					gdouble _tmp90_;
#line 183 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					_tmp84_ = cr;
#line 183 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					_tmp85_ = THICK;
#line 183 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					cairo_set_line_width (_tmp84_, _tmp85_);
#line 184 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					_tmp86_ = position;
#line 184 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					_tmp87_ = SQUARE_SIZE;
#line 184 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					_tmp88_ = last_line;
#line 184 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					_tmp89_ = THICK;
#line 184 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					position = _tmp86_ + ((_tmp87_ + (_tmp88_ / 2.0)) + (_tmp89_ / 2.0));
#line 185 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					_tmp90_ = THICK;
#line 185 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					last_line = _tmp90_;
#line 1231 "sudoku-printer.c"
				} else {
					cairo_t* _tmp91_;
					gdouble _tmp92_;
					gdouble _tmp93_;
					gdouble _tmp94_;
					gdouble _tmp95_;
					gdouble _tmp96_;
					gdouble _tmp97_;
#line 189 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					_tmp91_ = cr;
#line 189 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					_tmp92_ = THIN;
#line 189 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					cairo_set_line_width (_tmp91_, _tmp92_);
#line 190 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					_tmp93_ = position;
#line 190 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					_tmp94_ = SQUARE_SIZE;
#line 190 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					_tmp95_ = last_line;
#line 190 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					_tmp96_ = THIN;
#line 190 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					position = _tmp93_ + ((_tmp94_ + (_tmp95_ / 2.0)) + (_tmp96_ / 2.0));
#line 191 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					_tmp97_ = THIN;
#line 191 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					last_line = _tmp97_;
#line 1260 "sudoku-printer.c"
				}
#line 194 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp98_ = pos;
#line 194 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp98__length1 = pos_length1;
#line 194 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp99_ = n;
#line 194 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp100_ = position;
#line 194 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp101_ = last_line;
#line 194 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp102_ = SQUARE_SIZE;
#line 194 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp98_[_tmp99_] = (_tmp100_ + (_tmp101_ / 2.0)) + (_tmp102_ / 2.0);
#line 194 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp103_ = _tmp98_[_tmp99_];
#line 195 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp104_ = cr;
#line 195 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp105_ = BORDER;
#line 195 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp106_ = THICK;
#line 195 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp107_ = offset_x;
#line 195 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp108_ = position;
#line 195 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp109_ = offset_y;
#line 195 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				cairo_move_to (_tmp104_, (_tmp105_ + (_tmp106_ / 2.0)) + _tmp107_, _tmp108_ + _tmp109_);
#line 196 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp110_ = cr;
#line 196 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp111_ = size;
#line 196 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp112_ = BORDER;
#line 196 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp113_ = THICK;
#line 196 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp114_ = offset_x;
#line 196 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp115_ = position;
#line 196 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp116_ = offset_y;
#line 196 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				cairo_line_to (_tmp110_, ((_tmp111_ - _tmp112_) - (_tmp113_ / 2.0)) + _tmp114_, _tmp115_ + _tmp116_);
#line 197 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp117_ = cr;
#line 197 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp118_ = position;
#line 197 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp119_ = offset_x;
#line 197 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp120_ = BORDER;
#line 197 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp121_ = THICK;
#line 197 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp122_ = offset_y;
#line 197 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				cairo_move_to (_tmp117_, _tmp118_ + _tmp119_, (_tmp120_ + (_tmp121_ / 2.0)) + _tmp122_);
#line 198 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp123_ = cr;
#line 198 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp124_ = position;
#line 198 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp125_ = offset_x;
#line 198 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp126_ = size;
#line 198 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp127_ = BORDER;
#line 198 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp128_ = THICK;
#line 198 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp129_ = offset_y;
#line 198 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				cairo_line_to (_tmp123_, _tmp124_ + _tmp125_, ((_tmp126_ - _tmp127_) - (_tmp128_ / 2.0)) + _tmp129_);
#line 199 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp130_ = cr;
#line 199 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				cairo_stroke (_tmp130_);
#line 1342 "sudoku-printer.c"
			}
		}
	}
#line 202 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp131_ = cr;
#line 202 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp132_ = FONT_SIZE;
#line 202 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	cairo_set_font_size (_tmp131_, (gdouble) _tmp132_);
#line 203 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp133_ = g_strdup ("");
#line 203 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	letter = _tmp133_;
#line 205 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp134_ = sudoku_board;
#line 205 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp137_ = sudoku_board_get_cells (_tmp134_, &_tmp135_, &_tmp136_);
#line 205 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	sudoku = _tmp137_;
#line 205 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	sudoku_length1 = _tmp135_;
#line 205 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	sudoku_length2 = _tmp136_;
#line 207 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_tmp138_ = gtk_widget_get_default_direction ();
#line 207 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	invert = _tmp138_ == GTK_TEXT_DIR_RTL;
#line 1370 "sudoku-printer.c"
	{
		gint x = 0;
#line 209 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
		x = 0;
#line 1375 "sudoku-printer.c"
		{
			gboolean _tmp139_ = FALSE;
#line 209 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			_tmp139_ = TRUE;
#line 209 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
			while (TRUE) {
#line 1382 "sudoku-printer.c"
				gint _tmp141_;
				gint _tmp142_ = 0;
				gboolean _tmp143_;
				gint real_x = 0;
#line 209 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				if (!_tmp139_) {
#line 1389 "sudoku-printer.c"
					gint _tmp140_;
#line 209 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					_tmp140_ = x;
#line 209 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					x = _tmp140_ + 1;
#line 1395 "sudoku-printer.c"
				}
#line 209 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp139_ = FALSE;
#line 209 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp141_ = x;
#line 209 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				if (!(_tmp141_ < SUDOKU_SIZE)) {
#line 209 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					break;
#line 1405 "sudoku-printer.c"
				}
#line 211 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				_tmp143_ = invert;
#line 211 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				if (_tmp143_) {
#line 1411 "sudoku-printer.c"
					gint _tmp144_;
#line 211 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					_tmp144_ = x;
#line 211 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					_tmp142_ = (SUDOKU_SIZE - _tmp144_) - 1;
#line 1417 "sudoku-printer.c"
				} else {
					gint _tmp145_;
#line 211 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					_tmp145_ = x;
#line 211 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					_tmp142_ = _tmp145_;
#line 1424 "sudoku-printer.c"
				}
#line 211 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
				real_x = _tmp142_;
#line 1428 "sudoku-printer.c"
				{
					gint y = 0;
#line 212 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
					y = 0;
#line 1433 "sudoku-printer.c"
					{
						gboolean _tmp146_ = FALSE;
#line 212 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
						_tmp146_ = TRUE;
#line 212 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
						while (TRUE) {
#line 1440 "sudoku-printer.c"
							gint _tmp148_;
							cairo_t* _tmp149_;
							gdouble* _tmp150_;
							gint _tmp150__length1;
							gint _tmp151_;
							gdouble _tmp152_;
							gdouble _tmp153_;
							gdouble* _tmp154_;
							gint _tmp154__length1;
							gint _tmp155_;
							gdouble _tmp156_;
							gdouble _tmp157_;
							gchar* _tmp158_;
							gint* _tmp159_;
							gint _tmp159__length1;
							gint _tmp159__length2;
							gint _tmp160_;
							gint _tmp161_;
							gint _tmp162_;
#line 212 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
							if (!_tmp146_) {
#line 1462 "sudoku-printer.c"
								gint _tmp147_;
#line 212 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp147_ = y;
#line 212 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								y = _tmp147_ + 1;
#line 1468 "sudoku-printer.c"
							}
#line 212 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
							_tmp146_ = FALSE;
#line 212 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
							_tmp148_ = y;
#line 212 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
							if (!(_tmp148_ < SUDOKU_SIZE)) {
#line 212 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								break;
#line 1478 "sudoku-printer.c"
							}
#line 214 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
							_tmp149_ = cr;
#line 214 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
							_tmp150_ = pos;
#line 214 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
							_tmp150__length1 = pos_length1;
#line 214 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
							_tmp151_ = x;
#line 214 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
							_tmp152_ = _tmp150_[_tmp151_];
#line 214 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
							_tmp153_ = offset_x;
#line 214 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
							_tmp154_ = pos;
#line 214 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
							_tmp154__length1 = pos_length1;
#line 214 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
							_tmp155_ = y;
#line 214 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
							_tmp156_ = _tmp154_[_tmp155_];
#line 214 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
							_tmp157_ = offset_y;
#line 214 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
							cairo_move_to (_tmp149_, _tmp152_ + _tmp153_, _tmp156_ + _tmp157_);
#line 215 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
							_tmp158_ = g_strdup ("");
#line 215 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
							_g_free0 (letter);
#line 215 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
							letter = _tmp158_;
#line 217 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
							_tmp159_ = sudoku;
#line 217 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
							_tmp159__length1 = sudoku_length1;
#line 217 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
							_tmp159__length2 = sudoku_length2;
#line 217 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
							_tmp160_ = y;
#line 217 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
							_tmp161_ = real_x;
#line 217 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
							_tmp162_ = _tmp159_[(_tmp160_ * _tmp159__length2) + _tmp161_];
#line 217 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
							if (_tmp162_ != 0) {
#line 1524 "sudoku-printer.c"
								gint* _tmp163_;
								gint _tmp163__length1;
								gint _tmp163__length2;
								gint _tmp164_;
								gint _tmp165_;
								gint _tmp166_;
								gchar* _tmp167_;
								SudokuBoard* _tmp168_;
								gboolean* _tmp169_;
								gint _tmp169__length1;
								gint _tmp169__length2;
								gint _tmp170_;
								gint _tmp171_;
								gboolean _tmp172_;
								cairo_t* _tmp180_;
								const gchar* _tmp181_;
								cairo_text_extents_t _tmp182_ = {0};
								cairo_t* _tmp183_;
								gdouble* _tmp184_;
								gint _tmp184__length1;
								gint _tmp185_;
								gdouble _tmp186_;
								gdouble _tmp187_;
								cairo_text_extents_t _tmp188_;
								gdouble _tmp189_;
								gdouble* _tmp190_;
								gint _tmp190__length1;
								gint _tmp191_;
								gdouble _tmp192_;
								gdouble _tmp193_;
								cairo_text_extents_t _tmp194_;
								gdouble _tmp195_;
								cairo_t* _tmp196_;
								const gchar* _tmp197_;
#line 219 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp163_ = sudoku;
#line 219 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp163__length1 = sudoku_length1;
#line 219 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp163__length2 = sudoku_length2;
#line 219 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp164_ = y;
#line 219 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp165_ = real_x;
#line 219 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp166_ = _tmp163_[(_tmp164_ * _tmp163__length2) + _tmp165_];
#line 219 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp167_ = g_strdup_printf ("%i", _tmp166_);
#line 219 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_g_free0 (letter);
#line 219 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								letter = _tmp167_;
#line 221 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp168_ = sudoku_board;
#line 221 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp169_ = _tmp168_->is_fixed;
#line 221 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp169__length1 = _tmp168_->is_fixed_length1;
#line 221 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp169__length2 = _tmp168_->is_fixed_length2;
#line 221 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp170_ = y;
#line 221 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp171_ = real_x;
#line 221 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp172_ = _tmp169_[(_tmp170_ * _tmp169__length2) + _tmp171_];
#line 221 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								if (_tmp172_) {
#line 1593 "sudoku-printer.c"
									cairo_t* _tmp173_;
									cairo_t* _tmp174_;
#line 223 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
									_tmp173_ = cr;
#line 223 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
									cairo_select_font_face (_tmp173_, "Sans", CAIRO_FONT_SLANT_NORMAL, FONT_WEIGHT);
#line 224 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
									_tmp174_ = cr;
#line 224 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
									cairo_set_source_rgb (_tmp174_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
#line 1604 "sudoku-printer.c"
								} else {
									cairo_t* _tmp175_;
									cairo_t* _tmp176_;
									gdouble _tmp177_;
									gdouble _tmp178_;
									gdouble _tmp179_;
#line 228 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
									_tmp175_ = cr;
#line 228 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
									cairo_select_font_face (_tmp175_, "Sans", CAIRO_FONT_SLANT_ITALIC, FONT_WEIGHT);
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
									_tmp176_ = cr;
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
									_tmp177_ = PENCIL_GREY[0];
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
									_tmp178_ = PENCIL_GREY[1];
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
									_tmp179_ = PENCIL_GREY[2];
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
									cairo_set_source_rgb (_tmp176_, _tmp177_, _tmp178_, _tmp179_);
#line 1625 "sudoku-printer.c"
								}
#line 231 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp180_ = cr;
#line 231 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp181_ = letter;
#line 231 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								cairo_text_extents (_tmp180_, _tmp181_, &_tmp182_);
#line 231 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								extents = _tmp182_;
#line 232 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp183_ = cr;
#line 232 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp184_ = pos;
#line 232 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp184__length1 = pos_length1;
#line 232 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp185_ = x;
#line 232 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp186_ = _tmp184_[_tmp185_];
#line 232 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp187_ = offset_x;
#line 232 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp188_ = extents;
#line 232 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp189_ = _tmp188_.x_advance;
#line 232 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp190_ = pos;
#line 232 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp190__length1 = pos_length1;
#line 232 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp191_ = y;
#line 232 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp192_ = _tmp190_[_tmp191_];
#line 232 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp193_ = offset_y;
#line 232 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp194_ = extents;
#line 232 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp195_ = _tmp194_.height;
#line 232 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								cairo_move_to (_tmp183_, (_tmp186_ + _tmp187_) - (_tmp189_ / 2.0), (_tmp192_ + _tmp193_) + (_tmp195_ / 2.0));
#line 233 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp196_ = cr;
#line 233 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								_tmp197_ = letter;
#line 233 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
								cairo_show_text (_tmp196_, _tmp197_);
#line 1673 "sudoku-printer.c"
							}
						}
					}
				}
			}
		}
	}
#line 129 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	sudoku = (g_free (sudoku), NULL);
#line 129 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_g_free0 (letter);
#line 129 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	pos = (g_free (pos), NULL);
#line 129 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	outer = (g_free (outer), NULL);
#line 1689 "sudoku-printer.c"
}


static void sudoku_printer_class_init (SudokuPrinterClass * klass) {
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	sudoku_printer_parent_class = g_type_class_peek_parent (klass);
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	g_type_class_add_private (klass, sizeof (SudokuPrinterPrivate));
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_printer_finalize;
#line 1700 "sudoku-printer.c"
}


static void sudoku_printer_instance_init (SudokuPrinter * self) {
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	self->priv = SUDOKU_PRINTER_GET_PRIVATE (self);
#line 1707 "sudoku-printer.c"
}


static void sudoku_printer_finalize (GObject * obj) {
	SudokuPrinter * self;
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_PRINTER, SudokuPrinter);
#line 27 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (self->priv->boards);
#line 28 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (self->priv->window);
#line 34 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (self->priv->print_op);
#line 25 "/home/mcatanzaro/Projects/GNOME/gnome-sudoku/src/sudoku-printer.vala"
	G_OBJECT_CLASS (sudoku_printer_parent_class)->finalize (obj);
#line 1723 "sudoku-printer.c"
}


GType sudoku_printer_get_type (void) {
	static volatile gsize sudoku_printer_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_printer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuPrinterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_printer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuPrinter), 0, (GInstanceInitFunc) sudoku_printer_instance_init, NULL };
		GType sudoku_printer_type_id;
		sudoku_printer_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuPrinter", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_printer_type_id__volatile, sudoku_printer_type_id);
	}
	return sudoku_printer_type_id__volatile;
}



