/* -- THIS FILE IS GENERATED - DO NOT EDIT *//* -*- Mode: C; c-basic-offset: 4 -*- */

#define PY_SSIZE_T_CLEAN
#include <Python.h>




#if PY_VERSION_HEX < 0x02050000
typedef int Py_ssize_t;
#define PY_SSIZE_T_MAX INT_MAX
#define PY_SSIZE_T_MIN INT_MIN
typedef inquiry lenfunc;
typedef intargfunc ssizeargfunc;
typedef intobjargproc ssizeobjargproc;
#endif


#line 4 "gnome.override"
#include <Python.h>

#include <signal.h>
#include <locale.h>

#define NO_IMPORT_PYGOBJECT
#include "pygobject.h"
#include <libgnome/libgnome.h>
#include <libgnome/libgnometypebuiltins.h>
#include <popt.h>
#include <config.h>
#ifdef HAVE_PRCTL
#include <sys/prctl.h>
#endif
#ifdef HAVE_SETPROCTITLE
#include <sys/types.h>
#include <unistd.h>
#endif
#include "config.h"

static struct poptOption * popt_build_table   (PyObject          *table);
static void                popt_destroy_table (struct poptOption *table);


#line 45 "gnome.c"


/* ---------- types from other modules ---------- */
static PyTypeObject *_PyGObject_Type;
#define PyGObject_Type (*_PyGObject_Type)


/* ---------- forward type declarations ---------- */
PyTypeObject G_GNUC_INTERNAL PyGnomeModuleInfo_Type;
PyTypeObject G_GNUC_INTERNAL PyGnomeProgram_Type;

#line 57 "gnome.c"



/* ----------- GnomeModuleInfo ----------- */

static int
pygobject_no_constructor(PyObject *self, PyObject *args, PyObject *kwargs)
{
    gchar buf[512];

    g_snprintf(buf, sizeof(buf), "%s is an abstract widget", self->ob_type->tp_name);
    PyErr_SetString(PyExc_NotImplementedError, buf);
    return -1;
}

static PyObject *
_wrap_gnome_module_info__get_name(PyObject *self, void *closure)
{
    const gchar *ret;

    ret = pyg_boxed_get(self, GnomeModuleInfo)->name;
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gnome_module_info__get_version(PyObject *self, void *closure)
{
    const gchar *ret;

    ret = pyg_boxed_get(self, GnomeModuleInfo)->version;
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gnome_module_info__get_description(PyObject *self, void *closure)
{
    const gchar *ret;

    ret = pyg_boxed_get(self, GnomeModuleInfo)->description;
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static const PyGetSetDef gnome_module_info_getsets[] = {
    { "name", (getter)_wrap_gnome_module_info__get_name, (setter)0 },
    { "version", (getter)_wrap_gnome_module_info__get_version, (setter)0 },
    { "description", (getter)_wrap_gnome_module_info__get_description, (setter)0 },
    { NULL, (getter)0, (setter)0 },
};

PyTypeObject G_GNUC_INTERNAL PyGnomeModuleInfo_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "gnome.GnomeModuleInfo",                   /* tp_name */
    sizeof(PyGBoxed),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)NULL, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)gnome_module_info_getsets,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)pygobject_no_constructor,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- GnomeProgram ----------- */

static PyObject *
_wrap_gnome_program_get_human_readable_name(PyGObject *self)
{
    const gchar *ret;

    
    ret = gnome_program_get_human_readable_name(GNOME_PROGRAM(self->obj));
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gnome_program_get_app_id(PyGObject *self)
{
    const gchar *ret;

    
    ret = gnome_program_get_app_id(GNOME_PROGRAM(self->obj));
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gnome_program_get_app_version(PyGObject *self)
{
    const gchar *ret;

    
    ret = gnome_program_get_app_version(GNOME_PROGRAM(self->obj));
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

#line 686 "gnome.override"
static PyObject *
_wrap_gnome_program_locate_file(PyGObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "domain", "file_name", "only_if_exists", NULL };
    PyObject *py_domain = NULL;
    GnomeFileDomain domain;
    char *file_name;
    int only_if_exists, i;
    GSList *ret_locations = NULL, *l;
    PyObject *py_ret_locations;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "Osi:GnomeProgram.locate_file",
                                     kwlist, &py_domain, &file_name, &only_if_exists))
        return NULL;
    if (pyg_enum_get_value(GNOME_TYPE_FILE_DOMAIN, py_domain, (gint *)&domain))
        return NULL;
    gnome_program_locate_file(GNOME_PROGRAM(self->obj), domain, file_name,
                              only_if_exists, &ret_locations);
    py_ret_locations = PyList_New(g_slist_length(ret_locations));
    for (l = ret_locations, i = 0; l; l = l->next, ++i) {
        PyList_SET_ITEM(py_ret_locations, i, PyString_FromString(l->data));
        g_free(l->data);
    }
    g_slist_free(ret_locations);
    return py_ret_locations;
}
#line 234 "gnome.c"


static PyObject *
_wrap_gnome_program_parse_args(PyGObject *self)
{
    
    gnome_program_parse_args(GNOME_PROGRAM(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gnome_program_postinit(PyGObject *self)
{
    
    gnome_program_postinit(GNOME_PROGRAM(self->obj));
    
    Py_INCREF(Py_None);
    return Py_None;
}

#line 558 "gnome.override"
static PyObject *
_wrap_gnome_get_popt_args(PyGObject *self, PyObject *args)
{
    PyObject *argdict, *leftover_args;

    argdict = g_object_get_data(G_OBJECT(self->obj),
                                "gnome-python-popt-argdict");
    leftover_args = g_object_get_data(G_OBJECT(self->obj),
                                      "gnome-python-popt-leftover-args");
    if (argdict) {
        Py_INCREF(argdict);
    } else
        argdict = PyDict_New();

    if (leftover_args) {
        Py_INCREF(leftover_args);
    } else
        leftover_args = PyList_New(0);

    return Py_BuildValue("(NN)", leftover_args, argdict);
}

#line 280 "gnome.c"


static const PyMethodDef _PyGnomeProgram_methods[] = {
    { "get_human_readable_name", (PyCFunction)_wrap_gnome_program_get_human_readable_name, METH_NOARGS,
      NULL },
    { "get_app_id", (PyCFunction)_wrap_gnome_program_get_app_id, METH_NOARGS,
      NULL },
    { "get_app_version", (PyCFunction)_wrap_gnome_program_get_app_version, METH_NOARGS,
      NULL },
    { "locate_file", (PyCFunction)_wrap_gnome_program_locate_file, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "parse_args", (PyCFunction)_wrap_gnome_program_parse_args, METH_NOARGS,
      NULL },
    { "postinit", (PyCFunction)_wrap_gnome_program_postinit, METH_NOARGS,
      NULL },
    { "get_popt_args", (PyCFunction)_wrap_gnome_get_popt_args, METH_NOARGS,
      NULL },
    { NULL, NULL, 0, NULL }
};

PyTypeObject G_GNUC_INTERNAL PyGnomeProgram_Type = {
    PyObject_HEAD_INIT(NULL)
    0,                                 /* ob_size */
    "gnome.Program",                   /* tp_name */
    sizeof(PyGObject),          /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)0,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)0,       /* tp_getattr */
    (setattrfunc)0,       /* tp_setattr */
    (cmpfunc)0,           /* tp_compare */
    (reprfunc)0,             /* tp_repr */
    (PyNumberMethods*)0,     /* tp_as_number */
    (PySequenceMethods*)0, /* tp_as_sequence */
    (PyMappingMethods*)0,   /* tp_as_mapping */
    (hashfunc)0,             /* tp_hash */
    (ternaryfunc)0,          /* tp_call */
    (reprfunc)0,              /* tp_str */
    (getattrofunc)0,     /* tp_getattro */
    (setattrofunc)0,     /* tp_setattro */
    (PyBufferProcs*)0,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)0,     /* tp_traverse */
    (inquiry)0,             /* tp_clear */
    (richcmpfunc)0,   /* tp_richcompare */
    offsetof(PyGObject, weakreflist),             /* tp_weaklistoffset */
    (getiterfunc)0,          /* tp_iter */
    (iternextfunc)0,     /* tp_iternext */
    (struct PyMethodDef*)_PyGnomeProgram_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    (struct PyGetSetDef*)0,  /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)0,    /* tp_descr_get */
    (descrsetfunc)0,    /* tp_descr_set */
    offsetof(PyGObject, inst_dict),                 /* tp_dictoffset */
    (initproc)0,             /* tp_init */
    (allocfunc)0,           /* tp_alloc */
    (newfunc)0,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)0              /* tp_is_gc */
};



/* ----------- functions ----------- */

static PyObject *
_wrap_gnome_config_set_string_(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "path", "value", "priv", NULL };
    char *path, *value;
    int priv;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"ssi:config_set_string_", kwlist, &path, &value, &priv))
        return NULL;
    
    gnome_config_set_string_(path, value, priv);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gnome_config_set_translated_string_(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "path", "value", "priv", NULL };
    char *path, *value;
    int priv;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"ssi:config_set_translated_string_", kwlist, &path, &value, &priv))
        return NULL;
    
    gnome_config_set_translated_string_(path, value, priv);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gnome_config_set_int_(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "path", "value", "priv", NULL };
    char *path;
    int value, priv;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"sii:config_set_int_", kwlist, &path, &value, &priv))
        return NULL;
    
    gnome_config_set_int_(path, value, priv);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gnome_config_set_float_(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "path", "value", "priv", NULL };
    char *path;
    double value;
    int priv;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"sdi:config_set_float_", kwlist, &path, &value, &priv))
        return NULL;
    
    gnome_config_set_float_(path, value, priv);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gnome_config_set_bool_(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "path", "value", "priv", NULL };
    char *path;
    int value, priv;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"sii:config_set_bool_", kwlist, &path, &value, &priv))
        return NULL;
    
    gnome_config_set_bool_(path, value, priv);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gnome_config_has_section_(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "path", "priv", NULL };
    char *path;
    int priv, ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"si:config_has_section_", kwlist, &path, &priv))
        return NULL;
    
    ret = gnome_config_has_section_(path, priv);
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gnome_config_drop_all(PyObject *self)
{
    
    gnome_config_drop_all();
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gnome_config_sync(PyObject *self)
{
    int ret;

    
    ret = gnome_config_sync();
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gnome_config_sync_file_(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "path", "priv", NULL };
    char *path;
    int priv, ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"si:config_sync_file_", kwlist, &path, &priv))
        return NULL;
    
    ret = gnome_config_sync_file_(path, priv);
    
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gnome_config_drop_file_(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "path", "priv", NULL };
    char *path;
    int priv;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"si:config_drop_file_", kwlist, &path, &priv))
        return NULL;
    
    gnome_config_drop_file_(path, priv);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gnome_config_clean_file_(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "path", "priv", NULL };
    char *path;
    int priv;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"si:config_clean_file_", kwlist, &path, &priv))
        return NULL;
    
    gnome_config_clean_file_(path, priv);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gnome_config_clean_section_(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "path", "priv", NULL };
    char *path;
    int priv;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"si:config_clean_section_", kwlist, &path, &priv))
        return NULL;
    
    gnome_config_clean_section_(path, priv);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gnome_config_clean_key_(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "path", "priv", NULL };
    char *path;
    int priv;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"si:config_clean_key_", kwlist, &path, &priv))
        return NULL;
    
    gnome_config_clean_key_(path, priv);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gnome_config_push_prefix(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "path", NULL };
    char *path;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:config_push_prefix", kwlist, &path))
        return NULL;
    
    gnome_config_push_prefix(path);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gnome_config_pop_prefix(PyObject *self)
{
    
    gnome_config_pop_prefix();
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gnome_execute_shell(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "dir", "commandline", NULL };
    char *dir, *commandline;
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"ss:execute_shell", kwlist, &dir, &commandline))
        return NULL;
    
    ret = gnome_execute_shell(dir, commandline);
    
    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_gnome_execute_shell_fds(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "dir", "commandline", "close_fds", NULL };
    char *dir, *commandline;
    int close_fds, ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"ssi:execute_shell_fds", kwlist, &dir, &commandline, &close_fds))
        return NULL;
    
    ret = gnome_execute_shell_fds(dir, commandline, close_fds);
    
    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_gnome_execute_terminal_shell(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "dir", "commandline", NULL };
    char *dir, *commandline;
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"ss:execute_terminal_shell", kwlist, &dir, &commandline))
        return NULL;
    
    ret = gnome_execute_terminal_shell(dir, commandline);
    
    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_gnome_execute_terminal_shell_fds(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "dir", "commandline", "close_fds", NULL };
    char *dir, *commandline;
    int close_fds, ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"ssi:execute_terminal_shell_fds", kwlist, &dir, &commandline, &close_fds))
        return NULL;
    
    ret = gnome_execute_terminal_shell_fds(dir, commandline, close_fds);
    
    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_gnome_gconf_get_gnome_libs_settings_relative(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "subkey", NULL };
    char *subkey;
    gchar *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:gconf_get_gnome_libs_settings_relative", kwlist, &subkey))
        return NULL;
    
    ret = gnome_gconf_get_gnome_libs_settings_relative(subkey);
    
    if (ret) {
        PyObject *py_ret = PyString_FromString(ret);
        g_free(ret);
        return py_ret;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gnome_gconf_get_app_settings_relative(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "program", "subkey", NULL };
    PyGObject *program;
    char *subkey;
    gchar *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!s:gconf_get_app_settings_relative", kwlist, &PyGnomeProgram_Type, &program, &subkey))
        return NULL;
    
    ret = gnome_gconf_get_app_settings_relative(GNOME_PROGRAM(program->obj), subkey);
    
    if (ret) {
        PyObject *py_ret = PyString_FromString(ret);
        g_free(ret);
        return py_ret;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

#line 655 "gnome.override"
static PyObject *
_wrap_gnome_help_display(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "doc_name", "link_id", NULL };
    char *doc_name, *link_id = NULL;
    int ret;
    GError *error = NULL;
    PyObject *py_ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s|z:help_display", kwlist, &doc_name, &link_id))
        return NULL;
    ret = gnome_help_display(doc_name, link_id, &error);
    if (pyg_error_check(&error))
        return NULL;
    py_ret = ret ? Py_True : Py_False;
    Py_INCREF(py_ret);
    return py_ret;
}
#line 696 "gnome.c"


static PyObject *
_wrap_gnome_help_display_with_doc_id(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "program", "doc_id", "file_name", "link_id", NULL };
    PyGObject *program;
    char *doc_id, *file_name, *link_id;
    int ret;
    GError *error = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!sss:help_display_with_doc_id", kwlist, &PyGnomeProgram_Type, &program, &doc_id, &file_name, &link_id))
        return NULL;
    
    ret = gnome_help_display_with_doc_id(GNOME_PROGRAM(program->obj), doc_id, file_name, link_id, &error);
    
    if (pyg_error_check(&error))
        return NULL;
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gnome_help_display_desktop(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "program", "doc_id", "file_name", "link_id", NULL };
    PyGObject *program;
    char *doc_id, *file_name, *link_id;
    int ret;
    GError *error = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O!sss:help_display_desktop", kwlist, &PyGnomeProgram_Type, &program, &doc_id, &file_name, &link_id))
        return NULL;
    
    ret = gnome_help_display_desktop(GNOME_PROGRAM(program->obj), doc_id, file_name, link_id, &error);
    
    if (pyg_error_check(&error))
        return NULL;
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gnome_help_display_uri(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "help_uri", NULL };
    char *help_uri;
    int ret;
    GError *error = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:help_display_uri", kwlist, &help_uri))
        return NULL;
    
    ret = gnome_help_display_uri(help_uri, &error);
    
    if (pyg_error_check(&error))
        return NULL;
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_gnome_i18n_push_c_numeric_locale(PyObject *self)
{
    
    gnome_i18n_push_c_numeric_locale();
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gnome_i18n_pop_c_numeric_locale(PyObject *self)
{
    
    gnome_i18n_pop_c_numeric_locale();
    
    Py_INCREF(Py_None);
    return Py_None;
}

#line 675 "gnome.override"
static PyObject *
_wrap_libgnome_module_info_get(PyObject *self)
{
    GnomeModuleInfo *ret;

    ret = (GnomeModuleInfo *) libgnome_module_info_get();
    /* pyg_boxed_new handles NULL checking */
    return pyg_boxed_new(GNOME_TYPE_MODULE_INFO, ret, TRUE, TRUE);
}
#line 788 "gnome.c"


#line 714 "gnome.override"
static PyObject *
_wrap_gnome_bonobo_module_info_get(PyObject *self)
{
    GnomeModuleInfo *ret;

    ret = (GnomeModuleInfo *) gnome_bonobo_module_info_get();
    /* pyg_boxed_new handles NULL checking */
    return pyg_boxed_new(GNOME_TYPE_MODULE_INFO, ret, TRUE, TRUE);
}
#line 801 "gnome.c"


static PyObject *
_wrap_gnome_user_dir_get(PyObject *self)
{
    const gchar *ret;

    
    ret = gnome_user_dir_get();
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gnome_user_private_dir_get(PyObject *self)
{
    const gchar *ret;

    
    ret = gnome_user_private_dir_get();
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gnome_user_accels_dir_get(PyObject *self)
{
    const gchar *ret;

    
    ret = gnome_user_accels_dir_get();
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gnome_program_get(PyObject *self)
{
    GnomeProgram *ret;

    
    ret = gnome_program_get();
    
    /* pygobject_new handles NULL checking */
    return pygobject_new((GObject *)ret);
}

static PyObject *
_wrap_gnome_program_module_register(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "module_info", NULL };
    PyObject *py_module_info;
    GnomeModuleInfo *module_info = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:program_module_register", kwlist, &py_module_info))
        return NULL;
    if (pyg_boxed_check(py_module_info, GNOME_TYPE_MODULE_INFO))
        module_info = pyg_boxed_get(py_module_info, GnomeModuleInfo);
    else {
        PyErr_SetString(PyExc_TypeError, "module_info should be a GnomeModuleInfo");
        return NULL;
    }
    
    gnome_program_module_register(module_info);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gnome_program_module_registered(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "module_info", NULL };
    PyObject *py_module_info;
    int ret;
    GnomeModuleInfo *module_info = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"O:program_module_registered", kwlist, &py_module_info))
        return NULL;
    if (pyg_boxed_check(py_module_info, GNOME_TYPE_MODULE_INFO))
        module_info = pyg_boxed_get(py_module_info, GnomeModuleInfo);
    else {
        PyErr_SetString(PyExc_TypeError, "module_info should be a GnomeModuleInfo");
        return NULL;
    }
    
    ret = gnome_program_module_registered(module_info);
    
    return PyBool_FromLong(ret);

}

#line 725 "gnome.override"
static PyObject *
_wrap_gnome_program_module_load(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "mod_name", NULL };
    char *mod_name;
    GnomeModuleInfo *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "s:program_module_load", kwlist, &mod_name))
        return NULL;
    ret = (GnomeModuleInfo *) gnome_program_module_load(mod_name);
    /* pyg_boxed_new handles NULL checking */
    return pyg_boxed_new(GNOME_TYPE_MODULE_INFO, ret, TRUE, TRUE);
}

#line 918 "gnome.c"


#line 37 "gnome.override"

static void __py_object_free(gpointer data)
{
    Py_DECREF((PyObject *) data);
}

static void
popt_cb(poptContext con, 
        enum poptCallbackReason reason, 
        const struct poptOption *opt, 
        const char *arg, void *data)
{
    PyObject *dict = data;
    PyObject *item = NULL, *existing;
    PyObject *key;
    char aux[] = " ";

    switch (opt->argInfo & POPT_ARG_MASK) {
    case POPT_ARG_INT:
        item = PyInt_FromLong(*(int *)(opt->arg));
        break;
    case POPT_ARG_DOUBLE:
        item = PyFloat_FromDouble(*(double *)(opt->arg));
        break;
    case POPT_ARG_STRING:
        item = PyString_FromString(arg);
        break;
    case POPT_ARG_LONG:
        item = PyLong_FromLong(*(long *)(opt->arg));
        break;
    case POPT_ARG_NONE:
        item = PyInt_FromLong(1L);
        break;
    default:
        break;
    }
    if (!item)
        return;

    if (opt->longName) {
        key = PyString_FromString(opt->longName);
    } else {
        aux[0] = opt->shortName;
        key = PyString_FromString(aux);
    }

    existing = PyDict_GetItem(dict, key);
    if (existing && PyList_Check(existing))
        PyList_Append(existing, item);
    else
        PyDict_SetItem(dict, key, item);
    Py_DECREF(item);
}

static void
popt_destroy_table(struct poptOption *table)
{
    int i = 1;

    if (table[0].descrip) {
        Py_DECREF((PyObject *) table[0].descrip);
    }
    while ((table[i].longName != NULL) || (table[i].shortName != '\0') || 
           (table[i].argInfo != 0)) {
        if (table[i].longName)
            g_free((gpointer) table[i].longName);
        if (table[i].descrip)
            g_free((gpointer) table[i].descrip);
        if (table[i].argDescrip)
            g_free((gpointer) table[i].argDescrip);
        if ((table[i].argInfo != POPT_ARG_CALLBACK) && 
            (table[i].arg != NULL))
            g_free((gpointer) table[i].arg);
        i++;
    }
    g_free(table);
}

static struct poptOption *
popt_build_table(PyObject *table)
{
    int optslen;
    int i;
    struct poptOption *popt_table = NULL;
    PyObject *tmpobj;
    char *lname, *sname, *desc = NULL, *adesc = NULL;
    PyTypeObject *tinfo;
    PyObject *dict_key = Py_None, *dict, *defval, *defval1;
    int flags;

    optslen = PyList_Size(table);
    /* save one row for the callback definition, and another for
     * end of table */
    popt_table = g_new0(struct poptOption, optslen + 2);

    if (popt_table != NULL) {

        dict = PyDict_New();
        if (dict == NULL) {
            g_free(popt_table);
            return NULL;
        }

        /* Hey popt, we want to be called back */
        popt_table[0].longName = NULL;
        popt_table[0].shortName = 0;
        popt_table[0].argInfo = POPT_ARG_CALLBACK;
        popt_table[0].arg = popt_cb;
        popt_table[0].val = 0;
        popt_table[0].descrip = (char *) dict;
        popt_table[0].argDescrip = NULL;

        for (i = 0; i < optslen; i++) {

            desc = NULL;
            adesc = NULL;

            tmpobj = PyList_GetItem(table, i);

            if (!PyTuple_Check(tmpobj)) {
                PyErr_SetString(PyExc_TypeError,
                                "table must be a list of tuples");
                popt_destroy_table(popt_table);
                return NULL;
            }

            if (!PyArg_ParseTuple(tmpobj, "zzOOi|ss", 
                                  &lname, &sname, &tinfo,
                                  &defval, &flags, &desc, &adesc)) {
                popt_destroy_table(popt_table);
                return NULL;
            }

            if (strlen(lname) == 0)
                lname = NULL;

            if (strlen(sname) == 0)
                sname = NULL;

            if (sname && strlen(sname) > 1) {
                PyErr_Format(PyExc_ValueError,
                             "popt table row %d short option"
                             " must be one character only", i);
                popt_destroy_table(popt_table);
                return NULL;
            } else {
                if (lname) {
                    dict_key = PyString_FromString(lname);
                } else if (sname) {
                    dict_key = PyString_FromString(sname);
                }
            }

            if (!sname & !lname) {
                PyErr_Format(PyExc_ValueError,
                             "popt table row %d at least short"
                             " or long name must be set", i);
                popt_destroy_table(popt_table);
                return NULL;
            }

            if (dict_key != Py_None) {
                if ((defval != Py_None && !PyList_Check(defval)) && 
                    (!PyObject_TypeCheck(defval, (PyTypeObject *) tinfo))) {
                    PyErr_Format(PyExc_ValueError,
                                 "popt table row %d type info and default "
                                 "value must have same type", i);
                    popt_destroy_table(popt_table);
                    return NULL;
                }

                /* If one doesnt want to have keys created only when
                   a parameter is found in the command line this has to
                   be done only when defval is not Py_None */
                if (PyList_Check(defval))
                    defval1 = PyList_New(0);
                else {
                    Py_INCREF(defval);
                    defval1 = defval;
                }
                if (PyDict_SetItem(dict, dict_key, defval1)) {
                    Py_DECREF(defval1);
                    popt_destroy_table(popt_table);
                    return NULL;
                }
                Py_DECREF(defval1);
            }

            /* ARG_FLOAT is not set here - we use DOUBLE */
            if (tinfo == &PyInt_Type) {
                popt_table[i + 1].argInfo = POPT_ARG_INT;
                popt_table[i + 1].arg = g_new(int, 1);
                if (PyInt_Check(defval))
                    *((int *)popt_table[i + 1].arg) = PyInt_AS_LONG(defval);
            } else if (tinfo == &PyFloat_Type) {
                popt_table[i + 1].argInfo = POPT_ARG_DOUBLE;
                popt_table[i + 1].arg = g_new(double, 1);
                if (PyFloat_Check(defval))
                    *((double *)popt_table[i + 1].arg) = PyFloat_AS_DOUBLE(defval);
            } else if (tinfo == &PyString_Type) {
                popt_table[i + 1].argInfo = POPT_ARG_STRING;
                popt_table[i + 1].arg = NULL;
            } else if (tinfo == &PyLong_Type) {
                popt_table[i + 1].argInfo = POPT_ARG_LONG;
                popt_table[i + 1].arg = g_new(long, 1);
                if (PyLong_Check(defval))
                    *((long *)popt_table[i + 1].arg) = PyInt_AS_LONG(defval);
            } else if (tinfo == (PyTypeObject *) Py_None) {
                popt_table[i + 1].argInfo = POPT_ARG_NONE;
                popt_table[i + 1].arg = NULL;
            } else {
                PyErr_Format(PyExc_ValueError,
                             "popt table row %d type info must be"
                             " None, int, str, float or long", i);
                popt_destroy_table(popt_table);
                return NULL;
            }

            popt_table[i + 1].longName = lname ? g_strdup(lname) : NULL;
            popt_table[i + 1].shortName = sname ? sname[0] : '\0';
            popt_table[i + 1].argInfo |= flags;
            popt_table[i + 1].val = 0;
            popt_table[i + 1].descrip = desc ? g_strdup(desc) : NULL;
            popt_table[i + 1].argDescrip = adesc ? g_strdup(adesc) : NULL;

        }
        /* finally the end mark */
        popt_table[optslen + 1].longName = NULL;
        popt_table[optslen + 1].shortName = 0;
        popt_table[optslen + 1].argInfo = 0;
        popt_table[optslen + 1].arg = NULL;
        popt_table[optslen + 1].val = 0;
        popt_table[optslen + 1].descrip = NULL;
        popt_table[optslen + 1].argDescrip = NULL;

        return popt_table;

    } else {
        PyErr_NoMemory();
    }

    return NULL;
}

static PyTypeObject *
get_option_context_type()
{
    PyObject *module;
    PyTypeObject *type;
    if ((module = PyImport_ImportModule("glib")) != NULL) {
        type = (PyTypeObject *)PyObject_GetAttrString(module, "OptionContext");
        Py_DECREF(module);
        if (type == NULL) {
            PyErr_SetString(PyExc_ImportError,
                            "cannot import OptionContext from glib");
            return NULL;
        } else
            return type;
    } else {
        PyErr_SetString(PyExc_ImportError, "could not import glib");
        return NULL;
    }
}

static int
build_gnome_init_params(PyObject *py_properties,
                        struct poptOption *popt_table, int flags,
                        PyObject *option_context,
                        PyObject **py_properties_items, Py_ssize_t *nparams,
                        GParameter **params_ptr)
{
    Py_ssize_t py_properties_len = -1;
    PyObject *items = NULL;
    if (py_properties) {
        *py_properties_items = items = PyMapping_Items(py_properties);
        if (!items)
            return 0;
        *nparams = py_properties_len = PyList_GET_SIZE(items);
    } else
        *nparams = 0;
    if (popt_table)
        *nparams += 2;
    if (option_context)
        *nparams += 1;

    GParameter *params = NULL;
    if (*nparams) {
        params = g_new0(GParameter, *nparams);
        if (!params) {
            PyErr_NoMemory();
            return 0;
        }
    }
    Py_ssize_t i = 0;
    if (py_properties) {
        PyObject *item, *key, *val;
        GType type;
        for (; i < py_properties_len; ++i) {
            item = PyList_GET_ITEM(items, i);
            key = PyTuple_GET_ITEM(item, 0);
            val = PyTuple_GET_ITEM(item, 1);
            type = pyg_type_from_object((PyObject *) val->ob_type);
            if (type == 0)
                goto error;
            params[i].name = PyString_AsString(key);
            g_value_init(&params[i].value, type);
            if (pyg_value_from_pyobject(&params[i].value, val))
                goto error;
            continue;
            error:
            {
                int j;
                for (j = 0; j < i; ++j)
                    g_value_unset(&params[j].value);
                g_free(params);
                Py_DECREF(items);
                return 0;
            }
        }
    }
    if (popt_table) {
        params[i].name = GNOME_PARAM_POPT_TABLE;
        g_value_init(&params[i].value, G_TYPE_POINTER);
        g_value_set_pointer(&params[i].value, popt_table);
        i++;
        params[i].name = GNOME_PARAM_POPT_FLAGS;
        g_value_init(&params[i].value, G_TYPE_INT);
        g_value_set_int(&params[i].value, flags);
    }
    if (option_context) {
        params[i].name = GNOME_PARAM_GOPTION_CONTEXT;
        g_value_init(&params[i].value, G_TYPE_POINTER);
        PyObject* context = PyObject_CallMethod(option_context, "_get_context", NULL);
        g_value_set_pointer(&params[0].value, PyCObject_AsVoidPtr(context));
        Py_DECREF(context);
    }

    *params_ptr = params;
    return 1;
}

static void
free_gnome_init_params(PyObject *py_properties_items, Py_ssize_t nparams,
                       GParameter *params)
{
    Py_XDECREF(py_properties_items);
    if (nparams)
    {
        Py_ssize_t i;
        for (i = 0; i < nparams; ++i)
            g_value_unset(&params[i].value);
        g_free(params);
    }
}

static PyObject *
_wrap_gnome_program_init(PyObject *self, 
                         PyObject *args, 
                         PyObject *kwargs)
{
    static char *kwlist[] = { "app_id", "app_version", "module_info", 
                              "argv", "popt_table", "popt_flags",
                              "option_context", "properties", NULL };
    gchar *app_id;
    gchar *app_version;
    PyObject *av = NULL;
    int argc;
    char **argv, **leftover_args;
    int i;
    GnomeModuleInfo *moduleinfo;
    GnomeProgram *program;
    struct sigaction sa;
    struct poptOption *popt_table = NULL;
    int flags = 0;
    PyObject *table = NULL;
    PyObject *m = NULL;
    PyObject *argdict, *py_leftover_args;
    PyObject *tmpobj;
    PyObject *option_context = NULL;
    PyObject *py_properties = NULL;
    PyObject *py_properties_items = NULL;
    GParameter *params;
    Py_ssize_t nparams;
    poptContext ctx = NULL;

    PyTypeObject *py_goption_context_type = get_option_context_type();
    if (!py_goption_context_type) {
        return NULL;
    }

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,
                                     "ss|OO!O!iO!O!:gnome.program_init",
                                     kwlist,
                                     &app_id, &app_version, &m,
                                     &PyList_Type, &av,
                                     &PyList_Type, &table,
                                     &flags,
                                     py_goption_context_type, &option_context,
                                     &PyDict_Type, &py_properties)) {
        return NULL;
    }

    Py_DECREF(py_goption_context_type);

    if (m == NULL) {
        moduleinfo = (GnomeModuleInfo *) libgnome_module_info_get();
    } else {
        if (pyg_boxed_check(m, GNOME_TYPE_MODULE_INFO))
            moduleinfo = pyg_boxed_get(m, GnomeModuleInfo);
        else {
            PyErr_SetString(PyExc_TypeError,
                            "module_info should be a GnomeModuleInfo");
            return NULL;
        }
    }

    if (av == NULL) {
          /* ... use argc and argv from sys */
        av = PySys_GetObject("argv");
    }
    argc = PyList_Size(av);
    argv = g_new(char *, argc);
    if (!argv)
        return PyErr_NoMemory();
    for (i = 0; i < argc; i++)
        argv[i] = PyString_AsString(PyList_GetItem(av, i));

    if (table != NULL) {
        popt_table = popt_build_table(table);
        if (!popt_table)
            return NULL;
    }

    if (!build_gnome_init_params(py_properties, popt_table, flags,
                                 option_context,
                                 &py_properties_items, &nparams, &params)) {
        if (popt_table)
            popt_destroy_table(popt_table);
        return NULL;
    }

    memset(&sa, 0, sizeof(sa));
    sigaction(SIGCHLD, NULL, &sa);

    program = gnome_program_init_paramv(GNOME_TYPE_PROGRAM,
                                        app_id, app_version,
                                        moduleinfo,  argc, argv,
                                        (guint) nparams, params);

    free_gnome_init_params(py_properties_items, nparams, params);

    if (!program) {
        PyErr_SetString(PyExc_RuntimeError,
                        "could not create GnomeProgram object");
        if (popt_table)
            popt_destroy_table(popt_table);
        g_free(argv);
        return NULL;
    }
      /* --- */

    sigaction(SIGCHLD, &sa, NULL);
#if PY_VERSION_HEX < 0x020400F0
    setlocale(LC_NUMERIC, "C");
#endif

    if (popt_table) {
          /* get argdict, store in object for later use */
        argdict = (PyObject *) popt_table[0].descrip;
        Py_INCREF(argdict);
        g_object_set_data_full(G_OBJECT(program),
                               "gnome-python-popt-argdict",
                               argdict, __py_object_free);

          /* get leftover args, store in object for later use */
        g_object_get(G_OBJECT(program), GNOME_PARAM_POPT_CONTEXT, &ctx, NULL);
        leftover_args = (char **) poptGetArgs(ctx);
        py_leftover_args = PyList_New(0);
        if (!py_leftover_args) {
            return PyErr_NoMemory();
        }
        if (leftover_args) {
            for (i = 0; leftover_args[i]; i++) {
                tmpobj = PyString_FromString(leftover_args[i]);
                if (!tmpobj) {
                    Py_DECREF(py_leftover_args);
                    return NULL;
                }
                if (PyList_Append(py_leftover_args, tmpobj)) {
                    Py_DECREF(tmpobj);
                    Py_DECREF(py_leftover_args);
                    return NULL;
                }
                Py_DECREF(tmpobj);
            }
        }
        g_object_set_data_full(G_OBJECT(program),
                               "gnome-python-popt-leftover-args",
                               py_leftover_args, __py_object_free);

        popt_destroy_table(popt_table);
    }

#if (defined(HAVE_PRCTL) && defined(PR_SET_NAME)) || defined(HAVE_SETPROCTITLE)
    if (argv && argv[0]) {
#if defined(HAVE_PRCTL) && defined(PR_SET_NAME)
    if (prctl(PR_SET_NAME, (unsigned long) argv[0], 0, 0, 0)) {
            g_warning("prctl() failed");
        }
#elif defined(HAVE_SETPROCTITLE)
    setproctitle("-%s", argv[0]);
#endif
    }
#endif

    g_free (argv);
    return pygobject_new((GObject *) program);
}

#line 1441 "gnome.c"


static PyObject *
_wrap_gnome_score_init(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "gamename", NULL };
    char *gamename;
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:score_init", kwlist, &gamename))
        return NULL;
    
    ret = gnome_score_init(gamename);
    
    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_gnome_score_log(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "score", "level", "higher_to_lower_score_order", NULL };
    char *level;
    double score;
    int higher_to_lower_score_order, ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"dsi:score_log", kwlist, &score, &level, &higher_to_lower_score_order))
        return NULL;
    
    ret = gnome_score_log(score, level, higher_to_lower_score_order);
    
    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_gnome_sound_connection_get(PyObject *self)
{
    int ret;

    
    ret = gnome_sound_connection_get();
    
    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_gnome_sound_init(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "hostname", NULL };
    char *hostname;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:sound_init", kwlist, &hostname))
        return NULL;
    
    gnome_sound_init(hostname);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gnome_sound_shutdown(PyObject *self)
{
    
    gnome_sound_shutdown();
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gnome_sound_sample_load(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "sample_name", "filename", NULL };
    char *sample_name, *filename;
    int ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"ss:sound_sample_load", kwlist, &sample_name, &filename))
        return NULL;
    
    ret = gnome_sound_sample_load(sample_name, filename);
    
    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_gnome_sound_play(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "filename", NULL };
    char *filename;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:sound_play", kwlist, &filename))
        return NULL;
    
    gnome_sound_play(filename);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gnome_url_show(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "url", NULL };
    char *url;
    int ret;
    GError *error = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:url_show", kwlist, &url))
        return NULL;
    
    ret = gnome_url_show(url, &error);
    
    if (pyg_error_check(&error))
        return NULL;
    return PyBool_FromLong(ret);

}

static PyObject *
_wrap_g_extension_pointer(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "path", NULL };
    char *path;
    const gchar *ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:g_extension_pointer", kwlist, &path))
        return NULL;
    
    ret = g_extension_pointer(path);
    
    if (ret)
        return PyString_FromString(ret);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gnome_util_user_shell(PyObject *self)
{
    gchar *ret;

    
    ret = gnome_util_user_shell();
    
    if (ret) {
        PyObject *py_ret = PyString_FromString(ret);
        g_free(ret);
        return py_ret;
    }
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gnome_setenv(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "name", "value", "overwrite", NULL };
    char *name, *value;
    int overwrite, ret;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"ssi:setenv", kwlist, &name, &value, &overwrite))
        return NULL;
    
    ret = gnome_setenv(name, value, overwrite);
    
    return PyInt_FromLong(ret);
}

static PyObject *
_wrap_gnome_unsetenv(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "name", NULL };
    char *name;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs,"s:unsetenv", kwlist, &name))
        return NULL;
    
    gnome_unsetenv(name);
    
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
_wrap_gnome_clearenv(PyObject *self)
{
    
    gnome_clearenv();
    
    Py_INCREF(Py_None);
    return Py_None;
}

#line 582 "gnome.override"
static PyObject *
_wrap_gnome_popt_parse(PyObject *self, PyObject *args, PyObject *kwargs)
{
    static char *kwlist[] = { "argv", "table", "flags", NULL };
    PyObject *pytable, *pyargv, *tmpobj;
    PyObject *argdict, *py_leftover_args;
    poptContext ctx = NULL;
    struct poptOption *table = NULL;
    GnomeProgram *program;
    const char *program_name;
    int i, argc, flags = 0;
    const char **argv = NULL;
    const char **leftover_args = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, "O!O!|i:popt_parse",
                                     kwlist,
                                     &PyList_Type, &pyargv,
                                     &PyList_Type, &pytable,
                                     &flags))
        return NULL;

    table = popt_build_table(pytable);
    if (table == NULL)
        return NULL;

      /* so much code just to get the program name :| */
    program = gnome_program_get();
    if (program)
        program_name = gnome_program_get_app_id(program);
    else {
        PyObject *sysargv, *arg0;
        sysargv = PySys_GetObject("argv");
        arg0 = PyList_GetItem(sysargv, 0);
        if (!arg0) {
            PyErr_Clear();
            program_name = "gnome-python";
        } else {
            program_name = PyString_AsString(arg0);
            if (!program_name) {
                PyErr_Clear();
                program_name = "gnome-python";
            }
        }
    }

    argc = PyList_Size(pyargv);
    argv = g_new(const char *, argc);
    for (i = 0; i < argc; i++)
        argv[i] = PyString_AsString(PyList_GetItem(pyargv, i));

    ctx = poptGetContext(program_name, argc, argv, table, flags);
    while (poptGetNextOpt(ctx) >= 0);
    
    argdict = (PyObject *) table[0].descrip;
    Py_INCREF(argdict);

    leftover_args = poptGetArgs(ctx);
    py_leftover_args = PyList_New(0);
    if (leftover_args)
        for (i = 0; leftover_args[i]; i++) {
            tmpobj = PyString_FromString(leftover_args[i]);
            PyList_Append(py_leftover_args, tmpobj);
            Py_DECREF(tmpobj);
        }

    popt_destroy_table(table);
    poptFreeContext(ctx);
    g_free(argv);

    return Py_BuildValue("(NN)", py_leftover_args, argdict);
}
#line 1707 "gnome.c"


const PyMethodDef pygnome_functions[] = {
    { "config_set_string_", (PyCFunction)_wrap_gnome_config_set_string_, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "config_set_translated_string_", (PyCFunction)_wrap_gnome_config_set_translated_string_, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "config_set_int_", (PyCFunction)_wrap_gnome_config_set_int_, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "config_set_float_", (PyCFunction)_wrap_gnome_config_set_float_, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "config_set_bool_", (PyCFunction)_wrap_gnome_config_set_bool_, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "config_has_section_", (PyCFunction)_wrap_gnome_config_has_section_, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "config_drop_all", (PyCFunction)_wrap_gnome_config_drop_all, METH_NOARGS,
      NULL },
    { "config_sync", (PyCFunction)_wrap_gnome_config_sync, METH_NOARGS,
      NULL },
    { "config_sync_file_", (PyCFunction)_wrap_gnome_config_sync_file_, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "config_drop_file_", (PyCFunction)_wrap_gnome_config_drop_file_, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "config_clean_file_", (PyCFunction)_wrap_gnome_config_clean_file_, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "config_clean_section_", (PyCFunction)_wrap_gnome_config_clean_section_, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "config_clean_key_", (PyCFunction)_wrap_gnome_config_clean_key_, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "config_push_prefix", (PyCFunction)_wrap_gnome_config_push_prefix, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "config_pop_prefix", (PyCFunction)_wrap_gnome_config_pop_prefix, METH_NOARGS,
      NULL },
    { "execute_shell", (PyCFunction)_wrap_gnome_execute_shell, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "execute_shell_fds", (PyCFunction)_wrap_gnome_execute_shell_fds, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "execute_terminal_shell", (PyCFunction)_wrap_gnome_execute_terminal_shell, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "execute_terminal_shell_fds", (PyCFunction)_wrap_gnome_execute_terminal_shell_fds, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "gconf_get_gnome_libs_settings_relative", (PyCFunction)_wrap_gnome_gconf_get_gnome_libs_settings_relative, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "gconf_get_app_settings_relative", (PyCFunction)_wrap_gnome_gconf_get_app_settings_relative, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "help_display", (PyCFunction)_wrap_gnome_help_display, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "help_display_with_doc_id", (PyCFunction)_wrap_gnome_help_display_with_doc_id, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "help_display_desktop", (PyCFunction)_wrap_gnome_help_display_desktop, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "help_display_uri", (PyCFunction)_wrap_gnome_help_display_uri, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "i18n_push_c_numeric_locale", (PyCFunction)_wrap_gnome_i18n_push_c_numeric_locale, METH_NOARGS,
      NULL },
    { "i18n_pop_c_numeric_locale", (PyCFunction)_wrap_gnome_i18n_pop_c_numeric_locale, METH_NOARGS,
      NULL },
    { "libgnome_module_info_get", (PyCFunction)_wrap_libgnome_module_info_get, METH_NOARGS,
      NULL },
    { "bonobo_module_info_get", (PyCFunction)_wrap_gnome_bonobo_module_info_get, METH_NOARGS,
      NULL },
    { "user_dir_get", (PyCFunction)_wrap_gnome_user_dir_get, METH_NOARGS,
      NULL },
    { "user_private_dir_get", (PyCFunction)_wrap_gnome_user_private_dir_get, METH_NOARGS,
      NULL },
    { "user_accels_dir_get", (PyCFunction)_wrap_gnome_user_accels_dir_get, METH_NOARGS,
      NULL },
    { "program_get", (PyCFunction)_wrap_gnome_program_get, METH_NOARGS,
      NULL },
    { "program_module_register", (PyCFunction)_wrap_gnome_program_module_register, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "program_module_registered", (PyCFunction)_wrap_gnome_program_module_registered, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "program_module_load", (PyCFunction)_wrap_gnome_program_module_load, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "program_init", (PyCFunction)_wrap_gnome_program_init, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "score_init", (PyCFunction)_wrap_gnome_score_init, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "score_log", (PyCFunction)_wrap_gnome_score_log, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "sound_connection_get", (PyCFunction)_wrap_gnome_sound_connection_get, METH_NOARGS,
      NULL },
    { "sound_init", (PyCFunction)_wrap_gnome_sound_init, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "sound_shutdown", (PyCFunction)_wrap_gnome_sound_shutdown, METH_NOARGS,
      NULL },
    { "sound_sample_load", (PyCFunction)_wrap_gnome_sound_sample_load, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "sound_play", (PyCFunction)_wrap_gnome_sound_play, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "url_show", (PyCFunction)_wrap_gnome_url_show, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "g_extension_pointer", (PyCFunction)_wrap_g_extension_pointer, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "util_user_shell", (PyCFunction)_wrap_gnome_util_user_shell, METH_NOARGS,
      NULL },
    { "setenv", (PyCFunction)_wrap_gnome_setenv, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "unsetenv", (PyCFunction)_wrap_gnome_unsetenv, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { "clearenv", (PyCFunction)_wrap_gnome_clearenv, METH_NOARGS,
      NULL },
    { "popt_parse", (PyCFunction)_wrap_gnome_popt_parse, METH_VARARGS|METH_KEYWORDS,
      NULL },
    { NULL, NULL, 0, NULL }
};


/* ----------- enums and flags ----------- */

void
pygnome_add_constants(PyObject *module, const gchar *strip_prefix)
{
#ifdef VERSION
    PyModule_AddStringConstant(module, "__version__", VERSION);
#endif
  pyg_enum_add(module, "HelpError", strip_prefix, GNOME_TYPE_HELP_ERROR);
  pyg_enum_add(module, "FileDomain", strip_prefix, GNOME_TYPE_FILE_DOMAIN);
  pyg_enum_add(module, "TriggerType", strip_prefix, GNOME_TYPE_TRIGGER_TYPE);
  pyg_enum_add(module, "URLError", strip_prefix, GNOME_TYPE_URL_ERROR);

  if (PyErr_Occurred())
    PyErr_Print();
}

/* initialise stuff extension classes */
void
pygnome_register_classes(PyObject *d)
{
    PyObject *module;

    if ((module = PyImport_ImportModule("gobject")) != NULL) {
        _PyGObject_Type = (PyTypeObject *)PyObject_GetAttrString(module, "GObject");
        if (_PyGObject_Type == NULL) {
            PyErr_SetString(PyExc_ImportError,
                "cannot import name GObject from gobject");
            return ;
        }
    } else {
        PyErr_SetString(PyExc_ImportError,
            "could not import gobject");
        return ;
    }


#line 1854 "gnome.c"
    pyg_register_boxed(d, "GnomeModuleInfo", GNOME_TYPE_MODULE_INFO, &PyGnomeModuleInfo_Type);
    pygobject_register_class(d, "GnomeProgram", GNOME_TYPE_PROGRAM, &PyGnomeProgram_Type, Py_BuildValue("(O)", &PyGObject_Type));
    pyg_set_object_has_new_constructor(GNOME_TYPE_PROGRAM);
}
