/* gnome-calculator.c generated by valac 0.36.5, the Vala compiler
 * generated from gnome-calculator.vala, do not modify */

/*
 * Copyright (C) 1987-2008 Sun Microsystems, Inc. All Rights Reserved.
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include "libcalculator.h"
#include "mpfr.h"
#include <gdk/gdk.h>
#include <stdio.h>
#include <langinfo.h>
#include <locale.h>


#define TYPE_CALCULATOR (calculator_get_type ())
#define CALCULATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CALCULATOR, Calculator))
#define CALCULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CALCULATOR, CalculatorClass))
#define IS_CALCULATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CALCULATOR))
#define IS_CALCULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CALCULATOR))
#define CALCULATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CALCULATOR, CalculatorClass))

typedef struct _Calculator Calculator;
typedef struct _CalculatorClass CalculatorClass;
typedef struct _CalculatorPrivate CalculatorPrivate;

#define TYPE_MATH_WINDOW (math_window_get_type ())
#define MATH_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_WINDOW, MathWindow))
#define MATH_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_WINDOW, MathWindowClass))
#define IS_MATH_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_WINDOW))
#define IS_MATH_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_WINDOW))
#define MATH_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_WINDOW, MathWindowClass))

typedef struct _MathWindow MathWindow;
typedef struct _MathWindowClass MathWindowClass;

#define TYPE_MATH_PREFERENCES_DIALOG (math_preferences_dialog_get_type ())
#define MATH_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialog))
#define MATH_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialogClass))
#define IS_MATH_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_PREFERENCES_DIALOG))
#define IS_MATH_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_PREFERENCES_DIALOG))
#define MATH_PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialogClass))

typedef struct _MathPreferencesDialog MathPreferencesDialog;
typedef struct _MathPreferencesDialogClass MathPreferencesDialogClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_BUTTON_MODE (button_mode_get_type ())

#define TYPE_MATH_BUTTONS (math_buttons_get_type ())
#define MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_BUTTONS, MathButtons))
#define MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_BUTTONS, MathButtonsClass))
#define IS_MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_BUTTONS))
#define IS_MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_BUTTONS))
#define MATH_BUTTONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_BUTTONS, MathButtonsClass))

typedef struct _MathButtons MathButtons;
typedef struct _MathButtonsClass MathButtonsClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define TYPE_SOLVE_EQUATION (solve_equation_get_type ())
#define SOLVE_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOLVE_EQUATION, SolveEquation))
#define SOLVE_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOLVE_EQUATION, SolveEquationClass))
#define IS_SOLVE_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOLVE_EQUATION))
#define IS_SOLVE_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOLVE_EQUATION))
#define SOLVE_EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOLVE_EQUATION, SolveEquationClass))

typedef struct _SolveEquation SolveEquation;
typedef struct _SolveEquationClass SolveEquationClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _SolveEquationPrivate SolveEquationPrivate;

struct _Calculator {
	GtkApplication parent_instance;
	CalculatorPrivate * priv;
};

struct _CalculatorClass {
	GtkApplicationClass parent_class;
};

struct _CalculatorPrivate {
	GSettings* settings;
	MathWindow* last_opened_window;
	gint n_math_windows;
	MathPreferencesDialog* preferences_dialog;
	GtkShortcutsWindow* shortcuts_window;
};

typedef enum  {
	BUTTON_MODE_BASIC,
	BUTTON_MODE_ADVANCED,
	BUTTON_MODE_FINANCIAL,
	BUTTON_MODE_PROGRAMMING,
	BUTTON_MODE_KEYBOARD
} ButtonMode;

struct _SolveEquation {
	Equation parent_instance;
	SolveEquationPrivate * priv;
};

struct _SolveEquationClass {
	EquationClass parent_class;
};


static gpointer calculator_parent_class = NULL;
static gchar* calculator_program_name;
static gchar* calculator_program_name = NULL;
static gchar* calculator_equation_string;
static gchar* calculator_equation_string = NULL;
static gchar* calculator_mode_string;
static gchar* calculator_mode_string = NULL;
static gpointer solve_equation_parent_class = NULL;

GType calculator_get_type (void) G_GNUC_CONST;
GType math_window_get_type (void) G_GNUC_CONST;
GType math_preferences_dialog_get_type (void) G_GNUC_CONST;
#define CALCULATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CALCULATOR, CalculatorPrivate))
enum  {
	CALCULATOR_DUMMY_PROPERTY
};
static void calculator_new_window_cb (Calculator* self);
static void _calculator_new_window_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void calculator_show_preferences_cb (Calculator* self);
static void _calculator_show_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void calculator_keyboard_shortcuts_cb (Calculator* self);
static void _calculator_keyboard_shortcuts_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void calculator_help_cb (Calculator* self);
static void _calculator_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void calculator_about_cb (Calculator* self);
static void _calculator_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void calculator_quit_cb (Calculator* self);
static void _calculator_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Calculator* calculator_new (void);
Calculator* calculator_construct (GType object_type);
static MathWindow* calculator_create_new_window (Calculator* self, GSettings* settings);
GType button_mode_get_type (void) G_GNUC_CONST;
MathWindow* math_window_new (GtkApplication* app, MathEquation* equation);
MathWindow* math_window_construct (GType object_type, GtkApplication* app, MathEquation* equation);
static gboolean __lambda34_ (Calculator* self, GtkWidget* sender, GdkEventAny* event);
static void calculator_save_window_position (Calculator* self, MathWindow* window);
static gboolean ___lambda34__gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
GType math_buttons_get_type (void) G_GNUC_CONST;
MathButtons* math_window_get_buttons (MathWindow* self);
void math_buttons_set_programming_base (MathButtons* self, gint value);
void math_buttons_set_mode (MathButtons* self, ButtonMode value);
static void calculator_real_startup (GApplication* base);
static void calculator_load_window_position (Calculator* self, MathWindow* window);
static MathWindow* calculator_get_active_math_window (Calculator* self);
static void calculator_real_activate (GApplication* base);
MathEquation* math_window_get_equation (MathWindow* self);
static void calculator_real_shutdown (GApplication* base);
ButtonMode math_buttons_get_mode (MathButtons* self);
gint math_buttons_get_programming_base (MathButtons* self);
static gint calculator_real_handle_local_options (GApplication* base, GVariantDict* options);
static gchar* _variant_get1 (GVariant* value);
GType solve_equation_get_type (void) G_GNUC_CONST;
SolveEquation* solve_equation_new (const gchar* text);
SolveEquation* solve_equation_construct (GType object_type, const gchar* text);
MathPreferencesDialog* math_preferences_dialog_new (MathEquation* eq);
MathPreferencesDialog* math_preferences_dialog_construct (GType object_type, MathEquation* eq);
static void ___lambda35_ (Calculator* self, GtkWidget* event);
static void ____lambda35__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
gint calculator_main (gchar** args, int args_length1);
static void calculator_finalize (GObject * obj);
enum  {
	SOLVE_EQUATION_DUMMY_PROPERTY
};
static Number* solve_equation_real_convert (Equation* base, Number* x, const gchar* x_units, const gchar* z_units);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry CALCULATOR_option_entries[5] = {{"mode", 'm', 0, G_OPTION_ARG_STRING, &calculator_mode_string, N_ ("Start in given mode"), "mode"}, {"solve", 's', 0, G_OPTION_ARG_STRING, NULL, N_ ("Solve given equation"), "equation"}, {"equation", 'e', 0, G_OPTION_ARG_STRING, &calculator_equation_string, N_ ("Start with given equation"), "equation"}, {"version", 'v', 0, G_OPTION_ARG_NONE, NULL, N_ ("Show release version"), NULL}, {NULL}};
static const GActionEntry CALCULATOR_app_entries[6] = {{"newwindow", _calculator_new_window_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"preferences", _calculator_show_preferences_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"shortcuts", _calculator_keyboard_shortcuts_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"help", _calculator_help_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"about", _calculator_about_cb_gsimple_action_activate_callback, NULL, NULL, NULL}, {"quit", _calculator_quit_cb_gsimple_action_activate_callback, NULL, NULL, NULL}};

static void _calculator_new_window_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	calculator_new_window_cb ((Calculator*) self);
}


static void _calculator_show_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	calculator_show_preferences_cb ((Calculator*) self);
}


static void _calculator_keyboard_shortcuts_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	calculator_keyboard_shortcuts_cb ((Calculator*) self);
}


static void _calculator_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	calculator_help_cb ((Calculator*) self);
}


static void _calculator_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	calculator_about_cb ((Calculator*) self);
}


static void _calculator_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	calculator_quit_cb ((Calculator*) self);
}


Calculator* calculator_construct (GType object_type) {
	Calculator * self = NULL;
	self = (Calculator*) g_object_new (object_type, "flags", G_APPLICATION_NON_UNIQUE, "application-id", "org.gnome.Calculator", NULL);
	g_application_add_main_option_entries ((GApplication*) self, CALCULATOR_option_entries);
	return self;
}


Calculator* calculator_new (void) {
	return calculator_construct (TYPE_CALCULATOR);
}


static gboolean __lambda34_ (Calculator* self, GtkWidget* sender, GdkEventAny* event) {
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp2_;
	g_return_val_if_fail (sender != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->n_math_windows;
	if (_tmp0_ == 1) {
		GtkWidget* _tmp1_;
		_tmp1_ = sender;
		calculator_save_window_position (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, TYPE_MATH_WINDOW) ? ((MathWindow*) _tmp1_) : NULL);
	}
	_tmp2_ = self->priv->n_math_windows;
	self->priv->n_math_windows = _tmp2_ - 1;
	result = FALSE;
	return result;
}


static gboolean ___lambda34__gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = __lambda34_ ((Calculator*) self, _sender, event);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static MathWindow* calculator_create_new_window (Calculator* self, GSettings* settings) {
	MathWindow* result = NULL;
	gint accuracy = 0;
	GSettings* _tmp0_;
	gint _tmp1_;
	gint word_size = 0;
	GSettings* _tmp2_;
	gint _tmp3_;
	gint number_base = 0;
	GSettings* _tmp4_;
	gint _tmp5_;
	gboolean show_tsep = FALSE;
	GSettings* _tmp6_;
	gboolean _tmp7_;
	gboolean show_zeroes = FALSE;
	GSettings* _tmp8_;
	gboolean _tmp9_;
	DisplayFormat number_format = 0;
	GSettings* _tmp10_;
	gint _tmp11_;
	AngleUnit angle_units = 0;
	GSettings* _tmp12_;
	gint _tmp13_;
	ButtonMode button_mode = 0;
	GSettings* _tmp14_;
	gint _tmp15_;
	gchar* source_currency = NULL;
	GSettings* _tmp16_;
	gchar* _tmp17_;
	gchar* target_currency = NULL;
	GSettings* _tmp18_;
	gchar* _tmp19_;
	gchar* source_units = NULL;
	GSettings* _tmp20_;
	gchar* _tmp21_;
	gchar* target_units = NULL;
	GSettings* _tmp22_;
	gchar* _tmp23_;
	gint precision = 0;
	GSettings* _tmp24_;
	gint _tmp25_;
	MathEquation* equation = NULL;
	MathEquation* _tmp26_;
	mpfr_prec_t _tmp27_;
	mpfr_prec_t _tmp28_;
	MathWindow* current_window = NULL;
	MathWindow* _tmp29_;
	gint _tmp30_;
	MathButtons* buttons = NULL;
	MathButtons* _tmp31_;
	MathButtons* _tmp32_;
	MathButtons* _tmp33_;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp34_;
	GMenuModel* menu = NULL;
	GObject* _tmp36_;
	GMenuModel* _tmp37_;
	gchar* _tmp38_;
	gchar** _tmp39_;
	gchar** _tmp40_;
	gint _tmp40__length1;
	gchar* _tmp41_;
	gchar** _tmp42_;
	gchar** _tmp43_;
	gint _tmp43__length1;
	gchar* _tmp44_;
	gchar** _tmp45_;
	gchar** _tmp46_;
	gint _tmp46__length1;
	gchar* _tmp47_;
	gchar** _tmp48_;
	gchar** _tmp49_;
	gint _tmp49__length1;
	gchar* _tmp50_;
	gchar** _tmp51_;
	gchar** _tmp52_;
	gint _tmp52__length1;
	gchar* _tmp53_;
	gchar** _tmp54_;
	gchar** _tmp55_;
	gint _tmp55__length1;
	gchar* _tmp56_;
	gchar** _tmp57_;
	gchar** _tmp58_;
	gint _tmp58__length1;
	gchar* _tmp59_;
	gchar** _tmp60_;
	gchar** _tmp61_;
	gint _tmp61__length1;
	gchar* _tmp62_;
	gchar** _tmp63_;
	gchar** _tmp64_;
	gint _tmp64__length1;
	gchar* _tmp65_;
	gchar** _tmp66_;
	gchar** _tmp67_;
	gint _tmp67__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (settings != NULL, NULL);
	_tmp0_ = settings;
	_tmp1_ = g_settings_get_int (_tmp0_, "accuracy");
	accuracy = _tmp1_;
	_tmp2_ = settings;
	_tmp3_ = g_settings_get_int (_tmp2_, "word-size");
	word_size = _tmp3_;
	_tmp4_ = settings;
	_tmp5_ = g_settings_get_int (_tmp4_, "base");
	number_base = _tmp5_;
	_tmp6_ = settings;
	_tmp7_ = g_settings_get_boolean (_tmp6_, "show-thousands");
	show_tsep = _tmp7_;
	_tmp8_ = settings;
	_tmp9_ = g_settings_get_boolean (_tmp8_, "show-zeroes");
	show_zeroes = _tmp9_;
	_tmp10_ = settings;
	_tmp11_ = g_settings_get_enum (_tmp10_, "number-format");
	number_format = (DisplayFormat) _tmp11_;
	_tmp12_ = settings;
	_tmp13_ = g_settings_get_enum (_tmp12_, "angle-units");
	angle_units = (AngleUnit) _tmp13_;
	_tmp14_ = settings;
	_tmp15_ = g_settings_get_enum (_tmp14_, "button-mode");
	button_mode = (ButtonMode) _tmp15_;
	_tmp16_ = settings;
	_tmp17_ = g_settings_get_string (_tmp16_, "source-currency");
	source_currency = _tmp17_;
	_tmp18_ = settings;
	_tmp19_ = g_settings_get_string (_tmp18_, "target-currency");
	target_currency = _tmp19_;
	_tmp20_ = settings;
	_tmp21_ = g_settings_get_string (_tmp20_, "source-units");
	source_units = _tmp21_;
	_tmp22_ = settings;
	_tmp23_ = g_settings_get_string (_tmp22_, "target-units");
	target_units = _tmp23_;
	_tmp24_ = settings;
	_tmp25_ = g_settings_get_int (_tmp24_, "precision");
	precision = _tmp25_;
	_tmp26_ = math_equation_new ();
	equation = _tmp26_;
	math_equation_set_accuracy (equation, accuracy);
	math_equation_set_word_size (equation, word_size);
	math_equation_set_show_thousands_separators (equation, show_tsep);
	math_equation_set_show_trailing_zeroes (equation, show_zeroes);
	math_equation_set_number_format (equation, number_format);
	math_equation_set_angle_units (equation, angle_units);
	math_equation_set_source_currency (equation, source_currency);
	math_equation_set_target_currency (equation, target_currency);
	math_equation_set_source_units (equation, source_units);
	math_equation_set_target_units (equation, target_units);
	_tmp27_ = number_get_precision ();
	_tmp28_ = _tmp27_;
	number_set_precision ((mpfr_prec_t) precision);
	g_action_map_add_action_entries ((GActionMap*) self, CALCULATOR_app_entries, G_N_ELEMENTS (CALCULATOR_app_entries), self);
	_tmp29_ = math_window_new ((GtkApplication*) self, equation);
	g_object_ref_sink (_tmp29_);
	current_window = _tmp29_;
	gtk_window_set_title ((GtkWindow*) current_window, _ ("Calculator"));
	g_signal_connect_object ((GtkWidget*) current_window, "delete-event", (GCallback) ___lambda34__gtk_widget_delete_event, self, 0);
	_tmp30_ = self->priv->n_math_windows;
	self->priv->n_math_windows = _tmp30_ + 1;
	_tmp31_ = math_window_get_buttons (current_window);
	_tmp32_ = _tmp31_;
	_tmp33_ = _g_object_ref0 (_tmp32_);
	buttons = _tmp33_;
	math_buttons_set_programming_base (buttons, number_base);
	math_buttons_set_mode (buttons, button_mode);
	_tmp34_ = gtk_builder_new ();
	builder = _tmp34_;
	{
		gtk_builder_add_from_resource (builder, "/org/gnome/calculator/menu.ui", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp35_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp35_ = e->message;
		g_error ("gnome-calculator.vala:102: Error loading menu UI: %s", _tmp35_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (builder);
		_g_object_unref0 (buttons);
		_g_object_unref0 (current_window);
		_g_object_unref0 (equation);
		_g_free0 (target_units);
		_g_free0 (source_units);
		_g_free0 (target_currency);
		_g_free0 (source_currency);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp36_ = gtk_builder_get_object (builder, "appmenu");
	_tmp37_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, g_menu_model_get_type ()) ? ((GMenuModel*) _tmp36_) : NULL);
	menu = _tmp37_;
	gtk_application_set_app_menu ((GtkApplication*) self, menu);
	_tmp38_ = g_strdup ("<alt>B");
	_tmp39_ = g_new0 (gchar*, 1 + 1);
	_tmp39_[0] = _tmp38_;
	_tmp40_ = _tmp39_;
	_tmp40__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.mode::basic", _tmp40_);
	_tmp40_ = (_vala_array_free (_tmp40_, _tmp40__length1, (GDestroyNotify) g_free), NULL);
	_tmp41_ = g_strdup ("<alt>A");
	_tmp42_ = g_new0 (gchar*, 1 + 1);
	_tmp42_[0] = _tmp41_;
	_tmp43_ = _tmp42_;
	_tmp43__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.mode::advanced", _tmp43_);
	_tmp43_ = (_vala_array_free (_tmp43_, _tmp43__length1, (GDestroyNotify) g_free), NULL);
	_tmp44_ = g_strdup ("<alt>F");
	_tmp45_ = g_new0 (gchar*, 1 + 1);
	_tmp45_[0] = _tmp44_;
	_tmp46_ = _tmp45_;
	_tmp46__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.mode::financial", _tmp46_);
	_tmp46_ = (_vala_array_free (_tmp46_, _tmp46__length1, (GDestroyNotify) g_free), NULL);
	_tmp47_ = g_strdup ("<alt>P");
	_tmp48_ = g_new0 (gchar*, 1 + 1);
	_tmp48_[0] = _tmp47_;
	_tmp49_ = _tmp48_;
	_tmp49__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.mode::programming", _tmp49_);
	_tmp49_ = (_vala_array_free (_tmp49_, _tmp49__length1, (GDestroyNotify) g_free), NULL);
	_tmp50_ = g_strdup ("<alt>K");
	_tmp51_ = g_new0 (gchar*, 1 + 1);
	_tmp51_[0] = _tmp50_;
	_tmp52_ = _tmp51_;
	_tmp52__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.mode::keyboard", _tmp52_);
	_tmp52_ = (_vala_array_free (_tmp52_, _tmp52__length1, (GDestroyNotify) g_free), NULL);
	_tmp53_ = g_strdup ("<control>C");
	_tmp54_ = g_new0 (gchar*, 1 + 1);
	_tmp54_[0] = _tmp53_;
	_tmp55_ = _tmp54_;
	_tmp55__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.copy", _tmp55_);
	_tmp55_ = (_vala_array_free (_tmp55_, _tmp55__length1, (GDestroyNotify) g_free), NULL);
	_tmp56_ = g_strdup ("<control>V");
	_tmp57_ = g_new0 (gchar*, 1 + 1);
	_tmp57_[0] = _tmp56_;
	_tmp58_ = _tmp57_;
	_tmp58__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.paste", _tmp58_);
	_tmp58_ = (_vala_array_free (_tmp58_, _tmp58__length1, (GDestroyNotify) g_free), NULL);
	_tmp59_ = g_strdup ("<control>Z");
	_tmp60_ = g_new0 (gchar*, 1 + 1);
	_tmp60_[0] = _tmp59_;
	_tmp61_ = _tmp60_;
	_tmp61__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.undo", _tmp61_);
	_tmp61_ = (_vala_array_free (_tmp61_, _tmp61__length1, (GDestroyNotify) g_free), NULL);
	_tmp62_ = g_strdup ("<control>W");
	_tmp63_ = g_new0 (gchar*, 1 + 1);
	_tmp63_[0] = _tmp62_;
	_tmp64_ = _tmp63_;
	_tmp64__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.close", _tmp64_);
	_tmp64_ = (_vala_array_free (_tmp64_, _tmp64__length1, (GDestroyNotify) g_free), NULL);
	_tmp65_ = g_strdup ("<control><shift>Z");
	_tmp66_ = g_new0 (gchar*, 1 + 1);
	_tmp66_[0] = _tmp65_;
	_tmp67_ = _tmp66_;
	_tmp67__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.redo", _tmp67_);
	_tmp67_ = (_vala_array_free (_tmp67_, _tmp67__length1, (GDestroyNotify) g_free), NULL);
	result = current_window;
	_g_object_unref0 (menu);
	_g_object_unref0 (builder);
	_g_object_unref0 (buttons);
	_g_object_unref0 (equation);
	_g_free0 (target_units);
	_g_free0 (source_units);
	_g_free0 (target_currency);
	_g_free0 (source_currency);
	return result;
}


static void calculator_real_startup (GApplication* base) {
	Calculator * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	MathWindow* _tmp2_;
	MathWindow* _tmp3_;
	self = (Calculator*) base;
	G_APPLICATION_CLASS (calculator_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = g_settings_new ("org.gnome.calculator");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->settings;
	_tmp2_ = calculator_create_new_window (self, _tmp1_);
	_g_object_unref0 (self->priv->last_opened_window);
	self->priv->last_opened_window = _tmp2_;
	_tmp3_ = self->priv->last_opened_window;
	calculator_load_window_position (self, _tmp3_);
}


static MathWindow* calculator_get_active_math_window (Calculator* self) {
	MathWindow* result = NULL;
	GtkWindow* _tmp0_;
	MathWindow* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MATH_WINDOW, MathWindow));
	result = _tmp1_;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void calculator_real_activate (GApplication* base) {
	Calculator * self;
	MathWindow* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gboolean _tmp31_ = FALSE;
	const gchar* _tmp32_;
	self = (Calculator*) base;
	G_APPLICATION_CLASS (calculator_parent_class)->activate ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = self->priv->last_opened_window;
	gtk_window_present ((GtkWindow*) _tmp0_);
	_tmp2_ = calculator_equation_string;
	if (g_strcmp0 (_tmp2_, "") != 0) {
		const gchar* _tmp3_;
		_tmp3_ = calculator_equation_string;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar** equations = NULL;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar** _tmp7_;
		gchar** _tmp8_;
		gchar** _tmp9_;
		gint _tmp9__length1;
		gint equations_length1;
		gint _equations_size_;
		_tmp4_ = calculator_equation_string;
		_tmp5_ = g_strcompress (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "\n", 0);
		_tmp9_ = _tmp8_;
		_tmp9__length1 = _vala_array_length (_tmp7_);
		_g_free0 (_tmp6_);
		equations = _tmp9_;
		equations_length1 = _tmp9__length1;
		_equations_size_ = equations_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp10_ = FALSE;
				_tmp10_ = TRUE;
				while (TRUE) {
					gint _tmp12_;
					gchar** _tmp13_;
					gint _tmp13__length1;
					gchar** _tmp14_;
					gint _tmp14__length1;
					gint _tmp15_;
					const gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					gint _tmp19_;
					gint _tmp20_;
					gboolean _tmp21_;
					if (!_tmp10_) {
						gint _tmp11_;
						_tmp11_ = i;
						i = _tmp11_ + 1;
					}
					_tmp10_ = FALSE;
					_tmp12_ = i;
					_tmp13_ = equations;
					_tmp13__length1 = equations_length1;
					if (!(_tmp12_ < _tmp13__length1)) {
						break;
					}
					_tmp14_ = equations;
					_tmp14__length1 = equations_length1;
					_tmp15_ = i;
					_tmp16_ = _tmp14_[_tmp15_];
					_tmp17_ = string_strip (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = strlen (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp21_ = _tmp20_ > 0;
					_g_free0 (_tmp18_);
					if (_tmp21_) {
						MathWindow* _tmp22_;
						MathEquation* _tmp23_;
						MathEquation* _tmp24_;
						gchar** _tmp25_;
						gint _tmp25__length1;
						gint _tmp26_;
						const gchar* _tmp27_;
						_tmp22_ = self->priv->last_opened_window;
						_tmp23_ = math_window_get_equation (_tmp22_);
						_tmp24_ = _tmp23_;
						_tmp25_ = equations;
						_tmp25__length1 = equations_length1;
						_tmp26_ = i;
						_tmp27_ = _tmp25_[_tmp26_];
						math_equation_set (_tmp24_, _tmp27_);
					} else {
						MathWindow* _tmp28_;
						MathEquation* _tmp29_;
						MathEquation* _tmp30_;
						_tmp28_ = self->priv->last_opened_window;
						_tmp29_ = math_window_get_equation (_tmp28_);
						_tmp30_ = _tmp29_;
						math_equation_solve (_tmp30_);
					}
				}
			}
		}
		equations = (_vala_array_free (equations, equations_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp32_ = calculator_mode_string;
	if (g_strcmp0 (_tmp32_, "") != 0) {
		const gchar* _tmp33_;
		_tmp33_ = calculator_mode_string;
		_tmp31_ = _tmp33_ != NULL;
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		ButtonMode mode = 0;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		GQuark _tmp37_ = 0U;
		static GQuark _tmp36_label0 = 0;
		static GQuark _tmp36_label1 = 0;
		static GQuark _tmp36_label2 = 0;
		static GQuark _tmp36_label3 = 0;
		static GQuark _tmp36_label4 = 0;
		MathWindow* _tmp38_;
		MathButtons* _tmp39_;
		MathButtons* _tmp40_;
		ButtonMode _tmp41_;
		mode = BUTTON_MODE_BASIC;
		_tmp34_ = calculator_mode_string;
		_tmp35_ = _tmp34_;
		_tmp37_ = (NULL == _tmp35_) ? 0 : g_quark_from_string (_tmp35_);
		if (_tmp37_ == ((0 != _tmp36_label0) ? _tmp36_label0 : (_tmp36_label0 = g_quark_from_static_string ("basic")))) {
			switch (0) {
				default:
				{
					mode = BUTTON_MODE_BASIC;
					break;
				}
			}
		} else if (_tmp37_ == ((0 != _tmp36_label1) ? _tmp36_label1 : (_tmp36_label1 = g_quark_from_static_string ("advanced")))) {
			switch (0) {
				default:
				{
					mode = BUTTON_MODE_ADVANCED;
					break;
				}
			}
		} else if (_tmp37_ == ((0 != _tmp36_label2) ? _tmp36_label2 : (_tmp36_label2 = g_quark_from_static_string ("financial")))) {
			switch (0) {
				default:
				{
					mode = BUTTON_MODE_FINANCIAL;
					break;
				}
			}
		} else if (_tmp37_ == ((0 != _tmp36_label3) ? _tmp36_label3 : (_tmp36_label3 = g_quark_from_static_string ("programming")))) {
			switch (0) {
				default:
				{
					mode = BUTTON_MODE_PROGRAMMING;
					break;
				}
			}
		} else if (_tmp37_ == ((0 != _tmp36_label4) ? _tmp36_label4 : (_tmp36_label4 = g_quark_from_static_string ("keyboard")))) {
			switch (0) {
				default:
				{
					mode = BUTTON_MODE_KEYBOARD;
					break;
				}
			}
		}
		_tmp38_ = self->priv->last_opened_window;
		_tmp39_ = math_window_get_buttons (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = mode;
		math_buttons_set_mode (_tmp40_, _tmp41_);
	}
}


static void calculator_real_shutdown (GApplication* base) {
	Calculator * self;
	MathWindow* window = NULL;
	MathWindow* _tmp0_;
	MathWindow* _tmp1_;
	MathEquation* equation = NULL;
	MathEquation* _tmp2_;
	MathEquation* _tmp3_;
	MathEquation* _tmp4_;
	MathButtons* buttons = NULL;
	MathButtons* _tmp5_;
	MathButtons* _tmp6_;
	MathButtons* _tmp7_;
	GSettings* _tmp8_;
	ButtonMode _tmp9_;
	ButtonMode _tmp10_;
	GSettings* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	GSettings* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GSettings* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	GSettings* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	GSettings* _tmp23_;
	DisplayFormat _tmp24_;
	DisplayFormat _tmp25_;
	GSettings* _tmp26_;
	AngleUnit _tmp27_;
	AngleUnit _tmp28_;
	GSettings* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	GSettings* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	GSettings* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	GSettings* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	GSettings* _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	self = (Calculator*) base;
	G_APPLICATION_CLASS (calculator_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = self->priv->last_opened_window;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	window = _tmp1_;
	_tmp2_ = math_window_get_equation (window);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	equation = _tmp4_;
	_tmp5_ = math_window_get_buttons (window);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	buttons = _tmp7_;
	_tmp8_ = self->priv->settings;
	_tmp9_ = math_buttons_get_mode (buttons);
	_tmp10_ = _tmp9_;
	g_settings_set_enum (_tmp8_, "button-mode", (gint) _tmp10_);
	_tmp11_ = self->priv->settings;
	_tmp12_ = math_equation_get_accuracy (equation);
	_tmp13_ = _tmp12_;
	g_settings_set_int (_tmp11_, "accuracy", _tmp13_);
	_tmp14_ = self->priv->settings;
	_tmp15_ = math_equation_get_word_size (equation);
	_tmp16_ = _tmp15_;
	g_settings_set_int (_tmp14_, "word-size", _tmp16_);
	_tmp17_ = self->priv->settings;
	_tmp18_ = math_equation_get_show_thousands_separators (equation);
	_tmp19_ = _tmp18_;
	g_settings_set_boolean (_tmp17_, "show-thousands", _tmp19_);
	_tmp20_ = self->priv->settings;
	_tmp21_ = math_equation_get_show_trailing_zeroes (equation);
	_tmp22_ = _tmp21_;
	g_settings_set_boolean (_tmp20_, "show-zeroes", _tmp22_);
	_tmp23_ = self->priv->settings;
	_tmp24_ = math_equation_get_number_format (equation);
	_tmp25_ = _tmp24_;
	g_settings_set_enum (_tmp23_, "number-format", (gint) _tmp25_);
	_tmp26_ = self->priv->settings;
	_tmp27_ = math_equation_get_angle_units (equation);
	_tmp28_ = _tmp27_;
	g_settings_set_enum (_tmp26_, "angle-units", (gint) _tmp28_);
	_tmp29_ = self->priv->settings;
	_tmp30_ = math_equation_get_source_currency (equation);
	_tmp31_ = _tmp30_;
	_tmp32_ = _tmp31_;
	g_settings_set_string (_tmp29_, "source-currency", _tmp32_);
	_g_free0 (_tmp32_);
	_tmp33_ = self->priv->settings;
	_tmp34_ = math_equation_get_target_currency (equation);
	_tmp35_ = _tmp34_;
	_tmp36_ = _tmp35_;
	g_settings_set_string (_tmp33_, "target-currency", _tmp36_);
	_g_free0 (_tmp36_);
	_tmp37_ = self->priv->settings;
	_tmp38_ = math_equation_get_source_units (equation);
	_tmp39_ = _tmp38_;
	_tmp40_ = _tmp39_;
	g_settings_set_string (_tmp37_, "source-units", _tmp40_);
	_g_free0 (_tmp40_);
	_tmp41_ = self->priv->settings;
	_tmp42_ = math_equation_get_target_units (equation);
	_tmp43_ = _tmp42_;
	_tmp44_ = _tmp43_;
	g_settings_set_string (_tmp41_, "target-units", _tmp44_);
	_g_free0 (_tmp44_);
	_tmp45_ = self->priv->settings;
	_tmp46_ = math_buttons_get_programming_base (buttons);
	_tmp47_ = _tmp46_;
	g_settings_set_int (_tmp45_, "base", _tmp47_);
	_g_object_unref0 (buttons);
	_g_object_unref0 (equation);
	_g_object_unref0 (window);
}


static gchar* _variant_get1 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = old;
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = old;
		_tmp4_ = replacement;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (self);
		result = _tmp5_;
		return result;
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = old;
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		regex = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = regex;
		_tmp13_ = replacement;
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		result = _tmp15_;
		_g_free0 (_tmp11_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gint calculator_real_handle_local_options (GApplication* base, GVariantDict* options) {
	Calculator * self;
	gint result = 0;
	GVariantDict* _tmp0_;
	gboolean _tmp1_;
	GVariantDict* _tmp4_;
	gboolean _tmp5_;
	self = (Calculator*) base;
	g_return_val_if_fail (options != NULL, 0);
	_tmp0_ = options;
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
	if (_tmp1_) {
		FILE* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = stderr;
		_tmp3_ = calculator_program_name;
		fprintf (_tmp2_, "%1$s %2$s\n", _tmp3_, VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	_tmp4_ = options;
	_tmp5_ = g_variant_dict_contains (_tmp4_, "solve");
	if (_tmp5_) {
		gchar* solve_equation = NULL;
		GVariantDict* _tmp6_;
		const GVariantType* _tmp7_;
		GVariant* _tmp8_;
		GVariant* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* tsep_string = NULL;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gboolean _tmp14_ = FALSE;
		const gchar* _tmp15_;
		gchar* decimal = NULL;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		const gchar* _tmp20_;
		GSettings* _tmp22_;
		AngleUnit angle_units = 0;
		GSettings* _tmp23_;
		gint _tmp24_;
		SolveEquation* e = NULL;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		SolveEquation* _tmp32_;
		SolveEquation* _tmp33_;
		SolveEquation* _tmp34_;
		SolveEquation* _tmp35_;
		SolveEquation* _tmp36_;
		AngleUnit _tmp37_;
		ErrorCode _error_ = 0;
		gchar* error_token = NULL;
		guint representation_base = 0U;
		Number* _result_ = NULL;
		SolveEquation* _tmp38_;
		guint _tmp39_ = 0U;
		ErrorCode _tmp40_ = 0;
		gchar* _tmp41_ = NULL;
		Number* _tmp42_;
		Number* _tmp43_;
		_tmp6_ = options;
		_tmp7_ = G_VARIANT_TYPE_STRING;
		_tmp8_ = g_variant_dict_lookup_value (_tmp6_, "solve", _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _variant_get1 (_tmp9_);
		_tmp11_ = _tmp10_;
		_g_variant_unref0 (_tmp9_);
		solve_equation = _tmp11_;
		_tmp12_ = nl_langinfo (THOUSEP);
		_tmp13_ = g_strdup (_tmp12_);
		tsep_string = _tmp13_;
		_tmp15_ = tsep_string;
		if (_tmp15_ == NULL) {
			_tmp14_ = TRUE;
		} else {
			const gchar* _tmp16_;
			_tmp16_ = tsep_string;
			_tmp14_ = g_strcmp0 (_tmp16_, "") == 0;
		}
		if (_tmp14_) {
			gchar* _tmp17_;
			_tmp17_ = g_strdup (" ");
			_g_free0 (tsep_string);
			tsep_string = _tmp17_;
		}
		_tmp18_ = nl_langinfo (RADIXCHAR);
		_tmp19_ = g_strdup (_tmp18_);
		decimal = _tmp19_;
		_tmp20_ = decimal;
		if (_tmp20_ == NULL) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("");
			_g_free0 (decimal);
			decimal = _tmp21_;
		}
		_tmp22_ = g_settings_new ("org.gnome.calculator");
		_g_object_unref0 (self->priv->settings);
		self->priv->settings = _tmp22_;
		_tmp23_ = self->priv->settings;
		_tmp24_ = g_settings_get_enum (_tmp23_, "angle-units");
		angle_units = (AngleUnit) _tmp24_;
		_tmp25_ = solve_equation;
		_tmp26_ = tsep_string;
		_tmp27_ = string_replace (_tmp25_, _tmp26_, "");
		_tmp28_ = _tmp27_;
		_tmp29_ = decimal;
		_tmp30_ = string_replace (_tmp28_, _tmp29_, ".");
		_tmp31_ = _tmp30_;
		_tmp32_ = solve_equation_new (_tmp31_);
		_tmp33_ = _tmp32_;
		_g_free0 (_tmp31_);
		_g_free0 (_tmp28_);
		e = _tmp33_;
		_tmp34_ = e;
		((Equation*) _tmp34_)->base = 10;
		_tmp35_ = e;
		((Equation*) _tmp35_)->wordlen = 32;
		_tmp36_ = e;
		_tmp37_ = angle_units;
		((Equation*) _tmp36_)->angle_units = _tmp37_;
		error_token = NULL;
		_tmp38_ = e;
		_tmp42_ = equation_parse ((Equation*) _tmp38_, &_tmp39_, &_tmp40_, &_tmp41_, NULL, NULL);
		representation_base = _tmp39_;
		_error_ = _tmp40_;
		_g_free0 (error_token);
		error_token = _tmp41_;
		_result_ = _tmp42_;
		_tmp43_ = _result_;
		if (_tmp43_ != NULL) {
			Serializer* serializer = NULL;
			Serializer* _tmp44_;
			Serializer* _tmp45_;
			guint _tmp46_;
			FILE* _tmp47_;
			Serializer* _tmp48_;
			Number* _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
			_tmp44_ = serializer_new (DISPLAY_FORMAT_AUTOMATIC, 10, 9);
			serializer = _tmp44_;
			_tmp45_ = serializer;
			_tmp46_ = representation_base;
			serializer_set_representation_base (_tmp45_, _tmp46_);
			_tmp47_ = stdout;
			_tmp48_ = serializer;
			_tmp49_ = _result_;
			_tmp50_ = serializer_to_string (_tmp48_, _tmp49_);
			_tmp51_ = _tmp50_;
			fprintf (_tmp47_, "%s\n", _tmp51_);
			_g_free0 (_tmp51_);
			result = EXIT_SUCCESS;
			_g_object_unref0 (serializer);
			_g_object_unref0 (_result_);
			_g_free0 (error_token);
			_g_object_unref0 (e);
			_g_free0 (decimal);
			_g_free0 (tsep_string);
			_g_free0 (solve_equation);
			return result;
		} else {
			ErrorCode _tmp52_;
			_tmp52_ = _error_;
			if (_tmp52_ == ERROR_CODE_MP) {
				const gchar* _tmp53_ = NULL;
				const gchar* _tmp54_;
				const gchar* _tmp55_;
				FILE* _tmp59_;
				_tmp54_ = number_get_error ();
				_tmp55_ = _tmp54_;
				if (_tmp55_ != NULL) {
					const gchar* _tmp56_;
					const gchar* _tmp57_;
					_tmp56_ = number_get_error ();
					_tmp57_ = _tmp56_;
					_tmp53_ = _tmp57_;
				} else {
					const gchar* _tmp58_;
					_tmp58_ = error_token;
					_tmp53_ = _tmp58_;
				}
				_tmp59_ = stderr;
				fprintf (_tmp59_, "Error: %s\n", _tmp53_);
				result = EXIT_FAILURE;
				_g_object_unref0 (_result_);
				_g_free0 (error_token);
				_g_object_unref0 (e);
				_g_free0 (decimal);
				_g_free0 (tsep_string);
				_g_free0 (solve_equation);
				return result;
			} else {
				FILE* _tmp60_;
				ErrorCode _tmp61_;
				gchar* _tmp62_;
				gchar* _tmp63_;
				_tmp60_ = stderr;
				_tmp61_ = _error_;
				_tmp62_ = mp_error_code_to_string (_tmp61_);
				_tmp63_ = _tmp62_;
				fprintf (_tmp60_, "Error: %s\n", _tmp63_);
				_g_free0 (_tmp63_);
				result = EXIT_FAILURE;
				_g_object_unref0 (_result_);
				_g_free0 (error_token);
				_g_object_unref0 (e);
				_g_free0 (decimal);
				_g_free0 (tsep_string);
				_g_free0 (solve_equation);
				return result;
			}
		}
		_g_object_unref0 (_result_);
		_g_free0 (error_token);
		_g_object_unref0 (e);
		_g_free0 (decimal);
		_g_free0 (tsep_string);
		_g_free0 (solve_equation);
	}
	result = -1;
	return result;
}


static void calculator_show_preferences_cb (Calculator* self) {
	MathPreferencesDialog* _tmp0_;
	MathPreferencesDialog* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	if (_tmp0_ == NULL) {
		MathWindow* _tmp1_;
		MathWindow* _tmp2_;
		MathEquation* _tmp3_;
		MathEquation* _tmp4_;
		MathPreferencesDialog* _tmp5_;
		MathPreferencesDialog* _tmp6_;
		GtkWindow* _tmp7_;
		_tmp1_ = calculator_get_active_math_window (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = math_window_get_equation (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = math_preferences_dialog_new (_tmp4_);
		g_object_ref_sink (_tmp5_);
		_g_object_unref0 (self->priv->preferences_dialog);
		self->priv->preferences_dialog = _tmp5_;
		_g_object_unref0 (_tmp2_);
		_tmp6_ = self->priv->preferences_dialog;
		_tmp7_ = gtk_application_get_active_window ((GtkApplication*) self);
		gtk_window_set_transient_for ((GtkWindow*) _tmp6_, _tmp7_);
	}
	_tmp8_ = self->priv->preferences_dialog;
	gtk_window_present ((GtkWindow*) _tmp8_);
}


static void ___lambda35_ (Calculator* self, GtkWidget* event) {
	g_return_if_fail (event != NULL);
	_g_object_unref0 (self->priv->shortcuts_window);
	self->priv->shortcuts_window = NULL;
}


static void ____lambda35__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	___lambda35_ ((Calculator*) self, _sender);
}


static void calculator_keyboard_shortcuts_cb (Calculator* self) {
	GtkShortcutsWindow* _tmp0_;
	GtkWindow* _tmp8_;
	GtkShortcutsWindow* _tmp9_;
	GtkWindow* _tmp10_;
	GtkShortcutsWindow* _tmp13_;
	GtkShortcutsWindow* _tmp14_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->shortcuts_window;
	if (_tmp0_ == NULL) {
		GtkBuilder* builder = NULL;
		GtkBuilder* _tmp1_;
		GtkBuilder* _tmp4_;
		GObject* _tmp5_;
		GtkShortcutsWindow* _tmp6_;
		GtkShortcutsWindow* _tmp7_;
		_tmp1_ = gtk_builder_new ();
		builder = _tmp1_;
		{
			GtkBuilder* _tmp2_;
			_tmp2_ = builder;
			gtk_builder_add_from_resource (_tmp2_, "/org/gnome/calculator/math-shortcuts.ui", &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch2_g_error;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp3_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp3_ = e->message;
			g_error ("gnome-calculator.vala:274: Error loading shortcuts window UI: %s", _tmp3_);
			_g_error_free0 (e);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (builder);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp4_ = builder;
		_tmp5_ = gtk_builder_get_object (_tmp4_, "shortcuts-calculator");
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, GTK_TYPE_SHORTCUTS_WINDOW) ? ((GtkShortcutsWindow*) _tmp5_) : NULL);
		_g_object_unref0 (self->priv->shortcuts_window);
		self->priv->shortcuts_window = _tmp6_;
		_tmp7_ = self->priv->shortcuts_window;
		g_signal_connect_object ((GtkWidget*) _tmp7_, "destroy", (GCallback) ____lambda35__gtk_widget_destroy, self, 0);
		_g_object_unref0 (builder);
	}
	_tmp8_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp9_ = self->priv->shortcuts_window;
	_tmp10_ = gtk_window_get_transient_for ((GtkWindow*) _tmp9_);
	if (_tmp8_ != _tmp10_) {
		GtkShortcutsWindow* _tmp11_;
		GtkWindow* _tmp12_;
		_tmp11_ = self->priv->shortcuts_window;
		_tmp12_ = gtk_application_get_active_window ((GtkApplication*) self);
		gtk_window_set_transient_for ((GtkWindow*) _tmp11_, _tmp12_);
	}
	_tmp13_ = self->priv->shortcuts_window;
	gtk_widget_show_all ((GtkWidget*) _tmp13_);
	_tmp14_ = self->priv->shortcuts_window;
	gtk_window_present ((GtkWindow*) _tmp14_);
}


static void calculator_help_cb (Calculator* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GtkWindow* _tmp0_;
		GdkScreen* _tmp1_;
		guint32 _tmp2_;
		_tmp0_ = gtk_application_get_active_window ((GtkApplication*) self);
		_tmp1_ = gtk_window_get_screen (_tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "help:gnome-calculator", _tmp2_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		gchar* message = NULL;
		gchar* _tmp3_;
		GtkMessageDialog* d = NULL;
		GtkWindow* _tmp4_;
		const gchar* _tmp5_;
		GtkMessageDialog* _tmp6_;
		GtkMessageDialog* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		GtkMessageDialog* _tmp10_;
		GtkMessageDialog* _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = g_strdup (_ ("Unable to open help file"));
		message = _tmp3_;
		_tmp4_ = gtk_application_get_active_window ((GtkApplication*) self);
		_tmp5_ = message;
		_tmp6_ = (GtkMessageDialog*) gtk_message_dialog_new (_tmp4_, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", _tmp5_);
		g_object_ref_sink (_tmp6_);
		d = _tmp6_;
		_tmp7_ = d;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		gtk_message_dialog_format_secondary_text (_tmp7_, "%s", _tmp9_);
		_tmp10_ = d;
		gtk_dialog_run ((GtkDialog*) _tmp10_);
		_tmp11_ = d;
		gtk_widget_destroy ((GtkWidget*) _tmp11_);
		_g_object_unref0 (d);
		_g_free0 (message);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void calculator_about_cb (Calculator* self) {
	gchar** authors = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gint authors_length1;
	gint _authors_size_;
	gchar** documenters = NULL;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gint documenters_length1;
	gint _documenters_size_;
	gchar* translator_credits = NULL;
	gchar* _tmp8_;
	GtkWindow* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Rich Burridge <rich.burridge@gmail.com>");
	_tmp1_ = g_strdup ("Robert Ancell <robert.ancell@gmail.com>");
	_tmp2_ = g_strdup ("Klaus Niederkrüger <kniederk@umpa.ens-lyon.fr>");
	_tmp3_ = g_strdup ("Robin Sonefors <ozamosi@flukkost.nu>");
	_tmp4_ = g_strdup ("Robert Roth <robert.roth.off@gmail.com>");
	_tmp5_ = g_new0 (gchar*, 6 + 1);
	_tmp5_[0] = _tmp0_;
	_tmp5_[1] = _tmp1_;
	_tmp5_[2] = _tmp2_;
	_tmp5_[3] = _tmp3_;
	_tmp5_[4] = _tmp4_;
	_tmp5_[5] = NULL;
	authors = _tmp5_;
	authors_length1 = 6;
	_authors_size_ = authors_length1;
	_tmp6_ = g_strdup ("Sun Microsystems");
	_tmp7_ = g_new0 (gchar*, 2 + 1);
	_tmp7_[0] = _tmp6_;
	_tmp7_[1] = NULL;
	documenters = _tmp7_;
	documenters_length1 = 2;
	_documenters_size_ = documenters_length1;
	_tmp8_ = g_strdup (_ ("translator-credits"));
	translator_credits = _tmp8_;
	_tmp9_ = gtk_application_get_active_window ((GtkApplication*) self);
	gtk_show_about_dialog (_tmp9_, "program-name", _ ("Calculator"), "title", _ ("About Calculator"), "version", VERSION, "copyright", "\xc2\xa9 1986–2016 The Calculator authors", "license-type", GTK_LICENSE_GPL_3_0, "comments", _ ("Calculator with financial and scientific modes."), "authors", authors, "documenters", documenters, "translator_credits", translator_credits, "logo-icon-name", "accessories-calculator", NULL);
	_g_free0 (translator_credits);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}


static void calculator_quit_cb (Calculator* self) {
	MathWindow* _tmp0_;
	MathWindow* _tmp1_;
	GtkWindow* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = calculator_get_active_math_window (self);
	_tmp1_ = _tmp0_;
	calculator_save_window_position (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = gtk_application_get_active_window ((GtkApplication*) self);
	gtk_widget_destroy ((GtkWidget*) _tmp2_);
}


static void calculator_new_window_cb (Calculator* self) {
	MathWindow* window = NULL;
	GSettings* _tmp0_;
	MathWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = calculator_create_new_window (self, _tmp0_);
	window = _tmp1_;
	gtk_window_present ((GtkWindow*) window);
	_g_object_unref0 (window);
}


/**
     * Load `window-position` from the settings and move the window to that
     * position
     */
static void calculator_load_window_position (Calculator* self, MathWindow* window) {
	gint32 x = 0;
	gint32 y = 0;
	GSettings* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gint32 _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->settings;
	g_settings_get (_tmp0_, "window-position", "(ii)", &x, &y);
	_tmp2_ = x;
	if (_tmp2_ != ((gint32) -1)) {
		gint32 _tmp3_;
		_tmp3_ = y;
		_tmp1_ = _tmp3_ != ((gint32) -1);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		MathWindow* _tmp4_;
		gint32 _tmp5_;
		gint32 _tmp6_;
		_tmp4_ = window;
		_tmp5_ = x;
		_tmp6_ = y;
		gtk_window_move ((GtkWindow*) _tmp4_, (gint) _tmp5_, (gint) _tmp6_);
	}
}


/**
     * Save window position to the settings
     */
static void calculator_save_window_position (Calculator* self, MathWindow* window) {
	gint32 x = 0;
	gint32 y = 0;
	MathWindow* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GSettings* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = window;
	gtk_window_get_position ((GtkWindow*) _tmp0_, &_tmp1_, &_tmp2_);
	x = (gint32) _tmp1_;
	y = (gint32) _tmp2_;
	_tmp3_ = self->priv->settings;
	_tmp4_ = g_variant_new ("(ii)", x, y, NULL);
	g_variant_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	g_settings_set_value (_tmp3_, "window-position", _tmp5_);
	_g_variant_unref0 (_tmp5_);
}


gint calculator_main (gchar** args, int args_length1) {
	gint result = 0;
	GDateTime* now = NULL;
	GDateTime* _tmp0_;
	gint _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	Calculator* app = NULL;
	Calculator* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = g_date_time_new_now_utc ();
	now = _tmp0_;
	_tmp1_ = g_date_time_get_microsecond (now);
	g_random_set_seed ((guint32) _tmp1_);
	_tmp2_ = args;
	_tmp2__length1 = args_length1;
	_tmp3_ = _tmp2_[0];
	_tmp4_ = g_path_get_basename (_tmp3_);
	_g_free0 (calculator_program_name);
	calculator_program_name = _tmp4_;
	gtk_window_set_default_icon_name ("accessories-calculator");
	_tmp5_ = calculator_new ();
	app = _tmp5_;
	_tmp6_ = args;
	_tmp6__length1 = args_length1;
	_tmp7_ = g_application_run ((GApplication*) app, _tmp6__length1, _tmp6_);
	result = _tmp7_;
	_g_object_unref0 (app);
	_g_date_time_unref0 (now);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return calculator_main (argv, argc);
}


static void calculator_class_init (CalculatorClass * klass) {
	calculator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CalculatorPrivate));
	((GApplicationClass *) klass)->startup = (void (*) (GApplication *)) calculator_real_startup;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication *)) calculator_real_activate;
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication *)) calculator_real_shutdown;
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication *, GVariantDict*)) calculator_real_handle_local_options;
	G_OBJECT_CLASS (klass)->finalize = calculator_finalize;
}


static void calculator_instance_init (Calculator * self) {
	self->priv = CALCULATOR_GET_PRIVATE (self);
	self->priv->n_math_windows = 0;
}


static void calculator_finalize (GObject * obj) {
	Calculator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CALCULATOR, Calculator);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->last_opened_window);
	_g_object_unref0 (self->priv->preferences_dialog);
	_g_object_unref0 (self->priv->shortcuts_window);
	G_OBJECT_CLASS (calculator_parent_class)->finalize (obj);
}


GType calculator_get_type (void) {
	static volatile gsize calculator_type_id__volatile = 0;
	if (g_once_init_enter (&calculator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CalculatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) calculator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Calculator), 0, (GInstanceInitFunc) calculator_instance_init, NULL };
		GType calculator_type_id;
		calculator_type_id = g_type_register_static (gtk_application_get_type (), "Calculator", &g_define_type_info, 0);
		g_once_init_leave (&calculator_type_id__volatile, calculator_type_id);
	}
	return calculator_type_id__volatile;
}


SolveEquation* solve_equation_construct (GType object_type, const gchar* text) {
	SolveEquation * self = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = text;
	self = (SolveEquation*) equation_construct (object_type, _tmp0_);
	return self;
}


SolveEquation* solve_equation_new (const gchar* text) {
	return solve_equation_construct (TYPE_SOLVE_EQUATION, text);
}


static Number* solve_equation_real_convert (Equation* base, Number* x, const gchar* x_units, const gchar* z_units) {
	SolveEquation * self;
	Number* result = NULL;
	UnitManager* _tmp0_;
	UnitManager* _tmp1_;
	Number* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	Number* _tmp5_;
	Number* _tmp6_;
	self = (SolveEquation*) base;
	g_return_val_if_fail (x != NULL, NULL);
	g_return_val_if_fail (x_units != NULL, NULL);
	g_return_val_if_fail (z_units != NULL, NULL);
	_tmp0_ = unit_manager_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = x;
	_tmp3_ = x_units;
	_tmp4_ = z_units;
	_tmp5_ = unit_manager_convert_by_symbol (_tmp1_, _tmp2_, _tmp3_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp1_);
	result = _tmp6_;
	return result;
}


static void solve_equation_class_init (SolveEquationClass * klass) {
	solve_equation_parent_class = g_type_class_peek_parent (klass);
	((EquationClass *) klass)->convert = (Number* (*) (Equation *, Number*, const gchar*, const gchar*)) solve_equation_real_convert;
}


static void solve_equation_instance_init (SolveEquation * self) {
}


GType solve_equation_get_type (void) {
	static volatile gsize solve_equation_type_id__volatile = 0;
	if (g_once_init_enter (&solve_equation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SolveEquationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) solve_equation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SolveEquation), 0, (GInstanceInitFunc) solve_equation_instance_init, NULL };
		GType solve_equation_type_id;
		solve_equation_type_id = g_type_register_static (TYPE_EQUATION, "SolveEquation", &g_define_type_info, 0);
		g_once_init_leave (&solve_equation_type_id__volatile, solve_equation_type_id);
	}
	return solve_equation_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



