/* gmpc-easy-command.c generated by valac 0.12.0, the Vala compiler
 * generated from gmpc-easy-command.vala, do not modify */

/* Gnome Music Player Client (GMPC)
 * Copyright (C) 2004-2011 Qball Cow <qball@gmpclient.org>
 * Project homepage: http://gmpclient.org/
 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtktransition.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include "gmpc-extras.h"
#include <glib/gi18n-lib.h>
#include <plugin.h>
#include <config1.h>
#include <playlist3-messages.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

struct _GmpcEasyCommandPrivate {
	GtkEntryCompletion* completion;
	guint signals;
	GtkWindow* window;
};


static gpointer gmpc_easy_command_parent_class = NULL;

#define use_transition_ec TRUE
#define some_unique_name_ec VERSION
#define log_domain_ec "EasyCommand"
#define GMPC_EASY_COMMAND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GMPC_EASY_TYPE_COMMAND, GmpcEasyCommandPrivate))
enum  {
	GMPC_EASY_COMMAND_DUMMY_PROPERTY
};
static const gchar* gmpc_easy_command_real_get_name (GmpcPluginBase* base);
static gint* gmpc_easy_command_real_get_version (GmpcPluginBase* base, int* result_length1);
static gboolean gmpc_easy_command_real_get_enabled (GmpcPluginBase* base);
static void gmpc_easy_command_real_set_enabled (GmpcPluginBase* base, gboolean state);
static void gmpc_easy_command_activate (GmpcEasyCommand* self, GtkEntry* entry);
static gboolean gmpc_easy_command_key_press_event (GmpcEasyCommand* self, GtkWidget* widget, GdkEventKey* event);
static gboolean gmpc_easy_command_popup_expose_handler (GmpcEasyCommand* self, GtkWidget* widget, GdkEventExpose* event);
static void _lambda0_ (GtkEntry* source, GtkEntryIconPosition pos, GdkEvent* event, GmpcEasyCommand* self);
static void __lambda0__gtk_entry_icon_release (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self);
static gboolean _gmpc_easy_command_popup_expose_handler_gtk_widget_expose_event (GtkWidget* _sender, GdkEventExpose* event, gpointer self);
static void _gmpc_easy_command_activate_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static gboolean _gmpc_easy_command_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static gboolean _lambda1_ (GtkWidget* source, GdkEventButton* event, GmpcEasyCommand* self);
static gboolean __lambda1__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void _gmpc_easy_command_help_window_destroy_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static GObject * gmpc_easy_command_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gboolean _gmpc_easy_command_completion_function_gtk_entry_completion_match_func (GtkEntryCompletion* completion, const gchar* key, GtkTreeIter* iter, gpointer self);
static void gmpc_easy_command_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const gint GMPC_EASY_COMMAND_version[3] = {0, 0, 1};

/**
 * Required plugin implementation
 */
static const gchar* gmpc_easy_command_real_get_name (GmpcPluginBase* base) {
	GmpcEasyCommand * self;
	const gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	self = (GmpcEasyCommand*) base;
	_tmp0_ = _ ("Gmpc Easy Command");
	result = _tmp0_;
	return result;
}


static gint* gmpc_easy_command_real_get_version (GmpcPluginBase* base, int* result_length1) {
	GmpcEasyCommand * self;
	gint* result = NULL;
	gint* _tmp0_;
	self = (GmpcEasyCommand*) base;
	_tmp0_ = GMPC_EASY_COMMAND_version;
	*result_length1 = G_N_ELEMENTS (GMPC_EASY_COMMAND_version);
	result = _tmp0_;
	return result;
}


/**
     * Get set enabled
     */
static gboolean gmpc_easy_command_real_get_enabled (GmpcPluginBase* base) {
	GmpcEasyCommand * self;
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_;
	self = (GmpcEasyCommand*) base;
	_tmp0_ = gmpc_plugin_base_get_name ((GmpcPluginBase*) self);
	_tmp1_ = cfg_get_single_value_as_int_with_default (config, _tmp0_, "enabled", 1);
	result = (gboolean) _tmp1_;
	return result;
}


static void gmpc_easy_command_real_set_enabled (GmpcPluginBase* base, gboolean state) {
	GmpcEasyCommand * self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	self = (GmpcEasyCommand*) base;
	if (!state) {
		_tmp0_ = self->priv->window != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gmpc_easy_command_popup_destroy (self);
	}
	_tmp1_ = gmpc_plugin_base_get_name ((GmpcPluginBase*) self);
	cfg_set_single_value_as_int (config, _tmp1_, "enabled", (gint) state);
}


/************************************************
 * private
 */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


gboolean gmpc_easy_command_completion_function (GtkEntryCompletion* comp, const gchar* key, GtkTreeIter* iter) {
	gboolean result = FALSE;
	gchar* value = NULL;
	gchar* pattern = NULL;
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* model;
	g_return_val_if_fail (comp != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = gtk_entry_completion_get_model (comp);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	model = _tmp1_;
	gtk_tree_model_get (model, iter, 1, &value, 2, &pattern, -1);
	if (value != NULL) {
		gchar* a = NULL;
		gint _tmp2_;
		gint _tmp3_;
		gchar* _tmp14_;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_;
		gboolean _tmp19_;
		gboolean _tmp20_;
		_tmp2_ = strlen (key);
		_tmp3_ = strlen (value);
		if (_tmp2_ < _tmp3_) {
			gint _tmp4_;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			gchar* _tmp7_ = NULL;
			_tmp4_ = strlen (key);
			_tmp5_ = string_substring (value, (glong) 0, (glong) _tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_strdup_printf ("^%s", _tmp6_);
			_g_free0 (a);
			a = _tmp7_;
			_g_free0 (_tmp6_);
		} else {
			gchar* _tmp8_ = NULL;
			gboolean _tmp9_ = FALSE;
			_tmp8_ = g_strdup_printf ("^%s", value);
			_g_free0 (a);
			a = _tmp8_;
			if (pattern != NULL) {
				gint _tmp10_;
				_tmp10_ = strlen (pattern);
				_tmp9_ = _tmp10_ > 0;
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp11_ = g_strdup_printf ("[ ]*(%s)", pattern);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_strconcat (a, _tmp12_, NULL);
				_g_free0 (a);
				a = _tmp13_;
				_g_free0 (_tmp12_);
			}
		}
		_tmp14_ = g_strconcat (a, "$", NULL);
		_g_free0 (a);
		a = _tmp14_;
		_tmp15_ = g_utf8_strdown (a, (gssize) (-1));
		_tmp16_ = _tmp15_;
		_tmp17_ = g_utf8_strdown (key, (gssize) (-1));
		_tmp18_ = _tmp17_;
		_tmp19_ = g_regex_match_simple (_tmp16_, _tmp18_, G_REGEX_CASELESS, 0);
		_tmp20_ = _tmp19_;
		_g_free0 (_tmp18_);
		_g_free0 (_tmp16_);
		result = _tmp20_;
		_g_free0 (a);
		_g_object_unref0 (model);
		_g_free0 (pattern);
		_g_free0 (value);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (model);
	_g_free0 (pattern);
	_g_free0 (value);
	return result;
}


/**
     * Add a match entry to the Easy command object.
     * param self the GmpcEasyCommand object.
     * param name the name of the command. This is the "prefix" that needs to be matched.
     * param pattern the pattern where the parameters need to match.
     * param callback a GmpcEasyCommandCallback that returns when a entry is matched.
     * param userdata a pointer that is passed to callback.
     *
     * return an unique id for the entry.
     */
guint gmpc_easy_command_add_entry (GmpcEasyCommand* self, const gchar* name, const gchar* pattern, const gchar* hint, GmpcEasyCommandCallback* callback, void* userdata) {
	guint result = 0U;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (name != NULL, 0U);
	g_return_val_if_fail (pattern != NULL, 0U);
	g_return_val_if_fail (hint != NULL, 0U);
	self->priv->signals++;
	gtk_list_store_append (self->store, &_tmp0_);
	iter = _tmp0_;
	gtk_list_store_set (self->store, &iter, 0, self->priv->signals, 1, name, 2, pattern, 3, callback, 4, userdata, 5, hint, -1, -1);
	result = self->priv->signals;
	return result;
}


/**
     * Add a match entry to the Easy command object.
     * param self the GmpcEasyCommand object.
     * param name the name of the command. This is the "prefix" that needs to be matched.
     * param pattern the pattern where the parameters need to match.
     * param callback a GmpcEasyCommandCallback that returns when a entry is matched.
     * param userdata a pointer that is passed to callback.
 * param icon a icon-name to be displayed
     *
     * return an unique id for the entry.
     */
guint gmpc_easy_command_add_entry_stock_id (GmpcEasyCommand* self, const gchar* name, const gchar* pattern, const gchar* hint, GmpcEasyCommandCallback* callback, void* userdata, const gchar* icon) {
	guint result = 0U;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (name != NULL, 0U);
	g_return_val_if_fail (pattern != NULL, 0U);
	g_return_val_if_fail (hint != NULL, 0U);
	g_return_val_if_fail (icon != NULL, 0U);
	self->priv->signals++;
	gtk_list_store_append (self->store, &_tmp0_);
	iter = _tmp0_;
	gtk_list_store_set (self->store, &iter, 0, self->priv->signals, 1, name, 2, pattern, 3, callback, 4, userdata, 5, hint, 7, icon, -1);
	result = self->priv->signals;
	return result;
}


guint gmpc_easy_command_add_entry_icon_name (GmpcEasyCommand* self, const gchar* name, const gchar* pattern, const gchar* hint, GmpcEasyCommandCallback* callback, void* userdata, const gchar* icon) {
	guint result = 0U;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (name != NULL, 0U);
	g_return_val_if_fail (pattern != NULL, 0U);
	g_return_val_if_fail (hint != NULL, 0U);
	g_return_val_if_fail (icon != NULL, 0U);
	self->priv->signals++;
	gtk_list_store_append (self->store, &_tmp0_);
	iter = _tmp0_;
	gtk_list_store_set (self->store, &iter, 0, self->priv->signals, 1, name, 2, pattern, 3, callback, 4, userdata, 5, hint, 6, icon, -1);
	result = self->priv->signals;
	return result;
}


static void gmpc_easy_command_activate (GmpcEasyCommand* self, GtkEntry* entry) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* value_unsplit;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = gtk_entry_get_text (entry);
	_tmp1_ = g_strdup (_tmp0_);
	value_unsplit = _tmp1_;
	gmpc_easy_command_popup_destroy (self);
	gmpc_easy_command_do_query (self, value_unsplit);
	_g_free0 (value_unsplit);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


void gmpc_easy_command_do_query (GmpcEasyCommand* self, const gchar* value_unsplit) {
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	gint _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (value_unsplit != NULL);
	model = (GtkTreeModel*) self->store;
	g_log (log_domain_ec, G_LOG_LEVEL_DEBUG, "gmpc-easy-command.vala:196: doing query: %s", value_unsplit);
	_tmp0_ = strlen (value_unsplit);
	if (_tmp0_ == 0) {
		if (self->priv->window != NULL) {
			gmpc_easy_command_popup_destroy (self);
		}
		return;
	}
	_tmp2_ = _tmp1_ = g_strsplit (value_unsplit, ";", 0);
	{
		gchar** value_collection;
		int value_collection_length1;
		int value_it;
		value_collection = _tmp2_;
		value_collection_length1 = _vala_array_length (_tmp1_);
		for (value_it = 0; value_it < _vala_array_length (_tmp1_); value_it = value_it + 1) {
			gchar* _tmp3_;
			gchar* value;
			_tmp3_ = g_strdup (value_collection[value_it]);
			value = _tmp3_;
			{
				gboolean found;
				gchar* _tmp4_ = NULL;
				GtkTreeIter _tmp5_ = {0};
				gboolean _tmp6_;
				found = FALSE;
				_tmp4_ = string_strip (value);
				_g_free0 (value);
				value = _tmp4_;
				g_log (log_domain_ec, G_LOG_LEVEL_DEBUG, "gmpc-easy-command.vala:206: doing query: %s", value);
				_tmp6_ = gtk_tree_model_get_iter_first (model, &_tmp5_);
				iter = _tmp5_;
				if (_tmp6_) {
					{
						gboolean _tmp7_;
						_tmp7_ = TRUE;
						while (TRUE) {
							gchar* name = NULL;
							gchar* pattern = NULL;
							gchar* test = NULL;
							GmpcEasyCommandCallback callback;
							void* callback_target = NULL;
							GDestroyNotify callback_target_destroy_notify = NULL;
							void* data = NULL;
							gchar* _tmp10_ = NULL;
							gboolean _tmp11_;
							if (!_tmp7_) {
								gboolean _tmp8_ = FALSE;
								gboolean _tmp9_;
								_tmp9_ = gtk_tree_model_iter_next (model, &iter);
								if (_tmp9_) {
									_tmp8_ = !found;
								} else {
									_tmp8_ = FALSE;
								}
								if (!_tmp8_) {
									break;
								}
							}
							_tmp7_ = FALSE;
							callback = NULL;
							callback_target = NULL;
							callback_target_destroy_notify = NULL;
							gtk_tree_model_get (model, &iter, 1, &name, 2, &pattern, 3, &callback, 4, &data, -1);
							_tmp10_ = g_strdup_printf ("^%s[ ]*%s$", name, pattern);
							_g_free0 (test);
							test = _tmp10_;
							g_log (log_domain_ec, G_LOG_LEVEL_DEBUG, "gmpc-easy-command.vala:216: doing query: %s-%s", test, value);
							_tmp11_ = g_regex_match_simple (test, value, G_REGEX_CASELESS, 0);
							if (_tmp11_) {
								gchar* param = NULL;
								gint _tmp12_;
								gint _tmp13_;
								gchar* _tmp17_ = NULL;
								gchar* param_str;
								g_log (log_domain_ec, G_LOG_LEVEL_DEBUG, "gmpc-easy-command.vala:220: Found match");
								_tmp12_ = strlen (value);
								_tmp13_ = strlen (name);
								if (_tmp12_ > _tmp13_) {
									gint _tmp14_;
									gchar* _tmp15_ = NULL;
									_tmp14_ = strlen (name);
									_tmp15_ = string_substring (value, (glong) _tmp14_, (glong) (-1));
									_g_free0 (param);
									param = _tmp15_;
								} else {
									gchar* _tmp16_;
									_tmp16_ = g_strdup ("");
									_g_free0 (param);
									param = _tmp16_;
								}
								_tmp17_ = string_strip (param);
								param_str = _tmp17_;
								callback (data, param_str, callback_target);
								found = TRUE;
								_g_free0 (param_str);
								_g_free0 (param);
							}
							(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
							callback = NULL;
							callback_target = NULL;
							callback_target_destroy_notify = NULL;
							_g_free0 (test);
							_g_free0 (pattern);
							_g_free0 (name);
						}
					}
				}
				if (!found) {
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_;
					_tmp18_ = g_strdup_printf ("Unknown command: '%s'", value);
					_tmp19_ = _tmp18_;
					playlist3_show_error_message (_tmp19_, ERROR_INFO);
					_g_free0 (_tmp19_);
				}
				_g_free0 (value);
			}
		}
		value_collection = (_vala_array_free (value_collection, value_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	if (self->priv->window != NULL) {
		gmpc_easy_command_popup_destroy (self);
	}
}


static gboolean gmpc_easy_command_key_press_event (GmpcEasyCommand* self, GtkWidget* widget, GdkEventKey* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	if ((*event).keyval == 0xff1b) {
		gmpc_easy_command_popup_destroy (self);
		result = TRUE;
		return result;
	}
	if ((*event).keyval == 0xff09) {
		gtk_editable_set_position (GTK_EDITABLE (widget), -1);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean gmpc_easy_command_popup_expose_handler (GmpcEasyCommand* self, GtkWidget* widget, GdkEventExpose* event) {
	gboolean result = FALSE;
	cairo_t* _tmp0_ = NULL;
	cairo_t* ctx;
	gint width;
	gint height;
	GtkStyle* _tmp1_ = NULL;
	GdkColor light;
	GtkStyle* _tmp2_ = NULL;
	GdkColor dark;
	gboolean _tmp3_;
	gboolean _tmp6_;
	cairo_pattern_t* _tmp7_ = NULL;
	cairo_pattern_t* pattern;
	GtkStyle* _tmp8_ = NULL;
	GdkColor _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	_tmp0_ = gdk_cairo_create ((GdkDrawable*) widget->window);
	ctx = _tmp0_;
	width = widget->allocation.width;
	height = widget->allocation.height;
	_tmp1_ = gtk_widget_get_style (widget);
	light = _tmp1_->bg[GTK_STATE_ACTIVE];
	_tmp2_ = gtk_widget_get_style (widget);
	dark = _tmp2_->dark[GTK_STATE_ACTIVE];
	cairo_set_antialias (ctx, CAIRO_ANTIALIAS_DEFAULT);
	cairo_set_line_width (ctx, 1.1);
	_tmp3_ = gtk_widget_is_composited (widget);
	if (_tmp3_) {
		cairo_set_operator (ctx, CAIRO_OPERATOR_SOURCE);
		cairo_set_source_rgba (ctx, 1.0, 1.0, 1.0, 0.0);
	} else {
		GtkStyle* _tmp4_ = NULL;
		GdkColor _tmp5_;
		_tmp4_ = gtk_widget_get_style (widget);
		_tmp5_ = _tmp4_->bg[GTK_STATE_ACTIVE];
		gdk_cairo_set_source_color (ctx, &_tmp5_);
	}
	cairo_paint (ctx);
	_tmp6_ = gtk_widget_is_composited (widget);
	if (_tmp6_) {
		cairo_move_to (ctx, 0.5, 20.5);
		cairo_arc (ctx, 20 + 0.5, 20 + 0.5, (gdouble) 20, -G_PI, (-G_PI) / 2.0);
		cairo_line_to (ctx, (width - 20) - 0.5, 0.5);
		cairo_arc (ctx, (width - 20) - 0.5, 20 + 0.5, (gdouble) 20, (-G_PI) / 2.0, (gdouble) 0);
		cairo_line_to (ctx, width - 0.5, (height - 20) - 0.5);
		cairo_arc (ctx, (width - 20) - 0.5, (height - 20) - 0.5, (gdouble) 20, (gdouble) 0, G_PI / 2.0);
		cairo_line_to (ctx, 20 - 0.5, height - 0.5);
		cairo_arc (ctx, 20 + 0.5, (height - 20) - 0.5, (gdouble) 20, G_PI / 2.0, -G_PI);
		cairo_close_path (ctx);
	} else {
		cairo_rectangle (ctx, 1.0, 1.0, (gdouble) (width - 2), (gdouble) (height - 2));
	}
	_tmp7_ = cairo_pattern_create_linear (0.0, 0.0, 0.0, (gdouble) height);
	pattern = _tmp7_;
	cairo_pattern_add_color_stop_rgb (pattern, 0.4, light.red / 65535.0, light.green / 65535.0, light.blue / 65535.0);
	cairo_pattern_add_color_stop_rgb (pattern, 0.8, dark.red / 65535.0, dark.green / 65535.0, dark.blue / 65535.0);
	cairo_set_source (ctx, pattern);
	cairo_fill_preserve (ctx);
	_tmp8_ = gtk_widget_get_style (widget);
	_tmp9_ = _tmp8_->fg[GTK_STATE_ACTIVE];
	gdk_cairo_set_source_color (ctx, &_tmp9_);
	cairo_stroke (ctx);
	result = FALSE;
	_cairo_pattern_destroy0 (pattern);
	_cairo_destroy0 (ctx);
	return result;
}


void gmpc_easy_command_popup_destroy (GmpcEasyCommand* self) {
	guint32 _tmp0_;
	guint32 _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_get_current_event_time ();
	gdk_keyboard_ungrab (_tmp0_);
	_tmp1_ = gtk_get_current_event_time ();
	gdk_pointer_ungrab (_tmp1_);
	gtk_object_destroy ((GtkObject*) self->priv->window);
	_g_object_unref0 (self->priv->window);
	self->priv->window = NULL;
}


/** 
     * Tell gmpc-easy-command to popup.
     * @param self The GmpcEasyCommand object to popup
     *
     * This function will popup GmpcEasyCommand, or if allready open, preset it to the user.
     */
static void _lambda0_ (GtkEntry* source, GtkEntryIconPosition pos, GdkEvent* event, GmpcEasyCommand* self) {
	g_return_if_fail (source != NULL);
	g_return_if_fail (event != NULL);
	if (pos == GTK_ENTRY_ICON_SECONDARY) {
		gtk_entry_set_text (source, "");
	} else {
		gmpc_easy_command_popup_destroy (self);
	}
}


static void __lambda0__gtk_entry_icon_release (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self) {
	_lambda0_ (_sender, p0, p1, self);
}


static gboolean _gmpc_easy_command_popup_expose_handler_gtk_widget_expose_event (GtkWidget* _sender, GdkEventExpose* event, gpointer self) {
	gboolean result;
	result = gmpc_easy_command_popup_expose_handler (self, _sender, event);
	return result;
}


static void _gmpc_easy_command_activate_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	gmpc_easy_command_activate (self, _sender);
}


static gboolean _gmpc_easy_command_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = gmpc_easy_command_key_press_event (self, _sender, event);
	return result;
}


static gboolean _lambda1_ (GtkWidget* source, GdkEventButton* event, GmpcEasyCommand* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (source != NULL, FALSE);
	gmpc_easy_command_popup_destroy (self);
	result = FALSE;
	return result;
}


static gboolean __lambda1__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = _lambda1_ (_sender, event, self);
	return result;
}


void gmpc_easy_command_popup (GmpcEasyCommand* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gmpc_plugin_base_get_enabled ((GmpcPluginBase*) self);
	if (!_tmp0_) {
		return;
	}
	if (self->priv->window == NULL) {
		GtkWindow* _tmp1_ = NULL;
		GtkEntry* _tmp2_ = NULL;
		GtkEntry* entry;
		gboolean _tmp3_;
		_tmp1_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_TOPLEVEL);
		_g_object_unref0 (self->priv->window);
		self->priv->window = g_object_ref_sink (_tmp1_);
		_tmp2_ = (GtkEntry*) gtk_entry_new ();
		entry = g_object_ref_sink (_tmp2_);
		gtk_entry_set_icon_from_icon_name (entry, GTK_ENTRY_ICON_PRIMARY, "gmpc");
		gtk_entry_set_icon_from_stock (entry, GTK_ENTRY_ICON_SECONDARY, "gtk-clear");
		g_signal_connect_object (entry, "icon-release", (GCallback) __lambda0__gtk_entry_icon_release, self, 0);
		gtk_window_set_role (self->priv->window, "easy command");
		gtk_window_set_type_hint (self->priv->window, GDK_WINDOW_TYPE_HINT_UTILITY);
		gtk_window_set_position (self->priv->window, GTK_WIN_POS_CENTER_ALWAYS);
		gtk_window_set_decorated (self->priv->window, FALSE);
		gtk_window_set_modal (self->priv->window, TRUE);
		gtk_window_set_keep_above (self->priv->window, TRUE);
		gtk_window_stick (self->priv->window);
		gtk_container_set_border_width ((GtkContainer*) self->priv->window, (guint) 24);
		gtk_entry_set_width_chars (entry, 50);
		gtk_container_add ((GtkContainer*) self->priv->window, (GtkWidget*) entry);
		_tmp3_ = gtk_widget_is_composited ((GtkWidget*) self->priv->window);
		if (_tmp3_) {
			GdkScreen* _tmp4_ = NULL;
			GdkScreen* _tmp5_;
			GdkScreen* screen;
			GdkColormap* _tmp6_ = NULL;
			GdkColormap* _tmp7_;
			GdkColormap* colormap;
			_tmp4_ = gtk_window_get_screen (self->priv->window);
			_tmp5_ = _g_object_ref0 (_tmp4_);
			screen = _tmp5_;
			_tmp6_ = gdk_screen_get_rgba_colormap (screen);
			_tmp7_ = _g_object_ref0 (_tmp6_);
			colormap = _tmp7_;
			gtk_widget_set_colormap ((GtkWidget*) self->priv->window, colormap);
			_g_object_unref0 (colormap);
			_g_object_unref0 (screen);
		}
		gtk_widget_set_app_paintable ((GtkWidget*) self->priv->window, TRUE);
		g_signal_connect_object ((GtkWidget*) self->priv->window, "expose-event", (GCallback) _gmpc_easy_command_popup_expose_handler_gtk_widget_expose_event, self, 0);
		gtk_entry_set_completion (entry, self->priv->completion);
		g_signal_connect_object (entry, "activate", (GCallback) _gmpc_easy_command_activate_gtk_entry_activate, self, 0);
		g_signal_connect_object ((GtkWidget*) entry, "key-press-event", (GCallback) _gmpc_easy_command_key_press_event_gtk_widget_key_press_event, self, 0);
		g_signal_connect_object ((GtkWidget*) self->priv->window, "button-press-event", (GCallback) __lambda1__gtk_widget_button_press_event, self, 0);
		gtk_widget_show_all ((GtkWidget*) self->priv->window);
		gtk_window_present (self->priv->window);
		gdk_window_raise (((GtkWidget*) self->priv->window)->window);
		gtk_widget_grab_focus ((GtkWidget*) entry);
		_g_object_unref0 (entry);
	} else {
		gtk_window_present (self->priv->window);
	}
	{
		guint32 _tmp8_;
		guint32 _time;
		gint i;
		_tmp8_ = gtk_get_current_event_time ();
		_time = _tmp8_;
		i = 10;
		while (TRUE) {
			gboolean _tmp9_ = FALSE;
			GdkGrabStatus _tmp10_;
			if (i > 0) {
				_tmp9_ = self->priv->window != NULL;
			} else {
				_tmp9_ = FALSE;
			}
			if (!_tmp9_) {
				break;
			}
			_tmp10_ = gdk_keyboard_grab (((GtkWidget*) self->priv->window)->window, TRUE, _time);
			if (_tmp10_ != GDK_GRAB_SUCCESS) {
				g_debug ("gmpc-easy-command.vala:382: Failed to grab keyboard\n");
			} else {
				break;
			}
			g_usleep ((gulong) 100000);
			i--;
		}
		while (TRUE) {
			gboolean _tmp11_ = FALSE;
			GdkGrabStatus _tmp12_;
			if (i > 0) {
				_tmp11_ = self->priv->window != NULL;
			} else {
				_tmp11_ = FALSE;
			}
			if (!_tmp11_) {
				break;
			}
			_tmp12_ = gdk_pointer_grab (((GtkWidget*) self->priv->window)->window, TRUE, (GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK) | GDK_POINTER_MOTION_MASK, NULL, NULL, _time);
			if (_tmp12_ != GDK_GRAB_SUCCESS) {
				g_debug ("gmpc-easy-command.vala:399: Failed to grab pointer\n");
			} else {
				break;
			}
			g_usleep ((gulong) 100000);
			i--;
		}
	}
}


void gmpc_easy_command_help_window_destroy (GtkDialog* window, gint response) {
	g_return_if_fail (window != NULL);
	gtk_object_destroy ((GtkObject*) window);
}


static void _gmpc_easy_command_help_window_destroy_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	gmpc_easy_command_help_window_destroy (_sender, response_id);
}


void gmpc_easy_command_help_window (void* data, const gchar* param) {
	GmpcEasyCommand* _tmp0_;
	GmpcEasyCommand* ec;
	const gchar* _tmp1_ = NULL;
	GtkDialog* _tmp2_ = NULL;
	GtkDialog* window;
	GtkTreeView* _tmp3_ = NULL;
	GtkTreeView* tree;
	GtkTreeModelSort* _tmp4_ = NULL;
	GtkTreeModelSort* _tmp5_;
	GtkScrolledWindow* _tmp6_ = NULL;
	GtkScrolledWindow* sw;
	GtkCellRendererPixbuf* _tmp7_ = NULL;
	GtkCellRendererPixbuf* prenderer;
	GtkTreeViewColumn* _tmp8_ = NULL;
	GtkTreeViewColumn* column;
	const gchar* _tmp9_ = NULL;
	GtkCellRendererText* _tmp10_ = NULL;
	GtkCellRendererText* renderer;
	GtkTreeViewColumn* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	GtkCellRendererText* _tmp13_ = NULL;
	GtkTreeViewColumn* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	GtkLabel* _tmp16_ = NULL;
	GtkLabel* label;
	const gchar* _tmp17_ = NULL;
	_tmp0_ = _g_object_ref0 ((GmpcEasyCommand*) data);
	ec = _tmp0_;
	_tmp1_ = _ ("Easy Command help");
	_tmp2_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp1_, NULL, 0, "gtk-close", GTK_RESPONSE_OK, NULL, NULL);
	window = g_object_ref_sink (_tmp2_);
	gtk_window_set_default_size ((GtkWindow*) window, 600, 400);
	_tmp3_ = (GtkTreeView*) gtk_tree_view_new ();
	tree = g_object_ref_sink (_tmp3_);
	_tmp4_ = (GtkTreeModelSort*) gtk_tree_model_sort_new_with_model ((GtkTreeModel*) ec->store);
	_tmp5_ = _tmp4_;
	gtk_tree_view_set_model (tree, (GtkTreeModel*) _tmp5_);
	_g_object_unref0 (_tmp5_);
	gtk_tree_view_set_rules_hint (tree, TRUE);
	gtk_tree_view_set_search_column (tree, 1);
	_tmp6_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	sw = g_object_ref_sink (_tmp6_);
	gtk_container_set_border_width ((GtkContainer*) sw, (guint) 8);
	gtk_scrolled_window_set_shadow_type (sw, GTK_SHADOW_ETCHED_IN);
	gtk_scrolled_window_set_policy (sw, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_add ((GtkContainer*) sw, (GtkWidget*) tree);
	_tmp7_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	prenderer = g_object_ref_sink (_tmp7_);
	_tmp8_ = gtk_tree_view_column_new ();
	column = g_object_ref_sink (_tmp8_);
	gtk_tree_view_append_column (tree, column);
	_tmp9_ = _ ("");
	gtk_tree_view_column_set_title (column, _tmp9_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) prenderer, FALSE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column, (GtkCellRenderer*) prenderer, "icon-name", 6);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column, (GtkCellRenderer*) prenderer, "stock-id", 7);
	_tmp10_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	renderer = g_object_ref_sink (_tmp10_);
	_tmp11_ = gtk_tree_view_column_new ();
	_g_object_unref0 (column);
	column = g_object_ref_sink (_tmp11_);
	gtk_tree_view_append_column (tree, column);
	_tmp12_ = _ ("Command");
	gtk_tree_view_column_set_title (column, _tmp12_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) renderer, FALSE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column, (GtkCellRenderer*) renderer, "text", 1);
	gtk_tree_view_column_set_sort_column_id (column, 1);
	_tmp13_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_g_object_unref0 (renderer);
	renderer = g_object_ref_sink (_tmp13_);
	_tmp14_ = gtk_tree_view_column_new ();
	_g_object_unref0 (column);
	column = g_object_ref_sink (_tmp14_);
	gtk_tree_view_append_column (tree, column);
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) renderer, FALSE);
	_tmp15_ = _ ("Usage");
	gtk_tree_view_column_set_title (column, _tmp15_);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column, (GtkCellRenderer*) renderer, "text", 5);
	gtk_tree_view_column_set_sort_column_id (column, 5);
	_tmp16_ = (GtkLabel*) gtk_label_new ("");
	label = g_object_ref_sink (_tmp16_);
	_tmp17_ = _ ("The following commands can be used in the easy command window.\n" \
"The easy command window can be opened by pressing ctrl-space");
	gtk_label_set_markup (label, _tmp17_);
	gtk_misc_set_alignment ((GtkMisc*) label, 0.0f, 0.5f);
	gtk_misc_set_padding ((GtkMisc*) label, 8, 6);
	gtk_box_pack_start ((GtkBox*) window->vbox, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) window->vbox, (GtkWidget*) sw, TRUE, TRUE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) window);
	g_signal_connect (window, "response", (GCallback) _gmpc_easy_command_help_window_destroy_gtk_dialog_response, NULL);
	_g_object_unref0 (label);
	_g_object_unref0 (renderer);
	_g_object_unref0 (column);
	_g_object_unref0 (prenderer);
	_g_object_unref0 (sw);
	_g_object_unref0 (tree);
	_g_object_unref0 (window);
	_g_object_unref0 (ec);
}


GmpcEasyCommand* gmpc_easy_command_construct (GType object_type) {
	GmpcEasyCommand * self = NULL;
	self = (GmpcEasyCommand*) gmpc_plugin_base_construct (object_type);
	return self;
}


GmpcEasyCommand* gmpc_easy_command_new (void) {
	return gmpc_easy_command_construct (GMPC_EASY_TYPE_COMMAND);
}


static gboolean _gmpc_easy_command_completion_function_gtk_entry_completion_match_func (GtkEntryCompletion* completion, const gchar* key, GtkTreeIter* iter, gpointer self) {
	gboolean result;
	result = gmpc_easy_command_completion_function (completion, key, iter);
	return result;
}


static GObject * gmpc_easy_command_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GmpcEasyCommand * self;
	GtkListStore* _tmp0_ = NULL;
	GtkEntryCompletion* _tmp1_ = NULL;
	GtkCellRendererPixbuf* _tmp2_ = NULL;
	GtkCellRendererPixbuf* rpixbuf;
	GtkCellRendererText* _tmp3_ = NULL;
	GtkCellRendererText* renderer;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	parent_class = G_OBJECT_CLASS (gmpc_easy_command_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GMPC_EASY_COMMAND (obj);
	((GmpcPluginBase*) self)->plugin_type = 8 + 4;
	_tmp0_ = gtk_list_store_new (8, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_POINTER, G_TYPE_POINTER, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
	_g_object_unref0 (self->store);
	self->store = _tmp0_;
	_tmp1_ = gtk_entry_completion_new ();
	_g_object_unref0 (self->priv->completion);
	self->priv->completion = _tmp1_;
	gtk_entry_completion_set_model (self->priv->completion, (GtkTreeModel*) self->store);
	gtk_entry_completion_set_text_column (self->priv->completion, 1);
	gtk_entry_completion_set_inline_completion (self->priv->completion, TRUE);
	gtk_entry_completion_set_inline_selection (self->priv->completion, TRUE);
	gtk_entry_completion_set_popup_completion (self->priv->completion, TRUE);
	gtk_entry_completion_set_match_func (self->priv->completion, _gmpc_easy_command_completion_function_gtk_entry_completion_match_func, NULL, NULL);
	_tmp2_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	rpixbuf = g_object_ref_sink (_tmp2_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->completion, (GtkCellRenderer*) rpixbuf, FALSE);
	gtk_cell_layout_reorder ((GtkCellLayout*) self->priv->completion, (GtkCellRenderer*) rpixbuf, 0);
	g_object_set ((GObject*) rpixbuf, "stock-size", GTK_ICON_SIZE_MENU, NULL, NULL);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) self->priv->completion, (GtkCellRenderer*) rpixbuf, "icon-name", 6);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) self->priv->completion, (GtkCellRenderer*) rpixbuf, "stock-id", 7);
	_tmp3_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	renderer = g_object_ref_sink (_tmp3_);
	gtk_cell_layout_pack_end ((GtkCellLayout*) self->priv->completion, (GtkCellRenderer*) renderer, FALSE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) self->priv->completion, (GtkCellRenderer*) renderer, "text", 5);
	g_object_set ((GObject*) renderer, "foreground", "grey", NULL, NULL);
	_tmp4_ = _ ("Help");
	_tmp5_ = _ ("Get a list of available commands");
	gmpc_easy_command_add_entry_stock_id (self, _tmp4_, "", _tmp5_, (GmpcEasyCommandCallback*) gmpc_easy_command_help_window, self, "gtk-info");
	_g_object_unref0 (renderer);
	_g_object_unref0 (rpixbuf);
	return obj;
}


static void gmpc_easy_command_class_init (GmpcEasyCommandClass * klass) {
	gmpc_easy_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GmpcEasyCommandPrivate));
	GMPC_PLUGIN_BASE_CLASS (klass)->get_name = gmpc_easy_command_real_get_name;
	GMPC_PLUGIN_BASE_CLASS (klass)->get_version = gmpc_easy_command_real_get_version;
	GMPC_PLUGIN_BASE_CLASS (klass)->get_enabled = gmpc_easy_command_real_get_enabled;
	GMPC_PLUGIN_BASE_CLASS (klass)->set_enabled = gmpc_easy_command_real_set_enabled;
	G_OBJECT_CLASS (klass)->constructor = gmpc_easy_command_constructor;
	G_OBJECT_CLASS (klass)->finalize = gmpc_easy_command_finalize;
}


static void gmpc_easy_command_instance_init (GmpcEasyCommand * self) {
	self->priv = GMPC_EASY_COMMAND_GET_PRIVATE (self);
	self->priv->completion = NULL;
	self->store = NULL;
	self->priv->signals = (guint) 0;
	self->priv->window = NULL;
}


static void gmpc_easy_command_finalize (GObject* obj) {
	GmpcEasyCommand * self;
	self = GMPC_EASY_COMMAND (obj);
	_g_object_unref0 (self->priv->completion);
	_g_object_unref0 (self->store);
	_g_object_unref0 (self->priv->window);
	G_OBJECT_CLASS (gmpc_easy_command_parent_class)->finalize (obj);
}


GType gmpc_easy_command_get_type (void) {
	static volatile gsize gmpc_easy_command_type_id__volatile = 0;
	if (g_once_init_enter (&gmpc_easy_command_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GmpcEasyCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gmpc_easy_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GmpcEasyCommand), 0, (GInstanceInitFunc) gmpc_easy_command_instance_init, NULL };
		GType gmpc_easy_command_type_id;
		gmpc_easy_command_type_id = g_type_register_static (GMPC_PLUGIN_TYPE_BASE, "GmpcEasyCommand", &g_define_type_info, 0);
		g_once_init_leave (&gmpc_easy_command_type_id__volatile, gmpc_easy_command_type_id);
	}
	return gmpc_easy_command_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



