/* DMPage.c generated by valac 0.38.7, the Vala compiler
 * generated from DMPage.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "CbBundle.h"
#include <stdlib.h>
#include <string.h>
#include "CbMessageReceiver.h"
#include <float.h>
#include <math.h>
#include "CbUserStream.h"
#include <json-glib/json-glib.h>
#include "rest/oauth-proxy.h"
#include "CbUserCounter.h"
#include "CbFilter.h"
#include "CbTwitterItem.h"
#include "CbTypes.h"
#include "CbTextTransform.h"
#include "CbUtils.h"
#include <gio/gio.h>
#include <cairo.h>
#include "rest/rest-proxy-call.h"
#include "rest/rest-proxy.h"
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>


#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_DM_PAGE (dm_page_get_type ())
#define DM_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_PAGE, DMPage))
#define DM_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_PAGE, DMPageClass))
#define IS_DM_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_PAGE))
#define IS_DM_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_PAGE))
#define DM_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_PAGE, DMPageClass))

typedef struct _DMPage DMPage;
typedef struct _DMPageClass DMPageClass;
typedef struct _DMPagePrivate DMPagePrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_COMPLETION_TEXT_VIEW (completion_text_view_get_type ())
#define COMPLETION_TEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_TEXT_VIEW, CompletionTextView))
#define COMPLETION_TEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_TEXT_VIEW, CompletionTextViewClass))
#define IS_COMPLETION_TEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_TEXT_VIEW))
#define IS_COMPLETION_TEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_TEXT_VIEW))
#define COMPLETION_TEXT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_TEXT_VIEW, CompletionTextViewClass))

typedef struct _CompletionTextView CompletionTextView;
typedef struct _CompletionTextViewClass CompletionTextViewClass;

#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;

#define TYPE_DM_PLACEHOLDER_BOX (dm_placeholder_box_get_type ())
#define DM_PLACEHOLDER_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_PLACEHOLDER_BOX, DMPlaceholderBox))
#define DM_PLACEHOLDER_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_PLACEHOLDER_BOX, DMPlaceholderBoxClass))
#define IS_DM_PLACEHOLDER_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_PLACEHOLDER_BOX))
#define IS_DM_PLACEHOLDER_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_PLACEHOLDER_BOX))
#define DM_PLACEHOLDER_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_PLACEHOLDER_BOX, DMPlaceholderBoxClass))

typedef struct _DMPlaceholderBox DMPlaceholderBox;
typedef struct _DMPlaceholderBoxClass DMPlaceholderBoxClass;
enum  {
	DM_PAGE_0_PROPERTY,
	DM_PAGE_UNREAD_COUNT_PROPERTY,
	DM_PAGE_WINDOW_PROPERTY,
	DM_PAGE_ID_PROPERTY,
	DM_PAGE_NUM_PROPERTIES
};
static GParamSpec* dm_page_properties[DM_PAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;

#define TYPE_DM_LIST_ENTRY (dm_list_entry_get_type ())
#define DM_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_LIST_ENTRY, DMListEntry))
#define DM_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_LIST_ENTRY, DMListEntryClass))
#define IS_DM_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_LIST_ENTRY))
#define IS_DM_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_LIST_ENTRY))
#define DM_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_LIST_ENTRY, DMListEntryClass))

typedef struct _DMListEntry DMListEntry;
typedef struct _DMListEntryClass DMListEntryClass;
typedef struct _DMListEntryPrivate DMListEntryPrivate;
typedef struct _Block8Data Block8Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _Block9Data Block9Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block10Data Block10Data;

#define SQL_TYPE_SELECT_STATEMENT (sql_select_statement_get_type ())
#define SQL_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatement))
#define SQL_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))
#define SQL_IS_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_SELECT_STATEMENT))
#define SQL_IS_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_SELECT_STATEMENT))
#define SQL_SELECT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))

typedef struct _SqlSelectStatement SqlSelectStatement;
typedef struct _SqlSelectStatementClass SqlSelectStatementClass;
typedef struct _Block11Data Block11Data;

#define TYPE_TWITTER (twitter_get_type ())
#define TWITTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWITTER, Twitter))
#define TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWITTER, TwitterClass))
#define IS_TWITTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWITTER))
#define IS_TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWITTER))
#define TWITTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWITTER, TwitterClass))

typedef struct _Twitter Twitter;
typedef struct _TwitterClass TwitterClass;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef struct _Block12Data Block12Data;
typedef struct _DMPlaceholderBoxPrivate DMPlaceholderBoxPrivate;

#define TYPE_DM_THREADS_PAGE (dm_threads_page_get_type ())
#define DM_THREADS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_THREADS_PAGE, DMThreadsPage))
#define DM_THREADS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_THREADS_PAGE, DMThreadsPageClass))
#define IS_DM_THREADS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_THREADS_PAGE))
#define IS_DM_THREADS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_THREADS_PAGE))
#define DM_THREADS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_THREADS_PAGE, DMThreadsPageClass))

typedef struct _DMThreadsPage DMThreadsPage;
typedef struct _DMThreadsPageClass DMThreadsPageClass;

#define TYPE_PAGE (page_get_type ())
typedef struct _Block13Data Block13Data;
typedef struct _Block14Data Block14Data;

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, CbBundle* args);
	void (*on_leave) (IPage* self);
	void (*create_radio_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_radio_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	void (*set_window) (IPage* self, MainWindow* value);
};

struct _DMPage {
	GtkBox parent_instance;
	DMPagePrivate * priv;
	Account* account;
	gint64 user_id;
};

struct _DMPageClass {
	GtkBoxClass parent_class;
};

struct _DMPagePrivate {
	MainWindow* main_window;
	gint _id;
	GtkButton* send_button;
	CompletionTextView* text_view;
	GtkListBox* messages_list;
	ScrollWidget* scroll_widget;
	DMPlaceholderBox* placeholder_box;
	gint64 lowest_id;
	gboolean was_scrolled_down;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _DMListEntry {
	GtkListBoxRow parent_instance;
	DMListEntryPrivate * priv;
	gint64 timestamp;
	gint64 id;
	gint64 user_id;
	MainWindow* main_window;
};

struct _DMListEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _Block8Data {
	int _ref_count_;
	DMPage* self;
	CbTextEntity* url_list;
	gint url_list_length1;
	gint _url_list_size_;
};

struct _Block9Data {
	int _ref_count_;
	DMPage* self;
	CbTextEntity* url_list;
	gint url_list_length1;
	gint _url_list_size_;
};

struct _Block10Data {
	int _ref_count_;
	DMPage* self;
	GDateTime* now;
};

typedef gboolean (*SqlSelectCallback) (gchar** vals, int vals_length1, void* user_data);
struct _Block11Data {
	int _ref_count_;
	Block10Data * _data10_;
	DMListEntry* entry;
};

struct _Block12Data {
	int _ref_count_;
	DMPage* self;
	gchar* screen_name;
	gchar* name;
	GDateTime* now;
};

struct _DMPlaceholderBox {
	GtkBox parent_instance;
	DMPlaceholderBoxPrivate * priv;
	gint64 user_id;
	gchar* avatar_url;
};

struct _DMPlaceholderBoxClass {
	GtkBoxClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

struct _Block13Data {
	int _ref_count_;
	Block12Data * _data12_;
	DMListEntry* entry;
};

struct _Block14Data {
	int _ref_count_;
	DMPage* self;
	RestProxyCall* call;
};


static gpointer dm_page_parent_class = NULL;
static IPageIface * dm_page_ipage_parent_iface = NULL;
static CbMessageReceiverInterface * dm_page_cb_message_receiver_parent_iface = NULL;

GType main_window_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType dm_page_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType completion_text_view_get_type (void) G_GNUC_CONST;
GType scroll_widget_get_type (void) G_GNUC_CONST;
GType dm_placeholder_box_get_type (void) G_GNUC_CONST;
#define DM_PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DM_PAGE, DMPagePrivate))
DMPlaceholderBox* dm_placeholder_box_new (void);
DMPlaceholderBox* dm_placeholder_box_construct (GType object_type);
#define DM_PAGE_KEY_SENDER_ID 0
#define DM_PAGE_KEY_SCREEN_NAME 1
#define DM_PAGE_KEY_USER_NAME 2
#define DM_PAGE_KEY_AVATAR_URL 3
DMPage* dm_page_new (gint id, Account* account);
DMPage* dm_page_construct (GType object_type, gint id, Account* account);
void ipage_set_id (IPage* self, gint value);
static void dm_page_recalc_length (DMPage* self);
static void _dm_page_recalc_length_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self);
gint twitter_item_sort_func_inv (GtkListBoxRow* a, GtkListBoxRow* b);
static gint _twitter_item_sort_func_inv_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self);
static void dm_page_load_older (DMPage* self);
static void _dm_page_load_older_scroll_widget_scrolled_to_start (ScrollWidget* _sender, gdouble value, gpointer self);
static void __lambda89_ (DMPage* self);
void scroll_widget_scroll_down_next (ScrollWidget* self, gboolean animate, gboolean force_wait);
static void ___lambda89__gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
static void __lambda90_ (DMPage* self);
gboolean scroll_widget_get_scrolled_down (ScrollWidget* self);
static void ___lambda90__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self);
static void dm_page_real_stream_message_received (CbMessageReceiver* base, CbStreamMessageType type, JsonNode* root);
GType sql_database_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
GType dm_list_entry_get_type (void) G_GNUC_CONST;
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void _vala_CbTextEntity_array_free (CbTextEntity * array, gint array_length);
static void block8_data_unref (void * _userdata_);
static void _______lambda91_ (Block8Data* _data8_, JsonArray* arr, guint index, JsonNode* node);
static void ________lambda91__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
void dm_list_entry_set_text (DMListEntry* self, const gchar* value);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void ____lambda92_ (Block9Data* _data9_, JsonArray* arr, guint index, JsonNode* node);
static void _____lambda92__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
DMListEntry* dm_list_entry_new (void);
DMListEntry* dm_list_entry_construct (GType object_type);
void dm_list_entry_set_name (DMListEntry* self, const gchar* value);
void dm_list_entry_set_screen_name (DMListEntry* self, const gchar* value);
void dm_list_entry_load_avatar (DMListEntry* self, const gchar* avatar_url);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
void scroll_widget_balance_next_upper_change (ScrollWidget* self, gint mode);
#define TOP 1
GType sql_select_statement_get_type (void) G_GNUC_CONST;
SqlSelectStatement* sql_database_select (SqlDatabase* self, const gchar* table_name);
SqlSelectStatement* sql_select_statement_cols (SqlSelectStatement* self, const gchar* first, ...);
SqlSelectStatement* sql_select_statement_where (SqlSelectStatement* self, const gchar* stmt);
SqlSelectStatement* sql_select_statement_order (SqlSelectStatement* self, const gchar* order_by);
SqlSelectStatement* sql_select_statement_limit (SqlSelectStatement* self, gint limit);
gint sql_select_statement_run (SqlSelectStatement* self, SqlSelectCallback callback, void* callback_target);
static gboolean __lambda86_ (Block10Data* _data10_, gchar** vals, int vals_length1);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
GType twitter_get_type (void) G_GNUC_CONST;
Twitter* twitter_get (void);
void twitter_load_avatar_for_user_id (Twitter* self, Account* account, gint64 user_id, gint size, GAsyncReadyCallback _callback_, gpointer _user_data_);
cairo_surface_t* twitter_load_avatar_for_user_id_finish (Twitter* self, GAsyncResult* _res_);
static void __lambda88_ (Block11Data* _data11_, GObject* obj, GAsyncResult* res);
void dm_list_entry_set_avatar (DMListEntry* self, cairo_surface_t* value);
static void ___lambda88__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean ___lambda86__sql_select_callback (gchar** vals, int vals_length1, gpointer self);
static void dm_page_real_on_join (IPage* base, gint page_id, CbBundle* args);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
void dm_placeholder_box_set_screen_name (DMPlaceholderBox* self, const gchar* value);
void dm_placeholder_box_set_name (DMPlaceholderBox* self, const gchar* value);
void dm_placeholder_box_load_avatar (DMPlaceholderBox* self);
void completion_text_view_set_account (CompletionTextView* self, Account* account);
static void __lambda93_ (DMPage* self, GtkWidget* w);
static void ___lambda93__gtk_callback (GtkWidget* widget, gpointer self);
GType dm_threads_page_get_type (void) G_GNUC_CONST;
IPage* main_window_get_page (MainWindow* self, gint page_id);
GType page_get_type (void) G_GNUC_CONST;
void dm_threads_page_adjust_unread_count_for_user_id (DMThreadsPage* self, gint64 user_id);
static gboolean __lambda114_ (Block12Data* _data12_, gchar** vals, int vals_length1);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
static void __lambda115_ (Block13Data* _data13_, GObject* obj, GAsyncResult* res);
static void ___lambda115__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean ___lambda114__sql_select_callback (gchar** vals, int vals_length1, gpointer self);
static void dm_page_real_on_leave (IPage* base);
static void dm_page_send_button_clicked_cb (DMPage* self);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
gchar* dm_threads_page_get_notification_id_for_user_id (DMThreadsPage* self, gint64 user_id);
cairo_surface_t* account_get_avatar (Account* self);
static void __lambda116_ (Block14Data* _data14_, GObject* obj, GAsyncResult* res);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file, GtkWindow* transient_for);
static void ___lambda116__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _dm_page_send_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean dm_page_text_view_key_press_cb (DMPage* self, GdkEventKey* evt);
static gboolean _dm_page_text_view_key_press_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static gchar* dm_page_real_get_title (IPage* base);
static void dm_page_real_create_radio_button (IPage* base, GtkRadioButton* group);
static GtkRadioButton* dm_page_real_get_radio_button (IPage* base);
gint dm_page_get_unread_count (DMPage* self);
static void dm_page_finalize (GObject * obj);
gint ipage_get_id (IPage* self);
static void _vala_dm_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void ipage_set_window (IPage* self, MainWindow* value);
static void _vala_dm_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _dm_page_recalc_length_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self) {
	dm_page_recalc_length ((DMPage*) self);
}


static gint _twitter_item_sort_func_inv_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self) {
	gint result;
	result = twitter_item_sort_func_inv (row1, row2);
	return result;
}


static void _dm_page_load_older_scroll_widget_scrolled_to_start (ScrollWidget* _sender, gdouble value, gpointer self) {
	dm_page_load_older ((DMPage*) self);
}


static void __lambda89_ (DMPage* self) {
	gboolean _tmp0_;
	_tmp0_ = self->priv->was_scrolled_down;
	if (_tmp0_) {
		ScrollWidget* _tmp1_;
		_tmp1_ = self->priv->scroll_widget;
		scroll_widget_scroll_down_next (_tmp1_, FALSE, FALSE);
	}
}


static void ___lambda89__gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
	__lambda89_ ((DMPage*) self);
}


static void __lambda90_ (DMPage* self) {
	ScrollWidget* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->scroll_widget;
	_tmp1_ = scroll_widget_get_scrolled_down (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		self->priv->was_scrolled_down = TRUE;
	} else {
		self->priv->was_scrolled_down = FALSE;
	}
}


static void ___lambda90__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self) {
	__lambda90_ ((DMPage*) self);
}


DMPage* dm_page_construct (GType object_type, gint id, Account* account) {
	DMPage * self = NULL;
	gint _tmp0_;
	Account* _tmp1_;
	CompletionTextView* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* _tmp4_;
	GtkListBox* _tmp5_;
	DMPlaceholderBox* _tmp6_;
	GtkListBox* _tmp7_;
	DMPlaceholderBox* _tmp8_;
	ScrollWidget* _tmp9_;
	CompletionTextView* _tmp10_;
	ScrollWidget* _tmp11_;
	GtkAdjustment* _tmp12_;
	GtkAdjustment* _tmp13_;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	self = (DMPage*) g_object_new (object_type, NULL);
	_tmp0_ = id;
	ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), _tmp0_);
	_tmp1_ = account;
	self->account = _tmp1_;
	_tmp2_ = self->priv->text_view;
	_tmp3_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_text_view_get_type (), GtkTextView));
	_tmp4_ = _tmp3_;
	g_signal_connect_object (_tmp4_, "changed", (GCallback) _dm_page_recalc_length_gtk_text_buffer_changed, self, 0);
	_tmp5_ = self->priv->messages_list;
	gtk_list_box_set_sort_func (_tmp5_, _twitter_item_sort_func_inv_gtk_list_box_sort_func, NULL, NULL);
	_tmp6_ = self->priv->placeholder_box;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget));
	_tmp7_ = self->priv->messages_list;
	_tmp8_ = self->priv->placeholder_box;
	gtk_list_box_set_placeholder (_tmp7_, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
	_tmp9_ = self->priv->scroll_widget;
	g_signal_connect_object (_tmp9_, "scrolled-to-start", (GCallback) _dm_page_load_older_scroll_widget_scrolled_to_start, self, 0);
	_tmp10_ = self->priv->text_view;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), "size-allocate", (GCallback) ___lambda89__gtk_widget_size_allocate, self, 0);
	_tmp11_ = self->priv->scroll_widget;
	_tmp12_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp13_ = _tmp12_;
	g_signal_connect_object (_tmp13_, "value-changed", (GCallback) ___lambda90__gtk_adjustment_value_changed, self, 0);
	return self;
}


DMPage* dm_page_new (gint id, Account* account) {
	return dm_page_construct (TYPE_DM_PAGE, id, account);
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void _vala_CbTextEntity_array_free (CbTextEntity * array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			cb_text_entity_free (&array[i]);
		}
	}
	g_free (array);
}


static void block8_data_unref (void * _userdata_) {
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		DMPage* self;
		self = _data8_->self;
		_data8_->url_list = (_vala_CbTextEntity_array_free (_data8_->url_list, _data8_->url_list_length1), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = old;
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = old;
		_tmp4_ = replacement;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (self);
		result = _tmp5_;
		return result;
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = old;
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		regex = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch8_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = regex;
		_tmp13_ = replacement;
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch8_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		result = _tmp15_;
		_g_free0 (_tmp11_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally8;
	__catch8_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void _______lambda91_ (Block8Data* _data8_, JsonArray* arr, guint index, JsonNode* node) {
	DMPage* self;
	JsonObject* url = NULL;
	JsonNode* _tmp0_;
	JsonObject* _tmp1_;
	JsonObject* _tmp2_;
	gchar* expanded_url = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	JsonArray* indices = NULL;
	JsonArray* _tmp5_;
	JsonArray* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	CbTextEntity* _tmp9_;
	gint _tmp9__length1;
	guint _tmp10_;
	gint64 _tmp11_;
	gint64 _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	CbTextEntity _tmp17_ = {0};
	CbTextEntity _tmp18_;
	self = _data8_->self;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	url = _tmp2_;
	_tmp3_ = json_object_get_string_member (url, "expanded_url");
	_tmp4_ = g_strdup (_tmp3_);
	expanded_url = _tmp4_;
	_tmp5_ = json_object_get_array_member (url, "indices");
	_tmp6_ = _json_array_ref0 (_tmp5_);
	indices = _tmp6_;
	_tmp7_ = expanded_url;
	_tmp8_ = string_replace (_tmp7_, "&", "&amp;");
	_g_free0 (expanded_url);
	expanded_url = _tmp8_;
	_tmp9_ = _data8_->url_list;
	_tmp9__length1 = _data8_->url_list_length1;
	_tmp10_ = index;
	_tmp11_ = json_array_get_int_element (indices, (guint) 0);
	_tmp12_ = json_array_get_int_element (indices, (guint) 1);
	_tmp13_ = expanded_url;
	_tmp14_ = g_strdup (_tmp13_);
	_tmp15_ = json_object_get_string_member (url, "display_url");
	_tmp16_ = g_strdup (_tmp15_);
	memset (&_tmp17_, 0, sizeof (CbTextEntity));
	_tmp17_.from = (guint) ((gint) _tmp11_);
	_tmp17_.to = (guint) ((gint) _tmp12_);
	_g_free0 (_tmp17_.target);
	_tmp17_.target = _tmp14_;
	_g_free0 (_tmp17_.display_text);
	_tmp17_.display_text = _tmp16_;
	cb_text_entity_free (&_tmp9_[_tmp10_]);
	_tmp9_[_tmp10_] = _tmp17_;
	_tmp18_ = _tmp9_[_tmp10_];
	_json_array_unref0 (indices);
	_g_free0 (expanded_url);
	_json_object_unref0 (url);
}


static void ________lambda91__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	_______lambda91_ (self, array, index_, element_node);
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void block9_data_unref (void * _userdata_) {
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		DMPage* self;
		self = _data9_->self;
		_data9_->url_list = (_vala_CbTextEntity_array_free (_data9_->url_list, _data9_->url_list_length1), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}


static void ____lambda92_ (Block9Data* _data9_, JsonArray* arr, guint index, JsonNode* node) {
	DMPage* self;
	JsonObject* url = NULL;
	JsonNode* _tmp0_;
	JsonObject* _tmp1_;
	JsonObject* _tmp2_;
	gchar* expanded_url = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	JsonArray* indices = NULL;
	JsonArray* _tmp5_;
	JsonArray* _tmp6_;
	CbTextEntity* _tmp7_;
	gint _tmp7__length1;
	guint _tmp8_;
	gint64 _tmp9_;
	gint64 _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	CbTextEntity _tmp15_ = {0};
	CbTextEntity _tmp16_;
	self = _data9_->self;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	url = _tmp2_;
	_tmp3_ = json_object_get_string_member (url, "expanded_url");
	_tmp4_ = g_strdup (_tmp3_);
	expanded_url = _tmp4_;
	_tmp5_ = json_object_get_array_member (url, "indices");
	_tmp6_ = _json_array_ref0 (_tmp5_);
	indices = _tmp6_;
	_tmp7_ = _data9_->url_list;
	_tmp7__length1 = _data9_->url_list_length1;
	_tmp8_ = index;
	_tmp9_ = json_array_get_int_element (indices, (guint) 0);
	_tmp10_ = json_array_get_int_element (indices, (guint) 1);
	_tmp11_ = string_replace (expanded_url, "&", "&amp;");
	_tmp12_ = g_strdup (expanded_url);
	_tmp13_ = json_object_get_string_member (url, "display_url");
	_tmp14_ = g_strdup (_tmp13_);
	memset (&_tmp15_, 0, sizeof (CbTextEntity));
	_tmp15_.from = (guint) _tmp9_;
	_tmp15_.to = (guint) _tmp10_;
	_g_free0 (_tmp15_.target);
	_tmp15_.target = _tmp11_;
	_g_free0 (_tmp15_.tooltip_text);
	_tmp15_.tooltip_text = _tmp12_;
	_g_free0 (_tmp15_.display_text);
	_tmp15_.display_text = _tmp14_;
	cb_text_entity_free (&_tmp7_[_tmp8_]);
	_tmp7_[_tmp8_] = _tmp15_;
	_tmp16_ = _tmp7_[_tmp8_];
	_json_array_unref0 (indices);
	_g_free0 (expanded_url);
	_json_object_unref0 (url);
}


static void _____lambda92__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	____lambda92_ (self, array, index_, element_node);
}


static void dm_page_real_stream_message_received (CbMessageReceiver* base, CbStreamMessageType type, JsonNode* root) {
	DMPage * self;
	CbStreamMessageType _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_PAGE, DMPage);
	g_return_if_fail (root != NULL);
	_tmp0_ = type;
	if (_tmp0_ == CB_STREAM_MESSAGE_DIRECT_MESSAGE) {
		JsonObject* obj = NULL;
		JsonNode* _tmp1_;
		JsonObject* _tmp2_;
		JsonObject* _tmp3_;
		JsonObject* _tmp4_;
		gboolean _tmp5_ = FALSE;
		JsonObject* _tmp6_;
		gint64 _tmp7_;
		Account* _tmp8_;
		gint64 _tmp9_;
		JsonObject* _tmp44_;
		gint64 _tmp45_;
		gint64 _tmp46_;
		gint64 _tmp47_;
		Account* _tmp48_;
		gint64 _tmp49_;
		gchar* text = NULL;
		JsonObject* _tmp50_;
		const gchar* _tmp51_;
		gchar* _tmp52_;
		JsonObject* _tmp53_;
		gboolean _tmp54_;
		JsonObject* sender = NULL;
		JsonObject* _tmp66_;
		JsonObject* _tmp67_;
		JsonObject* _tmp68_;
		DMListEntry* new_msg = NULL;
		DMListEntry* _tmp69_;
		DMListEntry* _tmp70_;
		const gchar* _tmp71_;
		DMListEntry* _tmp72_;
		JsonObject* _tmp73_;
		const gchar* _tmp74_;
		DMListEntry* _tmp75_;
		JsonObject* _tmp76_;
		const gchar* _tmp77_;
		DMListEntry* _tmp78_;
		JsonObject* _tmp79_;
		const gchar* _tmp80_;
		GDateTime* _tmp81_;
		GDateTime* _tmp82_;
		gint64 _tmp83_;
		DMListEntry* _tmp84_;
		MainWindow* _tmp85_;
		DMListEntry* _tmp86_;
		JsonObject* _tmp87_;
		gint64 _tmp88_;
		DMListEntry* _tmp89_;
		DMListEntry* _tmp90_;
		JsonObject* _tmp91_;
		const gchar* _tmp92_;
		GtkListBox* _tmp93_;
		DMListEntry* _tmp94_;
		ScrollWidget* _tmp95_;
		gboolean _tmp96_;
		gboolean _tmp97_;
		_tmp1_ = root;
		_tmp2_ = json_node_get_object (_tmp1_);
		_tmp3_ = json_object_get_object_member (_tmp2_, "direct_message");
		_tmp4_ = _json_object_ref0 (_tmp3_);
		obj = _tmp4_;
		_tmp6_ = obj;
		_tmp7_ = json_object_get_int_member (_tmp6_, "sender_id");
		_tmp8_ = self->account;
		_tmp9_ = _tmp8_->id;
		if (_tmp7_ == _tmp9_) {
			JsonObject* _tmp10_;
			gboolean _tmp11_;
			_tmp10_ = obj;
			_tmp11_ = json_object_has_member (_tmp10_, "entities");
			_tmp5_ = _tmp11_;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			GList* entries = NULL;
			GtkListBox* _tmp12_;
			GList* _tmp13_;
			gint64 dm_id = 0LL;
			JsonObject* _tmp14_;
			gint64 _tmp15_;
			GList* _tmp16_;
			_tmp12_ = self->priv->messages_list;
			_tmp13_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_container_get_type (), GtkContainer));
			entries = _tmp13_;
			_tmp14_ = obj;
			_tmp15_ = json_object_get_int_member (_tmp14_, "id");
			dm_id = _tmp15_;
			_tmp16_ = entries;
			{
				GList* entry_collection = NULL;
				GList* entry_it = NULL;
				entry_collection = _tmp16_;
				for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
					GtkWidget* entry = NULL;
					entry = (GtkWidget*) entry_it->data;
					{
						DMListEntry* e = NULL;
						GtkWidget* _tmp17_;
						DMListEntry* _tmp18_;
						gboolean _tmp19_ = FALSE;
						DMListEntry* _tmp20_;
						gint64 _tmp21_;
						Account* _tmp22_;
						gint64 _tmp23_;
						_tmp17_ = entry;
						_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_DM_LIST_ENTRY, DMListEntry));
						e = _tmp18_;
						_tmp20_ = e;
						_tmp21_ = _tmp20_->user_id;
						_tmp22_ = self->account;
						_tmp23_ = _tmp22_->id;
						if (_tmp21_ == _tmp23_) {
							DMListEntry* _tmp24_;
							gint64 _tmp25_;
							_tmp24_ = e;
							_tmp25_ = _tmp24_->id;
							_tmp19_ = _tmp25_ == ((gint64) -1);
						} else {
							_tmp19_ = FALSE;
						}
						if (_tmp19_) {
							Block8Data* _data8_;
							gchar* text = NULL;
							JsonObject* _tmp26_;
							const gchar* _tmp27_;
							gchar* _tmp28_;
							JsonArray* urls = NULL;
							JsonObject* _tmp29_;
							JsonObject* _tmp30_;
							JsonArray* _tmp31_;
							JsonArray* _tmp32_;
							JsonArray* _tmp33_;
							guint _tmp34_;
							CbTextEntity* _tmp35_;
							JsonArray* _tmp36_;
							DMListEntry* _tmp37_;
							const gchar* _tmp38_;
							CbTextEntity* _tmp39_;
							gint _tmp39__length1;
							gchar* _tmp40_;
							gchar* _tmp41_;
							DMListEntry* _tmp42_;
							gint64 _tmp43_;
							_data8_ = g_slice_new0 (Block8Data);
							_data8_->_ref_count_ = 1;
							_data8_->self = g_object_ref (self);
							_tmp26_ = obj;
							_tmp27_ = json_object_get_string_member (_tmp26_, "text");
							_tmp28_ = g_strdup (_tmp27_);
							text = _tmp28_;
							_tmp29_ = obj;
							_tmp30_ = json_object_get_object_member (_tmp29_, "entities");
							_tmp31_ = json_object_get_array_member (_tmp30_, "urls");
							_tmp32_ = _json_array_ref0 (_tmp31_);
							urls = _tmp32_;
							_tmp33_ = urls;
							_tmp34_ = json_array_get_length (_tmp33_);
							_tmp35_ = g_new0 (CbTextEntity, _tmp34_);
							_data8_->url_list = _tmp35_;
							_data8_->url_list_length1 = _tmp34_;
							_data8_->_url_list_size_ = _data8_->url_list_length1;
							_tmp36_ = urls;
							json_array_foreach_element (_tmp36_, ________lambda91__json_array_foreach, _data8_);
							_tmp37_ = e;
							_tmp38_ = text;
							_tmp39_ = _data8_->url_list;
							_tmp39__length1 = _data8_->url_list_length1;
							_tmp40_ = cb_text_transform_text (_tmp38_, _tmp39_, _tmp39__length1, (guint) 0, (gsize) 0, (gint64) 0, (guint) 0);
							_tmp41_ = _tmp40_;
							dm_list_entry_set_text (_tmp37_, _tmp41_);
							_g_free0 (_tmp41_);
							_tmp42_ = e;
							_tmp43_ = dm_id;
							_tmp42_->id = _tmp43_;
							_json_array_unref0 (urls);
							_g_free0 (text);
							block8_data_unref (_data8_);
							_data8_ = NULL;
							_g_object_unref0 (e);
							break;
						}
						_g_object_unref0 (e);
					}
				}
			}
			_g_list_free0 (entries);
		}
		_tmp44_ = obj;
		_tmp45_ = json_object_get_int_member (_tmp44_, "sender_id");
		_tmp46_ = self->user_id;
		if (_tmp45_ != _tmp46_) {
			_json_object_unref0 (obj);
			return;
		}
		_tmp47_ = self->user_id;
		_tmp48_ = self->account;
		_tmp49_ = _tmp48_->id;
		if (_tmp47_ == _tmp49_) {
			_json_object_unref0 (obj);
			return;
		}
		_tmp50_ = obj;
		_tmp51_ = json_object_get_string_member (_tmp50_, "text");
		_tmp52_ = g_strdup (_tmp51_);
		text = _tmp52_;
		_tmp53_ = obj;
		_tmp54_ = json_object_has_member (_tmp53_, "entities");
		if (_tmp54_) {
			Block9Data* _data9_;
			JsonArray* urls = NULL;
			JsonObject* _tmp55_;
			JsonObject* _tmp56_;
			JsonArray* _tmp57_;
			JsonArray* _tmp58_;
			JsonArray* _tmp59_;
			guint _tmp60_;
			CbTextEntity* _tmp61_;
			JsonArray* _tmp62_;
			const gchar* _tmp63_;
			CbTextEntity* _tmp64_;
			gint _tmp64__length1;
			gchar* _tmp65_;
			_data9_ = g_slice_new0 (Block9Data);
			_data9_->_ref_count_ = 1;
			_data9_->self = g_object_ref (self);
			_tmp55_ = obj;
			_tmp56_ = json_object_get_object_member (_tmp55_, "entities");
			_tmp57_ = json_object_get_array_member (_tmp56_, "urls");
			_tmp58_ = _json_array_ref0 (_tmp57_);
			urls = _tmp58_;
			_tmp59_ = urls;
			_tmp60_ = json_array_get_length (_tmp59_);
			_tmp61_ = g_new0 (CbTextEntity, _tmp60_);
			_data9_->url_list = _tmp61_;
			_data9_->url_list_length1 = _tmp60_;
			_data9_->_url_list_size_ = _data9_->url_list_length1;
			_tmp62_ = urls;
			json_array_foreach_element (_tmp62_, _____lambda92__json_array_foreach, _data9_);
			_tmp63_ = text;
			_tmp64_ = _data9_->url_list;
			_tmp64__length1 = _data9_->url_list_length1;
			_tmp65_ = cb_text_transform_text (_tmp63_, _tmp64_, _tmp64__length1, (guint) 0, (gsize) 0, (gint64) 0, (guint) 0);
			_g_free0 (text);
			text = _tmp65_;
			_json_array_unref0 (urls);
			block9_data_unref (_data9_);
			_data9_ = NULL;
		}
		_tmp66_ = obj;
		_tmp67_ = json_object_get_object_member (_tmp66_, "sender");
		_tmp68_ = _json_object_ref0 (_tmp67_);
		sender = _tmp68_;
		_tmp69_ = dm_list_entry_new ();
		g_object_ref_sink (_tmp69_);
		new_msg = _tmp69_;
		_tmp70_ = new_msg;
		_tmp71_ = text;
		dm_list_entry_set_text (_tmp70_, _tmp71_);
		_tmp72_ = new_msg;
		_tmp73_ = sender;
		_tmp74_ = json_object_get_string_member (_tmp73_, "name");
		dm_list_entry_set_name (_tmp72_, _tmp74_);
		_tmp75_ = new_msg;
		_tmp76_ = sender;
		_tmp77_ = json_object_get_string_member (_tmp76_, "screen_name");
		dm_list_entry_set_screen_name (_tmp75_, _tmp77_);
		_tmp78_ = new_msg;
		_tmp79_ = obj;
		_tmp80_ = json_object_get_string_member (_tmp79_, "created_at");
		_tmp81_ = cb_utils_parse_date (_tmp80_);
		_tmp82_ = _tmp81_;
		_tmp83_ = g_date_time_to_unix (_tmp82_);
		_tmp78_->timestamp = _tmp83_;
		_g_date_time_unref0 (_tmp82_);
		_tmp84_ = new_msg;
		_tmp85_ = self->priv->main_window;
		_tmp84_->main_window = _tmp85_;
		_tmp86_ = new_msg;
		_tmp87_ = sender;
		_tmp88_ = json_object_get_int_member (_tmp87_, "id");
		_tmp86_->user_id = _tmp88_;
		_tmp89_ = new_msg;
		cb_twitter_item_update_time_delta (G_TYPE_CHECK_INSTANCE_CAST (_tmp89_, CB_TYPE_TWITTER_ITEM, CbTwitterItem), NULL);
		_tmp90_ = new_msg;
		_tmp91_ = sender;
		_tmp92_ = json_object_get_string_member (_tmp91_, "profile_image_url");
		dm_list_entry_load_avatar (_tmp90_, _tmp92_);
		_tmp93_ = self->priv->messages_list;
		_tmp94_ = new_msg;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, gtk_widget_get_type (), GtkWidget));
		_tmp95_ = self->priv->scroll_widget;
		_tmp96_ = scroll_widget_get_scrolled_down (_tmp95_);
		_tmp97_ = _tmp96_;
		if (_tmp97_) {
			ScrollWidget* _tmp98_;
			_tmp98_ = self->priv->scroll_widget;
			scroll_widget_scroll_down_next (_tmp98_, TRUE, FALSE);
		}
		_g_object_unref0 (new_msg);
		_json_object_unref0 (sender);
		_g_free0 (text);
		_json_object_unref0 (obj);
	}
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}


static void block10_data_unref (void * _userdata_) {
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		DMPage* self;
		self = _data10_->self;
		_g_date_time_unref0 (_data10_->now);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}


static Block11Data* block11_data_ref (Block11Data* _data11_) {
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}


static void block11_data_unref (void * _userdata_) {
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		DMPage* self;
		self = _data11_->_data10_->self;
		_g_object_unref0 (_data11_->entry);
		block10_data_unref (_data11_->_data10_);
		_data11_->_data10_ = NULL;
		g_slice_free (Block11Data, _data11_);
	}
}


static gint64 int64_parse (const gchar* str) {
	gint64 result = 0LL;
	const gchar* _tmp0_;
	gint64 _tmp1_;
	g_return_val_if_fail (str != NULL, 0LL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoll (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static void __lambda88_ (Block11Data* _data11_, GObject* obj, GAsyncResult* res) {
	Block10Data* _data10_;
	DMPage* self;
	cairo_surface_t* s = NULL;
	Twitter* _tmp0_;
	Twitter* _tmp1_;
	GAsyncResult* _tmp2_;
	cairo_surface_t* _tmp3_;
	cairo_surface_t* _tmp4_;
	_data10_ = _data11_->_data10_;
	self = _data10_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_tmp0_ = twitter_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = res;
	_tmp3_ = twitter_load_avatar_for_user_id_finish (_tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	s = _tmp4_;
	dm_list_entry_set_avatar (_data11_->entry, s);
	_cairo_surface_destroy0 (s);
}


static void ___lambda88__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda88_ (self, source_object, res);
	block11_data_unref (self);
}


static gboolean __lambda86_ (Block10Data* _data10_, gchar** vals, int vals_length1) {
	DMPage* self;
	gboolean result = FALSE;
	Block11Data* _data11_;
	gint64 id = 0LL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	gint64 _tmp4_;
	DMListEntry* _tmp6_;
	gint64 _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	const gchar* _tmp9_;
	gint64 _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	const gchar* _tmp12_;
	gint64 _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	const gchar* _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp19_;
	MainWindow* _tmp20_;
	GDateTime* _tmp21_;
	Twitter* _tmp22_;
	Twitter* _tmp23_;
	Account* _tmp24_;
	gint64 _tmp25_;
	gint _tmp26_;
	GtkListBox* _tmp27_;
	self = _data10_->self;
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->_data10_ = block10_data_ref (_data10_);
	_tmp0_ = vals;
	_tmp0__length1 = vals_length1;
	_tmp1_ = _tmp0_[6];
	_tmp2_ = int64_parse (_tmp1_);
	id = _tmp2_;
	_tmp3_ = id;
	_tmp4_ = self->priv->lowest_id;
	if (_tmp3_ < _tmp4_) {
		gint64 _tmp5_;
		_tmp5_ = id;
		self->priv->lowest_id = _tmp5_;
	}
	_tmp6_ = dm_list_entry_new ();
	g_object_ref_sink (_tmp6_);
	_data11_->entry = _tmp6_;
	_tmp7_ = id;
	_data11_->entry->id = _tmp7_;
	_tmp8_ = vals;
	_tmp8__length1 = vals_length1;
	_tmp9_ = _tmp8_[0];
	_tmp10_ = int64_parse (_tmp9_);
	_data11_->entry->user_id = _tmp10_;
	_tmp11_ = vals;
	_tmp11__length1 = vals_length1;
	_tmp12_ = _tmp11_[5];
	_tmp13_ = int64_parse (_tmp12_);
	_data11_->entry->timestamp = _tmp13_;
	_tmp14_ = vals;
	_tmp14__length1 = vals_length1;
	_tmp15_ = _tmp14_[2];
	dm_list_entry_set_text (_data11_->entry, _tmp15_);
	_tmp16_ = vals;
	_tmp16__length1 = vals_length1;
	_tmp17_ = _tmp16_[3];
	dm_list_entry_set_name (_data11_->entry, _tmp17_);
	_tmp18_ = vals;
	_tmp18__length1 = vals_length1;
	_tmp19_ = _tmp18_[4];
	dm_list_entry_set_screen_name (_data11_->entry, _tmp19_);
	_tmp20_ = self->priv->main_window;
	_data11_->entry->main_window = _tmp20_;
	_tmp21_ = _data10_->now;
	cb_twitter_item_update_time_delta (G_TYPE_CHECK_INSTANCE_CAST (_data11_->entry, CB_TYPE_TWITTER_ITEM, CbTwitterItem), _tmp21_);
	_tmp22_ = twitter_get ();
	_tmp23_ = _tmp22_;
	_tmp24_ = self->account;
	_tmp25_ = _data11_->entry->user_id;
	_tmp26_ = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	twitter_load_avatar_for_user_id (_tmp23_, _tmp24_, _tmp25_, 48 * _tmp26_, ___lambda88__gasync_ready_callback, block11_data_ref (_data11_));
	_g_object_unref0 (_tmp23_);
	_tmp27_ = self->priv->messages_list;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_data11_->entry, gtk_widget_get_type (), GtkWidget));
	result = TRUE;
	block11_data_unref (_data11_);
	_data11_ = NULL;
	return result;
}


static gboolean ___lambda86__sql_select_callback (gchar** vals, int vals_length1, gpointer self) {
	gboolean result;
	result = __lambda86_ (self, vals, vals_length1);
	return result;
}


static void dm_page_load_older (DMPage* self) {
	Block10Data* _data10_;
	GDateTime* _tmp0_;
	ScrollWidget* _tmp1_;
	SqlSelectStatement* query = NULL;
	Account* _tmp2_;
	SqlDatabase* _tmp3_;
	SqlSelectStatement* _tmp4_;
	SqlSelectStatement* _tmp5_;
	SqlSelectStatement* _tmp6_;
	SqlSelectStatement* _tmp7_;
	gint64 _tmp8_;
	Account* _tmp9_;
	gint64 _tmp10_;
	SqlSelectStatement* _tmp39_;
	SqlSelectStatement* _tmp40_;
	SqlSelectStatement* _tmp41_;
	SqlSelectStatement* _tmp42_;
	SqlSelectStatement* _tmp43_;
	g_return_if_fail (IS_DM_PAGE (self));
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_tmp0_ = g_date_time_new_now_local ();
	_data10_->now = _tmp0_;
	_tmp1_ = self->priv->scroll_widget;
	scroll_widget_balance_next_upper_change (_tmp1_, TOP);
	_tmp2_ = self->account;
	_tmp3_ = _tmp2_->db;
	_tmp4_ = sql_database_select (_tmp3_, "dms");
	_tmp5_ = _tmp4_;
	_tmp6_ = sql_select_statement_cols (_tmp5_, "from_id", "to_id", "text", "from_name", "from_screen_name", "timestamp", "id", NULL);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	query = _tmp7_;
	_tmp8_ = self->user_id;
	_tmp9_ = self->account;
	_tmp10_ = _tmp9_->id;
	if (_tmp8_ == _tmp10_) {
		SqlSelectStatement* _tmp11_;
		gint64 _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gint64 _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gint64 _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		SqlSelectStatement* _tmp23_;
		SqlSelectStatement* _tmp24_;
		_tmp11_ = query;
		_tmp12_ = self->user_id;
		_tmp13_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = self->user_id;
		_tmp16_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = self->priv->lowest_id;
		_tmp19_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strconcat ("`from_id`='", _tmp14_, "' AND `to_id`='", _tmp17_, "' AND `id` < '", _tmp20_, "'", NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = sql_select_statement_where (_tmp11_, _tmp22_);
		_tmp24_ = _tmp23_;
		_g_object_unref0 (_tmp24_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp20_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp14_);
	} else {
		SqlSelectStatement* _tmp25_;
		gint64 _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gint64 _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gint64 _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		SqlSelectStatement* _tmp37_;
		SqlSelectStatement* _tmp38_;
		_tmp25_ = query;
		_tmp26_ = self->user_id;
		_tmp27_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = self->user_id;
		_tmp30_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = self->priv->lowest_id;
		_tmp33_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = g_strconcat ("(`from_id`='", _tmp28_, "' OR `to_id`='", _tmp31_, "') AND `id` < '", _tmp34_, "'", NULL);
		_tmp36_ = _tmp35_;
		_tmp37_ = sql_select_statement_where (_tmp25_, _tmp36_);
		_tmp38_ = _tmp37_;
		_g_object_unref0 (_tmp38_);
		_g_free0 (_tmp36_);
		_g_free0 (_tmp34_);
		_g_free0 (_tmp31_);
		_g_free0 (_tmp28_);
	}
	_tmp39_ = query;
	_tmp40_ = sql_select_statement_order (_tmp39_, "timestamp DESC");
	_tmp41_ = _tmp40_;
	_tmp42_ = sql_select_statement_limit (_tmp41_, 35);
	_tmp43_ = _tmp42_;
	sql_select_statement_run (_tmp43_, ___lambda86__sql_select_callback, _data10_);
	_g_object_unref0 (_tmp43_);
	_g_object_unref0 (_tmp41_);
	_g_object_unref0 (query);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}


static Block12Data* block12_data_ref (Block12Data* _data12_) {
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}


static void block12_data_unref (void * _userdata_) {
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		DMPage* self;
		self = _data12_->self;
		_g_date_time_unref0 (_data12_->now);
		_g_free0 (_data12_->name);
		_g_free0 (_data12_->screen_name);
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}


static void __lambda93_ (DMPage* self, GtkWidget* w) {
	GtkListBox* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = self->priv->messages_list;
	_tmp1_ = w;
	gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer), _tmp1_);
}


static void ___lambda93__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda93_ ((DMPage*) self, widget);
}


static Block13Data* block13_data_ref (Block13Data* _data13_) {
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}


static void block13_data_unref (void * _userdata_) {
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		DMPage* self;
		self = _data13_->_data12_->self;
		_g_object_unref0 (_data13_->entry);
		block12_data_unref (_data13_->_data12_);
		_data13_->_data12_ = NULL;
		g_slice_free (Block13Data, _data13_);
	}
}


static void __lambda115_ (Block13Data* _data13_, GObject* obj, GAsyncResult* res) {
	Block12Data* _data12_;
	DMPage* self;
	cairo_surface_t* s = NULL;
	Twitter* _tmp0_;
	Twitter* _tmp1_;
	GAsyncResult* _tmp2_;
	cairo_surface_t* _tmp3_;
	cairo_surface_t* _tmp4_;
	_data12_ = _data13_->_data12_;
	self = _data12_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_tmp0_ = twitter_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = res;
	_tmp3_ = twitter_load_avatar_for_user_id_finish (_tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	s = _tmp4_;
	dm_list_entry_set_avatar (_data13_->entry, s);
	_cairo_surface_destroy0 (s);
}


static void ___lambda115__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda115_ (self, source_object, res);
	block13_data_unref (self);
}


static gboolean __lambda114_ (Block12Data* _data12_, gchar** vals, int vals_length1) {
	DMPage* self;
	gboolean result = FALSE;
	Block13Data* _data13_;
	gint64 id = 0LL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	gint64 _tmp4_;
	DMListEntry* _tmp6_;
	gint64 _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	const gchar* _tmp9_;
	gint64 _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	const gchar* _tmp12_;
	gint64 _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	const gchar* _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	const gchar* _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	MainWindow* _tmp26_;
	GDateTime* _tmp27_;
	Twitter* _tmp28_;
	Twitter* _tmp29_;
	Account* _tmp30_;
	gint64 _tmp31_;
	gint _tmp32_;
	GtkListBox* _tmp33_;
	self = _data12_->self;
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->_data12_ = block12_data_ref (_data12_);
	_tmp0_ = vals;
	_tmp0__length1 = vals_length1;
	_tmp1_ = _tmp0_[6];
	_tmp2_ = int64_parse (_tmp1_);
	id = _tmp2_;
	_tmp3_ = id;
	_tmp4_ = self->priv->lowest_id;
	if (_tmp3_ < _tmp4_) {
		gint64 _tmp5_;
		_tmp5_ = id;
		self->priv->lowest_id = _tmp5_;
	}
	_tmp6_ = dm_list_entry_new ();
	g_object_ref_sink (_tmp6_);
	_data13_->entry = _tmp6_;
	_tmp7_ = id;
	_data13_->entry->id = _tmp7_;
	_tmp8_ = vals;
	_tmp8__length1 = vals_length1;
	_tmp9_ = _tmp8_[0];
	_tmp10_ = int64_parse (_tmp9_);
	_data13_->entry->user_id = _tmp10_;
	_tmp11_ = vals;
	_tmp11__length1 = vals_length1;
	_tmp12_ = _tmp11_[5];
	_tmp13_ = int64_parse (_tmp12_);
	_data13_->entry->timestamp = _tmp13_;
	_tmp14_ = vals;
	_tmp14__length1 = vals_length1;
	_tmp15_ = _tmp14_[2];
	dm_list_entry_set_text (_data13_->entry, _tmp15_);
	_tmp16_ = vals;
	_tmp16__length1 = vals_length1;
	_tmp17_ = _tmp16_[3];
	dm_list_entry_set_name (_data13_->entry, _tmp17_);
	_tmp18_ = vals;
	_tmp18__length1 = vals_length1;
	_tmp19_ = _tmp18_[3];
	_tmp20_ = g_strdup (_tmp19_);
	_g_free0 (_data12_->name);
	_data12_->name = _tmp20_;
	_tmp21_ = vals;
	_tmp21__length1 = vals_length1;
	_tmp22_ = _tmp21_[4];
	dm_list_entry_set_screen_name (_data13_->entry, _tmp22_);
	_tmp23_ = vals;
	_tmp23__length1 = vals_length1;
	_tmp24_ = _tmp23_[4];
	_tmp25_ = g_strdup (_tmp24_);
	_g_free0 (_data12_->screen_name);
	_data12_->screen_name = _tmp25_;
	_tmp26_ = self->priv->main_window;
	_data13_->entry->main_window = _tmp26_;
	_tmp27_ = _data12_->now;
	cb_twitter_item_update_time_delta (G_TYPE_CHECK_INSTANCE_CAST (_data13_->entry, CB_TYPE_TWITTER_ITEM, CbTwitterItem), _tmp27_);
	_tmp28_ = twitter_get ();
	_tmp29_ = _tmp28_;
	_tmp30_ = self->account;
	_tmp31_ = _data13_->entry->user_id;
	_tmp32_ = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	twitter_load_avatar_for_user_id (_tmp29_, _tmp30_, _tmp31_, 48 * _tmp32_, ___lambda115__gasync_ready_callback, block13_data_ref (_data13_));
	_g_object_unref0 (_tmp29_);
	_tmp33_ = self->priv->messages_list;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_data13_->entry, gtk_widget_get_type (), GtkWidget));
	result = TRUE;
	block13_data_unref (_data13_);
	_data13_ = NULL;
	return result;
}


static gboolean ___lambda114__sql_select_callback (gchar** vals, int vals_length1, gpointer self) {
	gboolean result;
	result = __lambda114_ (self, vals, vals_length1);
	return result;
}


static void dm_page_real_on_join (IPage* base, gint page_id, CbBundle* args) {
	DMPage * self;
	Block12Data* _data12_;
	gint64 user_id = 0LL;
	CbBundle* _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	CbBundle* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	CompletionTextView* _tmp22_;
	Account* _tmp23_;
	GtkListBox* _tmp24_;
	DMThreadsPage* threads_page = NULL;
	MainWindow* _tmp25_;
	IPage* _tmp26_;
	DMThreadsPage* _tmp27_;
	gint64 _tmp28_;
	GDateTime* _tmp29_;
	SqlSelectStatement* query = NULL;
	Account* _tmp30_;
	SqlDatabase* _tmp31_;
	SqlSelectStatement* _tmp32_;
	SqlSelectStatement* _tmp33_;
	SqlSelectStatement* _tmp34_;
	SqlSelectStatement* _tmp35_;
	gint64 _tmp36_;
	Account* _tmp37_;
	gint64 _tmp38_;
	SqlSelectStatement* _tmp61_;
	SqlSelectStatement* _tmp62_;
	SqlSelectStatement* _tmp63_;
	SqlSelectStatement* _tmp64_;
	SqlSelectStatement* _tmp65_;
	Account* _tmp66_;
	CbUserCounter* _tmp67_;
	gint64 _tmp68_;
	const gchar* _tmp69_;
	const gchar* _tmp70_;
	ScrollWidget* _tmp71_;
	CompletionTextView* _tmp72_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_PAGE, DMPage);
	g_return_if_fail ((args == NULL) || CB_IS_BUNDLE (args));
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
	_tmp0_ = args;
	_tmp1_ = cb_bundle_get_int64 (_tmp0_, DM_PAGE_KEY_SENDER_ID);
	user_id = _tmp1_;
	_tmp2_ = user_id;
	if (_tmp2_ == ((gint64) 0)) {
		block12_data_unref (_data12_);
		_data12_ = NULL;
		return;
	}
	self->priv->lowest_id = G_MAXINT64;
	_tmp3_ = user_id;
	self->user_id = _tmp3_;
	_data12_->name = NULL;
	_tmp4_ = args;
	_tmp5_ = cb_bundle_get_string (_tmp4_, DM_PAGE_KEY_SCREEN_NAME);
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (_data12_->screen_name);
	_data12_->screen_name = _tmp6_;
	_tmp7_ = _data12_->screen_name;
	if (_tmp7_ != NULL) {
		CbBundle* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		DMPlaceholderBox* _tmp11_;
		gint64 _tmp12_;
		DMPlaceholderBox* _tmp13_;
		const gchar* _tmp14_;
		DMPlaceholderBox* _tmp15_;
		const gchar* _tmp16_;
		DMPlaceholderBox* _tmp17_;
		CbBundle* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		DMPlaceholderBox* _tmp21_;
		_tmp8_ = args;
		_tmp9_ = cb_bundle_get_string (_tmp8_, DM_PAGE_KEY_USER_NAME);
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (_data12_->name);
		_data12_->name = _tmp10_;
		_tmp11_ = self->priv->placeholder_box;
		_tmp12_ = user_id;
		_tmp11_->user_id = _tmp12_;
		_tmp13_ = self->priv->placeholder_box;
		_tmp14_ = _data12_->screen_name;
		dm_placeholder_box_set_screen_name (_tmp13_, _tmp14_);
		_tmp15_ = self->priv->placeholder_box;
		_tmp16_ = _data12_->name;
		dm_placeholder_box_set_name (_tmp15_, _tmp16_);
		_tmp17_ = self->priv->placeholder_box;
		_tmp18_ = args;
		_tmp19_ = cb_bundle_get_string (_tmp18_, DM_PAGE_KEY_AVATAR_URL);
		_tmp20_ = g_strdup (_tmp19_);
		_g_free0 (_tmp17_->avatar_url);
		_tmp17_->avatar_url = _tmp20_;
		_tmp21_ = self->priv->placeholder_box;
		dm_placeholder_box_load_avatar (_tmp21_);
	}
	_tmp22_ = self->priv->text_view;
	_tmp23_ = self->account;
	completion_text_view_set_account (_tmp22_, _tmp23_);
	_tmp24_ = self->priv->messages_list;
	gtk_container_foreach (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_container_get_type (), GtkContainer), ___lambda93__gtk_callback, self);
	_tmp25_ = self->priv->main_window;
	_tmp26_ = main_window_get_page (_tmp25_, (gint) PAGE_DM_THREADS);
	threads_page = G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	_tmp27_ = threads_page;
	_tmp28_ = user_id;
	dm_threads_page_adjust_unread_count_for_user_id (_tmp27_, _tmp28_);
	_tmp29_ = g_date_time_new_now_local ();
	_data12_->now = _tmp29_;
	_tmp30_ = self->account;
	_tmp31_ = _tmp30_->db;
	_tmp32_ = sql_database_select (_tmp31_, "dms");
	_tmp33_ = _tmp32_;
	_tmp34_ = sql_select_statement_cols (_tmp33_, "from_id", "to_id", "text", "from_name", "from_screen_name", "timestamp", "id", NULL);
	_tmp35_ = _tmp34_;
	_g_object_unref0 (_tmp33_);
	query = _tmp35_;
	_tmp36_ = user_id;
	_tmp37_ = self->account;
	_tmp38_ = _tmp37_->id;
	if (_tmp36_ == _tmp38_) {
		SqlSelectStatement* _tmp39_;
		gint64 _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gint64 _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		SqlSelectStatement* _tmp48_;
		SqlSelectStatement* _tmp49_;
		_tmp39_ = query;
		_tmp40_ = user_id;
		_tmp41_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = user_id;
		_tmp44_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = g_strconcat ("`from_id`='", _tmp42_, "' AND `to_id`='", _tmp45_, "'", NULL);
		_tmp47_ = _tmp46_;
		_tmp48_ = sql_select_statement_where (_tmp39_, _tmp47_);
		_tmp49_ = _tmp48_;
		_g_object_unref0 (_tmp49_);
		_g_free0 (_tmp47_);
		_g_free0 (_tmp45_);
		_g_free0 (_tmp42_);
	} else {
		SqlSelectStatement* _tmp50_;
		gint64 _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		gint64 _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		SqlSelectStatement* _tmp59_;
		SqlSelectStatement* _tmp60_;
		_tmp50_ = query;
		_tmp51_ = user_id;
		_tmp52_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp51_);
		_tmp53_ = _tmp52_;
		_tmp54_ = user_id;
		_tmp55_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = g_strconcat ("`from_id`='", _tmp53_, "' OR `to_id`='", _tmp56_, "'", NULL);
		_tmp58_ = _tmp57_;
		_tmp59_ = sql_select_statement_where (_tmp50_, _tmp58_);
		_tmp60_ = _tmp59_;
		_g_object_unref0 (_tmp60_);
		_g_free0 (_tmp58_);
		_g_free0 (_tmp56_);
		_g_free0 (_tmp53_);
	}
	_tmp61_ = query;
	_tmp62_ = sql_select_statement_order (_tmp61_, "timestamp DESC");
	_tmp63_ = _tmp62_;
	_tmp64_ = sql_select_statement_limit (_tmp63_, 35);
	_tmp65_ = _tmp64_;
	sql_select_statement_run (_tmp65_, ___lambda114__sql_select_callback, _data12_);
	_g_object_unref0 (_tmp65_);
	_g_object_unref0 (_tmp63_);
	_tmp66_ = self->account;
	_tmp67_ = _tmp66_->user_counter;
	_tmp68_ = user_id;
	_tmp69_ = _data12_->screen_name;
	_tmp70_ = _data12_->name;
	cb_user_counter_user_seen (_tmp67_, _tmp68_, _tmp69_, _tmp70_);
	_tmp71_ = self->priv->scroll_widget;
	scroll_widget_scroll_down_next (_tmp71_, FALSE, TRUE);
	_tmp72_ = self->priv->text_view;
	gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (query);
	_g_object_unref0 (threads_page);
	block12_data_unref (_data12_);
	_data12_ = NULL;
}


static void dm_page_real_on_leave (IPage* base) {
	DMPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_PAGE, DMPage);
}


static Block14Data* block14_data_ref (Block14Data* _data14_) {
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}


static void block14_data_unref (void * _userdata_) {
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		DMPage* self;
		self = _data14_->self;
		_g_object_unref0 (_data14_->call);
		_g_object_unref0 (self);
		g_slice_free (Block14Data, _data14_);
	}
}


static void __lambda116_ (Block14Data* _data14_, GObject* obj, GAsyncResult* res) {
	DMPage* self;
	GError * _inner_error_ = NULL;
	self = _data14_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_;
		GAsyncResult* _tmp1_;
		_tmp0_ = _data14_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch9_g_error;
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		RestProxyCall* _tmp2_;
		const gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		MainWindow* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _data14_->call;
		_tmp3_ = rest_proxy_call_get_payload (_tmp2_);
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		_tmp6_ = self->priv->main_window;
		utils_show_error_object (_tmp3_, _tmp5_, 313, "DMPage.vala", G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_window_get_type (), GtkWindow));
		_g_error_free0 (e);
		return;
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda116__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda116_ (self, source_object, res);
	block14_data_unref (self);
}


static void dm_page_send_button_clicked_cb (DMPage* self) {
	Block14Data* _data14_;
	CompletionTextView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gboolean _tmp8_;
	DMThreadsPage* threads_page = NULL;
	MainWindow* _tmp9_;
	IPage* _tmp10_;
	gchar* notification_id = NULL;
	DMThreadsPage* _tmp11_;
	gint64 _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	DMListEntry* entry = NULL;
	DMListEntry* _tmp17_;
	DMListEntry* _tmp18_;
	DMListEntry* _tmp19_;
	Account* _tmp20_;
	gint64 _tmp21_;
	DMListEntry* _tmp22_;
	Account* _tmp23_;
	const gchar* _tmp24_;
	DMListEntry* _tmp25_;
	GDateTime* _tmp26_;
	GDateTime* _tmp27_;
	gint64 _tmp28_;
	DMListEntry* _tmp29_;
	CompletionTextView* _tmp30_;
	GtkTextBuffer* _tmp31_;
	GtkTextBuffer* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	DMListEntry* _tmp38_;
	MainWindow* _tmp39_;
	DMListEntry* _tmp40_;
	Account* _tmp41_;
	const gchar* _tmp42_;
	DMListEntry* _tmp43_;
	Account* _tmp44_;
	cairo_surface_t* _tmp45_;
	cairo_surface_t* _tmp46_;
	DMListEntry* _tmp47_;
	GtkListBox* _tmp48_;
	DMListEntry* _tmp49_;
	Account* _tmp50_;
	OAuthProxy* _tmp51_;
	RestProxyCall* _tmp52_;
	RestProxyCall* _tmp53_;
	RestProxyCall* _tmp54_;
	RestProxyCall* _tmp55_;
	gint64 _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	RestProxyCall* _tmp59_;
	CompletionTextView* _tmp60_;
	GtkTextBuffer* _tmp61_;
	GtkTextBuffer* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	RestProxyCall* _tmp66_;
	CompletionTextView* _tmp67_;
	GtkTextBuffer* _tmp68_;
	GtkTextBuffer* _tmp69_;
	ScrollWidget* _tmp70_;
	gboolean _tmp71_;
	gboolean _tmp72_;
	g_return_if_fail (IS_DM_PAGE (self));
	_data14_ = g_slice_new0 (Block14Data);
	_data14_->_ref_count_ = 1;
	_data14_->self = g_object_ref (self);
	_tmp0_ = self->priv->text_view;
	_tmp1_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_text_view_get_type (), GtkTextView));
	_tmp2_ = _tmp1_;
	g_object_get (_tmp2_, "text", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_ == 0;
	_g_free0 (_tmp5_);
	if (_tmp8_) {
		block14_data_unref (_data14_);
		_data14_ = NULL;
		return;
	}
	_tmp9_ = self->priv->main_window;
	_tmp10_ = main_window_get_page (_tmp9_, (gint) PAGE_DM_THREADS);
	threads_page = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	_tmp11_ = threads_page;
	_tmp12_ = self->user_id;
	_tmp13_ = dm_threads_page_get_notification_id_for_user_id (_tmp11_, _tmp12_);
	notification_id = _tmp13_;
	_tmp14_ = notification_id;
	if (_tmp14_ != NULL) {
		GApplication* _tmp15_;
		const gchar* _tmp16_;
		_tmp15_ = g_application_get_default ();
		_tmp16_ = notification_id;
		g_application_withdraw_notification (_tmp15_, _tmp16_);
	}
	_tmp17_ = dm_list_entry_new ();
	g_object_ref_sink (_tmp17_);
	entry = _tmp17_;
	_tmp18_ = entry;
	_tmp18_->id = (gint64) -1;
	_tmp19_ = entry;
	_tmp20_ = self->account;
	_tmp21_ = _tmp20_->id;
	_tmp19_->user_id = _tmp21_;
	_tmp22_ = entry;
	_tmp23_ = self->account;
	_tmp24_ = _tmp23_->screen_name;
	dm_list_entry_set_screen_name (_tmp22_, _tmp24_);
	_tmp25_ = entry;
	_tmp26_ = g_date_time_new_now_local ();
	_tmp27_ = _tmp26_;
	_tmp28_ = g_date_time_to_unix (_tmp27_);
	_tmp25_->timestamp = _tmp28_;
	_g_date_time_unref0 (_tmp27_);
	_tmp29_ = entry;
	_tmp30_ = self->priv->text_view;
	_tmp31_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_text_view_get_type (), GtkTextView));
	_tmp32_ = _tmp31_;
	g_object_get (_tmp32_, "text", &_tmp33_, NULL);
	_tmp34_ = _tmp33_;
	_tmp35_ = _tmp34_;
	_tmp36_ = g_markup_escape_text (_tmp35_, (gssize) -1);
	_tmp37_ = _tmp36_;
	dm_list_entry_set_text (_tmp29_, _tmp37_);
	_g_free0 (_tmp37_);
	_g_free0 (_tmp35_);
	_tmp38_ = entry;
	_tmp39_ = self->priv->main_window;
	_tmp38_->main_window = _tmp39_;
	_tmp40_ = entry;
	_tmp41_ = self->account;
	_tmp42_ = _tmp41_->name;
	dm_list_entry_set_name (_tmp40_, _tmp42_);
	_tmp43_ = entry;
	_tmp44_ = self->account;
	_tmp45_ = account_get_avatar (_tmp44_);
	_tmp46_ = _tmp45_;
	dm_list_entry_set_avatar (_tmp43_, _tmp46_);
	_tmp47_ = entry;
	cb_twitter_item_update_time_delta (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, CB_TYPE_TWITTER_ITEM, CbTwitterItem), NULL);
	_tmp48_ = self->priv->messages_list;
	_tmp49_ = entry;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, gtk_widget_get_type (), GtkWidget));
	_tmp50_ = self->account;
	_tmp51_ = _tmp50_->proxy;
	_tmp52_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, rest_proxy_get_type (), RestProxy));
	_data14_->call = _tmp52_;
	_tmp53_ = _data14_->call;
	rest_proxy_call_set_function (_tmp53_, "1.1/direct_messages/new.json");
	_tmp54_ = _data14_->call;
	rest_proxy_call_set_method (_tmp54_, "POST");
	_tmp55_ = _data14_->call;
	_tmp56_ = self->user_id;
	_tmp57_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp56_);
	_tmp58_ = _tmp57_;
	rest_proxy_call_add_param (_tmp55_, "user_id", _tmp58_);
	_g_free0 (_tmp58_);
	_tmp59_ = _data14_->call;
	_tmp60_ = self->priv->text_view;
	_tmp61_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, gtk_text_view_get_type (), GtkTextView));
	_tmp62_ = _tmp61_;
	g_object_get (_tmp62_, "text", &_tmp63_, NULL);
	_tmp64_ = _tmp63_;
	_tmp65_ = _tmp64_;
	rest_proxy_call_add_param (_tmp59_, "text", _tmp65_);
	_g_free0 (_tmp65_);
	_tmp66_ = _data14_->call;
	rest_proxy_call_invoke_async (_tmp66_, NULL, ___lambda116__gasync_ready_callback, block14_data_ref (_data14_));
	_tmp67_ = self->priv->text_view;
	_tmp68_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, gtk_text_view_get_type (), GtkTextView));
	_tmp69_ = _tmp68_;
	g_object_set (_tmp69_, "text", "", NULL);
	_tmp70_ = self->priv->scroll_widget;
	_tmp71_ = scroll_widget_get_scrolled_down (_tmp70_);
	_tmp72_ = _tmp71_;
	if (_tmp72_) {
		ScrollWidget* _tmp73_;
		_tmp73_ = self->priv->scroll_widget;
		scroll_widget_scroll_down_next (_tmp73_, TRUE, FALSE);
	}
	_g_object_unref0 (entry);
	_g_free0 (notification_id);
	_g_object_unref0 (threads_page);
	block14_data_unref (_data14_);
	_data14_ = NULL;
}


static void _dm_page_send_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	dm_page_send_button_clicked_cb ((DMPage*) self);
}


static gboolean dm_page_text_view_key_press_cb (DMPage* self, GdkEventKey* evt) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventKey* _tmp1_;
	guint _tmp2_;
	g_return_val_if_fail (IS_DM_PAGE (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp1_ = evt;
	_tmp2_ = _tmp1_->keyval;
	if (_tmp2_ == ((guint) GDK_KEY_Return)) {
		GdkEventKey* _tmp3_;
		GdkModifierType _tmp4_;
		_tmp3_ = evt;
		_tmp4_ = _tmp3_->state;
		_tmp0_ = (_tmp4_ & GDK_CONTROL_MASK) == GDK_CONTROL_MASK;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		dm_page_send_button_clicked_cb (self);
		result = GDK_EVENT_STOP;
		return result;
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}


static gboolean _dm_page_text_view_key_press_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = dm_page_text_view_key_press_cb ((DMPage*) self, event);
	return result;
}


static void dm_page_recalc_length (DMPage* self) {
	guint text_length = 0U;
	CompletionTextView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	guint _tmp8_;
	GtkButton* _tmp9_;
	g_return_if_fail (IS_DM_PAGE (self));
	_tmp0_ = self->priv->text_view;
	_tmp1_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_text_view_get_type (), GtkTextView));
	_tmp2_ = _tmp1_;
	g_object_get (_tmp2_, "text", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = (guint) _tmp7_;
	_g_free0 (_tmp5_);
	text_length = _tmp8_;
	_tmp9_ = self->priv->send_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), text_length > ((guint) 0));
}


static gchar* dm_page_real_get_title (IPage* base) {
	DMPage * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_PAGE, DMPage);
	_tmp0_ = g_strdup (_ ("Direct Conversation"));
	result = _tmp0_;
	return result;
}


static void dm_page_real_create_radio_button (IPage* base, GtkRadioButton* group) {
	DMPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_PAGE, DMPage);
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
}


static GtkRadioButton* dm_page_real_get_radio_button (IPage* base) {
	DMPage * self;
	GtkRadioButton* result = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_PAGE, DMPage);
	result = NULL;
	return result;
}


gint dm_page_get_unread_count (DMPage* self) {
	gint result;
	g_return_val_if_fail (IS_DM_PAGE (self), 0);
	result = 0;
	return result;
}


static void dm_page_real_set_window (IPage* base, MainWindow* value) {
	DMPage* self;
	MainWindow* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_PAGE, DMPage);
	_tmp0_ = value;
	self->priv->main_window = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, dm_page_properties[DM_PAGE_WINDOW_PROPERTY]);
}


static gint dm_page_real_get_id (IPage* base) {
	gint result;
	DMPage* self;
	gint _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_PAGE, DMPage);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void dm_page_real_set_id (IPage* base, gint value) {
	DMPage* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_PAGE, DMPage);
	if (dm_page_real_get_id (base) != value) {
		gint _tmp0_;
		_tmp0_ = value;
		self->priv->_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, dm_page_properties[DM_PAGE_ID_PROPERTY]);
	}
}


static void dm_page_class_init (DMPageClass * klass) {
	gint DMPage_private_offset;
	dm_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DMPagePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dm_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dm_page_set_property;
	G_OBJECT_CLASS (klass)->finalize = dm_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_PAGE_UNREAD_COUNT_PROPERTY, dm_page_properties[DM_PAGE_UNREAD_COUNT_PROPERTY] = g_param_spec_int ("unread-count", "unread-count", "unread-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_PAGE_WINDOW_PROPERTY, dm_page_properties[DM_PAGE_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", TYPE_MAIN_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_PAGE_ID_PROPERTY, dm_page_properties[DM_PAGE_ID_PROPERTY] = g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	DMPage_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/dm-page.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "send_button", FALSE, DMPage_private_offset + G_STRUCT_OFFSET (DMPagePrivate, send_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "text_view", FALSE, DMPage_private_offset + G_STRUCT_OFFSET (DMPagePrivate, text_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "messages_list", FALSE, DMPage_private_offset + G_STRUCT_OFFSET (DMPagePrivate, messages_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "scroll_widget", FALSE, DMPage_private_offset + G_STRUCT_OFFSET (DMPagePrivate, scroll_widget));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "send_button_clicked_cb", G_CALLBACK(_dm_page_send_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "text_view_key_press_cb", G_CALLBACK(_dm_page_text_view_key_press_cb_gtk_widget_key_press_event));
}


static void dm_page_ipage_interface_init (IPageIface * iface) {
	dm_page_ipage_parent_iface = g_type_interface_peek_parent (iface);
	iface->on_join = (void (*) (IPage *, gint, CbBundle*)) dm_page_real_on_join;
	iface->on_leave = (void (*) (IPage *)) dm_page_real_on_leave;
	iface->get_title = (gchar* (*) (IPage *)) dm_page_real_get_title;
	iface->create_radio_button = (void (*) (IPage *, GtkRadioButton*)) dm_page_real_create_radio_button;
	iface->get_radio_button = (GtkRadioButton* (*) (IPage *)) dm_page_real_get_radio_button;
	iface->set_window = dm_page_real_set_window;
	iface->get_id = dm_page_real_get_id;
	iface->set_id = dm_page_real_set_id;
}


static void dm_page_cb_message_receiver_interface_init (CbMessageReceiverInterface * iface) {
	dm_page_cb_message_receiver_parent_iface = g_type_interface_peek_parent (iface);
	iface->stream_message_received = (void (*) (CbMessageReceiver *, CbStreamMessageType, JsonNode*)) dm_page_real_stream_message_received;
}


static void dm_page_instance_init (DMPage * self) {
	DMPlaceholderBox* _tmp0_;
	self->priv = DM_PAGE_GET_PRIVATE (self);
	_tmp0_ = dm_placeholder_box_new ();
	g_object_ref_sink (_tmp0_);
	self->priv->placeholder_box = _tmp0_;
	self->priv->lowest_id = G_MAXINT64;
	self->priv->was_scrolled_down = FALSE;
	g_type_ensure (TYPE_COMPLETION_TEXT_VIEW);
	g_type_ensure (TYPE_SCROLL_WIDGET);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void dm_page_finalize (GObject * obj) {
	DMPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DM_PAGE, DMPage);
	_g_object_unref0 (self->priv->send_button);
	_g_object_unref0 (self->priv->text_view);
	_g_object_unref0 (self->priv->messages_list);
	_g_object_unref0 (self->priv->scroll_widget);
	_g_object_unref0 (self->priv->placeholder_box);
	G_OBJECT_CLASS (dm_page_parent_class)->finalize (obj);
}


GType dm_page_get_type (void) {
	static volatile gsize dm_page_type_id__volatile = 0;
	if (g_once_init_enter (&dm_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DMPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dm_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DMPage), 0, (GInstanceInitFunc) dm_page_instance_init, NULL };
		static const GInterfaceInfo ipage_info = { (GInterfaceInitFunc) dm_page_ipage_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo cb_message_receiver_info = { (GInterfaceInitFunc) dm_page_cb_message_receiver_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dm_page_type_id;
		dm_page_type_id = g_type_register_static (gtk_box_get_type (), "DMPage", &g_define_type_info, 0);
		g_type_add_interface_static (dm_page_type_id, TYPE_IPAGE, &ipage_info);
		g_type_add_interface_static (dm_page_type_id, CB_TYPE_MESSAGE_RECEIVER, &cb_message_receiver_info);
		g_once_init_leave (&dm_page_type_id__volatile, dm_page_type_id);
	}
	return dm_page_type_id__volatile;
}


static void _vala_dm_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DMPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DM_PAGE, DMPage);
	switch (property_id) {
		case DM_PAGE_UNREAD_COUNT_PROPERTY:
		g_value_set_int (value, dm_page_get_unread_count (self));
		break;
		case DM_PAGE_ID_PROPERTY:
		g_value_set_int (value, ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dm_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DMPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DM_PAGE, DMPage);
	switch (property_id) {
		case DM_PAGE_WINDOW_PROPERTY:
		ipage_set_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		case DM_PAGE_ID_PROPERTY:
		ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



