/* DMThreadsModel.c generated by valac 0.34.6, the Vala compiler
 * generated from DMThreadsModel.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "CbTypes.h"
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <gio/gio.h>


#define TYPE_DM_THREAD (dm_thread_get_type ())
#define DM_THREAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_THREAD, DMThread))
#define DM_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_THREAD, DMThreadClass))
#define IS_DM_THREAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_THREAD))
#define IS_DM_THREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_THREAD))
#define DM_THREAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_THREAD, DMThreadClass))

typedef struct _DMThread DMThread;
typedef struct _DMThreadClass DMThreadClass;
typedef struct _DMThreadPrivate DMThreadPrivate;

#define TYPE_TWITTER (twitter_get_type ())
#define TWITTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWITTER, Twitter))
#define TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWITTER, TwitterClass))
#define IS_TWITTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWITTER))
#define IS_TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWITTER))
#define TWITTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWITTER, TwitterClass))

typedef struct _Twitter Twitter;
typedef struct _TwitterClass TwitterClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;
typedef struct _DmThreadLoadAvatarData DmThreadLoadAvatarData;

#define TYPE_DM_THREADS_MODEL (dm_threads_model_get_type ())
#define DM_THREADS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_THREADS_MODEL, DMThreadsModel))
#define DM_THREADS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_THREADS_MODEL, DMThreadsModelClass))
#define IS_DM_THREADS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_THREADS_MODEL))
#define IS_DM_THREADS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_THREADS_MODEL))
#define DM_THREADS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_THREADS_MODEL, DMThreadsModelClass))

typedef struct _DMThreadsModel DMThreadsModel;
typedef struct _DMThreadsModelClass DMThreadsModelClass;
typedef struct _DMThreadsModelPrivate DMThreadsModelPrivate;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _DMThread {
	GObject parent_instance;
	DMThreadPrivate * priv;
	CbUserIdentity user;
	gint64 last_message_id;
	gchar* last_message;
	gint unread_count;
	gchar* notification_id;
	cairo_surface_t* avatar_surface;
};

struct _DMThreadClass {
	GObjectClass parent_class;
};

struct _DmThreadLoadAvatarData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DMThread* self;
	Account* account;
	gint scale_factor;
	CbUserIdentity _tmp0_;
	gint64 _tmp1_;
	cairo_surface_t* _tmp2_;
	Twitter* _tmp3_;
	Twitter* _tmp4_;
	Account* _tmp5_;
	CbUserIdentity _tmp6_;
	gint64 _tmp7_;
	gint _tmp8_;
	cairo_surface_t* _tmp9_;
	Twitter* _tmp10_;
	Twitter* _tmp11_;
	cairo_surface_t* _tmp12_;
};

struct _DMThreadsModel {
	GObject parent_instance;
	DMThreadsModelPrivate * priv;
};

struct _DMThreadsModelClass {
	GObjectClass parent_class;
};

struct _DMThreadsModelPrivate {
	GPtrArray* threads;
};


static gpointer dm_thread_parent_class = NULL;
static gpointer dm_threads_model_parent_class = NULL;
static GListModelInterface* dm_threads_model_g_list_model_parent_iface = NULL;

GType dm_thread_get_type (void) G_GNUC_CONST;
enum  {
	DM_THREAD_DUMMY_PROPERTY
};
GType twitter_get_type (void) G_GNUC_CONST;
Twitter* twitter_get (void);
void twitter_unref_avatar (Twitter* self, cairo_surface_t* surface);
static void dm_thread_load_avatar_data_free (gpointer _data);
GType account_get_type (void) G_GNUC_CONST;
void dm_thread_load_avatar (DMThread* self, Account* account, gint scale_factor, GAsyncReadyCallback _callback_, gpointer _user_data_);
void dm_thread_load_avatar_finish (DMThread* self, GAsyncResult* _res_);
static gboolean dm_thread_load_avatar_co (DmThreadLoadAvatarData* _data_);
void twitter_load_avatar_for_user_id (Twitter* self, Account* account, gint64 user_id, gint size, GAsyncReadyCallback _callback_, gpointer _user_data_);
cairo_surface_t* twitter_load_avatar_for_user_id_finish (Twitter* self, GAsyncResult* _res_);
static void dm_thread_load_avatar_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void twitter_ref_avatar (Twitter* self, cairo_surface_t* surface);
DMThread* dm_thread_new (void);
DMThread* dm_thread_construct (GType object_type);
static void dm_thread_finalize (GObject* obj);
GType dm_threads_model_get_type (void) G_GNUC_CONST;
#define DM_THREADS_MODEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DM_THREADS_MODEL, DMThreadsModelPrivate))
enum  {
	DM_THREADS_MODEL_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static GObject* dm_threads_model_real_get_item (GListModel* base, guint index);
static guint dm_threads_model_real_get_n_items (GListModel* base);
static GType dm_threads_model_real_get_item_type (GListModel* base);
void dm_threads_model_add (DMThreadsModel* self, DMThread* thread);
void dm_threads_model_update_last_message (DMThreadsModel* self, gint64 sender_id, gint64 message_id, const gchar* message_text);
gboolean dm_threads_model_has_thread (DMThreadsModel* self, gint64 user_id);
gint dm_threads_model_reset_unread_count (DMThreadsModel* self, gint64 user_id);
gchar* dm_threads_model_reset_notification_id (DMThreadsModel* self, gint64 user_id);
void dm_threads_model_increase_unread_count (DMThreadsModel* self, gint64 user_id, gint amount);
DMThread* dm_threads_model_get_thread (DMThreadsModel* self, gint64 user_id);
DMThreadsModel* dm_threads_model_new (void);
DMThreadsModel* dm_threads_model_construct (GType object_type);
static void dm_threads_model_finalize (GObject* obj);


static void dm_thread_load_avatar_data_free (gpointer _data) {
	DmThreadLoadAvatarData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	_g_object_unref0 (_data_->self);
	g_slice_free (DmThreadLoadAvatarData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void dm_thread_load_avatar (DMThread* self, Account* account, gint scale_factor, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DmThreadLoadAvatarData* _data_;
	DMThread* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	_data_ = g_slice_new0 (DmThreadLoadAvatarData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, dm_thread_load_avatar);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, dm_thread_load_avatar_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = account;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp2_;
	_tmp3_ = scale_factor;
	_data_->scale_factor = _tmp3_;
	dm_thread_load_avatar_co (_data_);
}


void dm_thread_load_avatar_finish (DMThread* self, GAsyncResult* _res_) {
	DmThreadLoadAvatarData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void dm_thread_load_avatar_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DmThreadLoadAvatarData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	dm_thread_load_avatar_co (_data_);
}


static gboolean dm_thread_load_avatar_co (DmThreadLoadAvatarData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	memset (&_data_->_tmp0_, 0, sizeof (CbUserIdentity));
	_data_->_tmp0_ = _data_->self->user;
	_data_->_tmp1_ = 0LL;
	_data_->_tmp1_ = _data_->_tmp0_.id;
	_vala_assert (_data_->_tmp1_ != ((gint64) 0), "this.user.id != 0");
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->self->avatar_surface;
	if (_data_->_tmp2_ != NULL) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = twitter_get ();
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->account;
	memset (&_data_->_tmp6_, 0, sizeof (CbUserIdentity));
	_data_->_tmp6_ = _data_->self->user;
	_data_->_tmp7_ = 0LL;
	_data_->_tmp7_ = _data_->_tmp6_.id;
	_data_->_tmp8_ = 0;
	_data_->_tmp8_ = _data_->scale_factor;
	_data_->_state_ = 1;
	twitter_load_avatar_for_user_id (_data_->_tmp4_, _data_->_tmp5_, _data_->_tmp7_, 48 * _data_->_tmp8_, dm_thread_load_avatar_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = twitter_load_avatar_for_user_id_finish (_data_->_tmp4_, _data_->_res_);
	_cairo_surface_destroy0 (_data_->self->avatar_surface);
	_data_->self->avatar_surface = _data_->_tmp9_;
	_g_object_unref0 (_data_->_tmp4_);
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = twitter_get ();
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->_tmp10_;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->self->avatar_surface;
	twitter_ref_avatar (_data_->_tmp11_, _data_->_tmp12_);
	_g_object_unref0 (_data_->_tmp11_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


DMThread* dm_thread_construct (GType object_type) {
	DMThread * self = NULL;
	self = (DMThread*) g_object_new (object_type, NULL);
	return self;
}


DMThread* dm_thread_new (void) {
	return dm_thread_construct (TYPE_DM_THREAD);
}


static void dm_thread_class_init (DMThreadClass * klass) {
	dm_thread_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = dm_thread_finalize;
}


static void dm_thread_instance_init (DMThread * self) {
	self->unread_count = 0;
	self->notification_id = NULL;
	self->avatar_surface = NULL;
}


static void dm_thread_finalize (GObject* obj) {
	DMThread * self;
	cairo_surface_t* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DM_THREAD, DMThread);
	_tmp0_ = self->avatar_surface;
	if (_tmp0_ != NULL) {
		Twitter* _tmp1_ = NULL;
		Twitter* _tmp2_ = NULL;
		cairo_surface_t* _tmp3_ = NULL;
		_tmp1_ = twitter_get ();
		_tmp2_ = _tmp1_;
		_tmp3_ = self->avatar_surface;
		twitter_unref_avatar (_tmp2_, _tmp3_);
		_g_object_unref0 (_tmp2_);
	}
	cb_user_identity_free (&self->user);
	_g_free0 (self->last_message);
	_g_free0 (self->notification_id);
	_cairo_surface_destroy0 (self->avatar_surface);
	G_OBJECT_CLASS (dm_thread_parent_class)->finalize (obj);
}


GType dm_thread_get_type (void) {
	static volatile gsize dm_thread_type_id__volatile = 0;
	if (g_once_init_enter (&dm_thread_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DMThreadClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dm_thread_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DMThread), 0, (GInstanceInitFunc) dm_thread_instance_init, NULL };
		GType dm_thread_type_id;
		dm_thread_type_id = g_type_register_static (G_TYPE_OBJECT, "DMThread", &g_define_type_info, 0);
		g_once_init_leave (&dm_thread_type_id__volatile, dm_thread_type_id);
	}
	return dm_thread_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static GObject* dm_threads_model_real_get_item (GListModel* base, guint index) {
	DMThreadsModel * self;
	GObject* result = NULL;
	GPtrArray* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gconstpointer _tmp2_ = NULL;
	GObject* _tmp3_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_MODEL, DMThreadsModel);
	_tmp0_ = self->priv->threads;
	_tmp1_ = index;
	_tmp2_ = g_ptr_array_index (_tmp0_, (guint) ((gint) _tmp1_));
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((DMThread*) _tmp2_, G_TYPE_OBJECT, GObject));
	result = _tmp3_;
	return result;
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static guint dm_threads_model_real_get_n_items (GListModel* base) {
	DMThreadsModel * self;
	guint result = 0U;
	GPtrArray* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_MODEL, DMThreadsModel);
	_tmp0_ = self->priv->threads;
	_tmp1_ = g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (guint) _tmp2_;
	return result;
}


static GType dm_threads_model_real_get_item_type (GListModel* base) {
	DMThreadsModel * self;
	GType result = 0UL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_THREADS_MODEL, DMThreadsModel);
	result = TYPE_DM_THREAD;
	return result;
}


void dm_threads_model_add (DMThreadsModel* self, DMThread* thread) {
	gboolean added = FALSE;
	gboolean _tmp17_ = FALSE;
	g_return_if_fail (IS_DM_THREADS_MODEL (self));
	g_return_if_fail (IS_DM_THREAD (thread));
	added = FALSE;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				GPtrArray* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				DMThread* _tmp6_ = NULL;
				gint64 _tmp7_ = 0LL;
				GPtrArray* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				gconstpointer _tmp10_ = NULL;
				gint64 _tmp11_ = 0LL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->threads;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = thread;
				_tmp7_ = _tmp6_->last_message_id;
				_tmp8_ = self->priv->threads;
				_tmp9_ = i;
				_tmp10_ = g_ptr_array_index (_tmp8_, (guint) _tmp9_);
				_tmp11_ = ((DMThread*) _tmp10_)->last_message_id;
				if (_tmp7_ > _tmp11_) {
					GPtrArray* _tmp12_ = NULL;
					gint _tmp13_ = 0;
					DMThread* _tmp14_ = NULL;
					DMThread* _tmp15_ = NULL;
					gint _tmp16_ = 0;
					_tmp12_ = self->priv->threads;
					_tmp13_ = i;
					_tmp14_ = thread;
					_tmp15_ = _g_object_ref0 (_tmp14_);
					g_ptr_array_insert (_tmp12_, _tmp13_, _tmp15_);
					_tmp16_ = i;
					g_list_model_items_changed (G_TYPE_CHECK_INSTANCE_CAST (self, g_list_model_get_type (), GListModel), (guint) _tmp16_, (guint) 0, (guint) 1);
					added = TRUE;
					break;
				}
			}
		}
	}
	_tmp17_ = added;
	if (!_tmp17_) {
		GPtrArray* _tmp18_ = NULL;
		DMThread* _tmp19_ = NULL;
		DMThread* _tmp20_ = NULL;
		GPtrArray* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		_tmp18_ = self->priv->threads;
		_tmp19_ = thread;
		_tmp20_ = _g_object_ref0 (_tmp19_);
		g_ptr_array_add (_tmp18_, _tmp20_);
		_tmp21_ = self->priv->threads;
		_tmp22_ = g_ptr_array_get_length (_tmp21_);
		_tmp23_ = _tmp22_;
		g_list_model_items_changed (G_TYPE_CHECK_INSTANCE_CAST (self, g_list_model_get_type (), GListModel), (guint) (_tmp23_ - 1), (guint) 0, (guint) 1);
	}
}


void dm_threads_model_update_last_message (DMThreadsModel* self, gint64 sender_id, gint64 message_id, const gchar* message_text) {
	gint index = 0;
	g_return_if_fail (IS_DM_THREADS_MODEL (self));
	g_return_if_fail (message_text != NULL);
	index = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				GPtrArray* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				DMThread* thread = NULL;
				GPtrArray* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gconstpointer _tmp8_ = NULL;
				DMThread* _tmp9_ = NULL;
				DMThread* _tmp10_ = NULL;
				CbUserIdentity _tmp11_ = {0};
				gint64 _tmp12_ = 0LL;
				gint64 _tmp13_ = 0LL;
				gint _tmp33_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->threads;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->threads;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				_tmp9_ = _g_object_ref0 ((DMThread*) _tmp8_);
				thread = _tmp9_;
				_tmp10_ = thread;
				_tmp11_ = _tmp10_->user;
				_tmp12_ = _tmp11_.id;
				_tmp13_ = sender_id;
				if (_tmp12_ == _tmp13_) {
					gint64 _tmp14_ = 0LL;
					DMThread* _tmp15_ = NULL;
					gint64 _tmp16_ = 0LL;
					_tmp14_ = message_id;
					_tmp15_ = thread;
					_tmp16_ = _tmp15_->last_message_id;
					if (_tmp14_ > _tmp16_) {
						DMThread* _tmp17_ = NULL;
						gint64 _tmp18_ = 0LL;
						DMThread* _tmp19_ = NULL;
						const gchar* _tmp20_ = NULL;
						gchar* _tmp21_ = NULL;
						GPtrArray* _tmp22_ = NULL;
						DMThread* _tmp23_ = NULL;
						gint _tmp24_ = 0;
						DMThread* _tmp25_ = NULL;
						_tmp17_ = thread;
						_tmp18_ = message_id;
						_tmp17_->last_message_id = _tmp18_;
						_tmp19_ = thread;
						_tmp20_ = message_text;
						_tmp21_ = g_strdup (_tmp20_);
						_g_free0 (_tmp19_->last_message);
						_tmp19_->last_message = _tmp21_;
						_tmp22_ = self->priv->threads;
						_tmp23_ = thread;
						g_ptr_array_remove (_tmp22_, _tmp23_);
						_tmp24_ = index;
						g_list_model_items_changed (G_TYPE_CHECK_INSTANCE_CAST (self, g_list_model_get_type (), GListModel), (guint) _tmp24_, (guint) 1, (guint) 0);
						_tmp25_ = thread;
						dm_threads_model_add (self, _tmp25_);
					} else {
						gint64 _tmp26_ = 0LL;
						gchar* _tmp27_ = NULL;
						gchar* _tmp28_ = NULL;
						DMThread* _tmp29_ = NULL;
						gint64 _tmp30_ = 0LL;
						gchar* _tmp31_ = NULL;
						gchar* _tmp32_ = NULL;
						_tmp26_ = message_id;
						_tmp27_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp26_);
						_tmp28_ = _tmp27_;
						_tmp29_ = thread;
						_tmp30_ = _tmp29_->last_message_id;
						_tmp31_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp30_);
						_tmp32_ = _tmp31_;
						g_warning ("DMThreadsModel.vala:95: id %s is < than %s", _tmp28_, _tmp32_);
						_g_free0 (_tmp32_);
						_g_free0 (_tmp28_);
					}
					_g_object_unref0 (thread);
					break;
				}
				_tmp33_ = index;
				index = _tmp33_ + 1;
				_g_object_unref0 (thread);
			}
		}
	}
}


gboolean dm_threads_model_has_thread (DMThreadsModel* self, gint64 user_id) {
	gboolean result = FALSE;
	g_return_val_if_fail (IS_DM_THREADS_MODEL (self), FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				GPtrArray* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				DMThread* thread = NULL;
				GPtrArray* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gconstpointer _tmp8_ = NULL;
				DMThread* _tmp9_ = NULL;
				DMThread* _tmp10_ = NULL;
				CbUserIdentity _tmp11_ = {0};
				gint64 _tmp12_ = 0LL;
				gint64 _tmp13_ = 0LL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->threads;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->threads;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				_tmp9_ = _g_object_ref0 ((DMThread*) _tmp8_);
				thread = _tmp9_;
				_tmp10_ = thread;
				_tmp11_ = _tmp10_->user;
				_tmp12_ = _tmp11_.id;
				_tmp13_ = user_id;
				if (_tmp12_ == _tmp13_) {
					result = TRUE;
					_g_object_unref0 (thread);
					return result;
				}
				_g_object_unref0 (thread);
			}
		}
	}
	result = FALSE;
	return result;
}


gint dm_threads_model_reset_unread_count (DMThreadsModel* self, gint64 user_id) {
	gint result = 0;
	g_return_val_if_fail (IS_DM_THREADS_MODEL (self), 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				GPtrArray* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				DMThread* thread = NULL;
				GPtrArray* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gconstpointer _tmp8_ = NULL;
				DMThread* _tmp9_ = NULL;
				DMThread* _tmp10_ = NULL;
				CbUserIdentity _tmp11_ = {0};
				gint64 _tmp12_ = 0LL;
				gint64 _tmp13_ = 0LL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->threads;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->threads;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				_tmp9_ = _g_object_ref0 ((DMThread*) _tmp8_);
				thread = _tmp9_;
				_tmp10_ = thread;
				_tmp11_ = _tmp10_->user;
				_tmp12_ = _tmp11_.id;
				_tmp13_ = user_id;
				if (_tmp12_ == _tmp13_) {
					gint k = 0;
					DMThread* _tmp14_ = NULL;
					gint _tmp15_ = 0;
					DMThread* _tmp16_ = NULL;
					_tmp14_ = thread;
					_tmp15_ = _tmp14_->unread_count;
					k = _tmp15_;
					_tmp16_ = thread;
					_tmp16_->unread_count = 0;
					result = k;
					_g_object_unref0 (thread);
					return result;
				}
				_g_object_unref0 (thread);
			}
		}
	}
	result = 0;
	return result;
}


gchar* dm_threads_model_reset_notification_id (DMThreadsModel* self, gint64 user_id) {
	gchar* result = NULL;
	g_return_val_if_fail (IS_DM_THREADS_MODEL (self), NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				GPtrArray* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				DMThread* thread = NULL;
				GPtrArray* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gconstpointer _tmp8_ = NULL;
				DMThread* _tmp9_ = NULL;
				DMThread* _tmp10_ = NULL;
				CbUserIdentity _tmp11_ = {0};
				gint64 _tmp12_ = 0LL;
				gint64 _tmp13_ = 0LL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->threads;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->threads;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				_tmp9_ = _g_object_ref0 ((DMThread*) _tmp8_);
				thread = _tmp9_;
				_tmp10_ = thread;
				_tmp11_ = _tmp10_->user;
				_tmp12_ = _tmp11_.id;
				_tmp13_ = user_id;
				if (_tmp12_ == _tmp13_) {
					gchar* k = NULL;
					DMThread* _tmp14_ = NULL;
					const gchar* _tmp15_ = NULL;
					gchar* _tmp16_ = NULL;
					DMThread* _tmp17_ = NULL;
					_tmp14_ = thread;
					_tmp15_ = _tmp14_->notification_id;
					_tmp16_ = g_strdup (_tmp15_);
					k = _tmp16_;
					_tmp17_ = thread;
					_g_free0 (_tmp17_->notification_id);
					_tmp17_->notification_id = NULL;
					result = k;
					_g_object_unref0 (thread);
					return result;
				}
				_g_object_unref0 (thread);
			}
		}
	}
	result = NULL;
	return result;
}


void dm_threads_model_increase_unread_count (DMThreadsModel* self, gint64 user_id, gint amount) {
	g_return_if_fail (IS_DM_THREADS_MODEL (self));
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				GPtrArray* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				DMThread* thread = NULL;
				GPtrArray* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gconstpointer _tmp8_ = NULL;
				DMThread* _tmp9_ = NULL;
				DMThread* _tmp10_ = NULL;
				CbUserIdentity _tmp11_ = {0};
				gint64 _tmp12_ = 0LL;
				gint64 _tmp13_ = 0LL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->threads;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->threads;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				_tmp9_ = _g_object_ref0 ((DMThread*) _tmp8_);
				thread = _tmp9_;
				_tmp10_ = thread;
				_tmp11_ = _tmp10_->user;
				_tmp12_ = _tmp11_.id;
				_tmp13_ = user_id;
				if (_tmp12_ == _tmp13_) {
					DMThread* _tmp14_ = NULL;
					DMThread* _tmp15_ = NULL;
					gint _tmp16_ = 0;
					gint _tmp17_ = 0;
					_tmp14_ = thread;
					_tmp15_ = thread;
					_tmp16_ = _tmp15_->unread_count;
					_tmp17_ = amount;
					_tmp15_->unread_count = _tmp16_ + _tmp17_;
					_g_object_unref0 (thread);
					break;
				}
				_g_object_unref0 (thread);
			}
		}
	}
}


DMThread* dm_threads_model_get_thread (DMThreadsModel* self, gint64 user_id) {
	DMThread* result = NULL;
	g_return_val_if_fail (IS_DM_THREADS_MODEL (self), NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				GPtrArray* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				DMThread* thread = NULL;
				GPtrArray* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gconstpointer _tmp8_ = NULL;
				DMThread* _tmp9_ = NULL;
				DMThread* _tmp10_ = NULL;
				CbUserIdentity _tmp11_ = {0};
				gint64 _tmp12_ = 0LL;
				gint64 _tmp13_ = 0LL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->threads;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->threads;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				_tmp9_ = _g_object_ref0 ((DMThread*) _tmp8_);
				thread = _tmp9_;
				_tmp10_ = thread;
				_tmp11_ = _tmp10_->user;
				_tmp12_ = _tmp11_.id;
				_tmp13_ = user_id;
				if (_tmp12_ == _tmp13_) {
					result = thread;
					return result;
				}
				_g_object_unref0 (thread);
			}
		}
	}
	result = NULL;
	return result;
}


DMThreadsModel* dm_threads_model_construct (GType object_type) {
	DMThreadsModel * self = NULL;
	self = (DMThreadsModel*) g_object_new (object_type, NULL);
	return self;
}


DMThreadsModel* dm_threads_model_new (void) {
	return dm_threads_model_construct (TYPE_DM_THREADS_MODEL);
}


static void dm_threads_model_class_init (DMThreadsModelClass * klass) {
	dm_threads_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DMThreadsModelPrivate));
	G_OBJECT_CLASS (klass)->finalize = dm_threads_model_finalize;
}


static void dm_threads_model_g_list_model_interface_init (GListModelInterface * iface) {
	dm_threads_model_g_list_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_item = (GObject* (*)(GListModel*, guint)) dm_threads_model_real_get_item;
	iface->get_n_items = (guint (*)(GListModel*)) dm_threads_model_real_get_n_items;
	iface->get_item_type = (GType (*)(GListModel*)) dm_threads_model_real_get_item_type;
}


static void dm_threads_model_instance_init (DMThreadsModel * self) {
	GPtrArray* _tmp0_ = NULL;
	self->priv = DM_THREADS_MODEL_GET_PRIVATE (self);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	self->priv->threads = _tmp0_;
}


static void dm_threads_model_finalize (GObject* obj) {
	DMThreadsModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DM_THREADS_MODEL, DMThreadsModel);
	_g_ptr_array_unref0 (self->priv->threads);
	G_OBJECT_CLASS (dm_threads_model_parent_class)->finalize (obj);
}


GType dm_threads_model_get_type (void) {
	static volatile gsize dm_threads_model_type_id__volatile = 0;
	if (g_once_init_enter (&dm_threads_model_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DMThreadsModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dm_threads_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DMThreadsModel), 0, (GInstanceInitFunc) dm_threads_model_instance_init, NULL };
		static const GInterfaceInfo g_list_model_info = { (GInterfaceInitFunc) dm_threads_model_g_list_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dm_threads_model_type_id;
		dm_threads_model_type_id = g_type_register_static (G_TYPE_OBJECT, "DMThreadsModel", &g_define_type_info, 0);
		g_type_add_interface_static (dm_threads_model_type_id, g_list_model_get_type (), &g_list_model_info);
		g_once_init_leave (&dm_threads_model_type_id__volatile, dm_threads_model_type_id);
	}
	return dm_threads_model_type_id__volatile;
}



