'''OpenGL extension EXT.post_depth_coverage

This module customises the behaviour of the 
OpenGL.raw.GL.EXT.post_depth_coverage to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension allows the fragment shader to control whether values in
	gl_SampleMaskIn[] reflect the coverage after application of the early
	depth and stencil tests.  This feature can be enabled with the following
	layout qualifier in the fragment shader:
	
	    layout(post_depth_coverage) in;
	
	To use this feature, early fragment tests must also be enabled in the
	fragment shader via:
	
	    layout(early_fragment_tests) in;

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/post_depth_coverage.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.EXT.post_depth_coverage import *
from OpenGL.raw.GL.EXT.post_depth_coverage import _EXTENSION_NAME

def glInitPostDepthCoverageEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION