/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSText.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSText.h"
#include "KURL.h"
#include "Text.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSTextTableValues[] =
{
    { "wholeText", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextWholeText), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTextTable = { 5, 3, JSTextTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSTextConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTextConstructorTable = { 1, 0, JSTextConstructorTableValues, 0 };
const ClassInfo JSTextConstructor::s_info = { "TextConstructor", &Base::s_info, &JSTextConstructorTable, 0, CREATE_METHOD_TABLE(JSTextConstructor) };

JSTextConstructor::JSTextConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSTextConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSTextPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSTextConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSTextConstructor, JSDOMWrapper>(exec, &JSTextConstructorTable, jsCast<JSTextConstructor*>(cell), propertyName, slot);
}

bool JSTextConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSTextConstructor, JSDOMWrapper>(exec, &JSTextConstructorTable, jsCast<JSTextConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSTextPrototypeTableValues[] =
{
    { "splitText", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsTextPrototypeFunctionSplitText), (intptr_t)0, NoIntrinsic },
    { "replaceWholeText", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsTextPrototypeFunctionReplaceWholeText), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTextPrototypeTable = { 4, 3, JSTextPrototypeTableValues, 0 };
const ClassInfo JSTextPrototype::s_info = { "TextPrototype", &Base::s_info, &JSTextPrototypeTable, 0, CREATE_METHOD_TABLE(JSTextPrototype) };

JSObject* JSTextPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSText>(exec, globalObject);
}

bool JSTextPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSTextPrototype* thisObject = jsCast<JSTextPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSTextPrototypeTable, thisObject, propertyName, slot);
}

bool JSTextPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSTextPrototype* thisObject = jsCast<JSTextPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSTextPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSText::s_info = { "Text", &Base::s_info, &JSTextTable, 0 , CREATE_METHOD_TABLE(JSText) };

JSText::JSText(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Text> impl)
    : JSCharacterData(structure, globalObject, impl)
{
}

void JSText::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSText::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSTextPrototype::create(exec->vm(), globalObject, JSTextPrototype::createStructure(exec->vm(), globalObject, JSCharacterDataPrototype::self(exec, globalObject)));
}

bool JSText::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSText* thisObject = jsCast<JSText*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSText, Base>(exec, &JSTextTable, thisObject, propertyName, slot);
}

bool JSText::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSText* thisObject = jsCast<JSText*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSText, Base>(exec, &JSTextTable, thisObject, propertyName, descriptor);
}

JSValue jsTextWholeText(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSText* castedThis = jsCast<JSText*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Text* impl = static_cast<Text*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->wholeText());
    return result;
}


JSValue jsTextConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSText* domObject = jsCast<JSText*>(asObject(slotBase));
    return JSText::getConstructor(exec, domObject->globalObject());
}

JSValue JSText::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTextConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsTextPrototypeFunctionSplitText(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSText::s_info))
        return throwVMTypeError(exec);
    JSText* castedThis = jsCast<JSText*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSText::s_info);
    Text* impl = static_cast<Text*>(castedThis->impl());
    ExceptionCode ec = 0;
    int offset(toUInt32(exec, exec->argument(0), NormalConversion));
    if (offset < 0) {
        setDOMException(exec, INDEX_SIZE_ERR);
        return JSValue::encode(jsUndefined());
    }
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->splitText(offset, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsTextPrototypeFunctionReplaceWholeText(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSText::s_info))
        return throwVMTypeError(exec);
    JSText* castedThis = jsCast<JSText*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSText::s_info);
    Text* impl = static_cast<Text*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& content(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->replaceWholeText(content, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}


}
