/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(LEGACY_NOTIFICATIONS)

#include "JSNotificationCenter.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSNotification.h"
#include "Notification.h"
#include "NotificationCenter.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table for prototype */

static const HashTableValue JSNotificationCenterPrototypeTableValues[] =
{
    { "createHTMLNotification", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsNotificationCenterPrototypeFunctionCreateHTMLNotification), (intptr_t)1, NoIntrinsic },
    { "createNotification", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsNotificationCenterPrototypeFunctionCreateNotification), (intptr_t)3, NoIntrinsic },
    { "checkPermission", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsNotificationCenterPrototypeFunctionCheckPermission), (intptr_t)0, NoIntrinsic },
    { "requestPermission", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsNotificationCenterPrototypeFunctionRequestPermission), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSNotificationCenterPrototypeTable = { 8, 7, JSNotificationCenterPrototypeTableValues, 0 };
const ClassInfo JSNotificationCenterPrototype::s_info = { "NotificationCenterPrototype", &Base::s_info, &JSNotificationCenterPrototypeTable, 0, CREATE_METHOD_TABLE(JSNotificationCenterPrototype) };

JSObject* JSNotificationCenterPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSNotificationCenter>(exec, globalObject);
}

bool JSNotificationCenterPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSNotificationCenterPrototype* thisObject = jsCast<JSNotificationCenterPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSNotificationCenterPrototypeTable, thisObject, propertyName, slot);
}

bool JSNotificationCenterPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSNotificationCenterPrototype* thisObject = jsCast<JSNotificationCenterPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSNotificationCenterPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSNotificationCenter::s_info = { "NotificationCenter", &Base::s_info, 0, 0 , CREATE_METHOD_TABLE(JSNotificationCenter) };

JSNotificationCenter::JSNotificationCenter(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<NotificationCenter> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSNotificationCenter::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSNotificationCenter::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSNotificationCenterPrototype::create(exec->globalData(), globalObject, JSNotificationCenterPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSNotificationCenter::destroy(JSC::JSCell* cell)
{
    JSNotificationCenter* thisObject = static_cast<JSNotificationCenter*>(cell);
    thisObject->JSNotificationCenter::~JSNotificationCenter();
}

JSNotificationCenter::~JSNotificationCenter()
{
    releaseImplIfNotNull();
}

EncodedJSValue JSC_HOST_CALL jsNotificationCenterPrototypeFunctionCreateHTMLNotification(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNotificationCenter::s_info))
        return throwVMTypeError(exec);
    JSNotificationCenter* castedThis = jsCast<JSNotificationCenter*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSNotificationCenter::s_info);
    NotificationCenter* impl = static_cast<NotificationCenter*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& url(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createHTMLNotification(url, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsNotificationCenterPrototypeFunctionCreateNotification(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNotificationCenter::s_info))
        return throwVMTypeError(exec);
    JSNotificationCenter* castedThis = jsCast<JSNotificationCenter*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSNotificationCenter::s_info);
    NotificationCenter* impl = static_cast<NotificationCenter*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& iconUrl(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& title(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& body(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createNotification(iconUrl, title, body, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsNotificationCenterPrototypeFunctionCheckPermission(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNotificationCenter::s_info))
        return throwVMTypeError(exec);
    JSNotificationCenter* castedThis = jsCast<JSNotificationCenter*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSNotificationCenter::s_info);
    NotificationCenter* impl = static_cast<NotificationCenter*>(castedThis->impl());

    JSC::JSValue result = jsNumber(impl->checkPermission());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsNotificationCenterPrototypeFunctionRequestPermission(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNotificationCenter::s_info))
        return throwVMTypeError(exec);
    JSNotificationCenter* castedThis = jsCast<JSNotificationCenter*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSNotificationCenter::s_info);
    return JSValue::encode(castedThis->requestPermission(exec));
}

static inline bool isObservable(JSNotificationCenter* jsNotificationCenter)
{
    if (jsNotificationCenter->hasCustomProperties())
        return true;
    return false;
}

bool JSNotificationCenterOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSNotificationCenter* jsNotificationCenter = jsCast<JSNotificationCenter*>(handle.get().asCell());
    if (jsNotificationCenter->impl()->hasPendingActivity())
        return true;
    if (!isObservable(jsNotificationCenter))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSNotificationCenterOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSNotificationCenter* jsNotificationCenter = jsCast<JSNotificationCenter*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsNotificationCenter->impl(), jsNotificationCenter);
    jsNotificationCenter->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, NotificationCenter* impl)
{
    return wrap<JSNotificationCenter>(exec, globalObject, impl);
}

NotificationCenter* toNotificationCenter(JSC::JSValue value)
{
    return value.inherits(&JSNotificationCenter::s_info) ? jsCast<JSNotificationCenter*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(LEGACY_NOTIFICATIONS)
