/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLOutputElement.h"

#include "ExceptionCode.h"
#include "HTMLFormElement.h"
#include "HTMLNames.h"
#include "HTMLOutputElement.h"
#include "JSDOMBinding.h"
#include "JSHTMLFormElement.h"
#include "JSNodeList.h"
#include "JSValidityState.h"
#include "KURL.h"
#include "NameNodeList.h"
#include "NodeList.h"
#include "ValidityState.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLOutputElementTableValues[] =
{
    { "htmlFor", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOutputElementHtmlFor), (intptr_t)setJSHTMLOutputElementHtmlFor, NoIntrinsic },
    { "form", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOutputElementForm), (intptr_t)0, NoIntrinsic },
    { "name", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOutputElementName), (intptr_t)setJSHTMLOutputElementName, NoIntrinsic },
    { "type", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOutputElementType), (intptr_t)0, NoIntrinsic },
    { "defaultValue", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOutputElementDefaultValue), (intptr_t)setJSHTMLOutputElementDefaultValue, NoIntrinsic },
    { "value", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOutputElementValue), (intptr_t)setJSHTMLOutputElementValue, NoIntrinsic },
    { "willValidate", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOutputElementWillValidate), (intptr_t)0, NoIntrinsic },
    { "validity", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOutputElementValidity), (intptr_t)0, NoIntrinsic },
    { "validationMessage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOutputElementValidationMessage), (intptr_t)0, NoIntrinsic },
    { "labels", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOutputElementLabels), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLOutputElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLOutputElementTable = { 34, 31, JSHTMLOutputElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLOutputElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLOutputElementConstructorTable = { 1, 0, JSHTMLOutputElementConstructorTableValues, 0 };
const ClassInfo JSHTMLOutputElementConstructor::s_info = { "HTMLOutputElementConstructor", &Base::s_info, &JSHTMLOutputElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLOutputElementConstructor) };

JSHTMLOutputElementConstructor::JSHTMLOutputElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLOutputElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLOutputElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLOutputElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLOutputElementConstructor, JSDOMWrapper>(exec, &JSHTMLOutputElementConstructorTable, jsCast<JSHTMLOutputElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLOutputElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLOutputElementConstructor, JSDOMWrapper>(exec, &JSHTMLOutputElementConstructorTable, jsCast<JSHTMLOutputElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLOutputElementPrototypeTableValues[] =
{
    { "checkValidity", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLOutputElementPrototypeFunctionCheckValidity), (intptr_t)0, NoIntrinsic },
    { "setCustomValidity", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLOutputElementPrototypeFunctionSetCustomValidity), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLOutputElementPrototypeTable = { 4, 3, JSHTMLOutputElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLOutputElementPrototype::s_info = { "HTMLOutputElementPrototype", &Base::s_info, &JSHTMLOutputElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLOutputElementPrototype) };

JSObject* JSHTMLOutputElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLOutputElement>(exec, globalObject);
}

bool JSHTMLOutputElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLOutputElementPrototype* thisObject = jsCast<JSHTMLOutputElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLOutputElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSHTMLOutputElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLOutputElementPrototype* thisObject = jsCast<JSHTMLOutputElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSHTMLOutputElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSHTMLOutputElement::s_info = { "HTMLOutputElement", &Base::s_info, &JSHTMLOutputElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLOutputElement) };

JSHTMLOutputElement::JSHTMLOutputElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLOutputElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLOutputElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLOutputElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLOutputElementPrototype::create(exec->globalData(), globalObject, JSHTMLOutputElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLOutputElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLOutputElement* thisObject = jsCast<JSHTMLOutputElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLOutputElement, Base>(exec, &JSHTMLOutputElementTable, thisObject, propertyName, slot);
}

bool JSHTMLOutputElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLOutputElement* thisObject = jsCast<JSHTMLOutputElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLOutputElement, Base>(exec, &JSHTMLOutputElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLOutputElementHtmlFor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLOutputElement* castedThis = jsCast<JSHTMLOutputElement*>(asObject(slotBase));
    return castedThis->htmlFor(exec);
}


JSValue jsHTMLOutputElementForm(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLOutputElement* castedThis = jsCast<JSHTMLOutputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLOutputElement* impl = static_cast<HTMLOutputElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->form()));
    return result;
}


JSValue jsHTMLOutputElementName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLOutputElement* castedThis = jsCast<JSHTMLOutputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLOutputElement* impl = static_cast<HTMLOutputElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::nameAttr));
    return result;
}


JSValue jsHTMLOutputElementType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLOutputElement* castedThis = jsCast<JSHTMLOutputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLOutputElement* impl = static_cast<HTMLOutputElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->type());
    return result;
}


JSValue jsHTMLOutputElementDefaultValue(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLOutputElement* castedThis = jsCast<JSHTMLOutputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLOutputElement* impl = static_cast<HTMLOutputElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->defaultValue());
    return result;
}


JSValue jsHTMLOutputElementValue(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLOutputElement* castedThis = jsCast<JSHTMLOutputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLOutputElement* impl = static_cast<HTMLOutputElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->value());
    return result;
}


JSValue jsHTMLOutputElementWillValidate(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLOutputElement* castedThis = jsCast<JSHTMLOutputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLOutputElement* impl = static_cast<HTMLOutputElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->willValidate());
    return result;
}


JSValue jsHTMLOutputElementValidity(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLOutputElement* castedThis = jsCast<JSHTMLOutputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLOutputElement* impl = static_cast<HTMLOutputElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->validity()));
    return result;
}


JSValue jsHTMLOutputElementValidationMessage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLOutputElement* castedThis = jsCast<JSHTMLOutputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLOutputElement* impl = static_cast<HTMLOutputElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->validationMessage());
    return result;
}


JSValue jsHTMLOutputElementLabels(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLOutputElement* castedThis = jsCast<JSHTMLOutputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLOutputElement* impl = static_cast<HTMLOutputElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->labels()));
    return result;
}


JSValue jsHTMLOutputElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLOutputElement* domObject = jsCast<JSHTMLOutputElement*>(asObject(slotBase));
    return JSHTMLOutputElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLOutputElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLOutputElement* thisObject = jsCast<JSHTMLOutputElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLOutputElement, Base>(exec, propertyName, value, &JSHTMLOutputElementTable, thisObject, slot);
}

void setJSHTMLOutputElementHtmlFor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    jsCast<JSHTMLOutputElement*>(thisObject)->setHtmlFor(exec, value);
}


void setJSHTMLOutputElementName(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLOutputElement* castedThis = jsCast<JSHTMLOutputElement*>(thisObject);
    HTMLOutputElement* impl = static_cast<HTMLOutputElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::nameAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLOutputElementDefaultValue(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLOutputElement* castedThis = jsCast<JSHTMLOutputElement*>(thisObject);
    HTMLOutputElement* impl = static_cast<HTMLOutputElement*>(castedThis->impl());
    impl->setDefaultValue(valueToStringWithNullCheck(exec, value));
}


void setJSHTMLOutputElementValue(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLOutputElement* castedThis = jsCast<JSHTMLOutputElement*>(thisObject);
    HTMLOutputElement* impl = static_cast<HTMLOutputElement*>(castedThis->impl());
    impl->setValue(valueToStringWithNullCheck(exec, value));
}


JSValue JSHTMLOutputElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLOutputElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLOutputElementPrototypeFunctionCheckValidity(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLOutputElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLOutputElement* castedThis = jsCast<JSHTMLOutputElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLOutputElement::s_info);
    HTMLOutputElement* impl = static_cast<HTMLOutputElement*>(castedThis->impl());

    JSC::JSValue result = jsBoolean(impl->checkValidity());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsHTMLOutputElementPrototypeFunctionSetCustomValidity(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLOutputElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLOutputElement* castedThis = jsCast<JSHTMLOutputElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLOutputElement::s_info);
    HTMLOutputElement* impl = static_cast<HTMLOutputElement*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& error(valueToStringWithUndefinedOrNullCheck(exec, MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setCustomValidity(error);
    return JSValue::encode(jsUndefined());
}


}
