/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLHeadElement.h"

#include "HTMLHeadElement.h"
#include "HTMLNames.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLHeadElementTableValues[] =
{
    { "profile", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLHeadElementProfile), (intptr_t)setJSHTMLHeadElementProfile, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLHeadElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLHeadElementTable = { 5, 3, JSHTMLHeadElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLHeadElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLHeadElementConstructorTable = { 1, 0, JSHTMLHeadElementConstructorTableValues, 0 };
const ClassInfo JSHTMLHeadElementConstructor::s_info = { "HTMLHeadElementConstructor", &Base::s_info, &JSHTMLHeadElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLHeadElementConstructor) };

JSHTMLHeadElementConstructor::JSHTMLHeadElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLHeadElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLHeadElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLHeadElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLHeadElementConstructor, JSDOMWrapper>(exec, &JSHTMLHeadElementConstructorTable, jsCast<JSHTMLHeadElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLHeadElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLHeadElementConstructor, JSDOMWrapper>(exec, &JSHTMLHeadElementConstructorTable, jsCast<JSHTMLHeadElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLHeadElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLHeadElementPrototypeTable = { 1, 0, JSHTMLHeadElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLHeadElementPrototype::s_info = { "HTMLHeadElementPrototype", &Base::s_info, &JSHTMLHeadElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLHeadElementPrototype) };

JSObject* JSHTMLHeadElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLHeadElement>(exec, globalObject);
}

const ClassInfo JSHTMLHeadElement::s_info = { "HTMLHeadElement", &Base::s_info, &JSHTMLHeadElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLHeadElement) };

JSHTMLHeadElement::JSHTMLHeadElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLHeadElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLHeadElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLHeadElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLHeadElementPrototype::create(exec->globalData(), globalObject, JSHTMLHeadElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLHeadElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLHeadElement* thisObject = jsCast<JSHTMLHeadElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLHeadElement, Base>(exec, &JSHTMLHeadElementTable, thisObject, propertyName, slot);
}

bool JSHTMLHeadElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLHeadElement* thisObject = jsCast<JSHTMLHeadElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLHeadElement, Base>(exec, &JSHTMLHeadElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLHeadElementProfile(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLHeadElement* castedThis = jsCast<JSHTMLHeadElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLHeadElement* impl = static_cast<HTMLHeadElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::profileAttr));
    return result;
}


JSValue jsHTMLHeadElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLHeadElement* domObject = jsCast<JSHTMLHeadElement*>(asObject(slotBase));
    return JSHTMLHeadElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLHeadElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLHeadElement* thisObject = jsCast<JSHTMLHeadElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLHeadElement, Base>(exec, propertyName, value, &JSHTMLHeadElementTable, thisObject, slot);
}

void setJSHTMLHeadElementProfile(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLHeadElement* castedThis = jsCast<JSHTMLHeadElement*>(thisObject);
    HTMLHeadElement* impl = static_cast<HTMLHeadElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::profileAttr, valueToStringWithNullCheck(exec, value));
}


JSValue JSHTMLHeadElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLHeadElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}
