/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCanvasRenderingContext2D.h"

#include "CanvasGradient.h"
#include "CanvasPattern.h"
#include "CanvasRenderingContext2D.h"
#include "CanvasStyle.h"
#include "ExceptionCode.h"
#include "ImageData.h"
#include "JSCanvasGradient.h"
#include "JSCanvasPattern.h"
#include "JSDOMBinding.h"
#include "JSHTMLCanvasElement.h"
#include "JSHTMLImageElement.h"
#include "JSHTMLVideoElement.h"
#include "JSImageData.h"
#include "JSTextMetrics.h"
#include "KURL.h"
#include "TextMetrics.h"
#include <runtime/Error.h>
#include <runtime/JSArray.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>
#include <wtf/text/WTFString.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSCanvasRenderingContext2DTableValues[] =
{
    { "globalAlpha", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DGlobalAlpha), (intptr_t)setJSCanvasRenderingContext2DGlobalAlpha, NoIntrinsic },
    { "globalCompositeOperation", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DGlobalCompositeOperation), (intptr_t)setJSCanvasRenderingContext2DGlobalCompositeOperation, NoIntrinsic },
    { "lineWidth", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DLineWidth), (intptr_t)setJSCanvasRenderingContext2DLineWidth, NoIntrinsic },
    { "lineCap", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DLineCap), (intptr_t)setJSCanvasRenderingContext2DLineCap, NoIntrinsic },
    { "lineJoin", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DLineJoin), (intptr_t)setJSCanvasRenderingContext2DLineJoin, NoIntrinsic },
    { "miterLimit", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DMiterLimit), (intptr_t)setJSCanvasRenderingContext2DMiterLimit, NoIntrinsic },
    { "shadowOffsetX", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DShadowOffsetX), (intptr_t)setJSCanvasRenderingContext2DShadowOffsetX, NoIntrinsic },
    { "shadowOffsetY", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DShadowOffsetY), (intptr_t)setJSCanvasRenderingContext2DShadowOffsetY, NoIntrinsic },
    { "shadowBlur", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DShadowBlur), (intptr_t)setJSCanvasRenderingContext2DShadowBlur, NoIntrinsic },
    { "shadowColor", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DShadowColor), (intptr_t)setJSCanvasRenderingContext2DShadowColor, NoIntrinsic },
    { "lineDashOffset", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DLineDashOffset), (intptr_t)setJSCanvasRenderingContext2DLineDashOffset, NoIntrinsic },
    { "webkitLineDash", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DWebkitLineDash), (intptr_t)setJSCanvasRenderingContext2DWebkitLineDash, NoIntrinsic },
    { "webkitLineDashOffset", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DWebkitLineDashOffset), (intptr_t)setJSCanvasRenderingContext2DWebkitLineDashOffset, NoIntrinsic },
    { "font", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DFont), (intptr_t)setJSCanvasRenderingContext2DFont, NoIntrinsic },
    { "textAlign", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DTextAlign), (intptr_t)setJSCanvasRenderingContext2DTextAlign, NoIntrinsic },
    { "textBaseline", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DTextBaseline), (intptr_t)setJSCanvasRenderingContext2DTextBaseline, NoIntrinsic },
    { "strokeStyle", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DStrokeStyle), (intptr_t)setJSCanvasRenderingContext2DStrokeStyle, NoIntrinsic },
    { "fillStyle", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DFillStyle), (intptr_t)setJSCanvasRenderingContext2DFillStyle, NoIntrinsic },
    { "webkitBackingStorePixelRatio", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DWebkitBackingStorePixelRatio), (intptr_t)0, NoIntrinsic },
    { "webkitImageSmoothingEnabled", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DWebkitImageSmoothingEnabled), (intptr_t)setJSCanvasRenderingContext2DWebkitImageSmoothingEnabled, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCanvasRenderingContext2DConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCanvasRenderingContext2DTable = { 68, 63, JSCanvasRenderingContext2DTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSCanvasRenderingContext2DConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCanvasRenderingContext2DConstructorTable = { 1, 0, JSCanvasRenderingContext2DConstructorTableValues, 0 };
const ClassInfo JSCanvasRenderingContext2DConstructor::s_info = { "CanvasRenderingContext2DConstructor", &Base::s_info, &JSCanvasRenderingContext2DConstructorTable, 0, CREATE_METHOD_TABLE(JSCanvasRenderingContext2DConstructor) };

JSCanvasRenderingContext2DConstructor::JSCanvasRenderingContext2DConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSCanvasRenderingContext2DConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSCanvasRenderingContext2DPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSCanvasRenderingContext2DConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCanvasRenderingContext2DConstructor, JSDOMWrapper>(exec, &JSCanvasRenderingContext2DConstructorTable, jsCast<JSCanvasRenderingContext2DConstructor*>(cell), propertyName, slot);
}

bool JSCanvasRenderingContext2DConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCanvasRenderingContext2DConstructor, JSDOMWrapper>(exec, &JSCanvasRenderingContext2DConstructorTable, jsCast<JSCanvasRenderingContext2DConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSCanvasRenderingContext2DPrototypeTableValues[] =
{
    { "save", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSave), (intptr_t)0, NoIntrinsic },
    { "restore", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionRestore), (intptr_t)0, NoIntrinsic },
    { "scale", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionScale), (intptr_t)2, NoIntrinsic },
    { "rotate", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionRotate), (intptr_t)1, NoIntrinsic },
    { "translate", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionTranslate), (intptr_t)2, NoIntrinsic },
    { "transform", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionTransform), (intptr_t)6, NoIntrinsic },
    { "setTransform", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetTransform), (intptr_t)6, NoIntrinsic },
    { "createLinearGradient", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionCreateLinearGradient), (intptr_t)4, NoIntrinsic },
    { "createRadialGradient", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionCreateRadialGradient), (intptr_t)6, NoIntrinsic },
    { "setLineDash", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetLineDash), (intptr_t)1, NoIntrinsic },
    { "getLineDash", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionGetLineDash), (intptr_t)0, NoIntrinsic },
    { "clearRect", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionClearRect), (intptr_t)4, NoIntrinsic },
    { "fillRect", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionFillRect), (intptr_t)4, NoIntrinsic },
    { "beginPath", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionBeginPath), (intptr_t)0, NoIntrinsic },
    { "closePath", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionClosePath), (intptr_t)0, NoIntrinsic },
    { "moveTo", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionMoveTo), (intptr_t)2, NoIntrinsic },
    { "lineTo", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionLineTo), (intptr_t)2, NoIntrinsic },
    { "quadraticCurveTo", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionQuadraticCurveTo), (intptr_t)4, NoIntrinsic },
    { "bezierCurveTo", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionBezierCurveTo), (intptr_t)6, NoIntrinsic },
    { "arcTo", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionArcTo), (intptr_t)5, NoIntrinsic },
    { "rect", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionRect), (intptr_t)4, NoIntrinsic },
    { "arc", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionArc), (intptr_t)6, NoIntrinsic },
    { "fill", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionFill), (intptr_t)0, NoIntrinsic },
    { "stroke", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionStroke), (intptr_t)0, NoIntrinsic },
    { "clip", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionClip), (intptr_t)0, NoIntrinsic },
    { "isPointInPath", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionIsPointInPath), (intptr_t)2, NoIntrinsic },
    { "measureText", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionMeasureText), (intptr_t)1, NoIntrinsic },
    { "setAlpha", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetAlpha), (intptr_t)1, NoIntrinsic },
    { "setCompositeOperation", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetCompositeOperation), (intptr_t)1, NoIntrinsic },
    { "setLineWidth", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetLineWidth), (intptr_t)1, NoIntrinsic },
    { "setLineCap", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetLineCap), (intptr_t)1, NoIntrinsic },
    { "setLineJoin", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetLineJoin), (intptr_t)1, NoIntrinsic },
    { "setMiterLimit", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetMiterLimit), (intptr_t)1, NoIntrinsic },
    { "clearShadow", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionClearShadow), (intptr_t)0, NoIntrinsic },
    { "fillText", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionFillText), (intptr_t)4, NoIntrinsic },
    { "strokeText", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionStrokeText), (intptr_t)4, NoIntrinsic },
    { "setStrokeColor", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor), (intptr_t)2, NoIntrinsic },
    { "setFillColor", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetFillColor), (intptr_t)2, NoIntrinsic },
    { "strokeRect", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionStrokeRect), (intptr_t)5, NoIntrinsic },
    { "drawImage", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionDrawImage), (intptr_t)3, NoIntrinsic },
    { "drawImageFromRect", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionDrawImageFromRect), (intptr_t)10, NoIntrinsic },
    { "setShadow", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionSetShadow), (intptr_t)5, NoIntrinsic },
    { "putImageData", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionPutImageData), (intptr_t)3, NoIntrinsic },
    { "webkitPutImageDataHD", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionWebkitPutImageDataHD), (intptr_t)3, NoIntrinsic },
    { "createPattern", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionCreatePattern), (intptr_t)2, NoIntrinsic },
    { "createImageData", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionCreateImageData), (intptr_t)1, NoIntrinsic },
    { "getImageData", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionGetImageData), (intptr_t)4, NoIntrinsic },
    { "webkitGetImageDataHD", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCanvasRenderingContext2DPrototypeFunctionWebkitGetImageDataHD), (intptr_t)4, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCanvasRenderingContext2DPrototypeTable = { 258, 255, JSCanvasRenderingContext2DPrototypeTableValues, 0 };
const ClassInfo JSCanvasRenderingContext2DPrototype::s_info = { "CanvasRenderingContext2DPrototype", &Base::s_info, &JSCanvasRenderingContext2DPrototypeTable, 0, CREATE_METHOD_TABLE(JSCanvasRenderingContext2DPrototype) };

JSObject* JSCanvasRenderingContext2DPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCanvasRenderingContext2D>(exec, globalObject);
}

bool JSCanvasRenderingContext2DPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSCanvasRenderingContext2DPrototype* thisObject = jsCast<JSCanvasRenderingContext2DPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSCanvasRenderingContext2DPrototypeTable, thisObject, propertyName, slot);
}

bool JSCanvasRenderingContext2DPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSCanvasRenderingContext2DPrototype* thisObject = jsCast<JSCanvasRenderingContext2DPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSCanvasRenderingContext2DPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSCanvasRenderingContext2D::s_info = { "CanvasRenderingContext2D", &Base::s_info, &JSCanvasRenderingContext2DTable, 0 , CREATE_METHOD_TABLE(JSCanvasRenderingContext2D) };

JSCanvasRenderingContext2D::JSCanvasRenderingContext2D(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<CanvasRenderingContext2D> impl)
    : JSCanvasRenderingContext(structure, globalObject, impl)
{
}

void JSCanvasRenderingContext2D::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSCanvasRenderingContext2D::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSCanvasRenderingContext2DPrototype::create(exec->globalData(), globalObject, JSCanvasRenderingContext2DPrototype::createStructure(exec->globalData(), globalObject, JSCanvasRenderingContextPrototype::self(exec, globalObject)));
}

bool JSCanvasRenderingContext2D::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSCanvasRenderingContext2D* thisObject = jsCast<JSCanvasRenderingContext2D*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSCanvasRenderingContext2D, Base>(exec, &JSCanvasRenderingContext2DTable, thisObject, propertyName, slot);
}

bool JSCanvasRenderingContext2D::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSCanvasRenderingContext2D* thisObject = jsCast<JSCanvasRenderingContext2D*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSCanvasRenderingContext2D, Base>(exec, &JSCanvasRenderingContext2DTable, thisObject, propertyName, descriptor);
}

JSValue jsCanvasRenderingContext2DGlobalAlpha(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsNumber(impl->globalAlpha());
    return result;
}


JSValue jsCanvasRenderingContext2DGlobalCompositeOperation(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->globalCompositeOperation());
    return result;
}


JSValue jsCanvasRenderingContext2DLineWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsNumber(impl->lineWidth());
    return result;
}


JSValue jsCanvasRenderingContext2DLineCap(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->lineCap());
    return result;
}


JSValue jsCanvasRenderingContext2DLineJoin(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->lineJoin());
    return result;
}


JSValue jsCanvasRenderingContext2DMiterLimit(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsNumber(impl->miterLimit());
    return result;
}


JSValue jsCanvasRenderingContext2DShadowOffsetX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsNumber(impl->shadowOffsetX());
    return result;
}


JSValue jsCanvasRenderingContext2DShadowOffsetY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsNumber(impl->shadowOffsetY());
    return result;
}


JSValue jsCanvasRenderingContext2DShadowBlur(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsNumber(impl->shadowBlur());
    return result;
}


JSValue jsCanvasRenderingContext2DShadowColor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->shadowColor());
    return result;
}


JSValue jsCanvasRenderingContext2DLineDashOffset(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsNumber(impl->lineDashOffset());
    return result;
}


JSValue jsCanvasRenderingContext2DWebkitLineDash(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    return castedThis->webkitLineDash(exec);
}


JSValue jsCanvasRenderingContext2DWebkitLineDashOffset(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsNumber(impl->webkitLineDashOffset());
    return result;
}


JSValue jsCanvasRenderingContext2DFont(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->font());
    return result;
}


JSValue jsCanvasRenderingContext2DTextAlign(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->textAlign());
    return result;
}


JSValue jsCanvasRenderingContext2DTextBaseline(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->textBaseline());
    return result;
}


JSValue jsCanvasRenderingContext2DStrokeStyle(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    return castedThis->strokeStyle(exec);
}


JSValue jsCanvasRenderingContext2DFillStyle(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    return castedThis->fillStyle(exec);
}


JSValue jsCanvasRenderingContext2DWebkitBackingStorePixelRatio(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsNumber(impl->webkitBackingStorePixelRatio());
    return result;
}


JSValue jsCanvasRenderingContext2DWebkitImageSmoothingEnabled(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    JSValue result = jsBoolean(impl->webkitImageSmoothingEnabled());
    return result;
}


JSValue jsCanvasRenderingContext2DConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCanvasRenderingContext2D* domObject = jsCast<JSCanvasRenderingContext2D*>(asObject(slotBase));
    return JSCanvasRenderingContext2D::getConstructor(exec, domObject->globalObject());
}

void JSCanvasRenderingContext2D::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSCanvasRenderingContext2D* thisObject = jsCast<JSCanvasRenderingContext2D*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSCanvasRenderingContext2D, Base>(exec, propertyName, value, &JSCanvasRenderingContext2DTable, thisObject, slot);
}

void setJSCanvasRenderingContext2DGlobalAlpha(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    impl->setGlobalAlpha(value.toFloat(exec));
}


void setJSCanvasRenderingContext2DGlobalCompositeOperation(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    impl->setGlobalCompositeOperation(valueToStringWithNullCheck(exec, value));
}


void setJSCanvasRenderingContext2DLineWidth(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    impl->setLineWidth(value.toFloat(exec));
}


void setJSCanvasRenderingContext2DLineCap(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    impl->setLineCap(valueToStringWithNullCheck(exec, value));
}


void setJSCanvasRenderingContext2DLineJoin(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    impl->setLineJoin(valueToStringWithNullCheck(exec, value));
}


void setJSCanvasRenderingContext2DMiterLimit(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    impl->setMiterLimit(value.toFloat(exec));
}


void setJSCanvasRenderingContext2DShadowOffsetX(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    impl->setShadowOffsetX(value.toFloat(exec));
}


void setJSCanvasRenderingContext2DShadowOffsetY(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    impl->setShadowOffsetY(value.toFloat(exec));
}


void setJSCanvasRenderingContext2DShadowBlur(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    impl->setShadowBlur(value.toFloat(exec));
}


void setJSCanvasRenderingContext2DShadowColor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    impl->setShadowColor(valueToStringWithNullCheck(exec, value));
}


void setJSCanvasRenderingContext2DLineDashOffset(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    impl->setLineDashOffset(value.toFloat(exec));
}


void setJSCanvasRenderingContext2DWebkitLineDash(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    jsCast<JSCanvasRenderingContext2D*>(thisObject)->setWebkitLineDash(exec, value);
}


void setJSCanvasRenderingContext2DWebkitLineDashOffset(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    impl->setWebkitLineDashOffset(value.toFloat(exec));
}


void setJSCanvasRenderingContext2DFont(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    impl->setFont(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


void setJSCanvasRenderingContext2DTextAlign(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    impl->setTextAlign(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


void setJSCanvasRenderingContext2DTextBaseline(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    impl->setTextBaseline(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


void setJSCanvasRenderingContext2DStrokeStyle(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    jsCast<JSCanvasRenderingContext2D*>(thisObject)->setStrokeStyle(exec, value);
}


void setJSCanvasRenderingContext2DFillStyle(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    jsCast<JSCanvasRenderingContext2D*>(thisObject)->setFillStyle(exec, value);
}


void setJSCanvasRenderingContext2DWebkitImageSmoothingEnabled(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(thisObject);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    impl->setWebkitImageSmoothingEnabled(value.toBoolean(exec));
}


JSValue JSCanvasRenderingContext2D::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCanvasRenderingContext2DConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSave(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    impl->save();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionRestore(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    impl->restore();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionScale(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    float sx(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float sy(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->scale(sx, sy);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionRotate(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    float angle(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->rotate(angle);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionTranslate(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    float tx(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float ty(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->translate(tx, ty);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionTransform(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    float m11(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float m12(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float m21(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float m22(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float dx(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float dy(MAYBE_MISSING_PARAMETER(exec, 5, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->transform(m11, m12, m21, m22, dx, dy);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetTransform(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    float m11(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float m12(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float m21(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float m22(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float dx(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float dy(MAYBE_MISSING_PARAMETER(exec, 5, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setTransform(m11, m12, m21, m22, dx, dy);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreateLinearGradient(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    ExceptionCode ec = 0;
    float x0(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y0(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float x1(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y1(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createLinearGradient(x0, y0, x1, y1, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreateRadialGradient(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    ExceptionCode ec = 0;
    float x0(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y0(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float r0(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float x1(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y1(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float r1(MAYBE_MISSING_PARAMETER(exec, 5, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createRadialGradient(x0, y0, r0, x1, y1, r1, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetLineDash(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Vector<float> dash(toNativeArray<float>(exec, MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setLineDash(dash);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionGetLineDash(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());

    JSC::JSValue result = jsArray(exec, castedThis->globalObject(), impl->getLineDash());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionClearRect(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    float x(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float width(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float height(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->clearRect(x, y, width, height);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionFillRect(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    float x(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float width(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float height(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->fillRect(x, y, width, height);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionBeginPath(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    impl->beginPath();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionClosePath(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    impl->closePath();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionMoveTo(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    float x(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->moveTo(x, y);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionLineTo(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    float x(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->lineTo(x, y);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionQuadraticCurveTo(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    float cpx(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float cpy(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float x(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->quadraticCurveTo(cpx, cpy, x, y);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionBezierCurveTo(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    float cp1x(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float cp1y(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float cp2x(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float cp2y(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float x(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(MAYBE_MISSING_PARAMETER(exec, 5, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->bezierCurveTo(cp1x, cp1y, cp2x, cp2y, x, y);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionArcTo(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    ExceptionCode ec = 0;
    float x1(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y1(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float x2(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y2(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float radius(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->arcTo(x1, y1, x2, y2, radius, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionRect(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    float x(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float width(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float height(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->rect(x, y, width, height);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionArc(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    ExceptionCode ec = 0;
    float x(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float radius(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float startAngle(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float endAngle(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool anticlockwise(MAYBE_MISSING_PARAMETER(exec, 5, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->arc(x, y, radius, startAngle, endAngle, anticlockwise, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionFill(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    impl->fill();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionStroke(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    impl->stroke();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionClip(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    impl->clip();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionIsPointInPath(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    float x(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->isPointInPath(x, y));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionMeasureText(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    const String& text(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->measureText(text)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetAlpha(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    float alpha(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAlpha(alpha);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetCompositeOperation(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    const String& compositeOperation(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setCompositeOperation(compositeOperation);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetLineWidth(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    float width(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setLineWidth(width);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetLineCap(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    const String& cap(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setLineCap(cap);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetLineJoin(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    const String& join(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setLineJoin(join);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetMiterLimit(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    float limit(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setMiterLimit(limit);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionClearShadow(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    impl->clearShadow();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionFillText(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& text(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float x(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 3) {
        impl->fillText(text, x, y);
        return JSValue::encode(jsUndefined());
    }

    float maxWidth(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->fillText(text, x, y, maxWidth);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionStrokeText(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& text(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float x(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 3) {
        impl->strokeText(text, x, y);
        return JSValue::encode(jsUndefined());
    }

    float maxWidth(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->strokeText(text, x, y, maxWidth);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor1(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& color(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 1) {
        impl->setStrokeColor(color);
        return JSValue::encode(jsUndefined());
    }

    float alpha(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setStrokeColor(color, alpha);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor2(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    float grayLevel(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 1) {
        impl->setStrokeColor(grayLevel);
        return JSValue::encode(jsUndefined());
    }

    float alpha(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setStrokeColor(grayLevel, alpha);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor3(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    if (exec->argumentCount() < 4)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    float r(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float g(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float b(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float a(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setStrokeColor(r, g, b, a);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor4(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    if (exec->argumentCount() < 5)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    float c(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float m(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float k(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float a(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setStrokeColor(c, m, y, k, a);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor(ExecState* exec)
{
    size_t argsCount = exec->argumentCount();
    JSValue arg0(exec->argument(0));
    if ((argsCount == 1 && (arg0.isUndefinedOrNull() || arg0.isString() || arg0.isObject())) || (argsCount == 2 && (arg0.isUndefinedOrNull() || arg0.isString() || arg0.isObject())))
        return jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor1(exec);
    if (argsCount == 1 || argsCount == 2)
        return jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor2(exec);
    if (argsCount == 4)
        return jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor3(exec);
    if (argsCount == 5)
        return jsCanvasRenderingContext2DPrototypeFunctionSetStrokeColor4(exec);
    if (argsCount < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    return throwVMTypeError(exec);
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetFillColor1(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& color(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 1) {
        impl->setFillColor(color);
        return JSValue::encode(jsUndefined());
    }

    float alpha(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setFillColor(color, alpha);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetFillColor2(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    float grayLevel(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 1) {
        impl->setFillColor(grayLevel);
        return JSValue::encode(jsUndefined());
    }

    float alpha(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setFillColor(grayLevel, alpha);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetFillColor3(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    if (exec->argumentCount() < 4)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    float r(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float g(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float b(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float a(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setFillColor(r, g, b, a);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetFillColor4(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    if (exec->argumentCount() < 5)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    float c(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float m(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float k(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float a(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setFillColor(c, m, y, k, a);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetFillColor(ExecState* exec)
{
    size_t argsCount = exec->argumentCount();
    JSValue arg0(exec->argument(0));
    if ((argsCount == 1 && (arg0.isUndefinedOrNull() || arg0.isString() || arg0.isObject())) || (argsCount == 2 && (arg0.isUndefinedOrNull() || arg0.isString() || arg0.isObject())))
        return jsCanvasRenderingContext2DPrototypeFunctionSetFillColor1(exec);
    if (argsCount == 1 || argsCount == 2)
        return jsCanvasRenderingContext2DPrototypeFunctionSetFillColor2(exec);
    if (argsCount == 4)
        return jsCanvasRenderingContext2DPrototypeFunctionSetFillColor3(exec);
    if (argsCount == 5)
        return jsCanvasRenderingContext2DPrototypeFunctionSetFillColor4(exec);
    if (argsCount < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    return throwVMTypeError(exec);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionStrokeRect(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    float x(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float width(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float height(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 4) {
        impl->strokeRect(x, y, width, height);
        return JSValue::encode(jsUndefined());
    }

    float lineWidth(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->strokeRect(x, y, width, height, lineWidth);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawImage1(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    HTMLImageElement* image(toHTMLImageElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float x(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->drawImage(image, x, y, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawImage2(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    if (exec->argumentCount() < 5)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    HTMLImageElement* image(toHTMLImageElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float x(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float width(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float height(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->drawImage(image, x, y, width, height, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawImage3(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    if (exec->argumentCount() < 9)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    HTMLImageElement* image(toHTMLImageElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float sx(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float sy(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float sw(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float sh(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float dx(MAYBE_MISSING_PARAMETER(exec, 5, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float dy(MAYBE_MISSING_PARAMETER(exec, 6, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float dw(MAYBE_MISSING_PARAMETER(exec, 7, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float dh(MAYBE_MISSING_PARAMETER(exec, 8, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->drawImage(image, sx, sy, sw, sh, dx, dy, dw, dh, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawImage4(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    HTMLCanvasElement* canvas(toHTMLCanvasElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float x(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->drawImage(canvas, x, y, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawImage5(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    if (exec->argumentCount() < 5)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    HTMLCanvasElement* canvas(toHTMLCanvasElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float x(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float width(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float height(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->drawImage(canvas, x, y, width, height, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawImage6(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    if (exec->argumentCount() < 9)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    HTMLCanvasElement* canvas(toHTMLCanvasElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float sx(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float sy(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float sw(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float sh(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float dx(MAYBE_MISSING_PARAMETER(exec, 5, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float dy(MAYBE_MISSING_PARAMETER(exec, 6, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float dw(MAYBE_MISSING_PARAMETER(exec, 7, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float dh(MAYBE_MISSING_PARAMETER(exec, 8, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->drawImage(canvas, sx, sy, sw, sh, dx, dy, dw, dh, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawImage7(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    HTMLVideoElement* video(toHTMLVideoElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float x(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->drawImage(video, x, y, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawImage8(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    if (exec->argumentCount() < 5)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    HTMLVideoElement* video(toHTMLVideoElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float x(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float width(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float height(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->drawImage(video, x, y, width, height, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawImage9(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    if (exec->argumentCount() < 9)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    HTMLVideoElement* video(toHTMLVideoElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float sx(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float sy(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float sw(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float sh(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float dx(MAYBE_MISSING_PARAMETER(exec, 5, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float dy(MAYBE_MISSING_PARAMETER(exec, 6, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float dw(MAYBE_MISSING_PARAMETER(exec, 7, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float dh(MAYBE_MISSING_PARAMETER(exec, 8, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->drawImage(video, sx, sy, sw, sh, dx, dy, dw, dh, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawImage(ExecState* exec)
{
    size_t argsCount = exec->argumentCount();
    JSValue arg0(exec->argument(0));
    if ((argsCount == 3 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(&JSHTMLImageElement::s_info)))))
        return jsCanvasRenderingContext2DPrototypeFunctionDrawImage1(exec);
    if ((argsCount == 5 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(&JSHTMLImageElement::s_info)))))
        return jsCanvasRenderingContext2DPrototypeFunctionDrawImage2(exec);
    if ((argsCount == 9 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(&JSHTMLImageElement::s_info)))))
        return jsCanvasRenderingContext2DPrototypeFunctionDrawImage3(exec);
    if ((argsCount == 3 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(&JSHTMLCanvasElement::s_info)))))
        return jsCanvasRenderingContext2DPrototypeFunctionDrawImage4(exec);
    if ((argsCount == 5 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(&JSHTMLCanvasElement::s_info)))))
        return jsCanvasRenderingContext2DPrototypeFunctionDrawImage5(exec);
    if ((argsCount == 9 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(&JSHTMLCanvasElement::s_info)))))
        return jsCanvasRenderingContext2DPrototypeFunctionDrawImage6(exec);
    if ((argsCount == 3 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(&JSHTMLVideoElement::s_info)))))
        return jsCanvasRenderingContext2DPrototypeFunctionDrawImage7(exec);
    if ((argsCount == 5 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(&JSHTMLVideoElement::s_info)))))
        return jsCanvasRenderingContext2DPrototypeFunctionDrawImage8(exec);
    if ((argsCount == 9 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(&JSHTMLVideoElement::s_info)))))
        return jsCanvasRenderingContext2DPrototypeFunctionDrawImage9(exec);
    if (argsCount < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    return throwVMTypeError(exec);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionDrawImageFromRect(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    HTMLImageElement* image(toHTMLImageElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 1) {
        impl->drawImageFromRect(image);
        return JSValue::encode(jsUndefined());
    }

    float sx(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (argsCount <= 2) {
        impl->drawImageFromRect(image, sx);
        return JSValue::encode(jsUndefined());
    }

    float sy(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (argsCount <= 3) {
        impl->drawImageFromRect(image, sx, sy);
        return JSValue::encode(jsUndefined());
    }

    float sw(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (argsCount <= 4) {
        impl->drawImageFromRect(image, sx, sy, sw);
        return JSValue::encode(jsUndefined());
    }

    float sh(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (argsCount <= 5) {
        impl->drawImageFromRect(image, sx, sy, sw, sh);
        return JSValue::encode(jsUndefined());
    }

    float dx(MAYBE_MISSING_PARAMETER(exec, 5, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (argsCount <= 6) {
        impl->drawImageFromRect(image, sx, sy, sw, sh, dx);
        return JSValue::encode(jsUndefined());
    }

    float dy(MAYBE_MISSING_PARAMETER(exec, 6, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (argsCount <= 7) {
        impl->drawImageFromRect(image, sx, sy, sw, sh, dx, dy);
        return JSValue::encode(jsUndefined());
    }

    float dw(MAYBE_MISSING_PARAMETER(exec, 7, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (argsCount <= 8) {
        impl->drawImageFromRect(image, sx, sy, sw, sh, dx, dy, dw);
        return JSValue::encode(jsUndefined());
    }

    float dh(MAYBE_MISSING_PARAMETER(exec, 8, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (argsCount <= 9) {
        impl->drawImageFromRect(image, sx, sy, sw, sh, dx, dy, dw, dh);
        return JSValue::encode(jsUndefined());
    }

    const String& compositeOperation(MAYBE_MISSING_PARAMETER(exec, 9, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 9, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->drawImageFromRect(image, sx, sy, sw, sh, dx, dy, dw, dh, compositeOperation);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetShadow1(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    float width(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float height(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float blur(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 3) {
        impl->setShadow(width, height, blur);
        return JSValue::encode(jsUndefined());
    }

    const String& color(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (argsCount <= 4) {
        impl->setShadow(width, height, blur, color);
        return JSValue::encode(jsUndefined());
    }

    float alpha(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setShadow(width, height, blur, color, alpha);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetShadow2(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    if (exec->argumentCount() < 4)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    float width(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float height(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float blur(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float grayLevel(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 4) {
        impl->setShadow(width, height, blur, grayLevel);
        return JSValue::encode(jsUndefined());
    }

    float alpha(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setShadow(width, height, blur, grayLevel, alpha);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetShadow3(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    if (exec->argumentCount() < 7)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    float width(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float height(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float blur(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float r(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float g(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float b(MAYBE_MISSING_PARAMETER(exec, 5, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float a(MAYBE_MISSING_PARAMETER(exec, 6, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setShadow(width, height, blur, r, g, b, a);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetShadow4(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    if (exec->argumentCount() < 8)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    float width(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float height(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float blur(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float c(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float m(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(MAYBE_MISSING_PARAMETER(exec, 5, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float k(MAYBE_MISSING_PARAMETER(exec, 6, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float a(MAYBE_MISSING_PARAMETER(exec, 7, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setShadow(width, height, blur, c, m, y, k, a);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionSetShadow(ExecState* exec)
{
    size_t argsCount = exec->argumentCount();
    JSValue arg3(exec->argument(3));
    if (argsCount == 3 || (argsCount == 4 && (arg3.isUndefinedOrNull() || arg3.isString() || arg3.isObject())) || (argsCount == 5 && (arg3.isUndefinedOrNull() || arg3.isString() || arg3.isObject())))
        return jsCanvasRenderingContext2DPrototypeFunctionSetShadow1(exec);
    if (argsCount == 4 || argsCount == 5)
        return jsCanvasRenderingContext2DPrototypeFunctionSetShadow2(exec);
    if (argsCount == 7)
        return jsCanvasRenderingContext2DPrototypeFunctionSetShadow3(exec);
    if (argsCount == 8)
        return jsCanvasRenderingContext2DPrototypeFunctionSetShadow4(exec);
    if (argsCount < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    return throwVMTypeError(exec);
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionPutImageData1(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    ImageData* imagedata(toImageData(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float dx(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float dy(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->putImageData(imagedata, dx, dy, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionPutImageData2(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    if (exec->argumentCount() < 7)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    ImageData* imagedata(toImageData(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float dx(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float dy(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float dirtyX(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float dirtyY(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float dirtyWidth(MAYBE_MISSING_PARAMETER(exec, 5, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float dirtyHeight(MAYBE_MISSING_PARAMETER(exec, 6, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->putImageData(imagedata, dx, dy, dirtyX, dirtyY, dirtyWidth, dirtyHeight, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionPutImageData(ExecState* exec)
{
    size_t argsCount = exec->argumentCount();
    JSValue arg0(exec->argument(0));
    if ((argsCount == 3 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(&JSImageData::s_info)))))
        return jsCanvasRenderingContext2DPrototypeFunctionPutImageData1(exec);
    if ((argsCount == 7 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(&JSImageData::s_info)))))
        return jsCanvasRenderingContext2DPrototypeFunctionPutImageData2(exec);
    if (argsCount < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    return throwVMTypeError(exec);
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionWebkitPutImageDataHD1(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    ImageData* imagedata(toImageData(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float dx(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float dy(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->webkitPutImageDataHD(imagedata, dx, dy, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionWebkitPutImageDataHD2(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    if (exec->argumentCount() < 7)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    ImageData* imagedata(toImageData(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float dx(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float dy(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float dirtyX(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float dirtyY(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float dirtyWidth(MAYBE_MISSING_PARAMETER(exec, 5, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float dirtyHeight(MAYBE_MISSING_PARAMETER(exec, 6, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->webkitPutImageDataHD(imagedata, dx, dy, dirtyX, dirtyY, dirtyWidth, dirtyHeight, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionWebkitPutImageDataHD(ExecState* exec)
{
    size_t argsCount = exec->argumentCount();
    JSValue arg0(exec->argument(0));
    if ((argsCount == 3 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(&JSImageData::s_info)))))
        return jsCanvasRenderingContext2DPrototypeFunctionWebkitPutImageDataHD1(exec);
    if ((argsCount == 7 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(&JSImageData::s_info)))))
        return jsCanvasRenderingContext2DPrototypeFunctionWebkitPutImageDataHD2(exec);
    if (argsCount < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    return throwVMTypeError(exec);
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreatePattern1(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    HTMLCanvasElement* canvas(toHTMLCanvasElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& repetitionType(valueToStringWithNullCheck(exec, MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createPattern(canvas, repetitionType, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreatePattern2(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    HTMLImageElement* image(toHTMLImageElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& repetitionType(valueToStringWithNullCheck(exec, MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createPattern(image, repetitionType, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreatePattern(ExecState* exec)
{
    size_t argsCount = exec->argumentCount();
    JSValue arg0(exec->argument(0));
    if ((argsCount == 2 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(&JSHTMLCanvasElement::s_info)))))
        return jsCanvasRenderingContext2DPrototypeFunctionCreatePattern1(exec);
    if ((argsCount == 2 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(&JSHTMLImageElement::s_info)))))
        return jsCanvasRenderingContext2DPrototypeFunctionCreatePattern2(exec);
    if (argsCount < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    return throwVMTypeError(exec);
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreateImageData1(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    ImageData* imagedata(toImageData(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createImageData(imagedata, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

static EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreateImageData2(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    float sw(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float sh(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createImageData(sw, sh, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionCreateImageData(ExecState* exec)
{
    size_t argsCount = exec->argumentCount();
    JSValue arg0(exec->argument(0));
    if ((argsCount == 1 && (arg0.isNull() || (arg0.isObject() && asObject(arg0)->inherits(&JSImageData::s_info)))))
        return jsCanvasRenderingContext2DPrototypeFunctionCreateImageData1(exec);
    if (argsCount == 2)
        return jsCanvasRenderingContext2DPrototypeFunctionCreateImageData2(exec);
    if (argsCount < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    return throwVMTypeError(exec);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionGetImageData(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    ExceptionCode ec = 0;
    float sx(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float sy(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float sw(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float sh(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getImageData(sx, sy, sw, sh, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCanvasRenderingContext2DPrototypeFunctionWebkitGetImageDataHD(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCanvasRenderingContext2D::s_info))
        return throwVMTypeError(exec);
    JSCanvasRenderingContext2D* castedThis = jsCast<JSCanvasRenderingContext2D*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCanvasRenderingContext2D::s_info);
    CanvasRenderingContext2D* impl = static_cast<CanvasRenderingContext2D*>(castedThis->impl());
    ExceptionCode ec = 0;
    float sx(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float sy(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float sw(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float sh(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->webkitGetImageDataHD(sx, sy, sw, sh, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}


}
