.TH "ZIP_DELETE" "3" "March 10, 2009" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_delete\fR
\- delete file from zip archive
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIint\fR
.br
\fBzip_delete\fR(\fIstruct zip *archive\fR,\ \fIzip_uint64_t index\fR);
.SH "DESCRIPTION"
The file at position
\fIindex\fR
in the zip archive
\fIarchive\fR
is marked as deleted.
.SH "RETURN VALUES"
Upon successful completion 0 is returned.
Otherwise, \-1 is returned and the error code in
\fIarchive\fR
is set to indicate the error.
.SH "ERRORS"
\fBzip_delete\fR()
fails if:
.TP 19n
[\fRZIP_ER_INVAL\fR]
\fIindex\fR
is not a valid file index in
\fIarchive\fR.
.SH "SEE ALSO"
libzip(3),
zip_unchange(3)
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
