/***************************************************************************

  GL.c

  (c) 2005-2007 Laurent Carlier <lordheavy@users.sourceforge.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
  MA 02110-1301, USA.

***************************************************************************/

#define __GL_C

#include "GL.h"

#include "GLclipping.h"
#include "GLcolorLighting.h"
#include "GLcoordTransf.h"
#include "GLdisplayList.h"
#include "GLfog.h"
#include "GLframeBufferOps.h"
#include "GLmodesExec.h"
#include "GLpixelOperations.h"
#include "GLprimitives.h"
#include "GLrasterization.h"
#include "GLtextureMapping.h"
#include "GLinfo.h"
#include "GLselectFeedback.h"
#include "GLeval.h"
#include "framebufferobject.h"

#define MAX_COMPAT_WARNING 16

/**************************************************************************/

BEGIN_METHOD_VOID(GLCHECKERROR)

	GB.ReturnInteger(glGetError());

END_METHOD

BEGIN_METHOD(GLCHECKEXTENSIONS, GB_STRING extlist)

	GB.ReturnBoolean(glewIsSupported(GB.ToZeroString(ARG(extlist))));

END_METHOD


BEGIN_METHOD_VOID(GL_property)

	GB.ReturnBoolean(TRUE);

END_METHOD

BEGIN_METHOD_VOID(GL_unknown)

	static int nwarn = 0;
	static void *klass = NULL;
	static const char *same_name[] = { "VIEWPORT", "ACCUM", "CLEAR", NULL};
	static const int same_value[] = { GL_VIEWPORT, GL_ACCUM, GL_CLEAR };
	
	char *name = GB.GetUnknown();
	const char **p;
	bool add_underscore;
	int same_index;
	
	if (strncasecmp(name, "GL_", 3))
	{
		GB.Error(GB_ERR_NSYMBOL, "Gl", name);
		return;
	}
	
	if (GB.NParam())
	{
		GB.Error(GB_ERR_NPROPERTY, "Gl", name);
		return;
	}
	
	name += 3;
	
	add_underscore = FALSE;
	same_index = 0;
	for (p = same_name; *p; p++, same_index++)
	{
		if (!strcasecmp(*p, name))
		{
			add_underscore = TRUE;
			break;
		}
	}
	
	nwarn++;
	if (nwarn <= MAX_COMPAT_WARNING)
		fprintf(stderr, "gb.opengl: warning: Gl.GL_%s constant is deprecated. Use Gl.%s%s now.\n", name, name, add_underscore ? "_" : "");
	else if (nwarn == (MAX_COMPAT_WARNING + 1))
		fprintf(stderr, "gb.opengl: warning: too many deprecated constant warnings.\n");
	
	if (!klass)
		klass = (void *)GB.FindClass("Gl");

	if (add_underscore)
		GB.ReturnInteger(same_value[same_index]);
	else 
		GB.GetProperty(klass, name);
	
	GB.ReturnConvVariant();

END_METHOD

/**************************************************************************/

GB_DESC Cgl[] =
{
	GB_DECLARE("Gl",0), GB_NOT_CREATABLE(),
	
	/* Check errors */
	GB_STATIC_METHOD("GetError", "i", GLCHECKERROR, NULL),
	/* Check an extension or a driver ability */
	GB_STATIC_METHOD("CheckExtensions", "b", GLCHECKEXTENSIONS, "(Extensions)s"),

	/* Primitives - see GLprimitives.h */
	GB_STATIC_METHOD("Begin", NULL, GLBEGIN, "(Primitive)i"),
	GB_STATIC_METHOD("EdgeFlag", NULL, GLEDGEFLAG, "(Flag)b"),
	GB_STATIC_METHOD("End", NULL, GLEND, NULL),
	GB_STATIC_METHOD("Rectf", NULL, GLRECTF, "(X1)f(Y1)f(X2)f(Y2)f"),
	GB_STATIC_METHOD("Recti", NULL, GLRECTI, "(X1)i(Y1)i(X2)i(Y2)i"),
	GB_STATIC_METHOD("Vertex2f", NULL, GLVERTEX2F, "(X)f(Y)f"),
	GB_STATIC_METHOD("Vertex3f", NULL, GLVERTEX3F, "(X)f(Y)f(Z)f"),
	GB_STATIC_METHOD("Vertex4f", NULL, GLVERTEXF, "(X)f(Y)f(Z)f(W)f"),
	GB_STATIC_METHOD("Vertexf", NULL, GLVERTEXF, "(X)f(Y)f[(Z)f(W)f]"),
	GB_STATIC_METHOD("Vertex2i", NULL, GLVERTEX2I, "(X)i(Y)i"),
	GB_STATIC_METHOD("Vertex3i", NULL, GLVERTEX3I, "(X)i(Y)i(Z)i"),
	GB_STATIC_METHOD("Vertex4i", NULL, GLVERTEXI, "(X)i(Y)i(Z)i(W)i"),
	GB_STATIC_METHOD("Vertexi", NULL, GLVERTEXI, "(X)i(Y)i[(Z)i(W)i]"),
	GB_STATIC_METHOD("Vertexfv", NULL, GLVERTEXFV, "(Coords)Float[]"),
	GB_STATIC_METHOD("Vertexiv", NULL, GLVERTEXIV, "(Coords)Integer[]"),

	/* Display lists - see GLdisplayList.h */
	GB_STATIC_METHOD("CallList", NULL, GLCALLLIST, "(Index)i"),
	GB_STATIC_METHOD("CallLists", NULL, GLCALLLISTS, "(Lists)Integer[]"),
	GB_STATIC_METHOD("DeleteLists", NULL, GLDELETELISTS, "(Index)i(Range)i"),
	GB_STATIC_METHOD("EndList", NULL, GLENDLIST, NULL),
	GB_STATIC_METHOD("GenLists", "i", GLGENLISTS, "(Count)i"),
	GB_STATIC_METHOD("IsList", "b", GLISLIST, "(Index)i"),
	GB_STATIC_METHOD("ListBase", NULL, GLLISTBASE, "(Index)i"),
	GB_STATIC_METHOD("NewList", NULL, GLNEWLIST, "(Index)i(Mode)i"),

	/* Coordinate Transformation - see GLcoordTransf.h */
	GB_STATIC_METHOD("DepthRange", NULL, GLDEPTHRANGE, "(Near)f(Far)f"),
	GB_STATIC_METHOD("Frustum", NULL, GLFRUSTUM, "(Left)f(Right)f(Bottom)f(Top)f(Near)f(Far)f"),
	GB_STATIC_METHOD("LoadIdentity", NULL, GLLOADIDENTITY, NULL),
	GB_STATIC_METHOD("LoadMatrixf", NULL, GLLOADMATRIXF, "(Matrix)Float[]"),
	GB_STATIC_METHOD("MatrixMode", NULL, GLMATRIXMODE, "(Mode)i"),
	GB_STATIC_METHOD("MultMatrixf", NULL, GLMULTMATRIXF, "(Matrix)Float[]"),
	GB_STATIC_METHOD("Ortho", NULL, GLORTHO, "(Left)f(Right)f(Bottom)f(Top)f(Near)f(Far)f"),
	GB_STATIC_METHOD("PopMatrix", NULL, GLPOPMATRIX, NULL),
	GB_STATIC_METHOD("PushMatrix", NULL, GLPUSHMATRIX, NULL),
	GB_STATIC_METHOD("Rotatef", NULL, GLROTATEF, "(Angle)f(X)f(Y)f(Z)f"),
	GB_STATIC_METHOD("Scalef", NULL, GLSCALEF, "(X)f(Y)f(Z)f"),
	GB_STATIC_METHOD("Translatef", NULL, GLTRANSLATEF, "(X)f(Y)f(Z)f"),
	GB_STATIC_METHOD("Viewport", NULL, GLVIEWPORT, "(X)i(Y)i(Width)i(Height)i"),

	/* Coloring and Lighting - see GLcolorLighting.h */
	GB_STATIC_METHOD("Color3f", NULL, GLCOLOR3F, "(Red)f(Green)f(Blue)f"),
	GB_STATIC_METHOD("Color4f", NULL, GLCOLORF, "(Red)f(Green)f(Blue)f(Alpha)f"),
	GB_STATIC_METHOD("Colorf", NULL, GLCOLORF, "(Red)f(Green)f(Blue)f[(Alpha)f]"),
	GB_STATIC_METHOD("Color3i", NULL, GLCOLOR3I, "(Red)i(Green)i(Blue)i"),
	GB_STATIC_METHOD("Color4i", NULL, GLCOLORI, "(Red)i(Green)i(Blue)i(Alpha)i"),
	GB_STATIC_METHOD("Colori", NULL, GLCOLORI, "(Red)i(Green)i(Blue)i[(Alpha)i]"),
	GB_STATIC_METHOD("Colorfv", NULL, GLCOLORFV, "(Colors)Float[]"),
	GB_STATIC_METHOD("Coloriv", NULL, GLCOLORIV, "(Colors)Integer[]"),
	GB_STATIC_METHOD("ColorMaterial", NULL, GLCOLORMATERIAL, "(Face)i(Mode)i"),
	GB_STATIC_METHOD("FrontFace", NULL, GLFRONTFACE, "(Mode)i"),
	GB_STATIC_METHOD("GetLightfv", "Float[]", GLGETLIGHTFV, "(Light)i(Pname)i"),
	GB_STATIC_METHOD("GetLightiv", "Integer[]", GLGETLIGHTIV, "(Light)i(Pname)i"),
	GB_STATIC_METHOD("GetMaterialfv", "Float[]", GLGETMATERIALFV, "(Face)i(Pname)i"),
	GB_STATIC_METHOD("GetMaterialiv", "Integer[]", GLGETMATERIALIV, "(Face)i(Pname)i"),
	GB_STATIC_METHOD("Indexf", NULL, GLINDEXF, "(Index)f"),
	GB_STATIC_METHOD("Indexi", NULL, GLINDEXI, "(Index)i"),
	GB_STATIC_METHOD("Lightf", NULL, GLLIGHTF, "(Light)i(Pname)i(Param)f"),
	GB_STATIC_METHOD("Lighti", NULL, GLLIGHTI, "(Light)i(Pname)i(Param)i"),
	GB_STATIC_METHOD("Lightfv", NULL, GLLIGHTFV, "(Light)i(Pname)i(Params)Float[]"),
	GB_STATIC_METHOD("Lightiv", NULL, GLLIGHTIV, "(Light)i(Pname)i(Params)Integer[]"),
	GB_STATIC_METHOD("LightModelf", NULL, GLLIGHTMODELF, "(Pname)i(Param)f"),
	GB_STATIC_METHOD("LightModeli", NULL, GLLIGHTMODELI, "(Pname)i(Param)i"),
	GB_STATIC_METHOD("LightModelfv", NULL, GLLIGHTMODELFV, "(Pname)i(Params)Float[]"),
	GB_STATIC_METHOD("LightModeliv", NULL, GLLIGHTMODELIV, "(Pname)i(Params)Integer[]"),
	GB_STATIC_METHOD("Materialf", NULL, GLMATERIALF, "(Face)i(Pname)i(Param)f"),
	GB_STATIC_METHOD("Materiali", NULL, GLMATERIALI, "(Face)i(Pname)i(Param)i"),
	GB_STATIC_METHOD("Materialfv", NULL, GLMATERIALFV, "(Face)i(Pname)i(Params)Float[]"),
	GB_STATIC_METHOD("Materialiv", NULL, GLMATERIALIV, "(Face)i(Pname)i(Params)Integer[]"),
	GB_STATIC_METHOD("Normal3f", NULL, GLNORMAL3F, "(Nx)f(Ny)f(Nz)f"),
	GB_STATIC_METHOD("Normal3i", NULL, GLNORMAL3I, "(Nx)i(Ny)i(Nz)i"),
	GB_STATIC_METHOD("Normal3fv", NULL, GLNORMAL3FV, "(Params)Float[]"),
	GB_STATIC_METHOD("Normal3iv", NULL, GLNORMAL3IV, "(Params)Integer[]"),
	GB_STATIC_METHOD("ShadeModel", NULL, GLSHADEMODEL, "(Model)i"),

	/* Clipping - see GLclipping.h */
	GB_STATIC_METHOD("ClipPlane", NULL, GLCLIPPLANE, "(Plane)i(Equation)Float[]"),
	GB_STATIC_METHOD("GetClipPlane", "Float[]", GLGETCLIPPLANE, "(Plane)i"),

	/* Rasterization - see GLrasterization.h  */
	//GB_STATIC_METHOD("Bitmap", NULL, GLBITMAP, NULL), //TODO
	GB_STATIC_METHOD("CullFace", NULL, GLCULLFACE, "(Mode)i"),
	//GB_STATIC_METHOD("GetPolygonStipple", "i", GLPOLYGONSTIPPLE, NULL), //TODO
	GB_STATIC_METHOD("LineStipple", NULL, GLLINESTIPPLE, "(Factor)i(Pattern)i"),
	GB_STATIC_METHOD("LineWidth", NULL, GLLINEWIDTH, "(Width)f"),
	GB_STATIC_METHOD("PointSize", NULL, GLPOINTSIZE, "(Size)f"),
	GB_STATIC_METHOD("PolygonMode", NULL, GLPOLYGONMODE, "(Face)i(Mode)i"),
	GB_STATIC_METHOD("PolygonOffset", NULL, GLPOLYGONOFFSET, "(Factor)f(Units)f"),
	//GB_STATIC_METHOD("PolygonStipple", NULL, GLPOLYGONSTIPPLE, "(Mask)i"), //TODO
	GB_STATIC_METHOD("RasterPos2f", NULL, GLRASTERPOS2F, "(X)f(Y)f"),
	GB_STATIC_METHOD("RasterPos3f", NULL, GLRASTERPOS3F, "(X)f(Y)f(Z)f"),
	GB_STATIC_METHOD("RasterPos4f", NULL, GLRASTERPOSF, "(X)f(Y)f(Z)f(W)f"),
	GB_STATIC_METHOD("RasterPosf", NULL, GLRASTERPOSF, "(X)f(Y)f[(Z)f(W)f]"),
	GB_STATIC_METHOD("RasterPos2i", NULL, GLRASTERPOS2I, "(X)i(Y)i"),
	GB_STATIC_METHOD("RasterPos3i", NULL, GLRASTERPOS3I, "(X)i(Y)i(Z)i"),
	GB_STATIC_METHOD("RasterPos4i", NULL, GLRASTERPOSI, "(X)i(Y)i(Z)i(W)i"),
	GB_STATIC_METHOD("RasterPosi", NULL, GLRASTERPOSI, "(X)i(Y)i[(Z)i(W)i]"),
	GB_STATIC_METHOD("RasterPosfv", NULL, GLRASTERPOSFV, "(Coords)Float[]"),
	GB_STATIC_METHOD("RasterPosiv", NULL, GLRASTERPOSIV, "(Coords)Integer[]"),
	
	/* PixelOperations - see GLpixelOperations.h  */
	// TODO glReadPixels
	GB_STATIC_METHOD("CopyPixels", NULL, GLCOPYPIXELS, "(X)i(Y)i(Width)i(Height)i(Buffer)i"),
	GB_STATIC_METHOD("PixelStoref", NULL, GLPIXELSTOREF, "(Pname)i(Param)f"),
	GB_STATIC_METHOD("PixelStorei", NULL, GLPIXELSTOREI, "(Pname)i(Param)i"),
	GB_STATIC_METHOD("PixelTransferf", NULL, GLPIXELTRANSFERF, "(Pname)i(Param)f"),
	GB_STATIC_METHOD("PixelTransferi", NULL, GLPIXELTRANSFERI, "(Pname)i(Param)i"),
	GB_STATIC_METHOD("ReadBuffer", NULL, GLREADBUFFER, "(Mode)i"),
	GB_STATIC_METHOD("DrawPixels", NULL, GLDRAWPIXELS, "(Image)Image;"),

	/* Modes and Execution - see GLmodesExec.h */
	GB_STATIC_METHOD("Disable", NULL, GLDISABLE, "(Capacity)i"),
	GB_STATIC_METHOD("Enable", NULL, GLENABLE, "(Capacity)i"),
	GB_STATIC_METHOD("Flush", NULL, GLFLUSH, NULL),
	GB_STATIC_METHOD("Finish", NULL, GLFINISH, NULL),
	GB_STATIC_METHOD("Hint", NULL, GLHINT, "(Target)i(Mode)i"),
	GB_STATIC_METHOD("IsEnabled", "b", GLISENABLED, "(Capacity)i"),

	/* Fog - see GLfog.h */
	GB_STATIC_METHOD("Fogf", NULL, GLFOGF, "(Pname)i(Param)f"),
	GB_STATIC_METHOD("Fogi", NULL, GLFOGI, "(Pname)i(Param)i"),
	GB_STATIC_METHOD("Fogfv", NULL, GLFOGFV, "(Pname)i(Params)Float[]"),
	GB_STATIC_METHOD("Fogiv", NULL, GLFOGIV, "(Pname)i(Params)Integer[]"),

	/* Texture Mapping - see GLtextureMapping.h */
	GB_STATIC_METHOD("BindTexture", NULL, GLBINDTEXTURE, "(Target)i(Texture)i"),
	GB_STATIC_METHOD("ActiveTexture", NULL, GLACTIVETEXTURE, "(Texture)i" ),
	// TODO adapt to gambas
	GB_STATIC_METHOD("CopyTexImage1D", NULL, GLCOPYTEXIMAGE1D, "(Target)i(Level)i(Format)i(X)i(Y)i(Width)i(Border)i"),
	GB_STATIC_METHOD("CopyTexImage2D", NULL, GLCOPYTEXIMAGE2D, "(Target)i(Level)i(Format)i(X)i(Y)i(Width)i(Height)i(Border)i"),
	GB_STATIC_METHOD("DeleteTextures", NULL, GLDELETETEXTURES, "(Textures)Integer[]"),
	GB_STATIC_METHOD("GenTextures", "Integer[]", GLGENTEXTURES, "(Count)i"),
	GB_STATIC_METHOD("IsTexture", "b", GLISTEXTURE, "(Texture)i"),
	GB_STATIC_METHOD("TexCoord1f", NULL, GLTEXCOORD1F, "(S)f"),
	GB_STATIC_METHOD("TexCoord2f", NULL, GLTEXCOORD2F, "(S)f(T)f"),
	GB_STATIC_METHOD("TexCoord3f", NULL, GLTEXCOORD3F, "(S)f(T)f(R)f"),
	GB_STATIC_METHOD("TexCoord4f", NULL, GLTEXCOORDF, "(S)f(T)f(R)f(Q)f"),
	GB_STATIC_METHOD("TexCoordf", NULL, GLTEXCOORDF, "(S)f[(T)f(R)f(Q)f]"),
	GB_STATIC_METHOD("TexCoord1i", NULL, GLTEXCOORD1I, "(S)i"),
	GB_STATIC_METHOD("TexCoord2i", NULL, GLTEXCOORD2I, "(S)i(T)i"),
	GB_STATIC_METHOD("TexCoord3i", NULL, GLTEXCOORD3I, "(S)i(T)i(R)i"),
	GB_STATIC_METHOD("TexCoord4i", NULL, GLTEXCOORDI, "(S)i(T)i(R)i(Q)i"),
	GB_STATIC_METHOD("TexCoordi", NULL, GLTEXCOORDI, "(S)i[(T)i(R)i(Q)i]"),
	GB_STATIC_METHOD("TexEnvf", NULL, GLTEXENVF, "(Target)i(Pname)i(Param)f"),
	GB_STATIC_METHOD("TexEnvfv", NULL, GLTEXENVFV, "(Target)i(Pname)i(Params)Float[]"),
	GB_STATIC_METHOD("TexEnvi", NULL, GLTEXENVI, "(Target)i(Pname)i(Param)i"),
	GB_STATIC_METHOD("TexEnviv", NULL, GLTEXENVIV, "(Target)i(Pname)i(Params)Integer[]"),
	GB_STATIC_METHOD("TexImage1D", NULL, GLTEXIMAGE1D, "(Image)Image;[(Level)i(Border)i]"),
	GB_STATIC_METHOD("TexImage2D", NULL, GLTEXIMAGE2D,"(Image)Image;[(Level)i(Border)i]"),
	GB_STATIC_METHOD("TexSubImage1D", NULL, GLTEXSUBIMAGE2D,"(Image)Image;(XOffset)i(Width)i[(Level)i]"),
	GB_STATIC_METHOD("TexSubImage2D", NULL, GLTEXSUBIMAGE2D,"(Image)Image;(XOffset)i(YOffset)i(Width)i(Height)i[(Level)i]"),
	GB_STATIC_METHOD("TexParameterf", NULL, GLTEXPARAMETERF, "(Target)i(Pname)i(Param)f"),
	GB_STATIC_METHOD("TexParameterfv", NULL, GLTEXPARAMETERFV, "(Target)i(Pname)i(Params)Float[]"),
	GB_STATIC_METHOD("TexParameteri", NULL, GLTEXPARAMETERI, "(Target)i(Pname)i(Param)i"),
	GB_STATIC_METHOD("TexParameteriv", NULL, GLTEXPARAMETERIV, "(Target)i(Pname)i(Params)Integer[]"),
	GB_STATIC_METHOD("TexGeni", NULL, GLTEXGENI, "(Coord)i(Pname)i(Param)i"),
	GB_STATIC_METHOD("MultiTexCoord2f", NULL, GLMULTITEXCOORD2F, "(Target)i(S)f(T)f"),

	/* FrameBuffer Operations - see GLframeBufferOps.h  */
	GB_STATIC_METHOD("Accum", NULL, GLACCUM, "(Operation)i(Value)f"),
	GB_STATIC_METHOD("AlphaFunc", NULL, GLALPHAFUNC, "(Function)i(Reference)f"),
	GB_STATIC_METHOD("BlendFunc", NULL, GLBLENDFUNC, "(SrcFactor)i(DstFactor)i"),
	GB_STATIC_METHOD("Clear", NULL, GLCLEAR, "(Mask)i"),
	GB_STATIC_METHOD("ClearAccum", NULL, GLCLEARACCUM, "(Red)f(Green)f(Blue)f(Alpha)f"),
	GB_STATIC_METHOD("ClearColor", NULL, GLCLEARCOLOR, "(Red)f(Green)f(Blue)f(Alpha)f"),
	GB_STATIC_METHOD("ClearDepth", NULL, GLCLEARDEPTH, "(Depth)f"),
	GB_STATIC_METHOD("ClearIndex", NULL, GLCLEARINDEX, "(Value)f"),
	GB_STATIC_METHOD("ClearStencil", NULL, GLCLEARSTENCIL, "(Value)i"),
	GB_STATIC_METHOD("ColorMask", NULL, GLCOLORMASK, "(Red)b(Green)b(Blue)b(Alpha)b"),
	GB_STATIC_METHOD("DrawBuffer", NULL, GLDRAWBUFFER, "(Mode)i"),
	GB_STATIC_METHOD("DepthFunc", NULL, GLDEPTHFUNC, "(Function)i"),
	GB_STATIC_METHOD("DepthMask", NULL, GLDEPTHMASK, "(Flag)b"),
	GB_STATIC_METHOD("IndexMask", NULL, GLINDEXMASK, "(Mask)i"),
	GB_STATIC_METHOD("LogicOp", NULL, GLLOGICOP, "(Opcode)i"),
	GB_STATIC_METHOD("Scissor", NULL, GLSCISSOR, "(X)i(Y)i(Width)i(Height)i"),
	GB_STATIC_METHOD("StencilFunc", NULL, GLSTENCILFUNC, "(Function)i(Reference)i(Mask)i"),
	GB_STATIC_METHOD("StencilMask", NULL, GLSTENCILMASK, "(Mask)i"),
	GB_STATIC_METHOD("StencilOp", NULL, GLSTENCILOP, "(Fail)i(Zfail)i(Zpass)i"),

	/* Selection and Feedback - see GLselectPixmap.h  */
	GB_STATIC_METHOD("FeedbackBuffer", NULL, GLFEEDBACKBUFFER, "(Type)i"),
	GB_STATIC_METHOD("InitNames", NULL, GLINITNAMES, NULL),
	GB_STATIC_METHOD("LoadName", NULL, GLLOADNAME, "(Name)i"),
	GB_STATIC_METHOD("PassThrough", NULL, GLPASSTHROUGH, "(Token)f"),
	GB_STATIC_METHOD("PopName", NULL, GLPOPNAME, NULL),
	GB_STATIC_METHOD("PushName", NULL, GLPUSHNAME, "(Name)i"),
	GB_STATIC_METHOD("RenderMode", "Array", GLRENDERMODE, "(Mode)i"),
	GB_STATIC_METHOD("SelectBuffer", NULL, GLSELECTBUFFER, NULL),

	/* Evaluators - see Gleval.h/c	*/
	GB_STATIC_METHOD("Map1f", NULL, GLMAP1F, "(Target)i(U1)f(U2)f(Stride)i(Order)i(Points)Float[]"),
	GB_STATIC_METHOD("Map2f", NULL, GLMAP2F, "(Target)i(U1)f(U2)f(Ustride)i(Uorder)i(V1)f(V2)f(Vstride)i(Vorder)i(Points)Float[]"),	
	GB_STATIC_METHOD("EvalCoord1f", NULL, GLEVALCOORD1F, "(U)f"),
	GB_STATIC_METHOD("EvalCoord2f", NULL, GLEVALCOORD2F, "(U)f(V)f"),
	GB_STATIC_METHOD("EvalCoord2fv", NULL, GLEVALCOORD2FV, "(Coords)Float[]"),
	GB_STATIC_METHOD("MapGrid1f", NULL, GLMAPGRID1F, "(Un)i(U)f(V)f"),	
	GB_STATIC_METHOD("MapGrid2f", NULL, GLMAPGRID2F, "(Un)i(U1)f(U2)f(Vn)i(V1)f(V2)f"),	
	GB_STATIC_METHOD("EvalPoint1", NULL, GLEVALPOINT1, "(I)i"),	
	GB_STATIC_METHOD("EvalPoint2", NULL, GLEVALPOINT2, "(I)i(J)i"),	
	GB_STATIC_METHOD("EvalMesh1", NULL, GLEVALMESH1, "(Mode)i(I1)i(I2)i"),
	GB_STATIC_METHOD("EvalMesh2", NULL, GLEVALMESH2, "(Mode)i(I1)i(I2)i(J1)i(J2)i"),		

	/* glGetxxxx calls - see GLinfo.h/c   */
	GB_STATIC_METHOD("GetBooleanv", "Boolean[]", GLGETBOOLEANV, "(Parameter)i"),
	GB_STATIC_METHOD("GetFloatv", "Float[]", GLGETFLOATV, "(Parameter)i"),
	GB_STATIC_METHOD("GetIntegerv", "Integer[]", GLGETINTEGERV, "(Parameter)i]"),
	GB_STATIC_METHOD("GetString", "s", GLGETSTRING, "(Name)i"),

	/*********************/
	/* Opengl Extensions */
	/*********************/
	/* See http://www.opengl.org/registry/ */
	
	/* ARB extensions */
	
	/* 38; GL_ARB_texture_rectangle */
	/* Only constants */
	
	/* EXT and Vendors extensions */
	
	/* 310; GL_EXT_framebuffer_object */
	/* framebufferobject.c */
	GB_STATIC_METHOD("BindFramebufferEXT", NULL, GLBINDFRAMEBUFFEREXT, "(Target)i(Framebuffer)i"),
	GB_STATIC_METHOD("BindRenderbufferEXT",NULL, GLBINDRENDERBUFFEREXT, "(Target)i(Renderbuffer)i"),
	GB_STATIC_METHOD("CheckFramebufferStatusEXT", "i", GLCHECKFRAMEBUFFERSTATUSEXT, "(Target)i"),
	GB_STATIC_METHOD("DeleteFramebuffersEXT", NULL, GLDELETEFRAMEBUFFERSEXT, "(Framebuffers)Integer[]"),
	GB_STATIC_METHOD("DeleteRenderbuffersEXT", NULL, GLDELETERENDERBUFFERSEXT, "(Renderbuffers)Integer[]"),
	GB_STATIC_METHOD("FramebufferRenderbufferEXT", NULL, GLFRAMEBUFFERRENDERBUFFEREXT, "(Target)i(Attachment)i(RenderbufferTarget)i(Renderbuffer)i"),
	GB_STATIC_METHOD("FramebufferTexture1DEXT", NULL, GLFRAMEBUFFERTEXTURE1DEXT, "(Target)i(Attachment)i(TexTarget)i(Texture)i(Level)i"),
	GB_STATIC_METHOD("FramebufferTexture2DEXT", NULL, GLFRAMEBUFFERTEXTURE2DEXT, "(Target)i(Attachment)i(TexTarget)i(Texture)i(Level)i"),
	GB_STATIC_METHOD("FramebufferTexture3DEXT", NULL, GLFRAMEBUFFERTEXTURE3DEXT, "(Target)i(Attachment)i(TexTarget)i(Texture)i(Level)i(Zoffset)i"),
	GB_STATIC_METHOD("GenerateMipmapEXT", NULL, GLGENERATEMIPMAPEXT, "(Target)i"),
	GB_STATIC_METHOD("GenFramebuffersEXT", "Integer[]", GLGENFRAMEBUFFERSEXT, "(Count)i"),
	GB_STATIC_METHOD("GenRenderbuffersEXT", "Integer[]", GLGENRENDERBUFFERSEXT, "(Count)i"),
	GB_STATIC_METHOD("GetFramebufferAttachmentParameterivEXT", "Integer[]", GLGETFRAMEBUFFERATTACHMENTPARAMETERIVEXT, "(Target)i(Attachment)i(Pname)i"),
	GB_STATIC_METHOD("GetRenderbufferParameterivEXT", "Integer[]", GLGETRENDERBUFFERPARAMETERIVEXT, "(Target)i(Pname)i"),
	GB_STATIC_METHOD("IsFramebufferEXT", "b", GLISFRAMEBUFFEREXT, "(Framebuffer)i"),
	GB_STATIC_METHOD("IsRenderbufferEXT", "b", GLISRENDERBUFFEREXT, "(Renderbuffer)i"),
	GB_STATIC_METHOD("RenderbufferStorageEXT", NULL, GLRENDERBUFFERSTORAGEEXT, "(Target)i(InternalFormat)i(Width)i(Height)i"),

	// Old constant naming support
	GB_STATIC_METHOD("_unknown", "v", GL_unknown, "."),
	GB_STATIC_METHOD("_property", "b", GL_property, NULL),

	/********************/
	/* opengl constants */
	/********************/
	
		GB_CONSTANT("FLOAT" , "i", GL_FLOAT),
	GB_CONSTANT("INTEGER" , "i", GL_FLOAT),
	GB_CONSTANT("UNSIGNED_BYTE", "i", GL_UNSIGNED_BYTE),
	GB_CONSTANT("UNSIGNED_INT", "i", GL_UNSIGNED_INT),
	GB_CONSTANT("DOUBLE", "i", GL_DOUBLE),

	/* GetString */
	GB_CONSTANT("EXTENSIONS", "i", GL_EXTENSIONS),
	GB_CONSTANT("VENDOR", "i", GL_VENDOR),
	GB_CONSTANT("RENDERER", "i", GL_RENDERER),
	GB_CONSTANT("VERSION", "i", GL_VERSION),
	GB_CONSTANT("SHADING_LANGUAGE_VERSION", "i", GL_SHADING_LANGUAGE_VERSION),

	/* Primitives */
	GB_CONSTANT("POINTS", "i", GL_POINTS),
	GB_CONSTANT("LINES", "i", GL_LINES),
	GB_CONSTANT("LINE_LOOP", "i", GL_LINE_LOOP),
	GB_CONSTANT("LINE_STRIP", "i", GL_LINE_STRIP),
	GB_CONSTANT("TRIANGLES", "i", GL_TRIANGLES),
	GB_CONSTANT("TRIANGLE_STRIP", "i", GL_TRIANGLE_STRIP),
	GB_CONSTANT("TRIANGLE_FAN", "i", GL_TRIANGLE_FAN),
	GB_CONSTANT("QUADS", "i", GL_QUADS),
	GB_CONSTANT("QUAD_STRIP", "i", GL_QUAD_STRIP),
	GB_CONSTANT("POLYGON", "i", GL_POLYGON),
	GB_CONSTANT("VERTEX_ARRAY", "i", GL_VERTEX_ARRAY),
  	GB_CONSTANT("COLOR_ARRAY", "i", GL_COLOR_ARRAY),
	GB_CONSTANT("NORMAL_ARRAY", "i", GL_NORMAL_ARRAY),
	GB_CONSTANT("TEXTURE_COORD_ARRAY", "i", GL_TEXTURE_COORD_ARRAY),

	/* Matrix Mode */
	GB_CONSTANT("MATRIX_MODE", "i", GL_MATRIX_MODE),
	GB_CONSTANT("MODELVIEW", "i", GL_MODELVIEW),
	GB_CONSTANT("PROJECTION", "i", GL_PROJECTION),
	GB_CONSTANT("TEXTURE", "i", GL_TEXTURE),
	
	/* Points */
	GB_CONSTANT("POINT_SMOOTH", "i", GL_POINT_SMOOTH),
	GB_CONSTANT("POINT_SIZE", "i", GL_POINT_SIZE),
	GB_CONSTANT("SMOOTH_POINT_SIZE_GRANULARITY", "i", GL_SMOOTH_POINT_SIZE_GRANULARITY),
	GB_CONSTANT("SMOOTH_POINT_SIZE_RANGE", "i", GL_SMOOTH_POINT_SIZE_RANGE),

	/* Display Lists */
	GB_CONSTANT("COMPILE", "i", GL_COMPILE),
	GB_CONSTANT("COMPILE_AND_EXECUTE", "i", GL_COMPILE_AND_EXECUTE),
	GB_CONSTANT("LIST_BASE", "i", GL_LIST_BASE),
	GB_CONSTANT("LIST_INDEX", "i", GL_LIST_INDEX),
	GB_CONSTANT("LIST_MODE" ,"i", GL_LIST_MODE),

	/* Accumulation buffer */
	GB_CONSTANT("ACCUM_", "i", GL_ACCUM),
	GB_CONSTANT("ACCUM_ALPHA_BITS", "i", GL_ACCUM_ALPHA_BITS),
	GB_CONSTANT("ACCUM_CLEAR_VALUE", "i", GL_ACCUM_CLEAR_VALUE),
	GB_CONSTANT("ACCUM_BLUE_BITS", "i", GL_ACCUM_BLUE_BITS),
	GB_CONSTANT("ACCUM_GREEN_BITS", "i", GL_ACCUM_GREEN_BITS),
	GB_CONSTANT("ACCUM_RED_BITS", "i", GL_ACCUM_RED_BITS),
	GB_CONSTANT("ADD", "i", GL_ADD),
	GB_CONSTANT("LOAD", "i", GL_LOAD),
	GB_CONSTANT("MULT", "i", GL_MULT),
	GB_CONSTANT("RETURN", "i", GL_RETURN),

	/* User clipping planes */
	GB_CONSTANT("CLIP_PLANE0", "i", GL_CLIP_PLANE0),
	GB_CONSTANT("CLIP_PLANE1", "i", GL_CLIP_PLANE1),
	GB_CONSTANT("CLIP_PLANE2", "i", GL_CLIP_PLANE2),
	GB_CONSTANT("CLIP_PLANE3", "i", GL_CLIP_PLANE3),
	GB_CONSTANT("CLIP_PLANE4", "i", GL_CLIP_PLANE4),
	GB_CONSTANT("CLIP_PLANE5", "i", GL_CLIP_PLANE5),

	/* Alpha testing */
	GB_CONSTANT("ALPHA_TEST", "i", GL_ALPHA_TEST),
	GB_CONSTANT("ALPHA_TEST_REF", "i", GL_ALPHA_TEST_REF),
	GB_CONSTANT("ALPHA_TEST_FUNC", "i", GL_ALPHA_TEST_FUNC),

	/* glPush/PopAttrib bits */
	GB_CONSTANT("ACCUM_BUFFER_BIT", "i", GL_ACCUM_BUFFER_BIT),
	GB_CONSTANT("ALL_ATTRIB_BITS", "i", GL_ALL_ATTRIB_BITS),
	GB_CONSTANT("CURRENT_BIT", "i", GL_CURRENT_BIT),
	GB_CONSTANT("COLOR_BUFFER_BIT", "i", GL_COLOR_BUFFER_BIT),
	GB_CONSTANT("DEPTH_BUFFER_BIT", "i", GL_DEPTH_BUFFER_BIT),
	GB_CONSTANT("ENABLE_BIT", "i", GL_ENABLE_BIT),
	GB_CONSTANT("EVAL_BIT", "i", GL_EVAL_BIT),
	GB_CONSTANT("FOG_BIT", "i", GL_FOG_BIT),
	GB_CONSTANT("HINT_BIT", "i", GL_HINT_BIT),
	GB_CONSTANT("LIGHTING_BIT", "i", GL_LIGHTING_BIT),
	GB_CONSTANT("LINE_BIT", "i", GL_LINE_BIT),
	GB_CONSTANT("LIST_BIT", "i", GL_LIST_BIT),
	GB_CONSTANT("PIXEL_MODE_BIT", "i", GL_PIXEL_MODE_BIT),
	GB_CONSTANT("POINT_BIT", "i", GL_POINT_BIT),
	GB_CONSTANT("POLYGON_BIT", "i", GL_POLYGON_BIT),
	GB_CONSTANT("POLYGON_STIPPLE_BIT", "i", GL_POLYGON_STIPPLE_BIT),
	GB_CONSTANT("SCISSOR_BIT", "i", GL_SCISSOR_BIT),
	GB_CONSTANT("STENCIL_BUFFER_BIT", "i", GL_STENCIL_BUFFER_BIT),
	GB_CONSTANT("TEXTURE_BIT", "i", GL_TEXTURE_BIT),
	GB_CONSTANT("TRANSFORM_BIT", "i", GL_TRANSFORM_BIT),
	GB_CONSTANT("VIEWPORT_BIT", "i", GL_VIEWPORT_BIT),

	/* Polygons */
	GB_CONSTANT("POINT", "i", GL_POINT),
	GB_CONSTANT("LINE", "i", GL_LINE),
	GB_CONSTANT("FILL", "i", GL_FILL),
	GB_CONSTANT("CW", "i", GL_CW),
	GB_CONSTANT("CCW", "i", GL_CCW),
	GB_CONSTANT("FRONT", "i", GL_FRONT),
	GB_CONSTANT("BACK", "i", GL_BACK),
	GB_CONSTANT("POLYGON_MODE", "i", GL_POLYGON_MODE),
	GB_CONSTANT("POLYGON_SMOOTH", "i", GL_POLYGON_SMOOTH),
	GB_CONSTANT("POLYGON_STIPPLE", "i", GL_POLYGON_STIPPLE),
	GB_CONSTANT("EDGE_FLAG", "i", GL_EDGE_FLAG),
	GB_CONSTANT("CULL_FACE", "i", GL_CULL_FACE),
	GB_CONSTANT("CULL_FACE_MODE", "i", GL_CULL_FACE_MODE),
	GB_CONSTANT("FRONT_FACE", "i", GL_FRONT_FACE),
	GB_CONSTANT("POLYGON_OFFSET_FACTOR", "i", GL_POLYGON_OFFSET_FACTOR),
	GB_CONSTANT("POLYGON_OFFSET_UNITS", "i", GL_POLYGON_OFFSET_UNITS),
	GB_CONSTANT("POLYGON_OFFSET_POINT", "i", GL_POLYGON_OFFSET_POINT),
	GB_CONSTANT("POLYGON_OFFSET_LINE", "i", GL_POLYGON_OFFSET_LINE),
	GB_CONSTANT("POLYGON_OFFSET_FILL", "i", GL_POLYGON_OFFSET_FILL),

	/* Depth buffer */
	GB_CONSTANT("NEVER", "i", GL_NEVER),
	GB_CONSTANT("LESS", "i", GL_LESS),
	GB_CONSTANT("EQUAL", "i", GL_EQUAL),
	GB_CONSTANT("LEQUAL", "i", GL_LEQUAL),
	GB_CONSTANT("GREATER", "i", GL_GREATER),
	GB_CONSTANT("NOTEQUAL", "i", GL_NOTEQUAL),
	GB_CONSTANT("GEQUAL", "i", GL_GEQUAL),
	GB_CONSTANT("ALWAYS", "i", GL_ALWAYS),
	GB_CONSTANT("DEPTH_TEST", "i", GL_DEPTH_TEST),
	GB_CONSTANT("DEPTH_BITS", "i", GL_DEPTH_BITS),
	GB_CONSTANT("DEPTH_CLEAR_VALUE", "i", GL_DEPTH_CLEAR_VALUE),
	GB_CONSTANT("DEPTH_FUNC", "i", GL_DEPTH_FUNC),
	GB_CONSTANT("DEPTH_RANGE", "i", GL_DEPTH_RANGE),
	GB_CONSTANT("DEPTH_WRITEMASK", "i", GL_DEPTH_WRITEMASK),
	GB_CONSTANT("DEPTH_COMPONENT", "i", GL_DEPTH_COMPONENT),

	/* Lines */
	GB_CONSTANT("LINE_SMOOTH", "i", GL_LINE_SMOOTH),
	GB_CONSTANT("LINE_STIPPLE", "i", GL_LINE_STIPPLE),
	GB_CONSTANT("LINE_STIPPLE_PATTERN", "i", GL_LINE_STIPPLE_PATTERN),
	GB_CONSTANT("LINE_STIPPLE_REPEAT", "i", GL_LINE_STIPPLE_REPEAT),
	GB_CONSTANT("LINE_WIDTH", "i", GL_LINE_WIDTH),
	GB_CONSTANT("SMOOTH_LINE_WIDTH_GRANULARITY", "i", GL_SMOOTH_LINE_WIDTH_GRANULARITY),
	GB_CONSTANT("SMOOTH_LINE_WIDTH_RANGE", "i", GL_SMOOTH_LINE_WIDTH_RANGE),

	/* Render Mode */
	GB_CONSTANT("FEEDBACK", "i", GL_FEEDBACK),
	GB_CONSTANT("RENDER", "i", GL_RENDER),
	GB_CONSTANT("SELECT", "i", GL_SELECT),

	/* Feedback */
	GB_CONSTANT("_2D", "i", GL_2D),
	GB_CONSTANT("_3D", "i", GL_3D),
	GB_CONSTANT("_3D_COLOR", "i", GL_3D_COLOR),
	GB_CONSTANT("_3D_COLOR_TEXTURE", "i",  GL_3D_COLOR_TEXTURE),
	GB_CONSTANT("_4D_COLOR_TEXTURE", "i",  GL_4D_COLOR_TEXTURE),
	GB_CONSTANT("POINT_TOKEN", "i", GL_POINT_TOKEN),
	GB_CONSTANT("LINE_TOKEN", "i", GL_LINE_TOKEN),
	GB_CONSTANT("LINE_RESET_TOKEN", "i", GL_LINE_RESET_TOKEN),
	GB_CONSTANT("POLYGON_TOKEN", "i", GL_POLYGON_TOKEN),
	GB_CONSTANT("BITMAP_TOKEN", "i", GL_BITMAP_TOKEN),
	GB_CONSTANT("DRAW_PIXEL_TOKEN", "i", GL_DRAW_PIXEL_TOKEN),
	GB_CONSTANT("COPY_PIXEL_TOKEN", "i", GL_COPY_PIXEL_TOKEN),
	GB_CONSTANT("PASS_THROUGH_TOKEN", "i", GL_PASS_THROUGH_TOKEN),
	GB_CONSTANT("FEEDBACK_BUFFER_POINTER", "i", GL_FEEDBACK_BUFFER_POINTER),
	GB_CONSTANT("FEEDBACK_BUFFER_SIZE", "i", GL_FEEDBACK_BUFFER_SIZE),
	GB_CONSTANT("FEEDBACK_BUFFER_TYPE", "i", GL_FEEDBACK_BUFFER_TYPE),

	/* Selection */
	GB_CONSTANT("SELECTION_BUFFER_POINTER", "i", GL_SELECTION_BUFFER_POINTER),
	GB_CONSTANT("SELECTION_BUFFER_SIZE", "i", GL_SELECTION_BUFFER_SIZE),

	/* Fog */
	GB_CONSTANT("FOG", "i", GL_FOG),
	GB_CONSTANT("FOG_MODE", "i", GL_FOG_MODE),
	GB_CONSTANT("FOG_DENSITY", "i", GL_FOG_DENSITY),
	GB_CONSTANT("FOG_COLOR", "i", GL_FOG_COLOR),
	GB_CONSTANT("FOG_INDEX", "i", GL_FOG_INDEX),
	GB_CONSTANT("FOG_START", "i", GL_FOG_START),
	GB_CONSTANT("FOG_END", "i", GL_FOG_END),
	GB_CONSTANT("LINEAR", "i", GL_LINEAR),
	GB_CONSTANT("EXP", "i", GL_EXP),
	GB_CONSTANT("EXP2", "i", GL_EXP2),

	/* Errors */
	GB_CONSTANT("NO_ERROR", "i", GL_NO_ERROR),
	GB_CONSTANT("INVALID_VALUE", "i", GL_INVALID_VALUE),
	GB_CONSTANT("INVALID_ENUM", "i", GL_INVALID_ENUM),
	GB_CONSTANT("INVALID_OPERATION", "i", GL_INVALID_OPERATION),
	GB_CONSTANT("STACK_OVERFLOW", "i", GL_STACK_OVERFLOW),
	GB_CONSTANT("STACK_UNDERFLOW", "i", GL_STACK_UNDERFLOW),
	GB_CONSTANT("OUT_OF_MEMORY", "i", GL_OUT_OF_MEMORY),

	/* Lighting */
	GB_CONSTANT("LIGHTING", "i", GL_LIGHTING),
	GB_CONSTANT("LIGHT0", "i", GL_LIGHT0),
	GB_CONSTANT("LIGHT1", "i", GL_LIGHT1),
	GB_CONSTANT("LIGHT2", "i", GL_LIGHT2),
	GB_CONSTANT("LIGHT3", "i", GL_LIGHT3),
	GB_CONSTANT("LIGHT4", "i", GL_LIGHT4),
	GB_CONSTANT("LIGHT5", "i", GL_LIGHT5),
	GB_CONSTANT("LIGHT6", "i", GL_LIGHT6),
	GB_CONSTANT("LIGHT7", "i", GL_LIGHT7),
	GB_CONSTANT("SPOT_EXPONENT", "i", GL_SPOT_EXPONENT),
	GB_CONSTANT("SPOT_CUTTOFF", "i", GL_SPOT_CUTOFF),
	GB_CONSTANT("CONSTANT_ATTENUATION", "i", GL_CONSTANT_ATTENUATION),
	GB_CONSTANT("LINEAR_ATTENUATION", "i", GL_LINEAR_ATTENUATION),
	GB_CONSTANT("QUADRATIC_ATTENUATION", "i", GL_QUADRATIC_ATTENUATION),
	GB_CONSTANT("AMBIENT", "i", GL_AMBIENT),
	GB_CONSTANT("DIFFUSE", "i", GL_DIFFUSE),
	GB_CONSTANT("SPECULAR", "i", GL_SPECULAR),
	GB_CONSTANT("SHININESS", "i", GL_SHININESS),
	GB_CONSTANT("EMISSION", "i", GL_EMISSION),
	GB_CONSTANT("POSITION", "i", GL_POSITION),
	GB_CONSTANT("SPOT_DIRECTION", "i", GL_SPOT_DIRECTION),
	GB_CONSTANT("AMBIENT_AND_DIFFUSE", "i", GL_AMBIENT_AND_DIFFUSE),
	GB_CONSTANT("COLOR_INDEXES", "i", GL_COLOR_INDEXES),
	GB_CONSTANT("LIGHT_MODEL_TWO_SIDE", "i", GL_LIGHT_MODEL_TWO_SIDE),
	GB_CONSTANT("LIGHT_MODEL_LOCAL_VIEWER", "i", GL_LIGHT_MODEL_LOCAL_VIEWER),
	GB_CONSTANT("LIGHT_MODEL_AMBIENT", "i", GL_LIGHT_MODEL_AMBIENT),
	GB_CONSTANT("FRONT_AND_BACK", "i", GL_FRONT_AND_BACK),
	GB_CONSTANT("SHADE_MODEL", "i", GL_SHADE_MODEL),
	GB_CONSTANT("FLAT", "i", GL_FLAT),
	GB_CONSTANT("SMOOTH", "i", GL_SMOOTH),
	GB_CONSTANT("COLOR_MATERIAL", "i", GL_COLOR_MATERIAL),
	GB_CONSTANT("COLOR_MATERIAL_FACE", "i", GL_COLOR_MATERIAL_FACE),
	GB_CONSTANT("COLOR_MATERIAL_PARAMETER", "i", GL_COLOR_MATERIAL_PARAMETER),
	GB_CONSTANT("NORMALIZE", "i", GL_NORMALIZE),

	/* Blending */
	GB_CONSTANT("BLEND", "i", GL_BLEND),
	GB_CONSTANT("BLEND_SRC", "i", GL_BLEND_SRC),
	GB_CONSTANT("BLEND_DST", "i", GL_BLEND_DST),
	GB_CONSTANT("ZERO", "i", GL_ZERO),
	GB_CONSTANT("ONE", "i", GL_ONE),
	GB_CONSTANT("SRC_COLOR", "i", GL_SRC_COLOR),
	GB_CONSTANT("ONE_MINUS_SRC_COLOR", "i", GL_ONE_MINUS_SRC_COLOR),
	GB_CONSTANT("SRC_ALPHA", "i", GL_SRC_ALPHA),
	GB_CONSTANT("ONE_MINUS_SRC_ALPHA", "i", GL_ONE_MINUS_SRC_ALPHA),
	GB_CONSTANT("DST_ALPHA", "i", GL_DST_ALPHA),
	GB_CONSTANT("ONE_MINUS_DST_ALPHA", "i", GL_ONE_MINUS_DST_ALPHA),
	GB_CONSTANT("DST_COLOR", "i", GL_DST_COLOR),
	GB_CONSTANT("ONE_MINUS_DST_COLOR", "i", GL_ONE_MINUS_DST_COLOR),
	GB_CONSTANT("SRC_ALPHA_SATURATE", "i", GL_SRC_ALPHA_SATURATE),

	/* Logic Ops */
	GB_CONSTANT("LOGIC_OP", "i", GL_LOGIC_OP),
	GB_CONSTANT("INDEX_LOGIC_OP", "i", GL_INDEX_LOGIC_OP),
	GB_CONSTANT("COLOR_LOGIC_OP", "i", GL_COLOR_LOGIC_OP),
	GB_CONSTANT("LOGIC_OP_MODE", "i", GL_LOGIC_OP_MODE),
	GB_CONSTANT("CLEAR_", "i", GL_CLEAR),
	GB_CONSTANT("SET", "i", GL_SET),
	GB_CONSTANT("COPY", "i", GL_COPY),
	GB_CONSTANT("COPY_INVERTED", "i", GL_COPY_INVERTED),
	GB_CONSTANT("NOOP", "i", GL_NOOP),
	GB_CONSTANT("INVERT", "i", GL_INVERT),
	GB_CONSTANT("AND", "i", GL_AND),
	GB_CONSTANT("NAND", "i", GL_NAND),
	GB_CONSTANT("OR", "i", GL_OR),
	GB_CONSTANT("NOR", "i", GL_NOR),
	GB_CONSTANT("XOR", "i", GL_XOR),
	GB_CONSTANT("EQUIV", "i", GL_EQUIV),
	GB_CONSTANT("AND_REVERSE", "i", GL_AND_REVERSE),
	GB_CONSTANT("AND_INVERTED", "i", GL_AND_INVERTED),
	GB_CONSTANT("OR_REVERSE", "i", GL_OR_REVERSE),
	GB_CONSTANT("OR_INVERTED", "i", GL_OR_INVERTED),

	/* Stencil */
	GB_CONSTANT("STENCIL_BITS", "i", GL_STENCIL_BITS),
	GB_CONSTANT("STENCIL_TEST", "i", GL_STENCIL_TEST),
	GB_CONSTANT("STENCIL_CLEAR_VALUE", "i", GL_STENCIL_CLEAR_VALUE),
	GB_CONSTANT("STENCIL_FUNC", "i", GL_STENCIL_FUNC),
	GB_CONSTANT("STENCIL_VALUE_MASK", "i", GL_STENCIL_VALUE_MASK),
	GB_CONSTANT("STENCIL_FAIL", "i", GL_STENCIL_FAIL),
	GB_CONSTANT("STENCIL_PASS_DEPTH_FAIL", "i", GL_STENCIL_PASS_DEPTH_FAIL),
	GB_CONSTANT("STENCIL_PASS_DEPTH_PASS", "i", GL_STENCIL_PASS_DEPTH_PASS),
	GB_CONSTANT("STENCIL_REF", "i", GL_STENCIL_REF),
	GB_CONSTANT("STENCIL_WRITEMASK", "i", GL_STENCIL_WRITEMASK),
	GB_CONSTANT("STENCIL_INDEX", "i", GL_STENCIL_INDEX),
	GB_CONSTANT("KEEP", "i", GL_KEEP),
	GB_CONSTANT("REPLACE", "i", GL_REPLACE),
	GB_CONSTANT("INCR", "i", GL_INCR),
	GB_CONSTANT("DECR", "i", GL_DECR),

	/* Buffers, Pixel Drawing/Reading */
	GB_CONSTANT("AUX0", "i", GL_AUX0),
	GB_CONSTANT("AUX1", "i", GL_AUX1),
	GB_CONSTANT("AUX2", "i", GL_AUX2),
	GB_CONSTANT("AUX3", "i", GL_AUX3),
	GB_CONSTANT("BACK_LEFT", "i", GL_BACK_LEFT),
	GB_CONSTANT("BACK_RIGHT", "i", GL_BACK_RIGHT),
	GB_CONSTANT("FRONT_LEFT", "i", GL_FRONT_LEFT),
	GB_CONSTANT("FRONT_RIGHT", "i", GL_FRONT_RIGHT),
	GB_CONSTANT("LEFT", "i", GL_LEFT),
	GB_CONSTANT("NONE", "i", GL_NONE),
	GB_CONSTANT("RIGHT", "i", GL_RIGHT),
	GB_CONSTANT("COLOR_INDEX", "i", GL_COLOR_INDEX),
	GB_CONSTANT("RED", "i", GL_RED),
	GB_CONSTANT("GREEN", "i", GL_GREEN),
	GB_CONSTANT("BLUE", "i", GL_BLUE),
	GB_CONSTANT("ALPHA", "i", GL_ALPHA),
	GB_CONSTANT("LUMINANCE", "i", GL_LUMINANCE),
	GB_CONSTANT("LUMINANCE_ALPHA", "i", GL_LUMINANCE_ALPHA),
	GB_CONSTANT("ALPHA_BITS", "i", GL_ALPHA_BITS),
	GB_CONSTANT("RED_BITS", "i", GL_RED_BITS),
	GB_CONSTANT("GREEN_BITS", "i", GL_GREEN_BITS),
	GB_CONSTANT("BLUE_BITS", "i", GL_BLUE_BITS),
	GB_CONSTANT("INDEX_BITS", "i", GL_INDEX_BITS),
	GB_CONSTANT("SUBPIXEL_BITS", "i", GL_SUBPIXEL_BITS),
	GB_CONSTANT("AUX_BUFFERS", "i", GL_AUX_BUFFERS),
	GB_CONSTANT("READ_BUFFER", "i", GL_READ_BUFFER),
	GB_CONSTANT("DRAW_BUFFER", "i", GL_DRAW_BUFFER),
	GB_CONSTANT("DOUBLEBUFFER", "i", GL_DOUBLEBUFFER),
	GB_CONSTANT("STEREO", "i", GL_STEREO),
	GB_CONSTANT("BITMAP_", "i", GL_BITMAP),
	GB_CONSTANT("COLOR", "i", GL_COLOR),
	GB_CONSTANT("DEPTH", "i", GL_DEPTH),
	GB_CONSTANT("STENCIL", "i", GL_STENCIL),
	GB_CONSTANT("DITHER", "i", GL_DITHER),
	GB_CONSTANT("RGB", "i", GL_RGB),
	GB_CONSTANT("RGBA", "i", GL_RGBA),
	GB_CONSTANT("BGR", "i", GL_BGR),
        GB_CONSTANT("BGRA", "i", GL_BGRA),

	/* Implementation limits */
	GB_CONSTANT("MAX_LIST_NESTING", "i", GL_MAX_LIST_NESTING),
	GB_CONSTANT("MAX_ATTRIB_STACK_DEPTH", "i", GL_MAX_ATTRIB_STACK_DEPTH),
	GB_CONSTANT("MAX_NAME_STACK_DEPTH", "i", GL_MAX_NAME_STACK_DEPTH),
	GB_CONSTANT("MAX_PROJECTION_STACK_DEPTH", "i", GL_MAX_PROJECTION_STACK_DEPTH),
	GB_CONSTANT("MAX_TEXTURE_STACK_DEPTH", "i", GL_MAX_TEXTURE_STACK_DEPTH),
	GB_CONSTANT("MAX_EVAL_ORDER", "i", GL_MAX_EVAL_ORDER),
	GB_CONSTANT("MAX_LIGHTS", "i", GL_MAX_LIGHTS),
	GB_CONSTANT("MAX_CLIP_PLANES", "i", GL_MAX_CLIP_PLANES),
	GB_CONSTANT("MAX_TEXTURE_SIZE", "i", GL_MAX_TEXTURE_SIZE),
	GB_CONSTANT("MAX_PIXEL_MAP_TABLE", "i", GL_MAX_PIXEL_MAP_TABLE),
	GB_CONSTANT("MAX_VIEWPORT_DIMS", "i", GL_MAX_VIEWPORT_DIMS),
	GB_CONSTANT("MAX_CLIENT_ATTRIB_STACK_DEPTH", "i", GL_MAX_CLIENT_ATTRIB_STACK_DEPTH),
	GB_CONSTANT("MAX_MODELVIEW_STACK_DEPTH", "i", GL_MAX_MODELVIEW_STACK_DEPTH),

	/* Gets */
	GB_CONSTANT("ATTRIB_STACK_DEPTH", "i", GL_ATTRIB_STACK_DEPTH),
	GB_CONSTANT("CLIENT_ATTRIB_STACK_DEPTH", "i", GL_CLIENT_ATTRIB_STACK_DEPTH),
	GB_CONSTANT("COLOR_CLEAR_VALUE", "i", GL_COLOR_CLEAR_VALUE),
	GB_CONSTANT("COLOR_WRITEMASK", "i", GL_COLOR_WRITEMASK),
	GB_CONSTANT("CURRENT_INDEX", "i", GL_CURRENT_INDEX),
	GB_CONSTANT("CURRENT_COLOR", "i", GL_CURRENT_COLOR),
	GB_CONSTANT("CURRENT_NORMAL", "i", GL_CURRENT_NORMAL),
	GB_CONSTANT("CURRENT_RASTER_COLOR", "i", GL_CURRENT_RASTER_COLOR),
	GB_CONSTANT("CURRENT_RASTER_DISTANCE", "i", GL_CURRENT_RASTER_DISTANCE),
	GB_CONSTANT("CURRENT_RASTER_INDEX", "i", GL_CURRENT_RASTER_INDEX),
	GB_CONSTANT("CURRENT_RASTER_POSITION", "i", GL_CURRENT_RASTER_POSITION),
	GB_CONSTANT("CURRENT_RASTER_TEXTURE_COORDS", "i", GL_CURRENT_RASTER_TEXTURE_COORDS),
	GB_CONSTANT("CURRENT_RASTER_POSITION_VALID", "i", GL_CURRENT_RASTER_POSITION_VALID),
	GB_CONSTANT("CURRENT_TEXTURE_COORDS", "i", GL_CURRENT_TEXTURE_COORDS),
	GB_CONSTANT("INDEX_CLEAR_VALUE", "i", GL_INDEX_CLEAR_VALUE),
	GB_CONSTANT("INDEX_MODE", "i", GL_INDEX_MODE),
	GB_CONSTANT("INDEX_WRITEMASK", "i", GL_INDEX_WRITEMASK),
	GB_CONSTANT("MODELVIEW_MATRIX", "i", GL_MODELVIEW_MATRIX),
	GB_CONSTANT("MODELVIEW_STACK_DEPTH", "i", GL_MODELVIEW_STACK_DEPTH),
	GB_CONSTANT("NAME_STACK_DEPTH", "i", GL_NAME_STACK_DEPTH),
	GB_CONSTANT("PROJECTION_MATRIX", "i", GL_PROJECTION_MATRIX),
	GB_CONSTANT("PROJECTION_STACK_DEPTH", "i", GL_PROJECTION_STACK_DEPTH),
	GB_CONSTANT("RENDER_MODE", "i", GL_RENDER_MODE),
	GB_CONSTANT("RGBA_MODE", "i", GL_RGBA_MODE),
	GB_CONSTANT("TEXTURE_MATRIX", "i", GL_TEXTURE_MATRIX),
	GB_CONSTANT("TEXTURE_STACK_DEPTH", "i", GL_TEXTURE_STACK_DEPTH),
	GB_CONSTANT("VIEWPORT_", "i", GL_VIEWPORT),

	/* Evaluators */
	GB_CONSTANT("AUTO_NORMAL", "i", GL_AUTO_NORMAL),
	GB_CONSTANT("MAP1_COLOR_4","i", GL_MAP1_COLOR_4),
	GB_CONSTANT("MAP1_INDEX","i", GL_MAP1_INDEX),
	GB_CONSTANT("MAP1_NORMAL","i", GL_MAP1_NORMAL),
	GB_CONSTANT("MAP1_TEXTURE_COORD_1","i", GL_MAP1_TEXTURE_COORD_1),
	GB_CONSTANT("MAP1_TEXTURE_COORD_2","i", GL_MAP1_TEXTURE_COORD_2),
	GB_CONSTANT("MAP1_TEXTURE_COORD_3","i", GL_MAP1_TEXTURE_COORD_3),
	GB_CONSTANT("MAP1_TEXTURE_COORD_4","i", GL_MAP1_TEXTURE_COORD_4),
	GB_CONSTANT("MAP1_VERTEX_3","i", GL_MAP1_VERTEX_3),
	GB_CONSTANT("MAP1_VERTEX_4","i", GL_MAP1_VERTEX_4),
	GB_CONSTANT("MAP2_COLOR_4","i", GL_MAP2_COLOR_4),
	GB_CONSTANT("MAP2_INDEX","i", GL_MAP2_INDEX),
	GB_CONSTANT("MAP2_NORMAL","i", GL_MAP2_NORMAL),
	GB_CONSTANT("MAP2_TEXTURE_COORD_1","i", GL_MAP2_TEXTURE_COORD_1),
	GB_CONSTANT("MAP2_TEXTURE_COORD_2","i", GL_MAP2_TEXTURE_COORD_2),
	GB_CONSTANT("MAP2_TEXTURE_COORD_3","i", GL_MAP2_TEXTURE_COORD_3),
	GB_CONSTANT("MAP2_TEXTURE_COORD_4","i", GL_MAP2_TEXTURE_COORD_4),
	GB_CONSTANT("MAP2_VERTEX_3","i", GL_MAP2_VERTEX_3),
	GB_CONSTANT("MAP2_VERTEX_4","i", GL_MAP2_VERTEX_4),
	GB_CONSTANT("MAP1_GRID_DOMAIN","i", GL_MAP1_GRID_DOMAIN),
	GB_CONSTANT("MAP1_GRID_SEGMENTS","i", GL_MAP1_GRID_SEGMENTS),
	GB_CONSTANT("MAP2_GRID_DOMAIN","i", GL_MAP2_GRID_DOMAIN),
	GB_CONSTANT("MAP2_GRID_SEGMENTS","i", GL_MAP2_GRID_SEGMENTS),
	GB_CONSTANT("COEFF","i", GL_COEFF),
	GB_CONSTANT("ORDER","i", GL_ORDER),
	GB_CONSTANT("DOMAIN","i", GL_DOMAIN),

	/* Hints */
	GB_CONSTANT("FOG_HINT", "i", GL_FOG_HINT),
	GB_CONSTANT("LINE_SMOOTH_HINT", "i", GL_LINE_SMOOTH_HINT),
	GB_CONSTANT("PERSPECTIVE_CORRECTION_HINT", "i", GL_PERSPECTIVE_CORRECTION_HINT),
	GB_CONSTANT("POINT_SMOOTH_HINT", "i", GL_POINT_SMOOTH_HINT),
	GB_CONSTANT("POLYGON_SMOOTH_HINT", "i", GL_POLYGON_SMOOTH_HINT),
	GB_CONSTANT("DONT_CARE", "i", GL_DONT_CARE),
	GB_CONSTANT("FASTEST", "i", GL_FASTEST),
	GB_CONSTANT("NICEST", "i", GL_NICEST),

	/* Scissor box */
	GB_CONSTANT("SCISSOR_BOX", "i", GL_SCISSOR_BOX),
	GB_CONSTANT("SCISSOR_TEST", "i", GL_SCISSOR_TEST),

	/* Pixel Mode / Transfer */
	GB_CONSTANT("MAP_COLOR", "i", GL_MAP_COLOR),
	GB_CONSTANT("MAP_STENCIL", "i", GL_MAP_STENCIL),
	GB_CONSTANT("INDEX_SHIFT", "i", GL_INDEX_SHIFT),
	GB_CONSTANT("INDEX_OFFSET", "i", GL_INDEX_OFFSET),
	GB_CONSTANT("RED_SCALE", "i", GL_RED_SCALE),
	GB_CONSTANT("RED_BIAS", "i", GL_RED_BIAS),
	GB_CONSTANT("GREEN_SCALE", "i", GL_GREEN_SCALE),
	GB_CONSTANT("GREEN_BIAS", "i", GL_GREEN_BIAS),
	GB_CONSTANT("BLUE_SCALE", "i", GL_BLUE_SCALE),
	GB_CONSTANT("BLUE_BIAS", "i", GL_BLUE_BIAS),
	GB_CONSTANT("ALPHA_SCALE", "i", GL_ALPHA_SCALE),
	GB_CONSTANT("ALPHA_BIAS", "i", GL_ALPHA_BIAS),
	GB_CONSTANT("DEPTH_SCALE", "i", GL_DEPTH_SCALE),
	GB_CONSTANT("DEPTH_BIAS", "i", GL_DEPTH_BIAS),
	GB_CONSTANT("PIXEL_MAP_S_TO_S_SIZE", "i", GL_PIXEL_MAP_S_TO_S_SIZE),
	GB_CONSTANT("PIXEL_MAP_I_TO_I_SIZE", "i", GL_PIXEL_MAP_I_TO_I_SIZE),
	GB_CONSTANT("PIXEL_MAP_I_TO_R_SIZE", "i", GL_PIXEL_MAP_I_TO_R_SIZE),
	GB_CONSTANT("PIXEL_MAP_I_TO_G_SIZE", "i", GL_PIXEL_MAP_I_TO_G_SIZE),
	GB_CONSTANT("PIXEL_MAP_I_TO_B_SIZE", "i", GL_PIXEL_MAP_I_TO_B_SIZE),
	GB_CONSTANT("PIXEL_MAP_I_TO_A_SIZE", "i", GL_PIXEL_MAP_I_TO_A_SIZE),
	GB_CONSTANT("PIXEL_MAP_R_TO_R_SIZE", "i", GL_PIXEL_MAP_R_TO_R_SIZE),
	GB_CONSTANT("PIXEL_MAP_G_TO_G_SIZE", "i", GL_PIXEL_MAP_G_TO_G_SIZE),
	GB_CONSTANT("PIXEL_MAP_B_TO_B_SIZE", "i", GL_PIXEL_MAP_B_TO_B_SIZE),
	GB_CONSTANT("PIXEL_MAP_A_TO_A_SIZE", "i", GL_PIXEL_MAP_A_TO_A_SIZE),
	GB_CONSTANT("PIXEL_MAP_S_TO_S", "i", GL_PIXEL_MAP_S_TO_S),
	GB_CONSTANT("PIXEL_MAP_I_TO_I", "i", GL_PIXEL_MAP_I_TO_I),
	GB_CONSTANT("PIXEL_MAP_I_TO_R", "i", GL_PIXEL_MAP_I_TO_R),
	GB_CONSTANT("PIXEL_MAP_I_TO_G", "i", GL_PIXEL_MAP_I_TO_G),
	GB_CONSTANT("PIXEL_MAP_I_TO_B", "i", GL_PIXEL_MAP_I_TO_B),
	GB_CONSTANT("PIXEL_MAP_I_TO_A", "i", GL_PIXEL_MAP_I_TO_A),
	GB_CONSTANT("PIXEL_MAP_R_TO_R", "i", GL_PIXEL_MAP_R_TO_R),
	GB_CONSTANT("PIXEL_MAP_G_TO_G", "i", GL_PIXEL_MAP_G_TO_G),
	GB_CONSTANT("PIXEL_MAP_B_TO_B", "i", GL_PIXEL_MAP_B_TO_B),
	GB_CONSTANT("PIXEL_MAP_A_TO_A", "i", GL_PIXEL_MAP_A_TO_A),
	GB_CONSTANT("PACK_ALIGNMENT", "i", GL_PACK_ALIGNMENT),
	GB_CONSTANT("PACK_LSB_FIRST", "i", GL_PACK_LSB_FIRST),
	GB_CONSTANT("PACK_ROW_LENGTH", "i", GL_PACK_ROW_LENGTH),
	GB_CONSTANT("PACK_SKIP_PIXELS", "i", GL_PACK_SKIP_PIXELS),
	GB_CONSTANT("PACK_SKIP_ROWS", "i", GL_PACK_SKIP_ROWS),
	GB_CONSTANT("PACK_SWAP_BYTES", "i", GL_PACK_SWAP_BYTES),
	GB_CONSTANT("UNPACK_ALIGNMENT", "i", GL_UNPACK_ALIGNMENT),
	GB_CONSTANT("UNPACK_LSB_FIRST", "i", GL_UNPACK_LSB_FIRST),
	GB_CONSTANT("UNPACK_ROW_LENGTH", "i", GL_UNPACK_ROW_LENGTH),
	GB_CONSTANT("UNPACK_SKIP_PIXELS", "i", GL_UNPACK_SKIP_PIXELS),
	GB_CONSTANT("UNPACK_SKIP_ROWS", "i", GL_UNPACK_SKIP_ROWS),
	GB_CONSTANT("UNPACK_SWAP_BYTES", "i", GL_UNPACK_SWAP_BYTES),
	GB_CONSTANT("ZOOM_X", "i", GL_ZOOM_X),
	GB_CONSTANT("ZOOM_Y", "i", GL_ZOOM_Y),

	/* Texture mapping */
	GB_CONSTANT("TEXTURE_ENV", "i", GL_TEXTURE_ENV),
	GB_CONSTANT("TEXTURE_ENV_MODE", "i", GL_TEXTURE_ENV_MODE),
	GB_CONSTANT("TEXTURE_1D", "i", GL_TEXTURE_1D),
	GB_CONSTANT("TEXTURE_2D", "i", GL_TEXTURE_2D),
	GB_CONSTANT("TEXTURE_WRAP_S", "i", GL_TEXTURE_WRAP_S),
	GB_CONSTANT("TEXTURE_WRAP_T", "i", GL_TEXTURE_WRAP_T),
	GB_CONSTANT("TEXTURE_MAG_FILTER", "i", GL_TEXTURE_MAG_FILTER),
	GB_CONSTANT("TEXTURE_MIN_FILTER", "i", GL_TEXTURE_MIN_FILTER),
	GB_CONSTANT("TEXTURE_ENV_COLOR", "i", GL_TEXTURE_ENV_COLOR),
	GB_CONSTANT("TEXTURE_GEN_S", "i", GL_TEXTURE_GEN_S),
	GB_CONSTANT("TEXTURE_GEN_T", "i", GL_TEXTURE_GEN_T),
	GB_CONSTANT("TEXTURE_GEN_MODE", "i", GL_TEXTURE_GEN_MODE),
	GB_CONSTANT("TEXTURE_BORDER_COLOR", "i", GL_TEXTURE_BORDER_COLOR),
	GB_CONSTANT("TEXTURE_WIDTH", "i", GL_TEXTURE_WIDTH),
	GB_CONSTANT("TEXTURE_HEIGHT", "i", GL_TEXTURE_HEIGHT),
	GB_CONSTANT("TEXTURE_BORDER", "i", GL_TEXTURE_BORDER),
	GB_CONSTANT("TEXTURE_COMPONENTS", "i", GL_TEXTURE_COMPONENTS),
	GB_CONSTANT("TEXTURE_RED_SIZE", "i", GL_TEXTURE_RED_SIZE),
	GB_CONSTANT("TEXTURE_GREEN_SIZE", "i", GL_TEXTURE_GREEN_SIZE),
	GB_CONSTANT("TEXTURE_BLUE_SIZE", "i", GL_TEXTURE_BLUE_SIZE),
	GB_CONSTANT("TEXTURE_ALPHA_SIZE", "i", GL_TEXTURE_ALPHA_SIZE),
	GB_CONSTANT("TEXTURE_LUMINANCE_SIZE", "i", GL_TEXTURE_LUMINANCE_SIZE),
	GB_CONSTANT("TEXTURE_INTENSITY_SIZE", "i", GL_TEXTURE_INTENSITY_SIZE),
	GB_CONSTANT("NEAREST_MIPMAP_NEAREST", "i", GL_NEAREST_MIPMAP_NEAREST),
	GB_CONSTANT("NEAREST_MIPMAP_LINEAR", "i", GL_NEAREST_MIPMAP_LINEAR),
	GB_CONSTANT("LINEAR_MIPMAP_NEAREST", "i", GL_LINEAR_MIPMAP_NEAREST),
	GB_CONSTANT("LINEAR_MIPMAP_LINEAR", "i", GL_LINEAR_MIPMAP_LINEAR),
	GB_CONSTANT("OBJECT_LINEAR", "i", GL_OBJECT_LINEAR),
	GB_CONSTANT("OBJECT_PLANE", "i", GL_OBJECT_PLANE),
	GB_CONSTANT("EYE_LINEAR", "i", GL_EYE_LINEAR),
	GB_CONSTANT("EYE_PLANE", "i", GL_EYE_PLANE),
	GB_CONSTANT("SPHERE_MAP", "i", GL_SPHERE_MAP),
	GB_CONSTANT("DECAL", "i", GL_DECAL),
	GB_CONSTANT("MODULATE", "i", GL_MODULATE),
	GB_CONSTANT("NEAREST", "i", GL_NEAREST),
	GB_CONSTANT("REPEAT", "i", GL_REPEAT),
	GB_CONSTANT("CLAMP", "i", GL_CLAMP),
	GB_CONSTANT("S", "i", GL_S),
	GB_CONSTANT("T", "i", GL_T),
	GB_CONSTANT("R", "i", GL_R),
	GB_CONSTANT("Q", "i", GL_Q),
	GB_CONSTANT("TEXTURE_GEN_R", "i", GL_TEXTURE_GEN_R),
	GB_CONSTANT("TEXTURE_GEN_Q", "i", GL_TEXTURE_GEN_Q),
        GB_CONSTANT("GENERATE_MIPMAP", "i", GL_GENERATE_MIPMAP),        
        GB_CONSTANT("TEXTURE_MAX_LEVEL", "i", GL_TEXTURE_MAX_LEVEL),
        GB_CONSTANT("COMPRESSED_RGBA", "i", GL_COMPRESSED_RGBA),

	/* Multitexture Mapping ARB*/
	GB_CONSTANT("TEXTURE0_ARB", "i", GL_TEXTURE0_ARB),
	GB_CONSTANT("TEXTURE1_ARB", "i", GL_TEXTURE1_ARB),
	GB_CONSTANT("TEXTURE2_ARB", "i", GL_TEXTURE2_ARB),
	GB_CONSTANT("TEXTURE3_ARB", "i", GL_TEXTURE3_ARB),
	GB_CONSTANT("TEXTURE4_ARB", "i", GL_TEXTURE4_ARB),
	
	GB_CONSTANT("TEXTURE0", "i", GL_TEXTURE0),
	GB_CONSTANT("TEXTURE1", "i", GL_TEXTURE1),
	GB_CONSTANT("TEXTURE2", "i", GL_TEXTURE2),
	GB_CONSTANT("TEXTURE3", "i", GL_TEXTURE3),
	GB_CONSTANT("TEXTURE4", "i", GL_TEXTURE4),
	GB_CONSTANT("COMBINE", "i", GL_COMBINE),
	GB_CONSTANT("COMBINE_RGB", "i", GL_COMBINE_RGB),
	GB_CONSTANT("COMBINE_ALPHA", "i", GL_COMBINE_ALPHA),
	GB_CONSTANT("COMBINE_EXT", "i", GL_COMBINE_EXT),
	GB_CONSTANT("COMBINE_RGB_EXT", "i", GL_COMBINE_RGB_EXT),
	GB_CONSTANT("COMBINE_ALPHA_EXT", "i", GL_COMBINE_ALPHA_EXT),
	GB_CONSTANT("COMBINE_ARB", "i", GL_COMBINE),
	GB_CONSTANT("COMBINE_RGB_ARB", "i", GL_COMBINE_RGB_ARB),
	GB_CONSTANT("COMBINE_ALPHA_ARB", "i", GL_COMBINE_ALPHA_ARB),
	GB_CONSTANT("SOURCE0_RGB_ARB", "i", GL_SOURCE0_RGB_ARB),
	GB_CONSTANT("SOURCE1_RGB_ARB", "i", GL_SOURCE1_RGB_ARB),
	GB_CONSTANT("SOURCE2_RGB_ARB", "i", GL_SOURCE2_RGB_ARB),
	GB_CONSTANT("SOURCE0_ALPHA_ARB", "i", GL_SOURCE0_ALPHA_ARB),
	GB_CONSTANT("SOURCE1_ALPHA_ARB", "i", GL_SOURCE1_ALPHA_ARB),
	GB_CONSTANT("SOURCE2_ALPHA_ARB", "i", GL_SOURCE2_ALPHA_ARB),
	GB_CONSTANT("OPERAND0_RGB_ARB", "i", GL_OPERAND0_RGB_ARB),
	GB_CONSTANT("OPERAND1_RGB_ARB", "i", GL_OPERAND1_RGB_ARB),
	GB_CONSTANT("OPERAND2_RGB_ARB", "i", GL_OPERAND2_RGB_ARB),
	GB_CONSTANT("OPERAND0_ALPHA_ARB", "i", GL_OPERAND0_ALPHA_ARB),
	GB_CONSTANT("OPERAND1_ALPHA_ARB", "i", GL_OPERAND1_ALPHA_ARB),
	GB_CONSTANT("OPERAND2_ALPHA_ARB", "i", GL_OPERAND2_ALPHA_ARB),
	GB_CONSTANT("RGB_SCALE_ARB", "i", GL_RGB_SCALE_ARB),
	GB_CONSTANT("ADD_SIGNED_ARB", "i", GL_ADD_SIGNED_ARB),
	GB_CONSTANT("INTERPOLATE_ARB", "i", GL_INTERPOLATE_ARB),
	GB_CONSTANT("SUBTRACT_ARB", "i", GL_SUBTRACT_ARB),
	GB_CONSTANT("CONSTANT_ARB", "i", GL_CONSTANT_ARB),
	GB_CONSTANT("PRIMARY_COLOR_ARB", "i", GL_PRIMARY_COLOR_ARB),
	GB_CONSTANT("PREVIOUS_ARB", "i", GL_PREVIOUS_ARB),
	GB_CONSTANT("COMPRESSED_RGBA_S3TC_DXT1_EXT", "i", GL_COMPRESSED_RGBA_S3TC_DXT1_EXT),
	GB_CONSTANT("COMPRESSED_RGBA_S3TC_DXT3_EXT", "i", GL_COMPRESSED_RGBA_S3TC_DXT3_EXT),
	GB_CONSTANT("COMPRESSED_RGBA_S3TC_DXT5_EXT", "i", GL_COMPRESSED_RGBA_S3TC_DXT5_EXT),

	/* 38; GL_ARB_texture_rectangle */
	GB_CONSTANT("TEXTURE_RECTANGLE_ARB", "i", GL_TEXTURE_RECTANGLE_ARB),
	GB_CONSTANT("TEXTURE_BINDING_RECTANGLE_ARB", "i", GL_TEXTURE_BINDING_RECTANGLE_ARB),
	GB_CONSTANT("PROXY_TEXTURE_RECTANGLE_ARB", "i", GL_PROXY_TEXTURE_RECTANGLE_ARB),
	GB_CONSTANT("MAX_RECTANGLE_TEXTURE_SIZE_ARB", "i", GL_MAX_RECTANGLE_TEXTURE_SIZE_ARB),
	GB_CONSTANT("SAMPLER_2D_RECT_ARB", "i", GL_SAMPLER_2D_RECT_ARB),
	GB_CONSTANT("SAMPLER_2D_RECT_SHADOW_ARB", "i", GL_SAMPLER_2D_RECT_SHADOW_ARB),

	/* 310; GL_EXT_framebuffer_object */
	GB_CONSTANT("ELEMENT_ARRAY_BUFFER", "i", GL_ELEMENT_ARRAY_BUFFER),
	GB_CONSTANT("FRAMEBUFFER_EXT", "i", GL_FRAMEBUFFER_EXT),
	GB_CONSTANT("RENDERBUFFER_EXT", "i", GL_RENDERBUFFER_EXT),
	GB_CONSTANT("STENCIL_INDEX1_EXT", "i", GL_STENCIL_INDEX1_EXT),
	GB_CONSTANT("STENCIL_INDEX4_EXT", "i", GL_STENCIL_INDEX4_EXT),
	GB_CONSTANT("STENCIL_INDEX8_EXT", "i", GL_STENCIL_INDEX8_EXT),
	GB_CONSTANT("STENCIL_INDEX16_EXT", "i", GL_STENCIL_INDEX16_EXT),
	GB_CONSTANT("RENDERBUFFER_WIDTH_EXT", "i", GL_RENDERBUFFER_WIDTH_EXT),
	GB_CONSTANT("RENDERBUFFER_HEIGHT_EXT", "i", GL_RENDERBUFFER_HEIGHT_EXT),
	GB_CONSTANT("RENDERBUFFER_INTERNAL_FORMAT_EXT", "i", GL_RENDERBUFFER_INTERNAL_FORMAT_EXT),
	GB_CONSTANT("RENDERBUFFER_RED_SIZE_EXT", "i", GL_RENDERBUFFER_RED_SIZE_EXT),
	GB_CONSTANT("RENDERBUFFER_GREEN_SIZE_EXT", "i", GL_RENDERBUFFER_GREEN_SIZE_EXT),
	GB_CONSTANT("RENDERBUFFER_BLUE_SIZE_EXT", "i", GL_RENDERBUFFER_BLUE_SIZE_EXT),
	GB_CONSTANT("RENDERBUFFER_ALPHA_SIZE_EXT", "i", GL_RENDERBUFFER_ALPHA_SIZE_EXT),
	GB_CONSTANT("RENDERBUFFER_DEPTH_SIZE_EXT", "i", GL_RENDERBUFFER_DEPTH_SIZE_EXT),
	GB_CONSTANT("RENDERBUFFER_STENCIL_SIZE_EXT", "i", GL_RENDERBUFFER_STENCIL_SIZE_EXT),
	GB_CONSTANT("FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT", "i", GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT),
	GB_CONSTANT("FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT", "i", GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT),
	GB_CONSTANT("FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT", "i", GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT),
	GB_CONSTANT("FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT", "i", GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT),
	GB_CONSTANT("FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT", "i", GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT),
	GB_CONSTANT("COLOR_ATTACHMENT0_EXT", "i", GL_COLOR_ATTACHMENT0_EXT),
	GB_CONSTANT("COLOR_ATTACHMENT1_EXT", "i", GL_COLOR_ATTACHMENT1_EXT),
	GB_CONSTANT("COLOR_ATTACHMENT2_EXT", "i", GL_COLOR_ATTACHMENT2_EXT),
	GB_CONSTANT("COLOR_ATTACHMENT3_EXT", "i", GL_COLOR_ATTACHMENT3_EXT),
	GB_CONSTANT("COLOR_ATTACHMENT4_EXT", "i", GL_COLOR_ATTACHMENT4_EXT),
	GB_CONSTANT("COLOR_ATTACHMENT5_EXT", "i", GL_COLOR_ATTACHMENT5_EXT),
	GB_CONSTANT("COLOR_ATTACHMENT6_EXT", "i", GL_COLOR_ATTACHMENT6_EXT),
	GB_CONSTANT("COLOR_ATTACHMENT7_EXT", "i", GL_COLOR_ATTACHMENT7_EXT),
	GB_CONSTANT("COLOR_ATTACHMENT8_EXT", "i", GL_COLOR_ATTACHMENT8_EXT),
	GB_CONSTANT("COLOR_ATTACHMENT9_EXT", "i", GL_COLOR_ATTACHMENT9_EXT),
	GB_CONSTANT("COLOR_ATTACHMENT10_EXT", "i", GL_COLOR_ATTACHMENT10_EXT),
	GB_CONSTANT("COLOR_ATTACHMENT11_EXT", "i", GL_COLOR_ATTACHMENT11_EXT),
	GB_CONSTANT("COLOR_ATTACHMENT12_EXT", "i", GL_COLOR_ATTACHMENT12_EXT),
	GB_CONSTANT("COLOR_ATTACHMENT13_EXT", "i", GL_COLOR_ATTACHMENT13_EXT),
	GB_CONSTANT("COLOR_ATTACHMENT14_EXT", "i", GL_COLOR_ATTACHMENT14_EXT),
	GB_CONSTANT("COLOR_ATTACHMENT15_EXT", "i", GL_COLOR_ATTACHMENT15_EXT),
	GB_CONSTANT("DEPTH_ATTACHMENT_EXT", "i", GL_DEPTH_ATTACHMENT_EXT),
	GB_CONSTANT("STENCIL_ATTACHMENT_EXT", "i", GL_STENCIL_ATTACHMENT_EXT),
	GB_CONSTANT("FRAMEBUFFER_COMPLETE_EXT", "i", GL_FRAMEBUFFER_COMPLETE_EXT),
	GB_CONSTANT("FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT", "i", GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT),
	GB_CONSTANT("FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT", "i", GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT),
	GB_CONSTANT("FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT", "i", GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT),
	GB_CONSTANT("FRAMEBUFFER_INCOMPLETE_FORMATS_EXT", "i", GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT),
	GB_CONSTANT("FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT", "i", GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT),
	GB_CONSTANT("FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT", "i", GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT),
	GB_CONSTANT("FRAMEBUFFER_UNSUPPORTED_EXT", "i", GL_FRAMEBUFFER_UNSUPPORTED_EXT),
	GB_CONSTANT("FRAMEBUFFER_BINDING_EXT", "i", GL_FRAMEBUFFER_BINDING_EXT),
	GB_CONSTANT("RENDERBUFFER_BINDING_EXT", "i", GL_RENDERBUFFER_BINDING_EXT),
	GB_CONSTANT("MAX_COLOR_ATTACHMENTS_EXT", "i", GL_MAX_COLOR_ATTACHMENTS_EXT),
	GB_CONSTANT("MAX_RENDERBUFFER_SIZE_EXT", "i", GL_MAX_RENDERBUFFER_SIZE_EXT),
	GB_CONSTANT("INVALID_FRAMEBUFFER_OPERATION_EXT", "i", GL_INVALID_FRAMEBUFFER_OPERATION_EXT),
	GB_CONSTANT("SAMPLES_PASSED", "i", GL_SAMPLES_PASSED),
	GB_CONSTANT("QUERY_RESULT", "i", GL_QUERY_RESULT),
	GB_CONSTANT("TRUE", "i", GL_TRUE),
	GB_CONSTANT("FALSE", "i", GL_FALSE),
	GB_CONSTANT("PRIMITIVES_GENERATED", "i", GL_PRIMITIVES_GENERATED),
	GB_CONSTANT("TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN", "i", GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN),
	//GB_CONSTANT("TIME_ELAPSED", "i",  GL_TIME_ELAPSED),
	//GB_CONSTANT("TIMESTAMP", "i", ​ GL_TIMESTAMP​),
	GB_CONSTANT("CURRENT_QUERY", "i",  GL_CURRENT_QUERY),
	GB_CONSTANT("QUERY_COUNTER_BITS", "i",  GL_QUERY_COUNTER_BITS),

    /* GL Array */
    GB_CONSTANT("ARRAY_BUFFER", "i", GL_ARRAY_BUFFER),
    GB_CONSTANT("STATIC_DRAW", "i", GL_STATIC_DRAW),



   


#if 0

/* OpenGL 1.1 */

  GB_CONSTANT("ProxyTexture1d", "i", GL_PROXY_TEXTURE_1D),
  GB_CONSTANT("ProxyTexture2d", "i", GL_PROXY_TEXTURE_2D),
  GB_CONSTANT("TexturePriority", "i", GL_TEXTURE_PRIORITY),
  GB_CONSTANT("TextureResident", "i", GL_TEXTURE_RESIDENT),
  GB_CONSTANT("TextureBinding1d", "i", GL_TEXTURE_BINDING_1D),
  GB_CONSTANT("TextureBinding2d", "i", GL_TEXTURE_BINDING_2D),
  GB_CONSTANT("TextureInternalFormat", "i", GL_TEXTURE_INTERNAL_FORMAT),
  GB_CONSTANT("Alpha4", "i", GL_ALPHA4),
  GB_CONSTANT("Alpha8", "i", GL_ALPHA8),
  GB_CONSTANT("Alpha12", "i", GL_ALPHA12),
  GB_CONSTANT("Alpha16", "i", GL_ALPHA16),
  GB_CONSTANT("Luminance4", "i", GL_LUMINANCE4),
  GB_CONSTANT("Luminance8", "i", GL_LUMINANCE8),
  GB_CONSTANT("Luminance12", "i", GL_LUMINANCE12),
  GB_CONSTANT("Luminance16", "i", GL_LUMINANCE16),
  GB_CONSTANT("Luminance4Alpha4", "i", GL_LUMINANCE4_ALPHA4),
  GB_CONSTANT("Luminance6Alpha2", "i", GL_LUMINANCE6_ALPHA2),
  GB_CONSTANT("Luminance8Alpha8", "i", GL_LUMINANCE8_ALPHA8),
  GB_CONSTANT("Luminance12Alpha4", "i", GL_LUMINANCE12_ALPHA4),
  GB_CONSTANT("Luminance12Alpha12", "i", GL_LUMINANCE12_ALPHA12),
  GB_CONSTANT("Luminance16Alpha16", "i", GL_LUMINANCE16_ALPHA16),
  GB_CONSTANT("Intensity", "i", GL_INTENSITY),
  GB_CONSTANT("Intensity4", "i", GL_INTENSITY4),
  GB_CONSTANT("Intensity8", "i", GL_INTENSITY8),
  GB_CONSTANT("Intensity12", "i", GL_INTENSITY12),
  GB_CONSTANT("Intensity16", "i", GL_INTENSITY16),
  GB_CONSTANT("R3G3B2", "i", GL_R3_G3_B2),
  GB_CONSTANT("Rgb4", "i", GL_RGB4),
  GB_CONSTANT("Rgb5", "i", GL_RGB5),
  GB_CONSTANT("Rgb8", "i", GL_RGB8),
  GB_CONSTANT("Rgb10", "i", GL_RGB10),
  GB_CONSTANT("Rgb12", "i", GL_RGB12),
  GB_CONSTANT("Rgb16", "i", GL_RGB16),
  GB_CONSTANT("Rgba2", "i", GL_RGBA2),
  GB_CONSTANT("Rgba4", "i", GL_RGBA4),
  GB_CONSTANT("Rgb5A1", "i", GL_RGB5_A1),
  GB_CONSTANT("Rgba8", "i", GL_RGBA8),
  GB_CONSTANT("Rgb10A2", "i", GL_RGB10_A2),
  GB_CONSTANT("Rgba12", "i", GL_RGBA12),
  GB_CONSTANT("Rgba16", "i", GL_RGBA16),
  GB_CONSTANT("ClientPixelStoreBit", "i", GL_CLIENT_PIXEL_STORE_BIT),
  GB_CONSTANT("ClientVertexArrayBit", "i", GL_CLIENT_VERTEX_ARRAY_BIT),
  GB_CONSTANT("AllClientAttribBits", "i", GL_ALL_CLIENT_ATTRIB_BITS),
  GB_CONSTANT("ClientAllAttribBits", "i", GL_CLIENT_ALL_ATTRIB_BITS),

/* texture_border_clamp */

  GB_CONSTANT("ClampToBorder", "i", GL_CLAMP_TO_BORDER),
#endif

	GB_END_DECLARE
};
