#include <string.h>
#include <version.h>

/* - On some systems git is not installed or
 *   installed on a place where FindGit.cmake cannot find it
 * - No git information is present (no .git directory)
 * in those cases clear the gitVersionString (would have string GIT-NOTFOUND).
 */
const char *getGitVersion(void)
{
#define BUF_SIZE 100
  static char gitVersionString[BUF_SIZE];
  static bool init = false;
  if (!init)
  {
    strncpy(gitVersionString,"87846a24ba5d96a548e5e1a377c2ff078a77dd77",BUF_SIZE-1);
    strncat(gitVersionString,!strcmp("false","true")?"*":"",BUF_SIZE-1);
    if (!strcmp("87846a24ba5d96a548e5e1a377c2ff078a77dd77", "GIT-NOTFOUND")) gitVersionString[0] = '\0';
    gitVersionString[BUF_SIZE-1]='\0';
    init = true;
  }
  return gitVersionString;
}
