#include "stdafx.h"
#include <memory.h>
#include "CE_Common.h"

namespace CoreSync
{
	NamedTable::NamedTable()
	{
		pvt_items=gcnew System::Collections::ArrayList();
	}

	NamedRow ^NamedTable::newRow()
	{
		NamedRow ^row=gcnew NamedRow();
		pvt_items->Add(row);
		return row;
	}

	int NamedTable::getRowCount()
	{
		return pvt_items->Count;
	}

	NamedRow ^NamedTable::getRow(int index)
	{
		return (NamedRow ^)pvt_items[index];
	}


	NamedRow::NamedRow()
	{
		pvt_items=gcnew System::Collections::ArrayList();
	}

	void NamedRow::addItem(System::String ^sName, System::String ^sValue)
	{
		if(itemexist(sName)==true)
			return;
		NamedItem ^item=gcnew NamedItem();
		item->Name=sName;
		item->Value=sValue;
		pvt_items->Add(item);
	}

	bool NamedRow::itemexist(System::String ^sName)
	{
		for(int i=0;i<pvt_items->Count;i++)
		{
			NamedItem ^item=(NamedItem ^)pvt_items[i];
			if(item->Name==sName)
				return true;
		}
		return false;
	}

	System::String ^NamedRow::getValue(System::String ^sName)
	{
		for(int i=0;i<pvt_items->Count;i++)
		{
			NamedItem ^item=(NamedItem ^)pvt_items[i];
			if(item->Name==sName)
				return item->Value;
		}
		return gcnew System::String(L"");
	}

	int NamedRow::getValuesCount()
	{
		return pvt_items->Count;
	}

	System::String ^NamedRow::getValueName(int index)
	{
		if(index>=0 && index<pvt_items->Count)
		{
			NamedItem ^item=(NamedItem ^)pvt_items[index];
			return item->Name;
		}
		return gcnew System::String(L"");
	}


	NamedItem::NamedItem()
	{
		Name = gcnew System::String(L"");
		Value = gcnew System::String(L"");
	}

}
