#include "stdafx.h"
#include <memory.h>
#include "CE_Common.h"

namespace CoreSync
{
	Field::Field()
	{
	}
	Field::Field(Object ^oValue)
	{
		setValue(oValue);
	}
	Field::~Field()
	{
	}

	int Field::getID()
	{
		return pvt_iID;
	}

	void Field::setID(int iID)
	{
		pvt_iID=iID;
	}

	int Field::getType()
	{
		//TODO: test
		return Field::pvt_iType;
	}
	void Field::setType(int iType)
	{
		//TODO: test
		Field::pvt_iType=iType;
	}

	System::Object ^Field::getValue()
	{
		//TODO: test
		switch(Field::pvt_iType)
		{
		case Field::BOOL:
			return gcnew System::Boolean(getBoolValue());
			break;
		case Field::DATETIME:
			return getDateValue();
			break;
		case Field::SHORT:
			return gcnew System::Int16(getShortValue());
			break;
		case Field::INT:
			return gcnew System::Int32(getIntValue());
			break;
		case Field::STRING:
			return getStringValue();
			break;
		case Field::DOUBLE:
			return gcnew System::Double(getDoubleValue());
			break;
		case Field::USHORT:
			return gcnew System::UInt16(getUShortValue());
			break;
		case Field::UINT:
			return gcnew System::UInt32(getUIntValue());
			break;
		default:
			return gcnew System::UInt32(0);
			break;
		}
	}
	void Field::setValue(System::Object ^oObject)
	{
		//TODO: test
		if(oObject->GetType()->Name==(gcnew System::Boolean())->GetType()->Name)
		{
			setType(Field::BOOL);
			pvt_bValue=(bool)oObject;
		}
		else if(oObject->GetType()->Name==(gcnew System::Int16())->GetType()->Name)
		{
			setType(Field::SHORT);
			pvt_iValue=(int)oObject;
		}
		else if(oObject->GetType()->Name==(gcnew System::Int32())->GetType()->Name)
		{
			setType(Field::INT);
			pvt_iValue=(int)oObject;
		}
		else if(oObject->GetType()->Name==(gcnew System::Double())->GetType()->Name)
		{
			setType(Field::DOUBLE);
			pvt_dValue=(double)oObject;
		}
		else if(oObject->GetType()->Name==(gcnew System::UInt16())->GetType()->Name)
		{
			setType(Field::USHORT);
			pvt_iValue=(int)oObject;
		}
		else if(oObject->GetType()->Name==(gcnew System::UInt32())->GetType()->Name)
		{
			setType(Field::UINT);
			pvt_iValue=(int)oObject;
		}
		else if(oObject->GetType()->Name==(gcnew System::String(L""))->GetType()->Name)
		{
			setType(Field::STRING);
			pvt_sValue=(System::String ^)oObject;
		}
		else if(oObject->GetType()->Name==(gcnew System::DateTime(0))->GetType()->Name)
		{
			setType(Field::DATETIME);
			pvt_dtValue=(System::DateTime)oObject;
		}
	}

	System::String ^Field::getStringValue()
	{
		//TODO: test
		return pvt_sValue;
	}
	void Field::setStringValue(System::String ^oString)
	{
		//TODO: test
		pvt_sValue=oString;
	}
	short Field::getShortValue()
	{
		//TODO: test
		return (short)pvt_iValue;
	}
	void Field::setShortValue(short wValue)
	{
		//TODO: test
		pvt_iValue=(int)wValue;
	}
	unsigned short Field::getUShortValue()
	{
		//TODO: test
		return (unsigned short)pvt_iValue;
	}
	void Field::setUShortValue(unsigned short wValue)
	{
		//TODO: test
		pvt_iValue=(int)wValue;
	}
	int Field::getIntValue()
	{
		//TODO: test
		return (int)pvt_iValue;
	}
	void Field::setIntValue(int dwValue)
	{
		//TODO: test
		pvt_iValue=(int)dwValue;
	}
	double Field::getDoubleValue()
	{
		//TODO: test
		return pvt_dValue;
	}
	void Field::setDoubleValue(double dblValue)
	{
		//TODO: test
		pvt_dValue=dblValue;
	}
	unsigned int Field::getUIntValue()
	{
		//TODO: test
		return (unsigned int)pvt_iValue;
	}
	void Field::setUIntValue(unsigned int uiValue)
	{
		//TODO: test
		pvt_iValue=(int)uiValue;
	}
	bool Field::getBoolValue()
	{
		//TODO: test
		return pvt_bValue;
	}
	void Field::setBoolValue(bool bValue)
	{
		//TODO: test
		pvt_bValue=bValue;
	}
	System::DateTime Field::getDateValue()
	{
		//TODO: test
		return pvt_dtValue;
	}
	void Field::setDateValue(System::DateTime dtValue)
	{
		//TODO: test
		pvt_dtValue=dtValue;
	}

	/////////////////////////////////////////////////////////

	Record::Record()
	{
		//TODO: test
		pvt_oFields=gcnew System::Collections::ArrayList();
	}
	Record::~Record()
	{
		//TODO: implement, test
	}

	int Record::getOID()
	{
		return pvt_iOID;
	}
	void Record::setOID(int iOID)
	{
		pvt_iOID=iOID;
	}

	Field ^Record::getFieldByID(int iID)
	{
		Field ^retval;
		for(int i=0;i<getFieldCount();i++)
		{
			retval=getField(i);
			if(retval->getID()==iID)
				return retval;
		}
		return retval;
	}

	Field ^Record::getField(int index)
	{
		//TODO: test
		if(index<pvt_oFields->Count)
			return (Field ^)pvt_oFields[index];
		else
			throw gcnew System::Exception(L"Index out of bound in Record::getField(int index)");
	}
	void Record::addField(Field ^oField)
	{
		//TODO: test
		pvt_oFields->Add(oField);
	}
	void Record::removeField(int index)
	{
		//TODO: test
		if(index<pvt_oFields->Count)
			pvt_oFields->RemoveAt(index);
		else
			throw gcnew System::Exception(L"Index out of bound in Record::removeField(int index)");
	}

	int Record::getFieldCount()
	{
		return pvt_oFields->Count;
	}

	/////////////////////////////////////////////////////////

	Database::Database(HANDLE hDB, CEOID oid)
	{
		//TODO: test
		pvt_hDBHandle=hDB;
		pvt_iOID=oid;
	}
	Database::~Database()
	{
		//TODO: test
		CeCloseHandle(pvt_hDBHandle);
	}

	Record ^Database::getRecord(int iRecord)
	{
		//TODO: test
		Record ^retval=gcnew Record();
		WORD iPropCount=0;
		BYTE* lplpBuffer=(BYTE*)malloc(sizeof(BYTE));
		DWORD lpcbBuffer=0;
		int iEnd=1;
		iEnd=CeReadRecordProps(pvt_hDBHandle, NULL, &iPropCount, NULL, &lplpBuffer, &lpcbBuffer);
		if(lplpBuffer!=NULL)
			free(lplpBuffer);
		lplpBuffer=(BYTE*)malloc(sizeof(BYTE)*lpcbBuffer);
		iEnd=CeReadRecordProps(pvt_hDBHandle, 0, &iPropCount, NULL, &lplpBuffer, &lpcbBuffer);
		CEPROPVAL *values=(CEPROPVAL*)lplpBuffer;
		retval->setOID(iEnd);
		for(int i=0;i<iPropCount;i++)
		{
			CEPROPVAL pVal=values[i];
			Field ^fld=gcnew Field();
			fld->setID(HIWORD(pVal.propid));
			switch(LOWORD(pVal.propid))
			{
				case Field::BOOL:
					if(pVal.val.boolVal==TRUE)
						fld=gcnew Field(gcnew System::Boolean(true));
					else
						fld=gcnew Field(gcnew System::Boolean(false));
					break;
				case Field::SHORT:
					fld=gcnew Field(gcnew System::Int16(pVal.val.iVal));
					break;
				case Field::INT:
					fld=gcnew Field(gcnew System::Int32(pVal.val.lVal));
					break;
				case Field::DOUBLE:
					fld=gcnew Field(gcnew System::Double(pVal.val.dblVal));
					break;
				case Field::USHORT:
					fld=gcnew Field(gcnew System::UInt16(pVal.val.uiVal));
					break;
				case Field::UINT:
					fld=gcnew Field(gcnew System::UInt32(pVal.val.ulVal));
					break;
				case Field::STRING:
					fld=gcnew Field(gcnew System::String(pVal.val.lpwstr));
					break;
				case Field::DATETIME:
					{
						__int64 hFT2 = (((__int64) pVal.val.filetime.dwHighDateTime) << 32);
						hFT2+= pVal.val.filetime.dwLowDateTime;
						System::DateTime ^dt = gcnew System::DateTime(hFT2);
						dt=dt->AddYears(1600);		// Needed because FILETIME starts on January 1th, 1601
						fld=gcnew Field(dt);
					}
					break;
				default:
					fld=gcnew Field(gcnew System::Int32(0));
					break;
			}
			retval->addField(fld);
		}
		return retval;
	}
	bool Database::addRecord(Record ^oRecord)
	{
		//TODO: implement, test
		short iPropCount=(short)oRecord->getFieldCount();
		int iMemSize=0;
		CEPROPVAL *rgPropVal;
		for(int i=0;i<iPropCount;i++)
		{
			Field ^fld=oRecord->getField(i);
			switch(fld->getType())
			{
				case Field::BOOL:
					iMemSize+=sizeof(BOOL);
					break;
				case Field::SHORT:
					iMemSize+=sizeof(short);
					break;
				case Field::INT:
					iMemSize+=sizeof(int);
					break;
				case Field::DOUBLE:
					iMemSize+=sizeof(double);
					break;
				case Field::USHORT:
					iMemSize+=sizeof(unsigned short);
					break;
				case Field::UINT:
					iMemSize+=sizeof(unsigned int);
					break;
				case Field::STRING:
					iMemSize+=(sizeof(wchar_t*));
					break;
				case Field::DATETIME:
					iMemSize+=sizeof(FILETIME);
					break;
			}
		}
		rgPropVal=(CEPROPVAL*)malloc(iMemSize);
		memset(rgPropVal, 0, iMemSize);
		for(int i=0;i<iPropCount;i++)
		{
			CEPROPVAL val=rgPropVal[i];
			Field ^fld=oRecord->getField(i);
			val.propid=fld->getType();
			switch(fld->getType())
			{
				case Field::BOOL:
					if(fld->getBoolValue()==true)
						val.val.boolVal=TRUE;
					else
						val.val.boolVal=FALSE;
					break;
				case Field::SHORT:
					val.val.iVal=fld->getShortValue();
					break;
				case Field::INT:
					val.val.lVal=fld->getIntValue();
					break;
				case Field::DOUBLE:
					val.val.dblVal=fld->getDoubleValue();
					break;
				case Field::USHORT:
					val.val.uiVal=fld->getUShortValue();
					break;
				case Field::UINT:
					val.val.ulVal=fld->getUIntValue();
					break;
				case Field::STRING:
					val.val.lpwstr=toLPWSTR(fld->getStringValue());
					break;
				case Field::DATETIME:
					val.val.filetime=toFILETIME(fld->getDateValue());
					break;
			}
		}
		CEOID oid=CeWriteRecordProps(pvt_hDBHandle, 0, iPropCount, rgPropVal);
		for(int i=0;i<iPropCount;i++)
		{
			CEPROPVAL val=rgPropVal[i];
			Field ^fld=oRecord->getField(i);
			if(fld->getType()==Field::STRING)
				free(val.val.lpwstr);
		}
		if(oid==0)
			return false;
		else
			return true;
	}
	bool Database::removeRecord(int iRecord)
	{
		//TODO: test
		CEOID oid=0;
		DWORD dwValue=iRecord;
		DWORD lpdwIndex=0;
		oid=CeSeekDatabase(pvt_hDBHandle, CEDB_SEEK_BEGINNING, dwValue, &lpdwIndex);
		if(oid==0)
			return false;
		else
		{
			if(CeDeleteRecord(pvt_hDBHandle, oid)==TRUE)
				return true;
			else
				return false;
		}
	}
	int Database::getRecordCount()
	{
		//TODO: test
		CEOIDINFO dbinfo;
		CeOidGetInfo(pvt_iOID, &dbinfo);
		int iCount=(int)dbinfo.infDatabase.wNumRecords;
		return iCount;
	}

	System::String ^Database::getName()
	{
		//TODO: test
		return pvt_sName;
	}

	void Database::setName(System::String ^sName)
	{
		pvt_sName=sName;
	}
}
