const CONSOLE_ID = "htmlHeaderConsole";

var htmlMetaConsole = {
	
	// init event handler
	dbgHandler: {
		handleEvent : function(Ev) {
			if(DEBUGGING) {
				// getById("sidebar-box").style.width = "450px ! important";
				getById(CONSOLE_ID).setAttribute("collapsed", false);
			} else {
				getById(CONSOLE_ID).setAttribute("collapsed", true);
			}
		}
	},

	inspectDocument : function(doc) {
		window.openDialog('chrome://inspector/content/', 
		                  '_blank', 'all,dialog=no', doc);
	},
	
	dumpObject : function(o) {
		if(!DEBUGGING)
			return false;
		
		var out = "== BEGIN OBJECT ==\n";
		for (e in o) {
			out += e;
			try {
				if (typeof(o[e]) == "function")
					out += "()";
				else
					out += ": " + o[e];
			} catch(err) {
				out += ": Error: " + err;
			}
			out += '\n';
		}
		this.consoleOut(out + "== END OBJECT ==\n\n");
	},
	
	consoleOut : function(txt) {
		if(!DEBUGGING)
			return false;
		
		document.getElementById("htmlHeaderConsole").value += txt + "\n";
	},
	
	show : function() {
		var sidebar = document.getElementById("sidebar-box").collapsed;
		document.getElementById("sidebar-box").collapsed = (!sidebar) ? true : false;
	}

};

document.addEventListener('load', htmlMetaConsole.dbgHandler, true);

// shortcuts
function p(txt) { htmlMetaConsole.consoleOut(txt); }
function d(obj) { htmlMetaConsole.dumpObject(obj); }
