<?php
include_once('Field.class');
include_once('Row.class');
include_once('Preferences.class');
include_once('Form.class');
include_once('FormLabel.class');
include_once('FormRadio.class');
include_once('FormCheck.class');
include_once('FormSelect.class');
include_once('FormInput.class');
include_once('FormSubmit.class');
include_once('Column.class');
include_once('Database.class');
include_once('Preferences.class');
include_once('session.php');
include_once('Transliterate_eo_EO.class');
include_once('Transliterate_cy_GB.class');

$l10nzilla_search_lastLine = null;
$l10nzilla_search_lastRow = null;


l10nzilla_main();

// ------------------------------------------------
function l10nzilla_main()
{
global	$mySession;

	checkSession();
	setLanguage();
//showPost();
	$preferences = & new Preferences();

	$database = & new Database(
	$preferences->databaseServer,
	$preferences->databaseName,
	$preferences->databaseUser,
	$preferences->databasePassword);
	$form = & new Form("search");

	Header("Content-type: text/html; charset=UTF-8");
	$mySession->ini_page();
	l10nzilla_search_form($form,$database);
//	print $form->getHtml();
	l10nzilla_search_processActions($form,$database);
	l10nzilla_search_doSearch($form,$database);
	$mySession->end_page();
}
// ------------------------------------------------
function l10nzilla_search_form(& $form,& $database)
{
global $mySession;

	$gst = & new Group(_("File search"));
	$gst->setExtraAttributes($gst->buildAttribute("align","center") .
	$gst->buildAttribute("valign","top"));

	// -----------------------------------
	$gso = & new Group(_("Search Options"));
	$xfield = & new FormRadio("formTranslated");
	$xfield->addValue(_("All"),"all");
	$xfield->addValue(_("Untranslated"),"untranslated");
	$xfield->addValue(_("Translated"),"translated");
	$xrow = & new Row();
	$xrow->addColumn($xfield);
	$gso->addRow($xrow);
	// -----------------------------------
	$gts = & new Group(_("File Search"));
	$xrow = & new Row();
	$xfield = & new FormLabel(_("Version"));
	$xrow->addColumn($xfield);
	$xfield = & new FormSelect("formInstallID");
	$xfield->addValuesFromDB($database,"select Install_Name,Install_ID from Installs order by Install_ID");
	$xrow->addColumn($xfield);

	$xfield = & new FormLabel(_("Language"));
	$xrow->addColumn($xfield);
	$xfield = & new FormSelect("formLanguageID");
	$xfield->addValue($mySession->translatorLanguage,$mySession->translatorLanguage);
	$xrow->addColumn($xfield);
	$gts->addRow($xrow);


	$xrow = & new Row();
	$xfield = & new FormLabel(_("Location"));
	$xrow->addColumn($xfield);
	$xfield = & new FormInput("formLocation");
	$xrow->addColumn($xfield);

	$xfield = & new FormSubmit("Search",_("Search"));
	$xrow->addColumn($xfield);

	$gts->addRow($xrow);
	// -----------------------------------
	$xrow = & new Row();
	//$xrow->addColumn($geo);
	$xrow->addColumn($gso);
	$gst->addRow($xrow);
	// -----------------------------------
	$xrow = & new Row();
	$xcol = & new Column();
	$xcol->addField($gts);
	$xcol->setExtraAttributes($xcol->buildAttribute("colspan","2") .
	$xcol->buildAttribute("align","center"));
	$xrow->addColumn($xcol);
	$gst->addRow($xrow);
	$form->addGroup($gst);
}
// ------------------------------------------------
function l10nzilla_search_processActions(& $form,& $database)
{
	// Don't do anything if "search" was pressed
	if ($form->getFormValue("Search") !== FALSE)
		return;

	// Iterate over all the fields
	for ($i = 0;$i < 1000;$i++)
	{
		$rr = "RowRef__" . $i;
		$idx = $form->getFormValue($rr);
		if ($idx !== FALSE)
		{
			$now = $form->getFormValue("TranslatedString",$idx);
			$before = $form->getFormValue("_O_TranslatedString",$idx);
			if (strcmp($before,$now) != 0)
			{
//print "Processing " . $_POST["RowRef__" . $i] . "<br>";
//print "--$idx--->$before|$now<br>";

				if (strlen($before) == 0)
					l10nzilla_search_addTranslation($database,$form,$idx);
				else if (strlen($now) == 0)
					l10nzilla_search_deleteTranslation($database,$form,$idx);
				else
					l10nzilla_search_modifyTranslation($database,$form,$idx);
			}
		}
		else
			break;
	}
//showPost();
}
// ------------------------------------------------
function showPost()
{
	print "<table>";
	foreach($_POST as $key => $value)
	{
		print "<tr><td><b>$key</b></td><td>$value</td></tr>";
	}
	print "</table>";
}
// ------------------------------------------------
function l10nzilla_search_doSearch(& $form,& $database)
{
	if ($form->getFormValue("Search") === FALSE &&
	$form->getFormValue("Process") === FALSE)
	{
		print $form->getHtml();
		return null;
	}

	$sql = l10nzilla_search_getQuery($form);

	if ($sql != "")
	{
print $sql;

		$result = $database->query($sql);
		$dataGroup = l10nzilla_buildGroup($database,$result,$form);
		print $dataGroup;
	}
	return;
}
// ------------------------------------------------
function l10nzilla_buildGroup(& $database,& $result,& $form)
{
include_once("Presentation.class");

	$presentation = & new Presentation($database,$result);
		$a = array(
#		"File_Location" => "vr",
		"File_Name" => "vr",
		"Total_Labels" => "vr",
		"Proposed_Translations" => "vr",
		"Accepted_Translations" => "vr"
		);
	$presentation->registerFields($a);
		$b = array(
		"File_Location"
		);
	$presentation->setCategory($b);

	$presentation->setGlobalForm($form);

	return $presentation->getHtml();
}
// ------------------------------------------------
function l10nzilla_search_getQuery(& $form)
{
global $mySession;

	$formInstallID = $form->getFormValue("formInstallID");
	$formLocation = $form->getFormValue("formLocation");
	$formLocationAll = $formLocation . "%";
	$formLanguageID = $form->getFormValue("formLanguageID");

	$formTranslated = $form->getFormValue("formTranslated");

	if (strcmp($formTranslated,"untranslated") == 0)
		$extrasql = " and Total_Labels != Accepted_Translations ";
	else if (strcmp($formTranslated,"translated") == 0)
		$extrasql = " and Total_Labels = Accepted_Translations ";
	else
		$extrasql = "";

	if (strlen($formLocation) != 0)
		$extrasql .= " and File_Location like '$formLocationAll' ";

	$sql = "select * from Files_Statistics as fs,Files as f
	where fs.File_ID = f.File_ID and
	fs.Install_ID = $formInstallID and
	fs.Lang_ID = '$formLanguageID'
	$extrasql
	order by f.File_Location";

	return $sql;
}
// ------------------------------------------------
function ex_l10nzilla_search_getQuery(& $form)
{
global $mySession;

	$formSearchText = $form->getFormValue("formSearchText");
	$formFileName = $form->getFormValue("formFileName");
	$formInstallID = $form->getFormValue("formInstallID");
	$formLanguageID = $form->getFormValue("formLanguageID");
	$formTranslated = $form->getFormValue("formTranslated");

	if ($formSearchText == "" && $formFileName == "")
		return "";

	if (strlen($formSearchText) > 0)
	{
		if ($formLanguageID == $mySession->translatorLanguage)
		{
		$sql = "select st.SourceText_ID,st.SourceString,ils.Install_ID,
		Status_ID,ils.Label_ID,ilst.Lang_ID,Quality_ID,Files.File_ID,File_Name,File_Location,Label_Name,
		TranslatedString,tt.TranslatedText_ID,ilst.Translator_ID
		from TranslatedTexts as tt
		left join Installs_Labels_Source_Target as ilst
		using (TranslatedText_ID)
		left join Installs_Labels_Source as ils
		using(Install_ID,Label_ID,SourceText_ID)
		left join Labels as l on l.Label_ID = ils.Label_ID
		left join Files using (File_ID)
		left join SourceTexts as st
		on st.SourceText_ID = ilst.SourceText_ID";
		}
		else
		{
		$sql = "select st.SourceText_ID,st.SourceString,ils.Install_ID,
		Status_ID,ils.Label_ID,ilst.Lang_ID,File_Name,Quality_ID,Files.File_ID,File_Location,Label_Name,
		TranslatedString,tt.TranslatedText_ID,tt.Translator_ID
		from SourceTexts as st
		left join Installs_Labels_Source as ils using(SourceText_ID)
		left join Installs_Labels_Source_Target as ilst
		using (Install_ID,Label_ID,SourceText_ID)
		left join Labels as l on l.Label_ID = ils.Label_ID
		left join Files using (File_ID)
		left join TranslatedTexts as tt
		on tt.TranslatedText_ID = ilst.TranslatedText_ID";
		}

//using (Install_ID,Label_ID,SourceText_ID)
		$sql .= " where ils.Install_ID = $formInstallID ";

		$upper = strtoupper($formSearchText);

		if ($formLanguageID == $mySession->translatorLanguage)
		{
			if ($form->getFormValue("transliterateInput"))
			{
				$upper = strtoupper($mySession->transliteration->xToUnicode($formSearchText));
			}
			$sql.= " and upper(TranslatedString) like '$upper'";
		}
		else
			$sql.= " and upper(SourceString) like '$upper'";
	}
	if (strlen($formFileName) > 0)
	{
		if (strlen($formSearchText) == 0)
		{
		$sql = "select st.SourceText_ID,st.SourceString,ils.Install_ID,
		Status_ID,ils.Label_ID,File_Name,File_Location,Label_Name,
		TranslatedString
		from Files
		left join Labels using (File_ID)
		left join Installs_Labels_Source as ils using(Label_ID)
		left join Installs_Labels_Source_Target as ilst
		using (Install_ID,Label_ID,SourceText_ID)
		left join SourceTexts as st using (SourceText_ID)
		left join TranslatedTexts as tt
		on tt.TranslatedText_ID = ilst.TranslatedText_ID";

		$sql .= " where ils.Install_ID = $formInstallID ";
		}

		$upper = strtoupper($formFileName);
		$sql .= " and upper(concat(Files.File_Location,
		Files.File_Name)) like '$upper'";
	}
	/*
	if (!$form->getFormValue("formAccessKey"))
		$sql .= " and Label_Name not like \"%key\" and  Label_Name not like \"%.keybinding\" ";
	*/
	$sql .= " and SourceString not like '_' ";
	if ($formTranslated == "translated")
		$sql .= " and (KeepOriginal = 1 or
		ilst.TranslatedText_ID is not null) ";
	else if ($formTranslated == "untranslated")
		$sql .= " and (KeepOriginal = 0 and
		ilst.TranslatedText_ID is null) ";

	$sql .= " and (ilst.Lang_ID = '{$mySession->translatorLanguage}'
	or ilst.Lang_ID is null)";
	$sql .= " group by Files.File_ID,SourceString
	 order by Files.File_ID,SourceString";
//print $sql;
	return $sql;
}
// ------------------------------------------------
?>
