<?php
include_once('Field.class');
include_once('Row.class');
include_once('Preferences.class');
include_once('Form.class');
include_once('FormLabel.class');
include_once('FormRadio.class');
include_once('FormSelect.class');
include_once('FormInput.class');
include_once('FormPassword.class');
include_once('FormSubmit.class');
include_once('Column.class');
include_once('Database.class');
include_once('Preferences.class');
include_once('Transliterate_eo_EO.class');
include_once('Transliterate_cy_GB.class');
include_once('session.php');

$l10nzilla_login_lastLine = null;
$l10nzilla_login_lastRow = null;


l10nzilla_main();

// ------------------------------------------------
function l10nzilla_main()
{
global	$mySession;

	$preferences = & new Preferences();

	checkSession();

	$database = & new Database(
	$preferences->databaseServer,
	$preferences->databaseName,
	$preferences->databaseUser,
	$preferences->databasePassword);
	$form = & new Form("Login");

	l10nzilla_processActions($form,$database);

	Header("Content-type: text/html; charset=UTF-8");
	$mySession->ini_page();
//print "<h1>".  $mySession->translatorID . "</h1>";
	if ($mySession->translatorID != -1)
	{
		prologue();
		l10nzilla_form($form,$database);
		print $form->getHtml();
	}
	else
	{
		prologue_no_access();
	}
	$mySession->end_page();
}
// ------------------------------------------------
function prologue()
{
	$message = _("Your statistics will be rebuilt for the specified install");
	print "<p>$message</p>";
}
// ------------------------------------------------
function prologue_no_access()
{
	$message = _("You have no permission to rebuild the statistics.");
	print "<p>$message</p>";
}
// ------------------------------------------------
function l10nzilla_form(& $form,& $database)
{
global $mySession;

	$gtl = & new Group();
	$gtl->setExtraAttributes($gtl->buildAttribute("align","center"));

	$xrow = & new Row();

	$xfield = & new FormSelect("formInstallID");
	$xfield->addValuesFromDB($database,"select Install_Name,Install_ID from Installs order by Install_ID");
	$xrow->addColumn($xfield);

	$xfield = & new FormLabel(_("Language"));
	$xrow->addColumn($xfield);
	$xfield = & new FormSelect("formLanguageID");
	$xfield->addValue($mySession->translatorLanguage,$mySession->translatorLanguage);
	$xrow->addColumn($xfield);

	$xfield = & new FormSubmit("Build",_("Rebuild Statistics"));
	$xrow->addColumn($xfield);

	$gtl->addRow($xrow);
	$form->addGroup($gtl);
}
// ------------------------------------------------
function setFileStatisticsField(&$database,$fileID,$installID,$fieldName,$fieldValue)
{
/*
	$update_sql = "replace into Files_Statistics
	(Install_ID,File_ID,Total_Labels) values (" .
	$therow[Install_ID] . "," .
	$therow[File_ID] . "," .
	$therow[Total_Labels] .
	")";
	$database->query($update_sql);
*/
	$update_sql = "update Files_Statistics
	set $fieldName = " .
	$fieldValue .
	" where File_ID=" .
	$fileID .
	" and Install_ID=" .
	$installID;
	$database->query($update_sql);
}
// ------------------------------------------------
function l10nzilla_processActions(& $form,& $database)
{
	// Don't do anything if "Build" was not pressed
	if ($form->getFormValue("Build") === FALSE)
		return;

#	left join Installs_Labels_Source_Target on (Install_ID,Label_ID,SourceText_ID)

	// Total Labels
	// ------------
	$formInstallID = $form->getFormValue("formInstallID");
	$formLanguageID = $form->getFormValue("formLanguageID");
	$sql = "select Install_ID,l.File_ID,count(Label_Name) as Total_Labels
	from
	Installs_Labels_Source as ils,
	Labels as l, Files as f,SourceTexts as st
	where
	l.Label_ID = ils.Label_ID and
	l.File_ID = f.File_ID and
	st.SourceText_ID = ils.SourceText_ID and
	length(st.SourceString) > 1 and
	Install_ID = $formInstallID
	group by File_ID";

	$result = $database->query($sql);
	while (($therow = $database->getRow($result)) !== FALSE)
	{
		$update_sql = "replace into Files_Statistics
		(Lang_ID,Install_ID,File_ID,Total_Labels) values (" .
		"'$formLanguageID'," .
		$therow[Install_ID] . "," .
		$therow[File_ID] . "," .
		$therow[Total_Labels] .
		")";
		$database->query($update_sql);
	}
	$database->freeResult($result);

	// Total Proposed_Translations (>1)
	// ---------------------------
	$sql = "select Install_ID,l.File_ID,count(TranslatedText_ID) as Proposed_Translations
	from
	Installs_Labels_Source_Target as ilst,
	Labels as l, Files as f, SourceTexts as st
	where
	l.Label_ID = ilst.Label_ID and
	l.File_ID = f.File_ID and
	Install_ID = $formInstallID and
	st.SourceText_ID = ilst.SourceText_ID and
	length(st.SourceString) > 1
	group by File_ID";

	$result = $database->query($sql);
	while (($therow = $database->getRow($result)) !== FALSE)
	{
		setFileStatisticsField($database,
		$therow[File_ID],
		$therow[Install_ID],
		"Proposed_Translations",
		$therow[Proposed_Translations]);
	}
	$database->freeResult($result);

	// Total Proposed_AccessKeys (>1)
	// -------------------------
	$sql = "select Install_ID,l.File_ID,count(TranslatedText_ID) as Proposed_AccessKeys
	from
	Installs_Labels_Source_Target as ilst,
	Labels as l, Files as f, SourceTexts as st
	where
	l.Label_ID = ilst.Label_ID and
	l.File_ID = f.File_ID and
	Install_ID = $formInstallID and
	st.SourceText_ID = ilst.SourceText_ID and
	length(st.SourceString) = 1
	group by File_ID";

	$result = $database->query($sql);
	while (($therow = $database->getRow($result)) !== FALSE)
	{
		setFileStatisticsField($database,
		$therow[File_ID],
		$therow[Install_ID],
		"Proposed_AccessKeys",
		$therow[Proposed_AccessKeys]);
	}
	$database->freeResult($result);

	// Total AccessKeys
	// ----------------
	$sql = "select Install_ID,l.File_ID,count(ils.SourceText_ID) as Total_AccessKeys
	from
	Installs_Labels_Source as ils,
	Labels as l, Files as f, SourceTexts as st
	where
	l.Label_ID = ils.Label_ID and
	l.File_ID = f.File_ID and
	Install_ID = $formInstallID and
	st.SourceText_ID = ils.SourceText_ID and
	length(st.SourceString) = 1
	group by File_ID";

	$result = $database->query($sql);
	while (($therow = $database->getRow($result)) !== FALSE)
	{
		setFileStatisticsField($database,
		$therow[File_ID],
		$therow[Install_ID],
		"Total_AccessKeys",
		$therow[Total_AccessKeys]);
	}
	$database->freeResult($result);

	// Total Accepted_Translations
	// ---------------------------
	$sql = "select Install_ID,l.File_ID,count(Quality_ID) as Accepted_Translations
	from
	Installs_Labels_Source_Target as ilst, SourceTexts as st,
	Labels as l, Files as f, TranslatedTexts as tt
	where
	l.Label_ID = ilst.Label_ID and
	l.File_ID = f.File_ID and
	tt.TranslatedText_ID = ilst.TranslatedText_ID and 
	ilst.SourceText_ID = st.SourceText_ID and
	length(SourceString) > 1 and
	Install_ID = $formInstallID and
	(Quality_ID = 1 OR Quality_ID = 3)
	group by File_ID";

	$result = $database->query($sql);
	while (($therow = $database->getRow($result)) !== FALSE)
	{
		setFileStatisticsField($database,
		$therow[File_ID],
		$therow[Install_ID],
		"Accepted_Translations",
		$therow[Accepted_Translations]);
	}
	$database->freeResult($result);

	// Total Accepted_AccessKeys
	// ---------------------------
	$sql = "select Install_ID,l.File_ID,count(Quality_ID) as Accepted_AccessKeys
	from
	Installs_Labels_Source_Target as ilst,
	Labels as l, Files as f, TranslatedTexts as tt,SourceTexts as st
	where
	l.Label_ID = ilst.Label_ID and
	l.File_ID = f.File_ID and
	tt.TranslatedText_ID = ilst.TranslatedText_ID and 
	ilst.SourceText_ID = st.SourceText_ID and
	length(SourceString) = 1 and
	Install_ID = $formInstallID and
	(Quality_ID = 1 OR Quality_ID = 3)
	group by File_ID";

	$result = $database->query($sql);
	while (($therow = $database->getRow($result)) !== FALSE)
	{
		setFileStatisticsField($database,
		$therow[File_ID],
		$therow[Install_ID],
		"Accepted_AccessKeys",
		$therow[Accepted_AccessKeys]);
	}
	$database->freeResult($result);
	return;
}
// ------------------------------------------------
function        getInstanceOfClass($nameClass)
{
	if (class_exists($nameClass) == FALSE)
		include_once("$nameClass.class");

	$obj = & new $nameClass;

	return $obj;
}
?>
