/* -*- mode: Java; c-basic-offset: 4 -*- */
/*------------------------------------------------------------------------
 |  FILE            WebWatcher.java
 |  PART OF         WebWatcher - A web-page update monitor
 |  WRITTEN BY      Sverre H. Huseby <shh@thathost.com>
 +----------------------------------------------------------------------*/

import java.util.*;
import java.io.*;
import java.net.*;

/**
 *
 *
 * @author   Sverre H. Huseby
 *           &lt;<A HREF="mailto:shh@thathost.com">shh@thathost.com</A>&gt;
 * @version  $Id: WebWatcher.java,v 1.2 2000/09/20 19:39:24 sverrehu Exp $
 */
public class WebWatcher
implements PropertyProvider {
/*-----------------------------------------------------------------------+
 |  PRIVATE PART                                                         |
 +----------------------------------------------------------------------*/
    private Properties prop;
    private Properties defaultProp;
    private boolean    propsSaved;

    /* includes trailing separator */
    public static String getUserHome() {
        String home;
        String sep;

        sep = System.getProperty("file.separator", "/");
        home = System.getProperty("user.home", "");
        if (home.length() > 0 && !home.endsWith(sep))
            home += sep;
        return home;
    }

    private boolean isUnix() {
        return System.getProperty("file.separator").equals("/");
    }

    private void setupProperties() {
        /* set up default properties */
        defaultProp = new Properties();
        if (isUnix()) {
            /* assume some kind of Unix */
            /* browser command. %u is replaced with the url. */
            defaultProp.put("browser",
                            "netscape -remote openURL(%u,new-window)");
            defaultProp.put("alternatebrowsercommand",
                            "netscape %u");
            /* file containing status about pages */
            defaultProp.put("pagesFile",".webwatcher.pages");
            //J.S:defaultProp.put("pagesFile", getUserHome() + ".webwatcher.pages");
        } else {
            /* assume Windows. sorry, Mac folks, I don't know how to
             * identify a Mac. */
            /* browser command. %u is replaced with the url. */
            defaultProp.put("browser",
                            "c:\\Program files\\Netscape\\Netscape\\"
                            + "netscp6.exe %u");
            defaultProp.put("alternatebrowsercommand",
                            "c:\\Program files\\Netscape\\Netscape\\"
                            + "netscp6.exe %u");
            /* file containing status about pages */
            defaultProp.put("pagesFile", "C:\\XBrowser4.1\\webwatcher\\webwatcher.pages");
        }
        /* do automatic refresh of loaded and new pages? */
        defaultProp.put("refreshNew", "1");
        /* do automatic refresh at given intervals? */
        defaultProp.put("autoRefresh", "1");
        /* refresh page status every X minutes */
        defaultProp.put("refreshInterval", "30"); /* minutes */
        /* sort pages in list? */
        defaultProp.put("doSort", "1");
        /* if sorting, put changed pages first in list? */
        defaultProp.put("changedFirst", "1");
        /* when sorting, ignore case*/
        defaultProp.put("ignoreCaseInSort", "0");
        /* underlining */
        defaultProp.put("underline", "0");
        /* use of proxy server */
        defaultProp.put("useProxy", "0");
        defaultProp.put("proxy.host", "");
        defaultProp.put("proxy.port", "3128"); /* default for Squid cache */
        /* location on screen */
        defaultProp.put("screenx", "0");
        defaultProp.put("screeny", "0");
        /* size */
        defaultProp.put("width", "200");
        defaultProp.put("height", "300");

        /* and now the actual properties. */
        prop = new Properties(defaultProp);
        propsSaved = true;
    }

    private String getPropertiesFilename() {
        if (isUnix()) {
            /* assume some kind of Unix */
            return getUserHome() + ".webwatcher.cfg";
        }
        /* assume Windows. sorry, Mac folks, I don't know how to
         * identify a Mac. */
        return getUserHome() + "WebWatcher.cfg";
    }

    private void loadProperties() {
        try {
            FileInputStream fin;

            fin = new FileInputStream(getPropertiesFilename());
            prop.load(fin);
            fin.close();
        } catch (IOException e) {
        }
        propsSaved = true;
    }

/*-----------------------------------------------------------------------+
 |  PACKAGE LOCAL PART                                                   |
 +----------------------------------------------------------------------*/
    WebWatchFrame     gui;
    WebPageCollection pages;

/*-----------------------------------------------------------------------+
 |  PUBLIC INTERFACE                                                     |
 +----------------------------------------------------------------------*/
    public static void main(String[] args) {
        WebWatcher ww = new WebWatcher();
        ww.start();
    }

    public WebWatcher() {
    }

    public void start() {
        setupProperties();
        loadProperties();

        pages = new WebPageCollection(this);
        try {
            pages.load(getProperty("pagesFile"));
        } catch (IOException e) {
            System.err.println("error reading list of webpages: "
                               + e.getMessage());
        }

        gui = new WebWatchFrame(this);
        //gui.setSize(500,500);
        //gui.pack();
       // gui.show();
    }

    public void doQuit() {
        try {
            saveProperties();
            pages.save(getProperty("pagesFile"));
        } catch (IOException e) {
        }
        gui.dispose();
        System.exit(0);
    }

    /* PropertyProvider *************************************************/
    public void saveProperties()
    throws IOException {
        FileOutputStream fout;

        if (propsSaved)
            return;
        fout = new FileOutputStream(getPropertiesFilename());
        prop.store(fout, "Belongs to WebWatcher - do not edit!");
        fout.close();
        propsSaved = true;
    }

    public String getProperty(String key) {
        return prop.getProperty(key);
    }

    public void setProperty(String key, String value) {
        prop.put(key, value);
        propsSaved = false;
    }

    public int getIntProperty(String key) {
        try {
            return Integer.parseInt(prop.getProperty(key));
        } catch (NumberFormatException e) {
        }
        return 0;
    }

    public void setIntProperty(String key, int value) {
        prop.put(key, String.valueOf(value));
        propsSaved = false;
    }

    public boolean getBooleanProperty(String key) {
        return (getIntProperty(key) != 0);
    }

    public void setBooleanProperty(String key, boolean value) {
        prop.put(key, value ? "1" : "0");
        propsSaved = false;
    }
}
