/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import javax.sound.sampled.Control;

public abstract class FloatControl
extends Control {
    private float minimum;
    private float maximum;
    private float precision;
    private int updatePeriod;
    private final String units;
    private final String minLabel;
    private final String maxLabel;
    private final String midLabel;
    private float value;

    protected FloatControl(Type type, float f, float f2, float f3, int n, float f4, String string, String string2, String string3, String string4) {
        super(type);
        this.minimum = f;
        this.maximum = f2;
        this.precision = f3;
        this.updatePeriod = n;
        this.value = f4;
        this.units = string;
        this.minLabel = string2 == null ? "" : string2;
        this.midLabel = string3 == null ? "" : string3;
        this.maxLabel = string4 == null ? "" : string4;
    }

    protected FloatControl(Type type, float f, float f2, float f3, int n, float f4, String string) {
        this(type, f, f2, f3, n, f4, string, "", "", "");
    }

    public void setValue(float f) {
        if (f > this.maximum) {
            throw new IllegalArgumentException("Requested value " + f + " exceeds allowable maximum value " + this.maximum + ".");
        }
        if (f < this.minimum) {
            throw new IllegalArgumentException("Requested value " + f + " smaller than allowable minimum value " + this.minimum + ".");
        }
        this.value = f;
    }

    public float getValue() {
        return this.value;
    }

    public float getMaximum() {
        return this.maximum;
    }

    public float getMinimum() {
        return this.minimum;
    }

    public String getUnits() {
        return this.units;
    }

    public String getMinLabel() {
        return this.minLabel;
    }

    public String getMidLabel() {
        return this.midLabel;
    }

    public String getMaxLabel() {
        return this.maxLabel;
    }

    public float getPrecision() {
        return this.precision;
    }

    public int getUpdatePeriod() {
        return this.updatePeriod;
    }

    public void shift(float f, float f2, int n) {
        this.setValue(f2);
    }

    public String toString() {
        return new String(this.getType() + " with current value: " + this.value + " " + this.units + " (range: " + this.minimum + " - " + this.maximum + ")");
    }

    public static class Type
    extends Control.Type {
        public static final Type MASTER_GAIN = new Type("Master Gain");
        public static final Type AUX_SEND = new Type("AUX Send");
        public static final Type AUX_RETURN = new Type("AUX Return");
        public static final Type REVERB_SEND = new Type("Reverb Send");
        public static final Type REVERB_RETURN = new Type("Reverb Return");
        public static final Type VOLUME = new Type("Volume");
        public static final Type PAN = new Type("Pan");
        public static final Type BALANCE = new Type("Balance");
        public static final Type SAMPLE_RATE = new Type("Sample Rate");

        protected Type(String string) {
            super(string);
        }
    }
}

