/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import sun.awt.image.ByteInterleavedRaster;
import sun.awt.image.IntegerInterleavedRaster;

abstract class TexturePaintContext
implements PaintContext {
    ColorModel colorModel;
    int bWidth;
    int bHeight;
    int maxWidth;
    WritableRaster outRas;
    double xOrg;
    double yOrg;
    double incXAcross;
    double incYAcross;
    double incXDown;
    double incYDown;
    int colincx;
    int colincy;
    int colincxerr;
    int colincyerr;
    int rowincx;
    int rowincy;
    int rowincxerr;
    int rowincyerr;

    public static PaintContext getContext(BufferedImage bufferedImage, AffineTransform affineTransform, RenderingHints renderingHints, Rectangle rectangle) {
        ByteInterleavedRaster byteInterleavedRaster;
        boolean bl;
        WritableRaster writableRaster = bufferedImage.getRaster();
        ColorModel colorModel = bufferedImage.getColorModel();
        int n = rectangle.width;
        Object object = renderingHints.get(RenderingHints.KEY_INTERPOLATION);
        boolean bl2 = object == null ? renderingHints.get(RenderingHints.KEY_RENDERING) == RenderingHints.VALUE_RENDER_QUALITY : (bl = object != RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        if (writableRaster instanceof IntegerInterleavedRaster && (!bl || TexturePaintContext.isFilterableDCM(colorModel))) {
            IntegerInterleavedRaster integerInterleavedRaster = (IntegerInterleavedRaster)writableRaster;
            if (integerInterleavedRaster.getNumDataElements() == 1 && integerInterleavedRaster.getPixelStride() == 1) {
                return new Int(integerInterleavedRaster, colorModel, affineTransform, n, bl);
            }
        } else if (writableRaster instanceof ByteInterleavedRaster && (byteInterleavedRaster = (ByteInterleavedRaster)writableRaster).getNumDataElements() == 1 && byteInterleavedRaster.getPixelStride() == 1) {
            if (bl) {
                if (TexturePaintContext.isFilterableICM(colorModel)) {
                    return new ByteFilter(byteInterleavedRaster, colorModel, affineTransform, n);
                }
            } else {
                return new Byte(byteInterleavedRaster, colorModel, affineTransform, n);
            }
        }
        return new Any(writableRaster, colorModel, affineTransform, n, bl);
    }

    public static boolean isFilterableICM(ColorModel colorModel) {
        IndexColorModel indexColorModel;
        return colorModel instanceof IndexColorModel && (indexColorModel = (IndexColorModel)colorModel).getMapSize() <= 256;
    }

    public static boolean isFilterableDCM(ColorModel colorModel) {
        if (colorModel instanceof DirectColorModel) {
            DirectColorModel directColorModel = (DirectColorModel)colorModel;
            return TexturePaintContext.isMaskOK(directColorModel.getAlphaMask(), true) && TexturePaintContext.isMaskOK(directColorModel.getRedMask(), false) && TexturePaintContext.isMaskOK(directColorModel.getGreenMask(), false) && TexturePaintContext.isMaskOK(directColorModel.getBlueMask(), false);
        }
        return false;
    }

    public static boolean isMaskOK(int n, boolean bl) {
        if (bl && n == 0) {
            return true;
        }
        return n == 255 || n == 65280 || n == 0xFF0000 || n == -16777216;
    }

    TexturePaintContext(ColorModel colorModel, AffineTransform affineTransform, int n, int n2, int n3) {
        this.colorModel = colorModel;
        this.bWidth = n;
        this.bHeight = n2;
        this.maxWidth = n3;
        try {
            affineTransform = affineTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            affineTransform.setToScale(0.0, 0.0);
        }
        this.incXAcross = TexturePaintContext.mod(affineTransform.getScaleX(), n);
        this.incYAcross = TexturePaintContext.mod(affineTransform.getShearY(), n2);
        this.incXDown = TexturePaintContext.mod(affineTransform.getShearX(), n);
        this.incYDown = TexturePaintContext.mod(affineTransform.getScaleY(), n2);
        this.xOrg = affineTransform.getTranslateX();
        this.yOrg = affineTransform.getTranslateY();
        this.colincx = (int)this.incXAcross;
        this.colincy = (int)this.incYAcross;
        this.colincxerr = TexturePaintContext.fractAsInt(this.incXAcross);
        this.colincyerr = TexturePaintContext.fractAsInt(this.incYAcross);
        this.rowincx = (int)this.incXDown;
        this.rowincy = (int)this.incYDown;
        this.rowincxerr = TexturePaintContext.fractAsInt(this.incXDown);
        this.rowincyerr = TexturePaintContext.fractAsInt(this.incYDown);
    }

    static int fractAsInt(double d) {
        return (int)(d % 1.0 * 2.147483647E9);
    }

    static double mod(double d, double d2) {
        if ((d %= d2) < 0.0 && (d += d2) >= d2) {
            d = 0.0;
        }
        return d;
    }

    public void dispose() {
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public Raster getRaster(int n, int n2, int n3, int n4) {
        if (this.outRas == null || this.outRas.getWidth() < n3 || this.outRas.getHeight() < n4) {
            this.outRas = this.makeRaster(n4 == 1 ? Math.max(n3, this.maxWidth) : n3, n4);
        }
        double d = TexturePaintContext.mod(this.xOrg + (double)n * this.incXAcross + (double)n2 * this.incXDown, this.bWidth);
        double d2 = TexturePaintContext.mod(this.yOrg + (double)n * this.incYAcross + (double)n2 * this.incYDown, this.bHeight);
        this.setRaster((int)d, (int)d2, TexturePaintContext.fractAsInt(d), TexturePaintContext.fractAsInt(d2), n3, n4, this.bWidth, this.bHeight, this.colincx, this.colincxerr, this.colincy, this.colincyerr, this.rowincx, this.rowincxerr, this.rowincy, this.rowincyerr);
        return this.outRas;
    }

    public abstract WritableRaster makeRaster(int var1, int var2);

    public abstract void setRaster(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16);

    public static int blend(int[] nArray, int n, int n2) {
        n >>>= 19;
        n2 >>>= 19;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < 4) {
            int n8;
            int n9 = nArray[n7];
            n = 4096 - n;
            if ((n7 & 1) == 0) {
                n2 = 4096 - n2;
            }
            if ((n8 = n * n2) != 0) {
                n6 += (n9 >>> 24) * n8;
                n5 += (n9 >>> 16 & 0xFF) * n8;
                n4 += (n9 >>> 8 & 0xFF) * n8;
                n3 += (n9 & 0xFF) * n8;
            }
            ++n7;
        }
        return n6 + 0x800000 >>> 24 << 24 | n5 + 0x800000 >>> 24 << 16 | n4 + 0x800000 >>> 24 << 8 | n3 + 0x800000 >>> 24;
    }

    static class Any
    extends TexturePaintContext {
        WritableRaster srcRas;
        boolean filter;

        public Any(WritableRaster writableRaster, ColorModel colorModel, AffineTransform affineTransform, int n, boolean bl) {
            super(colorModel, affineTransform, writableRaster.getWidth(), writableRaster.getHeight(), n);
            this.srcRas = writableRaster;
            this.filter = bl;
        }

        public WritableRaster makeRaster(int n, int n2) {
            return this.srcRas.createCompatibleWritableRaster(n, n2);
        }

        public void setRaster(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16) {
            Object object = null;
            int n17 = n;
            int n18 = n2;
            int n19 = n3;
            int n20 = n4;
            WritableRaster writableRaster = this.srcRas;
            WritableRaster writableRaster2 = this.outRas;
            int[] nArray = this.filter ? new int[4] : null;
            int n21 = 0;
            while (n21 < n6) {
                n = n17;
                n2 = n18;
                n3 = n19;
                n4 = n20;
                int n22 = 0;
                while (n22 < n5) {
                    object = writableRaster.getDataElements(n, n2, object);
                    if (this.filter) {
                        int n23;
                        int n24 = n + 1;
                        if (n24 >= n7) {
                            n24 = 0;
                        }
                        if ((n23 = n2 + 1) >= n8) {
                            n23 = 0;
                        }
                        nArray[0] = this.colorModel.getRGB(object);
                        object = writableRaster.getDataElements(n24, n2, object);
                        nArray[1] = this.colorModel.getRGB(object);
                        object = writableRaster.getDataElements(n, n23, object);
                        nArray[2] = this.colorModel.getRGB(object);
                        object = writableRaster.getDataElements(n24, n23, object);
                        nArray[3] = this.colorModel.getRGB(object);
                        int n25 = TexturePaintContext.blend(nArray, n3, n4);
                        object = this.colorModel.getDataElements(n25, object);
                    }
                    writableRaster2.setDataElements(n22, n21, object);
                    if ((n3 += n10) < 0) {
                        n3 &= Integer.MAX_VALUE;
                        ++n;
                    }
                    if ((n += n9) >= n7) {
                        n -= n7;
                    }
                    if ((n4 += n12) < 0) {
                        n4 &= Integer.MAX_VALUE;
                        ++n2;
                    }
                    if ((n2 += n11) >= n8) {
                        n2 -= n8;
                    }
                    ++n22;
                }
                if ((n19 += n14) < 0) {
                    n19 &= Integer.MAX_VALUE;
                    ++n17;
                }
                if ((n17 += n13) >= n7) {
                    n17 -= n7;
                }
                if ((n20 += n16) < 0) {
                    n20 &= Integer.MAX_VALUE;
                    ++n18;
                }
                if ((n18 += n15) >= n8) {
                    n18 -= n8;
                }
                ++n21;
            }
        }
    }

    static class ByteFilter
    extends TexturePaintContext {
        ByteInterleavedRaster srcRas;
        int[] inPalette = new int[256];
        byte[] inData;
        int inOff;
        int inSpan;
        int[] outData;
        int outOff;
        int outSpan;
        public static ColorModel xrgbmodel = new DirectColorModel(24, 0xFF0000, 65280, 255);
        public static ColorModel argbmodel = ColorModel.getRGBdefault();

        public ByteFilter(ByteInterleavedRaster byteInterleavedRaster, ColorModel colorModel, AffineTransform affineTransform, int n) {
            super(colorModel.getTransparency() == 1 ? xrgbmodel : argbmodel, affineTransform, byteInterleavedRaster.getWidth(), byteInterleavedRaster.getHeight(), n);
            ((IndexColorModel)colorModel).getRGBs(this.inPalette);
            this.srcRas = byteInterleavedRaster;
            this.inData = byteInterleavedRaster.getDataStorage();
            this.inSpan = byteInterleavedRaster.getScanlineStride();
            this.inOff = byteInterleavedRaster.getDataOffset(0);
        }

        public WritableRaster makeRaster(int n, int n2) {
            WritableRaster writableRaster = this.colorModel.createCompatibleWritableRaster(n, n2);
            IntegerInterleavedRaster integerInterleavedRaster = (IntegerInterleavedRaster)writableRaster;
            this.outData = integerInterleavedRaster.getDataStorage();
            this.outSpan = integerInterleavedRaster.getScanlineStride();
            this.outOff = integerInterleavedRaster.getDataOffset(0);
            return writableRaster;
        }

        public void setRaster(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16) {
            byte[] byArray = this.inData;
            int[] nArray = this.outData;
            int n17 = this.outOff;
            int n18 = this.inSpan;
            int n19 = this.inOff;
            int n20 = this.outSpan;
            int n21 = n;
            int n22 = n2;
            int n23 = n3;
            int n24 = n4;
            int[] nArray2 = new int[4];
            int n25 = 0;
            while (n25 < n6) {
                n = n21;
                n2 = n22;
                n3 = n23;
                n4 = n24;
                int n26 = 0;
                while (n26 < n5) {
                    int n27;
                    int n28 = n + 1;
                    if (n28 >= n7) {
                        n28 = 0;
                    }
                    if ((n27 = n2 + 1) >= n8) {
                        n27 = 0;
                    }
                    nArray2[0] = this.inPalette[0xFF & byArray[n19 + n + n18 * n2]];
                    nArray2[1] = this.inPalette[0xFF & byArray[n19 + n28 + n18 * n2]];
                    nArray2[2] = this.inPalette[0xFF & byArray[n19 + n + n18 * n27]];
                    nArray2[3] = this.inPalette[0xFF & byArray[n19 + n28 + n18 * n27]];
                    nArray[n17 + n26] = TexturePaintContext.blend(nArray2, n3, n4);
                    if ((n3 += n10) < 0) {
                        n3 &= Integer.MAX_VALUE;
                        ++n;
                    }
                    if ((n += n9) >= n7) {
                        n -= n7;
                    }
                    if ((n4 += n12) < 0) {
                        n4 &= Integer.MAX_VALUE;
                        ++n2;
                    }
                    if ((n2 += n11) >= n8) {
                        n2 -= n8;
                    }
                    ++n26;
                }
                if ((n23 += n14) < 0) {
                    n23 &= Integer.MAX_VALUE;
                    ++n21;
                }
                if ((n21 += n13) >= n7) {
                    n21 -= n7;
                }
                if ((n24 += n16) < 0) {
                    n24 &= Integer.MAX_VALUE;
                    ++n22;
                }
                if ((n22 += n15) >= n8) {
                    n22 -= n8;
                }
                n17 += n20;
                ++n25;
            }
        }
    }

    static class Byte
    extends TexturePaintContext {
        ByteInterleavedRaster srcRas;
        byte[] inData;
        int inOff;
        int inSpan;
        byte[] outData;
        int outOff;
        int outSpan;

        public Byte(ByteInterleavedRaster byteInterleavedRaster, ColorModel colorModel, AffineTransform affineTransform, int n) {
            super(colorModel, affineTransform, byteInterleavedRaster.getWidth(), byteInterleavedRaster.getHeight(), n);
            this.srcRas = byteInterleavedRaster;
            this.inData = byteInterleavedRaster.getDataStorage();
            this.inSpan = byteInterleavedRaster.getScanlineStride();
            this.inOff = byteInterleavedRaster.getDataOffset(0);
        }

        public WritableRaster makeRaster(int n, int n2) {
            WritableRaster writableRaster = this.srcRas.createCompatibleWritableRaster(n, n2);
            ByteInterleavedRaster byteInterleavedRaster = (ByteInterleavedRaster)writableRaster;
            this.outData = byteInterleavedRaster.getDataStorage();
            this.outSpan = byteInterleavedRaster.getScanlineStride();
            this.outOff = byteInterleavedRaster.getDataOffset(0);
            return writableRaster;
        }

        public void setRaster(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16) {
            byte[] byArray = this.inData;
            byte[] byArray2 = this.outData;
            int n17 = this.outOff;
            int n18 = this.inSpan;
            int n19 = this.inOff;
            int n20 = this.outSpan;
            boolean bl = n9 == 1 && n10 == 0 && n11 == 0 && n12 == 0;
            int n21 = n;
            int n22 = n2;
            int n23 = n3;
            int n24 = n4;
            if (bl) {
                n20 -= n5;
            }
            int n25 = 0;
            while (n25 < n6) {
                int n26;
                if (bl) {
                    int n27;
                    n26 = n19 + n22 * n18 + n7;
                    n = n7 - n21;
                    n17 += n5;
                    if (n7 >= 32) {
                        n27 = n5;
                        while (n27 > 0) {
                            int n28 = n27 < n ? n27 : n;
                            System.arraycopy(byArray, n26 - n, byArray2, n17 - n27, n28);
                            n27 -= n28;
                            if ((n -= n28) != 0) continue;
                            n = n7;
                        }
                    } else {
                        n27 = n5;
                        while (n27 > 0) {
                            byArray2[n17 - n27] = byArray[n26 - n];
                            if (--n == 0) {
                                n = n7;
                            }
                            --n27;
                        }
                    }
                } else {
                    n = n21;
                    n2 = n22;
                    n3 = n23;
                    n4 = n24;
                    n26 = 0;
                    while (n26 < n5) {
                        byArray2[n17 + n26] = byArray[n19 + n2 * n18 + n];
                        if ((n3 += n10) < 0) {
                            n3 &= Integer.MAX_VALUE;
                            ++n;
                        }
                        if ((n += n9) >= n7) {
                            n -= n7;
                        }
                        if ((n4 += n12) < 0) {
                            n4 &= Integer.MAX_VALUE;
                            ++n2;
                        }
                        if ((n2 += n11) >= n8) {
                            n2 -= n8;
                        }
                        ++n26;
                    }
                }
                if ((n23 += n14) < 0) {
                    n23 &= Integer.MAX_VALUE;
                    ++n21;
                }
                if ((n21 += n13) >= n7) {
                    n21 -= n7;
                }
                if ((n24 += n16) < 0) {
                    n24 &= Integer.MAX_VALUE;
                    ++n22;
                }
                if ((n22 += n15) >= n8) {
                    n22 -= n8;
                }
                n17 += n20;
                ++n25;
            }
        }
    }

    static class Int
    extends TexturePaintContext {
        IntegerInterleavedRaster srcRas;
        int[] inData;
        int inOff;
        int inSpan;
        int[] outData;
        int outOff;
        int outSpan;
        boolean filter;

        public Int(IntegerInterleavedRaster integerInterleavedRaster, ColorModel colorModel, AffineTransform affineTransform, int n, boolean bl) {
            super(colorModel, affineTransform, integerInterleavedRaster.getWidth(), integerInterleavedRaster.getHeight(), n);
            this.srcRas = integerInterleavedRaster;
            this.inData = integerInterleavedRaster.getDataStorage();
            this.inSpan = integerInterleavedRaster.getScanlineStride();
            this.inOff = integerInterleavedRaster.getDataOffset(0);
            this.filter = bl;
        }

        public WritableRaster makeRaster(int n, int n2) {
            WritableRaster writableRaster = this.srcRas.createCompatibleWritableRaster(n, n2);
            IntegerInterleavedRaster integerInterleavedRaster = (IntegerInterleavedRaster)writableRaster;
            this.outData = integerInterleavedRaster.getDataStorage();
            this.outSpan = integerInterleavedRaster.getScanlineStride();
            this.outOff = integerInterleavedRaster.getDataOffset(0);
            return writableRaster;
        }

        public void setRaster(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16) {
            int[] nArray = this.inData;
            int[] nArray2 = this.outData;
            int n17 = this.outOff;
            int n18 = this.inSpan;
            int n19 = this.inOff;
            int n20 = this.outSpan;
            boolean bl = this.filter;
            boolean bl2 = n9 == 1 && n10 == 0 && n11 == 0 && n12 == 0 && !bl;
            int n21 = n;
            int n22 = n2;
            int n23 = n3;
            int n24 = n4;
            if (bl2) {
                n20 -= n5;
            }
            int[] nArray3 = bl ? new int[4] : null;
            int n25 = 0;
            while (n25 < n6) {
                int n26;
                int n27;
                int n28;
                if (bl2) {
                    n28 = n19 + n22 * n18 + n7;
                    n = n7 - n21;
                    n17 += n5;
                    if (n7 >= 32) {
                        n27 = n5;
                        while (n27 > 0) {
                            n26 = n27 < n ? n27 : n;
                            System.arraycopy(nArray, n28 - n, nArray2, n17 - n27, n26);
                            n27 -= n26;
                            if ((n -= n26) != 0) continue;
                            n = n7;
                        }
                    } else {
                        n27 = n5;
                        while (n27 > 0) {
                            nArray2[n17 - n27] = nArray[n28 - n];
                            if (--n == 0) {
                                n = n7;
                            }
                            --n27;
                        }
                    }
                } else {
                    n = n21;
                    n2 = n22;
                    n3 = n23;
                    n4 = n24;
                    n28 = 0;
                    while (n28 < n5) {
                        if (bl) {
                            n27 = n + 1;
                            if (n27 >= n7) {
                                n27 = 0;
                            }
                            if ((n26 = n2 + 1) >= n8) {
                                n26 = 0;
                            }
                            nArray3[0] = nArray[n19 + n2 * n18 + n];
                            nArray3[1] = nArray[n19 + n2 * n18 + n27];
                            nArray3[2] = nArray[n19 + n26 * n18 + n];
                            nArray3[3] = nArray[n19 + n26 * n18 + n27];
                            nArray2[n17 + n28] = TexturePaintContext.blend(nArray3, n3, n4);
                        } else {
                            nArray2[n17 + n28] = nArray[n19 + n2 * n18 + n];
                        }
                        if ((n3 += n10) < 0) {
                            n3 &= Integer.MAX_VALUE;
                            ++n;
                        }
                        if ((n += n9) >= n7) {
                            n -= n7;
                        }
                        if ((n4 += n12) < 0) {
                            n4 &= Integer.MAX_VALUE;
                            ++n2;
                        }
                        if ((n2 += n11) >= n8) {
                            n2 -= n8;
                        }
                        ++n28;
                    }
                }
                if ((n23 += n14) < 0) {
                    n23 &= Integer.MAX_VALUE;
                    ++n21;
                }
                if ((n21 += n13) >= n7) {
                    n21 -= n7;
                }
                if ((n24 += n16) < 0) {
                    n24 &= Integer.MAX_VALUE;
                    ++n22;
                }
                if ((n22 += n15) >= n8) {
                    n22 -= n8;
                }
                n17 += n20;
                ++n25;
            }
        }
    }
}

