/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.webclient.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import org.mozilla.util.Assert;
import org.mozilla.util.ParameterCheck;

public class RandomHTMLInputStream
extends InputStream {
    private static final int MAX_AVAILABLE = 4096;
    private static final int EXCEPTION_DIVISOR = 179;
    private static final byte[] CHARSET;
    private Random random;
    private boolean isClosed;
    private boolean firstRead;
    private int numReads;
    private int available;

    public RandomHTMLInputStream(int n) {
        ParameterCheck.greaterThan(n, 1);
        this.random = new Random();
        Assert.assert_it(null != this.random);
        this.isClosed = false;
        this.firstRead = true;
        this.numReads = n;
        this.available = this.random.nextInt(4096);
    }

    public int available() throws IOException {
        if (this.shouldThrowException()) {
            throw new IOException("It's time for an IOException!");
        }
        int n = this.isClosed ? -1 : this.available;
        return n;
    }

    public int read() throws IOException {
        int n = 0;
        if (this.shouldThrowException()) {
            throw new IOException("It's time for an IOException!");
        }
        if (0 < this.available) {
            n = 97;
            --this.available;
        } else {
            n = -1;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.shouldThrowException()) {
            throw new IOException("It's time for an IOException!");
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        if (0 == this.numReads || this.isClosed) {
            return -1;
        }
        n4 = n2 <= this.available ? n2 : this.available;
        if (this.firstRead) {
            String string = "<HTML><BODY><PRE>START Random Data";
            n5 = string.length();
            if (n5 < n2 && n2 <= this.available) {
                byte[] byArray2 = string.getBytes();
                n3 = 0;
                while (n3 < n5) {
                    byArray[n + n3] = byArray2[n3];
                    ++n3;
                }
                this.available -= n5;
            } else {
                n3 = 0;
                while (n3 < n4) {
                    byArray[n + n3] = (byte)this.random.nextInt(8);
                    ++n3;
                }
                n5 = n4;
                this.available -= n4;
            }
            this.firstRead = false;
        } else if (1 == this.numReads) {
            String string = "\nEND Random Data</PRE></BODY></HTML>";
            n5 = string.length();
            if (n5 < n2 && n2 <= this.available) {
                byte[] byArray3 = string.getBytes();
                n3 = 0;
                while (n3 < n5) {
                    byArray[n + n3] = byArray3[n3];
                    ++n3;
                }
                this.available -= n5;
            } else {
                n3 = 0;
                while (n3 < n4) {
                    byArray[n + n3] = (byte)this.random.nextInt(8);
                    ++n3;
                }
                n5 = n4;
                this.available -= n4;
            }
        } else {
            if (this.random.nextBoolean()) {
                try {
                    System.out.println("RandomHTMLInputStream:: sleeping");
                    Thread.sleep(3000L);
                }
                catch (Exception exception) {
                    throw new IOException(exception.getMessage());
                }
            }
            byte[] byArray4 = new byte[n4];
            n3 = 0;
            while (n3 < n4) {
                byArray[n + n3] = 0 == n3 % 78 ? 10 : CHARSET[this.random.nextInt(CHARSET.length)];
                ++n3;
            }
            n5 = n4;
            this.available -= n4;
        }
        this.available = this.random.nextInt(4096);
        --this.numReads;
        return n5;
    }

    public void close() throws IOException {
        if (this.shouldThrowException()) {
            throw new IOException("It's time for an IOException!");
        }
        this.isClosed = true;
    }

    private boolean shouldThrowException() {
        int n = this.random.nextInt(10000);
        boolean bl = false;
        if (n > 179) {
            bl = 0 == n % 179;
        }
        return bl;
    }

    static {
        String string = " abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890[]{}";
        CHARSET = string.getBytes();
    }
}

