/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.webclient.test;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.tree.TreeModel;
import org.mozilla.util.Assert;
import org.mozilla.webclient.BookmarkEntry;
import org.mozilla.webclient.Bookmarks;
import org.mozilla.webclient.BrowserControl;
import org.mozilla.webclient.BrowserControlCanvas;
import org.mozilla.webclient.BrowserControlFactory;
import org.mozilla.webclient.CurrentPage;
import org.mozilla.webclient.DocumentLoadEvent;
import org.mozilla.webclient.DocumentLoadListener;
import org.mozilla.webclient.EventRegistration;
import org.mozilla.webclient.History;
import org.mozilla.webclient.Navigation;
import org.mozilla.webclient.Navigation2;
import org.mozilla.webclient.PrefChangedCallback;
import org.mozilla.webclient.Preferences;
import org.mozilla.webclient.ProfileManager;
import org.mozilla.webclient.Prompt;
import org.mozilla.webclient.WCMouseEvent;
import org.mozilla.webclient.WebclientEvent;
import org.mozilla.webclient.test.BookmarksFrame;
import org.mozilla.webclient.test.DOMViewerFrame;
import org.mozilla.webclient.test.DialogClient;
import org.mozilla.webclient.test.EmbeddedMozilla;
import org.mozilla.webclient.test.FindDialog;
import org.mozilla.webclient.test.PasswordDialog;
import org.mozilla.webclient.test.RandomHTMLInputStream;
import org.mozilla.webclient.test.UniversalDialog;
import org.w3c.dom.Document;

public class EMWindow
extends Frame
implements DialogClient,
ActionListener,
DocumentLoadListener,
MouseListener,
Prompt,
PrefChangedCallback {
    static final int defaultWidth = 640;
    static final int defaultHeight = 480;
    private int winNum;
    private TextField urlField;
    private BrowserControl browserControl;
    private BrowserControlCanvas browserCanvas;
    private Navigation2 navigation = null;
    private CurrentPage currentPage;
    private History history;
    private static Preferences prefs;
    private Bookmarks bookmarks;
    private BookmarksFrame bookmarksFrame = null;
    private TreeModel bookmarksTree;
    private DOMViewerFrame domViewer;
    private Panel controlPanel;
    private Panel statusPanel;
    private Panel buttonsPanel;
    private FindDialog findDialog = null;
    private PasswordDialog passDialog = null;
    private UniversalDialog uniDialog = null;
    private MenuBar menuBar;
    private Menu historyMenu;
    private MenuItem backMenuItem;
    private MenuItem forwardMenuItem;
    private HistoryActionListener historyActionListener = null;
    private Menu bookmarksMenu;
    private Label statusLabel;
    private Label urlStatusLabel;
    private String currentURL;
    private Document currentDocument = null;
    private EmbeddedMozilla creator;
    private Component forwardButton;
    private Component backButton;
    private Component stopButton;
    private Component refreshButton;
    private PopupMenu popup = new PopupMenu();
    private MenuItem popup_ViewSource;
    private MenuItem popup_SelectAll;
    private PopupActionListener contextListener;
    private ProfileManager profileManager = null;
    private String myBinDir;

    public static void main(String[] stringArray) {
    }

    public EMWindow(String string, String string2, String string3, int n, EmbeddedMozilla embeddedMozilla) {
        super(string);
        Object object;
        this.creator = embeddedMozilla;
        this.currentURL = string3;
        this.winNum = n;
        this.myBinDir = string2;
        System.out.println("constructed with binDir: " + string2 + " url: " + string3);
        ((Component)this).setSize(640, 480);
        this.menuBar = new MenuBar();
        this.setMenuBar(this.menuBar);
        Menu menu = new Menu("File");
        Menu menu2 = new Menu("View");
        Menu menu3 = new Menu("Search");
        Menu menu4 = new Menu("Edit");
        Menu menu5 = new Menu("Profile");
        MenuItem menuItem = new MenuItem("New Window");
        MenuItem menuItem2 = new MenuItem("Close");
        MenuItem menuItem3 = new MenuItem("Find");
        MenuItem menuItem4 = new MenuItem("Find Next");
        MenuItem menuItem5 = new MenuItem("View Page Source as String");
        MenuItem menuItem6 = new MenuItem("View Page Info");
        MenuItem menuItem7 = new MenuItem("Select All");
        MenuItem menuItem8 = new MenuItem("Copy");
        MenuItem menuItem9 = new MenuItem("Create Profile");
        MenuItem menuItem10 = new MenuItem("Delete Profile");
        this.menuBar.add(menu);
        this.menuBar.add(menu2);
        this.menuBar.add(menu3);
        this.menuBar.add(menu4);
        this.menuBar.add(menu5);
        menu5.add(menuItem9);
        menuItem9.addActionListener(this);
        menu5.add(menuItem10);
        menuItem10.addActionListener(this);
        menu.add(menuItem);
        menuItem.addActionListener(this);
        menu.add(menuItem2);
        menuItem2.addActionListener(this);
        menu3.add(menuItem3);
        menuItem3.addActionListener(this);
        menu3.add(menuItem4);
        menuItem4.addActionListener(this);
        this.historyMenu = new Menu("History");
        this.backMenuItem = new MenuItem("Back");
        this.backMenuItem.addActionListener(this);
        this.historyMenu.add(this.backMenuItem);
        this.forwardMenuItem = new MenuItem("Forward");
        this.forwardMenuItem.addActionListener(this);
        this.historyMenu.add(this.forwardMenuItem);
        this.menuBar.add(this.historyMenu);
        this.bookmarksMenu = new Menu("Bookmarks");
        MenuItem menuItem11 = new MenuItem("Add Current Page");
        menuItem11.addActionListener(this);
        this.bookmarksMenu.add(menuItem11);
        menuItem11 = new MenuItem("Add Current Page In New Folder");
        menuItem11.addActionListener(this);
        this.bookmarksMenu.add(menuItem11);
        MenuItem menuItem12 = new MenuItem("Manage Bookmarks...");
        menuItem12.addActionListener(this);
        this.bookmarksMenu.add(menuItem12);
        this.menuBar.add(this.bookmarksMenu);
        Menu menu6 = new Menu("Stream");
        MenuItem menuItem13 = new MenuItem("Load Stream From File...");
        menuItem13.addActionListener(this);
        menu6.add(menuItem13);
        MenuItem menuItem14 = new MenuItem("Load Random HTML InputStream");
        menuItem14.addActionListener(this);
        menu6.add(menuItem14);
        this.menuBar.add(menu6);
        menu2.add(menuItem5);
        menuItem5.addActionListener(this);
        menu2.add(menuItem6);
        menuItem6.addActionListener(this);
        menu4.add(menuItem7);
        menuItem7.addActionListener(this);
        menu4.add(menuItem8);
        menuItem8.addActionListener(this);
        this.urlField = new TextField("", 30);
        this.urlField.addActionListener(this);
        this.urlField.setText(string3);
        this.buttonsPanel = new Panel();
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.backButton = this.makeItem(this.buttonsPanel, "Back", 0, 0, 1, 1, 0.0, 0.0);
        this.backButton.setEnabled(false);
        this.forwardButton = this.makeItem(this.buttonsPanel, "Forward", 1, 0, 1, 1, 0.0, 0.0);
        this.forwardButton.setEnabled(false);
        this.stopButton = this.makeItem(this.buttonsPanel, "Stop", 2, 0, 1, 1, 0.0, 0.0);
        this.stopButton.setEnabled(false);
        this.refreshButton = this.makeItem(this.buttonsPanel, "Refresh", 3, 0, 1, 1, 0.0, 0.0);
        this.refreshButton.setEnabled(false);
        this.makeItem(this.buttonsPanel, "DOMViewer", 4, 0, 1, 1, 0.0, 0.0);
        this.makeItem(this.buttonsPanel, "POST", 5, 0, 1, 1, 0.0, 0.0);
        this.controlPanel = new Panel();
        this.controlPanel.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.urlField, "North");
        this.controlPanel.add((Component)panel, "Center");
        this.controlPanel.add((Component)this.buttonsPanel, "West");
        this.statusPanel = new Panel();
        this.statusPanel.setLayout(new BorderLayout());
        this.statusLabel = new Label("", 0);
        this.statusLabel.setBackground(Color.lightGray);
        this.urlStatusLabel = new Label("", 0);
        this.urlStatusLabel.setBackground(Color.lightGray);
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)this.statusLabel, "North");
        panel2.add((Component)this.urlStatusLabel, "South");
        this.statusPanel.add((Component)panel2, "Center");
        try {
            BrowserControlFactory.setAppData(string2);
            this.browserControl = BrowserControlFactory.newBrowserControl();
            this.browserCanvas = (BrowserControlCanvas)this.browserControl.queryInterface("webclient.BrowserControlCanvas");
        }
        catch (Exception exception) {
            System.out.println("Can't create BrowserControl: " + exception.getMessage());
        }
        Assert.assert_it(null != this.browserCanvas);
        this.browserCanvas.setSize(640, 480);
        this.add((Component)this.controlPanel, "North");
        this.add((Component)this.browserCanvas, "Center");
        this.add((Component)this.statusPanel, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.out.println("Got windowClosing");
                System.out.println("destroying the BrowserControl");
                EMWindow.this.delete();
                EMWindow.this.creator.DestroyEMWindow(EMWindow.this.winNum);
            }

            public void windowClosed(WindowEvent windowEvent) {
                System.out.println("Got windowClosed");
            }
        });
        this.add(this.popup);
        this.popup_ViewSource = new MenuItem("View Source as ByteArray");
        this.popup.add(this.popup_ViewSource);
        this.popup_SelectAll = new MenuItem("Select All");
        this.popup.add(this.popup_SelectAll);
        this.contextListener = new PopupActionListener();
        this.popup_ViewSource.addActionListener(this.contextListener);
        this.popup_SelectAll.addActionListener(this.contextListener);
        this.show();
        this.toFront();
        try {
            this.navigation = (Navigation2)this.browserControl.queryInterface("webclient.Navigation");
            this.navigation.setPrompt(this);
            this.currentPage = (CurrentPage)this.browserControl.queryInterface("webclient.CurrentPage");
            this.history = (History)this.browserControl.queryInterface("webclient.History");
            prefs = (Preferences)this.browserControl.queryInterface("webclient.Preferences");
            prefs.registerPrefChangedCallback(this, "network.cookie.warnAboutCookies", "This IS the Closure!");
            prefs.setPref("network.cookie.warnAboutCookies", "true");
            prefs.setPref("browser.cache.disk_cache_size", "0");
            object = prefs.getPrefs();
            String string4 = (String)((Hashtable)object).get("network.proxy.http");
            String string5 = (String)((Hashtable)object).get("network.proxy.http_port");
            if (null != string4 && null != string5) {
                System.setProperty("http.proxyHost", string4);
                System.setProperty("http.proxyPort", string5);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        try {
            object = (EventRegistration)this.browserControl.queryInterface("webclient.EventRegistration");
            object.addDocumentLoadListener(this);
            object.addMouseListener(this);
            this.bookmarks = (Bookmarks)this.browserControl.queryInterface("webclient.Bookmarks");
            System.out.println("debug: edburns: got Bookmarks instance");
            this.bookmarksTree = this.bookmarks.getBookmarks();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        if (null != this.navigation) {
            this.navigation.loadURL(string3);
        }
    }

    public void delete() {
        this.browserCanvas.setVisible(false);
        if (null != this.bookmarksFrame) {
            ((Component)this.bookmarksFrame).setVisible(false);
            this.bookmarksFrame.dispose();
            this.bookmarksFrame = null;
        }
        if (null != this.domViewer) {
            ((Component)this.domViewer).setVisible(false);
            this.domViewer.dispose();
            this.domViewer = null;
        }
        BrowserControlFactory.deleteBrowserControl(this.browserControl);
        this.browserControl = null;
        this.hide();
        this.dispose();
        this.urlField = null;
        this.browserCanvas = null;
        this.currentPage = null;
        this.bookmarks = null;
        this.bookmarksTree = null;
        this.controlPanel = null;
        this.buttonsPanel = null;
        this.currentDocument = null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        try {
            if (string.equals("New Window")) {
                this.creator.CreateEMWindow();
            } else if (string.equals("Close")) {
                System.out.println("Got windowClosing");
                System.out.println("destroying the BrowserControl");
                this.delete();
                this.creator.DestroyEMWindow(this.winNum);
            } else if (string.equals("Find")) {
                if (null == this.findDialog) {
                    Frame frame = new Frame();
                    ((Component)frame).setSize(350, 150);
                    this.findDialog = new FindDialog(this, this, "Find in Page", "Find  ", "", 20, false);
                    this.findDialog.setModal(false);
                }
                this.findDialog.setVisible(true);
            } else if (string.equals("Find Next")) {
                this.currentPage.findNextInPage();
            } else if (string.equals("View Page Source as String")) {
                String string2 = this.currentPage.getSource();
                System.out.println("+++++++++++ Page Source is +++++++++++\n\n" + string2);
            } else if (string.equals("View Page Info")) {
                this.currentPage.getPageInfo();
            } else if (string.equals("Select All")) {
                this.currentPage.selectAll();
            } else if (string.equals("Copy")) {
                this.currentPage.copyCurrentSelectionToSystemClipboard();
            } else if (string.equals("Create Profile")) {
                if (this.profileManager == null) {
                    this.profileManager = (ProfileManager)this.browserControl.queryInterface("webclient.ProfileManager");
                }
                this.profileManager.CreateNewProfile("Tester", this.myBinDir, null, true);
            } else if (string.equals("Delete Profile")) {
                if (this.profileManager == null) {
                    this.profileManager = (ProfileManager)this.browserControl.queryInterface("webclient.ProfileManager");
                }
                this.profileManager.DeleteProfile("Tester", true);
            } else if (string.equals("Stop")) {
                this.navigation.stop();
            } else if (string.equals("Refresh")) {
                this.navigation.refresh(0L);
            } else if (string.equals("Add Current Page")) {
                if (null == this.bookmarksTree) {
                    this.bookmarksTree = this.bookmarks.getBookmarks();
                }
                BookmarkEntry bookmarkEntry = this.bookmarks.newBookmarkEntry(this.urlField.getText());
                this.bookmarks.addBookmark(null, bookmarkEntry);
            } else if (string.equals("Add Current Page In New Folder")) {
                if (null == this.bookmarksTree) {
                    this.bookmarksTree = this.bookmarks.getBookmarks();
                }
                BookmarkEntry bookmarkEntry = this.bookmarks.newBookmarkFolder("newFolder");
                this.bookmarks.addBookmark(null, bookmarkEntry);
                BookmarkEntry bookmarkEntry2 = this.bookmarks.newBookmarkEntry(this.urlField.getText());
                this.bookmarks.addBookmark(bookmarkEntry, bookmarkEntry2);
            } else if (string.equals("Manage Bookmarks...")) {
                if (null == this.bookmarksTree) {
                    this.bookmarksTree = this.bookmarks.getBookmarks();
                }
                if (null == this.bookmarksFrame) {
                    this.bookmarksFrame = new BookmarksFrame(this.bookmarksTree, this.browserControl);
                    ((Component)this.bookmarksFrame).setSize(new Dimension(320, 480));
                    ((Component)this.bookmarksFrame).setLocation(645, 0);
                }
                ((Component)this.bookmarksFrame).setVisible(true);
            } else if (string.equals("Load Stream From File...")) {
                FileDialog fileDialog = new FileDialog((Frame)this, "Pick an HTML file", 0);
                fileDialog.show();
                String string3 = fileDialog.getFile();
                String string4 = fileDialog.getDirectory();
                if (null != string3 && null != string4 && 0 < string3.length() && 0 < string4.length()) {
                    String string5 = string4 + string3;
                    FileInputStream fileInputStream = new FileInputStream(string5);
                    File file = new File(string5);
                    System.out.println("debug: edburns: file: " + string5);
                    this.navigation.loadFromStream(fileInputStream, "file:///hello.html", "text/html", (int)file.length(), null);
                }
            } else if (string.equals("Load Random HTML InputStream")) {
                RandomHTMLInputStream randomHTMLInputStream = new RandomHTMLInputStream(3);
                System.out.println("debug: edburns: created RandomHTMLInputStream");
                this.navigation.loadFromStream(randomHTMLInputStream, "http://randomstream.com/", "text/html", -1, null);
            } else if (string.equals("DOMViewer")) {
                if (null == this.domViewer) {
                    this.domViewer = new DOMViewerFrame("DOM Viewer", this.creator);
                    ((Component)this.domViewer).setSize(new Dimension(300, 600));
                    ((Component)this.domViewer).setLocation(645, 0);
                }
                if (null != this.currentDocument) {
                    this.domViewer.setDocument(this.currentDocument);
                    ((Component)this.domViewer).setVisible(true);
                }
            } else if (string.equals("POST")) {
                this.navigation.post(this.urlField.getText(), null, "TESTDATA\r\n", "Content-Length: 8\r\nX-Header:hello\r\n\r\n");
            } else if (string.equals("Back")) {
                if (this.history.canBack()) {
                    this.history.back();
                }
            } else if (string.equals("Forward")) {
                if (this.history.canForward()) {
                    this.history.forward();
                }
            } else if (!string.equals(" ")) {
                this.navigation.loadURL(this.urlField.getText());
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    public void dialogDismissed(Dialog dialog) {
        if (dialog == this.passDialog || dialog == this.uniDialog) {
            return;
        }
        if (this.findDialog.wasClosed()) {
            System.out.println("Find Dialog Closed");
        } else {
            String string = this.findDialog.getTextField().getText();
            if (string == null) {
                System.out.println("Java ERROR - SearchString not received from Dialog Box" + string);
            } else if (string.equals("")) {
                System.out.println("Clear button selected");
                try {
                    CurrentPage currentPage = (CurrentPage)this.browserControl.queryInterface("webclient.CurrentPage");
                    currentPage.resetFind();
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                }
            } else {
                System.out.println("Tring to Find String   -  " + string);
                System.out.println("Parameters are    - Backwrads = " + this.findDialog.backwards + " and Matchcase = " + this.findDialog.matchcase);
                try {
                    CurrentPage currentPage = (CurrentPage)this.browserControl.queryInterface("webclient.CurrentPage");
                    currentPage.findInPage(string, !this.findDialog.backwards, this.findDialog.matchcase);
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                }
            }
        }
    }

    public void dialogCancelled(Dialog dialog) {
        System.out.println("Find Dialog Closed");
    }

    private Component makeItem(Panel panel, Object object, int n, int n2, int n3, int n4, double d, double d2) {
        GridBagLayout gridBagLayout = (GridBagLayout)panel.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Button button = null;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        if (object instanceof String) {
            Button button2;
            button = button2 = new Button((String)object);
            button2.addActionListener(this);
            panel.add(button);
            gridBagLayout.setConstraints(button, gridBagConstraints);
            if (((String)object).equals(" ")) {
                button2.setEnabled(false);
            }
        }
        return button;
    }

    public void eventDispatched(WebclientEvent webclientEvent) {
        if (webclientEvent instanceof DocumentLoadEvent) {
            switch ((int)webclientEvent.getType()) {
                case 1: {
                    this.stopButton.setEnabled(true);
                    this.refreshButton.setEnabled(true);
                    this.currentURL = (String)webclientEvent.getEventData();
                    System.out.println("debug: edburns: Currently Viewing: " + this.currentURL);
                    this.statusLabel.setText("Starting to load " + this.currentURL);
                    this.urlField.setText(this.currentURL);
                    this.currentDocument = null;
                    break;
                }
                case 4: {
                    this.stopButton.setEnabled(false);
                    this.backButton.setEnabled(this.history.canBack());
                    this.backMenuItem.setEnabled(this.history.canBack());
                    this.forwardButton.setEnabled(this.history.canForward());
                    this.forwardMenuItem.setEnabled(this.history.canForward());
                    this.populateHistoryMenu();
                    this.statusLabel.setText("Done.");
                    this.urlStatusLabel.setText("");
                    this.currentDocument = this.currentPage.getDOM();
                    if (null == this.currentDocument || null == this.domViewer) break;
                    this.domViewer.setDocument(this.currentDocument);
                    break;
                }
                case 32: {
                    String string = "Status: " + (String)webclientEvent.getEventData();
                    this.statusLabel.setText(string);
                    break;
                }
                case 64: {
                    String string = "Status: " + (String)webclientEvent.getEventData();
                    this.statusLabel.setText(string);
                    break;
                }
                case 8: {
                    String string = (String)webclientEvent.getEventData();
                    this.urlStatusLabel.setText("startURL: " + string);
                    break;
                }
                case 16: {
                    String string = (String)webclientEvent.getEventData();
                    this.urlStatusLabel.setText(" endURL: " + string);
                }
            }
        }
    }

    private void populateHistoryMenu() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        this.historyMenu.removeAll();
        if (null == this.historyActionListener) {
            this.historyActionListener = new HistoryActionListener();
            if (null == this.historyActionListener) {
                return;
            }
        }
        this.historyMenu.add(this.backMenuItem);
        this.historyMenu.add(this.forwardMenuItem);
        n2 = this.history.getHistoryLength();
        n3 = this.history.getCurrentHistoryIndex();
        n = 0;
        while (n < n2) {
            String string = this.history.getURLForIndex(n);
            string = n == n3 ? Integer.toString(n) + " * " + string : Integer.toString(n) + " " + string;
            MenuItem menuItem = new MenuItem(string);
            menuItem.addActionListener(this.historyActionListener);
            this.historyMenu.add(menuItem);
            ++n;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if (0 != (n & 0x10)) {
            System.out.println("Button1 ");
        }
        if (0 != (n & 8)) {
            System.out.println("Button2 ");
        }
        if (0 != (n & 4)) {
            System.out.println("Button3 ");
            this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (mouseEvent instanceof WCMouseEvent) {
            String string;
            WCMouseEvent wCMouseEvent = (WCMouseEvent)mouseEvent;
            Properties properties = (Properties)wCMouseEvent.getWebclientEvent().getEventData();
            if (null == properties) {
                return;
            }
            if (mouseEvent.isAltDown()) {
                System.out.println("Alt ");
            }
            if (mouseEvent.isControlDown()) {
                System.out.println("Ctrl ");
            }
            if (mouseEvent.isShiftDown()) {
                System.out.println("Shift ");
            }
            if (mouseEvent.isMetaDown()) {
                System.out.println("Meta ");
            }
            if (null != (string = properties.getProperty("href"))) {
                if (null != this.currentURL && -1 == string.indexOf("://")) {
                    int n = this.currentURL.lastIndexOf(47);
                    string = -1 == n ? this.currentURL + "/" + string : this.currentURL.substring(0, n) + "/" + string;
                }
                this.statusLabel.setText(string);
            }
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.statusLabel.setText("");
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public boolean promptUsernameAndPassword(String string, String string2, String string3, int n, Properties properties) {
        if (null == properties) {
            return false;
        }
        if (null == this.passDialog) {
            if (string.equals("")) {
                string = "Basic Authentication Test";
            }
            this.passDialog = new PasswordDialog(this, this, string, string2, string3, 20, true, properties);
            if (null == this.passDialog) {
                return false;
            }
            this.passDialog.setModal(true);
        }
        this.passDialog.setVisible(true);
        return this.passDialog.wasOk();
    }

    public boolean universalDialog(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, int n, int n2, boolean bl, Properties properties) {
        System.out.println("titleMessage " + string);
        System.out.println("dialogTitle " + string2);
        System.out.println("text " + string3);
        System.out.println("checkboxMsg " + string4);
        System.out.println("button0Text " + string5);
        System.out.println("button1Text " + string6);
        System.out.println("button2Text " + string7);
        System.out.println("button3Text " + string8);
        System.out.println("editfield1Msg " + string9);
        System.out.println("editfield2Msg " + string10);
        System.out.println("numButtons " + n);
        System.out.println("numEditfields " + n2);
        System.out.println("editfield1Password " + bl);
        ((Hashtable)properties).put("editfield1Value", "edit1");
        ((Hashtable)properties).put("editfield2Value", "edit2");
        ((Hashtable)properties).put("checkboxState", "true");
        if (null == properties) {
            return false;
        }
        if (null == this.uniDialog) {
            if (string2.equals("")) {
                string2 = "Universal Dialog";
            }
            this.uniDialog = new UniversalDialog((Frame)this, this, string2);
            if (null == this.uniDialog) {
                return false;
            }
            this.uniDialog.setParms(string, string2, string3, string4, string5, string6, string7, string9, string10, n, n2, bl, properties);
            this.uniDialog.setModal(true);
        }
        this.uniDialog.setVisible(true);
        return true;
    }

    public int prefChanged(String string, Object object) {
        System.out.println("prefChanged: " + string + " closure: " + object);
        return 0;
    }

    public BrowserControl getBrowserControl() {
        return this.browserControl;
    }

    Navigation getNavigation() {
        return this.navigation;
    }

    class PopupActionListener
    implements ActionListener {
        PopupActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("View Source as ByteArray")) {
                System.out.println("I will now View Source");
                byte[] byArray = EMWindow.this.currentPage.getSourceBytes();
                String string2 = new String(byArray);
                System.out.println("+++++++++++ Page Source is +++++++++++\n\n" + string2);
            } else if (string.equals("Select All")) {
                System.out.println("I will now Select All");
                EMWindow.this.currentPage.selectAll();
            }
        }
    }

    class HistoryActionListener
    implements ActionListener {
        HistoryActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (null == string) {
                return;
            }
            int n = string.indexOf(32);
            if (-1 == n) {
                return;
            }
            Integer n2 = new Integer(string.substring(0, n));
            EMWindow.this.history.setCurrentHistoryIndex(n2);
        }
    }
}

