/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.webclient.test;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.mozilla.webclient.test.DOMTreeDumper;
import org.mozilla.webclient.test.DOMTreeNotifier;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMAccessPanel
extends JPanel
implements ActionListener,
ItemListener,
TreeSelectionListener {
    private JTextField name;
    private JTextField aValue;
    private JComboBox type;
    private JComboBox aName;
    private JTextArea value;
    private JButton newNode;
    private JButton insert;
    private JButton append;
    private JButton remove;
    private JButton set;
    private JButton removeAttr;
    private JButton save;
    private Node node;
    private Node prv;
    private NamedNodeMap attrMap;
    private boolean updating;
    private String[] types = new String[]{"ELEMENT", "ATTRIBUTE", "TEXT", "CDATA_SECTION", "ENTITY_REF", "ENTITY", "PROC_INSTR", "COMMENT", "DOCUMENT", "DOCUMENT_TYPE", "DOC_FRAGM", "NOTATION"};
    private boolean debug = false;
    private Component tree;
    private DOMTreeNotifier treeNotifier;
    private TreePath nodePath;
    private DOMTreeDumper treeDumper;
    private JFileChooser chooser;

    public DOMAccessPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel("Name:");
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        jLabel = new JLabel("Type:");
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridwidth = -1;
        this.name = new JTextField(10);
        gridBagLayout.setConstraints(this.name, gridBagConstraints);
        jPanel.add(this.name);
        gridBagConstraints.gridwidth = 0;
        this.type = new JComboBox<String>(this.types);
        gridBagLayout.setConstraints(this.type, gridBagConstraints);
        jPanel.add(this.type);
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout2);
        gridBagConstraints.gridwidth = -1;
        this.aName = new JComboBox();
        this.aName.setEditable(true);
        this.aName.addItemListener(this);
        gridBagLayout2.setConstraints(this.aName, gridBagConstraints);
        jPanel2.add(this.aName);
        JPanel jPanel3 = new JPanel();
        jLabel = new JLabel("=");
        jPanel3.add(jLabel);
        this.aValue = new JTextField(9);
        jPanel3.add(this.aValue);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout2.setConstraints(jPanel3, gridBagConstraints);
        jPanel2.add(jPanel3);
        jPanel3 = new JPanel();
        this.set = new JButton("Set");
        this.set.addActionListener(this);
        jPanel3.add(this.set);
        this.removeAttr = new JButton("Remove");
        this.removeAttr.setActionCommand("remove_attr");
        this.removeAttr.addActionListener(this);
        jPanel3.add(this.removeAttr);
        gridBagLayout2.setConstraints(jPanel3, gridBagConstraints);
        jPanel2.add(jPanel3);
        jPanel2.setBorder(new TitledBorder(new BevelBorder(1), " Attributes "));
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        jLabel = new JLabel("Value:");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.value = new JTextArea(5, 23);
        this.value.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                DOMAccessPanel.this.dbg("caret:");
                if (DOMAccessPanel.this.node == null || DOMAccessPanel.this.updating) {
                    return;
                }
                String string = DOMAccessPanel.this.value.getText();
                if (!string.equals("")) {
                    DOMAccessPanel.this.node.setNodeValue(string);
                }
            }
        });
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.value);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        JPanel jPanel4 = new JPanel();
        GridLayout gridLayout = new GridLayout(2, 2);
        jPanel4.setLayout(gridLayout);
        this.newNode = new JButton("New");
        this.newNode.setToolTipText("Create a new node");
        this.newNode.addActionListener(this);
        jPanel4.add(this.newNode);
        this.insert = new JButton("Insert");
        this.insert.setToolTipText("Inserts a node before the selected node ");
        this.insert.addActionListener(this);
        jPanel4.add(this.insert);
        this.append = new JButton("Append");
        this.append.setToolTipText("Adds a node to the end of the list of children of the selected node");
        this.append.addActionListener(this);
        jPanel4.add(this.append);
        this.remove = new JButton("Remove");
        this.remove.setToolTipText("Removes the selected node from the tree");
        this.remove.addActionListener(this);
        jPanel4.add(this.remove);
        jPanel4.setBorder(new TitledBorder(new BevelBorder(1), " Node Manipulation "));
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel.add(jPanel4);
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), " Node info "));
        gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        this.save = new JButton("Dump Tree To File");
        this.save.setActionCommand("save");
        this.save.addActionListener(this);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.save, gridBagConstraints);
        this.add(this.save);
        this.setMinimumSize(new Dimension(350, 400));
        this.setButtonState();
    }

    public void setTreeNotifier(DOMTreeNotifier dOMTreeNotifier) {
        this.treeNotifier = dOMTreeNotifier;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        this.dbg("AttrInfoPanel.actionPerformed: " + string);
        if (string.equalsIgnoreCase("new")) {
            this.prv = this.node;
            this.updateInfo(null);
            this.type.setEnabled(true);
            this.insert.setEnabled(true);
            this.append.setEnabled(true);
        } else if (string.equalsIgnoreCase("insert")) {
            this.insertNode();
            this.treeNotifier.treeStructureChanged(new TreeModelEvent((Object)this, this.nodePath.getParentPath()));
        } else if (string.equalsIgnoreCase("append")) {
            this.appendNode();
            this.treeNotifier.treeStructureChanged(new TreeModelEvent((Object)this, this.nodePath.getParentPath()));
        } else if (string.equalsIgnoreCase("remove")) {
            if (this.node == null) {
                return;
            }
            Node node = this.node.getParentNode();
            node.removeChild(this.node);
            this.node = node;
            this.treeNotifier.treeStructureChanged(new TreeModelEvent((Object)this, this.nodePath.getParentPath()));
        } else if (string.equalsIgnoreCase("save")) {
            this.saveDoc();
        } else if (string.equalsIgnoreCase("set")) {
            ((Element)this.node).setAttribute((String)this.aName.getSelectedItem(), this.aValue.getText());
            this.updateInfo(this.node);
        } else if (string.equalsIgnoreCase("remove_attr")) {
            this.removeAttribute();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.node != null && this.aName.getSelectedItem() != null) {
            this.set.setEnabled(true);
            this.attrMap = this.node.getAttributes();
            if (this.attrMap != null && this.aName.getSelectedIndex() >= 0) {
                this.dbg("setting attr...");
                this.aValue.setText(this.attrMap.item(this.aName.getSelectedIndex()).getNodeValue());
            }
        }
    }

    public void updateInfo(Node node) {
        this.updating = true;
        this.dbg("updateInfo" + node);
        this.node = node;
        this.setButtonState();
        this.name.setText("");
        this.value.setText("");
        this.aValue.setText("");
        this.aName.removeAllItems();
        if (node == null) {
            this.updating = false;
            return;
        }
        this.prv = node;
        this.name.setText(node.getNodeName());
        this.type.setSelectedIndex(node.getNodeType() - 1);
        this.dbg("1 update node name: " + node.getNodeName());
        this.dbg("1 update node value:" + node.getNodeValue());
        this.value.setText(node.getNodeValue());
        this.dbg("2 update node name: " + node.getNodeName());
        this.dbg("2 update node value:" + node.getNodeValue());
        this.attrMap = node.getAttributes();
        if (this.attrMap == null) {
            this.updating = false;
            return;
        }
        int n = this.attrMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            Attr attr = (Attr)this.attrMap.item(n2);
            this.aName.addItem(attr.getName());
            ++n2;
        }
        if (n > 0) {
            this.aName.setSelectedIndex(0);
            this.aValue.setText(this.attrMap.item(0).getNodeValue());
        }
        this.updating = false;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.dbg("DOMAccessPanel.valueChanged");
        if (treeSelectionEvent.isAddedPath()) {
            this.updateInfo((Node)treeSelectionEvent.getPath().getLastPathComponent());
        }
        this.nodePath = treeSelectionEvent.getPath();
        this.tree = (Component)treeSelectionEvent.getSource();
    }

    private Node createNode() {
        int n = this.type.getSelectedIndex();
        Document document = this.prv.getOwnerDocument();
        Node node = null;
        switch (n + 1) {
            case 1: {
                this.dbg("ELEMENT");
                node = document.createElement(this.name.getText());
                break;
            }
            case 2: {
                this.dbg("ATTRIBUTE");
                return null;
            }
            case 3: {
                this.dbg("TEXT");
                node = document.createTextNode(this.value.getText());
                break;
            }
            case 4: {
                this.dbg("CDATA_SECTION");
                return null;
            }
            case 5: {
                this.dbg("ENTITY_REFERENCE");
                return null;
            }
            case 6: {
                this.dbg("ENTITY");
                return null;
            }
            case 7: {
                this.dbg("PROCESSING_INSTRUCTION");
                return null;
            }
            case 8: {
                this.dbg("COMMENT");
                node = document.createComment(this.value.getText());
                break;
            }
            case 9: {
                this.dbg("DOCUMENT");
                return null;
            }
            case 10: {
                this.dbg("DOCUMENT_TYPE");
                return null;
            }
            case 11: {
                this.dbg("DOCUMENT_FRAGMENT");
                return null;
            }
            case 12: {
                this.dbg("NOTATION");
                return null;
            }
        }
        return node;
    }

    private void insertNode() {
        Node node = this.createNode();
        if (node == null) {
            return;
        }
        this.dbg("inserting...");
        this.prv.getParentNode().insertBefore(node, this.prv);
    }

    private void appendNode() {
        Node node = this.createNode();
        if (node == null) {
            return;
        }
        this.dbg("appending...");
        this.prv.appendChild(node);
    }

    private void removeAttribute() {
        ((Element)this.node).removeAttribute((String)this.aName.getSelectedItem());
        this.updateInfo(this.node);
    }

    private void saveDoc() {
        int n;
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
        }
        if ((n = this.chooser.showSaveDialog(this)) == 0) {
            String string = this.chooser.getSelectedFile().getPath();
            if (this.treeDumper == null) {
                this.treeDumper = new DOMTreeDumper(this.debug);
            }
            this.treeDumper.dumpToFile(string, this.node.getOwnerDocument());
        }
    }

    private void setButtonState() {
        boolean bl = this.node != null;
        boolean bl2 = bl && this.node.getAttributes() != null && this.node.getAttributes().getLength() != 0;
        this.type.setEnabled(bl);
        this.newNode.setEnabled(bl);
        this.insert.setEnabled(bl);
        this.append.setEnabled(bl);
        this.save.setEnabled(bl);
        this.remove.setEnabled(bl);
        this.set.setEnabled(bl2);
        this.removeAttr.setEnabled(bl2);
    }

    private void dbg(String string) {
        if (this.debug) {
            System.out.println(string);
        }
    }
}

