#include "cupserrorparser.h"

#include <klocale.h>

CupsErrorParser::CupsErrorParser( QObject *parent )
	: CupsParser( "ErrorParser", "/var/log/cups/error_log", parent )
{
	m_re.setPattern( "([ XACEWNIDd]) \\[([^]]+)\\] (.+)" );
}

CupsErrorParser::~CupsErrorParser()
{
}

QStringList CupsErrorParser::fields()
{
	return QStringList() << i18n( "Log level" ) << i18n( "Summary" );
}

CupsParser::Item* CupsErrorParser::lineToItem( const QString& line )
{
	Item *item = 0;
	if ( m_re.exactMatch( line ) )
	{
		item = new Item( 2 );
		item->fulldata = m_re.cap( 3 );
		switch ( m_re.cap( 1 ).at( 0 ).latin1() )
		{
			case 'E':
				item->fields[ 0 ] = i18n( "Error" );
				item->pixmap = "error";
				break;
			case 'W':
				item->fields[ 0 ] = i18n( "Warning" );
				item->pixmap = "filenew2";
				break;
			case 'I':
				item->fields[ 0 ] = i18n( "Information" );
				item->pixmap = "help";
				break;
			case 'D':
				item->fields[ 0 ] = i18n( "Short debug" );
				item->pixmap = "history";
				break;
			case 'd':
				item->fields[ 0 ] = i18n( "Long debug" );
				item->pixmap = "viewmag";
				break;
			default:
				item->fields[ 0 ] = m_re.cap( 1 );
				item->pixmap = "unknown";
				break;
		}
		item->fields[ 1 ] = ( item->fulldata.length() > 32 ? item->fulldata.left( 32 ) + "..." : item->fulldata );
		item->parseDate( m_re.cap( 2 ) );
	}
	return item;
}

#include "cupserrorparser.moc"
