/*
    This file is part of KDevelop

    Copyright 2015 Milian Wolff <mail@milianw.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma clang system_header

// this file is automatically included by our clang backend for C/C++ projects
// to increase compatibility with GCC by adding some __m64rinsics etc.
// this is required to remove parse errors in GCC headers when using a
// GCC toolchain

inline namespace __KDevelopClangGccCompat {

typedef int __m64 __attribute__ ((__vector_size__ (8), __may_alias__));

typedef float __m128 __attribute__ ((__vector_size__ (16), __may_alias__));
typedef long long __m128i __attribute__ ((__vector_size__ (16), __may_alias__));
typedef double __m128d __attribute__ ((__vector_size__ (16), __may_alias__));

typedef float __m256 __attribute__ ((__vector_size__ (32), __may_alias__));
typedef long long __m256i __attribute__ ((__vector_size__ (32), __may_alias__));
typedef double __m256d __attribute__ ((__vector_size__ (32), __may_alias__));

typedef float __m512 __attribute__ ((__vector_size__ (64), __may_alias__));
typedef long long __m512i __attribute__ ((__vector_size__ (64), __may_alias__));
typedef double __m512d __attribute__ ((__vector_size__ (64), __may_alias__));

typedef unsigned char __mmask8;
typedef unsigned short __mmask16;
typedef unsigned int __mmask32;
typedef unsigned long long __mmask64;

//
// the below was generated using the following bash magic:
//
// tests/test_duchain-clang testGccCompatibility | grep -Po "\b__builtin_[a-z_A-Z0-9]*\b" | sort | uniq > /tmp/builtins.txt
// then, in your GCC include path, e.g. /usr/lib/gcc/x86_64-unknown-linux-gnu/5.2.0/include:
// (while read f; do r=$(grep -P "\b$f\b" -B 5 -m 1 -R . | grep "extern __inline" | awk '{printf "%s",$3; if ($4 !~ /__attrib/) printf " %s",$4;}'); echo "$r $f(...);"; done) < /tmp/builtins.txt
//
// these steps may need to be repeated multiple times
//

__m128  __builtin_ia32_addps128_mask(...);
__m128  __builtin_ia32_andps128_mask(...);
__m128  __builtin_ia32_broadcastss128_mask(...);
__m128  __builtin_ia32_compresssf128_mask(...);
__m128  __builtin_ia32_cvtdq2ps128_mask(...);
__m128  __builtin_ia32_cvtpd2ps256_mask(...);
__m128  __builtin_ia32_cvtpd2ps_mask(...);
__m128  __builtin_ia32_cvtqq2ps128_mask(...);
__m128  __builtin_ia32_cvtqq2ps256_mask(...);
__m128  __builtin_ia32_cvtudq2ps128_mask(...);
__m128  __builtin_ia32_cvtuqq2ps128_mask(...);
__m128  __builtin_ia32_cvtuqq2ps256_mask(...);
__m128  __builtin_ia32_cvtusi2ss32(...);
__m128  __builtin_ia32_cvtusi2ss64(...);
__m128  __builtin_ia32_divps_mask(...);
__m128  __builtin_ia32_expandloadsf128_mask(...);
__m128  __builtin_ia32_expandloadsf128_maskz(...);
__m128  __builtin_ia32_expandsf128_mask(...);
__m128  __builtin_ia32_expandsf128_maskz(...);
__m128  __builtin_ia32_getexpps128_mask(...);
__m128  __builtin_ia32_loadaps128_mask(...);
__m128  __builtin_ia32_loadups128_mask(...);
__m128  __builtin_ia32_maxps_mask(...);
__m128  __builtin_ia32_minps_mask(...);
__m128  __builtin_ia32_movaps128_mask(...);
__m128  __builtin_ia32_movshdup128_mask(...);
__m128  __builtin_ia32_movsldup128_mask(...);
__m128  __builtin_ia32_mulps_mask(...);
__m128  __builtin_ia32_rcp14ps128_mask(...);
__m128  __builtin_ia32_rsqrt14ps128_mask(...);
__m128  __builtin_ia32_scalefps128_mask(...);
__m128  __builtin_ia32_scalefss_round(...);
__m128  __builtin_ia32_sqrtps128_mask(...);
__m128  __builtin_ia32_subps128_mask(...);
__m128  __builtin_ia32_unpckhps128_mask(...);
__m128  __builtin_ia32_unpcklps128_mask(...);
__m128  __builtin_ia32_vcvtph2ps_mask(...);
__m128  __builtin_ia32_vfmaddss3(...);
__m128  __builtin_ia32_vpermi2varps128_mask(...);
__m128  __builtin_ia32_vpermilvarps_mask(...);
__m128  __builtin_ia32_vpermt2varps128_mask(...);
__m128  __builtin_ia32_vpermt2varps128_maskz(...);
__m128 __builtin_ia32_addps(...);
__m128 __builtin_ia32_addss(...);
__m128 __builtin_ia32_andnps(...);
__m128 __builtin_ia32_andps(...);
__m128 __builtin_ia32_cmpeqps(...);
__m128 __builtin_ia32_cmpeqss(...);
__m128 __builtin_ia32_cmpgeps(...);
__m128 __builtin_ia32_cmpgtps(...);
__m128 __builtin_ia32_cmpleps(...);
__m128 __builtin_ia32_cmpless(...);
__m128 __builtin_ia32_cmpltps(...);
__m128 __builtin_ia32_cmpltss(...);
__m128 __builtin_ia32_cmpneqps(...);
__m128 __builtin_ia32_cmpneqss(...);
__m128 __builtin_ia32_cmpngeps(...);
__m128 __builtin_ia32_cmpngtps(...);
__m128 __builtin_ia32_cmpnleps(...);
__m128 __builtin_ia32_cmpnless(...);
__m128 __builtin_ia32_cmpnltps(...);
__m128 __builtin_ia32_cmpnltss(...);
__m128 __builtin_ia32_cmpordps(...);
__m128 __builtin_ia32_cmpordss(...);
__m128 __builtin_ia32_cmpunordps(...);
__m128 __builtin_ia32_cmpunordss(...);
__m128 __builtin_ia32_cvtpi2ps(...);
__m128 __builtin_ia32_cvtsd2ss(...);
__m128 __builtin_ia32_cvtsi2ss(...);
__m128 __builtin_ia32_cvtsi642ss(...);
__m128 __builtin_ia32_divps(...);
__m128 __builtin_ia32_divss(...);
__m128 __builtin_ia32_haddps(...);
__m128 __builtin_ia32_hsubps(...);
__m128 __builtin_ia32_loadhps(...);
__m128 __builtin_ia32_loadlps(...);
__m128 __builtin_ia32_loadups(...);
__m128 __builtin_ia32_minps(...);
__m128 __builtin_ia32_minss(...);
__m128 __builtin_ia32_movhlps(...);
__m128 __builtin_ia32_movlhps(...);
__m128 __builtin_ia32_movshdup(...);
__m128 __builtin_ia32_movsldup(...);
__m128 __builtin_ia32_movss(...);
__m128 __builtin_ia32_mulps(...);
__m128 __builtin_ia32_mulss(...);
__m128 __builtin_ia32_orps(...);
__m128 __builtin_ia32_ps_ps256(...);
__m128 __builtin_ia32_rcp14ss(...);
__m128 __builtin_ia32_rsqrt14ss(...);
__m128 __builtin_ia32_shufps(...);
__m128 __builtin_ia32_subps(...);
__m128 __builtin_ia32_subss(...);
__m128 __builtin_ia32_unpckhps(...);
__m128 __builtin_ia32_unpcklps(...);
__m128 __builtin_ia32_vbroadcastss(...);
__m128 __builtin_ia32_vbroadcastss_ps(...);
__m128 __builtin_ia32_vfmaddss(...);
__m128 __builtin_ia32_xorps(...);
__m128d  __builtin_ia32_addpd128_mask(...);
__m128d  __builtin_ia32_andpd128_mask(...);
__m128d  __builtin_ia32_compressdf128_mask(...);
__m128d  __builtin_ia32_cvtdq2pd128_mask(...);
__m128d  __builtin_ia32_cvtps2pd128_mask(...);
__m128d  __builtin_ia32_cvtqq2pd128_mask(...);
__m128d  __builtin_ia32_cvtudq2pd128_mask(...);
__m128d  __builtin_ia32_cvtuqq2pd128_mask(...);
__m128d  __builtin_ia32_cvtusi2sd64(...);
__m128d  __builtin_ia32_divpd_mask(...);
__m128d  __builtin_ia32_expanddf128_mask(...);
__m128d  __builtin_ia32_expanddf128_maskz(...);
__m128d  __builtin_ia32_expandloaddf128_mask(...);
__m128d  __builtin_ia32_expandloaddf128_maskz(...);
__m128d  __builtin_ia32_getexppd128_mask(...);
__m128d  __builtin_ia32_loadapd128_mask(...);
__m128d  __builtin_ia32_loadupd128_mask(...);
__m128d  __builtin_ia32_maxpd_mask(...);
__m128d  __builtin_ia32_minpd_mask(...);
__m128d  __builtin_ia32_movapd128_mask(...);
__m128d  __builtin_ia32_movddup128_mask(...);
__m128d  __builtin_ia32_mulpd_mask(...);
__m128d  __builtin_ia32_rcp14pd128_mask(...);
__m128d  __builtin_ia32_rsqrt14pd128_mask(...);
__m128d  __builtin_ia32_scalefpd128_mask(...);
__m128d  __builtin_ia32_scalefsd_round(...);
__m128d  __builtin_ia32_sqrtpd128_mask(...);
__m128d  __builtin_ia32_subpd128_mask(...);
__m128d  __builtin_ia32_unpckhpd128_mask(...);
__m128d  __builtin_ia32_unpcklpd128_mask(...);
__m128d  __builtin_ia32_vfmaddsd3(...);
__m128d  __builtin_ia32_vpermi2varpd128_mask(...);
__m128d  __builtin_ia32_vpermilvarpd_mask(...);
__m128d  __builtin_ia32_vpermt2varpd128_mask(...);
__m128d  __builtin_ia32_vpermt2varpd128_maskz(...);
__m128d __builtin_ia32_addpd(...);
__m128d __builtin_ia32_addsd(...);
__m128d __builtin_ia32_andnpd(...);
__m128d __builtin_ia32_andpd(...);
__m128d __builtin_ia32_cmpeqpd(...);
__m128d __builtin_ia32_cmpeqsd(...);
__m128d __builtin_ia32_cmpgepd(...);
__m128d __builtin_ia32_cmpgtpd(...);
__m128d __builtin_ia32_cmplepd(...);
__m128d __builtin_ia32_cmplesd(...);
__m128d __builtin_ia32_cmpltpd(...);
__m128d __builtin_ia32_cmpltsd(...);
__m128d __builtin_ia32_cmpneqpd(...);
__m128d __builtin_ia32_cmpneqsd(...);
__m128d __builtin_ia32_cmpngepd(...);
__m128d __builtin_ia32_cmpngtpd(...);
__m128d __builtin_ia32_cmpnlepd(...);
__m128d __builtin_ia32_cmpnlesd(...);
__m128d __builtin_ia32_cmpnltpd(...);
__m128d __builtin_ia32_cmpnltsd(...);
__m128d __builtin_ia32_cmpordpd(...);
__m128d __builtin_ia32_cmpordsd(...);
__m128d __builtin_ia32_cmpunordpd(...);
__m128d __builtin_ia32_cmpunordsd(...);
__m128d __builtin_ia32_cvtsi2sd(...);
__m128d __builtin_ia32_cvtsi642sd(...);
__m128d __builtin_ia32_cvtss2sd(...);
__m128d __builtin_ia32_cvtusi2sd32(...);
__m128d __builtin_ia32_divpd(...);
__m128d __builtin_ia32_divsd(...);
__m128d __builtin_ia32_haddpd(...);
__m128d __builtin_ia32_hsubpd(...);
__m128d __builtin_ia32_loadhpd(...);
__m128d __builtin_ia32_loadlpd(...);
__m128d __builtin_ia32_loadupd(...);
__m128d __builtin_ia32_minpd(...);
__m128d __builtin_ia32_minsd(...);
__m128d __builtin_ia32_movsd(...);
__m128d __builtin_ia32_mulpd(...);
__m128d __builtin_ia32_mulsd(...);
__m128d __builtin_ia32_orpd(...);
__m128d __builtin_ia32_pd_pd256(...);
__m128d __builtin_ia32_rcp14sd(...);
__m128d __builtin_ia32_rsqrt14sd(...);
__m128d __builtin_ia32_shufpd(...);
__m128d __builtin_ia32_subpd(...);
__m128d __builtin_ia32_subsd(...);
__m128d __builtin_ia32_unpckhpd(...);
__m128d __builtin_ia32_unpcklpd(...);
__m128d __builtin_ia32_vfmaddsd(...);
__m128d __builtin_ia32_xorpd(...);
__m128i  __builtin_ia32_broadcasti32x2_128_mask(...);
__m128i  __builtin_ia32_broadcastmb128(...);
__m128i  __builtin_ia32_broadcastmw128(...);
__m128i  __builtin_ia32_compressdi128_mask(...);
__m128i  __builtin_ia32_compresssi128_mask(...);
__m128i  __builtin_ia32_cvtmask2b128(...);
__m128i  __builtin_ia32_cvtmask2d128(...);
__m128i  __builtin_ia32_cvtmask2q128(...);
__m128i  __builtin_ia32_cvtmask2w128(...);
__m128i  __builtin_ia32_cvtpd2dq128_mask(...);
__m128i  __builtin_ia32_cvtpd2dq256_mask(...);
__m128i  __builtin_ia32_cvtpd2qq128_mask(...);
__m128i  __builtin_ia32_cvtpd2udq128_mask(...);
__m128i  __builtin_ia32_cvtpd2udq256_mask(...);
__m128i  __builtin_ia32_cvtpd2uqq128_mask(...);
__m128i  __builtin_ia32_cvtps2dq128_mask(...);
__m128i  __builtin_ia32_cvtps2qq128_mask(...);
__m128i  __builtin_ia32_cvtps2udq128_mask(...);
__m128i  __builtin_ia32_cvtps2uqq128_mask(...);
__m128i  __builtin_ia32_cvttpd2dq128_mask(...);
__m128i  __builtin_ia32_cvttpd2dq256_mask(...);
__m128i  __builtin_ia32_cvttpd2qq128_mask(...);
__m128i  __builtin_ia32_cvttpd2udq128_mask(...);
__m128i  __builtin_ia32_cvttpd2udq256_mask(...);
__m128i  __builtin_ia32_cvttpd2uqq128_mask(...);
__m128i  __builtin_ia32_cvttps2dq128_mask(...);
__m128i  __builtin_ia32_cvttps2qq128_mask(...);
__m128i  __builtin_ia32_cvttps2udq128_mask(...);
__m128i  __builtin_ia32_cvttps2uqq128_mask(...);
__m128i  __builtin_ia32_expanddi128_mask(...);
__m128i  __builtin_ia32_expanddi128_maskz(...);
__m128i  __builtin_ia32_expandloaddi128_mask(...);
__m128i  __builtin_ia32_expandloaddi128_maskz(...);
__m128i  __builtin_ia32_expandloadsi128_mask(...);
__m128i  __builtin_ia32_expandloadsi128_maskz(...);
__m128i  __builtin_ia32_expandsi128_mask(...);
__m128i  __builtin_ia32_expandsi128_maskz(...);
__m128i  __builtin_ia32_extracti32x4_mask(...);
__m128i  __builtin_ia32_loaddqudi128_mask(...);
__m128i  __builtin_ia32_loaddquhi128_mask(...);
__m128i  __builtin_ia32_loaddquqi128_mask(...);
__m128i  __builtin_ia32_loaddqusi128_mask(...);
__m128i  __builtin_ia32_movdqa32_128_mask(...);
__m128i  __builtin_ia32_movdqa32load128_mask(...);
__m128i  __builtin_ia32_movdqa64_128_mask(...);
__m128i  __builtin_ia32_movdqa64load128_mask(...);
__m128i  __builtin_ia32_movdquhi128_mask(...);
__m128i  __builtin_ia32_movdquqi128_mask(...);
__m128i  __builtin_ia32_pabsb128_mask(...);
__m128i  __builtin_ia32_pabsd128_mask(...);
__m128i  __builtin_ia32_pabsq128_mask(...);
__m128i  __builtin_ia32_pabsw128_mask(...);
__m128i  __builtin_ia32_pandq128_mask(...);
__m128i  __builtin_ia32_pbroadcastb128(...);
__m128i  __builtin_ia32_pbroadcastb128_gpr_mask(...);
__m128i  __builtin_ia32_pbroadcastb128_mask(...);
__m128i  __builtin_ia32_pbroadcastd128(...);
__m128i  __builtin_ia32_pbroadcastd128_gpr_mask(...);
__m128i  __builtin_ia32_pbroadcastd128_mask(...);
__m128i  __builtin_ia32_pbroadcastq128(...);
__m128i  __builtin_ia32_pbroadcastq128_gpr_mask(...);
__m128i  __builtin_ia32_pbroadcastq128_mask(...);
__m128i  __builtin_ia32_pbroadcastw128(...);
__m128i  __builtin_ia32_pbroadcastw128_gpr_mask(...);
__m128i  __builtin_ia32_pbroadcastw128_mask(...);
__m128i  __builtin_ia32_permvarhi128_mask(...);
__m128i  __builtin_ia32_permvarqi128_mask(...);
__m128i  __builtin_ia32_pmaddubsw128_mask(...);
__m128i  __builtin_ia32_pmaddwd128_mask(...);
__m128i  __builtin_ia32_pmaxsd128_mask(...);
__m128i  __builtin_ia32_pmaxsq128_mask(...);
__m128i  __builtin_ia32_pmaxud128_mask(...);
__m128i  __builtin_ia32_pmaxuq128_mask(...);
__m128i  __builtin_ia32_pminsd128_mask(...);
__m128i  __builtin_ia32_pminsq128_mask(...);
__m128i  __builtin_ia32_pminud128_mask(...);
__m128i  __builtin_ia32_pminuq128_mask(...);
__m128i  __builtin_ia32_pmovdb128_mask(...);
__m128i  __builtin_ia32_pmovdb256_mask(...);
__m128i  __builtin_ia32_pmovdw128_mask(...);
__m128i  __builtin_ia32_pmovdw256_mask(...);
__m128i  __builtin_ia32_pmovqb128_mask(...);
__m128i  __builtin_ia32_pmovqb256_mask(...);
__m128i  __builtin_ia32_pmovqb512_mask(...);
__m128i  __builtin_ia32_pmovqd128_mask(...);
__m128i  __builtin_ia32_pmovqd256_mask(...);
__m128i  __builtin_ia32_pmovqw128_mask(...);
__m128i  __builtin_ia32_pmovqw256_mask(...);
__m128i  __builtin_ia32_pmovsdb128_mask(...);
__m128i  __builtin_ia32_pmovsdb256_mask(...);
__m128i  __builtin_ia32_pmovsdw128_mask(...);
__m128i  __builtin_ia32_pmovsdw256_mask(...);
__m128i  __builtin_ia32_pmovsqb128_mask(...);
__m128i  __builtin_ia32_pmovsqb256_mask(...);
__m128i  __builtin_ia32_pmovsqb512_mask(...);
__m128i  __builtin_ia32_pmovsqd128_mask(...);
__m128i  __builtin_ia32_pmovsqd256_mask(...);
__m128i  __builtin_ia32_pmovsqw128_mask(...);
__m128i  __builtin_ia32_pmovsqw256_mask(...);
__m128i  __builtin_ia32_pmovsqw512_mask(...);
__m128i  __builtin_ia32_pmovswb128_mask(...);
__m128i  __builtin_ia32_pmovswb256_mask(...);
__m128i  __builtin_ia32_pmovsxbd128_mask(...);
__m128i  __builtin_ia32_pmovsxbq128_mask(...);
__m128i  __builtin_ia32_pmovsxbw128_mask(...);
__m128i  __builtin_ia32_pmovsxdq128_mask(...);
__m128i  __builtin_ia32_pmovsxwd128_mask(...);
__m128i  __builtin_ia32_pmovsxwq128_mask(...);
__m128i  __builtin_ia32_pmovusdb128_mask(...);
__m128i  __builtin_ia32_pmovusdb256_mask(...);
__m128i  __builtin_ia32_pmovusdw128_mask(...);
__m128i  __builtin_ia32_pmovusdw256_mask(...);
__m128i  __builtin_ia32_pmovusqb128_mask(...);
__m128i  __builtin_ia32_pmovusqb256_mask(...);
__m128i  __builtin_ia32_pmovusqb512_mask(...);
__m128i  __builtin_ia32_pmovusqd128_mask(...);
__m128i  __builtin_ia32_pmovusqd256_mask(...);
__m128i  __builtin_ia32_pmovusqw128_mask(...);
__m128i  __builtin_ia32_pmovusqw256_mask(...);
__m128i  __builtin_ia32_pmovusqw512_mask(...);
__m128i  __builtin_ia32_pmovuswb128_mask(...);
__m128i  __builtin_ia32_pmovuswb256_mask(...);
__m128i  __builtin_ia32_pmovwb128_mask(...);
__m128i  __builtin_ia32_pmovwb256_mask(...);
__m128i  __builtin_ia32_pmovzxbd128_mask(...);
__m128i  __builtin_ia32_pmovzxbq128_mask(...);
__m128i  __builtin_ia32_pmovzxbw128_mask(...);
__m128i  __builtin_ia32_pmovzxdq128_mask(...);
__m128i  __builtin_ia32_pmovzxwd128_mask(...);
__m128i  __builtin_ia32_pmovzxwq128_mask(...);
__m128i  __builtin_ia32_pmulhrsw128_mask(...);
__m128i  __builtin_ia32_pmulhuw128_mask(...);
__m128i  __builtin_ia32_pmulhw128_mask(...);
__m128i  __builtin_ia32_pmulld128_mask(...);
__m128i  __builtin_ia32_prolvd128_mask(...);
__m128i  __builtin_ia32_prolvq128_mask(...);
__m128i  __builtin_ia32_prorvd128_mask(...);
__m128i  __builtin_ia32_prorvq128_mask(...);
__m128i  __builtin_ia32_pslld128_mask(...);
__m128i  __builtin_ia32_psllq128_mask(...);
__m128i  __builtin_ia32_psllv2di_mask(...);
__m128i  __builtin_ia32_psllv4si_mask(...);
__m128i  __builtin_ia32_psllv8hi_mask(...);
__m128i  __builtin_ia32_psllw128_mask(...);
__m128i  __builtin_ia32_psrad128_mask(...);
__m128i  __builtin_ia32_psraq128_mask(...);
__m128i  __builtin_ia32_psrav4si_mask(...);
__m128i  __builtin_ia32_psrav8hi_mask(...);
__m128i  __builtin_ia32_psravq128_mask(...);
__m128i  __builtin_ia32_psraw128_mask(...);
__m128i  __builtin_ia32_psrld128_mask(...);
__m128i  __builtin_ia32_psrlq128_mask(...);
__m128i  __builtin_ia32_psrlv2di_mask(...);
__m128i  __builtin_ia32_psrlv4si_mask(...);
__m128i  __builtin_ia32_psrlv8hi_mask(...);
__m128i  __builtin_ia32_psrlw128_mask(...);
__m128i  __builtin_ia32_psubd128_mask(...);
__m128i  __builtin_ia32_psubw128_mask(...);
__m128i  __builtin_ia32_punpckhbw128_mask(...);
__m128i  __builtin_ia32_punpckhdq128_mask(...);
__m128i  __builtin_ia32_punpckhqdq128_mask(...);
__m128i  __builtin_ia32_punpckhwd128_mask(...);
__m128i  __builtin_ia32_punpcklbw128_mask(...);
__m128i  __builtin_ia32_punpckldq128_mask(...);
__m128i  __builtin_ia32_punpcklqdq128_mask(...);
__m128i  __builtin_ia32_punpcklwd128_mask(...);
__m128i  __builtin_ia32_vpconflictdi_128_mask(...);
__m128i  __builtin_ia32_vpconflictsi_128_mask(...);
__m128i  __builtin_ia32_vpermi2vard128_mask(...);
__m128i  __builtin_ia32_vpermi2varhi128_mask(...);
__m128i  __builtin_ia32_vpermi2varq128_mask(...);
__m128i  __builtin_ia32_vpermi2varqi128_mask(...);
__m128i  __builtin_ia32_vpermt2vard128_mask(...);
__m128i  __builtin_ia32_vpermt2vard128_maskz(...);
__m128i  __builtin_ia32_vpermt2varhi128_mask(...);
__m128i  __builtin_ia32_vpermt2varhi128_maskz(...);
__m128i  __builtin_ia32_vpermt2varq128_mask(...);
__m128i  __builtin_ia32_vpermt2varq128_maskz(...);
__m128i  __builtin_ia32_vpermt2varqi128_mask(...);
__m128i  __builtin_ia32_vpermt2varqi128_maskz(...);
__m128i  __builtin_ia32_vplzcntd_128_mask(...);
__m128i  __builtin_ia32_vplzcntq_128_mask(...);
__m128i  __builtin_ia32_vpmadd52huq128_mask(...);
__m128i  __builtin_ia32_vpmadd52huq128_maskz(...);
__m128i  __builtin_ia32_vpmadd52luq128_mask(...);
__m128i  __builtin_ia32_vpmadd52luq128_maskz(...);
__m128i  __builtin_ia32_vpmultishiftqb128_mask(...);
__m128i __builtin_ia32_loaddqu(...);
__m128i __builtin_ia32_movntdqa(...);
__m128i __builtin_ia32_movq128(...);
__m128i __builtin_ia32_paddb128(...);
__m128i __builtin_ia32_paddd128(...);
__m128i __builtin_ia32_paddq128(...);
__m128i __builtin_ia32_paddsb128(...);
__m128i __builtin_ia32_paddw128(...);
__m128i __builtin_ia32_pand128(...);
__m128i __builtin_ia32_pandn128(...);
__m128i __builtin_ia32_pcmpeqb128(...);
__m128i __builtin_ia32_pcmpeqd128(...);
__m128i __builtin_ia32_pcmpeqq(...);
__m128i __builtin_ia32_pcmpeqw128(...);
__m128i __builtin_ia32_pcmpgtb128(...);
__m128i __builtin_ia32_pcmpgtd128(...);
__m128i __builtin_ia32_pcmpgtq(...);
__m128i __builtin_ia32_pcmpgtw128(...);
__m128i __builtin_ia32_phaddd128(...);
__m128i __builtin_ia32_phsubd128(...);
__m128i __builtin_ia32_pmovdb512_mask(...);
__m128i __builtin_ia32_pmovqw512_mask(...);
__m128i __builtin_ia32_pmovsdb512_mask(...);
__m128i __builtin_ia32_pmovsxbd128(...);
__m128i __builtin_ia32_pmovsxbq128(...);
__m128i __builtin_ia32_pmovsxbw128(...);
__m128i __builtin_ia32_pmovsxdq128(...);
__m128i __builtin_ia32_pmovsxwd128(...);
__m128i __builtin_ia32_pmovsxwq128(...);
__m128i __builtin_ia32_pmovusdb512_mask(...);
__m128i __builtin_ia32_pmovzxbd128(...);
__m128i __builtin_ia32_pmovzxbq128(...);
__m128i __builtin_ia32_pmovzxbw128(...);
__m128i __builtin_ia32_pmovzxdq128(...);
__m128i __builtin_ia32_pmovzxwd128(...);
__m128i __builtin_ia32_pmovzxwq128(...);
__m128i __builtin_ia32_pmullw128(...);
__m128i __builtin_ia32_por128(...);
__m128i __builtin_ia32_psadbw128(...);
__m128i __builtin_ia32_psubb128(...);
__m128i __builtin_ia32_psubd128(...);
__m128i __builtin_ia32_psubq128(...);
__m128i __builtin_ia32_psubsb128(...);
__m128i __builtin_ia32_psubw128(...);
__m128i __builtin_ia32_punpckhbw128(...);
__m128i __builtin_ia32_punpckhdq128(...);
__m128i __builtin_ia32_punpckhqdq128(...);
__m128i __builtin_ia32_punpckhwd128(...);
__m128i __builtin_ia32_punpcklbw128(...);
__m128i __builtin_ia32_punpckldq128(...);
__m128i __builtin_ia32_punpcklqdq128(...);
__m128i __builtin_ia32_punpcklwd128(...);
__m128i __builtin_ia32_pxor128(...);
__m128i __builtin_ia32_si_si256(...);
__m128i __builtin_ia32_vpcomeqb(...);
__m128i __builtin_ia32_vpcomeqd(...);
__m128i __builtin_ia32_vpcomeqq(...);
__m128i __builtin_ia32_vpcomequb(...);
__m128i __builtin_ia32_vpcomequd(...);
__m128i __builtin_ia32_vpcomequq(...);
__m128i __builtin_ia32_vpcomequw(...);
__m128i __builtin_ia32_vpcomeqw(...);
__m128i __builtin_ia32_vpcomfalseb(...);
__m128i __builtin_ia32_vpcomfalsed(...);
__m128i __builtin_ia32_vpcomfalseq(...);
__m128i __builtin_ia32_vpcomfalseub(...);
__m128i __builtin_ia32_vpcomfalseud(...);
__m128i __builtin_ia32_vpcomfalseuq(...);
__m128i __builtin_ia32_vpcomfalseuw(...);
__m128i __builtin_ia32_vpcomfalsew(...);
__m128i __builtin_ia32_vpcomgeb(...);
__m128i __builtin_ia32_vpcomged(...);
__m128i __builtin_ia32_vpcomgeq(...);
__m128i __builtin_ia32_vpcomgeub(...);
__m128i __builtin_ia32_vpcomgeud(...);
__m128i __builtin_ia32_vpcomgeuq(...);
__m128i __builtin_ia32_vpcomgeuw(...);
__m128i __builtin_ia32_vpcomgew(...);
__m128i __builtin_ia32_vpcomgtb(...);
__m128i __builtin_ia32_vpcomgtd(...);
__m128i __builtin_ia32_vpcomgtq(...);
__m128i __builtin_ia32_vpcomgtub(...);
__m128i __builtin_ia32_vpcomgtud(...);
__m128i __builtin_ia32_vpcomgtuq(...);
__m128i __builtin_ia32_vpcomgtuw(...);
__m128i __builtin_ia32_vpcomgtw(...);
__m128i __builtin_ia32_vpcomleb(...);
__m128i __builtin_ia32_vpcomled(...);
__m128i __builtin_ia32_vpcomleq(...);
__m128i __builtin_ia32_vpcomleub(...);
__m128i __builtin_ia32_vpcomleud(...);
__m128i __builtin_ia32_vpcomleuq(...);
__m128i __builtin_ia32_vpcomleuw(...);
__m128i __builtin_ia32_vpcomlew(...);
__m128i __builtin_ia32_vpcomltb(...);
__m128i __builtin_ia32_vpcomltd(...);
__m128i __builtin_ia32_vpcomltq(...);
__m128i __builtin_ia32_vpcomltub(...);
__m128i __builtin_ia32_vpcomltud(...);
__m128i __builtin_ia32_vpcomltuq(...);
__m128i __builtin_ia32_vpcomltuw(...);
__m128i __builtin_ia32_vpcomltw(...);
__m128i __builtin_ia32_vpcomneqb(...);
__m128i __builtin_ia32_vpcomneqd(...);
__m128i __builtin_ia32_vpcomneqq(...);
__m128i __builtin_ia32_vpcomnequb(...);
__m128i __builtin_ia32_vpcomnequd(...);
__m128i __builtin_ia32_vpcomnequq(...);
__m128i __builtin_ia32_vpcomnequw(...);
__m128i __builtin_ia32_vpcomneqw(...);
__m128i __builtin_ia32_vpcomtrueb(...);
__m128i __builtin_ia32_vpcomtrued(...);
__m128i __builtin_ia32_vpcomtrueq(...);
__m128i __builtin_ia32_vpcomtrueub(...);
__m128i __builtin_ia32_vpcomtrueud(...);
__m128i __builtin_ia32_vpcomtrueuq(...);
__m128i __builtin_ia32_vpcomtrueuw(...);
__m128i __builtin_ia32_vpcomtruew(...);
__m128i __builtin_ia32_vprotb(...);
__m128i __builtin_ia32_vprotd(...);
__m128i __builtin_ia32_vprotq(...);
__m128i __builtin_ia32_vprotw(...);
__m256  __builtin_ia32_addps256_mask(...);
__m256  __builtin_ia32_andps256_mask(...);
__m256  __builtin_ia32_broadcastf32x2_256_mask(...);
__m256  __builtin_ia32_broadcastf32x4_256_mask(...);
__m256  __builtin_ia32_broadcastss256_mask(...);
__m256  __builtin_ia32_compresssf256_mask(...);
__m256  __builtin_ia32_cvtdq2ps256_mask(...);
__m256  __builtin_ia32_cvtpd2ps512_mask(...);
__m256  __builtin_ia32_cvtqq2ps512_mask(...);
__m256  __builtin_ia32_cvtudq2ps256_mask(...);
__m256  __builtin_ia32_cvtuqq2ps512_mask(...);
__m256  __builtin_ia32_divps256_mask(...);
__m256  __builtin_ia32_expandloadsf256_mask(...);
__m256  __builtin_ia32_expandloadsf256_maskz(...);
__m256  __builtin_ia32_expandsf256_mask(...);
__m256  __builtin_ia32_expandsf256_maskz(...);
__m256  __builtin_ia32_getexpps256_mask(...);
__m256  __builtin_ia32_loadaps256_mask(...);
__m256  __builtin_ia32_loadups256_mask(...);
__m256  __builtin_ia32_maxps256_mask(...);
__m256  __builtin_ia32_minps256_mask(...);
__m256  __builtin_ia32_movaps256_mask(...);
__m256  __builtin_ia32_movshdup256_mask(...);
__m256  __builtin_ia32_movsldup256_mask(...);
__m256  __builtin_ia32_mulps256_mask(...);
__m256  __builtin_ia32_permvarsf256_mask(...);
__m256  __builtin_ia32_rcp14ps256_mask(...);
__m256  __builtin_ia32_rsqrt14ps256_mask(...);
__m256  __builtin_ia32_scalefps256_mask(...);
__m256  __builtin_ia32_sqrtps256_mask(...);
__m256  __builtin_ia32_subps256_mask(...);
__m256  __builtin_ia32_unpckhps256_mask(...);
__m256  __builtin_ia32_unpcklps256_mask(...);
__m256  __builtin_ia32_vbroadcastss_ps256(...);
__m256  __builtin_ia32_vcvtph2ps256_mask(...);
__m256  __builtin_ia32_vpermi2varps256_mask(...);
__m256  __builtin_ia32_vpermilvarps256_mask(...);
__m256  __builtin_ia32_vpermt2varps256_mask(...);
__m256  __builtin_ia32_vpermt2varps256_maskz(...);
__m256 __builtin_ia32_addps256(...);
__m256 __builtin_ia32_andnps256(...);
__m256 __builtin_ia32_andps256(...);
__m256 __builtin_ia32_divps256(...);
__m256 __builtin_ia32_haddps256(...);
__m256 __builtin_ia32_loadups256(...);
__m256 __builtin_ia32_movshdup256(...);
__m256 __builtin_ia32_movsldup256(...);
__m256 __builtin_ia32_mulps256(...);
__m256 __builtin_ia32_orps256(...);
__m256 __builtin_ia32_ps256_ps(...);
__m256 __builtin_ia32_rcpps256(...);
__m256 __builtin_ia32_subps256(...);
__m256 __builtin_ia32_unpckhps256(...);
__m256 __builtin_ia32_unpcklps256(...);
__m256 __builtin_ia32_vbroadcastf128_ps256(...);
__m256 __builtin_ia32_vbroadcastss256(...);
__m256 __builtin_ia32_xorps256(...);
__m256d  __builtin_ia32_addpd256_mask(...);
__m256d  __builtin_ia32_andpd256_mask(...);
__m256d  __builtin_ia32_broadcastf64x2_256_mask(...);
__m256d  __builtin_ia32_broadcastsd256_mask(...);
__m256d  __builtin_ia32_compressdf256_mask(...);
__m256d  __builtin_ia32_cvtdq2pd256_mask(...);
__m256d  __builtin_ia32_cvtps2pd256_mask(...);
__m256d  __builtin_ia32_cvtqq2pd256_mask(...);
__m256d  __builtin_ia32_cvtudq2pd256_mask(...);
__m256d  __builtin_ia32_cvtuqq2pd256_mask(...);
__m256d  __builtin_ia32_divpd256_mask(...);
__m256d  __builtin_ia32_expanddf256_mask(...);
__m256d  __builtin_ia32_expanddf256_maskz(...);
__m256d  __builtin_ia32_expandloaddf256_mask(...);
__m256d  __builtin_ia32_expandloaddf256_maskz(...);
__m256d  __builtin_ia32_getexppd256_mask(...);
__m256d  __builtin_ia32_loadapd256_mask(...);
__m256d  __builtin_ia32_loadupd256_mask(...);
__m256d  __builtin_ia32_maxpd256_mask(...);
__m256d  __builtin_ia32_minpd256_mask(...);
__m256d  __builtin_ia32_movapd256_mask(...);
__m256d  __builtin_ia32_movddup256_mask(...);
__m256d  __builtin_ia32_mulpd256_mask(...);
__m256d  __builtin_ia32_permvardf256_mask(...);
__m256d  __builtin_ia32_rcp14pd256_mask(...);
__m256d  __builtin_ia32_rsqrt14pd256_mask(...);
__m256d  __builtin_ia32_scalefpd256_mask(...);
__m256d  __builtin_ia32_sqrtpd256_mask(...);
__m256d  __builtin_ia32_subpd256_mask(...);
__m256d  __builtin_ia32_unpckhpd256_mask(...);
__m256d  __builtin_ia32_unpcklpd256_mask(...);
__m256d  __builtin_ia32_vbroadcastsd_pd256(...);
__m256d  __builtin_ia32_vpermi2varpd256_mask(...);
__m256d  __builtin_ia32_vpermilvarpd256_mask(...);
__m256d  __builtin_ia32_vpermt2varpd256_mask(...);
__m256d  __builtin_ia32_vpermt2varpd256_maskz(...);
__m256d __builtin_ia32_addpd256(...);
__m256d __builtin_ia32_andnpd256(...);
__m256d __builtin_ia32_andpd256(...);
__m256d __builtin_ia32_divpd256(...);
__m256d __builtin_ia32_haddpd256(...);
__m256d __builtin_ia32_loadupd256(...);
__m256d __builtin_ia32_minpd256(...);
__m256d __builtin_ia32_movddup256(...);
__m256d __builtin_ia32_mulpd256(...);
__m256d __builtin_ia32_orpd256(...);
__m256d __builtin_ia32_pd256_pd(...);
__m256d __builtin_ia32_subpd256(...);
__m256d __builtin_ia32_unpckhpd256(...);
__m256d __builtin_ia32_unpcklpd256(...);
__m256d __builtin_ia32_vbroadcastf128_pd256(...);
__m256d __builtin_ia32_vbroadcastsd256(...);
__m256d __builtin_ia32_xorpd256(...);
__m256i  __builtin_ia32_andsi256(...);
__m256i  __builtin_ia32_broadcasti32x2_256_mask(...);
__m256i  __builtin_ia32_broadcasti32x4_256_mask(...);
__m256i  __builtin_ia32_broadcasti64x2_256_mask(...);
__m256i  __builtin_ia32_broadcastmb256(...);
__m256i  __builtin_ia32_broadcastmw256(...);
__m256i  __builtin_ia32_compressdi256_mask(...);
__m256i  __builtin_ia32_compresssi256_mask(...);
__m256i  __builtin_ia32_cvtmask2b256(...);
__m256i  __builtin_ia32_cvtmask2d256(...);
__m256i  __builtin_ia32_cvtmask2q256(...);
__m256i  __builtin_ia32_cvtmask2w256(...);
__m256i  __builtin_ia32_cvtpd2dq512_mask(...);
__m256i  __builtin_ia32_cvtpd2qq256_mask(...);
__m256i  __builtin_ia32_cvtpd2udq512_mask(...);
__m256i  __builtin_ia32_cvtpd2uqq256_mask(...);
__m256i  __builtin_ia32_cvtps2dq256_mask(...);
__m256i  __builtin_ia32_cvtps2qq256_mask(...);
__m256i  __builtin_ia32_cvtps2udq256_mask(...);
__m256i  __builtin_ia32_cvtps2uqq256_mask(...);
__m256i  __builtin_ia32_cvttpd2dq512_mask(...);
__m256i  __builtin_ia32_cvttpd2qq256_mask(...);
__m256i  __builtin_ia32_cvttpd2udq512_mask(...);
__m256i  __builtin_ia32_cvttpd2uqq256_mask(...);
__m256i  __builtin_ia32_cvttps2dq256_mask(...);
__m256i  __builtin_ia32_cvttps2qq256_mask(...);
__m256i  __builtin_ia32_cvttps2udq256_mask(...);
__m256i  __builtin_ia32_cvttps2uqq256_mask(...);
__m256i  __builtin_ia32_expanddi256_mask(...);
__m256i  __builtin_ia32_expanddi256_maskz(...);
__m256i  __builtin_ia32_expandloaddi256_mask(...);
__m256i  __builtin_ia32_expandloaddi256_maskz(...);
__m256i  __builtin_ia32_expandloadsi256_mask(...);
__m256i  __builtin_ia32_expandloadsi256_maskz(...);
__m256i  __builtin_ia32_expandsi256_mask(...);
__m256i  __builtin_ia32_expandsi256_maskz(...);
__m256i  __builtin_ia32_loaddqudi256_mask(...);
__m256i  __builtin_ia32_loaddquhi256_mask(...);
__m256i  __builtin_ia32_loaddquqi256_mask(...);
__m256i  __builtin_ia32_loaddqusi256_mask(...);
__m256i  __builtin_ia32_movdqa32_256_mask(...);
__m256i  __builtin_ia32_movdqa32load256_mask(...);
__m256i  __builtin_ia32_movdqa64_256_mask(...);
__m256i  __builtin_ia32_movdqa64load256_mask(...);
__m256i  __builtin_ia32_movdquhi256_mask(...);
__m256i  __builtin_ia32_movdquqi256_mask(...);
__m256i  __builtin_ia32_pabsb256_mask(...);
__m256i  __builtin_ia32_pabsd256_mask(...);
__m256i  __builtin_ia32_pabsq256_mask(...);
__m256i  __builtin_ia32_pabsw256_mask(...);
__m256i  __builtin_ia32_paddb256(...);
__m256i  __builtin_ia32_paddd256(...);
__m256i  __builtin_ia32_paddq256(...);
__m256i  __builtin_ia32_paddsb256(...);
__m256i  __builtin_ia32_paddw256(...);
__m256i  __builtin_ia32_pandq256_mask(...);
__m256i  __builtin_ia32_pbroadcastb256(...);
__m256i  __builtin_ia32_pbroadcastb256_gpr_mask(...);
__m256i  __builtin_ia32_pbroadcastb256_mask(...);
__m256i  __builtin_ia32_pbroadcastd256_gpr_mask(...);
__m256i  __builtin_ia32_pbroadcastd256_mask(...);
__m256i  __builtin_ia32_pbroadcastq256(...);
__m256i  __builtin_ia32_pbroadcastq256_gpr_mask(...);
__m256i  __builtin_ia32_pbroadcastq256_mask(...);
__m256i  __builtin_ia32_pbroadcastw256(...);
__m256i  __builtin_ia32_pbroadcastw256_gpr_mask(...);
__m256i  __builtin_ia32_pbroadcastw256_mask(...);
__m256i  __builtin_ia32_pcmpeqb256(...);
__m256i  __builtin_ia32_pcmpeqd256(...);
__m256i  __builtin_ia32_pcmpeqq256(...);
__m256i  __builtin_ia32_pcmpeqw256(...);
__m256i  __builtin_ia32_pcmpgtb256(...);
__m256i  __builtin_ia32_pcmpgtd256(...);
__m256i  __builtin_ia32_pcmpgtq256(...);
__m256i  __builtin_ia32_pcmpgtw256(...);
__m256i  __builtin_ia32_permvardi256_mask(...);
__m256i  __builtin_ia32_permvarhi256_mask(...);
__m256i  __builtin_ia32_permvarqi256_mask(...);
__m256i  __builtin_ia32_permvarsi256_mask(...);
__m256i  __builtin_ia32_phaddd256(...);
__m256i  __builtin_ia32_phsubd256(...);
__m256i  __builtin_ia32_pmaddubsw256_mask(...);
__m256i  __builtin_ia32_pmaddwd256_mask(...);
__m256i  __builtin_ia32_pmaxsd256_mask(...);
__m256i  __builtin_ia32_pmaxsq256_mask(...);
__m256i  __builtin_ia32_pmaxud256_mask(...);
__m256i  __builtin_ia32_pmaxuq256_mask(...);
__m256i  __builtin_ia32_pminsd256_mask(...);
__m256i  __builtin_ia32_pminsq256_mask(...);
__m256i  __builtin_ia32_pminud256_mask(...);
__m256i  __builtin_ia32_pminuq256_mask(...);
__m256i  __builtin_ia32_pmovswb512_mask(...);
__m256i  __builtin_ia32_pmovsxbd256_mask(...);
__m256i  __builtin_ia32_pmovsxbq256_mask(...);
__m256i  __builtin_ia32_pmovsxbw256_mask(...);
__m256i  __builtin_ia32_pmovsxdq256_mask(...);
__m256i  __builtin_ia32_pmovsxwd256_mask(...);
__m256i  __builtin_ia32_pmovsxwq256_mask(...);
__m256i  __builtin_ia32_pmovuswb512_mask(...);
__m256i  __builtin_ia32_pmovwb512_mask(...);
__m256i  __builtin_ia32_pmovzxbd256_mask(...);
__m256i  __builtin_ia32_pmovzxbq256_mask(...);
__m256i  __builtin_ia32_pmovzxbw256_mask(...);
__m256i  __builtin_ia32_pmovzxdq256_mask(...);
__m256i  __builtin_ia32_pmovzxwd256_mask(...);
__m256i  __builtin_ia32_pmovzxwq256_mask(...);
__m256i  __builtin_ia32_pmuldq256(...);
__m256i  __builtin_ia32_pmulhrsw256_mask(...);
__m256i  __builtin_ia32_pmulhuw256_mask(...);
__m256i  __builtin_ia32_pmulhw256(...);
__m256i  __builtin_ia32_pmulhw256_mask(...);
__m256i  __builtin_ia32_pmulld256(...);
__m256i  __builtin_ia32_pmulld256_mask(...);
__m256i  __builtin_ia32_pmullw256(...);
__m256i  __builtin_ia32_por256(...);
__m256i  __builtin_ia32_prolvd256_mask(...);
__m256i  __builtin_ia32_prolvq256_mask(...);
__m256i  __builtin_ia32_prorvd256_mask(...);
__m256i  __builtin_ia32_prorvq256_mask(...);
__m256i  __builtin_ia32_pslld256_mask(...);
__m256i  __builtin_ia32_psllq256_mask(...);
__m256i  __builtin_ia32_psllv16hi_mask(...);
__m256i  __builtin_ia32_psllv4di_mask(...);
__m256i  __builtin_ia32_psllv8si_mask(...);
__m256i  __builtin_ia32_psllw256_mask(...);
__m256i  __builtin_ia32_psrad256_mask(...);
__m256i  __builtin_ia32_psraq256_mask(...);
__m256i  __builtin_ia32_psrav16hi_mask(...);
__m256i  __builtin_ia32_psrav8si_mask(...);
__m256i  __builtin_ia32_psravq256_mask(...);
__m256i  __builtin_ia32_psraw256_mask(...);
__m256i  __builtin_ia32_psrld256_mask(...);
__m256i  __builtin_ia32_psrlq256_mask(...);
__m256i  __builtin_ia32_psrlv16hi_mask(...);
__m256i  __builtin_ia32_psrlv4di_mask(...);
__m256i  __builtin_ia32_psrlv8si_mask(...);
__m256i  __builtin_ia32_psrlw256_mask(...);
__m256i  __builtin_ia32_psubb256(...);
__m256i  __builtin_ia32_psubd256(...);
__m256i  __builtin_ia32_psubd256_mask(...);
__m256i  __builtin_ia32_psubq256(...);
__m256i  __builtin_ia32_psubsb256(...);
__m256i  __builtin_ia32_psubw256(...);
__m256i  __builtin_ia32_psubw256_mask(...);
__m256i  __builtin_ia32_punpckhbw256_mask(...);
__m256i  __builtin_ia32_punpckhdq256_mask(...);
__m256i  __builtin_ia32_punpckhqdq256_mask(...);
__m256i  __builtin_ia32_punpckhwd256_mask(...);
__m256i  __builtin_ia32_punpcklbw256_mask(...);
__m256i  __builtin_ia32_punpckldq256_mask(...);
__m256i  __builtin_ia32_punpcklqdq256_mask(...);
__m256i  __builtin_ia32_punpcklwd256_mask(...);
__m256i  __builtin_ia32_pxor256(...);
__m256i  __builtin_ia32_vpconflictdi_256_mask(...);
__m256i  __builtin_ia32_vpconflictsi_256_mask(...);
__m256i  __builtin_ia32_vpermi2vard256_mask(...);
__m256i  __builtin_ia32_vpermi2varhi256_mask(...);
__m256i  __builtin_ia32_vpermi2varq256_mask(...);
__m256i  __builtin_ia32_vpermi2varqi256_mask(...);
__m256i  __builtin_ia32_vpermt2vard256_mask(...);
__m256i  __builtin_ia32_vpermt2vard256_maskz(...);
__m256i  __builtin_ia32_vpermt2varhi256_mask(...);
__m256i  __builtin_ia32_vpermt2varhi256_maskz(...);
__m256i  __builtin_ia32_vpermt2varq256_mask(...);
__m256i  __builtin_ia32_vpermt2varq256_maskz(...);
__m256i  __builtin_ia32_vpermt2varqi256_mask(...);
__m256i  __builtin_ia32_vpermt2varqi256_maskz(...);
__m256i  __builtin_ia32_vplzcntd_256_mask(...);
__m256i  __builtin_ia32_vplzcntq_256_mask(...);
__m256i  __builtin_ia32_vpmadd52huq256_mask(...);
__m256i  __builtin_ia32_vpmadd52huq256_maskz(...);
__m256i  __builtin_ia32_vpmadd52luq256_mask(...);
__m256i  __builtin_ia32_vpmadd52luq256_maskz(...);
__m256i  __builtin_ia32_vpmultishiftqb256_mask(...);
__m256i __builtin_ia32_andnotsi256(...);
__m256i __builtin_ia32_lddqu256(...);
__m256i __builtin_ia32_loaddqu256(...);
__m256i __builtin_ia32_pabsd256(...);
__m256i __builtin_ia32_pbroadcastd256(...);
__m256i __builtin_ia32_pmovdw512_mask(...);
__m256i __builtin_ia32_pmovqd512_mask(...);
__m256i __builtin_ia32_pmovsdw512_mask(...);
__m256i __builtin_ia32_pmovsqd512_mask(...);
__m256i __builtin_ia32_pmovusdw512_mask(...);
__m256i __builtin_ia32_pmovusqd512_mask(...);
__m256i __builtin_ia32_punpckhbw256(...);
__m256i __builtin_ia32_punpckhdq256(...);
__m256i __builtin_ia32_punpckhqdq256(...);
__m256i __builtin_ia32_punpckhwd256(...);
__m256i __builtin_ia32_punpcklbw256(...);
__m256i __builtin_ia32_punpckldq256(...);
__m256i __builtin_ia32_punpcklqdq256(...);
__m256i __builtin_ia32_punpcklwd256(...);
__m256i __builtin_ia32_si256_si(...);
__m256i __builtin_ia32_vbroadcastsi256(...);
__m512  __builtin_ia32_addps512_mask(...);
__m512  __builtin_ia32_blendmps_512_mask(...);
__m512  __builtin_ia32_broadcastf32x2_512_mask(...);
__m512  __builtin_ia32_broadcastf32x8_512_mask(...);
__m512  __builtin_ia32_compresssf512_mask(...);
__m512  __builtin_ia32_cvtdq2ps512_mask(...);
__m512  __builtin_ia32_cvtudq2ps512_mask(...);
__m512  __builtin_ia32_divps512_mask(...);
__m512  __builtin_ia32_exp2ps_mask(...);
__m512  __builtin_ia32_expandloadsf512_mask(...);
__m512  __builtin_ia32_expandloadsf512_maskz(...);
__m512  __builtin_ia32_expandsf512_mask(...);
__m512  __builtin_ia32_expandsf512_maskz(...);
__m512  __builtin_ia32_loadaps512_mask(...);
__m512  __builtin_ia32_loadups512_mask(...);
__m512  __builtin_ia32_maxps512_mask(...);
__m512  __builtin_ia32_minps512_mask(...);
__m512  __builtin_ia32_movshdup512_mask(...);
__m512  __builtin_ia32_movsldup512_mask(...);
__m512  __builtin_ia32_mulps512_mask(...);
__m512  __builtin_ia32_permvarsf512_mask(...);
__m512  __builtin_ia32_ps512_256ps(...);
__m512  __builtin_ia32_ps512_ps(...);
__m512  __builtin_ia32_rcp14ps512_mask(...);
__m512  __builtin_ia32_rndscaleps_mask(...);
__m512  __builtin_ia32_rsqrt14ps512_mask(...);
__m512  __builtin_ia32_scalefps512_mask(...);
__m512  __builtin_ia32_sqrtps512_mask(...);
__m512  __builtin_ia32_subps512_mask(...);
__m512  __builtin_ia32_unpckhps512_mask(...);
__m512  __builtin_ia32_unpcklps512_mask(...);
__m512  __builtin_ia32_vcvtph2ps512_mask(...);
__m512  __builtin_ia32_vfmaddps512_mask(...);
__m512  __builtin_ia32_vfmaddps512_mask3(...);
__m512  __builtin_ia32_vfmaddps512_maskz(...);
__m512  __builtin_ia32_vfmaddsubps512_mask(...);
__m512  __builtin_ia32_vfmaddsubps512_mask3(...);
__m512  __builtin_ia32_vfmaddsubps512_maskz(...);
__m512  __builtin_ia32_vfmsubaddps512_mask3(...);
__m512  __builtin_ia32_vfmsubps512_mask3(...);
__m512  __builtin_ia32_vfnmaddps512_mask(...);
__m512  __builtin_ia32_vfnmsubps512_mask(...);
__m512  __builtin_ia32_vfnmsubps512_mask3(...);
__m512  __builtin_ia32_vpermi2varps512_mask(...);
__m512  __builtin_ia32_vpermilvarps512_mask(...);
__m512  __builtin_ia32_vpermt2varps512_mask(...);
__m512  __builtin_ia32_vpermt2varps512_maskz(...);
__m512 __builtin_ia32_broadcastf32x4_512(...);
__m512 __builtin_ia32_broadcastss512(...);
__m512 __builtin_ia32_movaps512_mask(...);
__m512d  __builtin_ia32_addpd512_mask(...);
__m512d  __builtin_ia32_blendmpd_512_mask(...);
__m512d  __builtin_ia32_broadcastf64x2_512_mask(...);
__m512d  __builtin_ia32_compressdf512_mask(...);
__m512d  __builtin_ia32_cvtdq2pd512_mask(...);
__m512d  __builtin_ia32_cvtps2pd512_mask(...);
__m512d  __builtin_ia32_cvtqq2pd512_mask(...);
__m512d  __builtin_ia32_cvtudq2pd512_mask(...);
__m512d  __builtin_ia32_cvtuqq2pd512_mask(...);
__m512d  __builtin_ia32_divpd512_mask(...);
__m512d  __builtin_ia32_exp2pd_mask(...);
__m512d  __builtin_ia32_expanddf512_mask(...);
__m512d  __builtin_ia32_expanddf512_maskz(...);
__m512d  __builtin_ia32_expandloaddf512_mask(...);
__m512d  __builtin_ia32_expandloaddf512_maskz(...);
__m512d  __builtin_ia32_loadupd512_mask(...);
__m512d  __builtin_ia32_maxpd512_mask(...);
__m512d  __builtin_ia32_minpd512_mask(...);
__m512d  __builtin_ia32_movddup512_mask(...);
__m512d  __builtin_ia32_mulpd512_mask(...);
__m512d  __builtin_ia32_pd512_256pd(...);
__m512d  __builtin_ia32_pd512_pd(...);
__m512d  __builtin_ia32_permvardf512_mask(...);
__m512d  __builtin_ia32_rcp14pd512_mask(...);
__m512d  __builtin_ia32_rndscalepd_mask(...);
__m512d  __builtin_ia32_rsqrt14pd512_mask(...);
__m512d  __builtin_ia32_scalefpd512_mask(...);
__m512d  __builtin_ia32_sqrtpd512_mask(...);
__m512d  __builtin_ia32_subpd512_mask(...);
__m512d  __builtin_ia32_unpckhpd512_mask(...);
__m512d  __builtin_ia32_unpcklpd512_mask(...);
__m512d  __builtin_ia32_vfmaddpd512_mask(...);
__m512d  __builtin_ia32_vfmaddpd512_mask3(...);
__m512d  __builtin_ia32_vfmaddpd512_maskz(...);
__m512d  __builtin_ia32_vfmaddsubpd512_mask(...);
__m512d  __builtin_ia32_vfmaddsubpd512_mask3(...);
__m512d  __builtin_ia32_vfmaddsubpd512_maskz(...);
__m512d  __builtin_ia32_vfmsubaddpd512_mask3(...);
__m512d  __builtin_ia32_vfmsubpd512_mask3(...);
__m512d  __builtin_ia32_vfnmaddpd512_mask(...);
__m512d  __builtin_ia32_vfnmsubpd512_mask(...);
__m512d  __builtin_ia32_vfnmsubpd512_mask3(...);
__m512d  __builtin_ia32_vpermi2varpd512_mask(...);
__m512d  __builtin_ia32_vpermilvarpd512_mask(...);
__m512d  __builtin_ia32_vpermt2varpd512_mask(...);
__m512d  __builtin_ia32_vpermt2varpd512_maskz(...);
__m512d __builtin_ia32_broadcastf64x4_512(...);
__m512d __builtin_ia32_broadcastsd512(...);
__m512d __builtin_ia32_loadapd512_mask(...);
__m512d __builtin_ia32_movapd512_mask(...);
__m512i  __builtin_ia32_blendmd_512_mask(...);
__m512i  __builtin_ia32_blendmq_512_mask(...);
__m512i  __builtin_ia32_broadcasti32x2_512_mask(...);
__m512i  __builtin_ia32_broadcasti32x8_512_mask(...);
__m512i  __builtin_ia32_broadcasti64x2_512_mask(...);
__m512i  __builtin_ia32_broadcastmb512(...);
__m512i  __builtin_ia32_broadcastmw512(...);
__m512i  __builtin_ia32_compressdi512_mask(...);
__m512i  __builtin_ia32_compresssi512_mask(...);
__m512i  __builtin_ia32_cvtmask2b512(...);
__m512i  __builtin_ia32_cvtmask2d512(...);
__m512i  __builtin_ia32_cvtmask2q512(...);
__m512i  __builtin_ia32_cvtmask2w512(...);
__m512i  __builtin_ia32_cvtpd2qq512_mask(...);
__m512i  __builtin_ia32_cvtpd2uqq512_mask(...);
__m512i  __builtin_ia32_cvtps2dq512_mask(...);
__m512i  __builtin_ia32_cvtps2qq512_mask(...);
__m512i  __builtin_ia32_cvtps2udq512_mask(...);
__m512i  __builtin_ia32_cvtps2uqq512_mask(...);
__m512i  __builtin_ia32_cvttpd2qq512_mask(...);
__m512i  __builtin_ia32_cvttpd2uqq512_mask(...);
__m512i  __builtin_ia32_cvttps2dq512_mask(...);
__m512i  __builtin_ia32_cvttps2qq512_mask(...);
__m512i  __builtin_ia32_cvttps2udq512_mask(...);
__m512i  __builtin_ia32_cvttps2uqq512_mask(...);
__m512i  __builtin_ia32_expanddi512_mask(...);
__m512i  __builtin_ia32_expanddi512_maskz(...);
__m512i  __builtin_ia32_expandloaddi512_mask(...);
__m512i  __builtin_ia32_expandloaddi512_maskz(...);
__m512i  __builtin_ia32_expandloadsi512_mask(...);
__m512i  __builtin_ia32_expandloadsi512_maskz(...);
__m512i  __builtin_ia32_expandsi512_mask(...);
__m512i  __builtin_ia32_expandsi512_maskz(...);
__m512i  __builtin_ia32_loaddqudi512_mask(...);
__m512i  __builtin_ia32_loaddquhi512_mask(...);
__m512i  __builtin_ia32_loaddquqi512_mask(...);
__m512i  __builtin_ia32_loaddqusi512_mask(...);
__m512i  __builtin_ia32_movdquhi512_mask(...);
__m512i  __builtin_ia32_movdquqi512_mask(...);
__m512i  __builtin_ia32_movntdqa512(...);
__m512i  __builtin_ia32_pabsd512_mask(...);
__m512i  __builtin_ia32_pabsq512_mask(...);
__m512i  __builtin_ia32_paddd512_mask(...);
__m512i  __builtin_ia32_paddq512_mask(...);
__m512i  __builtin_ia32_pandd512_mask(...);
__m512i  __builtin_ia32_pandnd512_mask(...);
__m512i  __builtin_ia32_pandnq512_mask(...);
__m512i  __builtin_ia32_pandq512_mask(...);
__m512i  __builtin_ia32_pbroadcastb512_gpr_mask(...);
__m512i  __builtin_ia32_pbroadcastb512_mask(...);
__m512i  __builtin_ia32_pbroadcastd512_gpr_mask(...);
__m512i  __builtin_ia32_pbroadcastq512_gpr_mask(...);
__m512i  __builtin_ia32_pbroadcastw512_gpr_mask(...);
__m512i  __builtin_ia32_pbroadcastw512_mask(...);
__m512i  __builtin_ia32_permvardi512_mask(...);
__m512i  __builtin_ia32_permvarhi512_mask(...);
__m512i  __builtin_ia32_permvarqi512_mask(...);
__m512i  __builtin_ia32_permvarsi512_mask(...);
__m512i  __builtin_ia32_pmaddubsw512_mask(...);
__m512i  __builtin_ia32_pmaddwd512_mask(...);
__m512i  __builtin_ia32_pmaxsd512_mask(...);
__m512i  __builtin_ia32_pmaxsq512_mask(...);
__m512i  __builtin_ia32_pmaxud512_mask(...);
__m512i  __builtin_ia32_pmaxuq512_mask(...);
__m512i  __builtin_ia32_pminsd512_mask(...);
__m512i  __builtin_ia32_pminsq512_mask(...);
__m512i  __builtin_ia32_pminud512_mask(...);
__m512i  __builtin_ia32_pminuq512_mask(...);
__m512i  __builtin_ia32_pmovsxbw512_mask(...);
__m512i  __builtin_ia32_pmovzxbw512_mask(...);
__m512i  __builtin_ia32_pmuldq512_mask(...);
__m512i  __builtin_ia32_pmulhrsw512_mask(...);
__m512i  __builtin_ia32_pmulhuw512_mask(...);
__m512i  __builtin_ia32_pmulhw512_mask(...);
__m512i  __builtin_ia32_pmulld512_mask(...);
__m512i  __builtin_ia32_pmuludq512_mask(...);
__m512i  __builtin_ia32_pord512_mask(...);
__m512i  __builtin_ia32_porq512_mask(...);
__m512i  __builtin_ia32_psadbw512(...);
__m512i  __builtin_ia32_psllv32hi_mask(...);
__m512i  __builtin_ia32_psllw512_mask(...);
__m512i  __builtin_ia32_psrav32hi_mask(...);
__m512i  __builtin_ia32_psraw512_mask(...);
__m512i  __builtin_ia32_psrlv32hi_mask(...);
__m512i  __builtin_ia32_psrlw512_mask(...);
__m512i  __builtin_ia32_psubd512_mask(...);
__m512i  __builtin_ia32_psubq512_mask(...);
__m512i  __builtin_ia32_psubw512_mask(...);
__m512i  __builtin_ia32_punpckhbw512_mask(...);
__m512i  __builtin_ia32_punpckhdq512_mask(...);
__m512i  __builtin_ia32_punpckhqdq512_mask(...);
__m512i  __builtin_ia32_punpckhwd512_mask(...);
__m512i  __builtin_ia32_punpcklbw512_mask(...);
__m512i  __builtin_ia32_punpckldq512_mask(...);
__m512i  __builtin_ia32_punpcklqdq512_mask(...);
__m512i  __builtin_ia32_punpcklwd512_mask(...);
__m512i  __builtin_ia32_pxord512_mask(...);
__m512i  __builtin_ia32_pxorq512_mask(...);
__m512i  __builtin_ia32_si512_256si(...);
__m512i  __builtin_ia32_si512_si(...);
__m512i  __builtin_ia32_vpconflictdi_512_mask(...);
__m512i  __builtin_ia32_vpconflictsi_512_mask(...);
__m512i  __builtin_ia32_vpermi2vard512_mask(...);
__m512i  __builtin_ia32_vpermi2varhi512_mask(...);
__m512i  __builtin_ia32_vpermi2varq512_mask(...);
__m512i  __builtin_ia32_vpermi2varqi512_mask(...);
__m512i  __builtin_ia32_vpermt2vard512_mask(...);
__m512i  __builtin_ia32_vpermt2vard512_maskz(...);
__m512i  __builtin_ia32_vpermt2varhi512_mask(...);
__m512i  __builtin_ia32_vpermt2varhi512_maskz(...);
__m512i  __builtin_ia32_vpermt2varq512_mask(...);
__m512i  __builtin_ia32_vpermt2varq512_maskz(...);
__m512i  __builtin_ia32_vpermt2varqi512_mask(...);
__m512i  __builtin_ia32_vpermt2varqi512_maskz(...);
__m512i  __builtin_ia32_vplzcntd_512_mask(...);
__m512i  __builtin_ia32_vplzcntq_512_mask(...);
__m512i  __builtin_ia32_vpmadd52huq512_mask(...);
__m512i  __builtin_ia32_vpmadd52huq512_maskz(...);
__m512i  __builtin_ia32_vpmadd52luq512_mask(...);
__m512i  __builtin_ia32_vpmadd52luq512_maskz(...);
__m512i  __builtin_ia32_vpmultishiftqb512_mask(...);
__m512i __builtin_ia32_broadcasti32x4_512(...);
__m512i __builtin_ia32_broadcasti64x4_512(...);
__m512i __builtin_ia32_movdqa32_512_mask(...);
__m512i __builtin_ia32_movdqa32load512_mask(...);
__m512i __builtin_ia32_movdqa64_512_mask(...);
__m512i __builtin_ia32_movdqa64load512_mask(...);
__m512i __builtin_ia32_pbroadcastd512(...);
__m512i __builtin_ia32_pbroadcastq512(...);
__m512i __builtin_ia32_pbroadcastq512_mem_mask(...);
__m512i __builtin_ia32_pmovsxbd512_mask(...);
__m512i __builtin_ia32_pmovsxbq512_mask(...);
__m512i __builtin_ia32_pmovsxdq512_mask(...);
__m512i __builtin_ia32_pmovsxwd512_mask(...);
__m512i __builtin_ia32_pmovsxwq512_mask(...);
__m512i __builtin_ia32_pmovzxbd512_mask(...);
__m512i __builtin_ia32_pmovzxbq512_mask(...);
__m512i __builtin_ia32_pmovzxdq512_mask(...);
__m512i __builtin_ia32_pmovzxwd512_mask(...);
__m512i __builtin_ia32_pmovzxwq512_mask(...);
__m512i __builtin_ia32_prolvd512_mask(...);
__m512i __builtin_ia32_prolvq512_mask(...);
__m512i __builtin_ia32_prorvd512_mask(...);
__m512i __builtin_ia32_prorvq512_mask(...);
__m512i __builtin_ia32_pslld512_mask(...);
__m512i __builtin_ia32_psllq512_mask(...);
__m512i __builtin_ia32_psllv16si_mask(...);
__m512i __builtin_ia32_psllv8di_mask(...);
__m512i __builtin_ia32_psrad512_mask(...);
__m512i __builtin_ia32_psraq512_mask(...);
__m512i __builtin_ia32_psrav16si_mask(...);
__m512i __builtin_ia32_psrav8di_mask(...);
__m512i __builtin_ia32_psrld512_mask(...);
__m512i __builtin_ia32_psrlq512_mask(...);
__m512i __builtin_ia32_psrlv16si_mask(...);
__m512i __builtin_ia32_psrlv8di_mask(...);
__m64 __builtin_ia32_pandn(...);
__m64 __builtin_ia32_pcmpeqb(...);
__m64 __builtin_ia32_pcmpeqd(...);
__m64 __builtin_ia32_pcmpeqw(...);
__m64 __builtin_ia32_pcmpgtb(...);
__m64 __builtin_ia32_pcmpgtd(...);
__m64 __builtin_ia32_pcmpgtw(...);
__m64 __builtin_ia32_pfcmpeq(...);
__m64 __builtin_ia32_pfsubr(...);
__m64 __builtin_ia32_por(...);
__m64 __builtin_ia32_punpckhbw(...);
__m64 __builtin_ia32_punpckhdq(...);
__m64 __builtin_ia32_punpckhwd(...);
__m64 __builtin_ia32_punpcklbw(...);
__m64 __builtin_ia32_punpckldq(...);
__m64 __builtin_ia32_punpcklwd(...);
__m64 __builtin_ia32_pxor(...);
__m64 __builtin_ia32_vec_init_v2si(...);
__mmask16  __builtin_ia32_cmpd512_mask(...);
__mmask16  __builtin_ia32_cvtb2mask128(...);
__mmask16  __builtin_ia32_cvtd2mask512(...);
__mmask16  __builtin_ia32_cvtw2mask256(...);
__mmask16  __builtin_ia32_kandhi(...);
__mmask16  __builtin_ia32_kandnhi(...);
__mmask16  __builtin_ia32_kmov16(...);
__mmask16  __builtin_ia32_knothi(...);
__mmask16  __builtin_ia32_korhi(...);
__mmask16  __builtin_ia32_kunpckhi(...);
__mmask16  __builtin_ia32_kxnorhi(...);
__mmask16  __builtin_ia32_kxorhi(...);
__mmask16  __builtin_ia32_pcmpeqb128_mask(...);
__mmask16  __builtin_ia32_pcmpeqd512_mask(...);
__mmask16  __builtin_ia32_pcmpgtb128_mask(...);
__mmask16  __builtin_ia32_pcmpgtd512_mask(...);
__mmask16  __builtin_ia32_ptestmb128(...);
__mmask16  __builtin_ia32_ptestmd512(...);
__mmask16  __builtin_ia32_ptestmw256(...);
__mmask16  __builtin_ia32_ptestnmb128(...);
__mmask16  __builtin_ia32_ptestnmd512(...);
__mmask16  __builtin_ia32_ptestnmw256(...);
__mmask16  __builtin_ia32_ucmpd512_mask(...);
__mmask32  __builtin_ia32_cvtb2mask256(...);
__mmask32  __builtin_ia32_cvtw2mask512(...);
__mmask32  __builtin_ia32_kunpcksi(...);
__mmask32  __builtin_ia32_pcmpeqb256_mask(...);
__mmask32  __builtin_ia32_pcmpgtb256_mask(...);
__mmask32  __builtin_ia32_ptestmb256(...);
__mmask32  __builtin_ia32_ptestmw512(...);
__mmask32  __builtin_ia32_ptestnmb256(...);
__mmask32  __builtin_ia32_ptestnmw512(...);
__mmask64  __builtin_ia32_cvtb2mask512(...);
__mmask64  __builtin_ia32_kunpckdi(...);
__mmask64  __builtin_ia32_pcmpeqb512_mask(...);
__mmask64  __builtin_ia32_ptestmb512(...);
__mmask64  __builtin_ia32_ptestnmb512(...);
__mmask8  __builtin_ia32_cmpq512_mask(...);
__mmask8  __builtin_ia32_cvtd2mask128(...);
__mmask8  __builtin_ia32_cvtd2mask256(...);
__mmask8  __builtin_ia32_cvtq2mask128(...);
__mmask8  __builtin_ia32_cvtq2mask256(...);
__mmask8  __builtin_ia32_cvtq2mask512(...);
__mmask8  __builtin_ia32_cvtw2mask128(...);
__mmask8  __builtin_ia32_pcmpeqd256_mask(...);
__mmask8  __builtin_ia32_pcmpeqq512_mask(...);
__mmask8  __builtin_ia32_pcmpgtq512_mask(...);
__mmask8  __builtin_ia32_ptestmd128(...);
__mmask8  __builtin_ia32_ptestmd256(...);
__mmask8  __builtin_ia32_ptestmq128(...);
__mmask8  __builtin_ia32_ptestmq256(...);
__mmask8  __builtin_ia32_ptestmq512(...);
__mmask8  __builtin_ia32_ptestmw128(...);
__mmask8  __builtin_ia32_ptestnmd128(...);
__mmask8  __builtin_ia32_ptestnmd256(...);
__mmask8  __builtin_ia32_ptestnmq128(...);
__mmask8  __builtin_ia32_ptestnmq256(...);
__mmask8  __builtin_ia32_ptestnmq512(...);
__mmask8  __builtin_ia32_ptestnmw128(...);
__mmask8  __builtin_ia32_ucmpd128_mask(...);
__mmask8  __builtin_ia32_ucmpd256_mask(...);
__mmask8  __builtin_ia32_ucmpq512_mask(...);
double __builtin_ia32_vec_ext_v2df(...);
int  __builtin_ia32_bsrdi(...);
int  __builtin_ia32_bsrsi(...);
int  __builtin_ia32_kortestchi(...);
int  __builtin_ia32_kortestzhi(...);
int  __builtin_ia32_rdseed_di_step(...);
int  __builtin_ia32_rdseed_hi_step(...);
int  __builtin_ia32_rdseed_si_step(...);
int  __builtin_ia32_vcvttsd2si32(...);
int  __builtin_ia32_vcvttss2si32(...);
int __builtin_ia32_comineq(...);
int __builtin_ia32_cvtss2si(...);
int __builtin_ia32_cvttsd2si(...);
int __builtin_ia32_cvttss2si(...);
int __builtin_ia32_vec_ext_v2si(...);
int __builtin_ia32_vec_ext_v4sf(...);
int __builtin_ia32_vec_ext_v4si(...);
long long __builtin_ia32_cvtss2si64(...);
long long __builtin_ia32_cvttsd2si64(...);
long long __builtin_ia32_cvttss2si64(...);
long long __builtin_ia32_vcvttsd2si64(...);
long long __builtin_ia32_vcvttss2si64(...);
long long __builtin_ia32_vec_ext_v2di(...);
unsigned  __builtin_ia32_vcvtsd2usi32(...);
unsigned  __builtin_ia32_vcvtss2usi32(...);
unsigned  __builtin_ia32_vcvttsd2usi32(...);
unsigned  __builtin_ia32_vcvttss2usi32(...);
unsigned char __builtin_ia32_addcarryx_u32(...);
unsigned char __builtin_ia32_addcarryx_u64(...);
unsigned char __builtin_ia32_rolqi(...);
unsigned char __builtin_ia32_rorqi(...);
unsigned char __builtin_ia32_sbb_u32(...);
unsigned char __builtin_ia32_sbb_u64(...);
unsigned int __builtin_ia32_rdfsbase32(...);
unsigned int __builtin_ia32_rdgsbase32(...);
unsigned long __builtin_ia32_rdfsbase64(...);
unsigned long __builtin_ia32_rdgsbase64(...);
unsigned long __builtin_ia32_readeflags_u64(...);
unsigned long __builtin_ia32_vcvtsd2usi64(...);
unsigned long __builtin_ia32_vcvtss2usi64(...);
unsigned long __builtin_ia32_vcvttsd2usi64(...);
unsigned long __builtin_ia32_vcvttss2usi64(...);
unsigned short __builtin_ia32_rolhi(...);
unsigned short __builtin_ia32_rorhi(...);
void  __builtin_ia32_clflushopt(...);
void  __builtin_ia32_clwb(...);
void  __builtin_ia32_compressstoredf128_mask(...);
void  __builtin_ia32_compressstoredf256_mask(...);
void  __builtin_ia32_compressstoredf512_mask(...);
void  __builtin_ia32_compressstoredi128_mask(...);
void  __builtin_ia32_compressstoredi256_mask(...);
void  __builtin_ia32_compressstoredi512_mask(...);
void  __builtin_ia32_compressstoresf128_mask(...);
void  __builtin_ia32_compressstoresf256_mask(...);
void  __builtin_ia32_compressstoresf512_mask(...);
void  __builtin_ia32_compressstoresi128_mask(...);
void  __builtin_ia32_compressstoresi256_mask(...);
void  __builtin_ia32_compressstoresi512_mask(...);
void  __builtin_ia32_fxrstor(...);
void  __builtin_ia32_fxrstor64(...);
void  __builtin_ia32_fxsave(...);
void  __builtin_ia32_fxsave64(...);
void  __builtin_ia32_movdqa32store128_mask(...);
void  __builtin_ia32_movdqa32store256_mask(...);
void  __builtin_ia32_movdqa64store128_mask(...);
void  __builtin_ia32_movdqa64store256_mask(...);
void  __builtin_ia32_movntdq512(...);
void  __builtin_ia32_movntpd512(...);
void  __builtin_ia32_movntps512(...);
void  __builtin_ia32_pause(...);
void  __builtin_ia32_pcommit(...);
void  __builtin_ia32_pmovdb128mem_mask(...);
void  __builtin_ia32_pmovdb256mem_mask(...);
void  __builtin_ia32_pmovdw128mem_mask(...);
void  __builtin_ia32_pmovdw256mem_mask(...);
void  __builtin_ia32_pmovqb128mem_mask(...);
void  __builtin_ia32_pmovqb256mem_mask(...);
void  __builtin_ia32_pmovqb512mem_mask(...);
void  __builtin_ia32_pmovqd128mem_mask(...);
void  __builtin_ia32_pmovqd256mem_mask(...);
void  __builtin_ia32_pmovqw128mem_mask(...);
void  __builtin_ia32_pmovqw256mem_mask(...);
void  __builtin_ia32_pmovsdb128mem_mask(...);
void  __builtin_ia32_pmovsdb256mem_mask(...);
void  __builtin_ia32_pmovsdw128mem_mask(...);
void  __builtin_ia32_pmovsdw256mem_mask(...);
void  __builtin_ia32_pmovsqb128mem_mask(...);
void  __builtin_ia32_pmovsqb256mem_mask(...);
void  __builtin_ia32_pmovsqb512mem_mask(...);
void  __builtin_ia32_pmovsqd128mem_mask(...);
void  __builtin_ia32_pmovsqd256mem_mask(...);
void  __builtin_ia32_pmovsqw128mem_mask(...);
void  __builtin_ia32_pmovsqw256mem_mask(...);
void  __builtin_ia32_pmovsqw512mem_mask(...);
void  __builtin_ia32_pmovusdb128mem_mask(...);
void  __builtin_ia32_pmovusdb256mem_mask(...);
void  __builtin_ia32_pmovusdw128mem_mask(...);
void  __builtin_ia32_pmovusdw256mem_mask(...);
void  __builtin_ia32_pmovusqb128mem_mask(...);
void  __builtin_ia32_pmovusqb256mem_mask(...);
void  __builtin_ia32_pmovusqb512mem_mask(...);
void  __builtin_ia32_pmovusqd128mem_mask(...);
void  __builtin_ia32_pmovusqd256mem_mask(...);
void  __builtin_ia32_pmovusqw128mem_mask(...);
void  __builtin_ia32_pmovusqw256mem_mask(...);
void  __builtin_ia32_pmovusqw512mem_mask(...);
void  __builtin_ia32_storeapd128_mask(...);
void  __builtin_ia32_storeapd256_mask(...);
void  __builtin_ia32_storeapd512_mask(...);
void  __builtin_ia32_storeaps128_mask(...);
void  __builtin_ia32_storeaps256_mask(...);
void  __builtin_ia32_storeaps512_mask(...);
void  __builtin_ia32_storedqudi128_mask(...);
void  __builtin_ia32_storedqudi256_mask(...);
void  __builtin_ia32_storedqudi512_mask(...);
void  __builtin_ia32_storedquhi128_mask(...);
void  __builtin_ia32_storedquhi256_mask(...);
void  __builtin_ia32_storedquhi512_mask(...);
void  __builtin_ia32_storedquqi128_mask(...);
void  __builtin_ia32_storedquqi256_mask(...);
void  __builtin_ia32_storedquqi512_mask(...);
void  __builtin_ia32_storedqusi128_mask(...);
void  __builtin_ia32_storedqusi256_mask(...);
void  __builtin_ia32_storedqusi512_mask(...);
void  __builtin_ia32_storeupd128_mask(...);
void  __builtin_ia32_storeupd256_mask(...);
void  __builtin_ia32_storeupd512_mask(...);
void  __builtin_ia32_storeups128_mask(...);
void  __builtin_ia32_storeups256_mask(...);
void  __builtin_ia32_storeups512_mask(...);
void  __builtin_ia32_wrfsbase32(...);
void  __builtin_ia32_wrfsbase64(...);
void  __builtin_ia32_wrgsbase32(...);
void  __builtin_ia32_wrgsbase64(...);
void  __builtin_ia32_writeeflags_u64(...);
void  __builtin_ia32_xrstor(...);
void  __builtin_ia32_xrstor64(...);
void  __builtin_ia32_xrstors(...);
void  __builtin_ia32_xrstors64(...);
void  __builtin_ia32_xsave(...);
void  __builtin_ia32_xsave64(...);
void  __builtin_ia32_xsavec(...);
void  __builtin_ia32_xsavec64(...);
void  __builtin_ia32_xsaveopt(...);
void  __builtin_ia32_xsaveopt64(...);
void  __builtin_ia32_xsaves(...);
void  __builtin_ia32_xsaves64(...);
void * __builtin_ia32_slwpcb(...);
void __builtin_ia32_clflush(...);
void __builtin_ia32_llwpcb(...);
void __builtin_ia32_monitor(...);
void __builtin_ia32_monitorx(...);
void __builtin_ia32_movdqa32store512_mask(...);
void __builtin_ia32_movdqa64store512_mask(...);
void __builtin_ia32_movntps(...);
void __builtin_ia32_movntss(...);
void __builtin_ia32_mwaitx(...);
void __builtin_ia32_pmovdb512mem_mask(...);
void __builtin_ia32_pmovdw512mem_mask(...);
void __builtin_ia32_pmovqd512mem_mask(...);
void __builtin_ia32_pmovqw512mem_mask(...);
void __builtin_ia32_pmovsdb512mem_mask(...);
void __builtin_ia32_pmovsdw512mem_mask(...);
void __builtin_ia32_pmovsqd512mem_mask(...);
void __builtin_ia32_pmovusdb512mem_mask(...);
void __builtin_ia32_pmovusdw512mem_mask(...);
void __builtin_ia32_pmovusqd512mem_mask(...);
void __builtin_ia32_sfence(...);
}
