/*
    This file is part of KDevelop

    Copyright 2015 Milian Wolff <mail@milianw.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

// this file is automatically included by our clang backend for C/C++ projects
// to increase compatibility with GCC by adding some __m64rinsics etc.
// this is required to remove parse errors in GCC headers when using a
// GCC toolchain

inline namespace KDevelopClangGccCompat {

typedef int __m64 __attribute__ ((__vector_size__ (8), __may_alias__));

typedef float __m128 __attribute__ ((__vector_size__ (16), __may_alias__));
typedef long long __m128i __attribute__ ((__vector_size__ (16), __may_alias__));
typedef double __m128d __attribute__ ((__vector_size__ (16), __may_alias__));

typedef float __m256 __attribute__ ((__vector_size__ (32), __may_alias__));
typedef long long __m256i __attribute__ ((__vector_size__ (32), __may_alias__));
typedef double __m256d __attribute__ ((__vector_size__ (32), __may_alias__));

typedef float __m512 __attribute__ ((__vector_size__ (64), __may_alias__));
typedef long long __m512i __attribute__ ((__vector_size__ (64), __may_alias__));
typedef double __m512d __attribute__ ((__vector_size__ (64), __may_alias__));

typedef unsigned char __mmask8;
typedef unsigned short __mmask16;
typedef unsigned int __mmask32;
typedef unsigned long long __mmask64;

//
// the below was generated using the following bash magic:
//
// tests/test_duchain-clang testGccCompatibility | grep -Po "\b__builtin_[a-z_A-Z0-9]*\b" | sort | uniq > /tmp/builtins.txt
// then, in your GCC include path, e.g. /usr/lib/gcc/x86_64-unknown-linux-gnu/5.2.0/include:
// (while read f; do r=$(ack "\b$f\b" -B 5 -1 | grep "extern __inline" | awk '{printf "%s",$3; if ($4 !~ /__attrib/) printf " %s",$4;}'); echo "$r $f(...);"; done) < /tmp/builtins.txt
//
// these steps may need to be repeated multiple times
//

__m128d __builtin_ia32_addsd(...);
__m128 __builtin_ia32_addss(...);
__m128d __builtin_ia32_andnpd(...);
__m128 __builtin_ia32_andnps(...);
__m128d __builtin_ia32_andpd(...);
__m128 __builtin_ia32_andps(...);
int  __builtin_ia32_bsrdi(...);
int  __builtin_ia32_bsrsi(...);
__m128d __builtin_ia32_cmpgepd(...);
__m128 __builtin_ia32_cmpgeps(...);
__m128d __builtin_ia32_cmpgtpd(...);
__m128 __builtin_ia32_cmpgtps(...);
__m128 __builtin_ia32_cmpleps(...);
__m128 __builtin_ia32_cmpltps(...);
__m128d __builtin_ia32_cmpngepd(...);
__m128 __builtin_ia32_cmpngeps(...);
__m128d __builtin_ia32_cmpngtpd(...);
__m128 __builtin_ia32_cmpngtps(...);
__m128 __builtin_ia32_cmpnleps(...);
__m128 __builtin_ia32_cmpnltps(...);
__m128 __builtin_ia32_cvtpi2ps(...);
__m128 __builtin_ia32_cvtsd2ss(...);
__m128d __builtin_ia32_cvtsi2sd(...);
__m128 __builtin_ia32_cvtsi2ss(...);
__m128d __builtin_ia32_cvtsi642sd(...);
__m128 __builtin_ia32_cvtsi642ss(...);
__m128d __builtin_ia32_cvtss2sd(...);
int __builtin_ia32_cvtss2si(...);
long long __builtin_ia32_cvtss2si64(...);
int __builtin_ia32_cvttsd2si(...);
long long __builtin_ia32_cvttsd2si64(...);
int __builtin_ia32_cvttss2si(...);
long long __builtin_ia32_cvttss2si64(...);
__m128d __builtin_ia32_divsd(...);
__m128 __builtin_ia32_divss(...);
__m128 __builtin_ia32_haddps(...);
__m128i __builtin_ia32_loaddqu(...);
__m128d __builtin_ia32_loadhpd(...);
__m128 __builtin_ia32_loadhps(...);
__m128d __builtin_ia32_loadlpd(...);
__m128 __builtin_ia32_loadlps(...);
__m128d __builtin_ia32_loadupd(...);
__m128 __builtin_ia32_loadups(...);
__m128 __builtin_ia32_minss(...);
__m128 __builtin_ia32_movhlps(...);
__m128 __builtin_ia32_movlhps(...);
void __builtin_ia32_movntps(...);
__m128i __builtin_ia32_movq128(...);
__m128d __builtin_ia32_movsd(...);
__m128 __builtin_ia32_movss(...);
__m128d __builtin_ia32_mulsd(...);
__m128 __builtin_ia32_mulss(...);
__m128d __builtin_ia32_orpd(...);
__m128 __builtin_ia32_orps(...);
void  __builtin_ia32_pause(...);
__m64 __builtin_ia32_por(...);
__m128i __builtin_ia32_punpckhbw128(...);
__m128i __builtin_ia32_punpckhwd128(...);
unsigned long __builtin_ia32_readeflags_u64(...);
unsigned short __builtin_ia32_rolhi(...);
unsigned char __builtin_ia32_rolqi(...);
unsigned short __builtin_ia32_rorhi(...);
unsigned char __builtin_ia32_rorqi(...);
__m128d __builtin_ia32_shufpd(...);
__m128 __builtin_ia32_shufps(...);
__m128d __builtin_ia32_subsd(...);
__m128 __builtin_ia32_subss(...);
__m128d __builtin_ia32_unpckhpd(...);
__m128 __builtin_ia32_unpckhps(...);
__m128d __builtin_ia32_unpcklpd(...);
__m128 __builtin_ia32_unpcklps(...);
int __builtin_ia32_vec_ext_v4si(...);
void  __builtin_ia32_writeeflags_u64(...);
__m128d __builtin_ia32_xorpd(...);
__m128 __builtin_ia32_xorps(...);
__m256i __builtin_ia32_andnotsi256(...);
__m256d __builtin_ia32_andnpd256(...);
__m256 __builtin_ia32_andnps256(...);
__m256d __builtin_ia32_andpd256(...);
__m256 __builtin_ia32_andps256(...);
__m512d __builtin_ia32_broadcastsd512(...);
__m512 __builtin_ia32_broadcastss512(...);
__m256d __builtin_ia32_haddpd256(...);
__m256 __builtin_ia32_haddps256(...);
__m256i __builtin_ia32_lddqu256(...);
__m512d __builtin_ia32_loadapd512_mask(...);
__m256i __builtin_ia32_loaddqu256(...);
__m256d __builtin_ia32_loadupd256(...);
__m256 __builtin_ia32_loadups256(...);
__m512d __builtin_ia32_movapd512_mask(...);
__m512 __builtin_ia32_movaps512_mask(...);
__m256d __builtin_ia32_movddup256(...);
__m512i __builtin_ia32_movdqa32_512_mask(...);
__m512i __builtin_ia32_movdqa32load512_mask(...);
__m512i __builtin_ia32_movdqa64_512_mask(...);
__m512i __builtin_ia32_movdqa64load512_mask(...);
void __builtin_ia32_movdqa64store512_mask(...);
__m128i __builtin_ia32_movntdqa(...);
__m128 __builtin_ia32_movshdup(...);
__m256 __builtin_ia32_movshdup256(...);
__m128 __builtin_ia32_movsldup(...);
__m256 __builtin_ia32_movsldup256(...);
__m256d __builtin_ia32_orpd256(...);
__m256 __builtin_ia32_orps256(...);
__m256i __builtin_ia32_pabsd256(...);
__m128i __builtin_ia32_pandn128(...);
__m256i __builtin_ia32_pbroadcastd256(...);
__m256d __builtin_ia32_pd256_pd(...);
__m128d __builtin_ia32_pd_pd256(...);
__m256 __builtin_ia32_ps256_ps(...);
__m128 __builtin_ia32_ps_ps256(...);
__m64 __builtin_ia32_punpckhbw(...);
__m256i __builtin_ia32_punpckhbw256(...);
__m64 __builtin_ia32_punpckhdq(...);
__m128i __builtin_ia32_punpckhdq128(...);
__m256i __builtin_ia32_punpckhdq256(...);
__m128i __builtin_ia32_punpckhqdq128(...);
__m256i __builtin_ia32_punpckhqdq256(...);
__m64 __builtin_ia32_punpckhwd(...);
__m256i __builtin_ia32_punpckhwd256(...);
__m64 __builtin_ia32_punpcklbw(...);
__m128i __builtin_ia32_punpcklbw128(...);
__m256i __builtin_ia32_punpcklbw256(...);
__m64 __builtin_ia32_punpckldq(...);
__m128i __builtin_ia32_punpckldq128(...);
__m256i __builtin_ia32_punpckldq256(...);
__m128i __builtin_ia32_punpcklqdq128(...);
__m256i __builtin_ia32_punpcklqdq256(...);
__m64 __builtin_ia32_punpcklwd(...);
__m128i __builtin_ia32_punpcklwd128(...);
__m256i __builtin_ia32_punpcklwd256(...);
__m256 __builtin_ia32_rcpps256(...);
__m256i __builtin_ia32_si256_si(...);
__m128i __builtin_ia32_si_si256(...);
__m256d __builtin_ia32_unpckhpd256(...);
__m256 __builtin_ia32_unpckhps256(...);
__m256d __builtin_ia32_unpcklpd256(...);
__m256 __builtin_ia32_unpcklps256(...);
__m256d __builtin_ia32_vbroadcastsd256(...);
__m256i __builtin_ia32_vbroadcastsi256(...);
__m128 __builtin_ia32_vbroadcastss(...);
__m256 __builtin_ia32_vbroadcastss256(...);
__m128 __builtin_ia32_vbroadcastss_ps(...);
__m256d __builtin_ia32_xorpd256(...);
__m256 __builtin_ia32_xorps256(...);
void __builtin_ia32_movdqa32store512_mask(...);
__m512i __builtin_ia32_pmovsxbd512_mask(...);
__m512i __builtin_ia32_pmovsxbq512_mask(...);
__m512i __builtin_ia32_pmovsxdq512_mask(...);
__m512i __builtin_ia32_pmovsxwd512_mask(...);
__m512i __builtin_ia32_pmovsxwq512_mask(...);
__m512i __builtin_ia32_pmovzxbd512_mask(...);
__m512i __builtin_ia32_pslld512_mask(...);
__m512i __builtin_ia32_psllq512_mask(...);
__m512i __builtin_ia32_psllv16si_mask(...);
__m512i __builtin_ia32_psllv8di_mask(...);
__m512i __builtin_ia32_psrad512_mask(...);
__m512i __builtin_ia32_psraq512_mask(...);
__m512i __builtin_ia32_psrav16si_mask(...);
__m512i __builtin_ia32_psrav8di_mask(...);
__m512i __builtin_ia32_psrld512_mask(...);
__m512i __builtin_ia32_psrlq512_mask(...);
__m512i __builtin_ia32_psrlv16si_mask(...);
__m512i __builtin_ia32_psrlv8di_mask(...);
__m128d __builtin_ia32_rcp14sd(...);
__m128 __builtin_ia32_rcp14ss(...);
__m128d __builtin_ia32_rsqrt14sd(...);
__m128 __builtin_ia32_rsqrt14ss(...);
__m512 __builtin_ia32_broadcastf32x4_512(...);
__m512d __builtin_ia32_broadcastf64x4_512(...);
__m512i __builtin_ia32_broadcasti32x4_512(...);
__m512i __builtin_ia32_broadcasti64x4_512(...);
__m128d __builtin_ia32_cvtusi2sd32(...);
__m512i __builtin_ia32_pbroadcastd512(...);
__m512i __builtin_ia32_pbroadcastq512(...);
__m128i __builtin_ia32_pmovdb512_mask(...);
void __builtin_ia32_pmovdb512mem_mask(...);
__m256i __builtin_ia32_pmovdw512_mask(...);
void __builtin_ia32_pmovdw512mem_mask(...);
__m256i __builtin_ia32_pmovqd512_mask(...);
void __builtin_ia32_pmovqd512mem_mask(...);
__m128i __builtin_ia32_pmovqw512_mask(...);
void __builtin_ia32_pmovqw512mem_mask(...);
__m128i __builtin_ia32_pmovsdb512_mask(...);
void __builtin_ia32_pmovsdb512mem_mask(...);
__m256i __builtin_ia32_pmovsdw512_mask(...);
void __builtin_ia32_pmovsdw512mem_mask(...);
__m256i __builtin_ia32_pmovsqd512_mask(...);
void __builtin_ia32_pmovsqd512mem_mask(...);
__m128i __builtin_ia32_pmovusdb512_mask(...);
void __builtin_ia32_pmovusdb512mem_mask(...);
__m256i __builtin_ia32_pmovusdw512_mask(...);
void __builtin_ia32_pmovusdw512mem_mask(...);
__m256i __builtin_ia32_pmovusqd512_mask(...);
void __builtin_ia32_pmovusqd512mem_mask(...);
__m512i __builtin_ia32_pmovzxbq512_mask(...);
__m512i __builtin_ia32_pmovzxdq512_mask(...);
__m512i __builtin_ia32_pmovzxwd512_mask(...);
__m512i __builtin_ia32_pmovzxwq512_mask(...);
__m512i __builtin_ia32_prolvd512_mask(...);
__m512i __builtin_ia32_prolvq512_mask(...);
__m512i __builtin_ia32_prorvd512_mask(...);
__m512i __builtin_ia32_prorvq512_mask(...);
__m512d  __builtin_ia32_compressdf512_mask(...);
__m512d  __builtin_ia32_movddup512_mask(...);
void  __builtin_ia32_movntdq512(...);
__m512i  __builtin_ia32_movntdqa512(...);
void  __builtin_ia32_movntpd512(...);
void  __builtin_ia32_movntps512(...);
__m512  __builtin_ia32_movshdup512_mask(...);
__m512  __builtin_ia32_movsldup512_mask(...);
__mmask64  __builtin_ia32_pcmpeqb512_mask(...);
__m512d  __builtin_ia32_permvardf512_mask(...);
__m512i  __builtin_ia32_permvardi512_mask(...);
__m512  __builtin_ia32_permvarsf512_mask(...);
__m512i  __builtin_ia32_permvarsi512_mask(...);
__m128i  __builtin_ia32_pmovqb512_mask(...);
void  __builtin_ia32_pmovqb512mem_mask(...);
__m128i  __builtin_ia32_pmovsqb512_mask(...);
void  __builtin_ia32_pmovsqb512mem_mask(...);
__m128i  __builtin_ia32_pmovsqw512_mask(...);
void  __builtin_ia32_pmovsqw512mem_mask(...);
__m128i  __builtin_ia32_pmovusqb512_mask(...);
void  __builtin_ia32_pmovusqb512mem_mask(...);
__m128i  __builtin_ia32_pmovusqw512_mask(...);
void  __builtin_ia32_pmovusqw512mem_mask(...);
__mmask16  __builtin_ia32_ptestnmd512(...);
__mmask8  __builtin_ia32_ptestnmq512(...);
__m512i  __builtin_ia32_punpckhdq512_mask(...);
__m512i  __builtin_ia32_punpckhqdq512_mask(...);
__m512i  __builtin_ia32_punpckldq512_mask(...);
__m512i  __builtin_ia32_punpcklqdq512_mask(...);
__m512d  __builtin_ia32_unpckhpd512_mask(...);
__m512  __builtin_ia32_unpckhps512_mask(...);
__m512d  __builtin_ia32_unpcklpd512_mask(...);
__m512i  __builtin_ia32_vpermi2vard512_mask(...);
__m512d  __builtin_ia32_vpermi2varpd512_mask(...);
__m512  __builtin_ia32_vpermi2varps512_mask(...);
__m512i  __builtin_ia32_vpermi2varq512_mask(...);
__m512d  __builtin_ia32_vpermilvarpd512_mask(...);
__m512  __builtin_ia32_vpermilvarps512_mask(...);
__m512i  __builtin_ia32_vpermt2vard512_mask(...);
__m512i  __builtin_ia32_vpermt2vard512_maskz(...);
__m512d  __builtin_ia32_vpermt2varpd512_mask(...);
__m512d  __builtin_ia32_vpermt2varpd512_maskz(...);
__m512  __builtin_ia32_vpermt2varps512_mask(...);
__m512  __builtin_ia32_vpermt2varps512_maskz(...);
__m512i  __builtin_ia32_vpermt2varq512_mask(...);
__m512i  __builtin_ia32_vpermt2varq512_maskz(...);
__m512d  __builtin_ia32_addpd512_mask(...);
__m512  __builtin_ia32_addps512_mask(...);
__m512i  __builtin_ia32_broadcastmb512(...);
__m512i  __builtin_ia32_compressdi512_mask(...);
__m512  __builtin_ia32_compresssf512_mask(...);
__m512i  __builtin_ia32_compresssi512_mask(...);
void  __builtin_ia32_compressstoredf512_mask(...);
void  __builtin_ia32_compressstoredi512_mask(...);
void  __builtin_ia32_compressstoresf512_mask(...);
void  __builtin_ia32_compressstoresi512_mask(...);
__m512d  __builtin_ia32_cvtps2pd512_mask(...);
__m128d  __builtin_ia32_cvtusi2sd64(...);
__m128  __builtin_ia32_cvtusi2ss32(...);
__m128  __builtin_ia32_cvtusi2ss64(...);
__m512d  __builtin_ia32_divpd512_mask(...);
__m512  __builtin_ia32_divps512_mask(...);
__m512d  __builtin_ia32_expanddf512_mask(...);
__m512d  __builtin_ia32_expanddf512_maskz(...);
__m512i  __builtin_ia32_expanddi512_mask(...);
__m512i  __builtin_ia32_expanddi512_maskz(...);
__m512d  __builtin_ia32_expandloaddf512_mask(...);
__m512d  __builtin_ia32_expandloaddf512_maskz(...);
__m512i  __builtin_ia32_expandloaddi512_mask(...);
__m512i  __builtin_ia32_expandloaddi512_maskz(...);
__m512  __builtin_ia32_expandloadsf512_mask(...);
__m512  __builtin_ia32_expandloadsf512_maskz(...);
__m512i  __builtin_ia32_expandloadsi512_mask(...);
__m512i  __builtin_ia32_expandloadsi512_maskz(...);
__m512  __builtin_ia32_expandsf512_mask(...);
__m512  __builtin_ia32_expandsf512_maskz(...);
__m512i  __builtin_ia32_expandsi512_mask(...);
__m512i  __builtin_ia32_expandsi512_maskz(...);
__m128i  __builtin_ia32_extracti32x4_mask(...);
__mmask16  __builtin_ia32_kandhi(...);
__mmask16  __builtin_ia32_kandnhi(...);
__mmask16  __builtin_ia32_kmov16(...);
__mmask16  __builtin_ia32_korhi(...);
int  __builtin_ia32_kortestchi(...);
int  __builtin_ia32_kortestzhi(...);
__mmask16  __builtin_ia32_kunpckhi(...);
__mmask16  __builtin_ia32_kxnorhi(...);
__mmask16  __builtin_ia32_kxorhi(...);
__m512d  __builtin_ia32_mulpd512_mask(...);
__m512  __builtin_ia32_mulps512_mask(...);
__m512i  __builtin_ia32_pabsd512_mask(...);
__m64 __builtin_ia32_pandn(...);
__mmask16  __builtin_ia32_pcmpeqd512_mask(...);
__m512d  __builtin_ia32_pd512_256pd(...);
__m512d  __builtin_ia32_pd512_pd(...);
__m512  __builtin_ia32_ps512_256ps(...);
__m512  __builtin_ia32_ps512_ps(...);
__m64 __builtin_ia32_pxor(...);
__m512d  __builtin_ia32_scalefpd512_mask(...);
__m512  __builtin_ia32_scalefps512_mask(...);
__m128d  __builtin_ia32_scalefsd_round(...);
__m128  __builtin_ia32_scalefss_round(...);
__m512i  __builtin_ia32_si512_256si(...);
__m512i  __builtin_ia32_si512_si(...);
__m512d  __builtin_ia32_subpd512_mask(...);
__m512  __builtin_ia32_subps512_mask(...);
__m512  __builtin_ia32_unpcklps512_mask(...);
unsigned  __builtin_ia32_vcvtsd2usi32(...);
unsigned long __builtin_ia32_vcvtsd2usi64(...);
unsigned  __builtin_ia32_vcvtss2usi32(...);
unsigned long __builtin_ia32_vcvtss2usi64(...);
int  __builtin_ia32_vcvttsd2si32(...);
long long __builtin_ia32_vcvttsd2si64(...);
unsigned  __builtin_ia32_vcvttsd2usi32(...);
unsigned long __builtin_ia32_vcvttsd2usi64(...);
int  __builtin_ia32_vcvttss2si32(...);
long long __builtin_ia32_vcvttss2si64(...);
unsigned  __builtin_ia32_vcvttss2usi32(...);
unsigned long __builtin_ia32_vcvttss2usi64(...);
__m128d  __builtin_ia32_addpd128_mask(...);
__m256d  __builtin_ia32_addpd256_mask(...);
__m128  __builtin_ia32_addps128_mask(...);
__m256  __builtin_ia32_addps256_mask(...);
__m128d  __builtin_ia32_andpd128_mask(...);
__m256d  __builtin_ia32_andpd256_mask(...);
__m128  __builtin_ia32_andps128_mask(...);
__m256  __builtin_ia32_andps256_mask(...);
__m512i  __builtin_ia32_broadcastmw512(...);
__m128d  __builtin_ia32_loadapd128_mask(...);
__m256d  __builtin_ia32_loadapd256_mask(...);
__m128  __builtin_ia32_loadaps128_mask(...);
__m256  __builtin_ia32_loadaps256_mask(...);
__m512  __builtin_ia32_loadaps512_mask(...);
__m128i  __builtin_ia32_loaddqudi128_mask(...);
__m256i  __builtin_ia32_loaddqudi256_mask(...);
__m128i  __builtin_ia32_loaddqusi128_mask(...);
__m256i  __builtin_ia32_loaddqusi256_mask(...);
__m128d  __builtin_ia32_loadupd128_mask(...);
__m256d  __builtin_ia32_loadupd256_mask(...);
__m128  __builtin_ia32_loadups128_mask(...);
__m256  __builtin_ia32_loadups256_mask(...);
__m128d  __builtin_ia32_movapd128_mask(...);
__m256d  __builtin_ia32_movapd256_mask(...);
__m128  __builtin_ia32_movaps128_mask(...);
__m256  __builtin_ia32_movaps256_mask(...);
__m128i  __builtin_ia32_movdqa32_128_mask(...);
__m256i  __builtin_ia32_movdqa32_256_mask(...);
__m128i  __builtin_ia32_movdqa32load128_mask(...);
__m256i  __builtin_ia32_movdqa32load256_mask(...);
void  __builtin_ia32_movdqa32store128_mask(...);
void  __builtin_ia32_movdqa32store256_mask(...);
__m128i  __builtin_ia32_movdqa64_128_mask(...);
__m256i  __builtin_ia32_movdqa64_256_mask(...);
__m128i  __builtin_ia32_movdqa64load128_mask(...);
__m256i  __builtin_ia32_movdqa64load256_mask(...);
void  __builtin_ia32_movdqa64store128_mask(...);
void  __builtin_ia32_movdqa64store256_mask(...);
__m128i  __builtin_ia32_pabsd128_mask(...);
__m256i  __builtin_ia32_pabsd256_mask(...);
__m128i  __builtin_ia32_pbroadcastw128(...);
__m128i  __builtin_ia32_psubd128_mask(...);
void  __builtin_ia32_storeapd128_mask(...);
void  __builtin_ia32_storeapd256_mask(...);
void  __builtin_ia32_storeapd512_mask(...);
void  __builtin_ia32_storeaps128_mask(...);
void  __builtin_ia32_storeaps256_mask(...);
void  __builtin_ia32_storeaps512_mask(...);
void  __builtin_ia32_storedqudi128_mask(...);
void  __builtin_ia32_storedqudi256_mask(...);
void  __builtin_ia32_storedqusi128_mask(...);
void  __builtin_ia32_storedqusi256_mask(...);
void  __builtin_ia32_storeupd128_mask(...);
void  __builtin_ia32_storeupd256_mask(...);
void  __builtin_ia32_storeups128_mask(...);
void  __builtin_ia32_storeups256_mask(...);
__m128d  __builtin_ia32_subpd128_mask(...);
__m256d  __builtin_ia32_subpd256_mask(...);
__m128  __builtin_ia32_subps128_mask(...);
__m256  __builtin_ia32_subps256_mask(...);
__m128d  __builtin_ia32_cvtdq2pd128_mask(...);
__m256d  __builtin_ia32_cvtdq2pd256_mask(...);
__m512d  __builtin_ia32_cvtdq2pd512_mask(...);
__m128  __builtin_ia32_cvtdq2ps128_mask(...);
__m256  __builtin_ia32_cvtdq2ps256_mask(...);
__m128i  __builtin_ia32_cvtpd2dq128_mask(...);
__m128i  __builtin_ia32_cvtpd2dq256_mask(...);
__m128i  __builtin_ia32_cvtpd2udq128_mask(...);
__m128i  __builtin_ia32_cvtpd2udq256_mask(...);
__m128d  __builtin_ia32_cvtps2pd128_mask(...);
__m256d  __builtin_ia32_cvtps2pd256_mask(...);
__m128i  __builtin_ia32_cvttpd2dq128_mask(...);
__m128i  __builtin_ia32_cvttpd2dq256_mask(...);
__m128i  __builtin_ia32_cvttpd2udq128_mask(...);
__m128i  __builtin_ia32_cvttpd2udq256_mask(...);
__m128i  __builtin_ia32_cvttps2dq128_mask(...);
__m256i  __builtin_ia32_cvttps2dq256_mask(...);
__m128i  __builtin_ia32_cvttps2udq128_mask(...);
__m256i  __builtin_ia32_cvttps2udq256_mask(...);
__m128d  __builtin_ia32_cvtudq2pd128_mask(...);
__m256d  __builtin_ia32_cvtudq2pd256_mask(...);
__m512d  __builtin_ia32_cvtudq2pd512_mask(...);
__m128  __builtin_ia32_cvtudq2ps128_mask(...);
__m256  __builtin_ia32_cvtudq2ps256_mask(...);
__m128i  __builtin_ia32_pabsq128_mask(...);
__m256i  __builtin_ia32_pabsq256_mask(...);
__m128i  __builtin_ia32_pmovdb128_mask(...);
void  __builtin_ia32_pmovdb128mem_mask(...);
__m128i  __builtin_ia32_pmovdb256_mask(...);
void  __builtin_ia32_pmovdb256mem_mask(...);
__m128i  __builtin_ia32_pmovsdb128_mask(...);
void  __builtin_ia32_pmovsdb128mem_mask(...);
__m128i  __builtin_ia32_pmovsdb256_mask(...);
void  __builtin_ia32_pmovsdb256mem_mask(...);
__m128i  __builtin_ia32_pmovusdb128_mask(...);
void  __builtin_ia32_pmovusdb128mem_mask(...);
__m128i  __builtin_ia32_pabsw128_mask(...);
__m256i  __builtin_ia32_pabsw256_mask(...);
__mmask16  __builtin_ia32_pcmpeqb128_mask(...);
__mmask32  __builtin_ia32_pcmpeqb256_mask(...);
__m128i  __builtin_ia32_pmovdw128_mask(...);
void  __builtin_ia32_pmovdw128mem_mask(...);
__m128i  __builtin_ia32_pmovdw256_mask(...);
void  __builtin_ia32_pmovdw256mem_mask(...);
__m128i  __builtin_ia32_pmovqb128_mask(...);
void  __builtin_ia32_pmovqb128mem_mask(...);
__m128i  __builtin_ia32_pmovqb256_mask(...);
void  __builtin_ia32_pmovqb256mem_mask(...);
__m128i  __builtin_ia32_pmovqd128_mask(...);
void  __builtin_ia32_pmovqd128mem_mask(...);
__m128i  __builtin_ia32_pmovqd256_mask(...);
void  __builtin_ia32_pmovqd256mem_mask(...);
__m128i  __builtin_ia32_pmovqw128_mask(...);
void  __builtin_ia32_pmovqw128mem_mask(...);
__m128i  __builtin_ia32_pmovqw256_mask(...);
void  __builtin_ia32_pmovqw256mem_mask(...);
__m128i  __builtin_ia32_pmovsdw128_mask(...);
void  __builtin_ia32_pmovsdw128mem_mask(...);
__m128i  __builtin_ia32_pmovsdw256_mask(...);
void  __builtin_ia32_pmovsdw256mem_mask(...);
__m128i  __builtin_ia32_pmovsqb128_mask(...);
void  __builtin_ia32_pmovsqb128mem_mask(...);
__m128i  __builtin_ia32_pmovsqb256_mask(...);
void  __builtin_ia32_pmovsqb256mem_mask(...);
__m128i  __builtin_ia32_pmovsqd128_mask(...);
__m128i  __builtin_ia32_pmovsqw128_mask(...);
void  __builtin_ia32_pmovsqw128mem_mask(...);
__m128i  __builtin_ia32_pmovsqw256_mask(...);
void  __builtin_ia32_pmovsqw256mem_mask(...);
__m128i  __builtin_ia32_pmovusdb256_mask(...);
void  __builtin_ia32_pmovusdb256mem_mask(...);
__m128i  __builtin_ia32_pmovusdw128_mask(...);
void  __builtin_ia32_pmovusdw128mem_mask(...);
__m128i  __builtin_ia32_pmovusdw256_mask(...);
void  __builtin_ia32_pmovusdw256mem_mask(...);
__m128i  __builtin_ia32_pmovusqb128_mask(...);
void  __builtin_ia32_pmovusqb128mem_mask(...);
__m128i  __builtin_ia32_pmovusqb256_mask(...);
void  __builtin_ia32_pmovusqb256mem_mask(...);
__m128i  __builtin_ia32_pmovusqw128_mask(...);
void  __builtin_ia32_pmovusqw128mem_mask(...);
__m128i  __builtin_ia32_pmovusqw256_mask(...);
void  __builtin_ia32_pmovusqw256mem_mask(...);
__m256  __builtin_ia32_broadcastf32x4_256_mask(...);
__m256i  __builtin_ia32_broadcasti32x4_256_mask(...);
__m256d  __builtin_ia32_broadcastsd256_mask(...);
__m128  __builtin_ia32_broadcastss128_mask(...);
__m256  __builtin_ia32_broadcastss256_mask(...);
__m128i  __builtin_ia32_pabsb128_mask(...);
__m256i  __builtin_ia32_pabsb256_mask(...);
__m128i  __builtin_ia32_pbroadcastd128_gpr_mask(...);
__m128i  __builtin_ia32_pbroadcastd128_mask(...);
__m256i  __builtin_ia32_pbroadcastd256_gpr_mask(...);
__m256i  __builtin_ia32_pbroadcastd256_mask(...);
__m512i  __builtin_ia32_pbroadcastd512_gpr_mask(...);
__m128i  __builtin_ia32_pbroadcastq128_gpr_mask(...);
__m128i  __builtin_ia32_pbroadcastq128_mask(...);
__m256i  __builtin_ia32_pbroadcastq256_gpr_mask(...);
__m256i  __builtin_ia32_pbroadcastq256_mask(...);
__m512i  __builtin_ia32_pbroadcastq512_gpr_mask(...);
__mmask8  __builtin_ia32_pcmpeqd256_mask(...);
void  __builtin_ia32_pmovsqd128mem_mask(...);
__m128i  __builtin_ia32_pmovsqd256_mask(...);
void  __builtin_ia32_pmovsqd256mem_mask(...);
__m128i  __builtin_ia32_pmovsxbd128_mask(...);
__m256i  __builtin_ia32_pmovsxbd256_mask(...);
__m128i  __builtin_ia32_pmovsxbq128_mask(...);
__m256i  __builtin_ia32_pmovsxbq256_mask(...);
__m128i  __builtin_ia32_pmovsxdq128_mask(...);
__m256i  __builtin_ia32_pmovsxdq256_mask(...);
__m128i  __builtin_ia32_pmovsxwd128_mask(...);
__m256i  __builtin_ia32_pmovsxwd256_mask(...);
__m128i  __builtin_ia32_pmovsxwq128_mask(...);
__m256i  __builtin_ia32_pmovsxwq256_mask(...);
__m128i  __builtin_ia32_pmovusqd128_mask(...);
void  __builtin_ia32_pmovusqd128mem_mask(...);
__m128i  __builtin_ia32_pmovusqd256_mask(...);
void  __builtin_ia32_pmovusqd256mem_mask(...);
__m128i  __builtin_ia32_pmovzxbd128_mask(...);
__m256i  __builtin_ia32_pmovzxbd256_mask(...);
__m128i  __builtin_ia32_pmovzxbq128_mask(...);
__m256i  __builtin_ia32_pmovzxbq256_mask(...);
__m128i  __builtin_ia32_pmovzxwd128_mask(...);
__m256i  __builtin_ia32_pmovzxwd256_mask(...);
__m128i  __builtin_ia32_pmovzxwq128_mask(...);
__m256i  __builtin_ia32_pmovzxwq256_mask(...);
__m128  __builtin_ia32_cvtpd2ps_mask(...);
__m128d  __builtin_ia32_getexppd128_mask(...);
__m256d  __builtin_ia32_getexppd256_mask(...);
__m128  __builtin_ia32_getexpps128_mask(...);
__m256  __builtin_ia32_getexpps256_mask(...);
__m128i  __builtin_ia32_pmovzxdq128_mask(...);
__m256i  __builtin_ia32_pmovzxdq256_mask(...);
__m128i  __builtin_ia32_psrld128_mask(...);
__m256i  __builtin_ia32_psrld256_mask(...);
__m128i  __builtin_ia32_psrlq128_mask(...);
__m256i  __builtin_ia32_psrlq256_mask(...);
__m128d  __builtin_ia32_rcp14pd128_mask(...);
__m256d  __builtin_ia32_rcp14pd256_mask(...);
__m512d  __builtin_ia32_rcp14pd512_mask(...);
__m128  __builtin_ia32_rcp14ps128_mask(...);
__m256  __builtin_ia32_rcp14ps256_mask(...);
__m512  __builtin_ia32_rcp14ps512_mask(...);
__m128d  __builtin_ia32_rsqrt14pd128_mask(...);
__m256d  __builtin_ia32_rsqrt14pd256_mask(...);
__m512d  __builtin_ia32_rsqrt14pd512_mask(...);
__m128  __builtin_ia32_rsqrt14ps128_mask(...);
__m256  __builtin_ia32_rsqrt14ps256_mask(...);
__m512  __builtin_ia32_rsqrt14ps512_mask(...);
__m128d  __builtin_ia32_scalefpd128_mask(...);
__m256d  __builtin_ia32_scalefpd256_mask(...);
__m128  __builtin_ia32_scalefps128_mask(...);
__m256  __builtin_ia32_scalefps256_mask(...);
__m128d  __builtin_ia32_sqrtpd128_mask(...);
__m256d  __builtin_ia32_sqrtpd256_mask(...);
__m128  __builtin_ia32_sqrtps128_mask(...);
__m256  __builtin_ia32_sqrtps256_mask(...);
__m128d  __builtin_ia32_compressdf128_mask(...);
__m256d  __builtin_ia32_compressdf256_mask(...);
__m128i  __builtin_ia32_compressdi128_mask(...);
__m256i  __builtin_ia32_compressdi256_mask(...);
__m128  __builtin_ia32_compresssf128_mask(...);
__m256  __builtin_ia32_compresssf256_mask(...);
__m128i  __builtin_ia32_compresssi128_mask(...);
__m256i  __builtin_ia32_compresssi256_mask(...);
void  __builtin_ia32_compressstoredf128_mask(...);
void  __builtin_ia32_compressstoredf256_mask(...);
void  __builtin_ia32_compressstoredi128_mask(...);
void  __builtin_ia32_compressstoredi256_mask(...);
void  __builtin_ia32_compressstoresf128_mask(...);
void  __builtin_ia32_compressstoresf256_mask(...);
void  __builtin_ia32_compressstoresi128_mask(...);
void  __builtin_ia32_compressstoresi256_mask(...);
__m128  __builtin_ia32_cvtpd2ps256_mask(...);
__m128i  __builtin_ia32_cvtps2dq128_mask(...);
__m256i  __builtin_ia32_cvtps2dq256_mask(...);
__m128i  __builtin_ia32_cvtps2udq128_mask(...);
__m256i  __builtin_ia32_cvtps2udq256_mask(...);
__m128d  __builtin_ia32_expanddf128_mask(...);
__m128d  __builtin_ia32_expanddf128_maskz(...);
__m256d  __builtin_ia32_expanddf256_mask(...);
__m256d  __builtin_ia32_expanddf256_maskz(...);
__m256d  __builtin_ia32_expandloaddf256_mask(...);
__m256d  __builtin_ia32_expandloaddf256_maskz(...);
__m128d  __builtin_ia32_movddup128_mask(...);
__m256d  __builtin_ia32_movddup256_mask(...);
__m128  __builtin_ia32_movshdup128_mask(...);
__m256  __builtin_ia32_movshdup256_mask(...);
__m128  __builtin_ia32_movsldup128_mask(...);
__m256  __builtin_ia32_movsldup256_mask(...);
__m128i  __builtin_ia32_pandq128_mask(...);
__m256i  __builtin_ia32_pandq256_mask(...);
__mmask8  __builtin_ia32_ptestmd128(...);
__mmask8  __builtin_ia32_ptestmd256(...);
__mmask16  __builtin_ia32_ptestmd512(...);
__mmask8  __builtin_ia32_ptestmq128(...);
__mmask8  __builtin_ia32_ptestmq256(...);
__mmask8  __builtin_ia32_ptestmq512(...);
__mmask8  __builtin_ia32_ptestnmd128(...);
__mmask8  __builtin_ia32_ptestnmd256(...);
__mmask8  __builtin_ia32_ptestnmq128(...);
__mmask8  __builtin_ia32_ptestnmq256(...);
__m128i  __builtin_ia32_punpckhdq128_mask(...);
__m256i  __builtin_ia32_punpckhdq256_mask(...);
__m128i  __builtin_ia32_punpckhqdq128_mask(...);
__m256i  __builtin_ia32_punpckhqdq256_mask(...);
__m128i  __builtin_ia32_punpckldq128_mask(...);
__m256i  __builtin_ia32_punpckldq256_mask(...);
__m128i  __builtin_ia32_punpcklqdq128_mask(...);
__m256i  __builtin_ia32_punpcklqdq256_mask(...);

__m128i  __builtin_ia32_expanddi128_mask(...);
__m128i  __builtin_ia32_expanddi128_maskz(...);
__m256i  __builtin_ia32_expanddi256_mask(...);
__m256i  __builtin_ia32_expanddi256_maskz(...);
__m128d  __builtin_ia32_expandloaddf128_mask(...);
__m128d  __builtin_ia32_expandloaddf128_maskz(...);
__m128i  __builtin_ia32_expandloaddi128_mask(...);
__m128i  __builtin_ia32_expandloaddi128_maskz(...);
__m256i  __builtin_ia32_expandloaddi256_mask(...);
__m256i  __builtin_ia32_expandloaddi256_maskz(...);
__m128  __builtin_ia32_expandloadsf128_mask(...);
__m128  __builtin_ia32_expandloadsf128_maskz(...);
__m256  __builtin_ia32_expandloadsf256_mask(...);
__m256  __builtin_ia32_expandloadsf256_maskz(...);
__m128i  __builtin_ia32_expandloadsi128_mask(...);
__m128i  __builtin_ia32_expandloadsi128_maskz(...);
__m256i  __builtin_ia32_expandloadsi256_mask(...);
__m256i  __builtin_ia32_expandloadsi256_maskz(...);
__m128  __builtin_ia32_expandsf128_mask(...);
__m128  __builtin_ia32_expandsf128_maskz(...);
__m256  __builtin_ia32_expandsf256_mask(...);
__m256  __builtin_ia32_expandsf256_maskz(...);
__m128i  __builtin_ia32_expandsi128_mask(...);
__m128i  __builtin_ia32_expandsi128_maskz(...);
__m256i  __builtin_ia32_expandsi256_mask(...);
__m256i  __builtin_ia32_expandsi256_maskz(...);
__m128i  __builtin_ia32_prolvd128_mask(...);
__m256i  __builtin_ia32_prolvd256_mask(...);
__m256i  __builtin_ia32_prolvq256_mask(...);
__m128i  __builtin_ia32_prorvd128_mask(...);
__m256i  __builtin_ia32_prorvd256_mask(...);
__m128i  __builtin_ia32_psllv2di_mask(...);
__m256i  __builtin_ia32_psllv4di_mask(...);
__m128i  __builtin_ia32_psllv4si_mask(...);
__m256i  __builtin_ia32_psllv8si_mask(...);
__m128i  __builtin_ia32_psrav4si_mask(...);
__m256i  __builtin_ia32_psrav8si_mask(...);
__m128i  __builtin_ia32_psravq128_mask(...);
__m128i  __builtin_ia32_psrlv2di_mask(...);
__m256i  __builtin_ia32_psrlv4di_mask(...);
__m128i  __builtin_ia32_psrlv4si_mask(...);
__m256i  __builtin_ia32_psrlv8si_mask(...);
__m128i  __builtin_ia32_vpermi2vard128_mask(...);
__m256i  __builtin_ia32_vpermi2vard256_mask(...);
__m128i  __builtin_ia32_vpermi2varhi128_mask(...);
__m256i  __builtin_ia32_vpermi2varhi256_mask(...);
__m128d  __builtin_ia32_vpermi2varpd128_mask(...);
__m256d  __builtin_ia32_vpermi2varpd256_mask(...);
__m128  __builtin_ia32_vpermi2varps128_mask(...);
__m256  __builtin_ia32_vpermi2varps256_mask(...);
__m128i  __builtin_ia32_vpermi2varq128_mask(...);
__m256i  __builtin_ia32_vpermi2varq256_mask(...);
__m128i  __builtin_ia32_vpermt2vard128_mask(...);
__m128i  __builtin_ia32_vpermt2vard128_maskz(...);
__m256i  __builtin_ia32_vpermt2vard256_mask(...);
__m256i  __builtin_ia32_vpermt2vard256_maskz(...);
__m128i  __builtin_ia32_vpermt2varhi128_mask(...);
__m128i  __builtin_ia32_vpermt2varhi128_maskz(...);
__m256i  __builtin_ia32_vpermt2varhi256_mask(...);
__m256i  __builtin_ia32_vpermt2varhi256_maskz(...);
__m128d  __builtin_ia32_vpermt2varpd128_mask(...);
__m128d  __builtin_ia32_vpermt2varpd128_maskz(...);
__m256d  __builtin_ia32_vpermt2varpd256_mask(...);
__m256d  __builtin_ia32_vpermt2varpd256_maskz(...);
__m128  __builtin_ia32_vpermt2varps128_mask(...);
__m128  __builtin_ia32_vpermt2varps128_maskz(...);
__m256  __builtin_ia32_vpermt2varps256_mask(...);
__m256  __builtin_ia32_vpermt2varps256_maskz(...);
__m128i  __builtin_ia32_vpermt2varq128_mask(...);
__m128i  __builtin_ia32_vpermt2varq128_maskz(...);
__m256i  __builtin_ia32_vpermt2varq256_mask(...);
__m256i  __builtin_ia32_vpermt2varq256_maskz(...);
__m256d  __builtin_ia32_divpd256_mask(...);
__m128d  __builtin_ia32_divpd_mask(...);
__m256  __builtin_ia32_divps256_mask(...);
__m128  __builtin_ia32_divps_mask(...);
__m512d  __builtin_ia32_exp2pd_mask(...);
__m512  __builtin_ia32_exp2ps_mask(...);
__m256d  __builtin_ia32_maxpd256_mask(...);
__m128d  __builtin_ia32_maxpd_mask(...);
__m256  __builtin_ia32_maxps256_mask(...);
__m128  __builtin_ia32_maxps_mask(...);
__m256d  __builtin_ia32_minpd256_mask(...);
__m128d  __builtin_ia32_minpd_mask(...);
__m256  __builtin_ia32_minps256_mask(...);
__m128  __builtin_ia32_minps_mask(...);
__m256d  __builtin_ia32_mulpd256_mask(...);
__m128d  __builtin_ia32_mulpd_mask(...);
__m256  __builtin_ia32_mulps256_mask(...);
__m128  __builtin_ia32_mulps_mask(...);
__m128i  __builtin_ia32_pmaxsd128_mask(...);
__m256i  __builtin_ia32_pmaxsd256_mask(...);
__m128i  __builtin_ia32_pmaxsq128_mask(...);
__m256i  __builtin_ia32_pmaxsq256_mask(...);
__m256i  __builtin_ia32_pmaxud256_mask(...);
__m128i  __builtin_ia32_pmaxuq128_mask(...);
__m256i  __builtin_ia32_pmaxuq256_mask(...);
__m128i  __builtin_ia32_pminsd128_mask(...);
__m256i  __builtin_ia32_pminsd256_mask(...);
__m128i  __builtin_ia32_pminsq128_mask(...);
__m256i  __builtin_ia32_pminsq256_mask(...);
__m256i  __builtin_ia32_pminud256_mask(...);
__m128i  __builtin_ia32_pminuq128_mask(...);
__m256i  __builtin_ia32_pminuq256_mask(...);
__m256i  __builtin_ia32_pmulld256_mask(...);
__m128i  __builtin_ia32_prolvq128_mask(...);
__m128i  __builtin_ia32_prorvq128_mask(...);
__m256i  __builtin_ia32_prorvq256_mask(...);
__m256i  __builtin_ia32_psravq256_mask(...);
__m128i  __builtin_ia32_broadcastmb128(...);
__m256i  __builtin_ia32_broadcastmb256(...);
__m128i  __builtin_ia32_broadcastmw128(...);
__m256i  __builtin_ia32_broadcastmw256(...);
__m128i  __builtin_ia32_pbroadcastb128(...);
__m256i  __builtin_ia32_pbroadcastb256(...);
__m256i  __builtin_ia32_pbroadcastw256(...);
__m128i  __builtin_ia32_pmaxud128_mask(...);
__m128i  __builtin_ia32_pminud128_mask(...);
__m128i  __builtin_ia32_psrad128_mask(...);
__m256i  __builtin_ia32_psrad256_mask(...);
__m128i  __builtin_ia32_psraq128_mask(...);
__m256i  __builtin_ia32_psraq256_mask(...);
__mmask8  __builtin_ia32_ucmpd128_mask(...);
__mmask8  __builtin_ia32_ucmpd256_mask(...);
__m128d  __builtin_ia32_unpckhpd128_mask(...);
__m256d  __builtin_ia32_unpckhpd256_mask(...);
__m128  __builtin_ia32_unpckhps128_mask(...);
__m256  __builtin_ia32_unpckhps256_mask(...);
__m128d  __builtin_ia32_unpcklpd128_mask(...);
__m256d  __builtin_ia32_unpcklpd256_mask(...);
__m128  __builtin_ia32_unpcklps128_mask(...);
__m256  __builtin_ia32_unpcklps256_mask(...);
__m256  __builtin_ia32_vcvtph2ps256_mask(...);
__m128  __builtin_ia32_vcvtph2ps_mask(...);
__m128i  __builtin_ia32_vpconflictdi_128_mask(...);
__m256i  __builtin_ia32_vpconflictdi_256_mask(...);
__m512i  __builtin_ia32_vpconflictdi_512_mask(...);
__m128i  __builtin_ia32_vpconflictsi_128_mask(...);
__m256i  __builtin_ia32_vpconflictsi_256_mask(...);
__m512i  __builtin_ia32_vpconflictsi_512_mask(...);
__m128i  __builtin_ia32_vplzcntd_128_mask(...);
__m256i  __builtin_ia32_vplzcntd_256_mask(...);
__m512i  __builtin_ia32_vplzcntd_512_mask(...);
__m128i  __builtin_ia32_vplzcntq_128_mask(...);
__m256i  __builtin_ia32_vplzcntq_256_mask(...);
__m512i  __builtin_ia32_vplzcntq_512_mask(...);
__mmask64  __builtin_ia32_kunpckdi(...);
__mmask32  __builtin_ia32_kunpcksi(...);
__m512i  __builtin_ia32_loaddquhi512_mask(...);
__m512i  __builtin_ia32_loaddquqi512_mask(...);
__m512i  __builtin_ia32_movdquhi512_mask(...);
__m512i  __builtin_ia32_movdquqi512_mask(...);
__m512i  __builtin_ia32_pbroadcastb512_gpr_mask(...);
__m512i  __builtin_ia32_pbroadcastb512_mask(...);
__m512i  __builtin_ia32_pbroadcastw512_gpr_mask(...);
__m512i  __builtin_ia32_pbroadcastw512_mask(...);
__m256d  __builtin_ia32_permvardf256_mask(...);
__m256i  __builtin_ia32_permvardi256_mask(...);
__m512i  __builtin_ia32_permvarhi512_mask(...);
__m256  __builtin_ia32_permvarsf256_mask(...);
__m256i  __builtin_ia32_permvarsi256_mask(...);
__m512i  __builtin_ia32_pmaddubsw512_mask(...);
__m512i  __builtin_ia32_pmaddwd512_mask(...);
__m256i  __builtin_ia32_pmovswb512_mask(...);
__m512i  __builtin_ia32_pmovsxbw512_mask(...);
__m256i  __builtin_ia32_pmovuswb512_mask(...);
__m256i  __builtin_ia32_pmovwb512_mask(...);
__m512i  __builtin_ia32_pmovzxbw512_mask(...);
__m512i  __builtin_ia32_pmulhrsw512_mask(...);
__m512i  __builtin_ia32_pmulhuw512_mask(...);
__m512i  __builtin_ia32_pmulhw512_mask(...);
__m128i  __builtin_ia32_pmulld128_mask(...);
__m128i __builtin_ia32_psadbw128(...);
__m512i  __builtin_ia32_psadbw512(...);
__m128i  __builtin_ia32_pslld128_mask(...);
__m256i  __builtin_ia32_pslld256_mask(...);
__m128i  __builtin_ia32_psllq128_mask(...);
__m256i  __builtin_ia32_psllq256_mask(...);
__m512i  __builtin_ia32_psllw512_mask(...);
__m512i  __builtin_ia32_psrlw512_mask(...);
__m256i  __builtin_ia32_psubd256_mask(...);
__m512i  __builtin_ia32_punpckhbw512_mask(...);
void  __builtin_ia32_storedquhi512_mask(...);
void  __builtin_ia32_storedquqi512_mask(...);
__m512i  __builtin_ia32_vpermi2varhi512_mask(...);
__m256d  __builtin_ia32_vpermilvarpd256_mask(...);
__m128d  __builtin_ia32_vpermilvarpd_mask(...);
__m256  __builtin_ia32_vpermilvarps256_mask(...);
__m128  __builtin_ia32_vpermilvarps_mask(...);
__m512  __builtin_ia32_broadcastf32x2_512_mask(...);
__m512  __builtin_ia32_broadcastf32x8_512_mask(...);
__m512d  __builtin_ia32_broadcastf64x2_512_mask(...);
__m512i  __builtin_ia32_broadcasti32x2_512_mask(...);
__m512i  __builtin_ia32_broadcasti32x8_512_mask(...);
__m512i  __builtin_ia32_broadcasti64x2_512_mask(...);
__mmask64  __builtin_ia32_cvtb2mask512(...);
__mmask16  __builtin_ia32_cvtd2mask512(...);
__m512i  __builtin_ia32_cvtmask2b512(...);
__m512i  __builtin_ia32_cvtmask2d512(...);
__m512i  __builtin_ia32_cvtmask2q512(...);
__m512i  __builtin_ia32_cvtmask2w512(...);
__m512i  __builtin_ia32_cvtpd2qq512_mask(...);
__m512i  __builtin_ia32_cvtpd2uqq512_mask(...);
__m512i  __builtin_ia32_cvtps2qq512_mask(...);
__m512i  __builtin_ia32_cvtps2uqq512_mask(...);
__mmask8  __builtin_ia32_cvtq2mask512(...);
__m512d  __builtin_ia32_cvtqq2pd512_mask(...);
__m256  __builtin_ia32_cvtqq2ps512_mask(...);
__m512i  __builtin_ia32_cvttpd2qq512_mask(...);
__m512i  __builtin_ia32_cvttpd2uqq512_mask(...);
__m512i  __builtin_ia32_cvttps2qq512_mask(...);
__m512i  __builtin_ia32_cvttps2uqq512_mask(...);
__m512d  __builtin_ia32_cvtuqq2pd512_mask(...);
__m256  __builtin_ia32_cvtuqq2ps512_mask(...);
__mmask32  __builtin_ia32_cvtw2mask512(...);
__m512i  __builtin_ia32_psllv32hi_mask(...);
__m512i  __builtin_ia32_psrav32hi_mask(...);
__m512i  __builtin_ia32_psraw512_mask(...);
__m512i  __builtin_ia32_psrlv32hi_mask(...);
__m512i  __builtin_ia32_psubw512_mask(...);
__mmask64  __builtin_ia32_ptestmb512(...);
__mmask32  __builtin_ia32_ptestmw512(...);
__mmask64  __builtin_ia32_ptestnmb512(...);
__mmask32  __builtin_ia32_ptestnmw512(...);
__m512i  __builtin_ia32_punpckhwd512_mask(...);
__m512i  __builtin_ia32_punpcklbw512_mask(...);
__m512i  __builtin_ia32_punpcklwd512_mask(...);
__mmask16  __builtin_ia32_cvtb2mask128(...);
__mmask32  __builtin_ia32_cvtb2mask256(...);
__m128i  __builtin_ia32_cvtmask2b128(...);
__m256i  __builtin_ia32_cvtmask2b256(...);
__m128i  __builtin_ia32_cvtmask2w128(...);
__m256i  __builtin_ia32_cvtmask2w256(...);
__mmask8  __builtin_ia32_cvtw2mask128(...);
__mmask16  __builtin_ia32_cvtw2mask256(...);
__m128i  __builtin_ia32_loaddquhi128_mask(...);
__m256i  __builtin_ia32_loaddquhi256_mask(...);
__m128i  __builtin_ia32_loaddquqi128_mask(...);
__m256i  __builtin_ia32_loaddquqi256_mask(...);
__m128i  __builtin_ia32_movdquhi128_mask(...);
__m256i  __builtin_ia32_movdquhi256_mask(...);
__m128i  __builtin_ia32_movdquqi128_mask(...);
__m256i  __builtin_ia32_movdquqi256_mask(...);
__m128i  __builtin_ia32_pbroadcastb128_gpr_mask(...);
__m128i  __builtin_ia32_pbroadcastb128_mask(...);
__m256i  __builtin_ia32_pbroadcastb256_gpr_mask(...);
__m256i  __builtin_ia32_pbroadcastb256_mask(...);
__m128i  __builtin_ia32_pbroadcastw128_gpr_mask(...);
__m128i  __builtin_ia32_pbroadcastw128_mask(...);
__m256i  __builtin_ia32_pbroadcastw256_gpr_mask(...);
__m256i  __builtin_ia32_pbroadcastw256_mask(...);
__mmask32  __builtin_ia32_pcmpgtb256_mask(...);
__m128i  __builtin_ia32_permvarhi128_mask(...);
__m256i  __builtin_ia32_permvarhi256_mask(...);
__m128i  __builtin_ia32_pmaddubsw128_mask(...);
__m256i  __builtin_ia32_pmaddubsw256_mask(...);
__m128i  __builtin_ia32_pmaddwd128_mask(...);
__m256i  __builtin_ia32_pmaddwd256_mask(...);
__m128i  __builtin_ia32_pmovswb128_mask(...);
__m128i  __builtin_ia32_pmovswb256_mask(...);
__m256i  __builtin_ia32_pmovsxbw256_mask(...);
__m128i  __builtin_ia32_pmovuswb128_mask(...);
__m128i  __builtin_ia32_pmovuswb256_mask(...);
__m128i  __builtin_ia32_pmovwb256_mask(...);
__m128i  __builtin_ia32_pmulhrsw128_mask(...);
__m256i  __builtin_ia32_pmulhrsw256_mask(...);
__m128i  __builtin_ia32_pmulhuw128_mask(...);
__m256i  __builtin_ia32_pmulhuw256_mask(...);
__m128i  __builtin_ia32_pmulhw128_mask(...);
__m256i  __builtin_ia32_pmulhw256_mask(...);
__mmask16  __builtin_ia32_ptestmb128(...);
__mmask32  __builtin_ia32_ptestmb256(...);
__mmask8  __builtin_ia32_ptestmw128(...);
__mmask16  __builtin_ia32_ptestmw256(...);
void  __builtin_ia32_storedquqi128_mask(...);
void  __builtin_ia32_storedquqi256_mask(...);
__m128i  __builtin_ia32_cvtpd2qq128_mask(...);
__m256i  __builtin_ia32_cvtpd2qq256_mask(...);
__m128i  __builtin_ia32_cvtpd2uqq128_mask(...);
__m256i  __builtin_ia32_cvtpd2uqq256_mask(...);
__m128i  __builtin_ia32_cvttpd2qq128_mask(...);
__m256i  __builtin_ia32_cvttpd2qq256_mask(...);
__m128i  __builtin_ia32_cvttpd2uqq128_mask(...);
__m256i  __builtin_ia32_cvttpd2uqq256_mask(...);
__mmask16  __builtin_ia32_pcmpgtb128_mask(...);
__m128i  __builtin_ia32_pmovsxbw128_mask(...);
__m128i  __builtin_ia32_pmovwb128_mask(...);
__m128i  __builtin_ia32_pmovzxbw128_mask(...);
__m256i  __builtin_ia32_pmovzxbw256_mask(...);
__m256i  __builtin_ia32_psllv16hi_mask(...);
__m128i  __builtin_ia32_psllv8hi_mask(...);
__m128i  __builtin_ia32_psllw128_mask(...);
__m256i  __builtin_ia32_psllw256_mask(...);
__m256i  __builtin_ia32_psrav16hi_mask(...);
__m128i  __builtin_ia32_psrav8hi_mask(...);
__m128i  __builtin_ia32_psraw128_mask(...);
__m256i  __builtin_ia32_psraw256_mask(...);
__m256i  __builtin_ia32_psrlv16hi_mask(...);
__m128i  __builtin_ia32_psrlv8hi_mask(...);
__m128i  __builtin_ia32_psrlw128_mask(...);
__m256i  __builtin_ia32_psrlw256_mask(...);
__m128i  __builtin_ia32_psubw128_mask(...);
__m256i  __builtin_ia32_psubw256_mask(...);
__mmask16  __builtin_ia32_ptestnmb128(...);
__mmask32  __builtin_ia32_ptestnmb256(...);
__mmask8  __builtin_ia32_ptestnmw128(...);
__mmask16  __builtin_ia32_ptestnmw256(...);
__m128i  __builtin_ia32_punpckhbw128_mask(...);
__m256i  __builtin_ia32_punpckhbw256_mask(...);
__m128i  __builtin_ia32_punpckhwd128_mask(...);
__m256i  __builtin_ia32_punpckhwd256_mask(...);
__m128i  __builtin_ia32_punpcklbw128_mask(...);
__m256i  __builtin_ia32_punpcklbw256_mask(...);
__m128i  __builtin_ia32_punpcklwd128_mask(...);
__m256i  __builtin_ia32_punpcklwd256_mask(...);
void  __builtin_ia32_storedquhi128_mask(...);
void  __builtin_ia32_storedquhi256_mask(...);
__m256  __builtin_ia32_broadcastf32x2_256_mask(...);
__m256d  __builtin_ia32_broadcastf64x2_256_mask(...);
__m128i  __builtin_ia32_broadcasti32x2_128_mask(...);
__m256i  __builtin_ia32_broadcasti32x2_256_mask(...);
__m256i  __builtin_ia32_broadcasti64x2_256_mask(...);
__mmask8  __builtin_ia32_cvtd2mask128(...);
__mmask8  __builtin_ia32_cvtd2mask256(...);
__m128i  __builtin_ia32_cvtmask2d128(...);
__m256i  __builtin_ia32_cvtmask2d256(...);
__m128i  __builtin_ia32_cvtmask2q128(...);
__m256i  __builtin_ia32_cvtmask2q256(...);
__m128i  __builtin_ia32_cvtps2qq128_mask(...);
__m256i  __builtin_ia32_cvtps2qq256_mask(...);
__m128i  __builtin_ia32_cvtps2uqq128_mask(...);
__m256i  __builtin_ia32_cvtps2uqq256_mask(...);
__mmask8  __builtin_ia32_cvtq2mask128(...);
__mmask8  __builtin_ia32_cvtq2mask256(...);
__m128d  __builtin_ia32_cvtqq2pd128_mask(...);
__m256d  __builtin_ia32_cvtqq2pd256_mask(...);
__m128  __builtin_ia32_cvtqq2ps128_mask(...);
__m128  __builtin_ia32_cvtqq2ps256_mask(...);
__m128i  __builtin_ia32_cvttps2qq128_mask(...);
__m256i  __builtin_ia32_cvttps2qq256_mask(...);
__m128i  __builtin_ia32_cvttps2uqq128_mask(...);
__m256i  __builtin_ia32_cvttps2uqq256_mask(...);
__m128d  __builtin_ia32_cvtuqq2pd128_mask(...);
__m256d  __builtin_ia32_cvtuqq2pd256_mask(...);
__m128  __builtin_ia32_cvtuqq2ps128_mask(...);
__m128  __builtin_ia32_cvtuqq2ps256_mask(...);
__m512i  __builtin_ia32_permvarqi512_mask(...);
__m128i  __builtin_ia32_vpmadd52huq128_mask(...);
__m128i  __builtin_ia32_vpmadd52huq128_maskz(...);
__m256i  __builtin_ia32_vpmadd52huq256_mask(...);
__m256i  __builtin_ia32_vpmadd52huq256_maskz(...);
__m512i  __builtin_ia32_vpmadd52huq512_mask(...);
__m512i  __builtin_ia32_vpmadd52huq512_maskz(...);
__m128i  __builtin_ia32_vpmadd52luq128_mask(...);
__m128i  __builtin_ia32_vpmadd52luq128_maskz(...);
__m256i  __builtin_ia32_vpmadd52luq256_mask(...);
__m256i  __builtin_ia32_vpmadd52luq256_maskz(...);
__m512i  __builtin_ia32_vpmadd52luq512_mask(...);
__m512i  __builtin_ia32_vpmadd52luq512_maskz(...);
__m512i  __builtin_ia32_vpmultishiftqb512_mask(...);
__m64 __builtin_ia32_pcmpeqb(...);
__m64 __builtin_ia32_pcmpeqw(...);
__m128i  __builtin_ia32_permvarqi128_mask(...);
__m256i  __builtin_ia32_permvarqi256_mask(...);
int __builtin_ia32_vec_ext_v2si(...);
int __builtin_ia32_vec_ext_v4sf(...);
__m128d __builtin_ia32_vfmaddsd(...);
__m128d  __builtin_ia32_vfmaddsd3(...);
__m128 __builtin_ia32_vfmaddss(...);
__m128  __builtin_ia32_vfmaddss3(...);
__m128i __builtin_ia32_vpcomeqb(...);
__m128i __builtin_ia32_vpcomequb(...);
__m128i __builtin_ia32_vpcomequd(...);
__m128i __builtin_ia32_vpcomequq(...);
__m128i __builtin_ia32_vpcomequw(...);
__m128i __builtin_ia32_vpcomeqw(...);
__m128i __builtin_ia32_vpcomfalseb(...);
__m128i __builtin_ia32_vpcomfalseub(...);
__m128i __builtin_ia32_vpcomfalseud(...);
__m128i __builtin_ia32_vpcomfalseuq(...);
__m128i __builtin_ia32_vpcomfalseuw(...);
__m128i __builtin_ia32_vpcomgeb(...);
__m128i __builtin_ia32_vpcomgeub(...);
__m128i __builtin_ia32_vpcomgeud(...);
__m128i __builtin_ia32_vpcomgeuq(...);
__m128i __builtin_ia32_vpcomgeuw(...);
__m128i __builtin_ia32_vpcomgew(...);
__m128i __builtin_ia32_vpcomgtb(...);
__m128i __builtin_ia32_vpcomgtub(...);
__m128i __builtin_ia32_vpcomgtud(...);
__m128i __builtin_ia32_vpcomgtuq(...);
__m128i __builtin_ia32_vpcomgtuw(...);
__m128i __builtin_ia32_vpcomgtw(...);
__m128i __builtin_ia32_vpcomleb(...);
__m128i __builtin_ia32_vpcomleub(...);
__m128i __builtin_ia32_vpcomleud(...);
__m128i __builtin_ia32_vpcomleuq(...);
__m128i __builtin_ia32_vpcomleuw(...);
__m128i __builtin_ia32_vpcomlew(...);
__m128i __builtin_ia32_vpcomltb(...);
__m128i __builtin_ia32_vpcomltub(...);
__m128i __builtin_ia32_vpcomltud(...);
__m128i __builtin_ia32_vpcomltuq(...);
__m128i __builtin_ia32_vpcomltuw(...);
__m128i __builtin_ia32_vpcomltw(...);
__m128i __builtin_ia32_vpcomneqb(...);
__m128i __builtin_ia32_vpcomnequb(...);
__m128i __builtin_ia32_vpcomnequd(...);
__m128i __builtin_ia32_vpcomnequq(...);
__m128i __builtin_ia32_vpcomnequw(...);
__m128i __builtin_ia32_vpcomneqw(...);
__m128i __builtin_ia32_vpcomtrueb(...);
__m128i __builtin_ia32_vpcomtrueub(...);
__m128i __builtin_ia32_vpcomtrueud(...);
__m128i __builtin_ia32_vpcomtrueuq(...);
__m128i __builtin_ia32_vpcomtrueuw(...);
__m128i  __builtin_ia32_vpermi2varqi128_mask(...);
__m256i  __builtin_ia32_vpermi2varqi256_mask(...);
__m512i  __builtin_ia32_vpermi2varqi512_mask(...);
__m512i  __builtin_ia32_vpermt2varhi512_mask(...);
__m512i  __builtin_ia32_vpermt2varhi512_maskz(...);
__m128i  __builtin_ia32_vpermt2varqi128_mask(...);
__m128i  __builtin_ia32_vpermt2varqi128_maskz(...);
__m256i  __builtin_ia32_vpermt2varqi256_mask(...);
__m256i  __builtin_ia32_vpermt2varqi256_maskz(...);
__m512i  __builtin_ia32_vpermt2varqi512_mask(...);
__m512i  __builtin_ia32_vpermt2varqi512_maskz(...);
__m128i  __builtin_ia32_vpmultishiftqb128_mask(...);
__m256i  __builtin_ia32_vpmultishiftqb256_mask(...);
__m128i __builtin_ia32_vprotb(...);
__m128i __builtin_ia32_vprotd(...);
__m128i __builtin_ia32_vprotw(...);
void __builtin_ia32_clflush(...);
void  __builtin_ia32_clflushopt(...);
void  __builtin_ia32_clwb(...);
void __builtin_ia32_llwpcb(...);
void __builtin_ia32_monitor(...);
void __builtin_ia32_monitorx(...);
void __builtin_ia32_mwaitx(...);
__m64 __builtin_ia32_pcmpeqd(...);
__m64 __builtin_ia32_pcmpgtd(...);
void  __builtin_ia32_pcommit(...);
__m64 __builtin_ia32_pfsubr(...);
int  __builtin_ia32_rdseed_di_step(...);
int  __builtin_ia32_rdseed_hi_step(...);
int  __builtin_ia32_rdseed_si_step(...);
unsigned char __builtin_ia32_sbb_u32(...);
unsigned char __builtin_ia32_sbb_u64(...);
void __builtin_ia32_sfence(...);
void * __builtin_ia32_slwpcb(...);
__m128i __builtin_ia32_vpcomeqd(...);
__m128i __builtin_ia32_vpcomeqq(...);
__m128i __builtin_ia32_vpcomfalsed(...);
__m128i __builtin_ia32_vpcomfalseq(...);
__m128i __builtin_ia32_vpcomfalsew(...);
__m128i __builtin_ia32_vpcomged(...);
__m128i __builtin_ia32_vpcomgeq(...);
__m128i __builtin_ia32_vpcomgtd(...);
__m128i __builtin_ia32_vpcomgtq(...);
__m128i __builtin_ia32_vpcomled(...);
__m128i __builtin_ia32_vpcomleq(...);
__m128i __builtin_ia32_vpcomltd(...);
__m128i __builtin_ia32_vpcomltq(...);
__m128i __builtin_ia32_vpcomneqd(...);
__m128i __builtin_ia32_vpcomneqq(...);
__m128i __builtin_ia32_vpcomtrued(...);
__m128i __builtin_ia32_vpcomtrueq(...);
__m128i __builtin_ia32_vpcomtruew(...);
__m128i __builtin_ia32_vprotq(...);
void  __builtin_ia32_xrstor(...);
void  __builtin_ia32_xrstor64(...);
void  __builtin_ia32_xrstors(...);
void  __builtin_ia32_xrstors64(...);
void  __builtin_ia32_xsave(...);
void  __builtin_ia32_xsave64(...);
void  __builtin_ia32_xsavec(...);
void  __builtin_ia32_xsavec64(...);
void  __builtin_ia32_xsaveopt(...);
void  __builtin_ia32_xsaveopt64(...);
void  __builtin_ia32_xsaves(...);
void  __builtin_ia32_xsaves64(...);
__m128i  __builtin_ia32_pbroadcastd128(...);
__m128i  __builtin_ia32_pbroadcastq128(...);
__m256i  __builtin_ia32_pbroadcastq256(...);
__m128i __builtin_ia32_pmovsxbd128(...);
__m128i __builtin_ia32_pmovsxbq128(...);
__m128i __builtin_ia32_pmovsxbw128(...);
__m128i __builtin_ia32_pmovsxdq128(...);
__m128i __builtin_ia32_pmovsxwd128(...);
__m128i __builtin_ia32_pmovsxwq128(...);
__m128i __builtin_ia32_pmovzxbd128(...);
__m128i __builtin_ia32_pmovzxbq128(...);
__m128i __builtin_ia32_pmovzxbw128(...);
__m128i __builtin_ia32_pmovzxdq128(...);
__m128i __builtin_ia32_pmovzxwd128(...);
__m128i __builtin_ia32_pmovzxwq128(...);
__m256d __builtin_ia32_vbroadcastf128_pd256(...);
__m256 __builtin_ia32_vbroadcastf128_ps256(...);
__m256d  __builtin_ia32_vbroadcastsd_pd256(...);
__m256  __builtin_ia32_vbroadcastss_ps256(...);
}
