/*
   Copyright (C) 2019 Laurent Montel <montel@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include "emoticonunicodeutils.h"
using namespace KPIMTextEdit;

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeFlagsEmoji()
{
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst {
        {QStringLiteral(":chequered_flag:"), QString::fromUtf16(u"\U0001F3C1")},
        {QStringLiteral(":triangular_flag:"), QString::fromUtf16(u"\U0001F6A9")},
        {QStringLiteral(":crossed_flags:"), QString::fromUtf16(u"\U0001F38C")},
        {QStringLiteral(":black_flag:"), QString::fromUtf16(u"\U0001F3F4")},
        {QStringLiteral(":white_flag:"), QString::fromUtf16(u"\U0001F3F3")},
        {QStringLiteral(":rainbow_flag:"), QString::fromUtf16(u"\U0001F3F3\U0000FE0F\U0000200D\U0001F308")},
        {QStringLiteral(":pirate_flag:"), QString::fromUtf16(u"\U0001F3F4\U0000200D\U00002620\U0000FE0F")},
        {QStringLiteral(":flag_Ascension_Island:"), QString::fromUtf16(u"\U0001F1E6\U0001F1E8")},
        {QStringLiteral(":flag_Andorra:"), QString::fromUtf16(u"\U0001F1E6\U0001F1E9")},
        {QStringLiteral(":flag_United_Arab_Emirates:"), QString::fromUtf16(u"\U0001F1E6\U0001F1EA")},
        {QStringLiteral(":flag_Afghanistan:"), QString::fromUtf16(u"\U0001F1E6\U0001F1EB")},
        {QStringLiteral(":flag_Antigua_&_Barbuda:"), QString::fromUtf16(u"\U0001F1E6\U0001F1EC")},
        {QStringLiteral(":flag_Anguilla:"), QString::fromUtf16(u"\U0001F1E6\U0001F1EE")},
        {QStringLiteral(":flag_Albania:"), QString::fromUtf16(u"\U0001F1E6\U0001F1F1")},
        {QStringLiteral(":flag_Armenia:"), QString::fromUtf16(u"\U0001F1E6\U0001F1F2")},
        {QStringLiteral(":flag_Angola:"), QString::fromUtf16(u"\U0001F1E6\U0001F1F4")},
        {QStringLiteral(":flag_Antarctica:"), QString::fromUtf16(u"\U0001F1E6\U0001F1F6")},
        {QStringLiteral(":flag_Argentina:"), QString::fromUtf16(u"\U0001F1E6\U0001F1F7")},
        {QStringLiteral(":flag_American_Samoa:"), QString::fromUtf16(u"\U0001F1E6\U0001F1F8")},
        {QStringLiteral(":flag_Austria:"), QString::fromUtf16(u"\U0001F1E6\U0001F1F9")},
        {QStringLiteral(":flag_Australia:"), QString::fromUtf16(u"\U0001F1E6\U0001F1FA")},
        {QStringLiteral(":flag_Aruba:"), QString::fromUtf16(u"\U0001F1E6\U0001F1FC")},
        {QStringLiteral(":flag_Åland_Islands:"), QString::fromUtf16(u"\U0001F1E6\U0001F1FD")},
        {QStringLiteral(":flag_Azerbaijan:"), QString::fromUtf16(u"\U0001F1E6\U0001F1FF")},
        {QStringLiteral(":flag_Bosnia_&_Herzegovina:"), QString::fromUtf16(u"\U0001F1E7\U0001F1E6")},
        {QStringLiteral(":flag_Barbados:"), QString::fromUtf16(u"\U0001F1E7\U0001F1E7")},
        {QStringLiteral(":flag_Bangladesh:"), QString::fromUtf16(u"\U0001F1E7\U0001F1E9")},
        {QStringLiteral(":flag_Belgium:"), QString::fromUtf16(u"\U0001F1E7\U0001F1EA")},
        {QStringLiteral(":flag_Burkina_Faso:"), QString::fromUtf16(u"\U0001F1E7\U0001F1EB")},
        {QStringLiteral(":flag_Bulgaria:"), QString::fromUtf16(u"\U0001F1E7\U0001F1EC")},
        {QStringLiteral(":flag_Bahrain:"), QString::fromUtf16(u"\U0001F1E7\U0001F1ED")},
        {QStringLiteral(":flag_Burundi:"), QString::fromUtf16(u"\U0001F1E7\U0001F1EE")},
        {QStringLiteral(":flag_Benin:"), QString::fromUtf16(u"\U0001F1E7\U0001F1EF")},
        {QStringLiteral(":flag_St._Barthélemy:"), QString::fromUtf16(u"\U0001F1E7\U0001F1F1")},
        {QStringLiteral(":flag_Bermuda:"), QString::fromUtf16(u"\U0001F1E7\U0001F1F2")},
        {QStringLiteral(":flag_Brunei:"), QString::fromUtf16(u"\U0001F1E7\U0001F1F3")},
        {QStringLiteral(":flag_Bolivia:"), QString::fromUtf16(u"\U0001F1E7\U0001F1F4")},
        {QStringLiteral(":flag_Caribbean_Netherlands:"), QString::fromUtf16(u"\U0001F1E7\U0001F1F6")},
        {QStringLiteral(":flag_Brazil:"), QString::fromUtf16(u"\U0001F1E7\U0001F1F7")},
        {QStringLiteral(":flag_Bahamas:"), QString::fromUtf16(u"\U0001F1E7\U0001F1F8")},
        {QStringLiteral(":flag_Bhutan:"), QString::fromUtf16(u"\U0001F1E7\U0001F1F9")},
        {QStringLiteral(":flag_Bouvet_Island:"), QString::fromUtf16(u"\U0001F1E7\U0001F1FB")},
        {QStringLiteral(":flag_Botswana:"), QString::fromUtf16(u"\U0001F1E7\U0001F1FC")},
        {QStringLiteral(":flag_Belarus:"), QString::fromUtf16(u"\U0001F1E7\U0001F1FE")},
        {QStringLiteral(":flag_Belize:"), QString::fromUtf16(u"\U0001F1E7\U0001F1FF")},
        {QStringLiteral(":flag_Canada:"), QString::fromUtf16(u"\U0001F1E8\U0001F1E6")},
        {QStringLiteral(":flag_Cocos_(Keeling)_Islands:"), QString::fromUtf16(u"\U0001F1E8\U0001F1E8")},
        {QStringLiteral(":flag_Congo_-_Kinshasa:"), QString::fromUtf16(u"\U0001F1E8\U0001F1E9")},
        {QStringLiteral(":flag_Central_African_Republic:"), QString::fromUtf16(u"\U0001F1E8\U0001F1EB")},
        {QStringLiteral(":flag_Congo_-_Brazzaville:"), QString::fromUtf16(u"\U0001F1E8\U0001F1EC")},
        {QStringLiteral(":flag_Switzerland:"), QString::fromUtf16(u"\U0001F1E8\U0001F1ED")},
        {QStringLiteral(":flag_Côte_d’Ivoire:"), QString::fromUtf16(u"\U0001F1E8\U0001F1EE")},
        {QStringLiteral(":flag_Cook_Islands:"), QString::fromUtf16(u"\U0001F1E8\U0001F1F0")},
        {QStringLiteral(":flag_Chile:"), QString::fromUtf16(u"\U0001F1E8\U0001F1F1")},
        {QStringLiteral(":flag_Cameroon:"), QString::fromUtf16(u"\U0001F1E8\U0001F1F2")},
        {QStringLiteral(":flag_China:"), QString::fromUtf16(u"\U0001F1E8\U0001F1F3")},
        {QStringLiteral(":flag_Colombia:"), QString::fromUtf16(u"\U0001F1E8\U0001F1F4")},
        {QStringLiteral(":flag_Clipperton_Island:"), QString::fromUtf16(u"\U0001F1E8\U0001F1F5")},
        {QStringLiteral(":flag_Costa_Rica:"), QString::fromUtf16(u"\U0001F1E8\U0001F1F7")},
        {QStringLiteral(":flag_Cuba:"), QString::fromUtf16(u"\U0001F1E8\U0001F1FA")},
        {QStringLiteral(":flag_Cape_Verde:"), QString::fromUtf16(u"\U0001F1E8\U0001F1FB")},
        {QStringLiteral(":flag_Curaçao:"), QString::fromUtf16(u"\U0001F1E8\U0001F1FC")},
        {QStringLiteral(":flag_Christmas_Island:"), QString::fromUtf16(u"\U0001F1E8\U0001F1FD")},
        {QStringLiteral(":flag_Cyprus:"), QString::fromUtf16(u"\U0001F1E8\U0001F1FE")},
        {QStringLiteral(":flag_Czechia:"), QString::fromUtf16(u"\U0001F1E8\U0001F1FF")},
        {QStringLiteral(":flag_Germany:"), QString::fromUtf16(u"\U0001F1E9\U0001F1EA")},
        {QStringLiteral(":flag_Diego_Garcia:"), QString::fromUtf16(u"\U0001F1E9\U0001F1EC")},
        {QStringLiteral(":flag_Djibouti:"), QString::fromUtf16(u"\U0001F1E9\U0001F1EF")},
        {QStringLiteral(":flag_Denmark:"), QString::fromUtf16(u"\U0001F1E9\U0001F1F0")},
        {QStringLiteral(":flag_Dominica:"), QString::fromUtf16(u"\U0001F1E9\U0001F1F2")},
        {QStringLiteral(":flag_Dominican_Republic:"), QString::fromUtf16(u"\U0001F1E9\U0001F1F4")},
        {QStringLiteral(":flag_Algeria:"), QString::fromUtf16(u"\U0001F1E9\U0001F1FF")},
        {QStringLiteral(":flag_Ceuta_&_Melilla:"), QString::fromUtf16(u"\U0001F1EA\U0001F1E6")},
        {QStringLiteral(":flag_Ecuador:"), QString::fromUtf16(u"\U0001F1EA\U0001F1E8")},
        {QStringLiteral(":flag_Estonia:"), QString::fromUtf16(u"\U0001F1EA\U0001F1EA")},
        {QStringLiteral(":flag_Egypt:"), QString::fromUtf16(u"\U0001F1EA\U0001F1EC")},
        {QStringLiteral(":flag_Western_Sahara:"), QString::fromUtf16(u"\U0001F1EA\U0001F1ED")},
        {QStringLiteral(":flag_Eritrea:"), QString::fromUtf16(u"\U0001F1EA\U0001F1F7")},
        {QStringLiteral(":flag_Spain:"), QString::fromUtf16(u"\U0001F1EA\U0001F1F8")},
        {QStringLiteral(":flag_Ethiopia:"), QString::fromUtf16(u"\U0001F1EA\U0001F1F9")},
        {QStringLiteral(":flag_European_Union:"), QString::fromUtf16(u"\U0001F1EA\U0001F1FA")},
        {QStringLiteral(":flag_Finland:"), QString::fromUtf16(u"\U0001F1EB\U0001F1EE")},
        {QStringLiteral(":flag_Fiji:"), QString::fromUtf16(u"\U0001F1EB\U0001F1EF")},
        {QStringLiteral(":flag_Falkland_Islands:"), QString::fromUtf16(u"\U0001F1EB\U0001F1F0")},
        {QStringLiteral(":flag_Micronesia:"), QString::fromUtf16(u"\U0001F1EB\U0001F1F2")},
        {QStringLiteral(":flag_Faroe_Islands:"), QString::fromUtf16(u"\U0001F1EB\U0001F1F4")},
        {QStringLiteral(":flag_France:"), QString::fromUtf16(u"\U0001F1EB\U0001F1F7")},
        {QStringLiteral(":flag_Gabon:"), QString::fromUtf16(u"\U0001F1EC\U0001F1E6")},
        {QStringLiteral(":flag_United_Kingdom:"), QString::fromUtf16(u"\U0001F1EC\U0001F1E7")},
        {QStringLiteral(":flag_Grenada:"), QString::fromUtf16(u"\U0001F1EC\U0001F1E9")},
        {QStringLiteral(":flag_Georgia:"), QString::fromUtf16(u"\U0001F1EC\U0001F1EA")},
        {QStringLiteral(":flag_French_Guiana:"), QString::fromUtf16(u"\U0001F1EC\U0001F1EB")},
        {QStringLiteral(":flag_Guernsey:"), QString::fromUtf16(u"\U0001F1EC\U0001F1EC")},
        {QStringLiteral(":flag_Ghana:"), QString::fromUtf16(u"\U0001F1EC\U0001F1ED")},
        {QStringLiteral(":flag_Gibraltar:"), QString::fromUtf16(u"\U0001F1EC\U0001F1EE")},
        {QStringLiteral(":flag_Greenland:"), QString::fromUtf16(u"\U0001F1EC\U0001F1F1")},
        {QStringLiteral(":flag_Gambia:"), QString::fromUtf16(u"\U0001F1EC\U0001F1F2")},
        {QStringLiteral(":flag_Guinea:"), QString::fromUtf16(u"\U0001F1EC\U0001F1F3")},
        {QStringLiteral(":flag_Guadeloupe:"), QString::fromUtf16(u"\U0001F1EC\U0001F1F5")},
        {QStringLiteral(":flag_Equatorial_Guinea:"), QString::fromUtf16(u"\U0001F1EC\U0001F1F6")},
        {QStringLiteral(":flag_Greece:"), QString::fromUtf16(u"\U0001F1EC\U0001F1F7")},
        {QStringLiteral(":flag_South_Georgia_&_South_Sandwich_Islands:"), QString::fromUtf16(u"\U0001F1EC\U0001F1F8")},
        {QStringLiteral(":flag_Guatemala:"), QString::fromUtf16(u"\U0001F1EC\U0001F1F9")},
        {QStringLiteral(":flag_Guam:"), QString::fromUtf16(u"\U0001F1EC\U0001F1FA")},
        {QStringLiteral(":flag_Guinea-Bissau:"), QString::fromUtf16(u"\U0001F1EC\U0001F1FC")},
        {QStringLiteral(":flag_Guyana:"), QString::fromUtf16(u"\U0001F1EC\U0001F1FE")},
        {QStringLiteral(":flag_Hong_Kong_SAR_China:"), QString::fromUtf16(u"\U0001F1ED\U0001F1F0")},
        {QStringLiteral(":flag_Heard_&_McDonald_Islands:"), QString::fromUtf16(u"\U0001F1ED\U0001F1F2")},
        {QStringLiteral(":flag_Honduras:"), QString::fromUtf16(u"\U0001F1ED\U0001F1F3")},
        {QStringLiteral(":flag_Croatia:"), QString::fromUtf16(u"\U0001F1ED\U0001F1F7")},
        {QStringLiteral(":flag_Haiti:"), QString::fromUtf16(u"\U0001F1ED\U0001F1F9")},
        {QStringLiteral(":flag_Hungary:"), QString::fromUtf16(u"\U0001F1ED\U0001F1FA")},
        {QStringLiteral(":flag_Canary_Islands:"), QString::fromUtf16(u"\U0001F1EE\U0001F1E8")},
        {QStringLiteral(":flag_Indonesia:"), QString::fromUtf16(u"\U0001F1EE\U0001F1E9")},
        {QStringLiteral(":flag_Ireland:"), QString::fromUtf16(u"\U0001F1EE\U0001F1EA")},
        {QStringLiteral(":flag_Israel:"), QString::fromUtf16(u"\U0001F1EE\U0001F1F1")},
        {QStringLiteral(":flag_Isle_of_Man:"), QString::fromUtf16(u"\U0001F1EE\U0001F1F2")},
        {QStringLiteral(":flag_India:"), QString::fromUtf16(u"\U0001F1EE\U0001F1F3")},
        {QStringLiteral(":flag_British_Indian_Ocean_Territory:"), QString::fromUtf16(u"\U0001F1EE\U0001F1F4")},
        {QStringLiteral(":flag_Iraq:"), QString::fromUtf16(u"\U0001F1EE\U0001F1F6")},
        {QStringLiteral(":flag_Iran:"), QString::fromUtf16(u"\U0001F1EE\U0001F1F7")},
        {QStringLiteral(":flag_Iceland:"), QString::fromUtf16(u"\U0001F1EE\U0001F1F8")},
        {QStringLiteral(":flag_Italy:"), QString::fromUtf16(u"\U0001F1EE\U0001F1F9")},
        {QStringLiteral(":flag_Jersey:"), QString::fromUtf16(u"\U0001F1EF\U0001F1EA")},
        {QStringLiteral(":flag_Jamaica:"), QString::fromUtf16(u"\U0001F1EF\U0001F1F2")},
        {QStringLiteral(":flag_Jordan:"), QString::fromUtf16(u"\U0001F1EF\U0001F1F4")},
        {QStringLiteral(":flag_Japan:"), QString::fromUtf16(u"\U0001F1EF\U0001F1F5")},
        {QStringLiteral(":flag_Kenya:"), QString::fromUtf16(u"\U0001F1F0\U0001F1EA")},
        {QStringLiteral(":flag_Kyrgyzstan:"), QString::fromUtf16(u"\U0001F1F0\U0001F1EC")},
        {QStringLiteral(":flag_Cambodia:"), QString::fromUtf16(u"\U0001F1F0\U0001F1ED")},
        {QStringLiteral(":flag_Kiribati:"), QString::fromUtf16(u"\U0001F1F0\U0001F1EE")},
        {QStringLiteral(":flag_Comoros:"), QString::fromUtf16(u"\U0001F1F0\U0001F1F2")},
        {QStringLiteral(":flag_St._Kitts_&_Nevis:"), QString::fromUtf16(u"\U0001F1F0\U0001F1F3")},
        {QStringLiteral(":flag_North_Korea:"), QString::fromUtf16(u"\U0001F1F0\U0001F1F5")},
        {QStringLiteral(":flag_South_Korea:"), QString::fromUtf16(u"\U0001F1F0\U0001F1F7")},
        {QStringLiteral(":flag_Kuwait:"), QString::fromUtf16(u"\U0001F1F0\U0001F1FC")},
        {QStringLiteral(":flag_Cayman_Islands:"), QString::fromUtf16(u"\U0001F1F0\U0001F1FE")},
        {QStringLiteral(":flag_Kazakhstan:"), QString::fromUtf16(u"\U0001F1F0\U0001F1FF")},
        {QStringLiteral(":flag_Laos:"), QString::fromUtf16(u"\U0001F1F1\U0001F1E6")},
        {QStringLiteral(":flag_Lebanon:"), QString::fromUtf16(u"\U0001F1F1\U0001F1E7")},
        {QStringLiteral(":flag_St._Lucia:"), QString::fromUtf16(u"\U0001F1F1\U0001F1E8")},
        {QStringLiteral(":flag_Liechtenstein:"), QString::fromUtf16(u"\U0001F1F1\U0001F1EE")},
        {QStringLiteral(":flag_Sri_Lanka:"), QString::fromUtf16(u"\U0001F1F1\U0001F1F0")},
        {QStringLiteral(":flag_Liberia:"), QString::fromUtf16(u"\U0001F1F1\U0001F1F7")},
        {QStringLiteral(":flag_Lesotho:"), QString::fromUtf16(u"\U0001F1F1\U0001F1F8")},
        {QStringLiteral(":flag_Lithuania:"), QString::fromUtf16(u"\U0001F1F1\U0001F1F9")},
        {QStringLiteral(":flag_Luxembourg:"), QString::fromUtf16(u"\U0001F1F1\U0001F1FA")},
        {QStringLiteral(":flag_Latvia:"), QString::fromUtf16(u"\U0001F1F1\U0001F1FB")},
        {QStringLiteral(":flag_Libya:"), QString::fromUtf16(u"\U0001F1F1\U0001F1FE")},
        {QStringLiteral(":flag_Morocco:"), QString::fromUtf16(u"\U0001F1F2\U0001F1E6")},
        {QStringLiteral(":flag_Monaco:"), QString::fromUtf16(u"\U0001F1F2\U0001F1E8")},
        {QStringLiteral(":flag_Moldova:"), QString::fromUtf16(u"\U0001F1F2\U0001F1E9")},
        {QStringLiteral(":flag_Montenegro:"), QString::fromUtf16(u"\U0001F1F2\U0001F1EA")},
        {QStringLiteral(":flag_St._Martin:"), QString::fromUtf16(u"\U0001F1F2\U0001F1EB")},
        {QStringLiteral(":flag_Madagascar:"), QString::fromUtf16(u"\U0001F1F2\U0001F1EC")},
        {QStringLiteral(":flag_Marshall_Islands:"), QString::fromUtf16(u"\U0001F1F2\U0001F1ED")},
        {QStringLiteral(":flag_North_Macedonia:"), QString::fromUtf16(u"\U0001F1F2\U0001F1F0")},
        {QStringLiteral(":flag_Mali:"), QString::fromUtf16(u"\U0001F1F2\U0001F1F1")},
        {QStringLiteral(":flag_Myanmar_(Burma):"), QString::fromUtf16(u"\U0001F1F2\U0001F1F2")},
        {QStringLiteral(":flag_Mongolia:"), QString::fromUtf16(u"\U0001F1F2\U0001F1F3")},
        {QStringLiteral(":flag_Macao_SAR_China:"), QString::fromUtf16(u"\U0001F1F2\U0001F1F4")},
        {QStringLiteral(":flag_Northern_Mariana_Islands:"), QString::fromUtf16(u"\U0001F1F2\U0001F1F5")},
        {QStringLiteral(":flag_Martinique:"), QString::fromUtf16(u"\U0001F1F2\U0001F1F6")},
        {QStringLiteral(":flag_Mauritania:"), QString::fromUtf16(u"\U0001F1F2\U0001F1F7")},
        {QStringLiteral(":flag_Montserrat:"), QString::fromUtf16(u"\U0001F1F2\U0001F1F8")},
        {QStringLiteral(":flag_Malta:"), QString::fromUtf16(u"\U0001F1F2\U0001F1F9")},
        {QStringLiteral(":flag_Mauritius:"), QString::fromUtf16(u"\U0001F1F2\U0001F1FA")},
        {QStringLiteral(":flag_Maldives:"), QString::fromUtf16(u"\U0001F1F2\U0001F1FB")},
        {QStringLiteral(":flag_Malawi:"), QString::fromUtf16(u"\U0001F1F2\U0001F1FC")},
        {QStringLiteral(":flag_Mexico:"), QString::fromUtf16(u"\U0001F1F2\U0001F1FD")},
        {QStringLiteral(":flag_Malaysia:"), QString::fromUtf16(u"\U0001F1F2\U0001F1FE")},
        {QStringLiteral(":flag_Mozambique:"), QString::fromUtf16(u"\U0001F1F2\U0001F1FF")},
        {QStringLiteral(":flag_Namibia:"), QString::fromUtf16(u"\U0001F1F3\U0001F1E6")},
        {QStringLiteral(":flag_New_Caledonia:"), QString::fromUtf16(u"\U0001F1F3\U0001F1E8")},
        {QStringLiteral(":flag_Niger:"), QString::fromUtf16(u"\U0001F1F3\U0001F1EA")},
        {QStringLiteral(":flag_Norfolk_Island:"), QString::fromUtf16(u"\U0001F1F3\U0001F1EB")},
        {QStringLiteral(":flag_Nigeria:"), QString::fromUtf16(u"\U0001F1F3\U0001F1EC")},
        {QStringLiteral(":flag_Nicaragua:"), QString::fromUtf16(u"\U0001F1F3\U0001F1EE")},
        {QStringLiteral(":flag_Netherlands:"), QString::fromUtf16(u"\U0001F1F3\U0001F1F1")},
        {QStringLiteral(":flag_Norway:"), QString::fromUtf16(u"\U0001F1F3\U0001F1F4")},
        {QStringLiteral(":flag_Nepal:"), QString::fromUtf16(u"\U0001F1F3\U0001F1F5")},
        {QStringLiteral(":flag_Nauru:"), QString::fromUtf16(u"\U0001F1F3\U0001F1F7")},
        {QStringLiteral(":flag_Niue:"), QString::fromUtf16(u"\U0001F1F3\U0001F1FA")},
        {QStringLiteral(":flag_New_Zealand:"), QString::fromUtf16(u"\U0001F1F3\U0001F1FF")},
        {QStringLiteral(":flag_Oman:"), QString::fromUtf16(u"\U0001F1F4\U0001F1F2")},
        {QStringLiteral(":flag_Panama:"), QString::fromUtf16(u"\U0001F1F5\U0001F1E6")},
        {QStringLiteral(":flag_Peru:"), QString::fromUtf16(u"\U0001F1F5\U0001F1EA")},
        {QStringLiteral(":flag_French_Polynesia:"), QString::fromUtf16(u"\U0001F1F5\U0001F1EB")},
        {QStringLiteral(":flag_Papua_New_Guinea:"), QString::fromUtf16(u"\U0001F1F5\U0001F1EC")},
        {QStringLiteral(":flag_Philippines:"), QString::fromUtf16(u"\U0001F1F5\U0001F1ED")},
        {QStringLiteral(":flag_Pakistan:"), QString::fromUtf16(u"\U0001F1F5\U0001F1F0")},
        {QStringLiteral(":flag_Poland:"), QString::fromUtf16(u"\U0001F1F5\U0001F1F1")},
        {QStringLiteral(":flag_St._Pierre_&_Miquelon:"), QString::fromUtf16(u"\U0001F1F5\U0001F1F2")},
        {QStringLiteral(":flag_Pitcairn_Islands:"), QString::fromUtf16(u"\U0001F1F5\U0001F1F3")},
        {QStringLiteral(":flag_Puerto_Rico:"), QString::fromUtf16(u"\U0001F1F5\U0001F1F7")},
        {QStringLiteral(":flag_Palestinian_Territories:"), QString::fromUtf16(u"\U0001F1F5\U0001F1F8")},
        {QStringLiteral(":flag_Portugal:"), QString::fromUtf16(u"\U0001F1F5\U0001F1F9")},
        {QStringLiteral(":flag_Palau:"), QString::fromUtf16(u"\U0001F1F5\U0001F1FC")},
        {QStringLiteral(":flag_Paraguay:"), QString::fromUtf16(u"\U0001F1F5\U0001F1FE")},
        {QStringLiteral(":flag_Qatar:"), QString::fromUtf16(u"\U0001F1F6\U0001F1E6")},
        {QStringLiteral(":flag_Réunion:"), QString::fromUtf16(u"\U0001F1F7\U0001F1EA")},
        {QStringLiteral(":flag_Romania:"), QString::fromUtf16(u"\U0001F1F7\U0001F1F4")},
        {QStringLiteral(":flag_Serbia:"), QString::fromUtf16(u"\U0001F1F7\U0001F1F8")},
        {QStringLiteral(":flag_Russia:"), QString::fromUtf16(u"\U0001F1F7\U0001F1FA")},
        {QStringLiteral(":flag_Rwanda:"), QString::fromUtf16(u"\U0001F1F7\U0001F1FC")},
        {QStringLiteral(":flag_Saudi_Arabia:"), QString::fromUtf16(u"\U0001F1F8\U0001F1E6")},
        {QStringLiteral(":flag_Solomon_Islands:"), QString::fromUtf16(u"\U0001F1F8\U0001F1E7")},
        {QStringLiteral(":flag_Seychelles:"), QString::fromUtf16(u"\U0001F1F8\U0001F1E8")},
        {QStringLiteral(":flag_Sudan:"), QString::fromUtf16(u"\U0001F1F8\U0001F1E9")},
        {QStringLiteral(":flag_Sweden:"), QString::fromUtf16(u"\U0001F1F8\U0001F1EA")},
        {QStringLiteral(":flag_Singapore:"), QString::fromUtf16(u"\U0001F1F8\U0001F1EC")},
        {QStringLiteral(":flag_St._Helena:"), QString::fromUtf16(u"\U0001F1F8\U0001F1ED")},
        {QStringLiteral(":flag_Slovenia:"), QString::fromUtf16(u"\U0001F1F8\U0001F1EE")},
        {QStringLiteral(":flag_Svalbard_&_Jan_Mayen:"), QString::fromUtf16(u"\U0001F1F8\U0001F1EF")},
        {QStringLiteral(":flag_Slovakia:"), QString::fromUtf16(u"\U0001F1F8\U0001F1F0")},
        {QStringLiteral(":flag_Sierra_Leone:"), QString::fromUtf16(u"\U0001F1F8\U0001F1F1")},
        {QStringLiteral(":flag_San_Marino:"), QString::fromUtf16(u"\U0001F1F8\U0001F1F2")},
        {QStringLiteral(":flag_Senegal:"), QString::fromUtf16(u"\U0001F1F8\U0001F1F3")},
        {QStringLiteral(":flag_Somalia:"), QString::fromUtf16(u"\U0001F1F8\U0001F1F4")},
        {QStringLiteral(":flag_Suriname:"), QString::fromUtf16(u"\U0001F1F8\U0001F1F7")},
        {QStringLiteral(":flag_South_Sudan:"), QString::fromUtf16(u"\U0001F1F8\U0001F1F8")},
        {QStringLiteral(":flag_São_Tomé_&_Príncipe:"), QString::fromUtf16(u"\U0001F1F8\U0001F1F9")},
        {QStringLiteral(":flag_El_Salvador:"), QString::fromUtf16(u"\U0001F1F8\U0001F1FB")},
        {QStringLiteral(":flag_Sint_Maarten:"), QString::fromUtf16(u"\U0001F1F8\U0001F1FD")},
        {QStringLiteral(":flag_Syria:"), QString::fromUtf16(u"\U0001F1F8\U0001F1FE")},
        {QStringLiteral(":flag_Eswatini:"), QString::fromUtf16(u"\U0001F1F8\U0001F1FF")},
        {QStringLiteral(":flag_Tristan_da_Cunha:"), QString::fromUtf16(u"\U0001F1F9\U0001F1E6")},
        {QStringLiteral(":flag_Turks_&_Caicos_Islands:"), QString::fromUtf16(u"\U0001F1F9\U0001F1E8")},
        {QStringLiteral(":flag_Chad:"), QString::fromUtf16(u"\U0001F1F9\U0001F1E9")},
        {QStringLiteral(":flag_French_Southern_Territories:"), QString::fromUtf16(u"\U0001F1F9\U0001F1EB")},
        {QStringLiteral(":flag_Togo:"), QString::fromUtf16(u"\U0001F1F9\U0001F1EC")},
        {QStringLiteral(":flag_Thailand:"), QString::fromUtf16(u"\U0001F1F9\U0001F1ED")},
        {QStringLiteral(":flag_Tajikistan:"), QString::fromUtf16(u"\U0001F1F9\U0001F1EF")},
        {QStringLiteral(":flag_Tokelau:"), QString::fromUtf16(u"\U0001F1F9\U0001F1F0")},
        {QStringLiteral(":flag_Timor-Leste:"), QString::fromUtf16(u"\U0001F1F9\U0001F1F1")},
        {QStringLiteral(":flag_Turkmenistan:"), QString::fromUtf16(u"\U0001F1F9\U0001F1F2")},
        {QStringLiteral(":flag_Tunisia:"), QString::fromUtf16(u"\U0001F1F9\U0001F1F3")},
        {QStringLiteral(":flag_Tonga:"), QString::fromUtf16(u"\U0001F1F9\U0001F1F4")},
        {QStringLiteral(":flag_Turkey:"), QString::fromUtf16(u"\U0001F1F9\U0001F1F7")},
        {QStringLiteral(":flag_Trinidad_&_Tobago:"), QString::fromUtf16(u"\U0001F1F9\U0001F1F9")},
        {QStringLiteral(":flag_Tuvalu:"), QString::fromUtf16(u"\U0001F1F9\U0001F1FB")},
        {QStringLiteral(":flag_Taiwan:"), QString::fromUtf16(u"\U0001F1F9\U0001F1FC")},
        {QStringLiteral(":flag_Tanzania:"), QString::fromUtf16(u"\U0001F1F9\U0001F1FF")},
        {QStringLiteral(":flag_Ukraine:"), QString::fromUtf16(u"\U0001F1FA\U0001F1E6")},
        {QStringLiteral(":flag_Uganda:"), QString::fromUtf16(u"\U0001F1FA\U0001F1EC")},
        {QStringLiteral(":flag_U.S._Outlying_Islands:"), QString::fromUtf16(u"\U0001F1FA\U0001F1F2")},
        {QStringLiteral(":flag_United_Nations:"), QString::fromUtf16(u"\U0001F1FA\U0001F1F3")},
        {QStringLiteral(":flag_United_States:"), QString::fromUtf16(u"\U0001F1FA\U0001F1F8")},
        {QStringLiteral(":flag_Uruguay:"), QString::fromUtf16(u"\U0001F1FA\U0001F1FE")},
        {QStringLiteral(":flag_Uzbekistan:"), QString::fromUtf16(u"\U0001F1FA\U0001F1FF")},
        {QStringLiteral(":flag_Vatican_City:"), QString::fromUtf16(u"\U0001F1FB\U0001F1E6")},
        {QStringLiteral(":flag_St._Vincent_&_Grenadines:"), QString::fromUtf16(u"\U0001F1FB\U0001F1E8")},
        {QStringLiteral(":flag_Venezuela:"), QString::fromUtf16(u"\U0001F1FB\U0001F1EA")},
        {QStringLiteral(":flag_British_Virgin_Islands:"), QString::fromUtf16(u"\U0001F1FB\U0001F1EC")},
        {QStringLiteral(":flag_U.S._Virgin_Islands:"), QString::fromUtf16(u"\U0001F1FB\U0001F1EE")},
        {QStringLiteral(":flag_Vietnam:"), QString::fromUtf16(u"\U0001F1FB\U0001F1F3")},
        {QStringLiteral(":flag_Vanuatu:"), QString::fromUtf16(u"\U0001F1FB\U0001F1FA")},
        {QStringLiteral(":flag_Wallis_&_Futuna:"), QString::fromUtf16(u"\U0001F1FC\U0001F1EB")},
        {QStringLiteral(":flag_Samoa:"), QString::fromUtf16(u"\U0001F1FC\U0001F1F8")},
        {QStringLiteral(":flag_Kosovo:"), QString::fromUtf16(u"\U0001F1FD\U0001F1F0")},
        {QStringLiteral(":flag_Yemen:"), QString::fromUtf16(u"\U0001F1FE\U0001F1EA")},
        {QStringLiteral(":flag_Mayotte:"), QString::fromUtf16(u"\U0001F1FE\U0001F1F9")},
        {QStringLiteral(":flag_South_Africa:"), QString::fromUtf16(u"\U0001F1FF\U0001F1E6")},
        {QStringLiteral(":flag_Zambia:"), QString::fromUtf16(u"\U0001F1FF\U0001F1F2")},
        {QStringLiteral(":flag_Zimbabwe:"), QString::fromUtf16(u"\U0001F1FF\U0001F1FC")},
        {QStringLiteral(":flag_England:"), QString::fromUtf16(u"\U0001F3F4\U000E0067\U000E0062\U000E0065\U000E006E\U000E0067\U000E007F")},
        {QStringLiteral(":flag_Scotland:"), QString::fromUtf16(u"\U0001F3F4\U000E0067\U000E0062\U000E0073\U000E0063\U000E0074\U000E007F")},
        {QStringLiteral(":flag_Wales:"), QString::fromUtf16(u"\U0001F3F4\U000E0067\U000E0062\U000E0077\U000E006C\U000E0073\U000E007F")}};
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeFaceEmoji()
{
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst {
        {QStringLiteral(":grinning_face:"), QString::fromUtf16(u"\U0001F600")},
        {QStringLiteral(":grinning_face_with_big_eyes:"), QString::fromUtf16(u"\U0001F603")},
        {QStringLiteral(":grinning_face_with_smiling_eyes:"), QString::fromUtf16(u"\U0001F604")},
        {QStringLiteral(":beaming_face_with_smiling_eyes:"), QString::fromUtf16(u"\U0001F601")},
        {QStringLiteral(":grinning_squinting_face:"), QString::fromUtf16(u"\U0001F606")},
        {QStringLiteral(":grinning_face_with_sweat:"), QString::fromUtf16(u"\U0001F605")},
        {QStringLiteral(":rolling_on_the_floor_laughing:"), QString::fromUtf16(u"\U0001F923")},
        {QStringLiteral(":face_with_tears_of_joy:"), QString::fromUtf16(u"\U0001F602")},
        {QStringLiteral(":slightly_smiling_face:"), QString::fromUtf16(u"\U0001F642")},
        {QStringLiteral(":upside-down_face:"), QString::fromUtf16(u"\U0001F643")},
        {QStringLiteral(":winking_face:"), QString::fromUtf16(u"\U0001F609")},
        {QStringLiteral(":smiling_face_with_smiling_eyes:"), QString::fromUtf16(u"\U0001F60A")},
        {QStringLiteral(":smiling_face_with_halo:"), QString::fromUtf16(u"\U0001F607")},
        {QStringLiteral(":smiling_face_with_hearts:"), QString::fromUtf16(u"\U0001F970")},
        {QStringLiteral(":smiling_face_with_heart-eyes:"), QString::fromUtf16(u"\U0001F60D")},
        {QStringLiteral(":star-struck:"), QString::fromUtf16(u"\U0001F929")},
        {QStringLiteral(":face_blowing_a_kiss:"), QString::fromUtf16(u"\U0001F618")},
        {QStringLiteral(":kissing_face:"), QString::fromUtf16(u"\U0001F617")},
        {QStringLiteral(":smiling_face:"), QString::fromUtf16(u"\U0000263A")},
        {QStringLiteral(":kissing_face_with_closed_eyes:"), QString::fromUtf16(u"\U0001F61A")},
        {QStringLiteral(":kissing_face_with_smiling_eyes:"), QString::fromUtf16(u"\U0001F619")},
        {QStringLiteral(":face_savoring_food:"), QString::fromUtf16(u"\U0001F60B")},
        {QStringLiteral(":face_with_tongue:"), QString::fromUtf16(u"\U0001F61B")},
        {QStringLiteral(":winking_face_with_tongue:"), QString::fromUtf16(u"\U0001F61C")},
        {QStringLiteral(":zany_face:"), QString::fromUtf16(u"\U0001F92A")},
        {QStringLiteral(":squinting_face_with_tongue:"), QString::fromUtf16(u"\U0001F61D")},
        {QStringLiteral(":money-mouth_face:"), QString::fromUtf16(u"\U0001F911")},
        {QStringLiteral(":hugging_face:"), QString::fromUtf16(u"\U0001F917")},
        {QStringLiteral(":face_with_hand_over_mouth:"), QString::fromUtf16(u"\U0001F92D")},
        {QStringLiteral(":shushing_face:"), QString::fromUtf16(u"\U0001F92B")},
        {QStringLiteral(":thinking_face:"), QString::fromUtf16(u"\U0001F914")},
        {QStringLiteral(":zipper-mouth_face:"), QString::fromUtf16(u"\U0001F910")},
        {QStringLiteral(":face_with_raised_eyebrow:"), QString::fromUtf16(u"\U0001F928")},
        {QStringLiteral(":neutral_face:"), QString::fromUtf16(u"\U0001F610")},
        {QStringLiteral(":expressionless_face:"), QString::fromUtf16(u"\U0001F611")},
        {QStringLiteral(":face_without_mouth:"), QString::fromUtf16(u"\U0001F636")},
        {QStringLiteral(":smirking_face:"), QString::fromUtf16(u"\U0001F60F")},
        {QStringLiteral(":unamused_face:"), QString::fromUtf16(u"\U0001F612")},
        {QStringLiteral(":face_with_rolling_eyes:"), QString::fromUtf16(u"\U0001F644")},
        {QStringLiteral(":grimacing_face:"), QString::fromUtf16(u"\U0001F62C")},
        {QStringLiteral(":lying_face:"), QString::fromUtf16(u"\U0001F925")},
        {QStringLiteral(":relieved_face:"), QString::fromUtf16(u"\U0001F60C")},
        {QStringLiteral(":pensive_face:"), QString::fromUtf16(u"\U0001F614")},
        {QStringLiteral(":sleepy_face:"), QString::fromUtf16(u"\U0001F62A")},
        {QStringLiteral(":drooling_face:"), QString::fromUtf16(u"\U0001F924")},
        {QStringLiteral(":sleeping_face:"), QString::fromUtf16(u"\U0001F634")},
        {QStringLiteral(":face_with_medical_mask:"), QString::fromUtf16(u"\U0001F637")},
        {QStringLiteral(":face_with_thermometer:"), QString::fromUtf16(u"\U0001F912")},
        {QStringLiteral(":face_with_head-bandage:"), QString::fromUtf16(u"\U0001F915")},
        {QStringLiteral(":nauseated_face:"), QString::fromUtf16(u"\U0001F922")},
        {QStringLiteral(":face_vomiting:"), QString::fromUtf16(u"\U0001F92E")},
        {QStringLiteral(":sneezing_face:"), QString::fromUtf16(u"\U0001F927")},
        {QStringLiteral(":hot_face:"), QString::fromUtf16(u"\U0001F975")},
        {QStringLiteral(":cold_face:"), QString::fromUtf16(u"\U0001F976")},
        {QStringLiteral(":woozy_face:"), QString::fromUtf16(u"\U0001F974")},
        {QStringLiteral(":dizzy_face:"), QString::fromUtf16(u"\U0001F635")},
        {QStringLiteral(":exploding_head:"), QString::fromUtf16(u"\U0001F92F")},
        {QStringLiteral(":cowboy_hat_face:"), QString::fromUtf16(u"\U0001F920")},
        {QStringLiteral(":partying_face:"), QString::fromUtf16(u"\U0001F973")},
        {QStringLiteral(":smiling_face_with_sunglasses:"), QString::fromUtf16(u"\U0001F60E")},
        {QStringLiteral(":nerd_face:"), QString::fromUtf16(u"\U0001F913")},
        {QStringLiteral(":face_with_monocle:"), QString::fromUtf16(u"\U0001F9D0")},
        {QStringLiteral(":confused_face:"), QString::fromUtf16(u"\U0001F615")},
        {QStringLiteral(":worried_face:"), QString::fromUtf16(u"\U0001F61F")},
        {QStringLiteral(":slightly_frowning_face:"), QString::fromUtf16(u"\U0001F641")},
        {QStringLiteral(":frowning_face:"), QString::fromUtf16(u"\U00002639")},
        {QStringLiteral(":face_with_open_mouth:"), QString::fromUtf16(u"\U0001F62E")},
        {QStringLiteral(":hushed_face:"), QString::fromUtf16(u"\U0001F62F")},
        {QStringLiteral(":astonished_face:"), QString::fromUtf16(u"\U0001F632")},
        {QStringLiteral(":flushed_face:"), QString::fromUtf16(u"\U0001F633")},
        {QStringLiteral(":pleading_face:"), QString::fromUtf16(u"\U0001F97A")},
        {QStringLiteral(":frowning_face_with_open_mouth:"), QString::fromUtf16(u"\U0001F626")},
        {QStringLiteral(":anguished_face:"), QString::fromUtf16(u"\U0001F627")},
        {QStringLiteral(":fearful_face:"), QString::fromUtf16(u"\U0001F628")},
        {QStringLiteral(":anxious_face_with_sweat:"), QString::fromUtf16(u"\U0001F630")},
        {QStringLiteral(":sad_but_relieved_face:"), QString::fromUtf16(u"\U0001F625")},
        {QStringLiteral(":crying_face:"), QString::fromUtf16(u"\U0001F622")},
        {QStringLiteral(":loudly_crying_face:"), QString::fromUtf16(u"\U0001F62D")},
        {QStringLiteral(":face_screaming_in_fear:"), QString::fromUtf16(u"\U0001F631")},
        {QStringLiteral(":confounded_face:"), QString::fromUtf16(u"\U0001F616")},
        {QStringLiteral(":persevering_face:"), QString::fromUtf16(u"\U0001F623")},
        {QStringLiteral(":disappointed_face:"), QString::fromUtf16(u"\U0001F61E")},
        {QStringLiteral(":downcast_face_with_sweat:"), QString::fromUtf16(u"\U0001F613")},
        {QStringLiteral(":weary_face:"), QString::fromUtf16(u"\U0001F629")},
        {QStringLiteral(":tired_face:"), QString::fromUtf16(u"\U0001F62B")},
        {QStringLiteral(":yawning_face:"), QString::fromUtf16(u"\U0001F971")},
        {QStringLiteral(":face_with_steam_from_nose:"), QString::fromUtf16(u"\U0001F624")},
        {QStringLiteral(":pouting_face:"), QString::fromUtf16(u"\U0001F621")},
        {QStringLiteral(":angry_face:"), QString::fromUtf16(u"\U0001F620")},
        {QStringLiteral(":face_with_symbols_on_mouth:"), QString::fromUtf16(u"\U0001F92C")},
        {QStringLiteral(":smiling_face_with_horns:"), QString::fromUtf16(u"\U0001F608")},
        {QStringLiteral(":angry_face_with_horns:"), QString::fromUtf16(u"\U0001F47F")},
        {QStringLiteral(":skull:"), QString::fromUtf16(u"\U0001F480")},
        {QStringLiteral(":skull_and_crossbones:"), QString::fromUtf16(u"\U00002620")},
        {QStringLiteral(":pile_of_poo:"), QString::fromUtf16(u"\U0001F4A9")},
        {QStringLiteral(":clown_face:"), QString::fromUtf16(u"\U0001F921")},
        {QStringLiteral(":ogre:"), QString::fromUtf16(u"\U0001F479")},
        {QStringLiteral(":goblin:"), QString::fromUtf16(u"\U0001F47A")},
        {QStringLiteral(":ghost:"), QString::fromUtf16(u"\U0001F47B")},
        {QStringLiteral(":alien:"), QString::fromUtf16(u"\U0001F47D")},
        {QStringLiteral(":alien_monster:"), QString::fromUtf16(u"\U0001F47E")},
        {QStringLiteral(":robot:"), QString::fromUtf16(u"\U0001F916")},
        {QStringLiteral(":grinning_cat:"), QString::fromUtf16(u"\U0001F63A")},
        {QStringLiteral(":grinning_cat_with_smiling_eyes:"), QString::fromUtf16(u"\U0001F638")},
        {QStringLiteral(":cat_with_tears_of_joy:"), QString::fromUtf16(u"\U0001F639")},
        {QStringLiteral(":smiling_cat_with_heart-eyes:"), QString::fromUtf16(u"\U0001F63B")},
        {QStringLiteral(":cat_with_wry_smile:"), QString::fromUtf16(u"\U0001F63C")},
        {QStringLiteral(":kissing_cat:"), QString::fromUtf16(u"\U0001F63D")},
        {QStringLiteral(":weary_cat:"), QString::fromUtf16(u"\U0001F640")},
        {QStringLiteral(":crying_cat:"), QString::fromUtf16(u"\U0001F63F")},
        {QStringLiteral(":pouting_cat:"), QString::fromUtf16(u"\U0001F63E")},
        {QStringLiteral(":see-no-evil_monkey:"), QString::fromUtf16(u"\U0001F648")},
        {QStringLiteral(":hear-no-evil_monkey:"), QString::fromUtf16(u"\U0001F649")},
        {QStringLiteral(":speak-no-evil_monkey:"), QString::fromUtf16(u"\U0001F64A")},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeAnimalsEmoji()
{
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst {
        {QStringLiteral(":monkey_face:"), QString::fromUtf16(u"\U0001F435")},
        {QStringLiteral(":monkey:"), QString::fromUtf16(u"\U0001F412")},
        {QStringLiteral(":gorilla:"), QString::fromUtf16(u"\U0001F98D")},
        {QStringLiteral(":orangutan:"), QString::fromUtf16(u"\U0001F9A7")},
        {QStringLiteral(":dog_face:"), QString::fromUtf16(u"\U0001F436")},
        {QStringLiteral(":dog:"), QString::fromUtf16(u"\U0001F415")},
        {QStringLiteral(":guide_dog:"), QString::fromUtf16(u"\U0001F9AE")},
        {QStringLiteral(":service_dog:"), QString::fromUtf16(u"\U0001F415\U0000200D\U0001F9BA")},
        {QStringLiteral(":poodle:"), QString::fromUtf16(u"\U0001F429")},
        {QStringLiteral(":wolf:"), QString::fromUtf16(u"\U0001F43A")},
        {QStringLiteral(":fox:"), QString::fromUtf16(u"\U0001F98A")},
        {QStringLiteral(":raccoon:"), QString::fromUtf16(u"\U0001F99D")},
        {QStringLiteral(":cat_face:"), QString::fromUtf16(u"\U0001F431")},
        {QStringLiteral(":cat:"), QString::fromUtf16(u"\U0001F408")},
        {QStringLiteral(":lion:"), QString::fromUtf16(u"\U0001F981")},
        {QStringLiteral(":tiger_face:"), QString::fromUtf16(u"\U0001F42F")},
        {QStringLiteral(":tiger:"), QString::fromUtf16(u"\U0001F405")},
        {QStringLiteral(":leopard:"), QString::fromUtf16(u"\U0001F406")},
        {QStringLiteral(":horse_face:"), QString::fromUtf16(u"\U0001F434")},
        {QStringLiteral(":horse:"), QString::fromUtf16(u"\U0001F40E")},
        {QStringLiteral(":unicorn:"), QString::fromUtf16(u"\U0001F984")},
        {QStringLiteral(":zebra:"), QString::fromUtf16(u"\U0001F993")},
        {QStringLiteral(":deer:"), QString::fromUtf16(u"\U0001F98C")},
        {QStringLiteral(":cow_face:"), QString::fromUtf16(u"\U0001F42E")},
        {QStringLiteral(":ox:"), QString::fromUtf16(u"\U0001F402")},
        {QStringLiteral(":water_buffalo:"), QString::fromUtf16(u"\U0001F403")},
        {QStringLiteral(":cow:"), QString::fromUtf16(u"\U0001F404")},
        {QStringLiteral(":pig_face:"), QString::fromUtf16(u"\U0001F437")},
        {QStringLiteral(":pig:"), QString::fromUtf16(u"\U0001F416")},
        {QStringLiteral(":boar:"), QString::fromUtf16(u"\U0001F417")},
        {QStringLiteral(":pig_nose:"), QString::fromUtf16(u"\U0001F43D")},
        {QStringLiteral(":ram:"), QString::fromUtf16(u"\U0001F40F")},
        {QStringLiteral(":ewe:"), QString::fromUtf16(u"\U0001F411")},
        {QStringLiteral(":goat:"), QString::fromUtf16(u"\U0001F410")},
        {QStringLiteral(":camel:"), QString::fromUtf16(u"\U0001F42A")},
        {QStringLiteral(":two-hump_camel:"), QString::fromUtf16(u"\U0001F42B")},
        {QStringLiteral(":llama:"), QString::fromUtf16(u"\U0001F999")},
        {QStringLiteral(":giraffe:"), QString::fromUtf16(u"\U0001F992")},
        {QStringLiteral(":elephant:"), QString::fromUtf16(u"\U0001F418")},
        {QStringLiteral(":rhinoceros:"), QString::fromUtf16(u"\U0001F98F")},
        {QStringLiteral(":hippopotamus:"), QString::fromUtf16(u"\U0001F99B")},
        {QStringLiteral(":mouse_face:"), QString::fromUtf16(u"\U0001F42D")},
        {QStringLiteral(":mouse:"), QString::fromUtf16(u"\U0001F401")},
        {QStringLiteral(":rat:"), QString::fromUtf16(u"\U0001F400")},
        {QStringLiteral(":hamster:"), QString::fromUtf16(u"\U0001F439")},
        {QStringLiteral(":rabbit_face:"), QString::fromUtf16(u"\U0001F430")},
        {QStringLiteral(":rabbit:"), QString::fromUtf16(u"\U0001F407")},
        {QStringLiteral(":chipmunk:"), QString::fromUtf16(u"\U0001F43F")},
        {QStringLiteral(":hedgehog:"), QString::fromUtf16(u"\U0001F994")},
        {QStringLiteral(":bat:"), QString::fromUtf16(u"\U0001F987")},
        {QStringLiteral(":bear:"), QString::fromUtf16(u"\U0001F43B")},
        {QStringLiteral(":koala:"), QString::fromUtf16(u"\U0001F428")},
        {QStringLiteral(":panda:"), QString::fromUtf16(u"\U0001F43C")},
        {QStringLiteral(":sloth:"), QString::fromUtf16(u"\U0001F9A5")},
        {QStringLiteral(":otter:"), QString::fromUtf16(u"\U0001F9A6")},
        {QStringLiteral(":skunk:"), QString::fromUtf16(u"\U0001F9A8")},
        {QStringLiteral(":kangaroo:"), QString::fromUtf16(u"\U0001F998")},
        {QStringLiteral(":badger:"), QString::fromUtf16(u"\U0001F9A1")},
        {QStringLiteral(":paw_prints:"), QString::fromUtf16(u"\U0001F43E")},
        {QStringLiteral(":turkey:"), QString::fromUtf16(u"\U0001F983")},
        {QStringLiteral(":chicken:"), QString::fromUtf16(u"\U0001F414")},
        {QStringLiteral(":rooster:"), QString::fromUtf16(u"\U0001F413")},
        {QStringLiteral(":hatching_chick:"), QString::fromUtf16(u"\U0001F423")},
        {QStringLiteral(":baby_chick:"), QString::fromUtf16(u"\U0001F424")},
        {QStringLiteral(":front-facing_baby_chick:"), QString::fromUtf16(u"\U0001F425")},
        {QStringLiteral(":bird:"), QString::fromUtf16(u"\U0001F426")},
        {QStringLiteral(":penguin:"), QString::fromUtf16(u"\U0001F427")},
        {QStringLiteral(":dove:"), QString::fromUtf16(u"\U0001F54A")},
        {QStringLiteral(":eagle:"), QString::fromUtf16(u"\U0001F985")},
        {QStringLiteral(":duck:"), QString::fromUtf16(u"\U0001F986")},
        {QStringLiteral(":swan:"), QString::fromUtf16(u"\U0001F9A2")},
        {QStringLiteral(":owl:"), QString::fromUtf16(u"\U0001F989")},
        {QStringLiteral(":flamingo:"), QString::fromUtf16(u"\U0001F9A9")},
        {QStringLiteral(":peacock:"), QString::fromUtf16(u"\U0001F99A")},
        {QStringLiteral(":parrot:"), QString::fromUtf16(u"\U0001F99C")},
        {QStringLiteral(":frog:"), QString::fromUtf16(u"\U0001F438")},
        {QStringLiteral(":crocodile:"), QString::fromUtf16(u"\U0001F40A")},
        {QStringLiteral(":turtle:"), QString::fromUtf16(u"\U0001F422")},
        {QStringLiteral(":lizard:"), QString::fromUtf16(u"\U0001F98E")},
        {QStringLiteral(":snake:"), QString::fromUtf16(u"\U0001F40D")},
        {QStringLiteral(":dragon_face:"), QString::fromUtf16(u"\U0001F432")},
        {QStringLiteral(":dragon:"), QString::fromUtf16(u"\U0001F409")},
        {QStringLiteral(":sauropod:"), QString::fromUtf16(u"\U0001F995")},
        {QStringLiteral(":T-Rex:"), QString::fromUtf16(u"\U0001F996")},
        {QStringLiteral(":spouting_whale:"), QString::fromUtf16(u"\U0001F433")},
        {QStringLiteral(":whale:"), QString::fromUtf16(u"\U0001F40B")},
        {QStringLiteral(":dolphin:"), QString::fromUtf16(u"\U0001F42C")},
        {QStringLiteral(":fish:"), QString::fromUtf16(u"\U0001F41F")},
        {QStringLiteral(":tropical_fish:"), QString::fromUtf16(u"\U0001F420")},
        {QStringLiteral(":blowfish:"), QString::fromUtf16(u"\U0001F421")},
        {QStringLiteral(":shark:"), QString::fromUtf16(u"\U0001F988")},
        {QStringLiteral(":octopus:"), QString::fromUtf16(u"\U0001F419")},
        {QStringLiteral(":spiral_shell:"), QString::fromUtf16(u"\U0001F41A")},
        {QStringLiteral(":snail:"), QString::fromUtf16(u"\U0001F40C")},
        {QStringLiteral(":butterfly:"), QString::fromUtf16(u"\U0001F98B")},
        {QStringLiteral(":bug:"), QString::fromUtf16(u"\U0001F41B")},
        {QStringLiteral(":ant:"), QString::fromUtf16(u"\U0001F41C")},
        {QStringLiteral(":honeybee:"), QString::fromUtf16(u"\U0001F41D")},
        {QStringLiteral(":lady_beetle:"), QString::fromUtf16(u"\U0001F41E")},
        {QStringLiteral(":cricket:"), QString::fromUtf16(u"\U0001F997")},
        {QStringLiteral(":spider:"), QString::fromUtf16(u"\U0001F577")},
        {QStringLiteral(":spider_web:"), QString::fromUtf16(u"\U0001F578")},
        {QStringLiteral(":scorpion:"), QString::fromUtf16(u"\U0001F982")},
        {QStringLiteral(":mosquito:"), QString::fromUtf16(u"\U0001F99F")},
        {QStringLiteral(":microbe:"), QString::fromUtf16(u"\U0001F9A0")}
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodePlantEmoji()
{
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst {
        {QStringLiteral(":bouquet:"), QString::fromUtf16(u"\U0001F490")},
        {QStringLiteral(":cherry_blossom:"), QString::fromUtf16(u"\U0001F338")},
        {QStringLiteral(":white_flower:"), QString::fromUtf16(u"\U0001F4AE")},
        {QStringLiteral(":rosette:"), QString::fromUtf16(u"\U0001F3F5")},
        {QStringLiteral(":rose:"), QString::fromUtf16(u"\U0001F339")},
        {QStringLiteral(":wilted_flower:"), QString::fromUtf16(u"\U0001F940")},
        {QStringLiteral(":hibiscus:"), QString::fromUtf16(u"\U0001F33A")},
        {QStringLiteral(":sunflower:"), QString::fromUtf16(u"\U0001F33B")},
        {QStringLiteral(":blossom:"), QString::fromUtf16(u"\U0001F33C")},
        {QStringLiteral(":tulip:"), QString::fromUtf16(u"\U0001F337")},
        {QStringLiteral(":seedling:"), QString::fromUtf16(u"\U0001F331")},
        {QStringLiteral(":evergreen_tree:"), QString::fromUtf16(u"\U0001F332")},
        {QStringLiteral(":deciduous_tree:"), QString::fromUtf16(u"\U0001F333")},
        {QStringLiteral(":palm_tree:"), QString::fromUtf16(u"\U0001F334")},
        {QStringLiteral(":cactus:"), QString::fromUtf16(u"\U0001F335")},
        {QStringLiteral(":sheaf_of_rice:"), QString::fromUtf16(u"\U0001F33E")},
        {QStringLiteral(":herb:"), QString::fromUtf16(u"\U0001F33F")},
        {QStringLiteral(":shamrock:"), QString::fromUtf16(u"\U00002618")},
        {QStringLiteral(":four_leaf_clover:"), QString::fromUtf16(u"\U0001F340")},
        {QStringLiteral(":maple_leaf:"), QString::fromUtf16(u"\U0001F341")},
        {QStringLiteral(":fallen_leaf:"), QString::fromUtf16(u"\U0001F342")},
        {QStringLiteral(":leaf_fluttering_in_wind:"), QString::fromUtf16(u"\U0001F343")},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeScienceEmoji()
{
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst {
        {QStringLiteral(":alembic:"), QString::fromUtf16(u"\U00002697")},
        {QStringLiteral(":test_tube:"), QString::fromUtf16(u"\U0001F9EA")},
        {QStringLiteral(":petri_dish:"), QString::fromUtf16(u"\U0001F9EB")},
        {QStringLiteral(":dna:"), QString::fromUtf16(u"\U0001F9EC")},
        {QStringLiteral(":microscope:"), QString::fromUtf16(u"\U0001F52C")},
        {QStringLiteral(":telescope:"), QString::fromUtf16(u"\U0001F52D")},
        {QStringLiteral(":satellite_antenna:"), QString::fromUtf16(u"\U0001F4E1")},
        {QStringLiteral(":syringe:"), QString::fromUtf16(u"\U0001F489")},
        {QStringLiteral(":drop_of_blood:"), QString::fromUtf16(u"\U0001FA78")},
        {QStringLiteral(":pill:"), QString::fromUtf16(u"\U0001F48A")},
        {QStringLiteral(":adhesive_bandage:"), QString::fromUtf16(u"\U0001FA79")},
        {QStringLiteral(":stethoscope:"), QString::fromUtf16(u"\U0001FA7A")},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeComputerEmoji()
{
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst {
        {QStringLiteral(":battery:"), QString::fromUtf16(u"\U0001F50B")},
        {QStringLiteral(":electric_plug:"), QString::fromUtf16(u"\U0001F50C")},
        {QStringLiteral(":laptop_computer:"), QString::fromUtf16(u"\U0001F4BB")},
        {QStringLiteral(":desktop_computer:"), QString::fromUtf16(u"\U0001F5A5")},
        {QStringLiteral(":printer:"), QString::fromUtf16(u"\U0001F5A8")},
        {QStringLiteral(":keyboard:"), QString::fromUtf16(u"\U00002328")},
        {QStringLiteral(":computer_mouse:"), QString::fromUtf16(u"\U0001F5B1")},
        {QStringLiteral(":trackball:"), QString::fromUtf16(u"\U0001F5B2")},
        {QStringLiteral(":computer_disk:"), QString::fromUtf16(u"\U0001F4BD")},
        {QStringLiteral(":floppy_disk:"), QString::fromUtf16(u"\U0001F4BE")},
        {QStringLiteral(":optical_disk:"), QString::fromUtf16(u"\U0001F4BF")},
        {QStringLiteral(":dvd:"), QString::fromUtf16(u"\U0001F4C0")},
        {QStringLiteral(":abacus:"), QString::fromUtf16(u"\U0001F9EE")},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeBookPaperEmoji()
{
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst {
        {QStringLiteral(":notebook_with_decorative_cover:"), QString::fromUtf16(u"\U0001F4D4")},
        {QStringLiteral(":closed_book:"), QString::fromUtf16(u"\U0001F4D5")},
        {QStringLiteral(":open_book:"), QString::fromUtf16(u"\U0001F4D6")},
        {QStringLiteral(":green_book:"), QString::fromUtf16(u"\U0001F4D7")},
        {QStringLiteral(":blue_book:"), QString::fromUtf16(u"\U0001F4D8")},
        {QStringLiteral(":orange_book:"), QString::fromUtf16(u"\U0001F4D9")},
        {QStringLiteral(":books:"), QString::fromUtf16(u"\U0001F4DA")},
        {QStringLiteral(":notebook:"), QString::fromUtf16(u"\U0001F4D3")},
        {QStringLiteral(":ledger:"), QString::fromUtf16(u"\U0001F4D2")},
        {QStringLiteral(":page_with_curl:"), QString::fromUtf16(u"\U0001F4C3")},
        {QStringLiteral(":scroll:"), QString::fromUtf16(u"\U0001F4DC")},
        {QStringLiteral(":page_facing_up:"), QString::fromUtf16(u"\U0001F4C4")},
        {QStringLiteral(":newspaper:"), QString::fromUtf16(u"\U0001F4F0")},
        {QStringLiteral(":rolled-up_newspaper:"), QString::fromUtf16(u"\U0001F5DE")},
        {QStringLiteral(":bookmark_tabs:"), QString::fromUtf16(u"\U0001F4D1")},
        {QStringLiteral(":bookmark:"), QString::fromUtf16(u"\U0001F516")},
        {QStringLiteral(":label:"), QString::fromUtf16(u"\U0001F3F7")},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeSoundMusicEmoji()
{
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst {
        {QStringLiteral(":muted_speaker:"), QString::fromUtf16(u"\U0001F507")},
        {QStringLiteral(":speaker_low_volume:"), QString::fromUtf16(u"\U0001F508")},
        {QStringLiteral(":speaker_medium_volume:"), QString::fromUtf16(u"\U0001F509")},
        {QStringLiteral(":speaker_high_volume:"), QString::fromUtf16(u"\U0001F50A")},
        {QStringLiteral(":loudspeaker:"), QString::fromUtf16(u"\U0001F4E2")},
        {QStringLiteral(":megaphone:"), QString::fromUtf16(u"\U0001F4E3")},
        {QStringLiteral(":postal_horn:"), QString::fromUtf16(u"\U0001F4EF")},
        {QStringLiteral(":bell:"), QString::fromUtf16(u"\U0001F514")},
        {QStringLiteral(":bell_with_slash:"), QString::fromUtf16(u"\U0001F515")},
        {QStringLiteral(":musical_score:"), QString::fromUtf16(u"\U0001F3BC")},
        {QStringLiteral(":musical_note:"), QString::fromUtf16(u"\U0001F3B5")},
        {QStringLiteral(":musical_notes:"), QString::fromUtf16(u"\U0001F3B6")},
        {QStringLiteral(":studio_microphone:"), QString::fromUtf16(u"\U0001F399")},
        {QStringLiteral(":level_slider:"), QString::fromUtf16(u"\U0001F39A")},
        {QStringLiteral(":control_knobs:"), QString::fromUtf16(u"\U0001F39B")},
        {QStringLiteral(":microphone:"), QString::fromUtf16(u"\U0001F3A4")},
        {QStringLiteral(":headphone:"), QString::fromUtf16(u"\U0001F3A7")},
        {QStringLiteral(":radio:"), QString::fromUtf16(u"\U0001F4FB")},
        {QStringLiteral(":saxophone:"), QString::fromUtf16(u"\U0001F3B7")},
        {QStringLiteral(":guitar:"), QString::fromUtf16(u"\U0001F3B8")},
        {QStringLiteral(":musical_keyboard:"), QString::fromUtf16(u"\U0001F3B9")},
        {QStringLiteral(":trumpet:"), QString::fromUtf16(u"\U0001F3BA")},
        {QStringLiteral(":violin:"), QString::fromUtf16(u"\U0001F3BB")},
        {QStringLiteral(":banjo:"), QString::fromUtf16(u"\U0001FA95")},
        {QStringLiteral(":drum:"), QString::fromUtf16(u"\U0001F941")},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeWeatherEmoji()
{
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst {
        {QStringLiteral(":new_moon:"), QString::fromUtf16(u"\U0001F311")},
        {QStringLiteral(":waxing_crescent_moon:"), QString::fromUtf16(u"\U0001F312")},
        {QStringLiteral(":first_quarter_moon:"), QString::fromUtf16(u"\U0001F313")},
        {QStringLiteral(":waxing_gibbous_moon:"), QString::fromUtf16(u"\U0001F314")},
        {QStringLiteral(":full_moon:"), QString::fromUtf16(u"\U0001F315")},
        {QStringLiteral(":waning_gibbous_moon:"), QString::fromUtf16(u"\U0001F316")},
        {QStringLiteral(":last_quarter_moon:"), QString::fromUtf16(u"\U0001F317")},
        {QStringLiteral(":waning_crescent_moon:"), QString::fromUtf16(u"\U0001F318")},
        {QStringLiteral(":crescent_moon:"), QString::fromUtf16(u"\U0001F319")},
        {QStringLiteral(":new_moon_face:"), QString::fromUtf16(u"\U0001F31A")},
        {QStringLiteral(":first_quarter_moon_face:"), QString::fromUtf16(u"\U0001F31B")},
        {QStringLiteral(":last_quarter_moon_face:"), QString::fromUtf16(u"\U0001F31C")},
        {QStringLiteral(":thermometer:"), QString::fromUtf16(u"\U0001F321")},
        {QStringLiteral(":sun:"), QString::fromUtf16(u"\U00002600")},
        {QStringLiteral(":full_moon_face:"), QString::fromUtf16(u"\U0001F31D")},
        {QStringLiteral(":sun_with_face:"), QString::fromUtf16(u"\U0001F31E")},
        {QStringLiteral(":ringed_planet:"), QString::fromUtf16(u"\U0001FA90")},
        {QStringLiteral(":star:"), QString::fromUtf16(u"\U00002B50")},
        {QStringLiteral(":glowing_star:"), QString::fromUtf16(u"\U0001F31F")},
        {QStringLiteral(":shooting_star:"), QString::fromUtf16(u"\U0001F320")},
        {QStringLiteral(":milky_way:"), QString::fromUtf16(u"\U0001F30C")},
        {QStringLiteral(":cloud:"), QString::fromUtf16(u"\U00002601")},
        {QStringLiteral(":sun_behind_cloud:"), QString::fromUtf16(u"\U000026C5")},
        {QStringLiteral(":cloud_with_lightning_and_rain:"), QString::fromUtf16(u"\U000026C8")},
        {QStringLiteral(":sun_behind_small_cloud:"), QString::fromUtf16(u"\U0001F324")},
        {QStringLiteral(":sun_behind_large_cloud:"), QString::fromUtf16(u"\U0001F325")},
        {QStringLiteral(":sun_behind_rain_cloud:"), QString::fromUtf16(u"\U0001F326")},
        {QStringLiteral(":cloud_with_rain:"), QString::fromUtf16(u"\U0001F327")},
        {QStringLiteral(":cloud_with_snow:"), QString::fromUtf16(u"\U0001F328")},
        {QStringLiteral(":cloud_with_lightning:"), QString::fromUtf16(u"\U0001F329")},
        {QStringLiteral(":tornado:"), QString::fromUtf16(u"\U0001F32A")},
        {QStringLiteral(":fog:"), QString::fromUtf16(u"\U0001F32B")},
        {QStringLiteral(":wind_face:"), QString::fromUtf16(u"\U0001F32C")},
        {QStringLiteral(":cyclone:"), QString::fromUtf16(u"\U0001F300")},
        {QStringLiteral(":rainbow:"), QString::fromUtf16(u"\U0001F308")},
        {QStringLiteral(":closed_umbrella:"), QString::fromUtf16(u"\U0001F302")},
        {QStringLiteral(":umbrella:"), QString::fromUtf16(u"\U00002602")},
        {QStringLiteral(":umbrella_with_rain_drops:"), QString::fromUtf16(u"\U00002614")},
        {QStringLiteral(":umbrella_on_ground:"), QString::fromUtf16(u"\U000026F1")},
        {QStringLiteral(":high_voltage:"), QString::fromUtf16(u"\U000026A1")},
        {QStringLiteral(":snowflake:"), QString::fromUtf16(u"\U00002744")},
        {QStringLiteral(":snowman:"), QString::fromUtf16(u"\U00002603")},
        {QStringLiteral(":snowman_without_snow:"), QString::fromUtf16(u"\U000026C4")},
        {QStringLiteral(":comet:"), QString::fromUtf16(u"\U00002604")},
        {QStringLiteral(":fire:"), QString::fromUtf16(u"\U0001F525")},
        {QStringLiteral(":droplet:"), QString::fromUtf16(u"\U0001F4A7")},
        {QStringLiteral(":water_wave:"), QString::fromUtf16(u"\U0001F30A")},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeTimeEmoji()
{
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst {
        {QStringLiteral(":hourglass_done:"), QString::fromUtf16(u"\U0000231B")},
        {QStringLiteral(":hourglass_not_done:"), QString::fromUtf16(u"\U000023F3")},
        {QStringLiteral(":watch:"), QString::fromUtf16(u"\U0000231A")},
        {QStringLiteral(":alarm_clock:"), QString::fromUtf16(u"\U000023F0")},
        {QStringLiteral(":stopwatch:"), QString::fromUtf16(u"\U000023F1")},
        {QStringLiteral(":timer_clock:"), QString::fromUtf16(u"\U000023F2")},
        {QStringLiteral(":mantelpiece_clock:"), QString::fromUtf16(u"\U0001F570")},
        {QStringLiteral(":twelve_o’clock:"), QString::fromUtf16(u"\U0001F55B")},
        {QStringLiteral(":twelve-thirty:"), QString::fromUtf16(u"\U0001F567")},
        {QStringLiteral(":one_o’clock:"), QString::fromUtf16(u"\U0001F550")},
        {QStringLiteral(":one-thirty:"), QString::fromUtf16(u"\U0001F55C")},
        {QStringLiteral(":two_o’clock:"), QString::fromUtf16(u"\U0001F551")},
        {QStringLiteral(":two-thirty:"), QString::fromUtf16(u"\U0001F55D")},
        {QStringLiteral(":three_o’clock:"), QString::fromUtf16(u"\U0001F552")},
        {QStringLiteral(":three-thirty:"), QString::fromUtf16(u"\U0001F55E")},
        {QStringLiteral(":four_o’clock:"), QString::fromUtf16(u"\U0001F553")},
        {QStringLiteral(":four-thirty:"), QString::fromUtf16(u"\U0001F55F")},
        {QStringLiteral(":five_o’clock:"), QString::fromUtf16(u"\U0001F554")},
        {QStringLiteral(":five-thirty:"), QString::fromUtf16(u"\U0001F560")},
        {QStringLiteral(":six_o’clock:"), QString::fromUtf16(u"\U0001F555")},
        {QStringLiteral(":six-thirty:"), QString::fromUtf16(u"\U0001F561")},
        {QStringLiteral(":seven_o’clock:"), QString::fromUtf16(u"\U0001F556")},
        {QStringLiteral(":seven-thirty:"), QString::fromUtf16(u"\U0001F562")},
        {QStringLiteral(":eight_o’clock:"), QString::fromUtf16(u"\U0001F557")},
        {QStringLiteral(":eight-thirty:"), QString::fromUtf16(u"\U0001F563")},
        {QStringLiteral(":nine_o’clock:"), QString::fromUtf16(u"\U0001F558")},
        {QStringLiteral(":nine-thirty:"), QString::fromUtf16(u"\U0001F564")},
        {QStringLiteral(":ten_o’clock:"), QString::fromUtf16(u"\U0001F559")},
        {QStringLiteral(":ten-thirty:"), QString::fromUtf16(u"\U0001F565")},
        {QStringLiteral(":eleven_o’clock:"), QString::fromUtf16(u"\U0001F55A")},
        {QStringLiteral(":eleven-thirty:"), QString::fromUtf16(u"\U0001F566")},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeGameEmoji()
{
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst {
        {QStringLiteral(":direct_hit:"), QString::fromUtf16(u"\U0001F3AF")},
        {QStringLiteral(":yo-yo:"), QString::fromUtf16(u"\U0001FA80")},
        {QStringLiteral(":kite:"), QString::fromUtf16(u"\U0001FA81")},
        {QStringLiteral(":pool_8_ball:"), QString::fromUtf16(u"\U0001F3B1")},
        {QStringLiteral(":crystal_ball:"), QString::fromUtf16(u"\U0001F52E")},
        {QStringLiteral(":nazar_amulet:"), QString::fromUtf16(u"\U0001F9FF")},
        {QStringLiteral(":video_game:"), QString::fromUtf16(u"\U0001F3AE")},
        {QStringLiteral(":joystick:"), QString::fromUtf16(u"\U0001F579")},
        {QStringLiteral(":slot_machine:"), QString::fromUtf16(u"\U0001F3B0")},
        {QStringLiteral(":game_die:"), QString::fromUtf16(u"\U0001F3B2")},
        {QStringLiteral(":puzzle_piece:"), QString::fromUtf16(u"\U0001F9E9")},
        {QStringLiteral(":teddy_bear:"), QString::fromUtf16(u"\U0001F9F8")},
        {QStringLiteral(":spade_suit:"), QString::fromUtf16(u"\U00002660")},
        {QStringLiteral(":heart_suit:"), QString::fromUtf16(u"\U00002665")},
        {QStringLiteral(":diamond_suit:"), QString::fromUtf16(u"\U00002666")},
        {QStringLiteral(":club_suit:"), QString::fromUtf16(u"\U00002663")},
        {QStringLiteral(":chess_pawn:"), QString::fromUtf16(u"\U0000265F")},
        {QStringLiteral(":joker:"), QString::fromUtf16(u"\U0001F0CF")},
        {QStringLiteral(":mahjong_red_dragon:"), QString::fromUtf16(u"\U0001F004")},
        {QStringLiteral(":flower_playing_cards:"), QString::fromUtf16(u"\U0001F3B4")},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeClothingEmoji()
{
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst {
        {QStringLiteral(":glasses:"), QString::fromUtf16(u"\U0001F453")},
        {QStringLiteral(":sunglasses:"), QString::fromUtf16(u"\U0001F576")},
        {QStringLiteral(":goggles:"), QString::fromUtf16(u"\U0001F97D")},
        {QStringLiteral(":lab_coat:"), QString::fromUtf16(u"\U0001F97C")},
        {QStringLiteral(":safety_vest:"), QString::fromUtf16(u"\U0001F9BA")},
        {QStringLiteral(":necktie:"), QString::fromUtf16(u"\U0001F454")},
        {QStringLiteral(":t-shirt:"), QString::fromUtf16(u"\U0001F455")},
        {QStringLiteral(":jeans:"), QString::fromUtf16(u"\U0001F456")},
        {QStringLiteral(":scarf:"), QString::fromUtf16(u"\U0001F9E3")},
        {QStringLiteral(":gloves:"), QString::fromUtf16(u"\U0001F9E4")},
        {QStringLiteral(":coat:"), QString::fromUtf16(u"\U0001F9E5")},
        {QStringLiteral(":socks:"), QString::fromUtf16(u"\U0001F9E6")},
        {QStringLiteral(":dress:"), QString::fromUtf16(u"\U0001F457")},
        {QStringLiteral(":kimono:"), QString::fromUtf16(u"\U0001F458")},
        {QStringLiteral(":sari:"), QString::fromUtf16(u"\U0001F97B")},
        {QStringLiteral(":one-piece_swimsuit:"), QString::fromUtf16(u"\U0001FA71")},
        {QStringLiteral(":briefs:"), QString::fromUtf16(u"\U0001FA72")},
        {QStringLiteral(":shorts:"), QString::fromUtf16(u"\U0001FA73")},
        {QStringLiteral(":bikini:"), QString::fromUtf16(u"\U0001F459")},
        {QStringLiteral(":woman’s_clothes:"), QString::fromUtf16(u"\U0001F45A")},
        {QStringLiteral(":purse:"), QString::fromUtf16(u"\U0001F45B")},
        {QStringLiteral(":handbag:"), QString::fromUtf16(u"\U0001F45C")},
        {QStringLiteral(":clutch_bag:"), QString::fromUtf16(u"\U0001F45D")},
        {QStringLiteral(":shopping_bags:"), QString::fromUtf16(u"\U0001F6CD")},
        {QStringLiteral(":backpack:"), QString::fromUtf16(u"\U0001F392")},
        {QStringLiteral(":man’s_shoe:"), QString::fromUtf16(u"\U0001F45E")},
        {QStringLiteral(":running_shoe:"), QString::fromUtf16(u"\U0001F45F")},
        {QStringLiteral(":hiking_boot:"), QString::fromUtf16(u"\U0001F97E")},
        {QStringLiteral(":flat_shoe:"), QString::fromUtf16(u"\U0001F97F")},
        {QStringLiteral(":high-heeled_shoe:"), QString::fromUtf16(u"\U0001F460")},
        {QStringLiteral(":woman’s_sandal:"), QString::fromUtf16(u"\U0001F461")},
        {QStringLiteral(":ballet_shoes:"), QString::fromUtf16(u"\U0001FA70")},
        {QStringLiteral(":woman’s_boot:"), QString::fromUtf16(u"\U0001F462")},
        {QStringLiteral(":crown:"), QString::fromUtf16(u"\U0001F451")},
        {QStringLiteral(":woman’s_hat:"), QString::fromUtf16(u"\U0001F452")},
        {QStringLiteral(":top_hat:"), QString::fromUtf16(u"\U0001F3A9")},
        {QStringLiteral(":graduation_cap:"), QString::fromUtf16(u"\U0001F393")},
        {QStringLiteral(":billed_cap:"), QString::fromUtf16(u"\U0001F9E2")},
        {QStringLiteral(":rescue_worker’s_helmet:"), QString::fromUtf16(u"\U000026D1")},
        {QStringLiteral(":prayer_beads:"), QString::fromUtf16(u"\U0001F4FF")},
        {QStringLiteral(":lipstick:"), QString::fromUtf16(u"\U0001F484")},
        {QStringLiteral(":ring:"), QString::fromUtf16(u"\U0001F48D")},
        {QStringLiteral(":gem_stone:"), QString::fromUtf16(u"\U0001F48E")},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeEventEmoji()
{
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst {
        {QStringLiteral(":jack-o-lantern:"), QString::fromUtf16(u"\U0001F383")},
        {QStringLiteral(":Christmas_tree:"), QString::fromUtf16(u"\U0001F384")},
        {QStringLiteral(":fireworks:"), QString::fromUtf16(u"\U0001F386")},
        {QStringLiteral(":sparkler:"), QString::fromUtf16(u"\U0001F387")},
        {QStringLiteral(":firecracker:"), QString::fromUtf16(u"\U0001F9E8")},
        {QStringLiteral(":sparkles:"), QString::fromUtf16(u"\U00002728")},
        {QStringLiteral(":balloon:"), QString::fromUtf16(u"\U0001F388")},
        {QStringLiteral(":party_popper:"), QString::fromUtf16(u"\U0001F389")},
        {QStringLiteral(":confetti_ball:"), QString::fromUtf16(u"\U0001F38A")},
        {QStringLiteral(":tanabata_tree:"), QString::fromUtf16(u"\U0001F38B")},
        {QStringLiteral(":pine_decoration:"), QString::fromUtf16(u"\U0001F38D")},
        {QStringLiteral(":Japanese_dolls:"), QString::fromUtf16(u"\U0001F38E")},
        {QStringLiteral(":carp_streamer:"), QString::fromUtf16(u"\U0001F38F")},
        {QStringLiteral(":wind_chime:"), QString::fromUtf16(u"\U0001F390")},
        {QStringLiteral(":moon_viewing_ceremony:"), QString::fromUtf16(u"\U0001F391")},
        {QStringLiteral(":red_envelope:"), QString::fromUtf16(u"\U0001F9E7")},
        {QStringLiteral(":ribbon:"), QString::fromUtf16(u"\U0001F380")},
        {QStringLiteral(":wrapped_gift:"), QString::fromUtf16(u"\U0001F381")},
        {QStringLiteral(":reminder_ribbon:"), QString::fromUtf16(u"\U0001F397")},
        {QStringLiteral(":admission_tickets:"), QString::fromUtf16(u"\U0001F39F")},
        {QStringLiteral(":ticket:"), QString::fromUtf16(u"\U0001F3AB")},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeFoodEmoji()
{
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst {
        {QStringLiteral(":grapes:"), QString::fromUtf16(u"\U0001F347")},
        {QStringLiteral(":melon:"), QString::fromUtf16(u"\U0001F348")},
        {QStringLiteral(":watermelon:"), QString::fromUtf16(u"\U0001F349")},
        {QStringLiteral(":tangerine:"), QString::fromUtf16(u"\U0001F34A")},
        {QStringLiteral(":lemon:"), QString::fromUtf16(u"\U0001F34B")},
        {QStringLiteral(":banana:"), QString::fromUtf16(u"\U0001F34C")},
        {QStringLiteral(":pineapple:"), QString::fromUtf16(u"\U0001F34D")},
        {QStringLiteral(":mango:"), QString::fromUtf16(u"\U0001F96D")},
        {QStringLiteral(":red_apple:"), QString::fromUtf16(u"\U0001F34E")},
        {QStringLiteral(":green_apple:"), QString::fromUtf16(u"\U0001F34F")},
        {QStringLiteral(":pear:"), QString::fromUtf16(u"\U0001F350")},
        {QStringLiteral(":peach:"), QString::fromUtf16(u"\U0001F351")},
        {QStringLiteral(":cherries:"), QString::fromUtf16(u"\U0001F352")},
        {QStringLiteral(":strawberry:"), QString::fromUtf16(u"\U0001F353")},
        {QStringLiteral(":kiwi_fruit:"), QString::fromUtf16(u"\U0001F95D")},
        {QStringLiteral(":tomato:"), QString::fromUtf16(u"\U0001F345")},
        {QStringLiteral(":coconut:"), QString::fromUtf16(u"\U0001F965")},
        {QStringLiteral(":avocado:"), QString::fromUtf16(u"\U0001F951")},
        {QStringLiteral(":eggplant:"), QString::fromUtf16(u"\U0001F346")},
        {QStringLiteral(":potato:"), QString::fromUtf16(u"\U0001F954")},
        {QStringLiteral(":carrot:"), QString::fromUtf16(u"\U0001F955")},
        {QStringLiteral(":ear_of_corn:"), QString::fromUtf16(u"\U0001F33D")},
        {QStringLiteral(":hot_pepper:"), QString::fromUtf16(u"\U0001F336")},
        {QStringLiteral(":cucumber:"), QString::fromUtf16(u"\U0001F952")},
        {QStringLiteral(":leafy_green:"), QString::fromUtf16(u"\U0001F96C")},
        {QStringLiteral(":broccoli:"), QString::fromUtf16(u"\U0001F966")},
        {QStringLiteral(":garlic:"), QString::fromUtf16(u"\U0001F9C4")},
        {QStringLiteral(":onion:"), QString::fromUtf16(u"\U0001F9C5")},
        {QStringLiteral(":mushroom:"), QString::fromUtf16(u"\U0001F344")},
        {QStringLiteral(":peanuts:"), QString::fromUtf16(u"\U0001F95C")},
        {QStringLiteral(":chestnut:"), QString::fromUtf16(u"\U0001F330")},
        {QStringLiteral(":bread:"), QString::fromUtf16(u"\U0001F35E")},
        {QStringLiteral(":croissant:"), QString::fromUtf16(u"\U0001F950")},
        {QStringLiteral(":baguette_bread:"), QString::fromUtf16(u"\U0001F956")},
        {QStringLiteral(":pretzel:"), QString::fromUtf16(u"\U0001F968")},
        {QStringLiteral(":bagel:"), QString::fromUtf16(u"\U0001F96F")},
        {QStringLiteral(":pancakes:"), QString::fromUtf16(u"\U0001F95E")},
        {QStringLiteral(":waffle:"), QString::fromUtf16(u"\U0001F9C7")},
        {QStringLiteral(":cheese_wedge:"), QString::fromUtf16(u"\U0001F9C0")},
        {QStringLiteral(":meat_on_bone:"), QString::fromUtf16(u"\U0001F356")},
        {QStringLiteral(":poultry_leg:"), QString::fromUtf16(u"\U0001F357")},
        {QStringLiteral(":cut_of_meat:"), QString::fromUtf16(u"\U0001F969")},
        {QStringLiteral(":bacon:"), QString::fromUtf16(u"\U0001F953")},
        {QStringLiteral(":hamburger:"), QString::fromUtf16(u"\U0001F354")},
        {QStringLiteral(":french_fries:"), QString::fromUtf16(u"\U0001F35F")},
        {QStringLiteral(":pizza:"), QString::fromUtf16(u"\U0001F355")},
        {QStringLiteral(":hot_dog:"), QString::fromUtf16(u"\U0001F32D")},
        {QStringLiteral(":sandwich:"), QString::fromUtf16(u"\U0001F96A")},
        {QStringLiteral(":taco:"), QString::fromUtf16(u"\U0001F32E")},
        {QStringLiteral(":burrito:"), QString::fromUtf16(u"\U0001F32F")},
        {QStringLiteral(":stuffed_flatbread:"), QString::fromUtf16(u"\U0001F959")},
        {QStringLiteral(":falafel:"), QString::fromUtf16(u"\U0001F9C6")},
        {QStringLiteral(":egg:"), QString::fromUtf16(u"\U0001F95A")},
        {QStringLiteral(":cooking:"), QString::fromUtf16(u"\U0001F373")},
        {QStringLiteral(":shallow_pan_of_food:"), QString::fromUtf16(u"\U0001F958")},
        {QStringLiteral(":pot_of_food:"), QString::fromUtf16(u"\U0001F372")},
        {QStringLiteral(":bowl_with_spoon:"), QString::fromUtf16(u"\U0001F963")},
        {QStringLiteral(":green_salad:"), QString::fromUtf16(u"\U0001F957")},
        {QStringLiteral(":popcorn:"), QString::fromUtf16(u"\U0001F37F")},
        {QStringLiteral(":butter:"), QString::fromUtf16(u"\U0001F9C8")},
        {QStringLiteral(":salt:"), QString::fromUtf16(u"\U0001F9C2")},
        {QStringLiteral(":canned_food:"), QString::fromUtf16(u"\U0001F96B")},
        {QStringLiteral(":bento_box:"), QString::fromUtf16(u"\U0001F371")},
        {QStringLiteral(":rice_cracker:"), QString::fromUtf16(u"\U0001F358")},
        {QStringLiteral(":rice_ball:"), QString::fromUtf16(u"\U0001F359")},
        {QStringLiteral(":cooked_rice:"), QString::fromUtf16(u"\U0001F35A")},
        {QStringLiteral(":curry_rice:"), QString::fromUtf16(u"\U0001F35B")},
        {QStringLiteral(":steaming_bowl:"), QString::fromUtf16(u"\U0001F35C")},
        {QStringLiteral(":spaghetti:"), QString::fromUtf16(u"\U0001F35D")},
        {QStringLiteral(":roasted_sweet_potato:"), QString::fromUtf16(u"\U0001F360")},
        {QStringLiteral(":oden:"), QString::fromUtf16(u"\U0001F362")},
        {QStringLiteral(":sushi:"), QString::fromUtf16(u"\U0001F363")},
        {QStringLiteral(":fried_shrimp:"), QString::fromUtf16(u"\U0001F364")},
        {QStringLiteral(":fish_cake_with_swirl:"), QString::fromUtf16(u"\U0001F365")},
        {QStringLiteral(":moon_cake:"), QString::fromUtf16(u"\U0001F96E")},
        {QStringLiteral(":dango:"), QString::fromUtf16(u"\U0001F361")},
        {QStringLiteral(":dumpling:"), QString::fromUtf16(u"\U0001F95F")},
        {QStringLiteral(":fortune_cookie:"), QString::fromUtf16(u"\U0001F960")},
        {QStringLiteral(":takeout_box:"), QString::fromUtf16(u"\U0001F961")},
        {QStringLiteral(":crab:"), QString::fromUtf16(u"\U0001F980")},
        {QStringLiteral(":lobster:"), QString::fromUtf16(u"\U0001F99E")},
        {QStringLiteral(":shrimp:"), QString::fromUtf16(u"\U0001F990")},
        {QStringLiteral(":squid:"), QString::fromUtf16(u"\U0001F991")},
        {QStringLiteral(":oyster:"), QString::fromUtf16(u"\U0001F9AA")},
        {QStringLiteral(":soft_ice_cream:"), QString::fromUtf16(u"\U0001F366")},
        {QStringLiteral(":shaved_ice:"), QString::fromUtf16(u"\U0001F367")},
        {QStringLiteral(":ice_cream:"), QString::fromUtf16(u"\U0001F368")},
        {QStringLiteral(":doughnut:"), QString::fromUtf16(u"\U0001F369")},
        {QStringLiteral(":cookie:"), QString::fromUtf16(u"\U0001F36A")},
        {QStringLiteral(":birthday_cake:"), QString::fromUtf16(u"\U0001F382")},
        {QStringLiteral(":shortcake:"), QString::fromUtf16(u"\U0001F370")},
        {QStringLiteral(":cupcake:"), QString::fromUtf16(u"\U0001F9C1")},
        {QStringLiteral(":pie:"), QString::fromUtf16(u"\U0001F967")},
        {QStringLiteral(":chocolate_bar:"), QString::fromUtf16(u"\U0001F36B")},
        {QStringLiteral(":candy:"), QString::fromUtf16(u"\U0001F36C")},
        {QStringLiteral(":lollipop:"), QString::fromUtf16(u"\U0001F36D")},
        {QStringLiteral(":custard:"), QString::fromUtf16(u"\U0001F36E")},
        {QStringLiteral(":honey_pot:"), QString::fromUtf16(u"\U0001F36F")},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeTransportEmoji()
{
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst {
        {QStringLiteral(":locomotive:"), QString::fromUtf16(u"\U0001F682")},
        {QStringLiteral(":railway_car:"), QString::fromUtf16(u"\U0001F683")},
        {QStringLiteral(":high-speed_train:"), QString::fromUtf16(u"\U0001F684")},
        {QStringLiteral(":bullet_train:"), QString::fromUtf16(u"\U0001F685")},
        {QStringLiteral(":train:"), QString::fromUtf16(u"\U0001F686")},
        {QStringLiteral(":metro:"), QString::fromUtf16(u"\U0001F687")},
        {QStringLiteral(":light_rail:"), QString::fromUtf16(u"\U0001F688")},
        {QStringLiteral(":station:"), QString::fromUtf16(u"\U0001F689")},
        {QStringLiteral(":tram:"), QString::fromUtf16(u"\U0001F68A")},
        {QStringLiteral(":monorail:"), QString::fromUtf16(u"\U0001F69D")},
        {QStringLiteral(":mountain_railway:"), QString::fromUtf16(u"\U0001F69E")},
        {QStringLiteral(":tram_car:"), QString::fromUtf16(u"\U0001F68B")},
        {QStringLiteral(":bus:"), QString::fromUtf16(u"\U0001F68C")},
        {QStringLiteral(":oncoming_bus:"), QString::fromUtf16(u"\U0001F68D")},
        {QStringLiteral(":trolleybus:"), QString::fromUtf16(u"\U0001F68E")},
        {QStringLiteral(":minibus:"), QString::fromUtf16(u"\U0001F690")},
        {QStringLiteral(":ambulance:"), QString::fromUtf16(u"\U0001F691")},
        {QStringLiteral(":fire_engine:"), QString::fromUtf16(u"\U0001F692")},
        {QStringLiteral(":police_car:"), QString::fromUtf16(u"\U0001F693")},
        {QStringLiteral(":oncoming_police_car:"), QString::fromUtf16(u"\U0001F694")},
        {QStringLiteral(":taxi:"), QString::fromUtf16(u"\U0001F695")},
        {QStringLiteral(":oncoming_taxi:"), QString::fromUtf16(u"\U0001F696")},
        {QStringLiteral(":automobile:"), QString::fromUtf16(u"\U0001F697")},
        {QStringLiteral(":oncoming_automobile:"), QString::fromUtf16(u"\U0001F698")},
        {QStringLiteral(":sport_utility_vehicle:"), QString::fromUtf16(u"\U0001F699")},
        {QStringLiteral(":delivery_truck:"), QString::fromUtf16(u"\U0001F69A")},
        {QStringLiteral(":articulated_lorry:"), QString::fromUtf16(u"\U0001F69B")},
        {QStringLiteral(":tractor:"), QString::fromUtf16(u"\U0001F69C")},
        {QStringLiteral(":racing_car:"), QString::fromUtf16(u"\U0001F3CE")},
        {QStringLiteral(":motorcycle:"), QString::fromUtf16(u"\U0001F3CD")},
        {QStringLiteral(":motor_scooter:"), QString::fromUtf16(u"\U0001F6F5")},
        {QStringLiteral(":manual_wheelchair:"), QString::fromUtf16(u"\U0001F9BD")},
        {QStringLiteral(":motorized_wheelchair:"), QString::fromUtf16(u"\U0001F9BC")},
        {QStringLiteral(":auto_rickshaw:"), QString::fromUtf16(u"\U0001F6FA")},
        {QStringLiteral(":bicycle:"), QString::fromUtf16(u"\U0001F6B2")},
        {QStringLiteral(":kick_scooter:"), QString::fromUtf16(u"\U0001F6F4")},
        {QStringLiteral(":skateboard:"), QString::fromUtf16(u"\U0001F6F9")},
        {QStringLiteral(":bus_stop:"), QString::fromUtf16(u"\U0001F68F")},
        {QStringLiteral(":motorway:"), QString::fromUtf16(u"\U0001F6E3")},
        {QStringLiteral(":railway_track:"), QString::fromUtf16(u"\U0001F6E4")},
        {QStringLiteral(":oil_drum:"), QString::fromUtf16(u"\U0001F6E2")},
        {QStringLiteral(":fuel_pump:"), QString::fromUtf16(u"\U000026FD")},
        {QStringLiteral(":police_car_light:"), QString::fromUtf16(u"\U0001F6A8")},
        {QStringLiteral(":horizontal_traffic_light:"), QString::fromUtf16(u"\U0001F6A5")},
        {QStringLiteral(":vertical_traffic_light:"), QString::fromUtf16(u"\U0001F6A6")},
        {QStringLiteral(":stop_sign:"), QString::fromUtf16(u"\U0001F6D1")},
        {QStringLiteral(":construction:"), QString::fromUtf16(u"\U0001F6A7")},
        {QStringLiteral(":anchor:"), QString::fromUtf16(u"\U00002693")},
        {QStringLiteral(":sailboat:"), QString::fromUtf16(u"\U000026F5")},
        {QStringLiteral(":canoe:"), QString::fromUtf16(u"\U0001F6F6")},
        {QStringLiteral(":speedboat:"), QString::fromUtf16(u"\U0001F6A4")},
        {QStringLiteral(":passenger_ship:"), QString::fromUtf16(u"\U0001F6F3")},
        {QStringLiteral(":ferry:"), QString::fromUtf16(u"\U000026F4")},
        {QStringLiteral(":motor_boat:"), QString::fromUtf16(u"\U0001F6E5")},
        {QStringLiteral(":ship:"), QString::fromUtf16(u"\U0001F6A2")},
        {QStringLiteral(":airplane:"), QString::fromUtf16(u"\U00002708")},
        {QStringLiteral(":small_airplane:"), QString::fromUtf16(u"\U0001F6E9")},
        {QStringLiteral(":airplane_departure:"), QString::fromUtf16(u"\U0001F6EB")},
        {QStringLiteral(":airplane_arrival:"), QString::fromUtf16(u"\U0001F6EC")},
        {QStringLiteral(":parachute:"), QString::fromUtf16(u"\U0001FA82")},
        {QStringLiteral(":seat:"), QString::fromUtf16(u"\U0001F4BA")},
        {QStringLiteral(":helicopter:"), QString::fromUtf16(u"\U0001F681")},
        {QStringLiteral(":suspension_railway:"), QString::fromUtf16(u"\U0001F69F")},
        {QStringLiteral(":mountain_cableway:"), QString::fromUtf16(u"\U0001F6A0")},
        {QStringLiteral(":aerial_tramway:"), QString::fromUtf16(u"\U0001F6A1")},
        {QStringLiteral(":satellite:"), QString::fromUtf16(u"\U0001F6F0")},
        {QStringLiteral(":rocket:"), QString::fromUtf16(u"\U0001F680")},
        {QStringLiteral(":flying_saucer:"), QString::fromUtf16(u"\U0001F6F8")},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodePersonEmoji()
{
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst {
        {QStringLiteral(":baby:"), QString::fromUtf16(u"\U0001F476")},
        {QStringLiteral(":child:"), QString::fromUtf16(u"\U0001F9D2")},
        {QStringLiteral(":boy:"), QString::fromUtf16(u"\U0001F466")},
        {QStringLiteral(":girl:"), QString::fromUtf16(u"\U0001F467")},
        {QStringLiteral(":person:"), QString::fromUtf16(u"\U0001F9D1")},
        {QStringLiteral(":person_blond_hair:"), QString::fromUtf16(u"\U0001F471")},
        {QStringLiteral(":man:"), QString::fromUtf16(u"\U0001F468")},
        {QStringLiteral(":man_beard:"), QString::fromUtf16(u"\U0001F9D4")},
        {QStringLiteral(":man_blond_hair:"), QString::fromUtf16(u"\U0001F471\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":man_red_hair:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F9B0")},
        {QStringLiteral(":man_curly_hair:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F9B1")},
        {QStringLiteral(":man_white_hair:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F9B3")},
        {QStringLiteral(":man_bald:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F9B2")},
        {QStringLiteral(":woman:"), QString::fromUtf16(u"\U0001F469")},
        {QStringLiteral(":woman_blond_hair:"), QString::fromUtf16(u"\U0001F471\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":woman_red_hair:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F9B0")},
        {QStringLiteral(":woman_curly_hair:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F9B1")},
        {QStringLiteral(":woman_white_hair:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F9B3")},
        {QStringLiteral(":woman_bald:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F9B2")},
        {QStringLiteral(":older_person:"), QString::fromUtf16(u"\U0001F9D3")},
        {QStringLiteral(":old_man:"), QString::fromUtf16(u"\U0001F474")},
        {QStringLiteral(":old_woman:"), QString::fromUtf16(u"\U0001F475")},
        {QStringLiteral(":person_frowning:"), QString::fromUtf16(u"\U0001F64D")},
        {QStringLiteral(":man_frowning:"), QString::fromUtf16(u"\U0001F64D\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_frowning:"), QString::fromUtf16(u"\U0001F64D\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":person_pouting:"), QString::fromUtf16(u"\U0001F64E")},
        {QStringLiteral(":man_pouting:"), QString::fromUtf16(u"\U0001F64E\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_pouting:"), QString::fromUtf16(u"\U0001F64E\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":person_gesturing_NO:"), QString::fromUtf16(u"\U0001F645")},
        {QStringLiteral(":man_gesturing_NO:"), QString::fromUtf16(u"\U0001F645\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_gesturing_NO:"), QString::fromUtf16(u"\U0001F645\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":person_gesturing_OK:"), QString::fromUtf16(u"\U0001F646")},
        {QStringLiteral(":man_gesturing_OK:"), QString::fromUtf16(u"\U0001F646\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_gesturing_OK:"), QString::fromUtf16(u"\U0001F646\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":person_tipping_hand:"), QString::fromUtf16(u"\U0001F481")},
        {QStringLiteral(":man_tipping_hand:"), QString::fromUtf16(u"\U0001F481\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_tipping_hand:"), QString::fromUtf16(u"\U0001F481\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":person_raising_hand:"), QString::fromUtf16(u"\U0001F64B")},
        {QStringLiteral(":man_raising_hand:"), QString::fromUtf16(u"\U0001F64B\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_raising_hand:"), QString::fromUtf16(u"\U0001F64B\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":deaf_person:"), QString::fromUtf16(u"\U0001F9CF")},
        {QStringLiteral(":deaf_man:"), QString::fromUtf16(u"\U0001F9CF\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":deaf_woman:"), QString::fromUtf16(u"\U0001F9CF\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":person_bowing:"), QString::fromUtf16(u"\U0001F647")},
        {QStringLiteral(":man_bowing:"), QString::fromUtf16(u"\U0001F647\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_bowing:"), QString::fromUtf16(u"\U0001F647\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":person_facepalming:"), QString::fromUtf16(u"\U0001F926")},
        {QStringLiteral(":man_facepalming:"), QString::fromUtf16(u"\U0001F926\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_facepalming:"), QString::fromUtf16(u"\U0001F926\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":person_shrugging:"), QString::fromUtf16(u"\U0001F937")},
        {QStringLiteral(":man_shrugging:"), QString::fromUtf16(u"\U0001F937\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_shrugging:"), QString::fromUtf16(u"\U0001F937\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":man_health_worker:"), QString::fromUtf16(u"\U0001F468\U0000200D\U00002695\U0000FE0F")},
        {QStringLiteral(":woman_health_worker:"), QString::fromUtf16(u"\U0001F469\U0000200D\U00002695\U0000FE0F")},
        {QStringLiteral(":man_student:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F393")},
        {QStringLiteral(":woman_student:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F393")},
        {QStringLiteral(":man_teacher:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F3EB")},
        {QStringLiteral(":woman_teacher:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F3EB")},
        {QStringLiteral(":man_judge:"), QString::fromUtf16(u"\U0001F468\U0000200D\U00002696\U0000FE0F")},
        {QStringLiteral(":woman_judge:"), QString::fromUtf16(u"\U0001F469\U0000200D\U00002696\U0000FE0F")},
        {QStringLiteral(":man_farmer:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F33E")},
        {QStringLiteral(":woman_farmer:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F33E")},
        {QStringLiteral(":man_cook:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F373")},
        {QStringLiteral(":woman_cook:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F373")},
        {QStringLiteral(":man_mechanic:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F527")},
        {QStringLiteral(":woman_mechanic:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F527")},
        {QStringLiteral(":man_factory_worker:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F3ED")},
        {QStringLiteral(":woman_factory_worker:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F3ED")},
        {QStringLiteral(":man_office_worker:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F4BC")},
        {QStringLiteral(":woman_office_worker:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F4BC")},
        {QStringLiteral(":man_scientist:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F52C")},
        {QStringLiteral(":woman_scientist:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F52C")},
        {QStringLiteral(":man_technologist:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F4BB")},
        {QStringLiteral(":woman_technologist:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F4BB")},
        {QStringLiteral(":man_singer:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F3A4")},
        {QStringLiteral(":woman_singer:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F3A4")},
        {QStringLiteral(":man_artist:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F3A8")},
        {QStringLiteral(":woman_artist:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F3A8")},
        {QStringLiteral(":man_pilot:"), QString::fromUtf16(u"\U0001F468\U0000200D\U00002708\U0000FE0F")},
        {QStringLiteral(":woman_pilot:"), QString::fromUtf16(u"\U0001F469\U0000200D\U00002708\U0000FE0F")},
        {QStringLiteral(":man_astronaut:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F680")},
        {QStringLiteral(":woman_astronaut:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F680")},
        {QStringLiteral(":man_firefighter:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F692")},
        {QStringLiteral(":woman_firefighter:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F692")},
        {QStringLiteral(":police_officer:"), QString::fromUtf16(u"\U0001F46E")},
        {QStringLiteral(":man_police_officer:"), QString::fromUtf16(u"\U0001F46E\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_police_officer:"), QString::fromUtf16(u"\U0001F46E\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":detective:"), QString::fromUtf16(u"\U0001F575")},
        {QStringLiteral(":man_detective:"), QString::fromUtf16(u"\U0001F575\U0000FE0F\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_detective:"), QString::fromUtf16(u"\U0001F575\U0000FE0F\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":guard:"), QString::fromUtf16(u"\U0001F482")},
        {QStringLiteral(":man_guard:"), QString::fromUtf16(u"\U0001F482\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_guard:"), QString::fromUtf16(u"\U0001F482\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":construction_worker:"), QString::fromUtf16(u"\U0001F477")},
        {QStringLiteral(":man_construction_worker:"), QString::fromUtf16(u"\U0001F477\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_construction_worker:"), QString::fromUtf16(u"\U0001F477\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":prince:"), QString::fromUtf16(u"\U0001F934")},
        {QStringLiteral(":princess:"), QString::fromUtf16(u"\U0001F478")},
        {QStringLiteral(":person_wearing_turban:"), QString::fromUtf16(u"\U0001F473")},
        {QStringLiteral(":man_wearing_turban:"), QString::fromUtf16(u"\U0001F473\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_wearing_turban:"), QString::fromUtf16(u"\U0001F473\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":man_with_Chinese_cap:"), QString::fromUtf16(u"\U0001F472")},
        {QStringLiteral(":woman_with_headscarf:"), QString::fromUtf16(u"\U0001F9D5")},
        {QStringLiteral(":man_in_tuxedo:"), QString::fromUtf16(u"\U0001F935")},
        {QStringLiteral(":bride_with_veil:"), QString::fromUtf16(u"\U0001F470")},
        {QStringLiteral(":pregnant_woman:"), QString::fromUtf16(u"\U0001F930")},
        {QStringLiteral(":breast-feeding:"), QString::fromUtf16(u"\U0001F931")},
        {QStringLiteral(":baby_angel:"), QString::fromUtf16(u"\U0001F47C")},
        {QStringLiteral(":Santa_Claus:"), QString::fromUtf16(u"\U0001F385")},
        {QStringLiteral(":Mrs._Claus:"), QString::fromUtf16(u"\U0001F936")},
        {QStringLiteral(":superhero:"), QString::fromUtf16(u"\U0001F9B8")},
        {QStringLiteral(":man_superhero:"), QString::fromUtf16(u"\U0001F9B8\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_superhero:"), QString::fromUtf16(u"\U0001F9B8\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":supervillain:"), QString::fromUtf16(u"\U0001F9B9")},
        {QStringLiteral(":man_supervillain:"), QString::fromUtf16(u"\U0001F9B9\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_supervillain:"), QString::fromUtf16(u"\U0001F9B9\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":mage:"), QString::fromUtf16(u"\U0001F9D9")},
        {QStringLiteral(":man_mage:"), QString::fromUtf16(u"\U0001F9D9\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_mage:"), QString::fromUtf16(u"\U0001F9D9\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":fairy:"), QString::fromUtf16(u"\U0001F9DA")},
        {QStringLiteral(":man_fairy:"), QString::fromUtf16(u"\U0001F9DA\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_fairy:"), QString::fromUtf16(u"\U0001F9DA\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":vampire:"), QString::fromUtf16(u"\U0001F9DB")},
        {QStringLiteral(":man_vampire:"), QString::fromUtf16(u"\U0001F9DB\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_vampire:"), QString::fromUtf16(u"\U0001F9DB\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":merperson:"), QString::fromUtf16(u"\U0001F9DC")},
        {QStringLiteral(":merman:"), QString::fromUtf16(u"\U0001F9DC\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":mermaid:"), QString::fromUtf16(u"\U0001F9DC\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":elf:"), QString::fromUtf16(u"\U0001F9DD")},
        {QStringLiteral(":man_elf:"), QString::fromUtf16(u"\U0001F9DD\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_elf:"), QString::fromUtf16(u"\U0001F9DD\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":genie:"), QString::fromUtf16(u"\U0001F9DE")},
        {QStringLiteral(":man_genie:"), QString::fromUtf16(u"\U0001F9DE\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_genie:"), QString::fromUtf16(u"\U0001F9DE\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":zombie:"), QString::fromUtf16(u"\U0001F9DF")},
        {QStringLiteral(":man_zombie:"), QString::fromUtf16(u"\U0001F9DF\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_zombie:"), QString::fromUtf16(u"\U0001F9DF\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":person_getting_massage:"), QString::fromUtf16(u"\U0001F486")},
        {QStringLiteral(":man_getting_massage:"), QString::fromUtf16(u"\U0001F486\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_getting_massage:"), QString::fromUtf16(u"\U0001F486\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":person_getting_haircut:"), QString::fromUtf16(u"\U0001F487")},
        {QStringLiteral(":man_getting_haircut:"), QString::fromUtf16(u"\U0001F487\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_getting_haircut:"), QString::fromUtf16(u"\U0001F487\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":person_walking:"), QString::fromUtf16(u"\U0001F6B6")},
        {QStringLiteral(":man_walking:"), QString::fromUtf16(u"\U0001F6B6\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_walking:"), QString::fromUtf16(u"\U0001F6B6\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":person_standing:"), QString::fromUtf16(u"\U0001F9CD")},
        {QStringLiteral(":man_standing:"), QString::fromUtf16(u"\U0001F9CD\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_standing:"), QString::fromUtf16(u"\U0001F9CD\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":person_kneeling:"), QString::fromUtf16(u"\U0001F9CE")},
        {QStringLiteral(":man_kneeling:"), QString::fromUtf16(u"\U0001F9CE\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_kneeling:"), QString::fromUtf16(u"\U0001F9CE\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":man_with_probing_cane:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F9AF")},
        {QStringLiteral(":woman_with_probing_cane:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F9AF")},
        {QStringLiteral(":man_in_motorized_wheelchair:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F9BC")},
        {QStringLiteral(":woman_in_motorized_wheelchair:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F9BC")},
        {QStringLiteral(":man_in_manual_wheelchair:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F9BD")},
        {QStringLiteral(":woman_in_manual_wheelchair:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F9BD")},
        {QStringLiteral(":person_running:"), QString::fromUtf16(u"\U0001F3C3")},
        {QStringLiteral(":man_running:"), QString::fromUtf16(u"\U0001F3C3\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_running:"), QString::fromUtf16(u"\U0001F3C3\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":woman_dancing:"), QString::fromUtf16(u"\U0001F483")},
        {QStringLiteral(":man_dancing:"), QString::fromUtf16(u"\U0001F57A")},
        {QStringLiteral(":man_in_suit_levitating:"), QString::fromUtf16(u"\U0001F574")},
        {QStringLiteral(":people_with_bunny_ears:"), QString::fromUtf16(u"\U0001F46F")},
        {QStringLiteral(":men_with_bunny_ears:"), QString::fromUtf16(u"\U0001F46F\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":women_with_bunny_ears:"), QString::fromUtf16(u"\U0001F46F\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":person_in_steamy_room:"), QString::fromUtf16(u"\U0001F9D6")},
        {QStringLiteral(":man_in_steamy_room:"), QString::fromUtf16(u"\U0001F9D6\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_in_steamy_room:"), QString::fromUtf16(u"\U0001F9D6\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":person_climbing:"), QString::fromUtf16(u"\U0001F9D7")},
        {QStringLiteral(":man_climbing:"), QString::fromUtf16(u"\U0001F9D7\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_climbing:"), QString::fromUtf16(u"\U0001F9D7\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":person_fencing:"), QString::fromUtf16(u"\U0001F93A")},
        {QStringLiteral(":horse_racing:"), QString::fromUtf16(u"\U0001F3C7")},
        {QStringLiteral(":skier:"), QString::fromUtf16(u"\U000026F7")},
        {QStringLiteral(":snowboarder:"), QString::fromUtf16(u"\U0001F3C2")},
        {QStringLiteral(":person_golfing:"), QString::fromUtf16(u"\U0001F3CC")},
        {QStringLiteral(":man_golfing:"), QString::fromUtf16(u"\U0001F3CC\U0000FE0F\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_golfing:"), QString::fromUtf16(u"\U0001F3CC\U0000FE0F\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":person_surfing:"), QString::fromUtf16(u"\U0001F3C4")},
        {QStringLiteral(":man_surfing:"), QString::fromUtf16(u"\U0001F3C4\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_surfing:"), QString::fromUtf16(u"\U0001F3C4\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":person_rowing_boat:"), QString::fromUtf16(u"\U0001F6A3")},
        {QStringLiteral(":man_rowing_boat:"), QString::fromUtf16(u"\U0001F6A3\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_rowing_boat:"), QString::fromUtf16(u"\U0001F6A3\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":person_swimming:"), QString::fromUtf16(u"\U0001F3CA")},
        {QStringLiteral(":man_swimming:"), QString::fromUtf16(u"\U0001F3CA\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_swimming:"), QString::fromUtf16(u"\U0001F3CA\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":person_bouncing_ball:"), QString::fromUtf16(u"\U000026F9")},
        {QStringLiteral(":man_bouncing_ball:"), QString::fromUtf16(u"\U000026F9\U0000FE0F\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_bouncing_ball:"), QString::fromUtf16(u"\U000026F9\U0000FE0F\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":person_lifting_weights:"), QString::fromUtf16(u"\U0001F3CB")},
        {QStringLiteral(":man_lifting_weights:"), QString::fromUtf16(u"\U0001F3CB\U0000FE0F\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_lifting_weights:"), QString::fromUtf16(u"\U0001F3CB\U0000FE0F\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":person_biking:"), QString::fromUtf16(u"\U0001F6B4")},
        {QStringLiteral(":man_biking:"), QString::fromUtf16(u"\U0001F6B4\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_biking:"), QString::fromUtf16(u"\U0001F6B4\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":person_mountain_biking:"), QString::fromUtf16(u"\U0001F6B5")},
        {QStringLiteral(":man_mountain_biking:"), QString::fromUtf16(u"\U0001F6B5\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_mountain_biking:"), QString::fromUtf16(u"\U0001F6B5\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":person_cartwheeling:"), QString::fromUtf16(u"\U0001F938")},
        {QStringLiteral(":man_cartwheeling:"), QString::fromUtf16(u"\U0001F938\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_cartwheeling:"), QString::fromUtf16(u"\U0001F938\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":people_wrestling:"), QString::fromUtf16(u"\U0001F93C")},
        {QStringLiteral(":men_wrestling:"), QString::fromUtf16(u"\U0001F93C\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":women_wrestling:"), QString::fromUtf16(u"\U0001F93C\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":person_playing_water_polo:"), QString::fromUtf16(u"\U0001F93D")},
        {QStringLiteral(":man_playing_water_polo:"), QString::fromUtf16(u"\U0001F93D\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_playing_water_polo:"), QString::fromUtf16(u"\U0001F93D\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":person_playing_handball:"), QString::fromUtf16(u"\U0001F93E")},
        {QStringLiteral(":man_playing_handball:"), QString::fromUtf16(u"\U0001F93E\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_playing_handball:"), QString::fromUtf16(u"\U0001F93E\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":person_juggling:"), QString::fromUtf16(u"\U0001F939")},
        {QStringLiteral(":man_juggling:"), QString::fromUtf16(u"\U0001F939\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_juggling:"), QString::fromUtf16(u"\U0001F939\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":person_in_lotus_position:"), QString::fromUtf16(u"\U0001F9D8")},
        {QStringLiteral(":man_in_lotus_position:"), QString::fromUtf16(u"\U0001F9D8\U0000200D\U00002642\U0000FE0F")},
        {QStringLiteral(":woman_in_lotus_position:"), QString::fromUtf16(u"\U0001F9D8\U0000200D\U00002640\U0000FE0F")},
        {QStringLiteral(":person_taking_bath:"), QString::fromUtf16(u"\U0001F6C0")},
        {QStringLiteral(":person_in_bed:"), QString::fromUtf16(u"\U0001F6CC")},
        {QStringLiteral(":people_holding_hands:"), QString::fromUtf16(u"\U0001F9D1\U0000200D\U0001F91D\U0000200D\U0001F9D1")},
        {QStringLiteral(":women_holding_hands:"), QString::fromUtf16(u"\U0001F46D")},
        {QStringLiteral(":woman_and_man_holding_hands:"), QString::fromUtf16(u"\U0001F46B")},
        {QStringLiteral(":men_holding_hands:"), QString::fromUtf16(u"\U0001F46C")},
        {QStringLiteral(":kiss:"), QString::fromUtf16(u"\U0001F48F")},
        {QStringLiteral(":kiss_woman_man:"), QString::fromUtf16(u"\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468")},
        {QStringLiteral(":kiss_man_man:"), QString::fromUtf16(u"\U0001F468\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468")},
        {QStringLiteral(":kiss_woman_woman:"), QString::fromUtf16(u"\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469")},
        {QStringLiteral(":couple_with_heart:"), QString::fromUtf16(u"\U0001F491")},
        {QStringLiteral(":couple_with_heart_woman_man:"), QString::fromUtf16(u"\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468")},
        {QStringLiteral(":couple_with_heart_man_man:"), QString::fromUtf16(u"\U0001F468\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468")},
        {QStringLiteral(":couple_with_heart_woman_woman:"), QString::fromUtf16(u"\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469")},
        {QStringLiteral(":family:"), QString::fromUtf16(u"\U0001F46A")},
        {QStringLiteral(":family_man_woman_boy:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F469\U0000200D\U0001F466")},
        {QStringLiteral(":family_man_woman_girl:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467")},
        {QStringLiteral(":family_man_woman_girl_boy:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466")},
        {QStringLiteral(":family_man_woman_boy_boy:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466")},
        {QStringLiteral(":family_man_woman_girl_girl:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467")},
        {QStringLiteral(":family_man_man_boy:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F468\U0000200D\U0001F466")},
        {QStringLiteral(":family_man_man_girl:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467")},
        {QStringLiteral(":family_man_man_girl_boy:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467\U0000200D\U0001F466")},
        {QStringLiteral(":family_man_man_boy_boy:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F468\U0000200D\U0001F466\U0000200D\U0001F466")},
        {QStringLiteral(":family_man_man_girl_girl:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467\U0000200D\U0001F467")},
        {QStringLiteral(":family_woman_woman_boy:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F469\U0000200D\U0001F466")},
        {QStringLiteral(":family_woman_woman_girl:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467")},
        {QStringLiteral(":family_woman_woman_girl_boy:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466")},
        {QStringLiteral(":family_woman_woman_boy_boy:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466")},
        {QStringLiteral(":family_woman_woman_girl_girl:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467")},
        {QStringLiteral(":family_man_boy:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F466")},
        {QStringLiteral(":family_man_boy_boy:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F466\U0000200D\U0001F466")},
        {QStringLiteral(":family_man_girl:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F467")},
        {QStringLiteral(":family_man_girl_boy:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F467\U0000200D\U0001F466")},
        {QStringLiteral(":family_man_girl_girl:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F467\U0000200D\U0001F467")},
        {QStringLiteral(":family_woman_boy:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F466")},
        {QStringLiteral(":family_woman_boy_boy:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466")},
        {QStringLiteral(":family_woman_girl:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F467")},
        {QStringLiteral(":family_woman_girl_boy:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466")},
        {QStringLiteral(":family_woman_girl_girl:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467")},
        {QStringLiteral(":speaking_head:"), QString::fromUtf16(u"\U0001F5E3")},
        {QStringLiteral(":bust_in_silhouette:"), QString::fromUtf16(u"\U0001F464")},
        {QStringLiteral(":busts_in_silhouette:"), QString::fromUtf16(u"\U0001F465")},
        {QStringLiteral(":footprints:"), QString::fromUtf16(u"\U0001F463")},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodePlaceEmoji()
{
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst {
        {QStringLiteral(":globe_showing_Europe-Africa:"), QString::fromUtf16(u"\U0001F30D")},
        {QStringLiteral(":globe_showing_Americas:"), QString::fromUtf16(u"\U0001F30E")},
        {QStringLiteral(":globe_showing_Asia-Australia:"), QString::fromUtf16(u"\U0001F30F")},
        {QStringLiteral(":globe_with_meridians:"), QString::fromUtf16(u"\U0001F310")},
        {QStringLiteral(":world_map:"), QString::fromUtf16(u"\U0001F5FA")},
        {QStringLiteral(":map_of_Japan:"), QString::fromUtf16(u"\U0001F5FE")},
        {QStringLiteral(":compass:"), QString::fromUtf16(u"\U0001F9ED")},
        {QStringLiteral(":snow-capped_mountain:"), QString::fromUtf16(u"\U0001F3D4")},
        {QStringLiteral(":mountain:"), QString::fromUtf16(u"\U000026F0")},
        {QStringLiteral(":volcano:"), QString::fromUtf16(u"\U0001F30B")},
        {QStringLiteral(":mount_fuji:"), QString::fromUtf16(u"\U0001F5FB")},
        {QStringLiteral(":camping:"), QString::fromUtf16(u"\U0001F3D5")},
        {QStringLiteral(":beach_with_umbrella:"), QString::fromUtf16(u"\U0001F3D6")},
        {QStringLiteral(":desert:"), QString::fromUtf16(u"\U0001F3DC")},
        {QStringLiteral(":desert_island:"), QString::fromUtf16(u"\U0001F3DD")},
        {QStringLiteral(":national_park:"), QString::fromUtf16(u"\U0001F3DE")},
        {QStringLiteral(":stadium:"), QString::fromUtf16(u"\U0001F3DF")},
        {QStringLiteral(":classical_building:"), QString::fromUtf16(u"\U0001F3DB")},
        {QStringLiteral(":building_construction:"), QString::fromUtf16(u"\U0001F3D7")},
        {QStringLiteral(":brick:"), QString::fromUtf16(u"\U0001F9F1")},
        {QStringLiteral(":houses:"), QString::fromUtf16(u"\U0001F3D8")},
        {QStringLiteral(":derelict_house:"), QString::fromUtf16(u"\U0001F3DA")},
        {QStringLiteral(":house:"), QString::fromUtf16(u"\U0001F3E0")},
        {QStringLiteral(":house_with_garden:"), QString::fromUtf16(u"\U0001F3E1")},
        {QStringLiteral(":office_building:"), QString::fromUtf16(u"\U0001F3E2")},
        {QStringLiteral(":Japanese_post_office:"), QString::fromUtf16(u"\U0001F3E3")},
        {QStringLiteral(":post_office:"), QString::fromUtf16(u"\U0001F3E4")},
        {QStringLiteral(":hospital:"), QString::fromUtf16(u"\U0001F3E5")},
        {QStringLiteral(":bank:"), QString::fromUtf16(u"\U0001F3E6")},
        {QStringLiteral(":hotel:"), QString::fromUtf16(u"\U0001F3E8")},
        {QStringLiteral(":love_hotel:"), QString::fromUtf16(u"\U0001F3E9")},
        {QStringLiteral(":convenience_store:"), QString::fromUtf16(u"\U0001F3EA")},
        {QStringLiteral(":school:"), QString::fromUtf16(u"\U0001F3EB")},
        {QStringLiteral(":department_store:"), QString::fromUtf16(u"\U0001F3EC")},
        {QStringLiteral(":factory:"), QString::fromUtf16(u"\U0001F3ED")},
        {QStringLiteral(":Japanese_castle:"), QString::fromUtf16(u"\U0001F3EF")},
        {QStringLiteral(":castle:"), QString::fromUtf16(u"\U0001F3F0")},
        {QStringLiteral(":wedding:"), QString::fromUtf16(u"\U0001F492")},
        {QStringLiteral(":Tokyo_tower:"), QString::fromUtf16(u"\U0001F5FC")},
        {QStringLiteral(":Statue_of_Liberty:"), QString::fromUtf16(u"\U0001F5FD")},
        {QStringLiteral(":church:"), QString::fromUtf16(u"\U000026EA")},
        {QStringLiteral(":mosque:"), QString::fromUtf16(u"\U0001F54C")},
        {QStringLiteral(":hindu_temple:"), QString::fromUtf16(u"\U0001F6D5")},
        {QStringLiteral(":synagogue:"), QString::fromUtf16(u"\U0001F54D")},
        {QStringLiteral(":shinto_shrine:"), QString::fromUtf16(u"\U000026E9")},
        {QStringLiteral(":kaaba:"), QString::fromUtf16(u"\U0001F54B")},
        {QStringLiteral(":fountain:"), QString::fromUtf16(u"\U000026F2")},
        {QStringLiteral(":tent:"), QString::fromUtf16(u"\U000026FA")},
        {QStringLiteral(":foggy:"), QString::fromUtf16(u"\U0001F301")},
        {QStringLiteral(":night_with_stars:"), QString::fromUtf16(u"\U0001F303")},
        {QStringLiteral(":cityscape:"), QString::fromUtf16(u"\U0001F3D9")},
        {QStringLiteral(":sunrise_over_mountains:"), QString::fromUtf16(u"\U0001F304")},
        {QStringLiteral(":sunrise:"), QString::fromUtf16(u"\U0001F305")},
        {QStringLiteral(":cityscape_at_dusk:"), QString::fromUtf16(u"\U0001F306")},
        {QStringLiteral(":sunset:"), QString::fromUtf16(u"\U0001F307")},
        {QStringLiteral(":bridge_at_night:"), QString::fromUtf16(u"\U0001F309")},
        {QStringLiteral(":hot_springs:"), QString::fromUtf16(u"\U00002668")},
        {QStringLiteral(":carousel_horse:"), QString::fromUtf16(u"\U0001F3A0")},
        {QStringLiteral(":ferris_wheel:"), QString::fromUtf16(u"\U0001F3A1")},
        {QStringLiteral(":roller_coaster:"), QString::fromUtf16(u"\U0001F3A2")},
        {QStringLiteral(":barber_pole:"), QString::fromUtf16(u"\U0001F488")},
        {QStringLiteral(":circus_tent:"), QString::fromUtf16(u"\U0001F3AA")},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeSymbolsEmoji()
{
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst {
        {QStringLiteral(":ATM_sign:"), QString::fromUtf16(u"\U0001F3E7")},
        {QStringLiteral(":litter_in_bin_sign:"), QString::fromUtf16(u"\U0001F6AE")},
        {QStringLiteral(":potable_water:"), QString::fromUtf16(u"\U0001F6B0")},
        {QStringLiteral(":wheelchair_symbol:"), QString::fromUtf16(u"\U0000267F")},
        {QStringLiteral(":men’s_room:"), QString::fromUtf16(u"\U0001F6B9")},
        {QStringLiteral(":women’s_room:"), QString::fromUtf16(u"\U0001F6BA")},
        {QStringLiteral(":restroom:"), QString::fromUtf16(u"\U0001F6BB")},
        {QStringLiteral(":baby_symbol:"), QString::fromUtf16(u"\U0001F6BC")},
        {QStringLiteral(":water_closet:"), QString::fromUtf16(u"\U0001F6BE")},
        {QStringLiteral(":passport_control:"), QString::fromUtf16(u"\U0001F6C2")},
        {QStringLiteral(":customs:"), QString::fromUtf16(u"\U0001F6C3")},
        {QStringLiteral(":baggage_claim:"), QString::fromUtf16(u"\U0001F6C4")},
        {QStringLiteral(":left_luggage:"), QString::fromUtf16(u"\U0001F6C5")},
        {QStringLiteral(":warning:"), QString::fromUtf16(u"\U000026A0")},
        {QStringLiteral(":children_crossing:"), QString::fromUtf16(u"\U0001F6B8")},
        {QStringLiteral(":no_entry:"), QString::fromUtf16(u"\U000026D4")},
        {QStringLiteral(":prohibited:"), QString::fromUtf16(u"\U0001F6AB")},
        {QStringLiteral(":no_bicycles:"), QString::fromUtf16(u"\U0001F6B3")},
        {QStringLiteral(":no_smoking:"), QString::fromUtf16(u"\U0001F6AD")},
        {QStringLiteral(":no_littering:"), QString::fromUtf16(u"\U0001F6AF")},
        {QStringLiteral(":non-potable_water:"), QString::fromUtf16(u"\U0001F6B1")},
        {QStringLiteral(":no_pedestrians:"), QString::fromUtf16(u"\U0001F6B7")},
        {QStringLiteral(":no_mobile_phones:"), QString::fromUtf16(u"\U0001F4F5")},
        {QStringLiteral(":no_one_under_eighteen:"), QString::fromUtf16(u"\U0001F51E")},
        {QStringLiteral(":radioactive:"), QString::fromUtf16(u"\U00002622")},
        {QStringLiteral(":biohazard:"), QString::fromUtf16(u"\U00002623")},
        {QStringLiteral(":up_arrow:"), QString::fromUtf16(u"\U00002B06")},
        {QStringLiteral(":up-right_arrow:"), QString::fromUtf16(u"\U00002197")},
        {QStringLiteral(":right_arrow:"), QString::fromUtf16(u"\U000027A1")},
        {QStringLiteral(":down-right_arrow:"), QString::fromUtf16(u"\U00002198")},
        {QStringLiteral(":down_arrow:"), QString::fromUtf16(u"\U00002B07")},
        {QStringLiteral(":down-left_arrow:"), QString::fromUtf16(u"\U00002199")},
        {QStringLiteral(":left_arrow:"), QString::fromUtf16(u"\U00002B05")},
        {QStringLiteral(":up-left_arrow:"), QString::fromUtf16(u"\U00002196")},
        {QStringLiteral(":up-down_arrow:"), QString::fromUtf16(u"\U00002195")},
        {QStringLiteral(":left-right_arrow:"), QString::fromUtf16(u"\U00002194")},
        {QStringLiteral(":right_arrow_curving_left:"), QString::fromUtf16(u"\U000021A9")},
        {QStringLiteral(":left_arrow_curving_right:"), QString::fromUtf16(u"\U000021AA")},
        {QStringLiteral(":right_arrow_curving_up:"), QString::fromUtf16(u"\U00002934")},
        {QStringLiteral(":right_arrow_curving_down:"), QString::fromUtf16(u"\U00002935")},
        {QStringLiteral(":clockwise_vertical_arrows:"), QString::fromUtf16(u"\U0001F503")},
        {QStringLiteral(":counterclockwise_arrows_button:"), QString::fromUtf16(u"\U0001F504")},
        {QStringLiteral(":BACK_arrow:"), QString::fromUtf16(u"\U0001F519")},
        {QStringLiteral(":END_arrow:"), QString::fromUtf16(u"\U0001F51A")},
        {QStringLiteral(":ON!_arrow:"), QString::fromUtf16(u"\U0001F51B")},
        {QStringLiteral(":SOON_arrow:"), QString::fromUtf16(u"\U0001F51C")},
        {QStringLiteral(":TOP_arrow:"), QString::fromUtf16(u"\U0001F51D")},
        {QStringLiteral(":place_of_worship:"), QString::fromUtf16(u"\U0001F6D0")},
        {QStringLiteral(":atom_symbol:"), QString::fromUtf16(u"\U0000269B")},
        {QStringLiteral(":om:"), QString::fromUtf16(u"\U0001F549")},
        {QStringLiteral(":star_of_David:"), QString::fromUtf16(u"\U00002721")},
        {QStringLiteral(":wheel_of_dharma:"), QString::fromUtf16(u"\U00002638")},
        {QStringLiteral(":yin_yang:"), QString::fromUtf16(u"\U0000262F")},
        {QStringLiteral(":latin_cross:"), QString::fromUtf16(u"\U0000271D")},
        {QStringLiteral(":orthodox_cross:"), QString::fromUtf16(u"\U00002626")},
        {QStringLiteral(":star_and_crescent:"), QString::fromUtf16(u"\U0000262A")},
        {QStringLiteral(":peace_symbol:"), QString::fromUtf16(u"\U0000262E")},
        {QStringLiteral(":menorah:"), QString::fromUtf16(u"\U0001F54E")},
        {QStringLiteral(":dotted_six-pointed_star:"), QString::fromUtf16(u"\U0001F52F")},
        {QStringLiteral(":Aries:"), QString::fromUtf16(u"\U00002648")},
        {QStringLiteral(":Taurus:"), QString::fromUtf16(u"\U00002649")},
        {QStringLiteral(":Gemini:"), QString::fromUtf16(u"\U0000264A")},
        {QStringLiteral(":Cancer:"), QString::fromUtf16(u"\U0000264B")},
        {QStringLiteral(":Leo:"), QString::fromUtf16(u"\U0000264C")},
        {QStringLiteral(":Virgo:"), QString::fromUtf16(u"\U0000264D")},
        {QStringLiteral(":Libra:"), QString::fromUtf16(u"\U0000264E")},
        {QStringLiteral(":Scorpio:"), QString::fromUtf16(u"\U0000264F")},
        {QStringLiteral(":Sagittarius:"), QString::fromUtf16(u"\U00002650")},
        {QStringLiteral(":Capricorn:"), QString::fromUtf16(u"\U00002651")},
        {QStringLiteral(":Aquarius:"), QString::fromUtf16(u"\U00002652")},
        {QStringLiteral(":Pisces:"), QString::fromUtf16(u"\U00002653")},
        {QStringLiteral(":Ophiuchus:"), QString::fromUtf16(u"\U000026CE")},
        {QStringLiteral(":shuffle_tracks_button:"), QString::fromUtf16(u"\U0001F500")},
        {QStringLiteral(":repeat_button:"), QString::fromUtf16(u"\U0001F501")},
        {QStringLiteral(":repeat_single_button:"), QString::fromUtf16(u"\U0001F502")},
        {QStringLiteral(":play_button:"), QString::fromUtf16(u"\U000025B6")},
        {QStringLiteral(":fast-forward_button:"), QString::fromUtf16(u"\U000023E9")},
        {QStringLiteral(":next_track_button:"), QString::fromUtf16(u"\U000023ED")},
        {QStringLiteral(":play_or_pause_button:"), QString::fromUtf16(u"\U000023EF")},
        {QStringLiteral(":reverse_button:"), QString::fromUtf16(u"\U000025C0")},
        {QStringLiteral(":fast_reverse_button:"), QString::fromUtf16(u"\U000023EA")},
        {QStringLiteral(":last_track_button:"), QString::fromUtf16(u"\U000023EE")},
        {QStringLiteral(":upwards_button:"), QString::fromUtf16(u"\U0001F53C")},
        {QStringLiteral(":fast_up_button:"), QString::fromUtf16(u"\U000023EB")},
        {QStringLiteral(":downwards_button:"), QString::fromUtf16(u"\U0001F53D")},
        {QStringLiteral(":fast_down_button:"), QString::fromUtf16(u"\U000023EC")},
        {QStringLiteral(":pause_button:"), QString::fromUtf16(u"\U000023F8")},
        {QStringLiteral(":stop_button:"), QString::fromUtf16(u"\U000023F9")},
        {QStringLiteral(":record_button:"), QString::fromUtf16(u"\U000023FA")},
        {QStringLiteral(":eject_button:"), QString::fromUtf16(u"\U000023CF")},
        {QStringLiteral(":cinema:"), QString::fromUtf16(u"\U0001F3A6")},
        {QStringLiteral(":dim_button:"), QString::fromUtf16(u"\U0001F505")},
        {QStringLiteral(":bright_button:"), QString::fromUtf16(u"\U0001F506")},
        {QStringLiteral(":antenna_bars:"), QString::fromUtf16(u"\U0001F4F6")},
        {QStringLiteral(":vibration_mode:"), QString::fromUtf16(u"\U0001F4F3")},
        {QStringLiteral(":mobile_phone_off:"), QString::fromUtf16(u"\U0001F4F4")},
        {QStringLiteral(":female_sign:"), QString::fromUtf16(u"\U00002640")},
        {QStringLiteral(":male_sign:"), QString::fromUtf16(u"\U00002642")},
        {QStringLiteral(":medical_symbol:"), QString::fromUtf16(u"\U00002695")},
        {QStringLiteral(":infinity:"), QString::fromUtf16(u"\U0000267E")},
        {QStringLiteral(":recycling_symbol:"), QString::fromUtf16(u"\U0000267B")},
        {QStringLiteral(":fleur-de-lis:"), QString::fromUtf16(u"\U0000269C")},
        {QStringLiteral(":trident_emblem:"), QString::fromUtf16(u"\U0001F531")},
        {QStringLiteral(":name_badge:"), QString::fromUtf16(u"\U0001F4DB")},
        {QStringLiteral(":Japanese_symbol_for_beginner:"), QString::fromUtf16(u"\U0001F530")},
        {QStringLiteral(":hollow_red_circle:"), QString::fromUtf16(u"\U00002B55")},
        {QStringLiteral(":check_mark_button:"), QString::fromUtf16(u"\U00002705")},
        {QStringLiteral(":check_box_with_check:"), QString::fromUtf16(u"\U00002611")},
        {QStringLiteral(":check_mark:"), QString::fromUtf16(u"\U00002714")},
        {QStringLiteral(":multiplication_sign:"), QString::fromUtf16(u"\U00002716")},
        {QStringLiteral(":cross_mark:"), QString::fromUtf16(u"\U0000274C")},
        {QStringLiteral(":cross_mark_button:"), QString::fromUtf16(u"\U0000274E")},
        {QStringLiteral(":plus_sign:"), QString::fromUtf16(u"\U00002795")},
        {QStringLiteral(":minus_sign:"), QString::fromUtf16(u"\U00002796")},
        {QStringLiteral(":division_sign:"), QString::fromUtf16(u"\U00002797")},
        {QStringLiteral(":curly_loop:"), QString::fromUtf16(u"\U000027B0")},
        {QStringLiteral(":double_curly_loop:"), QString::fromUtf16(u"\U000027BF")},
        {QStringLiteral(":part_alternation_mark:"), QString::fromUtf16(u"\U0000303D")},
        {QStringLiteral(":eight-spoked_asterisk:"), QString::fromUtf16(u"\U00002733")},
        {QStringLiteral(":eight-pointed_star:"), QString::fromUtf16(u"\U00002734")},
        {QStringLiteral(":sparkle:"), QString::fromUtf16(u"\U00002747")},
        {QStringLiteral(":double_exclamation_mark:"), QString::fromUtf16(u"\U0000203C")},
        {QStringLiteral(":exclamation_question_mark:"), QString::fromUtf16(u"\U00002049")},
        {QStringLiteral(":question_mark:"), QString::fromUtf16(u"\U00002753")},
        {QStringLiteral(":white_question_mark:"), QString::fromUtf16(u"\U00002754")},
        {QStringLiteral(":white_exclamation_mark:"), QString::fromUtf16(u"\U00002755")},
        {QStringLiteral(":exclamation_mark:"), QString::fromUtf16(u"\U00002757")},
        {QStringLiteral(":wavy_dash:"), QString::fromUtf16(u"\U00003030")},
        {QStringLiteral(":copyright:"), QString::fromUtf16(u"\U000000A9")},
        {QStringLiteral(":registered:"), QString::fromUtf16(u"\U000000AE")},
        {QStringLiteral(":trade_mark:"), QString::fromUtf16(u"\U00002122")},
        {QStringLiteral(":keycap_#:"), QString::fromUtf16(u"\U00000023\U0000FE0F\U000020E3")},
        {QStringLiteral(":keycap_*:"), QString::fromUtf16(u"\U0000002A\U0000FE0F\U000020E3")},
        {QStringLiteral(":keycap_0:"), QString::fromUtf16(u"\U00000030\U0000FE0F\U000020E3")},
        {QStringLiteral(":keycap_1:"), QString::fromUtf16(u"\U00000031\U0000FE0F\U000020E3")},
        {QStringLiteral(":keycap_2:"), QString::fromUtf16(u"\U00000032\U0000FE0F\U000020E3")},
        {QStringLiteral(":keycap_3:"), QString::fromUtf16(u"\U00000033\U0000FE0F\U000020E3")},
        {QStringLiteral(":keycap_4:"), QString::fromUtf16(u"\U00000034\U0000FE0F\U000020E3")},
        {QStringLiteral(":keycap_5:"), QString::fromUtf16(u"\U00000035\U0000FE0F\U000020E3")},
        {QStringLiteral(":keycap_6:"), QString::fromUtf16(u"\U00000036\U0000FE0F\U000020E3")},
        {QStringLiteral(":keycap_7:"), QString::fromUtf16(u"\U00000037\U0000FE0F\U000020E3")},
        {QStringLiteral(":keycap_8:"), QString::fromUtf16(u"\U00000038\U0000FE0F\U000020E3")},
        {QStringLiteral(":keycap_9:"), QString::fromUtf16(u"\U00000039\U0000FE0F\U000020E3")},
        {QStringLiteral(":keycap_10:"), QString::fromUtf16(u"\U0001F51F")},
        {QStringLiteral(":input_latin_uppercase:"), QString::fromUtf16(u"\U0001F520")},
        {QStringLiteral(":input_latin_lowercase:"), QString::fromUtf16(u"\U0001F521")},
        {QStringLiteral(":input_numbers:"), QString::fromUtf16(u"\U0001F522")},
        {QStringLiteral(":input_symbols:"), QString::fromUtf16(u"\U0001F523")},
        {QStringLiteral(":input_latin_letters:"), QString::fromUtf16(u"\U0001F524")},
        {QStringLiteral(":A_button_(blood_type):"), QString::fromUtf16(u"\U0001F170")},
        {QStringLiteral(":AB_button_(blood_type):"), QString::fromUtf16(u"\U0001F18E")},
        {QStringLiteral(":B_button_(blood_type):"), QString::fromUtf16(u"\U0001F171")},
        {QStringLiteral(":CL_button:"), QString::fromUtf16(u"\U0001F191")},
        {QStringLiteral(":COOL_button:"), QString::fromUtf16(u"\U0001F192")},
        {QStringLiteral(":FREE_button:"), QString::fromUtf16(u"\U0001F193")},
        {QStringLiteral(":information:"), QString::fromUtf16(u"\U00002139")},
        {QStringLiteral(":ID_button:"), QString::fromUtf16(u"\U0001F194")},
        {QStringLiteral(":circled_M:"), QString::fromUtf16(u"\U000024C2")},
        {QStringLiteral(":NEW_button:"), QString::fromUtf16(u"\U0001F195")},
        {QStringLiteral(":NG_button:"), QString::fromUtf16(u"\U0001F196")},
        {QStringLiteral(":O_button_(blood_type):"), QString::fromUtf16(u"\U0001F17E")},
        {QStringLiteral(":OK_button:"), QString::fromUtf16(u"\U0001F197")},
        {QStringLiteral(":P_button:"), QString::fromUtf16(u"\U0001F17F")},
        {QStringLiteral(":SOS_button:"), QString::fromUtf16(u"\U0001F198")},
        {QStringLiteral(":UP!_button:"), QString::fromUtf16(u"\U0001F199")},
        {QStringLiteral(":VS_button:"), QString::fromUtf16(u"\U0001F19A")},
        {QStringLiteral(":Japanese_here_button:"), QString::fromUtf16(u"\U0001F201")},
        {QStringLiteral(":Japanese_service_charge_button:"), QString::fromUtf16(u"\U0001F202")},
        {QStringLiteral(":Japanese_monthly_amount_button:"), QString::fromUtf16(u"\U0001F237")},
        {QStringLiteral(":Japanese_not_free_of_charge_button:"), QString::fromUtf16(u"\U0001F236")},
        {QStringLiteral(":Japanese_reserved_button:"), QString::fromUtf16(u"\U0001F22F")},
        {QStringLiteral(":Japanese_bargain_button:"), QString::fromUtf16(u"\U0001F250")},
        {QStringLiteral(":Japanese_discount_button:"), QString::fromUtf16(u"\U0001F239")},
        {QStringLiteral(":Japanese_free_of_charge_button:"), QString::fromUtf16(u"\U0001F21A")},
        {QStringLiteral(":Japanese_prohibited_button:"), QString::fromUtf16(u"\U0001F232")},
        {QStringLiteral(":Japanese_acceptable_button:"), QString::fromUtf16(u"\U0001F251")},
        {QStringLiteral(":Japanese_application_button:"), QString::fromUtf16(u"\U0001F238")},
        {QStringLiteral(":Japanese_passing_grade_button:"), QString::fromUtf16(u"\U0001F234")},
        {QStringLiteral(":Japanese_vacancy_button:"), QString::fromUtf16(u"\U0001F233")},
        {QStringLiteral(":Japanese_congratulations_button:"), QString::fromUtf16(u"\U00003297")},
        {QStringLiteral(":Japanese_secret_button:"), QString::fromUtf16(u"\U00003299")},
        {QStringLiteral(":Japanese_open_for_business_button:"), QString::fromUtf16(u"\U0001F23A")},
        {QStringLiteral(":Japanese_no_vacancy_button:"), QString::fromUtf16(u"\U0001F235")},
        {QStringLiteral(":red_circle:"), QString::fromUtf16(u"\U0001F534")},
        {QStringLiteral(":orange_circle:"), QString::fromUtf16(u"\U0001F7E0")},
        {QStringLiteral(":yellow_circle:"), QString::fromUtf16(u"\U0001F7E1")},
        {QStringLiteral(":green_circle:"), QString::fromUtf16(u"\U0001F7E2")},
        {QStringLiteral(":blue_circle:"), QString::fromUtf16(u"\U0001F535")},
        {QStringLiteral(":purple_circle:"), QString::fromUtf16(u"\U0001F7E3")},
        {QStringLiteral(":brown_circle:"), QString::fromUtf16(u"\U0001F7E4")},
        {QStringLiteral(":black_circle:"), QString::fromUtf16(u"\U000026AB")},
        {QStringLiteral(":white_circle:"), QString::fromUtf16(u"\U000026AA")},
        {QStringLiteral(":red_square:"), QString::fromUtf16(u"\U0001F7E5")},
        {QStringLiteral(":orange_square:"), QString::fromUtf16(u"\U0001F7E7")},
        {QStringLiteral(":yellow_square:"), QString::fromUtf16(u"\U0001F7E8")},
        {QStringLiteral(":green_square:"), QString::fromUtf16(u"\U0001F7E9")},
        {QStringLiteral(":blue_square:"), QString::fromUtf16(u"\U0001F7E6")},
        {QStringLiteral(":purple_square:"), QString::fromUtf16(u"\U0001F7EA")},
        {QStringLiteral(":brown_square:"), QString::fromUtf16(u"\U0001F7EB")},
        {QStringLiteral(":black_large_square:"), QString::fromUtf16(u"\U00002B1B")},
        {QStringLiteral(":white_large_square:"), QString::fromUtf16(u"\U00002B1C")},
        {QStringLiteral(":black_medium_square:"), QString::fromUtf16(u"\U000025FC")},
        {QStringLiteral(":white_medium_square:"), QString::fromUtf16(u"\U000025FB")},
        {QStringLiteral(":black_medium-small_square:"), QString::fromUtf16(u"\U000025FE")},
        {QStringLiteral(":white_medium-small_square:"), QString::fromUtf16(u"\U000025FD")},
        {QStringLiteral(":black_small_square:"), QString::fromUtf16(u"\U000025AA")},
        {QStringLiteral(":white_small_square:"), QString::fromUtf16(u"\U000025AB")},
        {QStringLiteral(":large_orange_diamond:"), QString::fromUtf16(u"\U0001F536")},
        {QStringLiteral(":large_blue_diamond:"), QString::fromUtf16(u"\U0001F537")},
        {QStringLiteral(":small_orange_diamond:"), QString::fromUtf16(u"\U0001F538")},
        {QStringLiteral(":small_blue_diamond:"), QString::fromUtf16(u"\U0001F539")},
        {QStringLiteral(":red_triangle_pointed_up:"), QString::fromUtf16(u"\U0001F53A")},
        {QStringLiteral(":red_triangle_pointed_down:"), QString::fromUtf16(u"\U0001F53B")},
        {QStringLiteral(":diamond_with_a_dot:"), QString::fromUtf16(u"\U0001F4A0")},
        {QStringLiteral(":radio_button:"), QString::fromUtf16(u"\U0001F518")},
        {QStringLiteral(":white_square_button:"), QString::fromUtf16(u"\U0001F533")},
        {QStringLiteral(":black_square_button:"), QString::fromUtf16(u"\U0001F532")},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeSportEmoji()
{
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst {
        {QStringLiteral(":soccer_ball:"), QString::fromUtf16(u"\U000026BD")},
        {QStringLiteral(":baseball:"), QString::fromUtf16(u"\U000026BE")},
        {QStringLiteral(":softball:"), QString::fromUtf16(u"\U0001F94E")},
        {QStringLiteral(":basketball:"), QString::fromUtf16(u"\U0001F3C0")},
        {QStringLiteral(":volleyball:"), QString::fromUtf16(u"\U0001F3D0")},
        {QStringLiteral(":american_football:"), QString::fromUtf16(u"\U0001F3C8")},
        {QStringLiteral(":rugby_football:"), QString::fromUtf16(u"\U0001F3C9")},
        {QStringLiteral(":tennis:"), QString::fromUtf16(u"\U0001F3BE")},
        {QStringLiteral(":flying_disc:"), QString::fromUtf16(u"\U0001F94F")},
        {QStringLiteral(":bowling:"), QString::fromUtf16(u"\U0001F3B3")},
        {QStringLiteral(":cricket_game:"), QString::fromUtf16(u"\U0001F3CF")},
        {QStringLiteral(":field_hockey:"), QString::fromUtf16(u"\U0001F3D1")},
        {QStringLiteral(":ice_hockey:"), QString::fromUtf16(u"\U0001F3D2")},
        {QStringLiteral(":lacrosse:"), QString::fromUtf16(u"\U0001F94D")},
        {QStringLiteral(":ping_pong:"), QString::fromUtf16(u"\U0001F3D3")},
        {QStringLiteral(":badminton:"), QString::fromUtf16(u"\U0001F3F8")},
        {QStringLiteral(":boxing_glove:"), QString::fromUtf16(u"\U0001F94A")},
        {QStringLiteral(":martial_arts_uniform:"), QString::fromUtf16(u"\U0001F94B")},
        {QStringLiteral(":goal_net:"), QString::fromUtf16(u"\U0001F945")},
        {QStringLiteral(":flag_in_hole:"), QString::fromUtf16(u"\U000026F3")},
        {QStringLiteral(":ice_skate:"), QString::fromUtf16(u"\U000026F8")},
        {QStringLiteral(":fishing_pole:"), QString::fromUtf16(u"\U0001F3A3")},
        {QStringLiteral(":diving_mask:"), QString::fromUtf16(u"\U0001F93F")},
        {QStringLiteral(":running_shirt:"), QString::fromUtf16(u"\U0001F3BD")},
        {QStringLiteral(":skis:"), QString::fromUtf16(u"\U0001F3BF")},
        {QStringLiteral(":sled:"), QString::fromUtf16(u"\U0001F6F7")},
        {QStringLiteral(":curling_stone:"), QString::fromUtf16(u"\U0001F94C")},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeEmotionEmoji()
{
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst {
        {QStringLiteral(":kiss_mark:"), QString::fromUtf16(u"\U0001F48B")},
        {QStringLiteral(":love_letter:"), QString::fromUtf16(u"\U0001F48C")},
        {QStringLiteral(":heart_with_arrow:"), QString::fromUtf16(u"\U0001F498")},
        {QStringLiteral(":heart_with_ribbon:"), QString::fromUtf16(u"\U0001F49D")},
        {QStringLiteral(":sparkling_heart:"), QString::fromUtf16(u"\U0001F496")},
        {QStringLiteral(":growing_heart:"), QString::fromUtf16(u"\U0001F497")},
        {QStringLiteral(":beating_heart:"), QString::fromUtf16(u"\U0001F493")},
        {QStringLiteral(":revolving_hearts:"), QString::fromUtf16(u"\U0001F49E")},
        {QStringLiteral(":two_hearts:"), QString::fromUtf16(u"\U0001F495")},
        {QStringLiteral(":heart_decoration:"), QString::fromUtf16(u"\U0001F49F")},
        {QStringLiteral(":heart_exclamation:"), QString::fromUtf16(u"\U00002763")},
        {QStringLiteral(":broken_heart:"), QString::fromUtf16(u"\U0001F494")},
        {QStringLiteral(":red_heart:"), QString::fromUtf16(u"\U00002764")},
        {QStringLiteral(":orange_heart:"), QString::fromUtf16(u"\U0001F9E1")},
        {QStringLiteral(":yellow_heart:"), QString::fromUtf16(u"\U0001F49B")},
        {QStringLiteral(":green_heart:"), QString::fromUtf16(u"\U0001F49A")},
        {QStringLiteral(":blue_heart:"), QString::fromUtf16(u"\U0001F499")},
        {QStringLiteral(":purple_heart:"), QString::fromUtf16(u"\U0001F49C")},
        {QStringLiteral(":brown_heart:"), QString::fromUtf16(u"\U0001F90E")},
        {QStringLiteral(":black_heart:"), QString::fromUtf16(u"\U0001F5A4")},
        {QStringLiteral(":white_heart:"), QString::fromUtf16(u"\U0001F90D")},
        {QStringLiteral(":hundred_points:"), QString::fromUtf16(u"\U0001F4AF")},
        {QStringLiteral(":anger_symbol:"), QString::fromUtf16(u"\U0001F4A2")},
        {QStringLiteral(":collision:"), QString::fromUtf16(u"\U0001F4A5")},
        {QStringLiteral(":dizzy:"), QString::fromUtf16(u"\U0001F4AB")},
        {QStringLiteral(":sweat_droplets:"), QString::fromUtf16(u"\U0001F4A6")},
        {QStringLiteral(":dashing_away:"), QString::fromUtf16(u"\U0001F4A8")},
        {QStringLiteral(":hole:"), QString::fromUtf16(u"\U0001F573")},
        {QStringLiteral(":bomb:"), QString::fromUtf16(u"\U0001F4A3")},
        {QStringLiteral(":speech_balloon:"), QString::fromUtf16(u"\U0001F4AC")},
        {QStringLiteral(":eye_in_speech_bubble:"), QString::fromUtf16(u"\U0001F441\U0000FE0F\U0000200D\U0001F5E8\U0000FE0F")},
        {QStringLiteral(":left_speech_bubble:"), QString::fromUtf16(u"\U0001F5E8")},
        {QStringLiteral(":right_anger_bubble:"), QString::fromUtf16(u"\U0001F5EF")},
        {QStringLiteral(":thought_balloon:"), QString::fromUtf16(u"\U0001F4AD")},
        {QStringLiteral(":zzz:"), QString::fromUtf16(u"\U0001F4A4")},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeMoneyEmoji()
{
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst {
        {QStringLiteral(":money_bag:"), QString::fromUtf16(u"\U0001F4B0")},
        {QStringLiteral(":yen_banknote:"), QString::fromUtf16(u"\U0001F4B4")},
        {QStringLiteral(":dollar_banknote:"), QString::fromUtf16(u"\U0001F4B5")},
        {QStringLiteral(":euro_banknote:"), QString::fromUtf16(u"\U0001F4B6")},
        {QStringLiteral(":pound_banknote:"), QString::fromUtf16(u"\U0001F4B7")},
        {QStringLiteral(":money_with_wings:"), QString::fromUtf16(u"\U0001F4B8")},
        {QStringLiteral(":credit_card:"), QString::fromUtf16(u"\U0001F4B3")},
        {QStringLiteral(":receipt:"), QString::fromUtf16(u"\U0001F9FE")},
        {QStringLiteral(":chart_increasing_with_yen:"), QString::fromUtf16(u"\U0001F4B9")},
        {QStringLiteral(":currency_exchange:"), QString::fromUtf16(u"\U0001F4B1")},
        {QStringLiteral(":heavy_dollar_sign:"), QString::fromUtf16(u"\U0001F4B2")},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeBodyEmoji()
{
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst {
        {QStringLiteral(":waving_hand:"), QString::fromUtf16(u"\U0001F44B")},
        {QStringLiteral(":raised_back_of_hand:"), QString::fromUtf16(u"\U0001F91A")},
        {QStringLiteral(":hand_with_fingers_splayed:"), QString::fromUtf16(u"\U0001F590")},
        {QStringLiteral(":raised_hand:"), QString::fromUtf16(u"\U0000270B")},
        {QStringLiteral(":vulcan_salute:"), QString::fromUtf16(u"\U0001F596")},
        {QStringLiteral(":OK_hand:"), QString::fromUtf16(u"\U0001F44C")},
        {QStringLiteral(":pinching_hand:"), QString::fromUtf16(u"\U0001F90F")},
        {QStringLiteral(":victory_hand:"), QString::fromUtf16(u"\U0000270C")},
        {QStringLiteral(":crossed_fingers:"), QString::fromUtf16(u"\U0001F91E")},
        {QStringLiteral(":love-you_gesture:"), QString::fromUtf16(u"\U0001F91F")},
        {QStringLiteral(":sign_of_the_horns:"), QString::fromUtf16(u"\U0001F918")},
        {QStringLiteral(":call_me_hand:"), QString::fromUtf16(u"\U0001F919")},
        {QStringLiteral(":backhand_index_pointing_left:"), QString::fromUtf16(u"\U0001F448")},
        {QStringLiteral(":backhand_index_pointing_right:"), QString::fromUtf16(u"\U0001F449")},
        {QStringLiteral(":backhand_index_pointing_up:"), QString::fromUtf16(u"\U0001F446")},
        {QStringLiteral(":middle_finger:"), QString::fromUtf16(u"\U0001F595")},
        {QStringLiteral(":backhand_index_pointing_down:"), QString::fromUtf16(u"\U0001F447")},
        {QStringLiteral(":index_pointing_up:"), QString::fromUtf16(u"\U0000261D")},
        {QStringLiteral(":thumbs_up:"), QString::fromUtf16(u"\U0001F44D")},
        {QStringLiteral(":thumbs_down:"), QString::fromUtf16(u"\U0001F44E")},
        {QStringLiteral(":raised_fist:"), QString::fromUtf16(u"\U0000270A")},
        {QStringLiteral(":oncoming_fist:"), QString::fromUtf16(u"\U0001F44A")},
        {QStringLiteral(":left-facing_fist:"), QString::fromUtf16(u"\U0001F91B")},
        {QStringLiteral(":right-facing_fist:"), QString::fromUtf16(u"\U0001F91C")},
        {QStringLiteral(":clapping_hands:"), QString::fromUtf16(u"\U0001F44F")},
        {QStringLiteral(":raising_hands:"), QString::fromUtf16(u"\U0001F64C")},
        {QStringLiteral(":open_hands:"), QString::fromUtf16(u"\U0001F450")},
        {QStringLiteral(":palms_up_together:"), QString::fromUtf16(u"\U0001F932")},
        {QStringLiteral(":handshake:"), QString::fromUtf16(u"\U0001F91D")},
        {QStringLiteral(":folded_hands:"), QString::fromUtf16(u"\U0001F64F")},
        {QStringLiteral(":writing_hand:"), QString::fromUtf16(u"\U0000270D")},
        {QStringLiteral(":nail_polish:"), QString::fromUtf16(u"\U0001F485")},
        {QStringLiteral(":selfie:"), QString::fromUtf16(u"\U0001F933")},
        {QStringLiteral(":flexed_biceps:"), QString::fromUtf16(u"\U0001F4AA")},
        {QStringLiteral(":mechanical_arm:"), QString::fromUtf16(u"\U0001F9BE")},
        {QStringLiteral(":mechanical_leg:"), QString::fromUtf16(u"\U0001F9BF")},
        {QStringLiteral(":leg:"), QString::fromUtf16(u"\U0001F9B5")},
        {QStringLiteral(":foot:"), QString::fromUtf16(u"\U0001F9B6")},
        {QStringLiteral(":ear:"), QString::fromUtf16(u"\U0001F442")},
        {QStringLiteral(":ear_with_hearing_aid:"), QString::fromUtf16(u"\U0001F9BB")},
        {QStringLiteral(":nose:"), QString::fromUtf16(u"\U0001F443")},
        {QStringLiteral(":brain:"), QString::fromUtf16(u"\U0001F9E0")},
        {QStringLiteral(":tooth:"), QString::fromUtf16(u"\U0001F9B7")},
        {QStringLiteral(":bone:"), QString::fromUtf16(u"\U0001F9B4")},
        {QStringLiteral(":eyes:"), QString::fromUtf16(u"\U0001F440")},
        {QStringLiteral(":eye:"), QString::fromUtf16(u"\U0001F441")},
        {QStringLiteral(":tongue:"), QString::fromUtf16(u"\U0001F445")},
        {QStringLiteral(":mouth:"), QString::fromUtf16(u"\U0001F444")},
        {QStringLiteral(":red_hair:"), QString::fromUtf16(u"\U0001F9B0")},
        {QStringLiteral(":curly_hair:"), QString::fromUtf16(u"\U0001F9B1")},
        {QStringLiteral(":white_hair:"), QString::fromUtf16(u"\U0001F9B3")},
        {QStringLiteral(":bald:"), QString::fromUtf16(u"\U0001F9B2")},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeMailEmoji()
{
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst {
        {QStringLiteral(":envelope:"), QString::fromUtf16(u"\U00002709")},
        {QStringLiteral(":e-mail:"), QString::fromUtf16(u"\U0001F4E7")},
        {QStringLiteral(":incoming_envelope:"), QString::fromUtf16(u"\U0001F4E8")},
        {QStringLiteral(":envelope_with_arrow:"), QString::fromUtf16(u"\U0001F4E9")},
        {QStringLiteral(":outbox_tray:"), QString::fromUtf16(u"\U0001F4E4")},
        {QStringLiteral(":inbox_tray:"), QString::fromUtf16(u"\U0001F4E5")},
        {QStringLiteral(":package:"), QString::fromUtf16(u"\U0001F4E6")},
        {QStringLiteral(":closed_mailbox_with_raised_flag:"), QString::fromUtf16(u"\U0001F4EB")},
        {QStringLiteral(":closed_mailbox_with_lowered_flag:"), QString::fromUtf16(u"\U0001F4EA")},
        {QStringLiteral(":open_mailbox_with_raised_flag:"), QString::fromUtf16(u"\U0001F4EC")},
        {QStringLiteral(":open_mailbox_with_lowered_flag:"), QString::fromUtf16(u"\U0001F4ED")},
        {QStringLiteral(":postbox:"), QString::fromUtf16(u"\U0001F4EE")},
        {QStringLiteral(":ballot_box_with_ballot:"), QString::fromUtf16(u"\U0001F5F3")},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeOfficeEmoji()
{
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst {
        {QStringLiteral(":pencil:"), QString::fromUtf16(u"\U0000270F")},
        {QStringLiteral(":black_nib:"), QString::fromUtf16(u"\U00002712")},
        {QStringLiteral(":fountain_pen:"), QString::fromUtf16(u"\U0001F58B")},
        {QStringLiteral(":pen:"), QString::fromUtf16(u"\U0001F58A")},
        {QStringLiteral(":paintbrush:"), QString::fromUtf16(u"\U0001F58C")},
        {QStringLiteral(":crayon:"), QString::fromUtf16(u"\U0001F58D")},
        {QStringLiteral(":memo:"), QString::fromUtf16(u"\U0001F4DD")},
        {QStringLiteral(":briefcase:"), QString::fromUtf16(u"\U0001F4BC")},
        {QStringLiteral(":file_folder:"), QString::fromUtf16(u"\U0001F4C1")},
        {QStringLiteral(":open_file_folder:"), QString::fromUtf16(u"\U0001F4C2")},
        {QStringLiteral(":card_index_dividers:"), QString::fromUtf16(u"\U0001F5C2")},
        {QStringLiteral(":calendar:"), QString::fromUtf16(u"\U0001F4C5")},
        {QStringLiteral(":tear-off_calendar:"), QString::fromUtf16(u"\U0001F4C6")},
        {QStringLiteral(":spiral_notepad:"), QString::fromUtf16(u"\U0001F5D2")},
        {QStringLiteral(":spiral_calendar:"), QString::fromUtf16(u"\U0001F5D3")},
        {QStringLiteral(":card_index:"), QString::fromUtf16(u"\U0001F4C7")},
        {QStringLiteral(":chart_increasing:"), QString::fromUtf16(u"\U0001F4C8")},
        {QStringLiteral(":chart_decreasing:"), QString::fromUtf16(u"\U0001F4C9")},
        {QStringLiteral(":bar_chart:"), QString::fromUtf16(u"\U0001F4CA")},
        {QStringLiteral(":clipboard:"), QString::fromUtf16(u"\U0001F4CB")},
        {QStringLiteral(":pushpin:"), QString::fromUtf16(u"\U0001F4CC")},
        {QStringLiteral(":round_pushpin:"), QString::fromUtf16(u"\U0001F4CD")},
        {QStringLiteral(":paperclip:"), QString::fromUtf16(u"\U0001F4CE")},
        {QStringLiteral(":linked_paperclips:"), QString::fromUtf16(u"\U0001F587")},
        {QStringLiteral(":straight_ruler:"), QString::fromUtf16(u"\U0001F4CF")},
        {QStringLiteral(":triangular_ruler:"), QString::fromUtf16(u"\U0001F4D0")},
        {QStringLiteral(":scissors:"), QString::fromUtf16(u"\U00002702")},
        {QStringLiteral(":card_file_box:"), QString::fromUtf16(u"\U0001F5C3")},
        {QStringLiteral(":file_cabinet:"), QString::fromUtf16(u"\U0001F5C4")},
        {QStringLiteral(":wastebasket:"), QString::fromUtf16(u"\U0001F5D1")},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeToolsEmoji()
{
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst {
        {QStringLiteral(":hammer:"), QString::fromUtf16(u"\U0001F528")},
        {QStringLiteral(":axe:"), QString::fromUtf16(u"\U0001FA93")},
        {QStringLiteral(":pick:"), QString::fromUtf16(u"\U000026CF")},
        {QStringLiteral(":hammer_and_pick:"), QString::fromUtf16(u"\U00002692")},
        {QStringLiteral(":hammer_and_wrench:"), QString::fromUtf16(u"\U0001F6E0")},
        {QStringLiteral(":dagger:"), QString::fromUtf16(u"\U0001F5E1")},
        {QStringLiteral(":crossed_swords:"), QString::fromUtf16(u"\U00002694")},
        {QStringLiteral(":pistol:"), QString::fromUtf16(u"\U0001F52B")},
        {QStringLiteral(":bow_and_arrow:"), QString::fromUtf16(u"\U0001F3F9")},
        {QStringLiteral(":shield:"), QString::fromUtf16(u"\U0001F6E1")},
        {QStringLiteral(":wrench:"), QString::fromUtf16(u"\U0001F527")},
        {QStringLiteral(":nut_and_bolt:"), QString::fromUtf16(u"\U0001F529")},
        {QStringLiteral(":gear:"), QString::fromUtf16(u"\U00002699")},
        {QStringLiteral(":clamp:"), QString::fromUtf16(u"\U0001F5DC")},
        {QStringLiteral(":balance_scale:"), QString::fromUtf16(u"\U00002696")},
        {QStringLiteral(":probing_cane:"), QString::fromUtf16(u"\U0001F9AF")},
        {QStringLiteral(":link:"), QString::fromUtf16(u"\U0001F517")},
        {QStringLiteral(":chains:"), QString::fromUtf16(u"\U000026D3")},
        {QStringLiteral(":toolbox:"), QString::fromUtf16(u"\U0001F9F0")},
        {QStringLiteral(":magnet:"), QString::fromUtf16(u"\U0001F9F2")},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodePhoneEmoji()
{
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst {
        {QStringLiteral(":mobile_phone:"), QString::fromUtf16(u"\U0001F4F1")},
        {QStringLiteral(":mobile_phone_with_arrow:"), QString::fromUtf16(u"\U0001F4F2")},
        {QStringLiteral(":telephone:"), QString::fromUtf16(u"\U0000260E")},
        {QStringLiteral(":telephone_receiver:"), QString::fromUtf16(u"\U0001F4DE")},
        {QStringLiteral(":pager:"), QString::fromUtf16(u"\U0001F4DF")},
        {QStringLiteral(":fax_machine:"), QString::fromUtf16(u"\U0001F4E0")},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeLockEmoji()
{
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst {
        {QStringLiteral(":locked:"), QString::fromUtf16(u"\U0001F512")},
        {QStringLiteral(":unlocked:"), QString::fromUtf16(u"\U0001F513")},
        {QStringLiteral(":locked_with_pen:"), QString::fromUtf16(u"\U0001F50F")},
        {QStringLiteral(":locked_with_key:"), QString::fromUtf16(u"\U0001F510")},
        {QStringLiteral(":key:"), QString::fromUtf16(u"\U0001F511")},
        {QStringLiteral(":old_key:"), QString::fromUtf16(u"\U0001F5DD")},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeDrinkEmoji()
{
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst {
        {QStringLiteral(":baby_bottle:"), QString::fromUtf16(u"\U0001F37C")},
        {QStringLiteral(":glass_of_milk:"), QString::fromUtf16(u"\U0001F95B")},
        {QStringLiteral(":hot_beverage:"), QString::fromUtf16(u"\U00002615")},
        {QStringLiteral(":teacup_without_handle:"), QString::fromUtf16(u"\U0001F375")},
        {QStringLiteral(":sake:"), QString::fromUtf16(u"\U0001F376")},
        {QStringLiteral(":bottle_with_popping_cork:"), QString::fromUtf16(u"\U0001F37E")},
        {QStringLiteral(":wine_glass:"), QString::fromUtf16(u"\U0001F377")},
        {QStringLiteral(":cocktail_glass:"), QString::fromUtf16(u"\U0001F378")},
        {QStringLiteral(":tropical_drink:"), QString::fromUtf16(u"\U0001F379")},
        {QStringLiteral(":beer_mug:"), QString::fromUtf16(u"\U0001F37A")},
        {QStringLiteral(":clinking_beer_mugs:"), QString::fromUtf16(u"\U0001F37B")},
        {QStringLiteral(":clinking_glasses:"), QString::fromUtf16(u"\U0001F942")},
        {QStringLiteral(":tumbler_glass:"), QString::fromUtf16(u"\U0001F943")},
        {QStringLiteral(":cup_with_straw:"), QString::fromUtf16(u"\U0001F964")},
        {QStringLiteral(":beverage_box:"), QString::fromUtf16(u"\U0001F9C3")},
        {QStringLiteral(":mate:"), QString::fromUtf16(u"\U0001F9C9")},
        {QStringLiteral(":ice:"), QString::fromUtf16(u"\U0001F9CA")},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeVideoEmoji()
{
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst {
        {QStringLiteral(":movie_camera:"), QString::fromUtf16(u"\U0001F3A5")},
        {QStringLiteral(":film_frames:"), QString::fromUtf16(u"\U0001F39E")},
        {QStringLiteral(":film_projector:"), QString::fromUtf16(u"\U0001F4FD")},
        {QStringLiteral(":clapper_board:"), QString::fromUtf16(u"\U0001F3AC")},
        {QStringLiteral(":television:"), QString::fromUtf16(u"\U0001F4FA")},
        {QStringLiteral(":camera:"), QString::fromUtf16(u"\U0001F4F7")},
        {QStringLiteral(":camera_with_flash:"), QString::fromUtf16(u"\U0001F4F8")},
        {QStringLiteral(":video_camera:"), QString::fromUtf16(u"\U0001F4F9")},
        {QStringLiteral(":videocassette:"), QString::fromUtf16(u"\U0001F4FC")},
        {QStringLiteral(":magnifying_glass_tilted_left:"), QString::fromUtf16(u"\U0001F50D")},
        {QStringLiteral(":magnifying_glass_tilted_right:"), QString::fromUtf16(u"\U0001F50E")},
        {QStringLiteral(":candle:"), QString::fromUtf16(u"\U0001F56F")},
        {QStringLiteral(":light_bulb:"), QString::fromUtf16(u"\U0001F4A1")},
        {QStringLiteral(":flashlight:"), QString::fromUtf16(u"\U0001F526")},
        {QStringLiteral(":red_paper_lantern:"), QString::fromUtf16(u"\U0001F3EE")},
        {QStringLiteral(":diya_lamp:"), QString::fromUtf16(u"\U0001FA94")},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeHouseEmoji()
{
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst {
        {QStringLiteral(":door:"), QString::fromUtf16(u"\U0001F6AA")},
        {QStringLiteral(":bed:"), QString::fromUtf16(u"\U0001F6CF")},
        {QStringLiteral(":couch_and_lamp:"), QString::fromUtf16(u"\U0001F6CB")},
        {QStringLiteral(":chair:"), QString::fromUtf16(u"\U0001FA91")},
        {QStringLiteral(":toilet:"), QString::fromUtf16(u"\U0001F6BD")},
        {QStringLiteral(":shower:"), QString::fromUtf16(u"\U0001F6BF")},
        {QStringLiteral(":bathtub:"), QString::fromUtf16(u"\U0001F6C1")},
        {QStringLiteral(":razor:"), QString::fromUtf16(u"\U0001FA92")},
        {QStringLiteral(":lotion_bottle:"), QString::fromUtf16(u"\U0001F9F4")},
        {QStringLiteral(":safety_pin:"), QString::fromUtf16(u"\U0001F9F7")},
        {QStringLiteral(":broom:"), QString::fromUtf16(u"\U0001F9F9")},
        {QStringLiteral(":basket:"), QString::fromUtf16(u"\U0001F9FA")},
        {QStringLiteral(":roll_of_paper:"), QString::fromUtf16(u"\U0001F9FB")},
        {QStringLiteral(":soap:"), QString::fromUtf16(u"\U0001F9FC")},
        {QStringLiteral(":sponge:"), QString::fromUtf16(u"\U0001F9FD")},
        {QStringLiteral(":fire_extinguisher:"), QString::fromUtf16(u"\U0001F9EF")},
        {QStringLiteral(":shopping_cart:"), QString::fromUtf16(u"\U0001F6D2")},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeDishwareEmoji()
{
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst {
        {QStringLiteral(":chopsticks:"), QString::fromUtf16(u"\U0001F962")},
        {QStringLiteral(":fork_and_knife_with_plate:"), QString::fromUtf16(u"\U0001F37D")},
        {QStringLiteral(":fork_and_knife:"), QString::fromUtf16(u"\U0001F374")},
        {QStringLiteral(":spoon:"), QString::fromUtf16(u"\U0001F944")},
        {QStringLiteral(":kitchen_knife:"), QString::fromUtf16(u"\U0001F52A")},
        {QStringLiteral(":amphora:"), QString::fromUtf16(u"\U0001F3FA")},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeHotelEmoji()
{
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst {
        {QStringLiteral(":bellhop_bell:"), QString::fromUtf16(u"\U0001F6CE")},
        {QStringLiteral(":luggage:"), QString::fromUtf16(u"\U0001F9F3")},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeAwardMedalEmoji()
{
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst {
        {QStringLiteral(":military_medal:"), QString::fromUtf16(u"\U0001F396")},
        {QStringLiteral(":trophy:"), QString::fromUtf16(u"\U0001F3C6")},
        {QStringLiteral(":sports_medal:"), QString::fromUtf16(u"\U0001F3C5")},
        {QStringLiteral(":1st_place_medal:"), QString::fromUtf16(u"\U0001F947")},
        {QStringLiteral(":2nd_place_medal:"), QString::fromUtf16(u"\U0001F948")},
        {QStringLiteral(":3rd_place_medal:"), QString::fromUtf16(u"\U0001F949")},
    };
    return lst;
}
