
/**
 *
 *  This file is part of the kdewebdev package
 *  Copyright (c) 2002 Keith Isdale <keith@kdewebdev.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/

#include <QTableWidget> 
#include <QLineEdit> 
 
#include "xsldbgsourcesimpl.h" 
#include "xsldbgdebugger.h" 
#include <QDebug>
 
XsldbgSourcesImpl::XsldbgSourcesImpl(XsldbgDebugger *debugger, 
	QWidget *parent /*=0*/) 
		:  QWidget(parent) 
{	
	setupUi(this); 
	this->debugger = debugger; 
	connect(debugger, SIGNAL(sourceItem(QString /* fileName */, QString /* parentFileName */, int /*lineNumber */)), 
		this, SLOT(slotProcSourceItem(QString /* fileName */, QString /* parentFileName */, int /*lineNumber */))); 
		 
	connect( sourcesView,  SIGNAL(itemSelectionChanged()), 
						this, SLOT(itemSelectionChanged())); 
						 
	connect(&resizeTimer, SIGNAL(timeout()), this, SLOT(resizeContents()));
	resizeContents();

	show(); 
	refresh(); 
} 
 
XsldbgSourcesImpl::~XsldbgSourcesImpl(){ 
    debugger = 0L; 
} 
 
void XsldbgSourcesImpl::slotProcSourceItem(QString  fileName , QString  parentFileName , int lineNumber ) 
{
    static int insertPosition = 0;
    if (fileName.isNull()){
        sourcesView->clearContents();
        insertPosition=0;
    }else{
        resizeTimer.stop();
        if (insertPosition >= sourcesView->rowCount())
            sourcesView->insertRow(insertPosition);
        QTableWidgetItem *cellItem;
        for (int column=FileNameColumn; column<=ParentLineNumberColumn; column++){
            cellItem = sourcesView->item(insertPosition, column);
            if (!cellItem)
                sourcesView->setItem(insertPosition, column, new QTableWidgetItem);
            cellItem = sourcesView->item(insertPosition, column);
            if (cellItem){
                switch(column){
                    case FileNameColumn:
                        cellItem->setText(fileName);
                        break;
                    case ParentFileNameColumn:
                        cellItem->setText(parentFileName);
                        break;
                    case ParentLineNumberColumn:
                        if (lineNumber != -1)
                            cellItem->setText(QString::number(lineNumber));
                        else
                            cellItem->setText("");
                        break;
                }
            }
        }
        resizeTimer.start();
        insertPosition++;
    }
}


void XsldbgSourcesImpl::itemSelectionChanged()
{
    QList<QTableWidgetItem *> items = sourcesView->selectedItems();
    if (!items.isEmpty()){
        QString fileName;
        QTableWidgetItem *cellItem;
        for (int i = 0; i < items.size(); ++i) {
            cellItem = items[i];	
            switch(cellItem->column()){
                case FileNameColumn:
                    fileName = cellItem->text();
                    break;

                default:
                    break;
            }
        }
        if (!fileName.isEmpty())
            debugger->gotoLine(fileName, 1);
    }
}

void XsldbgSourcesImpl::resizeContents()
{
   sourcesView->resizeColumnsToContents();
}

void XsldbgSourcesImpl::refresh() 
{ 
	debugger->fakeInput("stylesheets", true) ; 
} 
 
 
 
 

#include "xsldbgsourcesimpl.moc"
