
/**
 *
 *  This file is part of the kdewebdev package
 *  Copyright (c) 2002 Keith Isdale <keith@kdewebdev.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/

#ifndef XSLDBGCALLSTACKIMPL_H 
#define XSLDBGCALLSTACKIMPL_H 
 
/** 
  *@author Keith lsdale 
  */ 
 
#include "ui_xsldbgcallstack.h" 
#include "xsldbgdialogbase.h" 

#include <QWidget>
 
class XsldbgDebugger; 
 
class XsldbgCallStackImpl : public QWidget, Ui::XsldbgCallStack, XsldbgDialogBase   { 
  Q_OBJECT	 
 
public:  
	explicit XsldbgCallStackImpl(XsldbgDebugger *debugger, QWidget *parent=0); 
	~XsldbgCallStackImpl(); 
	// this must match the order of columns in tableWidget
	enum ColumnDataTypes {FrameColumn, FileNameColumn, LineNumberColumn};
	 
public slots:	 
	void itemSelectionChanged();
	 
	/** Process request to add callstack to view, First parameter is QString() 
			to indicate start of callstack list notfication */	 
	void slotProcCallStackItem(QString  templateName, QString  fileName , int  lineNumber );	 

	/** Called to resize the table widget contents after enough time has lapsed */
	void resizeContents();
	 
	/** refresh data from source */ 
	void refresh(); 
	 
 
private: 
	XsldbgDebugger *debugger; 
	 
}; 
 
#endif 
