import copy
import string
from SCons.Debug import logInstanceCreation
import SCons.SConsign
import SCons.Util
pending=1
executing=2
up_to_date=3
executed=4
failed=5
stack=6
implicit_cache=0
implicit_deps_unchanged=0
implicit_deps_changed=0
def do_nothing(node): pass
Annotate=do_nothing
class BuildInfo:
    def __cmp__(self, other):
        return cmp(self.__dict__, other.__dict__)
class Node:
    class Attrs:
        pass
    def __init__(self):
        if __debug__: logInstanceCreation(self, 'Node')
        self.sources=[]
        self.sources_dict={}
        self.depends=[]
        self.depends_dict={}
        self.ignore=[]
        self.ignore_dict={}
        self.implicit=None
        self.waiting_parents=[]
        self.wkids=None
        self.target_scanner=None
        self.source_scanner=None
        self.backup_source_scanner=None
        self.env=None
        self.state=None
        self.precious=None
        self.always_build=None
        self.found_includes={}
        self.includes=None
        self.overrides={}
        self.attributes=self.Attrs()
        self.side_effect=0
        self.side_effects=[]
        self.pre_actions=[]
        self.post_actions=[]
        self.linked=0
        Annotate(self)
    def get_suffix(self):
        return ''
    def generate_build_dict(self):
        return {}
    def get_build_env(self):
        executor=self.get_executor()
        return executor.get_build_env()
    def set_executor(self, executor):
        self.executor=executor
    def get_executor(self, create=1):
        try:
            executor=self.executor
        except AttributeError:
            if not create:
                raise
            import SCons.Executor
            executor=SCons.Executor.Executor(self.builder.action, self.builder.env, [self.builder.overrides], [self], self.sources)
            self.executor=executor
        return executor
    def retrieve_from_cache(self):
        return 0
    def build(self, **kw):
        if not self.has_builder():
            return
        def errfunc(stat, node=self):
            raise SCons.Errors.BuildError(node=node, errstr="Error %d" % stat)
        executor=self.get_executor()
        apply(executor, (self, errfunc), kw)
    def built(self):
        try:
            new_binfo=self.binfo
        except AttributeError:
            pass
        else:
            self.store_info(new_binfo)
        self.found_includes={}
        self.includes=None
        for parent in self.waiting_parents:
            parent.implicit=None
            parent.del_binfo()
        self.waiting_parents=[]
        self.del_cinfo()
    def add_to_waiting_parents(self, node):
        self.waiting_parents.append(node)
    def call_for_all_waiting_parents(self, func):
        func(self)
        for parent in self.waiting_parents:
            parent.call_for_all_waiting_parents(func)
    def postprocess(self):
        try:
            executor=self.get_executor(create=None)
        except AttributeError:
            pass
        else:
            executor.cleanup()
    def clear(self):
        self.set_state(None)
        self.del_binfo()
        self.del_cinfo()
        try:
            delattr(self, '_calculated_sig')
        except AttributeError:
            pass
        self.includes=None
        self.found_includes={}
        self.implicit=None
        self.waiting_parents=[]
    def visited(self):
        pass
    def depends_on(self, nodes):
        for node in nodes:
            if node in self.children():
                return 1
        return 0
    def builder_set(self, builder):
        self.builder=builder
    def has_builder(self):
        try:
            b=self.builder
        except AttributeError:
            self.builder=None
            b=self.builder
        return not b is None
    multiple_side_effect_has_builder=has_builder
    def is_derived(self):
        return self.has_builder() or self.side_effect
    def is_pseudo_derived(self):
        return 0
    def alter_targets(self):
        return [], None
    def get_found_includes(self, env, scanner, target):
        return []
    def get_implicit_deps(self, env, scanner, target):
        if not scanner:
            return []
        scanner=scanner.select(self)
        try:
            recurse=scanner.recursive
        except AttributeError:
            recurse=None
        nodes=[self]
        seen={}
        seen[self]=1
        deps=[]
        while nodes:
           n=nodes.pop(0)
           d=filter(lambda x, seen=seen: not seen.has_key(x),
                      n.get_found_includes(env, scanner, target))
           if d:
               deps.extend(d)
               for n in d:
                   seen[n]=1
               if recurse:
                   nodes.extend(d)
        return deps
    implicit_factory_cache={}
    def implicit_factory(self, path):
        try:
            return self.implicit_factory_cache[path]
        except KeyError:
            n=self.builder.source_factory(path)
            self.implicit_factory_cache[path]=n
            return n
    def get_source_scanner(self, node):
        if self.source_scanner:
            return self.source_scanner
        try:
            scanner=node.builder.source_scanner
            if scanner:
                return scanner
        except AttributeError:
            pass
        return node.backup_source_scanner or None
    def scan(self):
        if not self.implicit is None:
            return
        self.implicit=[]
        self.implicit_dict={}
        self._children_reset()
        if not self.has_builder():
            return
        build_env=self.get_build_env()
        if implicit_cache and not implicit_deps_changed:
            implicit=self.get_stored_implicit()
            if implicit is not None:
                implicit=map(self.implicit_factory, implicit)
                self._add_child(self.implicit, self.implicit_dict, implicit)
                calc=build_env.get_calculator()
                if implicit_deps_unchanged or self.current(calc, scan=0):
                    return
                else:
                    self.implicit=[]
                    self.implicit_dict={}
                    self._children_reset()
                    self.del_binfo()
        for child in self.children(scan=0):
            scanner=self.get_source_scanner(child)
            if scanner:
                deps=child.get_implicit_deps(build_env, scanner, self)
                self._add_child(self.implicit, self.implicit_dict, deps)
        deps=self.get_implicit_deps(build_env, self.target_scanner, self)
        self._add_child(self.implicit, self.implicit_dict, deps)
    def scanner_key(self):
        return None
    def env_set(self, env, safe=0):
        if safe and self.env:
            return
        self.env=env
    def calculator(self):
        import SCons.Defaults
        
        env=self.env or SCons.Defaults.DefaultEnvironment()
        return env.get_calculator()
    def calc_signature(self, calc=None):
        try:
            return self._calculated_sig
        except AttributeError:
            if self.is_derived():
                import SCons.Defaults
                
                env=self.env or SCons.Defaults.DefaultEnvironment()
                if env.use_build_signature():
                    sig=self.calc_bsig(calc)
                else:
                    sig=self.calc_csig(calc)
            elif not self.rexists():
                sig=None
            else:
                sig=self.calc_csig(calc)
            self._calculated_sig=sig
            return sig
    def new_binfo(self):
        return BuildInfo()
    def del_binfo(self):
        try:
            delattr(self, 'binfo')
        except AttributeError:
            pass
    def calc_bsig(self, calc=None):
        try:
            return self.binfo.bsig
        except AttributeError:
            self.binfo=self.gen_binfo(calc)
            return self.binfo.bsig
    def gen_binfo(self, calc=None, scan=1):
        if calc is None:
            calc=self.calculator()
        binfo=self.new_binfo()
        if scan:
            self.scan()
        sources=self.filter_ignore(self.sources)
        depends=self.filter_ignore(self.depends)
        if self.implicit is None:
            implicit=[]
        else:
            implicit=self.filter_ignore(self.implicit)
        def calc_signature(node, calc=calc):
            return node.calc_signature(calc)
        sourcesigs=map(calc_signature, sources)
        dependsigs=map(calc_signature, depends)
        implicitsigs=map(calc_signature, implicit)
        sigs=sourcesigs + dependsigs + implicitsigs
        if self.has_builder():
            executor=self.get_executor()
            binfo.bact=executor.get_contents()
            binfo.bactsig=calc.module.signature(executor)
            sigs.append(binfo.bactsig)
        binfo.bsources=map(str, sources)
        binfo.bdepends=map(str, depends)
        binfo.bimplicit=map(str, implicit)
        binfo.bsourcesigs=sourcesigs
        binfo.bdependsigs=dependsigs
        binfo.bimplicitsigs=implicitsigs
        binfo.bsig=calc.module.collect(filter(None, sigs))
        return binfo
    def del_cinfo(self):
        try:
            del self.binfo.csig
        except AttributeError:
            pass
    def calc_csig(self, calc=None):
        try:
            binfo=self.binfo
        except AttributeError:
            binfo=self.binfo=self.new_binfo()
        try:
            return binfo.csig
        except AttributeError:
            if calc is None:
                calc=self.calculator()
            binfo.csig=calc.module.signature(self)
            self.store_info(binfo)
            return binfo.csig
    def store_info(self, obj):
        pass
    def get_stored_info(self):
        return None
    def get_stored_implicit(self):
        return None
    def set_precious(self, precious=1):
        self.precious=precious
    def set_always_build(self, always_build=1):
        self.always_build=always_build
    def exists(self):
        return 1
    def rexists(self):
        return self.exists()
    def prepare(self):
        def missing(node):
            return not node.is_derived() and \
                   not node.is_pseudo_derived() and \
                   not node.linked and \
                   not node.rexists()
        missing_sources=filter(missing, self.children())
        if missing_sources:
            desc="Source `%s' not found, needed by target `%s'." % (missing_sources[0], self)
            raise SCons.Errors.StopError, desc
    def remove(self):
        return None
    def add_dependency(self, depend):
        try:
            self._add_child(self.depends, self.depends_dict, depend)
        except TypeError, e:
            e=e.args[0]
            if SCons.Util.is_List(e):
                s=map(str, e)
            else:
                s=str(e)
            raise SCons.Errors.UserError("attempted to add a non-Node dependency to %s:\n\t%s is a %s, not a Node" % (str(self), s, type(e)))
    def add_ignore(self, depend):
        try:
            self._add_child(self.ignore, self.ignore_dict, depend)
        except TypeError, e:
            e=e.args[0]
            if SCons.Util.is_List(e):
                s=map(str, e)
            else:
                s=str(e)
            raise SCons.Errors.UserError("attempted to ignore a non-Node dependency of %s:\n\t%s is a %s, not a Node" % (str(self), s, type(e)))
    def add_source(self, source):
        try:
            self._add_child(self.sources, self.sources_dict, source)
        except TypeError, e:
            e=e.args[0]
            if SCons.Util.is_List(e):
                s=map(str, e)
            else:
                s=str(e)
            raise SCons.Errors.UserError("attempted to add a non-Node as source of %s:\n\t%s is a %s, not a Node" % (str(self), s, type(e)))
    def _add_child(self, collection, dict, child):
        if type(child) is not type([]):
            child=[child]
        for c in child:
            if not isinstance(c, Node):
                raise TypeError, c
        added=None
        for c in child:
            if not dict.has_key(c):
                collection.append(c)
                dict[c]=1
                added=1
        if added:
            self._children_reset()
    def add_wkid(self, wkid):
        if self.wkids != None:
            self.wkids.append(wkid)
    def _children_reset(self):
        try:
            delattr(self, '_children')
        except AttributeError:
            pass
    def filter_ignore(self, nodelist):
        ignore=self.ignore
        result=[]
        for node in nodelist:
            if node not in ignore:
                result.append(node)
        return result
    def children(self, scan=1):
        if scan:
            self.scan()
        try:
            return self._children
        except AttributeError:
            c=self.all_children(scan=0)
            self._children=self.filter_ignore(c)
            return self._children
    def all_children(self, scan=1):
        if scan:
            self.scan()
        if self.implicit is None:
            return self.sources + self.depends
        else:
            return self.sources + self.depends + self.implicit
    def set_state(self, state):
        self.state=state
    def get_state(self):
        return self.state
    def current(self, calc=None):
        return None
    def children_are_up_to_date(self, calc=None):
        self.binfo=self.gen_binfo(calc)
        state=0
        for kid in self.children(None):
            s=kid.get_state()
            if s and (not state or s > state):
                state=s
        return (state==0 or state==SCons.Node.up_to_date)
    def is_literal(self):
        return 1
    def add_pre_action(self, act):
        self.pre_actions.append(act)
    def add_post_action(self, act):
        self.post_actions.append(act)
    def render_include_tree(self):
        if self.is_derived() and self.env:
            env=self.get_build_env()
            for s in self.sources:
                scanner=s.get_source_scanner(self)
                def f(node, env=env, scanner=scanner, target=self):
                    return node.get_found_includes(env, scanner, target)
                return SCons.Util.render_tree(s, f, 1)
        else:
            return None
    def get_abspath(self):
        return str(self)
    def for_signature(self):
        return str(self)
    def get_string(self, for_signature):
        if for_signature:
            return self.for_signature()
        return str(self)
    def get_subst_proxy(self):
        return self
    def explain(self):
        if not self.exists():
            return "building `%s' because it doesn't exist\n" % self
        old=self.get_stored_info()
        if old is None:
            return None
        def dictify(result, kids, sigs):
            for k, s in zip(kids, sigs):
                result[k]=s
        try:
            old_bkids=old.bsources + old.bdepends + old.bimplicit
        except AttributeError:
            return "Cannot explain why `%s' is being rebuilt: No previous build information found\n" % self
        osig={}
        dictify(osig, old.bsources, old.bsourcesigs)
        dictify(osig, old.bdepends, old.bdependsigs)
        dictify(osig, old.bimplicit, old.bimplicitsigs)
        new_bsources=map(str, self.binfo.bsources)
        new_bdepends=map(str, self.binfo.bdepends)
        new_bimplicit=map(str, self.binfo.bimplicit)
        nsig={}
        dictify(nsig, new_bsources, self.binfo.bsourcesigs)
        dictify(nsig, new_bdepends, self.binfo.bdependsigs)
        dictify(nsig, new_bimplicit, self.binfo.bimplicitsigs)
        new_bkids=new_bsources + new_bdepends + new_bimplicit
        lines=map(lambda x: "`%s' is no longer a dependency\n" % x,
                    filter(lambda x, nk=new_bkids: not x in nk, old_bkids))
        for k in new_bkids:
            if not k in old_bkids:
                lines.append("`%s' is a new dependency\n" % k)
            elif osig[k] != nsig[k]:
                lines.append("`%s' changed\n" % k)
        if len(lines)==0 and old_bkids != new_bkids:
            lines.append("the dependency order changed:\n" +
                         "%sold: %s\n" % (' '*15, old_bkids) +
                         "%snew: %s\n" % (' '*15, new_bkids))
        if len(lines)==0:
            newact, newactsig=self.binfo.bact, self.binfo.bactsig
            if old.bact != newact:
                lines.append("the build action changed:\n" +
                             "%sold: %s\n" % (' '*15, old.bact) +
                             "%snew: %s\n" % (' '*15, newact))
        if len(lines)==0:
            return "rebuilding `%s' for unknown reasons" % self
        preamble="rebuilding `%s' because" % self
        if len(lines)==1:
            return "%s %s"  % (preamble, lines[0])
        else:
            lines=["%s:\n" % preamble] + lines
            return string.join(lines, ' '*11)
def get_children(node, parent): return node.children()
def ignore_cycle(node, stack): pass
def do_nothing(node, parent): pass
class Walker:
    def __init__(self, node, kids_func=get_children, cycle_func=ignore_cycle, eval_func=do_nothing):
        self.kids_func=kids_func
        self.cycle_func=cycle_func
        self.eval_func=eval_func
        node.wkids=copy.copy(kids_func(node, None))
        self.stack=[node]
        self.history={}
        self.history[node]=None
    def next(self):
        while self.stack:
            if self.stack[-1].wkids:
                node=self.stack[-1].wkids.pop(0)
                if not self.stack[-1].wkids:
                    self.stack[-1].wkids=None
                if self.history.has_key(node):
                    self.cycle_func(node, self.stack)
                else:
                    node.wkids=copy.copy(self.kids_func(node, self.stack[-1]))
                    self.stack.append(node)
                    self.history[node]=None
            else:
                node=self.stack.pop()
                del self.history[node]
                if node:
                    if self.stack:
                        parent=self.stack[-1]
                    else:
                        parent=None
                    self.eval_func(node, parent)
                return node
        return None
    def is_done(self):
        return not self.stack
arg2nodes_lookups=[]
