/* -*- mode:c -*-
 *
 * Copyright 2016 The Chromium OS Authors. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

/* Declare symbolic names for all the GPIOs that we care about.
 * Note: Those with interrupt handlers must be declared first. */

/* Outputs */
GPIO(MUX_EN_L,			PIN(A, 7),  GPIO_INPUT)
GPIO(USB_MUX_SEL,		PIN(A, 6),  GPIO_OUT_HIGH)
GPIO(PHY_RESET,			PIN(C, 4),  GPIO_INPUT)
GPIO(LED_BLUE,			PIN(A, 2),  GPIO_ODR_LOW)
GPIO(LED_GRN,			PIN(B, 8),  GPIO_ODR_LOW)
GPIO(LED_RED,			PIN(B, 15), GPIO_ODR_LOW)

/* Inputs */
GPIO(GPIO_1,  			PIN(A, 1), GPIO_INPUT)
GPIO(GPIO_2,  			PIN(A, 0), GPIO_INPUT)

/* Clock function */
GPIO(MCU_TO_PHY_MCO,		PIN(C, 9), GPIO_INPUT)


/* GPIO to DUT */
GPIO(DUT_XTAL_STATUS_3V3,	PIN(D, 8), GPIO_INPUT)
GPIO(DUT_TO_MCU_1_3V3,		PIN(D, 9), GPIO_INPUT)
GPIO(DUT_TO_MCU_2_3V3,		PIN(D, 10), GPIO_INPUT)
GPIO(MCU_TO_DUT_INT_3V3,	PIN(D, 12), GPIO_INPUT)

/* I2C pins should be configured as inputs until I2C module is    */
/* initialized. This will avoid driving the lines unintentionally.*/
GPIO(I2C1_SCL,			PIN(B, 6), GPIO_INPUT)
GPIO(I2C1_SDA,			PIN(B, 7), GPIO_INPUT)
GPIO(I2C2_SCL,			PIN(F, 1), GPIO_INPUT)
GPIO(I2C2_SDA,			PIN(F, 0), GPIO_INPUT)
GPIO(I2C3_SCL,			PIN(A, 8), GPIO_INPUT)
GPIO(I2C3_SDA,			PIN(B, 4), GPIO_INPUT)
GPIO(FMPI2C_SCL,		PIN(C, 6), GPIO_INPUT)
GPIO(FMPI2C_SDA,		PIN(C, 7), GPIO_INPUT)

/* These pin assignments aren't used as GPIO. Let's note them here
 * for readability but not initialize them.
 * USART3 TX/RX
 * GPIO(MCU_UART3_TX,		PIN(C, 10), GPIO_INPUT)
 * GPIO(MCU_UART3_RX,		PIN(C, 11), GPIO_INPUT)
 * USART4 TX/RX
 * GPIO(MCU_UART4_TX,		PIN(A, 0), GPIO_INPUT)
 * GPIO(MCU_UART4_RX,		PIN(A, 1), GPIO_INPUT)
 */

/* USB pins */
GPIO(USB_FS_DM,			PIN(A, 11), GPIO_INPUT)
GPIO(USB_FS_DP,			PIN(A, 12), GPIO_INPUT)

GPIO(USB_HS_ULPI_NXT,		PIN(C, 3), GPIO_INPUT)
GPIO(USB_HS_ULPI_DIR,		PIN(C, 2), GPIO_INPUT)
GPIO(USB_HS_ULPI_STP,		PIN(C, 0), GPIO_INPUT)
GPIO(USB_HS_ULPI_CK,		PIN(A, 5), GPIO_INPUT)

GPIO(USB_HS_ULPI_D7,		PIN(B, 5), GPIO_INPUT)
GPIO(USB_HS_ULPI_D6,		PIN(B,13), GPIO_INPUT)
GPIO(USB_HS_ULPI_D5,		PIN(B,12), GPIO_INPUT)
GPIO(USB_HS_ULPI_D4,		PIN(B, 2), GPIO_INPUT)
GPIO(USB_HS_ULPI_D3,		PIN(B,10), GPIO_INPUT)
GPIO(USB_HS_ULPI_D2,		PIN(B, 1), GPIO_INPUT)
GPIO(USB_HS_ULPI_D1,		PIN(B, 0), GPIO_INPUT)
GPIO(USB_HS_ULPI_D0,		PIN(A, 3), GPIO_INPUT)


/* Unimplemented signals since we are not an EC */
UNIMPLEMENTED(ENTERING_RW)
UNIMPLEMENTED(WP_L)


ALTERNATE(PIN_MASK(C, 0x0c00), 7, MODULE_UART, 0) /* USART3: PC10/PC11 - Console */
ALTERNATE(PIN_MASK(A, 0x0003), 8, MODULE_UART, 0) /* USART4: PA0/PA1 - Console */

ALTERNATE(PIN_MASK(B, 0x00c0), 4, MODULE_I2C, GPIO_ODR_HIGH | GPIO_PULL_UP) /* I2C1 MASTER:PB6/7 */
ALTERNATE(PIN_MASK(F, 0x0003), 4, MODULE_I2C, GPIO_ODR_HIGH | GPIO_PULL_UP) /* I2C2 MASTER:PF1/0 */
ALTERNATE(PIN_MASK(A, 0x0100), 4, MODULE_I2C, GPIO_ODR_HIGH | GPIO_PULL_UP) /* I2C3 MASTER:PA8 */
ALTERNATE(PIN_MASK(B, 0x0010), 4, MODULE_I2C, GPIO_ODR_HIGH | GPIO_PULL_UP) /* I2C3 MASTER:PB4 */
ALTERNATE(PIN_MASK(C, 0x00c0), 4, MODULE_I2C, GPIO_ODR_HIGH | GPIO_PULL_UP) /* FMPI2C MASTER:PC6/7 */

/* OTG FS */
ALTERNATE(PIN_MASK(A, 0x1800), 10, MODULE_USB, 0) /* DWC USB OTG: PA11/12 */

/* OTG HS */
ALTERNATE(PIN_MASK(A, 0x0028), 10, MODULE_USB, 0) /* DWC USB OTG HS */
ALTERNATE(PIN_MASK(B, 0x3427), 10, MODULE_USB, 0) /* DWC USB OTG HS */
ALTERNATE(PIN_MASK(C, 0x000d), 10, MODULE_USB, 0) /* DWC USB OTG HS */
ALTERNATE(PIN_MASK(C, 0x0200), 0, MODULE_MCO, 0) /* MCO2: PC9 */
