/* -*- mode:c -*-
 *
 * Copyright 2020 The Chromium OS Authors. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

/*
 * Declare symbolic names for all the GPIOs that we care about.
 * Note: Those with interrupt handlers must be declared first.
 */

/* Power Interrupts */
GPIO_INT(SLP_S0_L,		 PIN(D, 5), GPIO_INT_BOTH, power_signal_interrupt)
GPIO_INT(SLP_S3_L,		 PIN(A, 5), GPIO_INT_BOTH, baseboard_all_sys_pgood_interrupt)
GPIO_INT(SLP_S4_L,		 PIN(D, 4), GPIO_INT_BOTH, power_signal_interrupt)
GPIO_INT(SLP_SUS_L,		 PIN(D, 7), GPIO_INT_BOTH, power_signal_interrupt)
GPIO_INT(RSMRST_PWRGD_L,	 PIN(C, 6), GPIO_INT_BOTH, power_signal_interrupt)
GPIO_INT(VCCIN_AUX_VID1,	 PIN(C, 7), GPIO_INT_BOTH, power_signal_interrupt)
GPIO_INT(CPU_C10_GATE_L,	 PIN(6, 7), GPIO_INT_BOTH, power_signal_interrupt)
GPIO_INT(VCCIN_AUX_VID0,	 PIN(F, 4), GPIO_INT_BOTH | GPIO_SEL_1P8V, power_signal_interrupt)
GPIO_INT(PG_VCCIO_EXT_OD,	 PIN(B, 0), GPIO_INT_BOTH, baseboard_all_sys_pgood_interrupt)
GPIO_INT(PG_PP5000_U_OD,	 PIN(E, 2), GPIO_INT_BOTH, power_signal_interrupt)
GPIO_INT(PG_DRAM_OD,		 PIN(E, 4), GPIO_INT_BOTH, baseboard_all_sys_pgood_interrupt)
GPIO_INT(PG_PP1050_ST_OD,	 PIN(4, 2), GPIO_INT_BOTH, power_signal_interrupt)

/* USB-C interrupts */
GPIO_INT(USB_C0_INT_ODL,	 		PIN(6, 2), GPIO_INT_FALLING | GPIO_PULL_UP, usb_c0_interrupt)
GPIO_INT(SUB_C1_INT_EN_RAILS_ODL,		PIN(F, 5), GPIO_INT_FALLING | GPIO_PULL_UP, sub_usb_c1_interrupt) /* C1 interrupt OR 5V power en */
GPIO_INT(EC_I2C_SUB_C1_SDA_HDMI_HPD_ODL,	PIN(9, 1), GPIO_INT_BOTH, sub_hdmi_hpd_interrupt) /* C1 I2C SDA OR HDMI_HPD */

/* Button interrupts */
GPIO_INT(H1_EC_PWR_BTN_ODL,	 PIN(0, 1), GPIO_INT_BOTH | GPIO_PULL_UP, power_button_interrupt)
GPIO_INT(VOLDN_BTN_ODL,		 PIN(4, 0), GPIO_INT_BOTH | GPIO_PULL_UP, button_interrupt)
GPIO_INT(VOLUP_BTN_ODL,		 PIN(7, 3), GPIO_INT_BOTH | GPIO_PULL_UP, button_interrupt)

/* Other interrupts */
GPIO_INT(LID_OPEN,		 PIN(D, 2), GPIO_INT_BOTH, lid_interrupt)
GPIO_INT(EC_WP_OD,		 PIN(A, 1), GPIO_INT_BOTH, switch_interrupt)
GPIO_INT(BASE_SIXAXIS_INT_L,	 PIN(5, 6), GPIO_INT_FALLING | GPIO_SEL_1P8V, bmi160_interrupt)
GPIO_INT(LID_360_L,		 PIN(9, 5), GPIO_INT_BOTH, gmr_tablet_switch_isr)

/* I2C Ports */
GPIO(EC_I2C_EEPROM_SCL,			PIN(B, 3), GPIO_INPUT)
GPIO(EC_I2C_EEPROM_SDA,			PIN(B, 2), GPIO_INPUT)
GPIO(EC_I2C_BATTERY_SCL,		PIN(3, 3), GPIO_INPUT)
GPIO(EC_I2C_BATTERY_SDA,		PIN(3, 6), GPIO_INPUT)
GPIO(EC_I2C_SENSOR_SCL,			PIN(B, 5), GPIO_INPUT)
GPIO(EC_I2C_SENSOR_SDA,			PIN(B, 4), GPIO_INPUT)
GPIO(EC_I2C_USB_C0_SCL,			PIN(9, 0), GPIO_INPUT)
GPIO(EC_I2C_USB_C0_SDA,			PIN(8, 7), GPIO_INPUT)
GPIO(EC_I2C_SUB_C1_SCL_HDMI_EN_ODL,	PIN(9, 2), GPIO_INPUT) /* C1 I2C SCL OR HDMI en */

/* Extra Sub-board I/O pins */
GPIO(EC_SUB_IO_1,  PIN(3, 7), GPIO_OUT_LOW)
GPIO(EC_SUB_IO_2,  PIN(3, 4), GPIO_OUT_LOW)

/* Misc Enables */
GPIO(EN_VCCIO_EXT,   PIN(6, 1), GPIO_OUT_LOW)
/* TODO(b:149775160) - Modify if needed if we ever use this signal. */
GPIO(EN_VCCST,		PIN(A, 7), GPIO_INPUT)
GPIO(EN_PP3300_PEN,	PIN(6, 3), GPIO_OUT_LOW)
GPIO(EN_PP3300_A,	PIN(0, 3), GPIO_OUT_LOW)
GPIO(EN_PP5000_U,	PIN(A, 4), GPIO_OUT_LOW)
GPIO(EN_SLP_Z,		PIN(8, 3), GPIO_OUT_LOW)
GPIO(EN_KB_BL,		PIN(6, 0), GPIO_OUT_LOW)
GPIO(EN_BL_OD,		PIN(D, 3), GPIO_ODR_LOW)
GPIO(IMVP9_PE,		PIN(E, 0), GPIO_OUT_LOW)
GPIO(ECH1_PACKET_MODE,	PIN(7, 5), GPIO_OUT_LOW)

/* Power Sequencing */
GPIO(EC_AP_PSYS,	     PIN(B, 7), GPIO_OUT_LOW)
GPIO(EC_AP_RSMRST_L,         PIN(A, 6), GPIO_OUT_LOW)
GPIO(EC_AP_PWR_BTN_ODL,      PIN(C, 1), GPIO_ODR_HIGH)
GPIO(EC_AP_RTCRST,           PIN(7, 6), GPIO_OUT_LOW)
GPIO(EC_AP_WAKE_ODL,         PIN(7, 4), GPIO_ODR_HIGH)
GPIO(EC_AP_DPWROK,	     PIN(A, 3), GPIO_OUT_LOW)
GPIO(EC_AP_PCH_PWROK_OD,     PIN(9, 4), GPIO_ODR_LOW)
GPIO(EC_AP_VCCST_PWRGD_OD,   PIN(B, 1), GPIO_ODR_LOW)
GPIO(EC_AP_SYS_PWROK,	     PIN(0, 2), GPIO_OUT_LOW)
GPIO(EC_AP_MKBP_INT_L,	     PIN(7, 0), GPIO_ODR_HIGH)
GPIO(EC_PROCHOT_ODL,	     PIN(F, 1), GPIO_ODR_HIGH | GPIO_SEL_1P8V)
GPIO(EC_ENTERING_RW,	     PIN(E, 3), GPIO_OUT_LOW)
GPIO(ALL_SYS_PWRGD,	     PIN(A, 0), GPIO_OUT_LOW)
GPIO(SYS_RST_ODL,	     PIN(C, 5), GPIO_ODR_HIGH)
GPIO(CCD_MODE_ODL,	     PIN(E, 5), GPIO_ODR_HIGH)

GPIO(USB_C0_RST_ODL,	     PIN(9, 7), GPIO_OUT_HIGH) /* currently unused */
GPIO(EC_AP_USB_C1_HDMI_HPD,  PIN(9, 6), GPIO_OUT_LOW)
GPIO(EC_AP_USB_C0_HPD,	     PIN(9, 3), GPIO_OUT_LOW)
GPIO(HDMI_SEL_L,	     PIN(7, 2), GPIO_OUT_HIGH)
GPIO(EC_BATTERY_PRES_ODL,    PIN(E, 1), GPIO_INPUT)

/*
 * Waddledoo doesn't have these physical pins coming to the EC but uses other
 * logic.
 */
UNIMPLEMENTED(AC_PRESENT)
UNIMPLEMENTED(PG_EC_DSW_PWROK)
UNIMPLEMENTED(PG_EC_ALL_SYS_PWRGD)

/* Alternate Functions */
/* ADC */
ALTERNATE(PIN_MASK(F, BIT(0)), 0, MODULE_ADC, 0) /* ADC9 */
ALTERNATE(PIN_MASK(4, 0x38), 0, MODULE_ADC, 0)   /* ADC0-2 */

/* Keyboard */
ALTERNATE(PIN_MASK(3, 0x03), 0, MODULE_KEYBOARD_SCAN, GPIO_INPUT | GPIO_PULL_UP) /* KSI0, KSI1 */
ALTERNATE(PIN_MASK(2, 0xFC), 0, MODULE_KEYBOARD_SCAN, GPIO_INPUT | GPIO_PULL_UP) /* KSI2-7 */
ALTERNATE(PIN_MASK(2, 0x03), 0, MODULE_KEYBOARD_SCAN, GPIO_ODR_HIGH)		 /* KSO0, KSO1 */
ALTERNATE(PIN_MASK(1, 0x7F), 0, MODULE_KEYBOARD_SCAN, GPIO_ODR_HIGH)		 /* KSO3-9 */
ALTERNATE(PIN_MASK(0, 0xF0), 0, MODULE_KEYBOARD_SCAN, GPIO_ODR_HIGH)		 /* KSO10-13 */
ALTERNATE(PIN_MASK(8, 0x04), 0, MODULE_KEYBOARD_SCAN, GPIO_ODR_HIGH)		 /* KSO14 */
GPIO(EC_KSO_02_INV, PIN(1, 7), GPIO_OUT_LOW)	/* KSO2 inverted */

/* PWM */
ALTERNATE(PIN_MASK(C, 0x1C), 0, MODULE_PWM, 0)   /* PWM0-2 */
ALTERNATE(PIN_MASK(8, BIT(0)), 0, MODULE_PWM, 0) /* PWM3 */

/* UART */
ALTERNATE(PIN_MASK(6, 0x30), 0, MODULE_UART, 0)  /* UART1 */

/* I2C */
ALTERNATE(PIN_MASK(B, 0x3C), 0, MODULE_I2C, 0)   /* I2C7,I2C0 */
ALTERNATE(PIN_MASK(3, 0x48), 0, MODULE_I2C, 0)   /* I2C5 */
ALTERNATE(PIN_MASK(9, 0x07), 0, MODULE_I2C, 0)   /* I2C2, I2C1 SCL */
ALTERNATE(PIN_MASK(8, 0x80), 0, MODULE_I2C, 0)   /* I2C1 SDA */

/* NC pins, enable internal pull-up to avoid floating state. */
GPIO(GPIO32_NC, PIN(3, 2), GPIO_INPUT | GPIO_PULL_UP)
GPIO(GPIO35_NC, PIN(3, 5), GPIO_INPUT | GPIO_PULL_UP)
GPIO(GPIO41_NC, PIN(4, 1), GPIO_INPUT | GPIO_PULL_UP)
GPIO(GPIO57_NC, PIN(5, 7), GPIO_INPUT | GPIO_PULL_UP)
GPIO(GPIO81_NC, PIN(8, 1), GPIO_INPUT | GPIO_PULL_UP)
GPIO(GPIO86_NC, PIN(8, 6), GPIO_INPUT | GPIO_PULL_UP)
GPIO(GPIOC0_NC, PIN(C, 0), GPIO_INPUT | GPIO_PULL_UP)
GPIO(GPIOD0_NC, PIN(D, 0), GPIO_INPUT | GPIO_PULL_UP)
GPIO(GPIOD1_NC, PIN(D, 1), GPIO_INPUT | GPIO_PULL_UP)
GPIO(GPIOD6_NC, PIN(D, 6), GPIO_INPUT | GPIO_PULL_UP)
