// This file is part of The New Aspell
// Copyright (C) 2001 by Kevin Atkinson under the GNU LGPL license
// version 2.0 or 2.1.  You should have received a copy of the LGPL
// license along with this library if you did not you can find
// it at http://www.gnu.org/.

#ifndef ASPELL_FILE_UTIL__HPP
#define ASPELL_FILE_UTIL__HPP

#include <time.h>

#include "string.hpp"
#include "posib_err.hpp"

namespace acommon {

  class FStream;

  bool ASPELL_API need_dir(ParmString file);
  String ASPELL_API add_possible_dir(ParmString dir, ParmString file);
  String ASPELL_API figure_out_dir(ParmString dir, ParmString file);

  // FIXME: Possible remove
  //void open_file(FStream & in, const string & file,
  //               ParmString mode = "r");
  time_t ASPELL_API get_modification_time(FStream & f);
  PosibErr<void> ASPELL_API open_file_readlock(FStream& in, ParmString file);
  PosibErr<bool> ASPELL_API open_file_writelock(FStream & in, ParmString file);
  // returns true if the file already exists
  void ASPELL_API truncate_file(FStream & f, ParmString name);
  bool ASPELL_API remove_file(ParmString name);
  bool ASPELL_API file_exists(ParmString name);
  bool ASPELL_API rename_file(ParmString orig, ParmString new_name);
  // will return NULL if path is NULL.
  const char * get_file_name(const char * path);
}
#endif
