;;; py-ert-execute-block-test.el --- py-execute-block tests

;; URL: https://gitlab.com/python-mode-devs
;; Keywords: languages, convenience

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

;;; Commentary:

;; This file is generated by function from python-mode-utils.el - see in
;; directory devel. Edits here might not be persistent.

;;; Code:

(ert-deftest py-ert-execute-block-python-test ()
  (let ((buffer (py--choose-buffer-name "python")))
    (py-test
        "if True:
    print(\"one\")
    print(\"two\")"
      (py-execute-block-python)
      (set-buffer buffer)
      (should (search-backward "two")))))

(ert-deftest py-ert-execute-block-python2-test ()
  (let ((buffer (py--choose-buffer-name "python2")))
    (py-test
        "if True:
    print(\"one\")
    print(\"two\")"
      (py-execute-block-python2)
      (set-buffer buffer)
      (should (search-backward "two")))))

(ert-deftest py-ert-execute-block-python3-test ()
  (let ((buffer (py--choose-buffer-name "python3")))
    (py-test
        "if True:
    print(\"one\")
    print(\"two\")"
      (py-execute-block-python3)
      (set-buffer buffer)
      (should (search-backward "two")))))

(ert-deftest py-ert-execute-block-ipython-test ()
  (let ((buffer (py--choose-buffer-name "ipython")))
    (py-test
        "if True:
    print(\"one\")
    print(\"two\")"
      (py-execute-block-ipython)
      (set-buffer buffer)
      (should (search-backward "two")))))

(ert-deftest py-ert-execute-block-ipython3-test ()
  (let ((buffer (py--choose-buffer-name "ipython3")))
    (py-test
        "if True:
    print(\"one\")
    print(\"two\")"
      (py-execute-block-ipython3)
      (set-buffer buffer)
      (should (search-backward "two")))))

(provide 'py-ert-execute-block-test)
;;; py-ert-execute-block-test.el here
