# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import sys
from typing import Any, Callable, Dict, IO, List, Optional, TypeVar, Union, cast, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .._serialization import Serializer
from .._vendor import _format_url_section

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_enrollment_get_request(id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2021-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/enrollments/{id}"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_enrollment_create_or_update_request(id: str, *, if_match: Optional[str] = None, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2021-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/enrollments/{id}"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_enrollment_delete_request(id: str, *, if_match: Optional[str] = None, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2021-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/enrollments/{id}"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_enrollment_query_request(
    *, x_ms_max_item_count: Optional[int] = None, x_ms_continuation: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2021-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/enrollments/query"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if x_ms_max_item_count is not None:
        _headers["x-ms-max-item-count"] = _SERIALIZER.header("x_ms_max_item_count", x_ms_max_item_count, "int")
    if x_ms_continuation is not None:
        _headers["x-ms-continuation"] = _SERIALIZER.header("x_ms_continuation", x_ms_continuation, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_enrollment_get_attestation_mechanism_request(id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2021-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/enrollments/{id}/attestationmechanism"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_enrollment_run_bulk_operation_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2021-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/enrollments"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_enrollment_group_get_request(id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2021-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/enrollmentGroups/{id}"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_enrollment_group_create_or_update_request(
    id: str, *, if_match: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2021-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/enrollmentGroups/{id}"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, params=_params, headers=_headers, **kwargs)


def build_enrollment_group_delete_request(id: str, *, if_match: Optional[str] = None, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2021-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/enrollmentGroups/{id}"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_enrollment_group_query_request(
    *, x_ms_max_item_count: Optional[int] = None, x_ms_continuation: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2021-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/enrollmentGroups/query"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if x_ms_max_item_count is not None:
        _headers["x-ms-max-item-count"] = _SERIALIZER.header("x_ms_max_item_count", x_ms_max_item_count, "int")
    if x_ms_continuation is not None:
        _headers["x-ms-continuation"] = _SERIALIZER.header("x_ms_continuation", x_ms_continuation, "str")
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_enrollment_group_get_attestation_mechanism_request(id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2021-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/enrollmentGroups/{id}/attestationmechanism"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_enrollment_group_run_bulk_operation_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2021-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/enrollmentGroups"

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_device_registration_state_get_request(id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2021-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/registrations/{id}"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_device_registration_state_delete_request(
    id: str, *, if_match: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2021-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/registrations/{id}"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if if_match is not None:
        _headers["If-Match"] = _SERIALIZER.header("if_match", if_match, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, params=_params, headers=_headers, **kwargs)


def build_device_registration_state_query_request(
    id: str, *, x_ms_max_item_count: Optional[int] = None, x_ms_continuation: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2021-10-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/registrations/{id}/query"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if x_ms_max_item_count is not None:
        _headers["x-ms-max-item-count"] = _SERIALIZER.header("x_ms_max_item_count", x_ms_max_item_count, "int")
    if x_ms_continuation is not None:
        _headers["x-ms-continuation"] = _SERIALIZER.header("x_ms_continuation", x_ms_continuation, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


class EnrollmentOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.iot.deviceprovisioning.DeviceProvisioningClient`'s
        :attr:`enrollment` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def get(self, id: str, **kwargs: Any) -> JSON:
        """Get a device enrollment record.

        Get a device enrollment record.

        :param id: This id is used to uniquely identify a device registration of an enrollment. A
         case-insensitive string (up to 128 characters long) of alphanumeric characters plus certain
         special characters : . _ -. No special characters allowed at start or end. Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "attestation": {
                        "type": "str",  # Attestation Type. Required. Known values are:
                          "none", "tpm", "x509", and "symmetricKey".
                        "symmetricKey": {
                            "primaryKey": "str",  # Optional. Primary symmetric key.
                            "secondaryKey": "str"  # Optional. Secondary symmetric key.
                        },
                        "tpm": {
                            "endorsementKey": "str",  # Required.
                            "storageRootKey": "str"  # Optional. TPM attestation method.
                        },
                        "x509": {
                            "caReferences": {
                                "primary": "str",  # Optional. Primary and secondary
                                  CA references.
                                "secondary": "str"  # Optional. Primary and secondary
                                  CA references.
                            },
                            "clientCertificates": {
                                "primary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                },
                                "secondary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                }
                            },
                            "signingCertificates": {
                                "primary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                },
                                "secondary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                }
                            }
                        }
                    },
                    "registrationId": "str",  # This id is used to uniquely identify a device
                      registration of an enrollment."nA case-insensitive string (up to 128 characters
                      long) of alphanumeric characters plus certain special characters : . _ -. No
                      special characters allowed at start or end. Required.
                    "allocationPolicy": "str",  # Optional. The allocation policy of this
                      resource. This policy overrides the tenant level allocation policy for this
                      individual enrollment or enrollment group. Possible values include 'hashed':
                      Linked IoT hubs are equally likely to have devices provisioned to them,
                      'geoLatency':  Devices are provisioned to an IoT hub with the lowest latency to
                      the device.If multiple linked IoT hubs would provide the same lowest latency, the
                      provisioning service hashes devices across those hubs, 'static' : Specification
                      of the desired IoT hub in the enrollment list takes priority over the
                      service-level allocation policy, 'custom': Devices are provisioned to an IoT hub
                      based on your own custom logic. The provisioning service passes information about
                      the device to the logic, and the logic returns the desired IoT hub as well as the
                      desired initial configuration. We recommend using Azure Functions to host your
                      logic. Known values are: "hashed", "geoLatency", "static", and "custom".
                    "capabilities": {
                        "iotEdge": False  # Default value is False. If set to true, this
                          device is an IoTEdge device. Required.
                    },
                    "createdDateTimeUtc": "2020-02-20 00:00:00",  # Optional. The DateTime this
                      resource was created.
                    "customAllocationDefinition": {
                        "apiVersion": "str",  # The API version of the provisioning service
                          types (such as Enrollment) sent in the custom allocation request.
                          Minimum supported version: "2018-09-01-preview". Required.
                        "webhookUrl": "str"  # The webhook URL used for allocation requests.
                          Required.
                    },
                    "deviceId": "str",  # Optional. Desired IoT Hub device ID (optional).
                    "etag": "str",  # Optional. The entity tag associated with the resource.
                    "initialTwin": {
                        "properties": {
                            "desired": {
                                "count": 0,  # Optional. Number of properties in the
                                  TwinCollection.
                                "metadata": {
                                    "lastUpdated": "2020-02-20 00:00:00",  #
                                      Optional. Last time the TwinCollection was updated.
                                    "lastUpdatedVersion": 0  # Optional. This is
                                      null for reported properties metadata and is not null for desired
                                      properties metadata.
                                },
                                "version": 0  # Optional. Version of the
                                  TwinCollection.
                            }
                        },
                        "tags": {
                            "count": 0,  # Optional. Number of properties in the
                              TwinCollection.
                            "metadata": {
                                "lastUpdated": "2020-02-20 00:00:00",  # Optional.
                                  Last time the TwinCollection was updated.
                                "lastUpdatedVersion": 0  # Optional. This is null for
                                  reported properties metadata and is not null for desired properties
                                  metadata.
                            },
                            "version": 0  # Optional. Version of the TwinCollection.
                        }
                    },
                    "iotHubHostName": "str",  # Optional. The Iot Hub host name.
                    "iotHubs": [
                        "str"  # Optional. The list of IoT Hub hostnames the device(s) in
                          this resource can be allocated to. Must be a subset of tenant level list of
                          IoT hubs.
                    ],
                    "lastUpdatedDateTimeUtc": "2020-02-20 00:00:00",  # Optional. The DateTime
                      this resource was last updated.
                    "optionalDeviceInformation": {
                        "count": 0,  # Optional. Number of properties in the TwinCollection.
                        "metadata": {
                            "lastUpdated": "2020-02-20 00:00:00",  # Optional. Last time
                              the TwinCollection was updated.
                            "lastUpdatedVersion": 0  # Optional. This is null for
                              reported properties metadata and is not null for desired properties
                              metadata.
                        },
                        "version": 0  # Optional. Version of the TwinCollection.
                    },
                    "provisioningStatus": "enabled",  # Optional. Default value is "enabled". The
                      provisioning status. Known values are: "enabled" and "disabled".
                    "registrationState": {
                        "assignedHub": "str",  # Optional. Assigned Azure IoT Hub.
                        "createdDateTimeUtc": "2020-02-20 00:00:00",  # Optional.
                          Registration create date time (in UTC).
                        "deviceId": "str",  # Optional. Device ID.
                        "errorCode": 0,  # Optional. Error code.
                        "errorMessage": "str",  # Optional. Error message.
                        "etag": "str",  # Optional. The entity tag associated with the
                          resource.
                        "lastUpdatedDateTimeUtc": "2020-02-20 00:00:00",  # Optional. Last
                          updated date time (in UTC).
                        "payload": {},  # Optional. Custom allocation payload returned from
                          the webhook to the device.
                        "registrationId": "str",  # Optional. This id is used to uniquely
                          identify a device registration of an enrollment."nA case-insensitive string
                          (up to 128 characters long) of alphanumeric characters plus certain special
                          characters : . _ -. No special characters allowed at start or end.
                        "status": "str",  # Optional. Enrollment status. Known values are:
                          "unassigned", "assigning", "assigned", "failed", and "disabled".
                        "substatus": "str"  # Optional. Substatus for 'Assigned' devices.
                          Possible values include - 'initialAssignment': Device has been assigned to an
                          IoT hub for the first time, 'deviceDataMigrated': Device has been assigned to
                          a different IoT hub and its device data was migrated from the previously
                          assigned IoT hub. Device data was removed from the previously assigned IoT
                          hub, 'deviceDataReset':  Device has been assigned to a different IoT hub and
                          its device data was populated from the initial state stored in the
                          enrollment. Device data was removed from the previously assigned IoT hub,
                          'reprovisionedToInitialAssignment': Device has been re-provisioned to a
                          previously assigned IoT hub. Known values are: "initialAssignment",
                          "deviceDataMigrated", "deviceDataReset", and
                          "reprovisionedToInitialAssignment".
                    },
                    "reprovisionPolicy": {
                        "migrateDeviceData": True,  # Default value is True. When set to true
                          (default), the Device Provisioning Service will migrate the device's data
                          (twin, device capabilities, and device ID) from one IoT hub to another during
                          an IoT hub assignment update. If set to false, the Device Provisioning
                          Service will reset the device's data to the initial desired configuration
                          stored in the corresponding enrollment list.
                        "updateHubAssignment": True  # Default value is True. When set to
                          true (default), the Device Provisioning Service will evaluate the device's
                          IoT Hub assignment and update it if necessary for any provisioning requests
                          beyond the first from a given device. If set to false, the device will stay
                          assigned to its current IoT hub.
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_enrollment_get_request(
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    def create_or_update(
        self,
        id: str,
        enrollment: JSON,
        *,
        if_match: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Create or update a device enrollment record.

        Create or update a device enrollment record.

        :param id: This id is used to uniquely identify a device registration of an enrollment. A
         case-insensitive string (up to 128 characters long) of alphanumeric characters plus certain
         special characters : . _ -. No special characters allowed at start or end. Required.
        :type id: str
        :param enrollment: The device enrollment record. Required.
        :type enrollment: JSON
        :keyword if_match: The ETag of the enrollment record. Default value is None.
        :paramtype if_match: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                enrollment = {
                    "attestation": {
                        "type": "str",  # Attestation Type. Required. Known values are:
                          "none", "tpm", "x509", and "symmetricKey".
                        "symmetricKey": {
                            "primaryKey": "str",  # Optional. Primary symmetric key.
                            "secondaryKey": "str"  # Optional. Secondary symmetric key.
                        },
                        "tpm": {
                            "endorsementKey": "str",  # Required.
                            "storageRootKey": "str"  # Optional. TPM attestation method.
                        },
                        "x509": {
                            "caReferences": {
                                "primary": "str",  # Optional. Primary and secondary
                                  CA references.
                                "secondary": "str"  # Optional. Primary and secondary
                                  CA references.
                            },
                            "clientCertificates": {
                                "primary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                },
                                "secondary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                }
                            },
                            "signingCertificates": {
                                "primary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                },
                                "secondary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                }
                            }
                        }
                    },
                    "registrationId": "str",  # This id is used to uniquely identify a device
                      registration of an enrollment."nA case-insensitive string (up to 128 characters
                      long) of alphanumeric characters plus certain special characters : . _ -. No
                      special characters allowed at start or end. Required.
                    "allocationPolicy": "str",  # Optional. The allocation policy of this
                      resource. This policy overrides the tenant level allocation policy for this
                      individual enrollment or enrollment group. Possible values include 'hashed':
                      Linked IoT hubs are equally likely to have devices provisioned to them,
                      'geoLatency':  Devices are provisioned to an IoT hub with the lowest latency to
                      the device.If multiple linked IoT hubs would provide the same lowest latency, the
                      provisioning service hashes devices across those hubs, 'static' : Specification
                      of the desired IoT hub in the enrollment list takes priority over the
                      service-level allocation policy, 'custom': Devices are provisioned to an IoT hub
                      based on your own custom logic. The provisioning service passes information about
                      the device to the logic, and the logic returns the desired IoT hub as well as the
                      desired initial configuration. We recommend using Azure Functions to host your
                      logic. Known values are: "hashed", "geoLatency", "static", and "custom".
                    "capabilities": {
                        "iotEdge": False  # Default value is False. If set to true, this
                          device is an IoTEdge device. Required.
                    },
                    "createdDateTimeUtc": "2020-02-20 00:00:00",  # Optional. The DateTime this
                      resource was created.
                    "customAllocationDefinition": {
                        "apiVersion": "str",  # The API version of the provisioning service
                          types (such as Enrollment) sent in the custom allocation request.
                          Minimum supported version: "2018-09-01-preview". Required.
                        "webhookUrl": "str"  # The webhook URL used for allocation requests.
                          Required.
                    },
                    "deviceId": "str",  # Optional. Desired IoT Hub device ID (optional).
                    "etag": "str",  # Optional. The entity tag associated with the resource.
                    "initialTwin": {
                        "properties": {
                            "desired": {
                                "count": 0,  # Optional. Number of properties in the
                                  TwinCollection.
                                "metadata": {
                                    "lastUpdated": "2020-02-20 00:00:00",  #
                                      Optional. Last time the TwinCollection was updated.
                                    "lastUpdatedVersion": 0  # Optional. This is
                                      null for reported properties metadata and is not null for desired
                                      properties metadata.
                                },
                                "version": 0  # Optional. Version of the
                                  TwinCollection.
                            }
                        },
                        "tags": {
                            "count": 0,  # Optional. Number of properties in the
                              TwinCollection.
                            "metadata": {
                                "lastUpdated": "2020-02-20 00:00:00",  # Optional.
                                  Last time the TwinCollection was updated.
                                "lastUpdatedVersion": 0  # Optional. This is null for
                                  reported properties metadata and is not null for desired properties
                                  metadata.
                            },
                            "version": 0  # Optional. Version of the TwinCollection.
                        }
                    },
                    "iotHubHostName": "str",  # Optional. The Iot Hub host name.
                    "iotHubs": [
                        "str"  # Optional. The list of IoT Hub hostnames the device(s) in
                          this resource can be allocated to. Must be a subset of tenant level list of
                          IoT hubs.
                    ],
                    "lastUpdatedDateTimeUtc": "2020-02-20 00:00:00",  # Optional. The DateTime
                      this resource was last updated.
                    "optionalDeviceInformation": {
                        "count": 0,  # Optional. Number of properties in the TwinCollection.
                        "metadata": {
                            "lastUpdated": "2020-02-20 00:00:00",  # Optional. Last time
                              the TwinCollection was updated.
                            "lastUpdatedVersion": 0  # Optional. This is null for
                              reported properties metadata and is not null for desired properties
                              metadata.
                        },
                        "version": 0  # Optional. Version of the TwinCollection.
                    },
                    "provisioningStatus": "enabled",  # Optional. Default value is "enabled". The
                      provisioning status. Known values are: "enabled" and "disabled".
                    "registrationState": {
                        "assignedHub": "str",  # Optional. Assigned Azure IoT Hub.
                        "createdDateTimeUtc": "2020-02-20 00:00:00",  # Optional.
                          Registration create date time (in UTC).
                        "deviceId": "str",  # Optional. Device ID.
                        "errorCode": 0,  # Optional. Error code.
                        "errorMessage": "str",  # Optional. Error message.
                        "etag": "str",  # Optional. The entity tag associated with the
                          resource.
                        "lastUpdatedDateTimeUtc": "2020-02-20 00:00:00",  # Optional. Last
                          updated date time (in UTC).
                        "payload": {},  # Optional. Custom allocation payload returned from
                          the webhook to the device.
                        "registrationId": "str",  # Optional. This id is used to uniquely
                          identify a device registration of an enrollment."nA case-insensitive string
                          (up to 128 characters long) of alphanumeric characters plus certain special
                          characters : . _ -. No special characters allowed at start or end.
                        "status": "str",  # Optional. Enrollment status. Known values are:
                          "unassigned", "assigning", "assigned", "failed", and "disabled".
                        "substatus": "str"  # Optional. Substatus for 'Assigned' devices.
                          Possible values include - 'initialAssignment': Device has been assigned to an
                          IoT hub for the first time, 'deviceDataMigrated': Device has been assigned to
                          a different IoT hub and its device data was migrated from the previously
                          assigned IoT hub. Device data was removed from the previously assigned IoT
                          hub, 'deviceDataReset':  Device has been assigned to a different IoT hub and
                          its device data was populated from the initial state stored in the
                          enrollment. Device data was removed from the previously assigned IoT hub,
                          'reprovisionedToInitialAssignment': Device has been re-provisioned to a
                          previously assigned IoT hub. Known values are: "initialAssignment",
                          "deviceDataMigrated", "deviceDataReset", and
                          "reprovisionedToInitialAssignment".
                    },
                    "reprovisionPolicy": {
                        "migrateDeviceData": True,  # Default value is True. When set to true
                          (default), the Device Provisioning Service will migrate the device's data
                          (twin, device capabilities, and device ID) from one IoT hub to another during
                          an IoT hub assignment update. If set to false, the Device Provisioning
                          Service will reset the device's data to the initial desired configuration
                          stored in the corresponding enrollment list.
                        "updateHubAssignment": True  # Default value is True. When set to
                          true (default), the Device Provisioning Service will evaluate the device's
                          IoT Hub assignment and update it if necessary for any provisioning requests
                          beyond the first from a given device. If set to false, the device will stay
                          assigned to its current IoT hub.
                    }
                }

                # response body for status code(s): 200
                response == {
                    "attestation": {
                        "type": "str",  # Attestation Type. Required. Known values are:
                          "none", "tpm", "x509", and "symmetricKey".
                        "symmetricKey": {
                            "primaryKey": "str",  # Optional. Primary symmetric key.
                            "secondaryKey": "str"  # Optional. Secondary symmetric key.
                        },
                        "tpm": {
                            "endorsementKey": "str",  # Required.
                            "storageRootKey": "str"  # Optional. TPM attestation method.
                        },
                        "x509": {
                            "caReferences": {
                                "primary": "str",  # Optional. Primary and secondary
                                  CA references.
                                "secondary": "str"  # Optional. Primary and secondary
                                  CA references.
                            },
                            "clientCertificates": {
                                "primary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                },
                                "secondary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                }
                            },
                            "signingCertificates": {
                                "primary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                },
                                "secondary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                }
                            }
                        }
                    },
                    "registrationId": "str",  # This id is used to uniquely identify a device
                      registration of an enrollment."nA case-insensitive string (up to 128 characters
                      long) of alphanumeric characters plus certain special characters : . _ -. No
                      special characters allowed at start or end. Required.
                    "allocationPolicy": "str",  # Optional. The allocation policy of this
                      resource. This policy overrides the tenant level allocation policy for this
                      individual enrollment or enrollment group. Possible values include 'hashed':
                      Linked IoT hubs are equally likely to have devices provisioned to them,
                      'geoLatency':  Devices are provisioned to an IoT hub with the lowest latency to
                      the device.If multiple linked IoT hubs would provide the same lowest latency, the
                      provisioning service hashes devices across those hubs, 'static' : Specification
                      of the desired IoT hub in the enrollment list takes priority over the
                      service-level allocation policy, 'custom': Devices are provisioned to an IoT hub
                      based on your own custom logic. The provisioning service passes information about
                      the device to the logic, and the logic returns the desired IoT hub as well as the
                      desired initial configuration. We recommend using Azure Functions to host your
                      logic. Known values are: "hashed", "geoLatency", "static", and "custom".
                    "capabilities": {
                        "iotEdge": False  # Default value is False. If set to true, this
                          device is an IoTEdge device. Required.
                    },
                    "createdDateTimeUtc": "2020-02-20 00:00:00",  # Optional. The DateTime this
                      resource was created.
                    "customAllocationDefinition": {
                        "apiVersion": "str",  # The API version of the provisioning service
                          types (such as Enrollment) sent in the custom allocation request.
                          Minimum supported version: "2018-09-01-preview". Required.
                        "webhookUrl": "str"  # The webhook URL used for allocation requests.
                          Required.
                    },
                    "deviceId": "str",  # Optional. Desired IoT Hub device ID (optional).
                    "etag": "str",  # Optional. The entity tag associated with the resource.
                    "initialTwin": {
                        "properties": {
                            "desired": {
                                "count": 0,  # Optional. Number of properties in the
                                  TwinCollection.
                                "metadata": {
                                    "lastUpdated": "2020-02-20 00:00:00",  #
                                      Optional. Last time the TwinCollection was updated.
                                    "lastUpdatedVersion": 0  # Optional. This is
                                      null for reported properties metadata and is not null for desired
                                      properties metadata.
                                },
                                "version": 0  # Optional. Version of the
                                  TwinCollection.
                            }
                        },
                        "tags": {
                            "count": 0,  # Optional. Number of properties in the
                              TwinCollection.
                            "metadata": {
                                "lastUpdated": "2020-02-20 00:00:00",  # Optional.
                                  Last time the TwinCollection was updated.
                                "lastUpdatedVersion": 0  # Optional. This is null for
                                  reported properties metadata and is not null for desired properties
                                  metadata.
                            },
                            "version": 0  # Optional. Version of the TwinCollection.
                        }
                    },
                    "iotHubHostName": "str",  # Optional. The Iot Hub host name.
                    "iotHubs": [
                        "str"  # Optional. The list of IoT Hub hostnames the device(s) in
                          this resource can be allocated to. Must be a subset of tenant level list of
                          IoT hubs.
                    ],
                    "lastUpdatedDateTimeUtc": "2020-02-20 00:00:00",  # Optional. The DateTime
                      this resource was last updated.
                    "optionalDeviceInformation": {
                        "count": 0,  # Optional. Number of properties in the TwinCollection.
                        "metadata": {
                            "lastUpdated": "2020-02-20 00:00:00",  # Optional. Last time
                              the TwinCollection was updated.
                            "lastUpdatedVersion": 0  # Optional. This is null for
                              reported properties metadata and is not null for desired properties
                              metadata.
                        },
                        "version": 0  # Optional. Version of the TwinCollection.
                    },
                    "provisioningStatus": "enabled",  # Optional. Default value is "enabled". The
                      provisioning status. Known values are: "enabled" and "disabled".
                    "registrationState": {
                        "assignedHub": "str",  # Optional. Assigned Azure IoT Hub.
                        "createdDateTimeUtc": "2020-02-20 00:00:00",  # Optional.
                          Registration create date time (in UTC).
                        "deviceId": "str",  # Optional. Device ID.
                        "errorCode": 0,  # Optional. Error code.
                        "errorMessage": "str",  # Optional. Error message.
                        "etag": "str",  # Optional. The entity tag associated with the
                          resource.
                        "lastUpdatedDateTimeUtc": "2020-02-20 00:00:00",  # Optional. Last
                          updated date time (in UTC).
                        "payload": {},  # Optional. Custom allocation payload returned from
                          the webhook to the device.
                        "registrationId": "str",  # Optional. This id is used to uniquely
                          identify a device registration of an enrollment."nA case-insensitive string
                          (up to 128 characters long) of alphanumeric characters plus certain special
                          characters : . _ -. No special characters allowed at start or end.
                        "status": "str",  # Optional. Enrollment status. Known values are:
                          "unassigned", "assigning", "assigned", "failed", and "disabled".
                        "substatus": "str"  # Optional. Substatus for 'Assigned' devices.
                          Possible values include - 'initialAssignment': Device has been assigned to an
                          IoT hub for the first time, 'deviceDataMigrated': Device has been assigned to
                          a different IoT hub and its device data was migrated from the previously
                          assigned IoT hub. Device data was removed from the previously assigned IoT
                          hub, 'deviceDataReset':  Device has been assigned to a different IoT hub and
                          its device data was populated from the initial state stored in the
                          enrollment. Device data was removed from the previously assigned IoT hub,
                          'reprovisionedToInitialAssignment': Device has been re-provisioned to a
                          previously assigned IoT hub. Known values are: "initialAssignment",
                          "deviceDataMigrated", "deviceDataReset", and
                          "reprovisionedToInitialAssignment".
                    },
                    "reprovisionPolicy": {
                        "migrateDeviceData": True,  # Default value is True. When set to true
                          (default), the Device Provisioning Service will migrate the device's data
                          (twin, device capabilities, and device ID) from one IoT hub to another during
                          an IoT hub assignment update. If set to false, the Device Provisioning
                          Service will reset the device's data to the initial desired configuration
                          stored in the corresponding enrollment list.
                        "updateHubAssignment": True  # Default value is True. When set to
                          true (default), the Device Provisioning Service will evaluate the device's
                          IoT Hub assignment and update it if necessary for any provisioning requests
                          beyond the first from a given device. If set to false, the device will stay
                          assigned to its current IoT hub.
                    }
                }
        """

    @overload
    def create_or_update(
        self,
        id: str,
        enrollment: IO,
        *,
        if_match: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Create or update a device enrollment record.

        Create or update a device enrollment record.

        :param id: This id is used to uniquely identify a device registration of an enrollment. A
         case-insensitive string (up to 128 characters long) of alphanumeric characters plus certain
         special characters : . _ -. No special characters allowed at start or end. Required.
        :type id: str
        :param enrollment: The device enrollment record. Required.
        :type enrollment: IO
        :keyword if_match: The ETag of the enrollment record. Default value is None.
        :paramtype if_match: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "attestation": {
                        "type": "str",  # Attestation Type. Required. Known values are:
                          "none", "tpm", "x509", and "symmetricKey".
                        "symmetricKey": {
                            "primaryKey": "str",  # Optional. Primary symmetric key.
                            "secondaryKey": "str"  # Optional. Secondary symmetric key.
                        },
                        "tpm": {
                            "endorsementKey": "str",  # Required.
                            "storageRootKey": "str"  # Optional. TPM attestation method.
                        },
                        "x509": {
                            "caReferences": {
                                "primary": "str",  # Optional. Primary and secondary
                                  CA references.
                                "secondary": "str"  # Optional. Primary and secondary
                                  CA references.
                            },
                            "clientCertificates": {
                                "primary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                },
                                "secondary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                }
                            },
                            "signingCertificates": {
                                "primary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                },
                                "secondary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                }
                            }
                        }
                    },
                    "registrationId": "str",  # This id is used to uniquely identify a device
                      registration of an enrollment."nA case-insensitive string (up to 128 characters
                      long) of alphanumeric characters plus certain special characters : . _ -. No
                      special characters allowed at start or end. Required.
                    "allocationPolicy": "str",  # Optional. The allocation policy of this
                      resource. This policy overrides the tenant level allocation policy for this
                      individual enrollment or enrollment group. Possible values include 'hashed':
                      Linked IoT hubs are equally likely to have devices provisioned to them,
                      'geoLatency':  Devices are provisioned to an IoT hub with the lowest latency to
                      the device.If multiple linked IoT hubs would provide the same lowest latency, the
                      provisioning service hashes devices across those hubs, 'static' : Specification
                      of the desired IoT hub in the enrollment list takes priority over the
                      service-level allocation policy, 'custom': Devices are provisioned to an IoT hub
                      based on your own custom logic. The provisioning service passes information about
                      the device to the logic, and the logic returns the desired IoT hub as well as the
                      desired initial configuration. We recommend using Azure Functions to host your
                      logic. Known values are: "hashed", "geoLatency", "static", and "custom".
                    "capabilities": {
                        "iotEdge": False  # Default value is False. If set to true, this
                          device is an IoTEdge device. Required.
                    },
                    "createdDateTimeUtc": "2020-02-20 00:00:00",  # Optional. The DateTime this
                      resource was created.
                    "customAllocationDefinition": {
                        "apiVersion": "str",  # The API version of the provisioning service
                          types (such as Enrollment) sent in the custom allocation request.
                          Minimum supported version: "2018-09-01-preview". Required.
                        "webhookUrl": "str"  # The webhook URL used for allocation requests.
                          Required.
                    },
                    "deviceId": "str",  # Optional. Desired IoT Hub device ID (optional).
                    "etag": "str",  # Optional. The entity tag associated with the resource.
                    "initialTwin": {
                        "properties": {
                            "desired": {
                                "count": 0,  # Optional. Number of properties in the
                                  TwinCollection.
                                "metadata": {
                                    "lastUpdated": "2020-02-20 00:00:00",  #
                                      Optional. Last time the TwinCollection was updated.
                                    "lastUpdatedVersion": 0  # Optional. This is
                                      null for reported properties metadata and is not null for desired
                                      properties metadata.
                                },
                                "version": 0  # Optional. Version of the
                                  TwinCollection.
                            }
                        },
                        "tags": {
                            "count": 0,  # Optional. Number of properties in the
                              TwinCollection.
                            "metadata": {
                                "lastUpdated": "2020-02-20 00:00:00",  # Optional.
                                  Last time the TwinCollection was updated.
                                "lastUpdatedVersion": 0  # Optional. This is null for
                                  reported properties metadata and is not null for desired properties
                                  metadata.
                            },
                            "version": 0  # Optional. Version of the TwinCollection.
                        }
                    },
                    "iotHubHostName": "str",  # Optional. The Iot Hub host name.
                    "iotHubs": [
                        "str"  # Optional. The list of IoT Hub hostnames the device(s) in
                          this resource can be allocated to. Must be a subset of tenant level list of
                          IoT hubs.
                    ],
                    "lastUpdatedDateTimeUtc": "2020-02-20 00:00:00",  # Optional. The DateTime
                      this resource was last updated.
                    "optionalDeviceInformation": {
                        "count": 0,  # Optional. Number of properties in the TwinCollection.
                        "metadata": {
                            "lastUpdated": "2020-02-20 00:00:00",  # Optional. Last time
                              the TwinCollection was updated.
                            "lastUpdatedVersion": 0  # Optional. This is null for
                              reported properties metadata and is not null for desired properties
                              metadata.
                        },
                        "version": 0  # Optional. Version of the TwinCollection.
                    },
                    "provisioningStatus": "enabled",  # Optional. Default value is "enabled". The
                      provisioning status. Known values are: "enabled" and "disabled".
                    "registrationState": {
                        "assignedHub": "str",  # Optional. Assigned Azure IoT Hub.
                        "createdDateTimeUtc": "2020-02-20 00:00:00",  # Optional.
                          Registration create date time (in UTC).
                        "deviceId": "str",  # Optional. Device ID.
                        "errorCode": 0,  # Optional. Error code.
                        "errorMessage": "str",  # Optional. Error message.
                        "etag": "str",  # Optional. The entity tag associated with the
                          resource.
                        "lastUpdatedDateTimeUtc": "2020-02-20 00:00:00",  # Optional. Last
                          updated date time (in UTC).
                        "payload": {},  # Optional. Custom allocation payload returned from
                          the webhook to the device.
                        "registrationId": "str",  # Optional. This id is used to uniquely
                          identify a device registration of an enrollment."nA case-insensitive string
                          (up to 128 characters long) of alphanumeric characters plus certain special
                          characters : . _ -. No special characters allowed at start or end.
                        "status": "str",  # Optional. Enrollment status. Known values are:
                          "unassigned", "assigning", "assigned", "failed", and "disabled".
                        "substatus": "str"  # Optional. Substatus for 'Assigned' devices.
                          Possible values include - 'initialAssignment': Device has been assigned to an
                          IoT hub for the first time, 'deviceDataMigrated': Device has been assigned to
                          a different IoT hub and its device data was migrated from the previously
                          assigned IoT hub. Device data was removed from the previously assigned IoT
                          hub, 'deviceDataReset':  Device has been assigned to a different IoT hub and
                          its device data was populated from the initial state stored in the
                          enrollment. Device data was removed from the previously assigned IoT hub,
                          'reprovisionedToInitialAssignment': Device has been re-provisioned to a
                          previously assigned IoT hub. Known values are: "initialAssignment",
                          "deviceDataMigrated", "deviceDataReset", and
                          "reprovisionedToInitialAssignment".
                    },
                    "reprovisionPolicy": {
                        "migrateDeviceData": True,  # Default value is True. When set to true
                          (default), the Device Provisioning Service will migrate the device's data
                          (twin, device capabilities, and device ID) from one IoT hub to another during
                          an IoT hub assignment update. If set to false, the Device Provisioning
                          Service will reset the device's data to the initial desired configuration
                          stored in the corresponding enrollment list.
                        "updateHubAssignment": True  # Default value is True. When set to
                          true (default), the Device Provisioning Service will evaluate the device's
                          IoT Hub assignment and update it if necessary for any provisioning requests
                          beyond the first from a given device. If set to false, the device will stay
                          assigned to its current IoT hub.
                    }
                }
        """

    @distributed_trace
    def create_or_update(
        self, id: str, enrollment: Union[JSON, IO], *, if_match: Optional[str] = None, **kwargs: Any
    ) -> JSON:
        """Create or update a device enrollment record.

        Create or update a device enrollment record.

        :param id: This id is used to uniquely identify a device registration of an enrollment. A
         case-insensitive string (up to 128 characters long) of alphanumeric characters plus certain
         special characters : . _ -. No special characters allowed at start or end. Required.
        :type id: str
        :param enrollment: The device enrollment record. Is either a JSON type or a IO type. Required.
        :type enrollment: JSON or IO
        :keyword if_match: The ETag of the enrollment record. Default value is None.
        :paramtype if_match: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                enrollment = {
                    "attestation": {
                        "type": "str",  # Attestation Type. Required. Known values are:
                          "none", "tpm", "x509", and "symmetricKey".
                        "symmetricKey": {
                            "primaryKey": "str",  # Optional. Primary symmetric key.
                            "secondaryKey": "str"  # Optional. Secondary symmetric key.
                        },
                        "tpm": {
                            "endorsementKey": "str",  # Required.
                            "storageRootKey": "str"  # Optional. TPM attestation method.
                        },
                        "x509": {
                            "caReferences": {
                                "primary": "str",  # Optional. Primary and secondary
                                  CA references.
                                "secondary": "str"  # Optional. Primary and secondary
                                  CA references.
                            },
                            "clientCertificates": {
                                "primary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                },
                                "secondary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                }
                            },
                            "signingCertificates": {
                                "primary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                },
                                "secondary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                }
                            }
                        }
                    },
                    "registrationId": "str",  # This id is used to uniquely identify a device
                      registration of an enrollment."nA case-insensitive string (up to 128 characters
                      long) of alphanumeric characters plus certain special characters : . _ -. No
                      special characters allowed at start or end. Required.
                    "allocationPolicy": "str",  # Optional. The allocation policy of this
                      resource. This policy overrides the tenant level allocation policy for this
                      individual enrollment or enrollment group. Possible values include 'hashed':
                      Linked IoT hubs are equally likely to have devices provisioned to them,
                      'geoLatency':  Devices are provisioned to an IoT hub with the lowest latency to
                      the device.If multiple linked IoT hubs would provide the same lowest latency, the
                      provisioning service hashes devices across those hubs, 'static' : Specification
                      of the desired IoT hub in the enrollment list takes priority over the
                      service-level allocation policy, 'custom': Devices are provisioned to an IoT hub
                      based on your own custom logic. The provisioning service passes information about
                      the device to the logic, and the logic returns the desired IoT hub as well as the
                      desired initial configuration. We recommend using Azure Functions to host your
                      logic. Known values are: "hashed", "geoLatency", "static", and "custom".
                    "capabilities": {
                        "iotEdge": False  # Default value is False. If set to true, this
                          device is an IoTEdge device. Required.
                    },
                    "createdDateTimeUtc": "2020-02-20 00:00:00",  # Optional. The DateTime this
                      resource was created.
                    "customAllocationDefinition": {
                        "apiVersion": "str",  # The API version of the provisioning service
                          types (such as Enrollment) sent in the custom allocation request.
                          Minimum supported version: "2018-09-01-preview". Required.
                        "webhookUrl": "str"  # The webhook URL used for allocation requests.
                          Required.
                    },
                    "deviceId": "str",  # Optional. Desired IoT Hub device ID (optional).
                    "etag": "str",  # Optional. The entity tag associated with the resource.
                    "initialTwin": {
                        "properties": {
                            "desired": {
                                "count": 0,  # Optional. Number of properties in the
                                  TwinCollection.
                                "metadata": {
                                    "lastUpdated": "2020-02-20 00:00:00",  #
                                      Optional. Last time the TwinCollection was updated.
                                    "lastUpdatedVersion": 0  # Optional. This is
                                      null for reported properties metadata and is not null for desired
                                      properties metadata.
                                },
                                "version": 0  # Optional. Version of the
                                  TwinCollection.
                            }
                        },
                        "tags": {
                            "count": 0,  # Optional. Number of properties in the
                              TwinCollection.
                            "metadata": {
                                "lastUpdated": "2020-02-20 00:00:00",  # Optional.
                                  Last time the TwinCollection was updated.
                                "lastUpdatedVersion": 0  # Optional. This is null for
                                  reported properties metadata and is not null for desired properties
                                  metadata.
                            },
                            "version": 0  # Optional. Version of the TwinCollection.
                        }
                    },
                    "iotHubHostName": "str",  # Optional. The Iot Hub host name.
                    "iotHubs": [
                        "str"  # Optional. The list of IoT Hub hostnames the device(s) in
                          this resource can be allocated to. Must be a subset of tenant level list of
                          IoT hubs.
                    ],
                    "lastUpdatedDateTimeUtc": "2020-02-20 00:00:00",  # Optional. The DateTime
                      this resource was last updated.
                    "optionalDeviceInformation": {
                        "count": 0,  # Optional. Number of properties in the TwinCollection.
                        "metadata": {
                            "lastUpdated": "2020-02-20 00:00:00",  # Optional. Last time
                              the TwinCollection was updated.
                            "lastUpdatedVersion": 0  # Optional. This is null for
                              reported properties metadata and is not null for desired properties
                              metadata.
                        },
                        "version": 0  # Optional. Version of the TwinCollection.
                    },
                    "provisioningStatus": "enabled",  # Optional. Default value is "enabled". The
                      provisioning status. Known values are: "enabled" and "disabled".
                    "registrationState": {
                        "assignedHub": "str",  # Optional. Assigned Azure IoT Hub.
                        "createdDateTimeUtc": "2020-02-20 00:00:00",  # Optional.
                          Registration create date time (in UTC).
                        "deviceId": "str",  # Optional. Device ID.
                        "errorCode": 0,  # Optional. Error code.
                        "errorMessage": "str",  # Optional. Error message.
                        "etag": "str",  # Optional. The entity tag associated with the
                          resource.
                        "lastUpdatedDateTimeUtc": "2020-02-20 00:00:00",  # Optional. Last
                          updated date time (in UTC).
                        "payload": {},  # Optional. Custom allocation payload returned from
                          the webhook to the device.
                        "registrationId": "str",  # Optional. This id is used to uniquely
                          identify a device registration of an enrollment."nA case-insensitive string
                          (up to 128 characters long) of alphanumeric characters plus certain special
                          characters : . _ -. No special characters allowed at start or end.
                        "status": "str",  # Optional. Enrollment status. Known values are:
                          "unassigned", "assigning", "assigned", "failed", and "disabled".
                        "substatus": "str"  # Optional. Substatus for 'Assigned' devices.
                          Possible values include - 'initialAssignment': Device has been assigned to an
                          IoT hub for the first time, 'deviceDataMigrated': Device has been assigned to
                          a different IoT hub and its device data was migrated from the previously
                          assigned IoT hub. Device data was removed from the previously assigned IoT
                          hub, 'deviceDataReset':  Device has been assigned to a different IoT hub and
                          its device data was populated from the initial state stored in the
                          enrollment. Device data was removed from the previously assigned IoT hub,
                          'reprovisionedToInitialAssignment': Device has been re-provisioned to a
                          previously assigned IoT hub. Known values are: "initialAssignment",
                          "deviceDataMigrated", "deviceDataReset", and
                          "reprovisionedToInitialAssignment".
                    },
                    "reprovisionPolicy": {
                        "migrateDeviceData": True,  # Default value is True. When set to true
                          (default), the Device Provisioning Service will migrate the device's data
                          (twin, device capabilities, and device ID) from one IoT hub to another during
                          an IoT hub assignment update. If set to false, the Device Provisioning
                          Service will reset the device's data to the initial desired configuration
                          stored in the corresponding enrollment list.
                        "updateHubAssignment": True  # Default value is True. When set to
                          true (default), the Device Provisioning Service will evaluate the device's
                          IoT Hub assignment and update it if necessary for any provisioning requests
                          beyond the first from a given device. If set to false, the device will stay
                          assigned to its current IoT hub.
                    }
                }

                # response body for status code(s): 200
                response == {
                    "attestation": {
                        "type": "str",  # Attestation Type. Required. Known values are:
                          "none", "tpm", "x509", and "symmetricKey".
                        "symmetricKey": {
                            "primaryKey": "str",  # Optional. Primary symmetric key.
                            "secondaryKey": "str"  # Optional. Secondary symmetric key.
                        },
                        "tpm": {
                            "endorsementKey": "str",  # Required.
                            "storageRootKey": "str"  # Optional. TPM attestation method.
                        },
                        "x509": {
                            "caReferences": {
                                "primary": "str",  # Optional. Primary and secondary
                                  CA references.
                                "secondary": "str"  # Optional. Primary and secondary
                                  CA references.
                            },
                            "clientCertificates": {
                                "primary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                },
                                "secondary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                }
                            },
                            "signingCertificates": {
                                "primary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                },
                                "secondary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                }
                            }
                        }
                    },
                    "registrationId": "str",  # This id is used to uniquely identify a device
                      registration of an enrollment."nA case-insensitive string (up to 128 characters
                      long) of alphanumeric characters plus certain special characters : . _ -. No
                      special characters allowed at start or end. Required.
                    "allocationPolicy": "str",  # Optional. The allocation policy of this
                      resource. This policy overrides the tenant level allocation policy for this
                      individual enrollment or enrollment group. Possible values include 'hashed':
                      Linked IoT hubs are equally likely to have devices provisioned to them,
                      'geoLatency':  Devices are provisioned to an IoT hub with the lowest latency to
                      the device.If multiple linked IoT hubs would provide the same lowest latency, the
                      provisioning service hashes devices across those hubs, 'static' : Specification
                      of the desired IoT hub in the enrollment list takes priority over the
                      service-level allocation policy, 'custom': Devices are provisioned to an IoT hub
                      based on your own custom logic. The provisioning service passes information about
                      the device to the logic, and the logic returns the desired IoT hub as well as the
                      desired initial configuration. We recommend using Azure Functions to host your
                      logic. Known values are: "hashed", "geoLatency", "static", and "custom".
                    "capabilities": {
                        "iotEdge": False  # Default value is False. If set to true, this
                          device is an IoTEdge device. Required.
                    },
                    "createdDateTimeUtc": "2020-02-20 00:00:00",  # Optional. The DateTime this
                      resource was created.
                    "customAllocationDefinition": {
                        "apiVersion": "str",  # The API version of the provisioning service
                          types (such as Enrollment) sent in the custom allocation request.
                          Minimum supported version: "2018-09-01-preview". Required.
                        "webhookUrl": "str"  # The webhook URL used for allocation requests.
                          Required.
                    },
                    "deviceId": "str",  # Optional. Desired IoT Hub device ID (optional).
                    "etag": "str",  # Optional. The entity tag associated with the resource.
                    "initialTwin": {
                        "properties": {
                            "desired": {
                                "count": 0,  # Optional. Number of properties in the
                                  TwinCollection.
                                "metadata": {
                                    "lastUpdated": "2020-02-20 00:00:00",  #
                                      Optional. Last time the TwinCollection was updated.
                                    "lastUpdatedVersion": 0  # Optional. This is
                                      null for reported properties metadata and is not null for desired
                                      properties metadata.
                                },
                                "version": 0  # Optional. Version of the
                                  TwinCollection.
                            }
                        },
                        "tags": {
                            "count": 0,  # Optional. Number of properties in the
                              TwinCollection.
                            "metadata": {
                                "lastUpdated": "2020-02-20 00:00:00",  # Optional.
                                  Last time the TwinCollection was updated.
                                "lastUpdatedVersion": 0  # Optional. This is null for
                                  reported properties metadata and is not null for desired properties
                                  metadata.
                            },
                            "version": 0  # Optional. Version of the TwinCollection.
                        }
                    },
                    "iotHubHostName": "str",  # Optional. The Iot Hub host name.
                    "iotHubs": [
                        "str"  # Optional. The list of IoT Hub hostnames the device(s) in
                          this resource can be allocated to. Must be a subset of tenant level list of
                          IoT hubs.
                    ],
                    "lastUpdatedDateTimeUtc": "2020-02-20 00:00:00",  # Optional. The DateTime
                      this resource was last updated.
                    "optionalDeviceInformation": {
                        "count": 0,  # Optional. Number of properties in the TwinCollection.
                        "metadata": {
                            "lastUpdated": "2020-02-20 00:00:00",  # Optional. Last time
                              the TwinCollection was updated.
                            "lastUpdatedVersion": 0  # Optional. This is null for
                              reported properties metadata and is not null for desired properties
                              metadata.
                        },
                        "version": 0  # Optional. Version of the TwinCollection.
                    },
                    "provisioningStatus": "enabled",  # Optional. Default value is "enabled". The
                      provisioning status. Known values are: "enabled" and "disabled".
                    "registrationState": {
                        "assignedHub": "str",  # Optional. Assigned Azure IoT Hub.
                        "createdDateTimeUtc": "2020-02-20 00:00:00",  # Optional.
                          Registration create date time (in UTC).
                        "deviceId": "str",  # Optional. Device ID.
                        "errorCode": 0,  # Optional. Error code.
                        "errorMessage": "str",  # Optional. Error message.
                        "etag": "str",  # Optional. The entity tag associated with the
                          resource.
                        "lastUpdatedDateTimeUtc": "2020-02-20 00:00:00",  # Optional. Last
                          updated date time (in UTC).
                        "payload": {},  # Optional. Custom allocation payload returned from
                          the webhook to the device.
                        "registrationId": "str",  # Optional. This id is used to uniquely
                          identify a device registration of an enrollment."nA case-insensitive string
                          (up to 128 characters long) of alphanumeric characters plus certain special
                          characters : . _ -. No special characters allowed at start or end.
                        "status": "str",  # Optional. Enrollment status. Known values are:
                          "unassigned", "assigning", "assigned", "failed", and "disabled".
                        "substatus": "str"  # Optional. Substatus for 'Assigned' devices.
                          Possible values include - 'initialAssignment': Device has been assigned to an
                          IoT hub for the first time, 'deviceDataMigrated': Device has been assigned to
                          a different IoT hub and its device data was migrated from the previously
                          assigned IoT hub. Device data was removed from the previously assigned IoT
                          hub, 'deviceDataReset':  Device has been assigned to a different IoT hub and
                          its device data was populated from the initial state stored in the
                          enrollment. Device data was removed from the previously assigned IoT hub,
                          'reprovisionedToInitialAssignment': Device has been re-provisioned to a
                          previously assigned IoT hub. Known values are: "initialAssignment",
                          "deviceDataMigrated", "deviceDataReset", and
                          "reprovisionedToInitialAssignment".
                    },
                    "reprovisionPolicy": {
                        "migrateDeviceData": True,  # Default value is True. When set to true
                          (default), the Device Provisioning Service will migrate the device's data
                          (twin, device capabilities, and device ID) from one IoT hub to another during
                          an IoT hub assignment update. If set to false, the Device Provisioning
                          Service will reset the device's data to the initial desired configuration
                          stored in the corresponding enrollment list.
                        "updateHubAssignment": True  # Default value is True. When set to
                          true (default), the Device Provisioning Service will evaluate the device's
                          IoT Hub assignment and update it if necessary for any provisioning requests
                          beyond the first from a given device. If set to false, the device will stay
                          assigned to its current IoT hub.
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(enrollment, (IOBase, bytes)):
            _content = enrollment
        else:
            _json = enrollment

        request = build_enrollment_create_or_update_request(
            id=id,
            if_match=if_match,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace
    def delete(  # pylint: disable=inconsistent-return-statements
        self, id: str, *, if_match: Optional[str] = None, **kwargs: Any
    ) -> None:
        """Delete a device enrollment record.

        Delete a device enrollment record.

        :param id: This id is used to uniquely identify a device registration of an enrollment. A
         case-insensitive string (up to 128 characters long) of alphanumeric characters plus certain
         special characters : . _ -. No special characters allowed at start or end. Required.
        :type id: str
        :keyword if_match: The ETag of the enrollment record. Default value is None.
        :paramtype if_match: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_enrollment_delete_request(
            id=id,
            if_match=if_match,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    @overload
    def _query(
        self,
        query_specification: JSON,
        *,
        x_ms_max_item_count: Optional[int] = None,
        x_ms_continuation: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> List[JSON]:
        ...

    @overload
    def _query(
        self,
        query_specification: IO,
        *,
        x_ms_max_item_count: Optional[int] = None,
        x_ms_continuation: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> List[JSON]:
        ...

    @distributed_trace
    def _query(
        self,
        query_specification: Union[JSON, IO],
        *,
        x_ms_max_item_count: Optional[int] = None,
        x_ms_continuation: Optional[str] = None,
        **kwargs: Any
    ) -> List[JSON]:
        """Query the device enrollment records.

        Query the device enrollment records.

        :param query_specification: The query specification. Is either a JSON type or a IO type.
         Required.
        :type query_specification: JSON or IO
        :keyword x_ms_max_item_count: Page size. Default value is None.
        :paramtype x_ms_max_item_count: int
        :keyword x_ms_continuation: Continuation token. Default value is None.
        :paramtype x_ms_continuation: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                query_specification = {
                    "query": "str"  # Required.
                }

                # response body for status code(s): 200
                response == [
                    {
                        "attestation": {
                            "type": "str",  # Attestation Type. Required. Known values
                              are: "none", "tpm", "x509", and "symmetricKey".
                            "symmetricKey": {
                                "primaryKey": "str",  # Optional. Primary symmetric
                                  key.
                                "secondaryKey": "str"  # Optional. Secondary
                                  symmetric key.
                            },
                            "tpm": {
                                "endorsementKey": "str",  # Required.
                                "storageRootKey": "str"  # Optional. TPM attestation
                                  method.
                            },
                            "x509": {
                                "caReferences": {
                                    "primary": "str",  # Optional. Primary and
                                      secondary CA references.
                                    "secondary": "str"  # Optional. Primary and
                                      secondary CA references.
                                },
                                "clientCertificates": {
                                    "primary": {
                                        "certificate": "str",  # Optional.
                                          Certificate and Certificate info.
                                        "info": {
                                            "issuerName": "str",  #
                                              Required.
                                            "notAfterUtc": "2020-02-20
                                              00:00:00",  # Required.
                                            "notBeforeUtc": "2020-02-20
                                              00:00:00",  # Required.
                                            "serialNumber": "str",  #
                                              Required.
                                            "sha1Thumbprint": "str",  #
                                              Required.
                                            "sha256Thumbprint": "str",  #
                                              Required.
                                            "subjectName": "str",  #
                                              Required.
                                            "version": 0  # Required.
                                        }
                                    },
                                    "secondary": {
                                        "certificate": "str",  # Optional.
                                          Certificate and Certificate info.
                                        "info": {
                                            "issuerName": "str",  #
                                              Required.
                                            "notAfterUtc": "2020-02-20
                                              00:00:00",  # Required.
                                            "notBeforeUtc": "2020-02-20
                                              00:00:00",  # Required.
                                            "serialNumber": "str",  #
                                              Required.
                                            "sha1Thumbprint": "str",  #
                                              Required.
                                            "sha256Thumbprint": "str",  #
                                              Required.
                                            "subjectName": "str",  #
                                              Required.
                                            "version": 0  # Required.
                                        }
                                    }
                                },
                                "signingCertificates": {
                                    "primary": {
                                        "certificate": "str",  # Optional.
                                          Certificate and Certificate info.
                                        "info": {
                                            "issuerName": "str",  #
                                              Required.
                                            "notAfterUtc": "2020-02-20
                                              00:00:00",  # Required.
                                            "notBeforeUtc": "2020-02-20
                                              00:00:00",  # Required.
                                            "serialNumber": "str",  #
                                              Required.
                                            "sha1Thumbprint": "str",  #
                                              Required.
                                            "sha256Thumbprint": "str",  #
                                              Required.
                                            "subjectName": "str",  #
                                              Required.
                                            "version": 0  # Required.
                                        }
                                    },
                                    "secondary": {
                                        "certificate": "str",  # Optional.
                                          Certificate and Certificate info.
                                        "info": {
                                            "issuerName": "str",  #
                                              Required.
                                            "notAfterUtc": "2020-02-20
                                              00:00:00",  # Required.
                                            "notBeforeUtc": "2020-02-20
                                              00:00:00",  # Required.
                                            "serialNumber": "str",  #
                                              Required.
                                            "sha1Thumbprint": "str",  #
                                              Required.
                                            "sha256Thumbprint": "str",  #
                                              Required.
                                            "subjectName": "str",  #
                                              Required.
                                            "version": 0  # Required.
                                        }
                                    }
                                }
                            }
                        },
                        "registrationId": "str",  # This id is used to uniquely identify a
                          device registration of an enrollment."nA case-insensitive string (up to 128
                          characters long) of alphanumeric characters plus certain special characters :
                          . _ -. No special characters allowed at start or end. Required.
                        "allocationPolicy": "str",  # Optional. The allocation policy of this
                          resource. This policy overrides the tenant level allocation policy for this
                          individual enrollment or enrollment group. Possible values include 'hashed':
                          Linked IoT hubs are equally likely to have devices provisioned to them,
                          'geoLatency':  Devices are provisioned to an IoT hub with the lowest latency
                          to the device.If multiple linked IoT hubs would provide the same lowest
                          latency, the provisioning service hashes devices across those hubs, 'static'
                          : Specification of the desired IoT hub in the enrollment list takes priority
                          over the service-level allocation policy, 'custom': Devices are provisioned
                          to an IoT hub based on your own custom logic. The provisioning service passes
                          information about the device to the logic, and the logic returns the desired
                          IoT hub as well as the desired initial configuration. We recommend using
                          Azure Functions to host your logic. Known values are: "hashed", "geoLatency",
                          "static", and "custom".
                        "capabilities": {
                            "iotEdge": False  # Default value is False. If set to true,
                              this device is an IoTEdge device. Required.
                        },
                        "createdDateTimeUtc": "2020-02-20 00:00:00",  # Optional. The
                          DateTime this resource was created.
                        "customAllocationDefinition": {
                            "apiVersion": "str",  # The API version of the provisioning
                              service types (such as Enrollment) sent in the custom
                              allocation request. Minimum supported version: "2018-09-01-preview".
                              Required.
                            "webhookUrl": "str"  # The webhook URL used for allocation
                              requests. Required.
                        },
                        "deviceId": "str",  # Optional. Desired IoT Hub device ID (optional).
                        "etag": "str",  # Optional. The entity tag associated with the
                          resource.
                        "initialTwin": {
                            "properties": {
                                "desired": {
                                    "count": 0,  # Optional. Number of properties
                                      in the TwinCollection.
                                    "metadata": {
                                        "lastUpdated": "2020-02-20 00:00:00",
                                          # Optional. Last time the TwinCollection was updated.
                                        "lastUpdatedVersion": 0  # Optional.
                                          This is null for reported properties metadata and is not null
                                          for desired properties metadata.
                                    },
                                    "version": 0  # Optional. Version of the
                                      TwinCollection.
                                }
                            },
                            "tags": {
                                "count": 0,  # Optional. Number of properties in the
                                  TwinCollection.
                                "metadata": {
                                    "lastUpdated": "2020-02-20 00:00:00",  #
                                      Optional. Last time the TwinCollection was updated.
                                    "lastUpdatedVersion": 0  # Optional. This is
                                      null for reported properties metadata and is not null for desired
                                      properties metadata.
                                },
                                "version": 0  # Optional. Version of the
                                  TwinCollection.
                            }
                        },
                        "iotHubHostName": "str",  # Optional. The Iot Hub host name.
                        "iotHubs": [
                            "str"  # Optional. The list of IoT Hub hostnames the
                              device(s) in this resource can be allocated to. Must be a subset of
                              tenant level list of IoT hubs.
                        ],
                        "lastUpdatedDateTimeUtc": "2020-02-20 00:00:00",  # Optional. The
                          DateTime this resource was last updated.
                        "optionalDeviceInformation": {
                            "count": 0,  # Optional. Number of properties in the
                              TwinCollection.
                            "metadata": {
                                "lastUpdated": "2020-02-20 00:00:00",  # Optional.
                                  Last time the TwinCollection was updated.
                                "lastUpdatedVersion": 0  # Optional. This is null for
                                  reported properties metadata and is not null for desired properties
                                  metadata.
                            },
                            "version": 0  # Optional. Version of the TwinCollection.
                        },
                        "provisioningStatus": "enabled",  # Optional. Default value is
                          "enabled". The provisioning status. Known values are: "enabled" and
                          "disabled".
                        "registrationState": {
                            "assignedHub": "str",  # Optional. Assigned Azure IoT Hub.
                            "createdDateTimeUtc": "2020-02-20 00:00:00",  # Optional.
                              Registration create date time (in UTC).
                            "deviceId": "str",  # Optional. Device ID.
                            "errorCode": 0,  # Optional. Error code.
                            "errorMessage": "str",  # Optional. Error message.
                            "etag": "str",  # Optional. The entity tag associated with
                              the resource.
                            "lastUpdatedDateTimeUtc": "2020-02-20 00:00:00",  # Optional.
                              Last updated date time (in UTC).
                            "payload": {},  # Optional. Custom allocation payload
                              returned from the webhook to the device.
                            "registrationId": "str",  # Optional. This id is used to
                              uniquely identify a device registration of an enrollment."nA
                              case-insensitive string (up to 128 characters long) of alphanumeric
                              characters plus certain special characters : . _ -. No special characters
                              allowed at start or end.
                            "status": "str",  # Optional. Enrollment status. Known values
                              are: "unassigned", "assigning", "assigned", "failed", and "disabled".
                            "substatus": "str"  # Optional. Substatus for 'Assigned'
                              devices. Possible values include - 'initialAssignment': Device has been
                              assigned to an IoT hub for the first time, 'deviceDataMigrated': Device
                              has been assigned to a different IoT hub and its device data was migrated
                              from the previously assigned IoT hub. Device data was removed from the
                              previously assigned IoT hub, 'deviceDataReset':  Device has been assigned
                              to a different IoT hub and its device data was populated from the initial
                              state stored in the enrollment. Device data was removed from the
                              previously assigned IoT hub, 'reprovisionedToInitialAssignment': Device
                              has been re-provisioned to a previously assigned IoT hub. Known values
                              are: "initialAssignment", "deviceDataMigrated", "deviceDataReset", and
                              "reprovisionedToInitialAssignment".
                        },
                        "reprovisionPolicy": {
                            "migrateDeviceData": True,  # Default value is True. When set
                              to true (default), the Device Provisioning Service will migrate the
                              device's data (twin, device capabilities, and device ID) from one IoT hub
                              to another during an IoT hub assignment update. If set to false, the
                              Device Provisioning Service will reset the device's data to the initial
                              desired configuration stored in the corresponding enrollment list.
                            "updateHubAssignment": True  # Default value is True. When
                              set to true (default), the Device Provisioning Service will evaluate the
                              device's IoT Hub assignment and update it if necessary for any
                              provisioning requests beyond the first from a given device. If set to
                              false, the device will stay assigned to its current IoT hub.
                        }
                    }
                ]
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(query_specification, (IOBase, bytes)):
            _content = query_specification
        else:
            _json = query_specification

        request = build_enrollment_query_request(
            x_ms_max_item_count=x_ms_max_item_count,
            x_ms_continuation=x_ms_continuation,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["x-ms-continuation"] = self._deserialize("str", response.headers.get("x-ms-continuation"))
        response_headers["x-ms-max-item-count"] = self._deserialize("int", response.headers.get("x-ms-max-item-count"))
        response_headers["x-ms-item-type"] = self._deserialize("str", response.headers.get("x-ms-item-type"))

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), response_headers)

        return cast(List[JSON], deserialized)

    @distributed_trace
    def get_attestation_mechanism(self, id: str, **kwargs: Any) -> JSON:
        """Get the attestation mechanism in the device enrollment record.

        Get the attestation mechanism in the device enrollment record.

        :param id: This id is used to uniquely identify a device registration of an enrollment. A
         case-insensitive string (up to 128 characters long) of alphanumeric characters plus certain
         special characters : . _ -. No special characters allowed at start or end. Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "type": "str",  # Attestation Type. Required. Known values are: "none",
                      "tpm", "x509", and "symmetricKey".
                    "symmetricKey": {
                        "primaryKey": "str",  # Optional. Primary symmetric key.
                        "secondaryKey": "str"  # Optional. Secondary symmetric key.
                    },
                    "tpm": {
                        "endorsementKey": "str",  # Required.
                        "storageRootKey": "str"  # Optional. TPM attestation method.
                    },
                    "x509": {
                        "caReferences": {
                            "primary": "str",  # Optional. Primary and secondary CA
                              references.
                            "secondary": "str"  # Optional. Primary and secondary CA
                              references.
                        },
                        "clientCertificates": {
                            "primary": {
                                "certificate": "str",  # Optional. Certificate and
                                  Certificate info.
                                "info": {
                                    "issuerName": "str",  # Required.
                                    "notAfterUtc": "2020-02-20 00:00:00",  #
                                      Required.
                                    "notBeforeUtc": "2020-02-20 00:00:00",  #
                                      Required.
                                    "serialNumber": "str",  # Required.
                                    "sha1Thumbprint": "str",  # Required.
                                    "sha256Thumbprint": "str",  # Required.
                                    "subjectName": "str",  # Required.
                                    "version": 0  # Required.
                                }
                            },
                            "secondary": {
                                "certificate": "str",  # Optional. Certificate and
                                  Certificate info.
                                "info": {
                                    "issuerName": "str",  # Required.
                                    "notAfterUtc": "2020-02-20 00:00:00",  #
                                      Required.
                                    "notBeforeUtc": "2020-02-20 00:00:00",  #
                                      Required.
                                    "serialNumber": "str",  # Required.
                                    "sha1Thumbprint": "str",  # Required.
                                    "sha256Thumbprint": "str",  # Required.
                                    "subjectName": "str",  # Required.
                                    "version": 0  # Required.
                                }
                            }
                        },
                        "signingCertificates": {
                            "primary": {
                                "certificate": "str",  # Optional. Certificate and
                                  Certificate info.
                                "info": {
                                    "issuerName": "str",  # Required.
                                    "notAfterUtc": "2020-02-20 00:00:00",  #
                                      Required.
                                    "notBeforeUtc": "2020-02-20 00:00:00",  #
                                      Required.
                                    "serialNumber": "str",  # Required.
                                    "sha1Thumbprint": "str",  # Required.
                                    "sha256Thumbprint": "str",  # Required.
                                    "subjectName": "str",  # Required.
                                    "version": 0  # Required.
                                }
                            },
                            "secondary": {
                                "certificate": "str",  # Optional. Certificate and
                                  Certificate info.
                                "info": {
                                    "issuerName": "str",  # Required.
                                    "notAfterUtc": "2020-02-20 00:00:00",  #
                                      Required.
                                    "notBeforeUtc": "2020-02-20 00:00:00",  #
                                      Required.
                                    "serialNumber": "str",  # Required.
                                    "sha1Thumbprint": "str",  # Required.
                                    "sha256Thumbprint": "str",  # Required.
                                    "subjectName": "str",  # Required.
                                    "version": 0  # Required.
                                }
                            }
                        }
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_enrollment_get_attestation_mechanism_request(
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    def run_bulk_operation(
        self, bulk_operation: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Bulk device enrollment operation with maximum of 10 enrollments.

        Bulk device enrollment operation with maximum of 10 enrollments.

        :param bulk_operation: Bulk operation. Required.
        :type bulk_operation: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                bulk_operation = {
                    "enrollments": [
                        {
                            "attestation": {
                                "type": "str",  # Attestation Type. Required. Known
                                  values are: "none", "tpm", "x509", and "symmetricKey".
                                "symmetricKey": {
                                    "primaryKey": "str",  # Optional. Primary
                                      symmetric key.
                                    "secondaryKey": "str"  # Optional. Secondary
                                      symmetric key.
                                },
                                "tpm": {
                                    "endorsementKey": "str",  # Required.
                                    "storageRootKey": "str"  # Optional. TPM
                                      attestation method.
                                },
                                "x509": {
                                    "caReferences": {
                                        "primary": "str",  # Optional.
                                          Primary and secondary CA references.
                                        "secondary": "str"  # Optional.
                                          Primary and secondary CA references.
                                    },
                                    "clientCertificates": {
                                        "primary": {
                                            "certificate": "str",  #
                                              Optional. Certificate and Certificate info.
                                            "info": {
                                                "issuerName": "str",
                                                  # Required.
                                                "notAfterUtc":
                                                  "2020-02-20 00:00:00",  # Required.
                                                "notBeforeUtc":
                                                  "2020-02-20 00:00:00",  # Required.
                                                "serialNumber":
                                                  "str",  # Required.
                                                "sha1Thumbprint":
                                                  "str",  # Required.
                                                "sha256Thumbprint":
                                                  "str",  # Required.
                                                "subjectName": "str",
                                                  # Required.
                                                "version": 0  #
                                                  Required.
                                            }
                                        },
                                        "secondary": {
                                            "certificate": "str",  #
                                              Optional. Certificate and Certificate info.
                                            "info": {
                                                "issuerName": "str",
                                                  # Required.
                                                "notAfterUtc":
                                                  "2020-02-20 00:00:00",  # Required.
                                                "notBeforeUtc":
                                                  "2020-02-20 00:00:00",  # Required.
                                                "serialNumber":
                                                  "str",  # Required.
                                                "sha1Thumbprint":
                                                  "str",  # Required.
                                                "sha256Thumbprint":
                                                  "str",  # Required.
                                                "subjectName": "str",
                                                  # Required.
                                                "version": 0  #
                                                  Required.
                                            }
                                        }
                                    },
                                    "signingCertificates": {
                                        "primary": {
                                            "certificate": "str",  #
                                              Optional. Certificate and Certificate info.
                                            "info": {
                                                "issuerName": "str",
                                                  # Required.
                                                "notAfterUtc":
                                                  "2020-02-20 00:00:00",  # Required.
                                                "notBeforeUtc":
                                                  "2020-02-20 00:00:00",  # Required.
                                                "serialNumber":
                                                  "str",  # Required.
                                                "sha1Thumbprint":
                                                  "str",  # Required.
                                                "sha256Thumbprint":
                                                  "str",  # Required.
                                                "subjectName": "str",
                                                  # Required.
                                                "version": 0  #
                                                  Required.
                                            }
                                        },
                                        "secondary": {
                                            "certificate": "str",  #
                                              Optional. Certificate and Certificate info.
                                            "info": {
                                                "issuerName": "str",
                                                  # Required.
                                                "notAfterUtc":
                                                  "2020-02-20 00:00:00",  # Required.
                                                "notBeforeUtc":
                                                  "2020-02-20 00:00:00",  # Required.
                                                "serialNumber":
                                                  "str",  # Required.
                                                "sha1Thumbprint":
                                                  "str",  # Required.
                                                "sha256Thumbprint":
                                                  "str",  # Required.
                                                "subjectName": "str",
                                                  # Required.
                                                "version": 0  #
                                                  Required.
                                            }
                                        }
                                    }
                                }
                            },
                            "registrationId": "str",  # This id is used to uniquely
                              identify a device registration of an enrollment."nA case-insensitive
                              string (up to 128 characters long) of alphanumeric characters plus
                              certain special characters : . _ -. No special characters allowed at
                              start or end. Required.
                            "allocationPolicy": "str",  # Optional. The allocation policy
                              of this resource. This policy overrides the tenant level allocation
                              policy for this individual enrollment or enrollment group. Possible
                              values include 'hashed': Linked IoT hubs are equally likely to have
                              devices provisioned to them, 'geoLatency':  Devices are provisioned to an
                              IoT hub with the lowest latency to the device.If multiple linked IoT hubs
                              would provide the same lowest latency, the provisioning service hashes
                              devices across those hubs, 'static' : Specification of the desired IoT
                              hub in the enrollment list takes priority over the service-level
                              allocation policy, 'custom': Devices are provisioned to an IoT hub based
                              on your own custom logic. The provisioning service passes information
                              about the device to the logic, and the logic returns the desired IoT hub
                              as well as the desired initial configuration. We recommend using Azure
                              Functions to host your logic. Known values are: "hashed", "geoLatency",
                              "static", and "custom".
                            "capabilities": {
                                "iotEdge": False  # Default value is False. If set to
                                  true, this device is an IoTEdge device. Required.
                            },
                            "createdDateTimeUtc": "2020-02-20 00:00:00",  # Optional. The
                              DateTime this resource was created.
                            "customAllocationDefinition": {
                                "apiVersion": "str",  # The API version of the
                                  provisioning service types (such as Enrollment) sent in the
                                  custom allocation request. Minimum supported version:
                                  "2018-09-01-preview". Required.
                                "webhookUrl": "str"  # The webhook URL used for
                                  allocation requests. Required.
                            },
                            "deviceId": "str",  # Optional. Desired IoT Hub device ID
                              (optional).
                            "etag": "str",  # Optional. The entity tag associated with
                              the resource.
                            "initialTwin": {
                                "properties": {
                                    "desired": {
                                        "count": 0,  # Optional. Number of
                                          properties in the TwinCollection.
                                        "metadata": {
                                            "lastUpdated": "2020-02-20
                                              00:00:00",  # Optional. Last time the TwinCollection was
                                              updated.
                                            "lastUpdatedVersion": 0  #
                                              Optional. This is null for reported properties metadata
                                              and is not null for desired properties metadata.
                                        },
                                        "version": 0  # Optional. Version of
                                          the TwinCollection.
                                    }
                                },
                                "tags": {
                                    "count": 0,  # Optional. Number of properties
                                      in the TwinCollection.
                                    "metadata": {
                                        "lastUpdated": "2020-02-20 00:00:00",
                                          # Optional. Last time the TwinCollection was updated.
                                        "lastUpdatedVersion": 0  # Optional.
                                          This is null for reported properties metadata and is not null
                                          for desired properties metadata.
                                    },
                                    "version": 0  # Optional. Version of the
                                      TwinCollection.
                                }
                            },
                            "iotHubHostName": "str",  # Optional. The Iot Hub host name.
                            "iotHubs": [
                                "str"  # Optional. The list of IoT Hub hostnames the
                                  device(s) in this resource can be allocated to. Must be a subset of
                                  tenant level list of IoT hubs.
                            ],
                            "lastUpdatedDateTimeUtc": "2020-02-20 00:00:00",  # Optional.
                              The DateTime this resource was last updated.
                            "optionalDeviceInformation": {
                                "count": 0,  # Optional. Number of properties in the
                                  TwinCollection.
                                "metadata": {
                                    "lastUpdated": "2020-02-20 00:00:00",  #
                                      Optional. Last time the TwinCollection was updated.
                                    "lastUpdatedVersion": 0  # Optional. This is
                                      null for reported properties metadata and is not null for desired
                                      properties metadata.
                                },
                                "version": 0  # Optional. Version of the
                                  TwinCollection.
                            },
                            "provisioningStatus": "enabled",  # Optional. Default value
                              is "enabled". The provisioning status. Known values are: "enabled" and
                              "disabled".
                            "registrationState": {
                                "assignedHub": "str",  # Optional. Assigned Azure IoT
                                  Hub.
                                "createdDateTimeUtc": "2020-02-20 00:00:00",  #
                                  Optional. Registration create date time (in UTC).
                                "deviceId": "str",  # Optional. Device ID.
                                "errorCode": 0,  # Optional. Error code.
                                "errorMessage": "str",  # Optional. Error message.
                                "etag": "str",  # Optional. The entity tag associated
                                  with the resource.
                                "lastUpdatedDateTimeUtc": "2020-02-20 00:00:00",  #
                                  Optional. Last updated date time (in UTC).
                                "payload": {},  # Optional. Custom allocation payload
                                  returned from the webhook to the device.
                                "registrationId": "str",  # Optional. This id is used
                                  to uniquely identify a device registration of an enrollment."nA
                                  case-insensitive string (up to 128 characters long) of alphanumeric
                                  characters plus certain special characters : . _ -. No special
                                  characters allowed at start or end.
                                "status": "str",  # Optional. Enrollment status.
                                  Known values are: "unassigned", "assigning", "assigned", "failed",
                                  and "disabled".
                                "substatus": "str"  # Optional. Substatus for
                                  'Assigned' devices. Possible values include - 'initialAssignment':
                                  Device has been assigned to an IoT hub for the first time,
                                  'deviceDataMigrated': Device has been assigned to a different IoT hub
                                  and its device data was migrated from the previously assigned IoT
                                  hub. Device data was removed from the previously assigned IoT hub,
                                  'deviceDataReset':  Device has been assigned to a different IoT hub
                                  and its device data was populated from the initial state stored in
                                  the enrollment. Device data was removed from the previously assigned
                                  IoT hub, 'reprovisionedToInitialAssignment': Device has been
                                  re-provisioned to a previously assigned IoT hub. Known values are:
                                  "initialAssignment", "deviceDataMigrated", "deviceDataReset", and
                                  "reprovisionedToInitialAssignment".
                            },
                            "reprovisionPolicy": {
                                "migrateDeviceData": True,  # Default value is True.
                                  When set to true (default), the Device Provisioning Service will
                                  migrate the device's data (twin, device capabilities, and device ID)
                                  from one IoT hub to another during an IoT hub assignment update. If
                                  set to false, the Device Provisioning Service will reset the device's
                                  data to the initial desired configuration stored in the corresponding
                                  enrollment list.
                                "updateHubAssignment": True  # Default value is True.
                                  When set to true (default), the Device Provisioning Service will
                                  evaluate the device's IoT Hub assignment and update it if necessary
                                  for any provisioning requests beyond the first from a given device.
                                  If set to false, the device will stay assigned to its current IoT
                                  hub.
                            }
                        }
                    ],
                    "mode": "str"  # Operation mode. Required. Known values are: "create",
                      "update", "updateIfMatchETag", and "delete".
                }

                # response body for status code(s): 200
                response == {
                    "isSuccessful": bool,  # Indicates if the operation was successful in its
                      entirety. Required.
                    "errors": [
                        {
                            "errorCode": 0,  # Error code. Required.
                            "errorStatus": "str",  # Error status. Required.
                            "registrationId": "str"  # This id is used to uniquely
                              identify a device registration of an enrollment."nA case-insensitive
                              string (up to 128 characters long) of alphanumeric characters plus
                              certain special characters : . _ -. No special characters allowed at
                              start or end. Required.
                        }
                    ]
                }
        """

    @overload
    def run_bulk_operation(self, bulk_operation: IO, *, content_type: str = "application/json", **kwargs: Any) -> JSON:
        """Bulk device enrollment operation with maximum of 10 enrollments.

        Bulk device enrollment operation with maximum of 10 enrollments.

        :param bulk_operation: Bulk operation. Required.
        :type bulk_operation: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "isSuccessful": bool,  # Indicates if the operation was successful in its
                      entirety. Required.
                    "errors": [
                        {
                            "errorCode": 0,  # Error code. Required.
                            "errorStatus": "str",  # Error status. Required.
                            "registrationId": "str"  # This id is used to uniquely
                              identify a device registration of an enrollment."nA case-insensitive
                              string (up to 128 characters long) of alphanumeric characters plus
                              certain special characters : . _ -. No special characters allowed at
                              start or end. Required.
                        }
                    ]
                }
        """

    @distributed_trace
    def run_bulk_operation(self, bulk_operation: Union[JSON, IO], **kwargs: Any) -> JSON:
        """Bulk device enrollment operation with maximum of 10 enrollments.

        Bulk device enrollment operation with maximum of 10 enrollments.

        :param bulk_operation: Bulk operation. Is either a JSON type or a IO type. Required.
        :type bulk_operation: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                bulk_operation = {
                    "enrollments": [
                        {
                            "attestation": {
                                "type": "str",  # Attestation Type. Required. Known
                                  values are: "none", "tpm", "x509", and "symmetricKey".
                                "symmetricKey": {
                                    "primaryKey": "str",  # Optional. Primary
                                      symmetric key.
                                    "secondaryKey": "str"  # Optional. Secondary
                                      symmetric key.
                                },
                                "tpm": {
                                    "endorsementKey": "str",  # Required.
                                    "storageRootKey": "str"  # Optional. TPM
                                      attestation method.
                                },
                                "x509": {
                                    "caReferences": {
                                        "primary": "str",  # Optional.
                                          Primary and secondary CA references.
                                        "secondary": "str"  # Optional.
                                          Primary and secondary CA references.
                                    },
                                    "clientCertificates": {
                                        "primary": {
                                            "certificate": "str",  #
                                              Optional. Certificate and Certificate info.
                                            "info": {
                                                "issuerName": "str",
                                                  # Required.
                                                "notAfterUtc":
                                                  "2020-02-20 00:00:00",  # Required.
                                                "notBeforeUtc":
                                                  "2020-02-20 00:00:00",  # Required.
                                                "serialNumber":
                                                  "str",  # Required.
                                                "sha1Thumbprint":
                                                  "str",  # Required.
                                                "sha256Thumbprint":
                                                  "str",  # Required.
                                                "subjectName": "str",
                                                  # Required.
                                                "version": 0  #
                                                  Required.
                                            }
                                        },
                                        "secondary": {
                                            "certificate": "str",  #
                                              Optional. Certificate and Certificate info.
                                            "info": {
                                                "issuerName": "str",
                                                  # Required.
                                                "notAfterUtc":
                                                  "2020-02-20 00:00:00",  # Required.
                                                "notBeforeUtc":
                                                  "2020-02-20 00:00:00",  # Required.
                                                "serialNumber":
                                                  "str",  # Required.
                                                "sha1Thumbprint":
                                                  "str",  # Required.
                                                "sha256Thumbprint":
                                                  "str",  # Required.
                                                "subjectName": "str",
                                                  # Required.
                                                "version": 0  #
                                                  Required.
                                            }
                                        }
                                    },
                                    "signingCertificates": {
                                        "primary": {
                                            "certificate": "str",  #
                                              Optional. Certificate and Certificate info.
                                            "info": {
                                                "issuerName": "str",
                                                  # Required.
                                                "notAfterUtc":
                                                  "2020-02-20 00:00:00",  # Required.
                                                "notBeforeUtc":
                                                  "2020-02-20 00:00:00",  # Required.
                                                "serialNumber":
                                                  "str",  # Required.
                                                "sha1Thumbprint":
                                                  "str",  # Required.
                                                "sha256Thumbprint":
                                                  "str",  # Required.
                                                "subjectName": "str",
                                                  # Required.
                                                "version": 0  #
                                                  Required.
                                            }
                                        },
                                        "secondary": {
                                            "certificate": "str",  #
                                              Optional. Certificate and Certificate info.
                                            "info": {
                                                "issuerName": "str",
                                                  # Required.
                                                "notAfterUtc":
                                                  "2020-02-20 00:00:00",  # Required.
                                                "notBeforeUtc":
                                                  "2020-02-20 00:00:00",  # Required.
                                                "serialNumber":
                                                  "str",  # Required.
                                                "sha1Thumbprint":
                                                  "str",  # Required.
                                                "sha256Thumbprint":
                                                  "str",  # Required.
                                                "subjectName": "str",
                                                  # Required.
                                                "version": 0  #
                                                  Required.
                                            }
                                        }
                                    }
                                }
                            },
                            "registrationId": "str",  # This id is used to uniquely
                              identify a device registration of an enrollment."nA case-insensitive
                              string (up to 128 characters long) of alphanumeric characters plus
                              certain special characters : . _ -. No special characters allowed at
                              start or end. Required.
                            "allocationPolicy": "str",  # Optional. The allocation policy
                              of this resource. This policy overrides the tenant level allocation
                              policy for this individual enrollment or enrollment group. Possible
                              values include 'hashed': Linked IoT hubs are equally likely to have
                              devices provisioned to them, 'geoLatency':  Devices are provisioned to an
                              IoT hub with the lowest latency to the device.If multiple linked IoT hubs
                              would provide the same lowest latency, the provisioning service hashes
                              devices across those hubs, 'static' : Specification of the desired IoT
                              hub in the enrollment list takes priority over the service-level
                              allocation policy, 'custom': Devices are provisioned to an IoT hub based
                              on your own custom logic. The provisioning service passes information
                              about the device to the logic, and the logic returns the desired IoT hub
                              as well as the desired initial configuration. We recommend using Azure
                              Functions to host your logic. Known values are: "hashed", "geoLatency",
                              "static", and "custom".
                            "capabilities": {
                                "iotEdge": False  # Default value is False. If set to
                                  true, this device is an IoTEdge device. Required.
                            },
                            "createdDateTimeUtc": "2020-02-20 00:00:00",  # Optional. The
                              DateTime this resource was created.
                            "customAllocationDefinition": {
                                "apiVersion": "str",  # The API version of the
                                  provisioning service types (such as Enrollment) sent in the
                                  custom allocation request. Minimum supported version:
                                  "2018-09-01-preview". Required.
                                "webhookUrl": "str"  # The webhook URL used for
                                  allocation requests. Required.
                            },
                            "deviceId": "str",  # Optional. Desired IoT Hub device ID
                              (optional).
                            "etag": "str",  # Optional. The entity tag associated with
                              the resource.
                            "initialTwin": {
                                "properties": {
                                    "desired": {
                                        "count": 0,  # Optional. Number of
                                          properties in the TwinCollection.
                                        "metadata": {
                                            "lastUpdated": "2020-02-20
                                              00:00:00",  # Optional. Last time the TwinCollection was
                                              updated.
                                            "lastUpdatedVersion": 0  #
                                              Optional. This is null for reported properties metadata
                                              and is not null for desired properties metadata.
                                        },
                                        "version": 0  # Optional. Version of
                                          the TwinCollection.
                                    }
                                },
                                "tags": {
                                    "count": 0,  # Optional. Number of properties
                                      in the TwinCollection.
                                    "metadata": {
                                        "lastUpdated": "2020-02-20 00:00:00",
                                          # Optional. Last time the TwinCollection was updated.
                                        "lastUpdatedVersion": 0  # Optional.
                                          This is null for reported properties metadata and is not null
                                          for desired properties metadata.
                                    },
                                    "version": 0  # Optional. Version of the
                                      TwinCollection.
                                }
                            },
                            "iotHubHostName": "str",  # Optional. The Iot Hub host name.
                            "iotHubs": [
                                "str"  # Optional. The list of IoT Hub hostnames the
                                  device(s) in this resource can be allocated to. Must be a subset of
                                  tenant level list of IoT hubs.
                            ],
                            "lastUpdatedDateTimeUtc": "2020-02-20 00:00:00",  # Optional.
                              The DateTime this resource was last updated.
                            "optionalDeviceInformation": {
                                "count": 0,  # Optional. Number of properties in the
                                  TwinCollection.
                                "metadata": {
                                    "lastUpdated": "2020-02-20 00:00:00",  #
                                      Optional. Last time the TwinCollection was updated.
                                    "lastUpdatedVersion": 0  # Optional. This is
                                      null for reported properties metadata and is not null for desired
                                      properties metadata.
                                },
                                "version": 0  # Optional. Version of the
                                  TwinCollection.
                            },
                            "provisioningStatus": "enabled",  # Optional. Default value
                              is "enabled". The provisioning status. Known values are: "enabled" and
                              "disabled".
                            "registrationState": {
                                "assignedHub": "str",  # Optional. Assigned Azure IoT
                                  Hub.
                                "createdDateTimeUtc": "2020-02-20 00:00:00",  #
                                  Optional. Registration create date time (in UTC).
                                "deviceId": "str",  # Optional. Device ID.
                                "errorCode": 0,  # Optional. Error code.
                                "errorMessage": "str",  # Optional. Error message.
                                "etag": "str",  # Optional. The entity tag associated
                                  with the resource.
                                "lastUpdatedDateTimeUtc": "2020-02-20 00:00:00",  #
                                  Optional. Last updated date time (in UTC).
                                "payload": {},  # Optional. Custom allocation payload
                                  returned from the webhook to the device.
                                "registrationId": "str",  # Optional. This id is used
                                  to uniquely identify a device registration of an enrollment."nA
                                  case-insensitive string (up to 128 characters long) of alphanumeric
                                  characters plus certain special characters : . _ -. No special
                                  characters allowed at start or end.
                                "status": "str",  # Optional. Enrollment status.
                                  Known values are: "unassigned", "assigning", "assigned", "failed",
                                  and "disabled".
                                "substatus": "str"  # Optional. Substatus for
                                  'Assigned' devices. Possible values include - 'initialAssignment':
                                  Device has been assigned to an IoT hub for the first time,
                                  'deviceDataMigrated': Device has been assigned to a different IoT hub
                                  and its device data was migrated from the previously assigned IoT
                                  hub. Device data was removed from the previously assigned IoT hub,
                                  'deviceDataReset':  Device has been assigned to a different IoT hub
                                  and its device data was populated from the initial state stored in
                                  the enrollment. Device data was removed from the previously assigned
                                  IoT hub, 'reprovisionedToInitialAssignment': Device has been
                                  re-provisioned to a previously assigned IoT hub. Known values are:
                                  "initialAssignment", "deviceDataMigrated", "deviceDataReset", and
                                  "reprovisionedToInitialAssignment".
                            },
                            "reprovisionPolicy": {
                                "migrateDeviceData": True,  # Default value is True.
                                  When set to true (default), the Device Provisioning Service will
                                  migrate the device's data (twin, device capabilities, and device ID)
                                  from one IoT hub to another during an IoT hub assignment update. If
                                  set to false, the Device Provisioning Service will reset the device's
                                  data to the initial desired configuration stored in the corresponding
                                  enrollment list.
                                "updateHubAssignment": True  # Default value is True.
                                  When set to true (default), the Device Provisioning Service will
                                  evaluate the device's IoT Hub assignment and update it if necessary
                                  for any provisioning requests beyond the first from a given device.
                                  If set to false, the device will stay assigned to its current IoT
                                  hub.
                            }
                        }
                    ],
                    "mode": "str"  # Operation mode. Required. Known values are: "create",
                      "update", "updateIfMatchETag", and "delete".
                }

                # response body for status code(s): 200
                response == {
                    "isSuccessful": bool,  # Indicates if the operation was successful in its
                      entirety. Required.
                    "errors": [
                        {
                            "errorCode": 0,  # Error code. Required.
                            "errorStatus": "str",  # Error status. Required.
                            "registrationId": "str"  # This id is used to uniquely
                              identify a device registration of an enrollment."nA case-insensitive
                              string (up to 128 characters long) of alphanumeric characters plus
                              certain special characters : . _ -. No special characters allowed at
                              start or end. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(bulk_operation, (IOBase, bytes)):
            _content = bulk_operation
        else:
            _json = bulk_operation

        request = build_enrollment_run_bulk_operation_request(
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)


class EnrollmentGroupOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.iot.deviceprovisioning.DeviceProvisioningClient`'s
        :attr:`enrollment_group` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def get(self, id: str, **kwargs: Any) -> JSON:
        """Get a device enrollment group.

        Get a device enrollment group.

        :param id: Enrollment group ID. Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "attestation": {
                        "type": "str",  # Attestation Type. Required. Known values are:
                          "none", "tpm", "x509", and "symmetricKey".
                        "symmetricKey": {
                            "primaryKey": "str",  # Optional. Primary symmetric key.
                            "secondaryKey": "str"  # Optional. Secondary symmetric key.
                        },
                        "tpm": {
                            "endorsementKey": "str",  # Required.
                            "storageRootKey": "str"  # Optional. TPM attestation method.
                        },
                        "x509": {
                            "caReferences": {
                                "primary": "str",  # Optional. Primary and secondary
                                  CA references.
                                "secondary": "str"  # Optional. Primary and secondary
                                  CA references.
                            },
                            "clientCertificates": {
                                "primary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                },
                                "secondary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                }
                            },
                            "signingCertificates": {
                                "primary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                },
                                "secondary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                }
                            }
                        }
                    },
                    "enrollmentGroupId": "str",  # Enrollment Group ID. Required.
                    "allocationPolicy": "str",  # Optional. The allocation policy of this
                      resource. This policy overrides the tenant level allocation policy for this
                      individual enrollment or enrollment group. Possible values include 'hashed':
                      Linked IoT hubs are equally likely to have devices provisioned to them,
                      'geoLatency':  Devices are provisioned to an IoT hub with the lowest latency to
                      the device.If multiple linked IoT hubs would provide the same lowest latency, the
                      provisioning service hashes devices across those hubs, 'static' : Specification
                      of the desired IoT hub in the enrollment list takes priority over the
                      service-level allocation policy, 'custom': Devices are provisioned to an IoT hub
                      based on your own custom logic. The provisioning service passes information about
                      the device to the logic, and the logic returns the desired IoT hub as well as the
                      desired initial configuration. We recommend using Azure Functions to host your
                      logic. Known values are: "hashed", "geoLatency", "static", and "custom".
                    "capabilities": {
                        "iotEdge": False  # Default value is False. If set to true, this
                          device is an IoTEdge device. Required.
                    },
                    "createdDateTimeUtc": "2020-02-20 00:00:00",  # Optional. The DateTime this
                      resource was created.
                    "customAllocationDefinition": {
                        "apiVersion": "str",  # The API version of the provisioning service
                          types (such as Enrollment) sent in the custom allocation request.
                          Minimum supported version: "2018-09-01-preview". Required.
                        "webhookUrl": "str"  # The webhook URL used for allocation requests.
                          Required.
                    },
                    "etag": "str",  # Optional. The entity tag associated with the resource.
                    "initialTwin": {
                        "properties": {
                            "desired": {
                                "count": 0,  # Optional. Number of properties in the
                                  TwinCollection.
                                "metadata": {
                                    "lastUpdated": "2020-02-20 00:00:00",  #
                                      Optional. Last time the TwinCollection was updated.
                                    "lastUpdatedVersion": 0  # Optional. This is
                                      null for reported properties metadata and is not null for desired
                                      properties metadata.
                                },
                                "version": 0  # Optional. Version of the
                                  TwinCollection.
                            }
                        },
                        "tags": {
                            "count": 0,  # Optional. Number of properties in the
                              TwinCollection.
                            "metadata": {
                                "lastUpdated": "2020-02-20 00:00:00",  # Optional.
                                  Last time the TwinCollection was updated.
                                "lastUpdatedVersion": 0  # Optional. This is null for
                                  reported properties metadata and is not null for desired properties
                                  metadata.
                            },
                            "version": 0  # Optional. Version of the TwinCollection.
                        }
                    },
                    "iotHubHostName": "str",  # Optional. The Iot Hub host name.
                    "iotHubs": [
                        "str"  # Optional. The list of IoT Hub hostnames the device(s) in
                          this resource can be allocated to. Must be a subset of tenant level list of
                          IoT hubs.
                    ],
                    "lastUpdatedDateTimeUtc": "2020-02-20 00:00:00",  # Optional. The DateTime
                      this resource was last updated.
                    "provisioningStatus": "enabled",  # Optional. Default value is "enabled". The
                      provisioning status. Known values are: "enabled" and "disabled".
                    "reprovisionPolicy": {
                        "migrateDeviceData": True,  # Default value is True. When set to true
                          (default), the Device Provisioning Service will migrate the device's data
                          (twin, device capabilities, and device ID) from one IoT hub to another during
                          an IoT hub assignment update. If set to false, the Device Provisioning
                          Service will reset the device's data to the initial desired configuration
                          stored in the corresponding enrollment list.
                        "updateHubAssignment": True  # Default value is True. When set to
                          true (default), the Device Provisioning Service will evaluate the device's
                          IoT Hub assignment and update it if necessary for any provisioning requests
                          beyond the first from a given device. If set to false, the device will stay
                          assigned to its current IoT hub.
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_enrollment_group_get_request(
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    def create_or_update(
        self,
        id: str,
        enrollment_group: JSON,
        *,
        if_match: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Create or update a device enrollment group.

        Create or update a device enrollment group.

        :param id: Enrollment group ID. Required.
        :type id: str
        :param enrollment_group: The device enrollment group. Required.
        :type enrollment_group: JSON
        :keyword if_match: The ETag of the enrollment record. Default value is None.
        :paramtype if_match: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                enrollment_group = {
                    "attestation": {
                        "type": "str",  # Attestation Type. Required. Known values are:
                          "none", "tpm", "x509", and "symmetricKey".
                        "symmetricKey": {
                            "primaryKey": "str",  # Optional. Primary symmetric key.
                            "secondaryKey": "str"  # Optional. Secondary symmetric key.
                        },
                        "tpm": {
                            "endorsementKey": "str",  # Required.
                            "storageRootKey": "str"  # Optional. TPM attestation method.
                        },
                        "x509": {
                            "caReferences": {
                                "primary": "str",  # Optional. Primary and secondary
                                  CA references.
                                "secondary": "str"  # Optional. Primary and secondary
                                  CA references.
                            },
                            "clientCertificates": {
                                "primary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                },
                                "secondary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                }
                            },
                            "signingCertificates": {
                                "primary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                },
                                "secondary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                }
                            }
                        }
                    },
                    "enrollmentGroupId": "str",  # Enrollment Group ID. Required.
                    "allocationPolicy": "str",  # Optional. The allocation policy of this
                      resource. This policy overrides the tenant level allocation policy for this
                      individual enrollment or enrollment group. Possible values include 'hashed':
                      Linked IoT hubs are equally likely to have devices provisioned to them,
                      'geoLatency':  Devices are provisioned to an IoT hub with the lowest latency to
                      the device.If multiple linked IoT hubs would provide the same lowest latency, the
                      provisioning service hashes devices across those hubs, 'static' : Specification
                      of the desired IoT hub in the enrollment list takes priority over the
                      service-level allocation policy, 'custom': Devices are provisioned to an IoT hub
                      based on your own custom logic. The provisioning service passes information about
                      the device to the logic, and the logic returns the desired IoT hub as well as the
                      desired initial configuration. We recommend using Azure Functions to host your
                      logic. Known values are: "hashed", "geoLatency", "static", and "custom".
                    "capabilities": {
                        "iotEdge": False  # Default value is False. If set to true, this
                          device is an IoTEdge device. Required.
                    },
                    "createdDateTimeUtc": "2020-02-20 00:00:00",  # Optional. The DateTime this
                      resource was created.
                    "customAllocationDefinition": {
                        "apiVersion": "str",  # The API version of the provisioning service
                          types (such as Enrollment) sent in the custom allocation request.
                          Minimum supported version: "2018-09-01-preview". Required.
                        "webhookUrl": "str"  # The webhook URL used for allocation requests.
                          Required.
                    },
                    "etag": "str",  # Optional. The entity tag associated with the resource.
                    "initialTwin": {
                        "properties": {
                            "desired": {
                                "count": 0,  # Optional. Number of properties in the
                                  TwinCollection.
                                "metadata": {
                                    "lastUpdated": "2020-02-20 00:00:00",  #
                                      Optional. Last time the TwinCollection was updated.
                                    "lastUpdatedVersion": 0  # Optional. This is
                                      null for reported properties metadata and is not null for desired
                                      properties metadata.
                                },
                                "version": 0  # Optional. Version of the
                                  TwinCollection.
                            }
                        },
                        "tags": {
                            "count": 0,  # Optional. Number of properties in the
                              TwinCollection.
                            "metadata": {
                                "lastUpdated": "2020-02-20 00:00:00",  # Optional.
                                  Last time the TwinCollection was updated.
                                "lastUpdatedVersion": 0  # Optional. This is null for
                                  reported properties metadata and is not null for desired properties
                                  metadata.
                            },
                            "version": 0  # Optional. Version of the TwinCollection.
                        }
                    },
                    "iotHubHostName": "str",  # Optional. The Iot Hub host name.
                    "iotHubs": [
                        "str"  # Optional. The list of IoT Hub hostnames the device(s) in
                          this resource can be allocated to. Must be a subset of tenant level list of
                          IoT hubs.
                    ],
                    "lastUpdatedDateTimeUtc": "2020-02-20 00:00:00",  # Optional. The DateTime
                      this resource was last updated.
                    "provisioningStatus": "enabled",  # Optional. Default value is "enabled". The
                      provisioning status. Known values are: "enabled" and "disabled".
                    "reprovisionPolicy": {
                        "migrateDeviceData": True,  # Default value is True. When set to true
                          (default), the Device Provisioning Service will migrate the device's data
                          (twin, device capabilities, and device ID) from one IoT hub to another during
                          an IoT hub assignment update. If set to false, the Device Provisioning
                          Service will reset the device's data to the initial desired configuration
                          stored in the corresponding enrollment list.
                        "updateHubAssignment": True  # Default value is True. When set to
                          true (default), the Device Provisioning Service will evaluate the device's
                          IoT Hub assignment and update it if necessary for any provisioning requests
                          beyond the first from a given device. If set to false, the device will stay
                          assigned to its current IoT hub.
                    }
                }

                # response body for status code(s): 200
                response == {
                    "attestation": {
                        "type": "str",  # Attestation Type. Required. Known values are:
                          "none", "tpm", "x509", and "symmetricKey".
                        "symmetricKey": {
                            "primaryKey": "str",  # Optional. Primary symmetric key.
                            "secondaryKey": "str"  # Optional. Secondary symmetric key.
                        },
                        "tpm": {
                            "endorsementKey": "str",  # Required.
                            "storageRootKey": "str"  # Optional. TPM attestation method.
                        },
                        "x509": {
                            "caReferences": {
                                "primary": "str",  # Optional. Primary and secondary
                                  CA references.
                                "secondary": "str"  # Optional. Primary and secondary
                                  CA references.
                            },
                            "clientCertificates": {
                                "primary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                },
                                "secondary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                }
                            },
                            "signingCertificates": {
                                "primary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                },
                                "secondary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                }
                            }
                        }
                    },
                    "enrollmentGroupId": "str",  # Enrollment Group ID. Required.
                    "allocationPolicy": "str",  # Optional. The allocation policy of this
                      resource. This policy overrides the tenant level allocation policy for this
                      individual enrollment or enrollment group. Possible values include 'hashed':
                      Linked IoT hubs are equally likely to have devices provisioned to them,
                      'geoLatency':  Devices are provisioned to an IoT hub with the lowest latency to
                      the device.If multiple linked IoT hubs would provide the same lowest latency, the
                      provisioning service hashes devices across those hubs, 'static' : Specification
                      of the desired IoT hub in the enrollment list takes priority over the
                      service-level allocation policy, 'custom': Devices are provisioned to an IoT hub
                      based on your own custom logic. The provisioning service passes information about
                      the device to the logic, and the logic returns the desired IoT hub as well as the
                      desired initial configuration. We recommend using Azure Functions to host your
                      logic. Known values are: "hashed", "geoLatency", "static", and "custom".
                    "capabilities": {
                        "iotEdge": False  # Default value is False. If set to true, this
                          device is an IoTEdge device. Required.
                    },
                    "createdDateTimeUtc": "2020-02-20 00:00:00",  # Optional. The DateTime this
                      resource was created.
                    "customAllocationDefinition": {
                        "apiVersion": "str",  # The API version of the provisioning service
                          types (such as Enrollment) sent in the custom allocation request.
                          Minimum supported version: "2018-09-01-preview". Required.
                        "webhookUrl": "str"  # The webhook URL used for allocation requests.
                          Required.
                    },
                    "etag": "str",  # Optional. The entity tag associated with the resource.
                    "initialTwin": {
                        "properties": {
                            "desired": {
                                "count": 0,  # Optional. Number of properties in the
                                  TwinCollection.
                                "metadata": {
                                    "lastUpdated": "2020-02-20 00:00:00",  #
                                      Optional. Last time the TwinCollection was updated.
                                    "lastUpdatedVersion": 0  # Optional. This is
                                      null for reported properties metadata and is not null for desired
                                      properties metadata.
                                },
                                "version": 0  # Optional. Version of the
                                  TwinCollection.
                            }
                        },
                        "tags": {
                            "count": 0,  # Optional. Number of properties in the
                              TwinCollection.
                            "metadata": {
                                "lastUpdated": "2020-02-20 00:00:00",  # Optional.
                                  Last time the TwinCollection was updated.
                                "lastUpdatedVersion": 0  # Optional. This is null for
                                  reported properties metadata and is not null for desired properties
                                  metadata.
                            },
                            "version": 0  # Optional. Version of the TwinCollection.
                        }
                    },
                    "iotHubHostName": "str",  # Optional. The Iot Hub host name.
                    "iotHubs": [
                        "str"  # Optional. The list of IoT Hub hostnames the device(s) in
                          this resource can be allocated to. Must be a subset of tenant level list of
                          IoT hubs.
                    ],
                    "lastUpdatedDateTimeUtc": "2020-02-20 00:00:00",  # Optional. The DateTime
                      this resource was last updated.
                    "provisioningStatus": "enabled",  # Optional. Default value is "enabled". The
                      provisioning status. Known values are: "enabled" and "disabled".
                    "reprovisionPolicy": {
                        "migrateDeviceData": True,  # Default value is True. When set to true
                          (default), the Device Provisioning Service will migrate the device's data
                          (twin, device capabilities, and device ID) from one IoT hub to another during
                          an IoT hub assignment update. If set to false, the Device Provisioning
                          Service will reset the device's data to the initial desired configuration
                          stored in the corresponding enrollment list.
                        "updateHubAssignment": True  # Default value is True. When set to
                          true (default), the Device Provisioning Service will evaluate the device's
                          IoT Hub assignment and update it if necessary for any provisioning requests
                          beyond the first from a given device. If set to false, the device will stay
                          assigned to its current IoT hub.
                    }
                }
        """

    @overload
    def create_or_update(
        self,
        id: str,
        enrollment_group: IO,
        *,
        if_match: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Create or update a device enrollment group.

        Create or update a device enrollment group.

        :param id: Enrollment group ID. Required.
        :type id: str
        :param enrollment_group: The device enrollment group. Required.
        :type enrollment_group: IO
        :keyword if_match: The ETag of the enrollment record. Default value is None.
        :paramtype if_match: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "attestation": {
                        "type": "str",  # Attestation Type. Required. Known values are:
                          "none", "tpm", "x509", and "symmetricKey".
                        "symmetricKey": {
                            "primaryKey": "str",  # Optional. Primary symmetric key.
                            "secondaryKey": "str"  # Optional. Secondary symmetric key.
                        },
                        "tpm": {
                            "endorsementKey": "str",  # Required.
                            "storageRootKey": "str"  # Optional. TPM attestation method.
                        },
                        "x509": {
                            "caReferences": {
                                "primary": "str",  # Optional. Primary and secondary
                                  CA references.
                                "secondary": "str"  # Optional. Primary and secondary
                                  CA references.
                            },
                            "clientCertificates": {
                                "primary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                },
                                "secondary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                }
                            },
                            "signingCertificates": {
                                "primary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                },
                                "secondary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                }
                            }
                        }
                    },
                    "enrollmentGroupId": "str",  # Enrollment Group ID. Required.
                    "allocationPolicy": "str",  # Optional. The allocation policy of this
                      resource. This policy overrides the tenant level allocation policy for this
                      individual enrollment or enrollment group. Possible values include 'hashed':
                      Linked IoT hubs are equally likely to have devices provisioned to them,
                      'geoLatency':  Devices are provisioned to an IoT hub with the lowest latency to
                      the device.If multiple linked IoT hubs would provide the same lowest latency, the
                      provisioning service hashes devices across those hubs, 'static' : Specification
                      of the desired IoT hub in the enrollment list takes priority over the
                      service-level allocation policy, 'custom': Devices are provisioned to an IoT hub
                      based on your own custom logic. The provisioning service passes information about
                      the device to the logic, and the logic returns the desired IoT hub as well as the
                      desired initial configuration. We recommend using Azure Functions to host your
                      logic. Known values are: "hashed", "geoLatency", "static", and "custom".
                    "capabilities": {
                        "iotEdge": False  # Default value is False. If set to true, this
                          device is an IoTEdge device. Required.
                    },
                    "createdDateTimeUtc": "2020-02-20 00:00:00",  # Optional. The DateTime this
                      resource was created.
                    "customAllocationDefinition": {
                        "apiVersion": "str",  # The API version of the provisioning service
                          types (such as Enrollment) sent in the custom allocation request.
                          Minimum supported version: "2018-09-01-preview". Required.
                        "webhookUrl": "str"  # The webhook URL used for allocation requests.
                          Required.
                    },
                    "etag": "str",  # Optional. The entity tag associated with the resource.
                    "initialTwin": {
                        "properties": {
                            "desired": {
                                "count": 0,  # Optional. Number of properties in the
                                  TwinCollection.
                                "metadata": {
                                    "lastUpdated": "2020-02-20 00:00:00",  #
                                      Optional. Last time the TwinCollection was updated.
                                    "lastUpdatedVersion": 0  # Optional. This is
                                      null for reported properties metadata and is not null for desired
                                      properties metadata.
                                },
                                "version": 0  # Optional. Version of the
                                  TwinCollection.
                            }
                        },
                        "tags": {
                            "count": 0,  # Optional. Number of properties in the
                              TwinCollection.
                            "metadata": {
                                "lastUpdated": "2020-02-20 00:00:00",  # Optional.
                                  Last time the TwinCollection was updated.
                                "lastUpdatedVersion": 0  # Optional. This is null for
                                  reported properties metadata and is not null for desired properties
                                  metadata.
                            },
                            "version": 0  # Optional. Version of the TwinCollection.
                        }
                    },
                    "iotHubHostName": "str",  # Optional. The Iot Hub host name.
                    "iotHubs": [
                        "str"  # Optional. The list of IoT Hub hostnames the device(s) in
                          this resource can be allocated to. Must be a subset of tenant level list of
                          IoT hubs.
                    ],
                    "lastUpdatedDateTimeUtc": "2020-02-20 00:00:00",  # Optional. The DateTime
                      this resource was last updated.
                    "provisioningStatus": "enabled",  # Optional. Default value is "enabled". The
                      provisioning status. Known values are: "enabled" and "disabled".
                    "reprovisionPolicy": {
                        "migrateDeviceData": True,  # Default value is True. When set to true
                          (default), the Device Provisioning Service will migrate the device's data
                          (twin, device capabilities, and device ID) from one IoT hub to another during
                          an IoT hub assignment update. If set to false, the Device Provisioning
                          Service will reset the device's data to the initial desired configuration
                          stored in the corresponding enrollment list.
                        "updateHubAssignment": True  # Default value is True. When set to
                          true (default), the Device Provisioning Service will evaluate the device's
                          IoT Hub assignment and update it if necessary for any provisioning requests
                          beyond the first from a given device. If set to false, the device will stay
                          assigned to its current IoT hub.
                    }
                }
        """

    @distributed_trace
    def create_or_update(
        self, id: str, enrollment_group: Union[JSON, IO], *, if_match: Optional[str] = None, **kwargs: Any
    ) -> JSON:
        """Create or update a device enrollment group.

        Create or update a device enrollment group.

        :param id: Enrollment group ID. Required.
        :type id: str
        :param enrollment_group: The device enrollment group. Is either a JSON type or a IO type.
         Required.
        :type enrollment_group: JSON or IO
        :keyword if_match: The ETag of the enrollment record. Default value is None.
        :paramtype if_match: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                enrollment_group = {
                    "attestation": {
                        "type": "str",  # Attestation Type. Required. Known values are:
                          "none", "tpm", "x509", and "symmetricKey".
                        "symmetricKey": {
                            "primaryKey": "str",  # Optional. Primary symmetric key.
                            "secondaryKey": "str"  # Optional. Secondary symmetric key.
                        },
                        "tpm": {
                            "endorsementKey": "str",  # Required.
                            "storageRootKey": "str"  # Optional. TPM attestation method.
                        },
                        "x509": {
                            "caReferences": {
                                "primary": "str",  # Optional. Primary and secondary
                                  CA references.
                                "secondary": "str"  # Optional. Primary and secondary
                                  CA references.
                            },
                            "clientCertificates": {
                                "primary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                },
                                "secondary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                }
                            },
                            "signingCertificates": {
                                "primary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                },
                                "secondary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                }
                            }
                        }
                    },
                    "enrollmentGroupId": "str",  # Enrollment Group ID. Required.
                    "allocationPolicy": "str",  # Optional. The allocation policy of this
                      resource. This policy overrides the tenant level allocation policy for this
                      individual enrollment or enrollment group. Possible values include 'hashed':
                      Linked IoT hubs are equally likely to have devices provisioned to them,
                      'geoLatency':  Devices are provisioned to an IoT hub with the lowest latency to
                      the device.If multiple linked IoT hubs would provide the same lowest latency, the
                      provisioning service hashes devices across those hubs, 'static' : Specification
                      of the desired IoT hub in the enrollment list takes priority over the
                      service-level allocation policy, 'custom': Devices are provisioned to an IoT hub
                      based on your own custom logic. The provisioning service passes information about
                      the device to the logic, and the logic returns the desired IoT hub as well as the
                      desired initial configuration. We recommend using Azure Functions to host your
                      logic. Known values are: "hashed", "geoLatency", "static", and "custom".
                    "capabilities": {
                        "iotEdge": False  # Default value is False. If set to true, this
                          device is an IoTEdge device. Required.
                    },
                    "createdDateTimeUtc": "2020-02-20 00:00:00",  # Optional. The DateTime this
                      resource was created.
                    "customAllocationDefinition": {
                        "apiVersion": "str",  # The API version of the provisioning service
                          types (such as Enrollment) sent in the custom allocation request.
                          Minimum supported version: "2018-09-01-preview". Required.
                        "webhookUrl": "str"  # The webhook URL used for allocation requests.
                          Required.
                    },
                    "etag": "str",  # Optional. The entity tag associated with the resource.
                    "initialTwin": {
                        "properties": {
                            "desired": {
                                "count": 0,  # Optional. Number of properties in the
                                  TwinCollection.
                                "metadata": {
                                    "lastUpdated": "2020-02-20 00:00:00",  #
                                      Optional. Last time the TwinCollection was updated.
                                    "lastUpdatedVersion": 0  # Optional. This is
                                      null for reported properties metadata and is not null for desired
                                      properties metadata.
                                },
                                "version": 0  # Optional. Version of the
                                  TwinCollection.
                            }
                        },
                        "tags": {
                            "count": 0,  # Optional. Number of properties in the
                              TwinCollection.
                            "metadata": {
                                "lastUpdated": "2020-02-20 00:00:00",  # Optional.
                                  Last time the TwinCollection was updated.
                                "lastUpdatedVersion": 0  # Optional. This is null for
                                  reported properties metadata and is not null for desired properties
                                  metadata.
                            },
                            "version": 0  # Optional. Version of the TwinCollection.
                        }
                    },
                    "iotHubHostName": "str",  # Optional. The Iot Hub host name.
                    "iotHubs": [
                        "str"  # Optional. The list of IoT Hub hostnames the device(s) in
                          this resource can be allocated to. Must be a subset of tenant level list of
                          IoT hubs.
                    ],
                    "lastUpdatedDateTimeUtc": "2020-02-20 00:00:00",  # Optional. The DateTime
                      this resource was last updated.
                    "provisioningStatus": "enabled",  # Optional. Default value is "enabled". The
                      provisioning status. Known values are: "enabled" and "disabled".
                    "reprovisionPolicy": {
                        "migrateDeviceData": True,  # Default value is True. When set to true
                          (default), the Device Provisioning Service will migrate the device's data
                          (twin, device capabilities, and device ID) from one IoT hub to another during
                          an IoT hub assignment update. If set to false, the Device Provisioning
                          Service will reset the device's data to the initial desired configuration
                          stored in the corresponding enrollment list.
                        "updateHubAssignment": True  # Default value is True. When set to
                          true (default), the Device Provisioning Service will evaluate the device's
                          IoT Hub assignment and update it if necessary for any provisioning requests
                          beyond the first from a given device. If set to false, the device will stay
                          assigned to its current IoT hub.
                    }
                }

                # response body for status code(s): 200
                response == {
                    "attestation": {
                        "type": "str",  # Attestation Type. Required. Known values are:
                          "none", "tpm", "x509", and "symmetricKey".
                        "symmetricKey": {
                            "primaryKey": "str",  # Optional. Primary symmetric key.
                            "secondaryKey": "str"  # Optional. Secondary symmetric key.
                        },
                        "tpm": {
                            "endorsementKey": "str",  # Required.
                            "storageRootKey": "str"  # Optional. TPM attestation method.
                        },
                        "x509": {
                            "caReferences": {
                                "primary": "str",  # Optional. Primary and secondary
                                  CA references.
                                "secondary": "str"  # Optional. Primary and secondary
                                  CA references.
                            },
                            "clientCertificates": {
                                "primary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                },
                                "secondary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                }
                            },
                            "signingCertificates": {
                                "primary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                },
                                "secondary": {
                                    "certificate": "str",  # Optional.
                                      Certificate and Certificate info.
                                    "info": {
                                        "issuerName": "str",  # Required.
                                        "notAfterUtc": "2020-02-20 00:00:00",
                                          # Required.
                                        "notBeforeUtc": "2020-02-20
                                          00:00:00",  # Required.
                                        "serialNumber": "str",  # Required.
                                        "sha1Thumbprint": "str",  # Required.
                                        "sha256Thumbprint": "str",  #
                                          Required.
                                        "subjectName": "str",  # Required.
                                        "version": 0  # Required.
                                    }
                                }
                            }
                        }
                    },
                    "enrollmentGroupId": "str",  # Enrollment Group ID. Required.
                    "allocationPolicy": "str",  # Optional. The allocation policy of this
                      resource. This policy overrides the tenant level allocation policy for this
                      individual enrollment or enrollment group. Possible values include 'hashed':
                      Linked IoT hubs are equally likely to have devices provisioned to them,
                      'geoLatency':  Devices are provisioned to an IoT hub with the lowest latency to
                      the device.If multiple linked IoT hubs would provide the same lowest latency, the
                      provisioning service hashes devices across those hubs, 'static' : Specification
                      of the desired IoT hub in the enrollment list takes priority over the
                      service-level allocation policy, 'custom': Devices are provisioned to an IoT hub
                      based on your own custom logic. The provisioning service passes information about
                      the device to the logic, and the logic returns the desired IoT hub as well as the
                      desired initial configuration. We recommend using Azure Functions to host your
                      logic. Known values are: "hashed", "geoLatency", "static", and "custom".
                    "capabilities": {
                        "iotEdge": False  # Default value is False. If set to true, this
                          device is an IoTEdge device. Required.
                    },
                    "createdDateTimeUtc": "2020-02-20 00:00:00",  # Optional. The DateTime this
                      resource was created.
                    "customAllocationDefinition": {
                        "apiVersion": "str",  # The API version of the provisioning service
                          types (such as Enrollment) sent in the custom allocation request.
                          Minimum supported version: "2018-09-01-preview". Required.
                        "webhookUrl": "str"  # The webhook URL used for allocation requests.
                          Required.
                    },
                    "etag": "str",  # Optional. The entity tag associated with the resource.
                    "initialTwin": {
                        "properties": {
                            "desired": {
                                "count": 0,  # Optional. Number of properties in the
                                  TwinCollection.
                                "metadata": {
                                    "lastUpdated": "2020-02-20 00:00:00",  #
                                      Optional. Last time the TwinCollection was updated.
                                    "lastUpdatedVersion": 0  # Optional. This is
                                      null for reported properties metadata and is not null for desired
                                      properties metadata.
                                },
                                "version": 0  # Optional. Version of the
                                  TwinCollection.
                            }
                        },
                        "tags": {
                            "count": 0,  # Optional. Number of properties in the
                              TwinCollection.
                            "metadata": {
                                "lastUpdated": "2020-02-20 00:00:00",  # Optional.
                                  Last time the TwinCollection was updated.
                                "lastUpdatedVersion": 0  # Optional. This is null for
                                  reported properties metadata and is not null for desired properties
                                  metadata.
                            },
                            "version": 0  # Optional. Version of the TwinCollection.
                        }
                    },
                    "iotHubHostName": "str",  # Optional. The Iot Hub host name.
                    "iotHubs": [
                        "str"  # Optional. The list of IoT Hub hostnames the device(s) in
                          this resource can be allocated to. Must be a subset of tenant level list of
                          IoT hubs.
                    ],
                    "lastUpdatedDateTimeUtc": "2020-02-20 00:00:00",  # Optional. The DateTime
                      this resource was last updated.
                    "provisioningStatus": "enabled",  # Optional. Default value is "enabled". The
                      provisioning status. Known values are: "enabled" and "disabled".
                    "reprovisionPolicy": {
                        "migrateDeviceData": True,  # Default value is True. When set to true
                          (default), the Device Provisioning Service will migrate the device's data
                          (twin, device capabilities, and device ID) from one IoT hub to another during
                          an IoT hub assignment update. If set to false, the Device Provisioning
                          Service will reset the device's data to the initial desired configuration
                          stored in the corresponding enrollment list.
                        "updateHubAssignment": True  # Default value is True. When set to
                          true (default), the Device Provisioning Service will evaluate the device's
                          IoT Hub assignment and update it if necessary for any provisioning requests
                          beyond the first from a given device. If set to false, the device will stay
                          assigned to its current IoT hub.
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(enrollment_group, (IOBase, bytes)):
            _content = enrollment_group
        else:
            _json = enrollment_group

        request = build_enrollment_group_create_or_update_request(
            id=id,
            if_match=if_match,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace
    def delete(  # pylint: disable=inconsistent-return-statements
        self, id: str, *, if_match: Optional[str] = None, **kwargs: Any
    ) -> None:
        """Delete a device enrollment group.

        Delete a device enrollment group.

        :param id: Enrollment group ID. Required.
        :type id: str
        :keyword if_match: The ETag of the enrollment group record. Default value is None.
        :paramtype if_match: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_enrollment_group_delete_request(
            id=id,
            if_match=if_match,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    @overload
    def _query(
        self,
        query_specification: JSON,
        *,
        x_ms_max_item_count: Optional[int] = None,
        x_ms_continuation: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> List[JSON]:
        ...

    @overload
    def _query(
        self,
        query_specification: IO,
        *,
        x_ms_max_item_count: Optional[int] = None,
        x_ms_continuation: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> List[JSON]:
        ...

    @distributed_trace
    def _query(
        self,
        query_specification: Union[JSON, IO],
        *,
        x_ms_max_item_count: Optional[int] = None,
        x_ms_continuation: Optional[str] = None,
        **kwargs: Any
    ) -> List[JSON]:
        """Query the device enrollment groups.

        Query the device enrollment groups.

        :param query_specification: The query specification. Is either a JSON type or a IO type.
         Required.
        :type query_specification: JSON or IO
        :keyword x_ms_max_item_count: Page size. Default value is None.
        :paramtype x_ms_max_item_count: int
        :keyword x_ms_continuation: Continuation token. Default value is None.
        :paramtype x_ms_continuation: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                query_specification = {
                    "query": "str"  # Required.
                }

                # response body for status code(s): 200
                response == [
                    {
                        "attestation": {
                            "type": "str",  # Attestation Type. Required. Known values
                              are: "none", "tpm", "x509", and "symmetricKey".
                            "symmetricKey": {
                                "primaryKey": "str",  # Optional. Primary symmetric
                                  key.
                                "secondaryKey": "str"  # Optional. Secondary
                                  symmetric key.
                            },
                            "tpm": {
                                "endorsementKey": "str",  # Required.
                                "storageRootKey": "str"  # Optional. TPM attestation
                                  method.
                            },
                            "x509": {
                                "caReferences": {
                                    "primary": "str",  # Optional. Primary and
                                      secondary CA references.
                                    "secondary": "str"  # Optional. Primary and
                                      secondary CA references.
                                },
                                "clientCertificates": {
                                    "primary": {
                                        "certificate": "str",  # Optional.
                                          Certificate and Certificate info.
                                        "info": {
                                            "issuerName": "str",  #
                                              Required.
                                            "notAfterUtc": "2020-02-20
                                              00:00:00",  # Required.
                                            "notBeforeUtc": "2020-02-20
                                              00:00:00",  # Required.
                                            "serialNumber": "str",  #
                                              Required.
                                            "sha1Thumbprint": "str",  #
                                              Required.
                                            "sha256Thumbprint": "str",  #
                                              Required.
                                            "subjectName": "str",  #
                                              Required.
                                            "version": 0  # Required.
                                        }
                                    },
                                    "secondary": {
                                        "certificate": "str",  # Optional.
                                          Certificate and Certificate info.
                                        "info": {
                                            "issuerName": "str",  #
                                              Required.
                                            "notAfterUtc": "2020-02-20
                                              00:00:00",  # Required.
                                            "notBeforeUtc": "2020-02-20
                                              00:00:00",  # Required.
                                            "serialNumber": "str",  #
                                              Required.
                                            "sha1Thumbprint": "str",  #
                                              Required.
                                            "sha256Thumbprint": "str",  #
                                              Required.
                                            "subjectName": "str",  #
                                              Required.
                                            "version": 0  # Required.
                                        }
                                    }
                                },
                                "signingCertificates": {
                                    "primary": {
                                        "certificate": "str",  # Optional.
                                          Certificate and Certificate info.
                                        "info": {
                                            "issuerName": "str",  #
                                              Required.
                                            "notAfterUtc": "2020-02-20
                                              00:00:00",  # Required.
                                            "notBeforeUtc": "2020-02-20
                                              00:00:00",  # Required.
                                            "serialNumber": "str",  #
                                              Required.
                                            "sha1Thumbprint": "str",  #
                                              Required.
                                            "sha256Thumbprint": "str",  #
                                              Required.
                                            "subjectName": "str",  #
                                              Required.
                                            "version": 0  # Required.
                                        }
                                    },
                                    "secondary": {
                                        "certificate": "str",  # Optional.
                                          Certificate and Certificate info.
                                        "info": {
                                            "issuerName": "str",  #
                                              Required.
                                            "notAfterUtc": "2020-02-20
                                              00:00:00",  # Required.
                                            "notBeforeUtc": "2020-02-20
                                              00:00:00",  # Required.
                                            "serialNumber": "str",  #
                                              Required.
                                            "sha1Thumbprint": "str",  #
                                              Required.
                                            "sha256Thumbprint": "str",  #
                                              Required.
                                            "subjectName": "str",  #
                                              Required.
                                            "version": 0  # Required.
                                        }
                                    }
                                }
                            }
                        },
                        "enrollmentGroupId": "str",  # Enrollment Group ID. Required.
                        "allocationPolicy": "str",  # Optional. The allocation policy of this
                          resource. This policy overrides the tenant level allocation policy for this
                          individual enrollment or enrollment group. Possible values include 'hashed':
                          Linked IoT hubs are equally likely to have devices provisioned to them,
                          'geoLatency':  Devices are provisioned to an IoT hub with the lowest latency
                          to the device.If multiple linked IoT hubs would provide the same lowest
                          latency, the provisioning service hashes devices across those hubs, 'static'
                          : Specification of the desired IoT hub in the enrollment list takes priority
                          over the service-level allocation policy, 'custom': Devices are provisioned
                          to an IoT hub based on your own custom logic. The provisioning service passes
                          information about the device to the logic, and the logic returns the desired
                          IoT hub as well as the desired initial configuration. We recommend using
                          Azure Functions to host your logic. Known values are: "hashed", "geoLatency",
                          "static", and "custom".
                        "capabilities": {
                            "iotEdge": False  # Default value is False. If set to true,
                              this device is an IoTEdge device. Required.
                        },
                        "createdDateTimeUtc": "2020-02-20 00:00:00",  # Optional. The
                          DateTime this resource was created.
                        "customAllocationDefinition": {
                            "apiVersion": "str",  # The API version of the provisioning
                              service types (such as Enrollment) sent in the custom
                              allocation request. Minimum supported version: "2018-09-01-preview".
                              Required.
                            "webhookUrl": "str"  # The webhook URL used for allocation
                              requests. Required.
                        },
                        "etag": "str",  # Optional. The entity tag associated with the
                          resource.
                        "initialTwin": {
                            "properties": {
                                "desired": {
                                    "count": 0,  # Optional. Number of properties
                                      in the TwinCollection.
                                    "metadata": {
                                        "lastUpdated": "2020-02-20 00:00:00",
                                          # Optional. Last time the TwinCollection was updated.
                                        "lastUpdatedVersion": 0  # Optional.
                                          This is null for reported properties metadata and is not null
                                          for desired properties metadata.
                                    },
                                    "version": 0  # Optional. Version of the
                                      TwinCollection.
                                }
                            },
                            "tags": {
                                "count": 0,  # Optional. Number of properties in the
                                  TwinCollection.
                                "metadata": {
                                    "lastUpdated": "2020-02-20 00:00:00",  #
                                      Optional. Last time the TwinCollection was updated.
                                    "lastUpdatedVersion": 0  # Optional. This is
                                      null for reported properties metadata and is not null for desired
                                      properties metadata.
                                },
                                "version": 0  # Optional. Version of the
                                  TwinCollection.
                            }
                        },
                        "iotHubHostName": "str",  # Optional. The Iot Hub host name.
                        "iotHubs": [
                            "str"  # Optional. The list of IoT Hub hostnames the
                              device(s) in this resource can be allocated to. Must be a subset of
                              tenant level list of IoT hubs.
                        ],
                        "lastUpdatedDateTimeUtc": "2020-02-20 00:00:00",  # Optional. The
                          DateTime this resource was last updated.
                        "provisioningStatus": "enabled",  # Optional. Default value is
                          "enabled". The provisioning status. Known values are: "enabled" and
                          "disabled".
                        "reprovisionPolicy": {
                            "migrateDeviceData": True,  # Default value is True. When set
                              to true (default), the Device Provisioning Service will migrate the
                              device's data (twin, device capabilities, and device ID) from one IoT hub
                              to another during an IoT hub assignment update. If set to false, the
                              Device Provisioning Service will reset the device's data to the initial
                              desired configuration stored in the corresponding enrollment list.
                            "updateHubAssignment": True  # Default value is True. When
                              set to true (default), the Device Provisioning Service will evaluate the
                              device's IoT Hub assignment and update it if necessary for any
                              provisioning requests beyond the first from a given device. If set to
                              false, the device will stay assigned to its current IoT hub.
                        }
                    }
                ]
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(query_specification, (IOBase, bytes)):
            _content = query_specification
        else:
            _json = query_specification

        request = build_enrollment_group_query_request(
            x_ms_max_item_count=x_ms_max_item_count,
            x_ms_continuation=x_ms_continuation,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["x-ms-continuation"] = self._deserialize("str", response.headers.get("x-ms-continuation"))
        response_headers["x-ms-max-item-count"] = self._deserialize("int", response.headers.get("x-ms-max-item-count"))
        response_headers["x-ms-item-type"] = self._deserialize("str", response.headers.get("x-ms-item-type"))

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), response_headers)

        return cast(List[JSON], deserialized)

    @distributed_trace
    def get_attestation_mechanism(self, id: str, **kwargs: Any) -> JSON:
        """Get the attestation mechanism in the device enrollment group record.

        Get the attestation mechanism in the device enrollment group record.

        :param id: Enrollment group ID. Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "type": "str",  # Attestation Type. Required. Known values are: "none",
                      "tpm", "x509", and "symmetricKey".
                    "symmetricKey": {
                        "primaryKey": "str",  # Optional. Primary symmetric key.
                        "secondaryKey": "str"  # Optional. Secondary symmetric key.
                    },
                    "tpm": {
                        "endorsementKey": "str",  # Required.
                        "storageRootKey": "str"  # Optional. TPM attestation method.
                    },
                    "x509": {
                        "caReferences": {
                            "primary": "str",  # Optional. Primary and secondary CA
                              references.
                            "secondary": "str"  # Optional. Primary and secondary CA
                              references.
                        },
                        "clientCertificates": {
                            "primary": {
                                "certificate": "str",  # Optional. Certificate and
                                  Certificate info.
                                "info": {
                                    "issuerName": "str",  # Required.
                                    "notAfterUtc": "2020-02-20 00:00:00",  #
                                      Required.
                                    "notBeforeUtc": "2020-02-20 00:00:00",  #
                                      Required.
                                    "serialNumber": "str",  # Required.
                                    "sha1Thumbprint": "str",  # Required.
                                    "sha256Thumbprint": "str",  # Required.
                                    "subjectName": "str",  # Required.
                                    "version": 0  # Required.
                                }
                            },
                            "secondary": {
                                "certificate": "str",  # Optional. Certificate and
                                  Certificate info.
                                "info": {
                                    "issuerName": "str",  # Required.
                                    "notAfterUtc": "2020-02-20 00:00:00",  #
                                      Required.
                                    "notBeforeUtc": "2020-02-20 00:00:00",  #
                                      Required.
                                    "serialNumber": "str",  # Required.
                                    "sha1Thumbprint": "str",  # Required.
                                    "sha256Thumbprint": "str",  # Required.
                                    "subjectName": "str",  # Required.
                                    "version": 0  # Required.
                                }
                            }
                        },
                        "signingCertificates": {
                            "primary": {
                                "certificate": "str",  # Optional. Certificate and
                                  Certificate info.
                                "info": {
                                    "issuerName": "str",  # Required.
                                    "notAfterUtc": "2020-02-20 00:00:00",  #
                                      Required.
                                    "notBeforeUtc": "2020-02-20 00:00:00",  #
                                      Required.
                                    "serialNumber": "str",  # Required.
                                    "sha1Thumbprint": "str",  # Required.
                                    "sha256Thumbprint": "str",  # Required.
                                    "subjectName": "str",  # Required.
                                    "version": 0  # Required.
                                }
                            },
                            "secondary": {
                                "certificate": "str",  # Optional. Certificate and
                                  Certificate info.
                                "info": {
                                    "issuerName": "str",  # Required.
                                    "notAfterUtc": "2020-02-20 00:00:00",  #
                                      Required.
                                    "notBeforeUtc": "2020-02-20 00:00:00",  #
                                      Required.
                                    "serialNumber": "str",  # Required.
                                    "sha1Thumbprint": "str",  # Required.
                                    "sha256Thumbprint": "str",  # Required.
                                    "subjectName": "str",  # Required.
                                    "version": 0  # Required.
                                }
                            }
                        }
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_enrollment_group_get_attestation_mechanism_request(
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    def run_bulk_operation(
        self, bulk_operation: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Bulk device enrollment group operation with maximum of 10 groups.

        Bulk device enrollment group operation with maximum of 10 groups.

        :param bulk_operation: Bulk operation. Required.
        :type bulk_operation: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                bulk_operation = {
                    "enrollmentGroups": [
                        {
                            "attestation": {
                                "type": "str",  # Attestation Type. Required. Known
                                  values are: "none", "tpm", "x509", and "symmetricKey".
                                "symmetricKey": {
                                    "primaryKey": "str",  # Optional. Primary
                                      symmetric key.
                                    "secondaryKey": "str"  # Optional. Secondary
                                      symmetric key.
                                },
                                "tpm": {
                                    "endorsementKey": "str",  # Required.
                                    "storageRootKey": "str"  # Optional. TPM
                                      attestation method.
                                },
                                "x509": {
                                    "caReferences": {
                                        "primary": "str",  # Optional.
                                          Primary and secondary CA references.
                                        "secondary": "str"  # Optional.
                                          Primary and secondary CA references.
                                    },
                                    "clientCertificates": {
                                        "primary": {
                                            "certificate": "str",  #
                                              Optional. Certificate and Certificate info.
                                            "info": {
                                                "issuerName": "str",
                                                  # Required.
                                                "notAfterUtc":
                                                  "2020-02-20 00:00:00",  # Required.
                                                "notBeforeUtc":
                                                  "2020-02-20 00:00:00",  # Required.
                                                "serialNumber":
                                                  "str",  # Required.
                                                "sha1Thumbprint":
                                                  "str",  # Required.
                                                "sha256Thumbprint":
                                                  "str",  # Required.
                                                "subjectName": "str",
                                                  # Required.
                                                "version": 0  #
                                                  Required.
                                            }
                                        },
                                        "secondary": {
                                            "certificate": "str",  #
                                              Optional. Certificate and Certificate info.
                                            "info": {
                                                "issuerName": "str",
                                                  # Required.
                                                "notAfterUtc":
                                                  "2020-02-20 00:00:00",  # Required.
                                                "notBeforeUtc":
                                                  "2020-02-20 00:00:00",  # Required.
                                                "serialNumber":
                                                  "str",  # Required.
                                                "sha1Thumbprint":
                                                  "str",  # Required.
                                                "sha256Thumbprint":
                                                  "str",  # Required.
                                                "subjectName": "str",
                                                  # Required.
                                                "version": 0  #
                                                  Required.
                                            }
                                        }
                                    },
                                    "signingCertificates": {
                                        "primary": {
                                            "certificate": "str",  #
                                              Optional. Certificate and Certificate info.
                                            "info": {
                                                "issuerName": "str",
                                                  # Required.
                                                "notAfterUtc":
                                                  "2020-02-20 00:00:00",  # Required.
                                                "notBeforeUtc":
                                                  "2020-02-20 00:00:00",  # Required.
                                                "serialNumber":
                                                  "str",  # Required.
                                                "sha1Thumbprint":
                                                  "str",  # Required.
                                                "sha256Thumbprint":
                                                  "str",  # Required.
                                                "subjectName": "str",
                                                  # Required.
                                                "version": 0  #
                                                  Required.
                                            }
                                        },
                                        "secondary": {
                                            "certificate": "str",  #
                                              Optional. Certificate and Certificate info.
                                            "info": {
                                                "issuerName": "str",
                                                  # Required.
                                                "notAfterUtc":
                                                  "2020-02-20 00:00:00",  # Required.
                                                "notBeforeUtc":
                                                  "2020-02-20 00:00:00",  # Required.
                                                "serialNumber":
                                                  "str",  # Required.
                                                "sha1Thumbprint":
                                                  "str",  # Required.
                                                "sha256Thumbprint":
                                                  "str",  # Required.
                                                "subjectName": "str",
                                                  # Required.
                                                "version": 0  #
                                                  Required.
                                            }
                                        }
                                    }
                                }
                            },
                            "enrollmentGroupId": "str",  # Enrollment Group ID. Required.
                            "allocationPolicy": "str",  # Optional. The allocation policy
                              of this resource. This policy overrides the tenant level allocation
                              policy for this individual enrollment or enrollment group. Possible
                              values include 'hashed': Linked IoT hubs are equally likely to have
                              devices provisioned to them, 'geoLatency':  Devices are provisioned to an
                              IoT hub with the lowest latency to the device.If multiple linked IoT hubs
                              would provide the same lowest latency, the provisioning service hashes
                              devices across those hubs, 'static' : Specification of the desired IoT
                              hub in the enrollment list takes priority over the service-level
                              allocation policy, 'custom': Devices are provisioned to an IoT hub based
                              on your own custom logic. The provisioning service passes information
                              about the device to the logic, and the logic returns the desired IoT hub
                              as well as the desired initial configuration. We recommend using Azure
                              Functions to host your logic. Known values are: "hashed", "geoLatency",
                              "static", and "custom".
                            "capabilities": {
                                "iotEdge": False  # Default value is False. If set to
                                  true, this device is an IoTEdge device. Required.
                            },
                            "createdDateTimeUtc": "2020-02-20 00:00:00",  # Optional. The
                              DateTime this resource was created.
                            "customAllocationDefinition": {
                                "apiVersion": "str",  # The API version of the
                                  provisioning service types (such as Enrollment) sent in the
                                  custom allocation request. Minimum supported version:
                                  "2018-09-01-preview". Required.
                                "webhookUrl": "str"  # The webhook URL used for
                                  allocation requests. Required.
                            },
                            "etag": "str",  # Optional. The entity tag associated with
                              the resource.
                            "initialTwin": {
                                "properties": {
                                    "desired": {
                                        "count": 0,  # Optional. Number of
                                          properties in the TwinCollection.
                                        "metadata": {
                                            "lastUpdated": "2020-02-20
                                              00:00:00",  # Optional. Last time the TwinCollection was
                                              updated.
                                            "lastUpdatedVersion": 0  #
                                              Optional. This is null for reported properties metadata
                                              and is not null for desired properties metadata.
                                        },
                                        "version": 0  # Optional. Version of
                                          the TwinCollection.
                                    }
                                },
                                "tags": {
                                    "count": 0,  # Optional. Number of properties
                                      in the TwinCollection.
                                    "metadata": {
                                        "lastUpdated": "2020-02-20 00:00:00",
                                          # Optional. Last time the TwinCollection was updated.
                                        "lastUpdatedVersion": 0  # Optional.
                                          This is null for reported properties metadata and is not null
                                          for desired properties metadata.
                                    },
                                    "version": 0  # Optional. Version of the
                                      TwinCollection.
                                }
                            },
                            "iotHubHostName": "str",  # Optional. The Iot Hub host name.
                            "iotHubs": [
                                "str"  # Optional. The list of IoT Hub hostnames the
                                  device(s) in this resource can be allocated to. Must be a subset of
                                  tenant level list of IoT hubs.
                            ],
                            "lastUpdatedDateTimeUtc": "2020-02-20 00:00:00",  # Optional.
                              The DateTime this resource was last updated.
                            "provisioningStatus": "enabled",  # Optional. Default value
                              is "enabled". The provisioning status. Known values are: "enabled" and
                              "disabled".
                            "reprovisionPolicy": {
                                "migrateDeviceData": True,  # Default value is True.
                                  When set to true (default), the Device Provisioning Service will
                                  migrate the device's data (twin, device capabilities, and device ID)
                                  from one IoT hub to another during an IoT hub assignment update. If
                                  set to false, the Device Provisioning Service will reset the device's
                                  data to the initial desired configuration stored in the corresponding
                                  enrollment list.
                                "updateHubAssignment": True  # Default value is True.
                                  When set to true (default), the Device Provisioning Service will
                                  evaluate the device's IoT Hub assignment and update it if necessary
                                  for any provisioning requests beyond the first from a given device.
                                  If set to false, the device will stay assigned to its current IoT
                                  hub.
                            }
                        }
                    ],
                    "mode": "str"  # Operation mode. Required. Known values are: "create",
                      "update", "updateIfMatchETag", and "delete".
                }

                # response body for status code(s): 200
                response == {
                    "isSuccessful": bool,  # Indicates if the operation was successful in its
                      entirety. Required.
                    "errors": [
                        {
                            "enrollmentGroupId": "str",  # Enrollment group id. Required.
                            "errorCode": 0,  # Error code. Required.
                            "errorStatus": "str"  # Error status. Required.
                        }
                    ]
                }
        """

    @overload
    def run_bulk_operation(self, bulk_operation: IO, *, content_type: str = "application/json", **kwargs: Any) -> JSON:
        """Bulk device enrollment group operation with maximum of 10 groups.

        Bulk device enrollment group operation with maximum of 10 groups.

        :param bulk_operation: Bulk operation. Required.
        :type bulk_operation: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "isSuccessful": bool,  # Indicates if the operation was successful in its
                      entirety. Required.
                    "errors": [
                        {
                            "enrollmentGroupId": "str",  # Enrollment group id. Required.
                            "errorCode": 0,  # Error code. Required.
                            "errorStatus": "str"  # Error status. Required.
                        }
                    ]
                }
        """

    @distributed_trace
    def run_bulk_operation(self, bulk_operation: Union[JSON, IO], **kwargs: Any) -> JSON:
        """Bulk device enrollment group operation with maximum of 10 groups.

        Bulk device enrollment group operation with maximum of 10 groups.

        :param bulk_operation: Bulk operation. Is either a JSON type or a IO type. Required.
        :type bulk_operation: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                bulk_operation = {
                    "enrollmentGroups": [
                        {
                            "attestation": {
                                "type": "str",  # Attestation Type. Required. Known
                                  values are: "none", "tpm", "x509", and "symmetricKey".
                                "symmetricKey": {
                                    "primaryKey": "str",  # Optional. Primary
                                      symmetric key.
                                    "secondaryKey": "str"  # Optional. Secondary
                                      symmetric key.
                                },
                                "tpm": {
                                    "endorsementKey": "str",  # Required.
                                    "storageRootKey": "str"  # Optional. TPM
                                      attestation method.
                                },
                                "x509": {
                                    "caReferences": {
                                        "primary": "str",  # Optional.
                                          Primary and secondary CA references.
                                        "secondary": "str"  # Optional.
                                          Primary and secondary CA references.
                                    },
                                    "clientCertificates": {
                                        "primary": {
                                            "certificate": "str",  #
                                              Optional. Certificate and Certificate info.
                                            "info": {
                                                "issuerName": "str",
                                                  # Required.
                                                "notAfterUtc":
                                                  "2020-02-20 00:00:00",  # Required.
                                                "notBeforeUtc":
                                                  "2020-02-20 00:00:00",  # Required.
                                                "serialNumber":
                                                  "str",  # Required.
                                                "sha1Thumbprint":
                                                  "str",  # Required.
                                                "sha256Thumbprint":
                                                  "str",  # Required.
                                                "subjectName": "str",
                                                  # Required.
                                                "version": 0  #
                                                  Required.
                                            }
                                        },
                                        "secondary": {
                                            "certificate": "str",  #
                                              Optional. Certificate and Certificate info.
                                            "info": {
                                                "issuerName": "str",
                                                  # Required.
                                                "notAfterUtc":
                                                  "2020-02-20 00:00:00",  # Required.
                                                "notBeforeUtc":
                                                  "2020-02-20 00:00:00",  # Required.
                                                "serialNumber":
                                                  "str",  # Required.
                                                "sha1Thumbprint":
                                                  "str",  # Required.
                                                "sha256Thumbprint":
                                                  "str",  # Required.
                                                "subjectName": "str",
                                                  # Required.
                                                "version": 0  #
                                                  Required.
                                            }
                                        }
                                    },
                                    "signingCertificates": {
                                        "primary": {
                                            "certificate": "str",  #
                                              Optional. Certificate and Certificate info.
                                            "info": {
                                                "issuerName": "str",
                                                  # Required.
                                                "notAfterUtc":
                                                  "2020-02-20 00:00:00",  # Required.
                                                "notBeforeUtc":
                                                  "2020-02-20 00:00:00",  # Required.
                                                "serialNumber":
                                                  "str",  # Required.
                                                "sha1Thumbprint":
                                                  "str",  # Required.
                                                "sha256Thumbprint":
                                                  "str",  # Required.
                                                "subjectName": "str",
                                                  # Required.
                                                "version": 0  #
                                                  Required.
                                            }
                                        },
                                        "secondary": {
                                            "certificate": "str",  #
                                              Optional. Certificate and Certificate info.
                                            "info": {
                                                "issuerName": "str",
                                                  # Required.
                                                "notAfterUtc":
                                                  "2020-02-20 00:00:00",  # Required.
                                                "notBeforeUtc":
                                                  "2020-02-20 00:00:00",  # Required.
                                                "serialNumber":
                                                  "str",  # Required.
                                                "sha1Thumbprint":
                                                  "str",  # Required.
                                                "sha256Thumbprint":
                                                  "str",  # Required.
                                                "subjectName": "str",
                                                  # Required.
                                                "version": 0  #
                                                  Required.
                                            }
                                        }
                                    }
                                }
                            },
                            "enrollmentGroupId": "str",  # Enrollment Group ID. Required.
                            "allocationPolicy": "str",  # Optional. The allocation policy
                              of this resource. This policy overrides the tenant level allocation
                              policy for this individual enrollment or enrollment group. Possible
                              values include 'hashed': Linked IoT hubs are equally likely to have
                              devices provisioned to them, 'geoLatency':  Devices are provisioned to an
                              IoT hub with the lowest latency to the device.If multiple linked IoT hubs
                              would provide the same lowest latency, the provisioning service hashes
                              devices across those hubs, 'static' : Specification of the desired IoT
                              hub in the enrollment list takes priority over the service-level
                              allocation policy, 'custom': Devices are provisioned to an IoT hub based
                              on your own custom logic. The provisioning service passes information
                              about the device to the logic, and the logic returns the desired IoT hub
                              as well as the desired initial configuration. We recommend using Azure
                              Functions to host your logic. Known values are: "hashed", "geoLatency",
                              "static", and "custom".
                            "capabilities": {
                                "iotEdge": False  # Default value is False. If set to
                                  true, this device is an IoTEdge device. Required.
                            },
                            "createdDateTimeUtc": "2020-02-20 00:00:00",  # Optional. The
                              DateTime this resource was created.
                            "customAllocationDefinition": {
                                "apiVersion": "str",  # The API version of the
                                  provisioning service types (such as Enrollment) sent in the
                                  custom allocation request. Minimum supported version:
                                  "2018-09-01-preview". Required.
                                "webhookUrl": "str"  # The webhook URL used for
                                  allocation requests. Required.
                            },
                            "etag": "str",  # Optional. The entity tag associated with
                              the resource.
                            "initialTwin": {
                                "properties": {
                                    "desired": {
                                        "count": 0,  # Optional. Number of
                                          properties in the TwinCollection.
                                        "metadata": {
                                            "lastUpdated": "2020-02-20
                                              00:00:00",  # Optional. Last time the TwinCollection was
                                              updated.
                                            "lastUpdatedVersion": 0  #
                                              Optional. This is null for reported properties metadata
                                              and is not null for desired properties metadata.
                                        },
                                        "version": 0  # Optional. Version of
                                          the TwinCollection.
                                    }
                                },
                                "tags": {
                                    "count": 0,  # Optional. Number of properties
                                      in the TwinCollection.
                                    "metadata": {
                                        "lastUpdated": "2020-02-20 00:00:00",
                                          # Optional. Last time the TwinCollection was updated.
                                        "lastUpdatedVersion": 0  # Optional.
                                          This is null for reported properties metadata and is not null
                                          for desired properties metadata.
                                    },
                                    "version": 0  # Optional. Version of the
                                      TwinCollection.
                                }
                            },
                            "iotHubHostName": "str",  # Optional. The Iot Hub host name.
                            "iotHubs": [
                                "str"  # Optional. The list of IoT Hub hostnames the
                                  device(s) in this resource can be allocated to. Must be a subset of
                                  tenant level list of IoT hubs.
                            ],
                            "lastUpdatedDateTimeUtc": "2020-02-20 00:00:00",  # Optional.
                              The DateTime this resource was last updated.
                            "provisioningStatus": "enabled",  # Optional. Default value
                              is "enabled". The provisioning status. Known values are: "enabled" and
                              "disabled".
                            "reprovisionPolicy": {
                                "migrateDeviceData": True,  # Default value is True.
                                  When set to true (default), the Device Provisioning Service will
                                  migrate the device's data (twin, device capabilities, and device ID)
                                  from one IoT hub to another during an IoT hub assignment update. If
                                  set to false, the Device Provisioning Service will reset the device's
                                  data to the initial desired configuration stored in the corresponding
                                  enrollment list.
                                "updateHubAssignment": True  # Default value is True.
                                  When set to true (default), the Device Provisioning Service will
                                  evaluate the device's IoT Hub assignment and update it if necessary
                                  for any provisioning requests beyond the first from a given device.
                                  If set to false, the device will stay assigned to its current IoT
                                  hub.
                            }
                        }
                    ],
                    "mode": "str"  # Operation mode. Required. Known values are: "create",
                      "update", "updateIfMatchETag", and "delete".
                }

                # response body for status code(s): 200
                response == {
                    "isSuccessful": bool,  # Indicates if the operation was successful in its
                      entirety. Required.
                    "errors": [
                        {
                            "enrollmentGroupId": "str",  # Enrollment group id. Required.
                            "errorCode": 0,  # Error code. Required.
                            "errorStatus": "str"  # Error status. Required.
                        }
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(bulk_operation, (IOBase, bytes)):
            _content = bulk_operation
        else:
            _json = bulk_operation

        request = build_enrollment_group_run_bulk_operation_request(
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)


class DeviceRegistrationStateOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.iot.deviceprovisioning.DeviceProvisioningClient`'s
        :attr:`device_registration_state` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def get(self, id: str, **kwargs: Any) -> JSON:
        """Gets the device registration state.

        Gets the device registration state.

        :param id: Registration ID. Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "assignedHub": "str",  # Optional. Assigned Azure IoT Hub.
                    "createdDateTimeUtc": "2020-02-20 00:00:00",  # Optional. Registration create
                      date time (in UTC).
                    "deviceId": "str",  # Optional. Device ID.
                    "errorCode": 0,  # Optional. Error code.
                    "errorMessage": "str",  # Optional. Error message.
                    "etag": "str",  # Optional. The entity tag associated with the resource.
                    "lastUpdatedDateTimeUtc": "2020-02-20 00:00:00",  # Optional. Last updated
                      date time (in UTC).
                    "payload": {},  # Optional. Custom allocation payload returned from the
                      webhook to the device.
                    "registrationId": "str",  # Optional. This id is used to uniquely identify a
                      device registration of an enrollment."nA case-insensitive string (up to 128
                      characters long) of alphanumeric characters plus certain special characters : . _
                      -. No special characters allowed at start or end.
                    "status": "str",  # Optional. Enrollment status. Known values are:
                      "unassigned", "assigning", "assigned", "failed", and "disabled".
                    "substatus": "str"  # Optional. Substatus for 'Assigned' devices. Possible
                      values include - 'initialAssignment': Device has been assigned to an IoT hub for
                      the first time, 'deviceDataMigrated': Device has been assigned to a different IoT
                      hub and its device data was migrated from the previously assigned IoT hub. Device
                      data was removed from the previously assigned IoT hub, 'deviceDataReset':  Device
                      has been assigned to a different IoT hub and its device data was populated from
                      the initial state stored in the enrollment. Device data was removed from the
                      previously assigned IoT hub, 'reprovisionedToInitialAssignment': Device has been
                      re-provisioned to a previously assigned IoT hub. Known values are:
                      "initialAssignment", "deviceDataMigrated", "deviceDataReset", and
                      "reprovisionedToInitialAssignment".
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_device_registration_state_get_request(
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace
    def delete(  # pylint: disable=inconsistent-return-statements
        self, id: str, *, if_match: Optional[str] = None, **kwargs: Any
    ) -> None:
        """Deletes the device registration.

        Deletes the device registration.

        :param id: Registration ID. Required.
        :type id: str
        :keyword if_match: The ETag of the registration status record. Default value is None.
        :paramtype if_match: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_device_registration_state_delete_request(
            id=id,
            if_match=if_match,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace
    def query(
        self,
        id: str,
        *,
        x_ms_max_item_count: Optional[int] = None,
        x_ms_continuation: Optional[str] = None,
        **kwargs: Any
    ) -> List[JSON]:
        """Gets the registration state of devices in this enrollmentGroup.

        Gets the registration state of devices in this enrollmentGroup.

        :param id: Enrollment group ID. Required.
        :type id: str
        :keyword x_ms_max_item_count: pageSize. Default value is None.
        :paramtype x_ms_max_item_count: int
        :keyword x_ms_continuation: continuation token. Default value is None.
        :paramtype x_ms_continuation: str
        :return: list of JSON object
        :rtype: list[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "assignedHub": "str",  # Optional. Assigned Azure IoT Hub.
                        "createdDateTimeUtc": "2020-02-20 00:00:00",  # Optional.
                          Registration create date time (in UTC).
                        "deviceId": "str",  # Optional. Device ID.
                        "errorCode": 0,  # Optional. Error code.
                        "errorMessage": "str",  # Optional. Error message.
                        "etag": "str",  # Optional. The entity tag associated with the
                          resource.
                        "lastUpdatedDateTimeUtc": "2020-02-20 00:00:00",  # Optional. Last
                          updated date time (in UTC).
                        "payload": {},  # Optional. Custom allocation payload returned from
                          the webhook to the device.
                        "registrationId": "str",  # Optional. This id is used to uniquely
                          identify a device registration of an enrollment."nA case-insensitive string
                          (up to 128 characters long) of alphanumeric characters plus certain special
                          characters : . _ -. No special characters allowed at start or end.
                        "status": "str",  # Optional. Enrollment status. Known values are:
                          "unassigned", "assigning", "assigned", "failed", and "disabled".
                        "substatus": "str"  # Optional. Substatus for 'Assigned' devices.
                          Possible values include - 'initialAssignment': Device has been assigned to an
                          IoT hub for the first time, 'deviceDataMigrated': Device has been assigned to
                          a different IoT hub and its device data was migrated from the previously
                          assigned IoT hub. Device data was removed from the previously assigned IoT
                          hub, 'deviceDataReset':  Device has been assigned to a different IoT hub and
                          its device data was populated from the initial state stored in the
                          enrollment. Device data was removed from the previously assigned IoT hub,
                          'reprovisionedToInitialAssignment': Device has been re-provisioned to a
                          previously assigned IoT hub. Known values are: "initialAssignment",
                          "deviceDataMigrated", "deviceDataReset", and
                          "reprovisionedToInitialAssignment".
                    }
                ]
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[JSON]] = kwargs.pop("cls", None)

        request = build_device_registration_state_query_request(
            id=id,
            x_ms_max_item_count=x_ms_max_item_count,
            x_ms_continuation=x_ms_continuation,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["x-ms-continuation"] = self._deserialize("str", response.headers.get("x-ms-continuation"))
        response_headers["x-ms-max-item-count"] = self._deserialize("int", response.headers.get("x-ms-max-item-count"))
        response_headers["x-ms-item-type"] = self._deserialize("str", response.headers.get("x-ms-item-type"))

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(List[JSON], deserialized), response_headers)

        return cast(List[JSON], deserialized)
