/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import net.osmand.Location;
import net.osmand.StateChangedListener;
import net.osmand.data.LatLon;
import net.osmand.data.LocationPoint;
import net.osmand.data.PointDescription;
import net.osmand.plus.GeocodingLookupService;
import net.osmand.plus.OsmandSettings;
import net.osmand.plus.routing.RouteProvider;
import net.osmand.plus.routing.RoutingHelper;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import net.sourceforge.offroad.OsmWindow;

public class TargetPointsHelper {
    private List<TargetPoint> intermediatePoints = new ArrayList<TargetPoint>();
    private TargetPoint pointToNavigate = null;
    private TargetPoint pointToStart = null;
    private OsmandSettings settings;
    private RoutingHelper routingHelper;
    private List<StateChangedListener<Void>> listeners = new ArrayList<StateChangedListener<Void>>();
    private OsmWindow ctx;
    private GeocodingLookupService.AddressLookupRequest startPointRequest;
    private GeocodingLookupService.AddressLookupRequest targetPointRequest;

    public TargetPointsHelper(OsmWindow ctx) {
        this.ctx = ctx;
        this.settings = ctx.getSettings();
        this.routingHelper = ctx.getRoutingHelper();
        this.readFromSettings();
    }

    private void readFromSettings() {
        this.pointToNavigate = TargetPoint.create(this.settings.getPointToNavigate(), this.settings.getPointNavigateDescription());
        this.lookupAddressForPointToNavigate();
        this.pointToStart = TargetPoint.createStartPoint(this.settings.getPointToStart(), this.settings.getStartPointDescription());
        this.lookupAddessForStartPoint();
        this.intermediatePoints.clear();
        List<LatLon> ips = this.settings.getIntermediatePoints();
        List<String> desc = this.settings.getIntermediatePointDescriptions(ips.size());
        for (int i = 0; i < ips.size(); ++i) {
            TargetPoint targetPoint = new TargetPoint(ips.get(i), PointDescription.deserializeFromString(desc.get(i), ips.get(i)), i);
            this.intermediatePoints.add(targetPoint);
            this.lookupAddressForIntermediatePoint(targetPoint);
        }
    }

    private void lookupAddressForIntermediatePoint(final TargetPoint targetPoint) {
        if (targetPoint != null && targetPoint.pointDescription.isSearchingAddress(this.ctx)) {
            this.cancelPointAddressRequests(targetPoint.point);
            GeocodingLookupService.AddressLookupRequest lookupRequest = new GeocodingLookupService.AddressLookupRequest(targetPoint.point, new GeocodingLookupService.OnAddressLookupResult(){

                @Override
                public void geocodingDone(String address) {
                    if (TargetPointsHelper.this.intermediatePoints.contains(targetPoint)) {
                        targetPoint.pointDescription.setName(address);
                        TargetPointsHelper.this.settings.updateIntermediatePoint(targetPoint.point.getLatitude(), targetPoint.point.getLongitude(), targetPoint.pointDescription);
                        TargetPointsHelper.this.updateRouteAndRefresh(false);
                    }
                }
            }, null);
            this.ctx.getGeocodingLookupService().lookupAddress(lookupRequest);
        }
    }

    private void lookupAddessForStartPoint() {
        if (this.pointToStart != null && this.pointToStart.isSearchingAddress(this.ctx) && (this.startPointRequest == null || !this.startPointRequest.getLatLon().equals(this.pointToStart.point))) {
            this.cancelStartPointAddressRequest();
            this.startPointRequest = new GeocodingLookupService.AddressLookupRequest(this.pointToStart.point, new GeocodingLookupService.OnAddressLookupResult(){

                @Override
                public void geocodingDone(String address) {
                    TargetPointsHelper.this.startPointRequest = null;
                    if (TargetPointsHelper.this.pointToStart != null) {
                        TargetPointsHelper.this.pointToStart.pointDescription.setName(address);
                        TargetPointsHelper.this.settings.setPointToStart(((TargetPointsHelper)TargetPointsHelper.this).pointToStart.point.getLatitude(), ((TargetPointsHelper)TargetPointsHelper.this).pointToStart.point.getLongitude(), TargetPointsHelper.this.pointToStart.pointDescription);
                        TargetPointsHelper.this.updateRouteAndRefresh(false);
                    }
                }
            }, null);
            this.ctx.getGeocodingLookupService().lookupAddress(this.startPointRequest);
        }
    }

    private void lookupAddressForPointToNavigate() {
        if (this.pointToNavigate != null && this.pointToNavigate.isSearchingAddress(this.ctx) && (this.targetPointRequest == null || !this.targetPointRequest.getLatLon().equals(this.pointToNavigate.point))) {
            this.cancelTargetPointAddressRequest();
            this.targetPointRequest = new GeocodingLookupService.AddressLookupRequest(this.pointToNavigate.point, new GeocodingLookupService.OnAddressLookupResult(){

                @Override
                public void geocodingDone(String address) {
                    TargetPointsHelper.this.targetPointRequest = null;
                    if (TargetPointsHelper.this.pointToNavigate != null) {
                        TargetPointsHelper.this.pointToNavigate.pointDescription.setName(address);
                        TargetPointsHelper.this.settings.setPointToNavigate(((TargetPointsHelper)TargetPointsHelper.this).pointToNavigate.point.getLatitude(), ((TargetPointsHelper)TargetPointsHelper.this).pointToNavigate.point.getLongitude(), TargetPointsHelper.this.pointToNavigate.pointDescription);
                        TargetPointsHelper.this.updateRouteAndRefresh(false);
                    }
                }
            }, null);
            this.ctx.getGeocodingLookupService().lookupAddress(this.targetPointRequest);
        }
    }

    public TargetPoint getPointToNavigate() {
        return this.pointToNavigate;
    }

    public TargetPoint getPointToStart() {
        return this.pointToStart;
    }

    public PointDescription getStartPointDescription() {
        return this.settings.getStartPointDescription();
    }

    public List<TargetPoint> getIntermediatePoints() {
        return this.intermediatePoints;
    }

    public List<TargetPoint> getIntermediatePointsNavigation() {
        ArrayList<TargetPoint> intermediatePoints = new ArrayList<TargetPoint>();
        if (this.settings.USE_INTERMEDIATE_POINTS_NAVIGATION.get().booleanValue()) {
            for (TargetPoint t : this.intermediatePoints) {
                intermediatePoints.add(t);
            }
        }
        return intermediatePoints;
    }

    public List<LatLon> getIntermediatePointsLatLon() {
        ArrayList<LatLon> intermediatePointsLatLon = new ArrayList<LatLon>();
        for (TargetPoint t : this.intermediatePoints) {
            intermediatePointsLatLon.add(t.point);
        }
        return intermediatePointsLatLon;
    }

    public List<LatLon> getIntermediatePointsLatLonNavigation() {
        ArrayList<LatLon> intermediatePointsLatLon = new ArrayList<LatLon>();
        if (this.settings.USE_INTERMEDIATE_POINTS_NAVIGATION.get().booleanValue()) {
            for (TargetPoint t : this.intermediatePoints) {
                intermediatePointsLatLon.add(t.point);
            }
        }
        return intermediatePointsLatLon;
    }

    public List<TargetPoint> getAllPoints() {
        ArrayList<TargetPoint> res = new ArrayList<TargetPoint>();
        if (this.pointToStart != null) {
            res.add(this.pointToStart);
        }
        res.addAll(this.intermediatePoints);
        if (this.pointToNavigate != null) {
            res.add(this.pointToNavigate);
        }
        return res;
    }

    public List<TargetPoint> getIntermediatePointsWithTarget() {
        ArrayList<TargetPoint> res = new ArrayList<TargetPoint>();
        res.addAll(this.intermediatePoints);
        if (this.pointToNavigate != null) {
            res.add(this.pointToNavigate);
        }
        return res;
    }

    public TargetPoint getFirstIntermediatePoint() {
        if (this.intermediatePoints.size() > 0) {
            return this.intermediatePoints.get(0);
        }
        return null;
    }

    public void restoreTargetPoints(boolean updateRoute) {
        this.settings.restoreTargetPoints();
        this.readFromSettings();
        this.updateRouteAndRefresh(updateRoute);
    }

    public void removeAllWayPoints(boolean updateRoute, boolean clearBackup) {
        this.cancelStartPointAddressRequest();
        this.cancelTargetPointAddressRequest();
        this.cancelAllIntermediatePointsAddressRequests();
        this.settings.clearIntermediatePoints();
        this.settings.clearPointToNavigate();
        this.settings.clearPointToStart();
        if (clearBackup) {
            this.settings.backupTargetPoints();
        }
        this.pointToNavigate = null;
        this.pointToStart = null;
        this.intermediatePoints.clear();
        this.readFromSettings();
        this.updateRouteAndRefresh(updateRoute);
    }

    public void makeWayPointDestination(boolean updateRoute, int index) {
        TargetPoint targetPoint = this.intermediatePoints.remove(index);
        this.cancelTargetPointAddressRequest();
        this.cancelPointAddressRequests(targetPoint.point);
        this.pointToNavigate = targetPoint;
        this.settings.setPointToNavigate(this.pointToNavigate.getLatitude(), this.pointToNavigate.getLongitude(), this.pointToNavigate.pointDescription);
        this.pointToNavigate.intermediate = false;
        this.settings.deleteIntermediatePoint(index);
        this.lookupAddressForPointToNavigate();
        this.updateRouteAndRefresh(updateRoute);
    }

    public void removeWayPoint(boolean updateRoute, int index) {
        if (index < 0) {
            this.cancelTargetPointAddressRequest();
            this.settings.clearPointToNavigate();
            this.pointToNavigate = null;
            int sz = this.intermediatePoints.size();
            if (sz > 0) {
                this.settings.deleteIntermediatePoint(sz - 1);
                this.pointToNavigate = this.intermediatePoints.remove(sz - 1);
                this.pointToNavigate.intermediate = false;
                this.settings.setPointToNavigate(this.pointToNavigate.getLatitude(), this.pointToNavigate.getLongitude(), this.pointToNavigate.pointDescription);
                this.lookupAddressForPointToNavigate();
            }
        } else {
            this.settings.deleteIntermediatePoint(index);
            TargetPoint targetPoint = this.intermediatePoints.remove(index);
            this.cancelPointAddressRequests(targetPoint.point);
            int ind = 0;
            for (TargetPoint tp : this.intermediatePoints) {
                tp.index = ind++;
            }
        }
        this.updateRouteAndRefresh(updateRoute);
    }

    public void updateRouteAndRefresh(boolean updateRoute) {
        if (updateRoute && (this.routingHelper.isRouteBeingCalculated() || this.routingHelper.isRouteCalculated() || this.routingHelper.isFollowingMode() || this.routingHelper.isRoutePlanningMode())) {
            this.updateRoutingHelper();
        }
        this.updateListeners();
    }

    private void updateRoutingHelper() {
        LatLon start = this.settings.getPointToStart();
        Location lastKnownLocation = null;
        List<LatLon> is = this.getIntermediatePointsLatLonNavigation();
        if (this.routingHelper.isFollowingMode() && lastKnownLocation != null || start == null) {
            this.routingHelper.setFinalAndCurrentLocation(this.settings.getPointToNavigate(), is, lastKnownLocation);
        } else {
            Location loc = this.wrap(start);
            this.routingHelper.setFinalAndCurrentLocation(this.settings.getPointToNavigate(), is, loc);
        }
    }

    private Location wrap(LatLon l) {
        if (l == null) {
            return null;
        }
        Location loc = new Location("map");
        loc.setLatitude(l.getLatitude());
        loc.setLongitude(l.getLongitude());
        return loc;
    }

    private Location wrap(TargetPoint l) {
        if (l == null) {
            return null;
        }
        Location loc = new Location("map");
        loc.setLatitude(l.getLatitude());
        loc.setLongitude(l.getLongitude());
        return loc;
    }

    public void addListener(StateChangedListener<Void> l) {
        this.listeners.add(l);
    }

    private void updateListeners() {
        for (StateChangedListener<Void> l : this.listeners) {
            l.stateChanged(null);
        }
    }

    public void clearPointToNavigate(boolean updateRoute) {
        this.cancelTargetPointAddressRequest();
        this.cancelAllIntermediatePointsAddressRequests();
        this.settings.clearPointToNavigate();
        this.settings.clearIntermediatePoints();
        this.intermediatePoints.clear();
        this.readFromSettings();
        this.updateRouteAndRefresh(updateRoute);
    }

    public void clearStartPoint(boolean updateRoute) {
        this.cancelStartPointAddressRequest();
        this.settings.clearPointToStart();
        this.readFromSettings();
        this.updateRouteAndRefresh(updateRoute);
    }

    public void reorderAllTargetPoints(List<TargetPoint> point, boolean updateRoute) {
        this.cancelTargetPointAddressRequest();
        this.cancelAllIntermediatePointsAddressRequests();
        this.settings.clearPointToNavigate();
        if (point.size() > 0) {
            List<TargetPoint> subList = point.subList(0, point.size() - 1);
            ArrayList<String> names = new ArrayList<String>(subList.size());
            ArrayList<LatLon> ls = new ArrayList<LatLon>(subList.size());
            for (int i = 0; i < subList.size(); ++i) {
                names.add(PointDescription.serializeToString(subList.get(i).pointDescription));
                ls.add(subList.get((int)i).point);
            }
            this.settings.saveIntermediatePoints(ls, names);
            TargetPoint p = point.get(point.size() - 1);
            this.settings.setPointToNavigate(p.getLatitude(), p.getLongitude(), p.pointDescription);
        } else {
            this.settings.clearIntermediatePoints();
        }
        this.readFromSettings();
        this.updateRouteAndRefresh(updateRoute);
    }

    public boolean hasTooLongDistanceToNavigate() {
        if (this.settings.ROUTER_SERVICE.get() != RouteProvider.RouteService.OSMAND) {
            return false;
        }
        Location current = this.routingHelper.getLastProjection();
        double dist = 400000.0;
        List<TargetPoint> list = this.getIntermediatePointsWithTarget();
        if (!list.isEmpty()) {
            if (current != null && MapUtils.getDistance(list.get((int)0).point, current.getLatitude(), current.getLongitude()) > dist) {
                return true;
            }
            for (int i = 1; i < list.size(); ++i) {
                if (!(MapUtils.getDistance(list.get((int)(i - 1)).point, list.get((int)i).point) > dist)) continue;
                return true;
            }
        }
        return false;
    }

    public void navigateToPoint(LatLon point, boolean updateRoute, int intermediate) {
        this.navigateToPoint(point, updateRoute, intermediate, null);
    }

    public void navigateToPoint(LatLon point, boolean updateRoute, int intermediate, PointDescription historyName) {
        if (point != null) {
            PointDescription pointDescription = historyName == null ? new PointDescription("location", "") : historyName;
            if (pointDescription.isLocation() && Algorithms.isEmpty(pointDescription.getName())) {
                pointDescription.setName(PointDescription.getSearchAddressStr(this.ctx));
            }
            if (intermediate < 0 || intermediate > this.intermediatePoints.size()) {
                TargetPoint pn;
                if (intermediate > this.intermediatePoints.size() && (pn = this.getPointToNavigate()) != null) {
                    this.settings.insertIntermediatePoint(pn.getLatitude(), pn.getLongitude(), pn.pointDescription, this.intermediatePoints.size());
                }
                this.settings.setPointToNavigate(point.getLatitude(), point.getLongitude(), pointDescription);
            } else {
                this.settings.insertIntermediatePoint(point.getLatitude(), point.getLongitude(), pointDescription, intermediate);
            }
        } else {
            this.cancelTargetPointAddressRequest();
            this.cancelAllIntermediatePointsAddressRequests();
            this.settings.clearPointToNavigate();
            this.settings.clearIntermediatePoints();
        }
        this.readFromSettings();
        this.updateRouteAndRefresh(updateRoute);
    }

    public void setStartPoint(LatLon startPoint, boolean updateRoute, PointDescription name) {
        if (startPoint != null) {
            PointDescription pointDescription = name == null ? new PointDescription("location", "") : name;
            if (pointDescription.isLocation() && Algorithms.isEmpty(pointDescription.getName())) {
                pointDescription.setName(PointDescription.getSearchAddressStr(this.ctx));
            }
            this.settings.setPointToStart(startPoint.getLatitude(), startPoint.getLongitude(), pointDescription);
        } else {
            this.settings.clearPointToStart();
        }
        this.readFromSettings();
        this.updateRouteAndRefresh(updateRoute);
    }

    public boolean checkPointToNavigateShort() {
        if (this.pointToNavigate == null) {
            JOptionPane.showMessageDialog(null, 768);
            return false;
        }
        return true;
    }

    public Location getPointToStartLocation() {
        return this.wrap(this.getPointToStart());
    }

    private void cancelStartPointAddressRequest() {
        if (this.startPointRequest != null) {
            this.ctx.getGeocodingLookupService().cancel(this.startPointRequest);
            this.startPointRequest = null;
        }
    }

    private void cancelTargetPointAddressRequest() {
        if (this.targetPointRequest != null) {
            this.ctx.getGeocodingLookupService().cancel(this.targetPointRequest);
            this.targetPointRequest = null;
        }
    }

    private void cancelAllIntermediatePointsAddressRequests() {
        List<LatLon> intermediatePointsLatLon = this.getIntermediatePointsLatLon();
        for (LatLon latLon : intermediatePointsLatLon) {
            this.cancelPointAddressRequests(latLon);
        }
    }

    private void cancelPointAddressRequests(LatLon latLon) {
        if (latLon != null) {
            this.ctx.getGeocodingLookupService().cancel(latLon);
        }
    }

    public static class TargetPoint
    implements LocationPoint {
        public LatLon point;
        private PointDescription pointDescription;
        public int index;
        public boolean intermediate;
        public boolean start;

        public TargetPoint(LatLon point, PointDescription name) {
            this.point = point;
            this.pointDescription = name;
        }

        public TargetPoint(LatLon point, PointDescription name, int index) {
            this.point = point;
            this.pointDescription = name;
            this.index = index;
            this.intermediate = true;
        }

        @Override
        public PointDescription getPointDescription(OsmWindow ctx) {
            if (!this.intermediate) {
                return new PointDescription("destination", ctx.getString(1178, ""), this.getOnlyName());
            }
            return new PointDescription("destination", this.index + 1 + ". " + ctx.getString(1047, ""), this.getOnlyName());
        }

        public PointDescription getOriginalPointDescription() {
            return this.pointDescription;
        }

        public String getOnlyName() {
            return this.pointDescription == null ? "" : this.pointDescription.getName();
        }

        public boolean isSearchingAddress(OsmWindow ctx) {
            return this.pointDescription != null && this.pointDescription.isSearchingAddress(ctx);
        }

        public static TargetPoint create(LatLon point, PointDescription name) {
            if (point != null) {
                return new TargetPoint(point, name);
            }
            return null;
        }

        public static TargetPoint createStartPoint(LatLon point, PointDescription name) {
            if (point != null) {
                TargetPoint target = new TargetPoint(point, name);
                target.start = true;
                return target;
            }
            return null;
        }

        @Override
        public double getLatitude() {
            return this.point.getLatitude();
        }

        @Override
        public double getLongitude() {
            return this.point.getLongitude();
        }

        @Override
        public int getColor() {
            return 0;
        }

        @Override
        public boolean isVisible() {
            return false;
        }
    }
}

