/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import com.headius.invokebinder.Binder;
import com.headius.invokebinder.SmartBinder;
import com.headius.invokebinder.SmartHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.anno.JavaMethodDescriptor;
import org.jruby.internal.runtime.methods.DescriptorInfo;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.HandleMethod;
import org.jruby.internal.runtime.methods.InvocationMethodFactory;
import org.jruby.runtime.Block;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.InvocationLinker;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class InvokeDynamicMethodFactory
extends InvocationMethodFactory {
    private static final Logger LOG = LoggerFactory.getLogger(InvokeDynamicMethodFactory.class);
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    public static final com.headius.invokebinder.Signature VARIABLE_ARITY_SIGNATURE = com.headius.invokebinder.Signature.returning(IRubyObject.class).appendArg("context", ThreadContext.class).appendArg("self", IRubyObject.class).appendArg("class", RubyModule.class).appendArg("name", String.class).appendArg("args", IRubyObject[].class).appendArg("block", Block.class);
    public static final com.headius.invokebinder.Signature[] SPECIFIC_ARITY_SIGNATURES;
    private static final SmartBinder[] SPREAD_BINDERS;
    private static final Map<String, SmartBinder> BINDERS;

    public InvokeDynamicMethodFactory(ClassLoader classLoader) {
        super(classLoader);
    }

    @Override
    public DynamicMethod getAnnotatedMethod(RubyModule implementationClass, List<JavaMethodDescriptor> descs, String name2) {
        JavaMethodDescriptor desc1 = descs.get(0);
        DescriptorInfo info = new DescriptorInfo(desc1);
        if (desc1.anno.frame()) {
            return super.getAnnotatedMethod(implementationClass, descs, name2);
        }
        if (!Modifier.isPublic(desc1.declaringClass.getModifiers())) {
            LOG.warn("warning: binding non-public class {}; reflected handles won't work", desc1.declaringClassName);
        }
        int min2 = Integer.MAX_VALUE;
        int max2 = 0;
        boolean notImplemented = false;
        for (JavaMethodDescriptor desc : descs) {
            int specificArity = -1;
            if (desc.optional == 0 && !desc.rest) {
                if (desc.required == 0) {
                    if (desc.actualRequired <= 3) {
                        specificArity = desc.actualRequired;
                    }
                } else if (desc.required >= 0 && desc.required <= 3) {
                    specificArity = desc.required;
                }
            }
            if (specificArity != -1) {
                if (specificArity < min2) {
                    min2 = specificArity;
                }
                if (specificArity > max2) {
                    max2 = specificArity;
                }
            } else {
                if (desc.required < min2) {
                    min2 = desc.required;
                }
                if (desc.rest) {
                    max2 = Integer.MAX_VALUE;
                }
                if (desc.required + desc.optional > max2) {
                    max2 = desc.required + desc.optional;
                }
            }
            notImplemented = notImplemented || desc.anno.notImplemented();
        }
        Supplier<MethodHandle>[] generators = this.buildAnnotatedMethodHandles(implementationClass.getRuntime(), descs, implementationClass);
        return new HandleMethod(implementationClass, desc1.anno.visibility().getDefaultVisibilityFor(desc1.name), desc1.name, min2 == max2 ? Signature.from(min2, 0, 0, 0, 0, Signature.Rest.NONE, -1).encode() : Signature.OPTIONAL.encode(), true, notImplemented, info.getParameterDesc(), min2, max2, generators[0], generators[1], generators[2], generators[3], generators[4]);
    }

    private Supplier<MethodHandle>[] buildAnnotatedMethodHandles(Ruby runtime2, List<JavaMethodDescriptor> descs, RubyModule implementationClass) {
        int min2 = Integer.MAX_VALUE;
        int max2 = 0;
        String rubyName = descs.get((int)0).rubyName;
        Supplier[] targets = new Supplier[5];
        for (JavaMethodDescriptor desc : descs) {
            MethodHandle method2 = desc.isStatic ? Binder.from(desc.returnClass, desc.parameters).invokeStaticQuiet(LOOKUP, desc.declaringClass, desc.name) : Binder.from(desc.returnClass, desc.declaringClass, desc.parameters).invokeVirtualQuiet(LOOKUP, desc.name);
            Supplier<MethodHandle> target2 = InvokeDynamicMethodFactory.adaptHandle(method2, runtime2, desc.actualRequired, desc.required, desc.optional, desc.rest, rubyName, desc.declaringClass, desc.isStatic, desc.hasContext, desc.hasBlock, desc.anno.frame(), implementationClass);
            int specificArity = -1;
            if (desc.required < 4 && desc.optional == 0 && !desc.rest) {
                if (desc.required == 0) {
                    if (desc.actualRequired <= 3) {
                        specificArity = desc.actualRequired;
                    }
                } else if (desc.required >= 0 && desc.required <= 3) {
                    specificArity = desc.required;
                }
            }
            if (specificArity != -1) {
                if (specificArity < min2) {
                    min2 = specificArity;
                }
                if (specificArity > max2) {
                    max2 = specificArity;
                }
            } else {
                if (desc.required < min2) {
                    min2 = desc.required;
                }
                if (desc.rest) {
                    max2 = Integer.MAX_VALUE;
                }
                if (desc.required + desc.optional > max2) {
                    max2 = desc.required + desc.optional;
                }
            }
            if (specificArity >= 0) {
                targets[specificArity] = target2;
                continue;
            }
            targets[4] = target2;
        }
        return targets;
    }

    public static SmartBinder preAdaptHandle(int specificArity, boolean isStatic, boolean hasContext, boolean hasBlock) {
        com.headius.invokebinder.Signature baseSignature = specificArity >= 0 ? SPECIFIC_ARITY_SIGNATURES[specificArity] : VARIABLE_ARITY_SIGNATURE;
        SmartBinder targetBinder = SmartBinder.from(baseSignature);
        targetBinder = targetBinder.exclude("class", "name");
        if (isStatic) {
            if (hasContext) {
                if (!hasBlock) {
                    targetBinder = targetBinder.exclude("block");
                }
            } else {
                targetBinder = hasBlock ? targetBinder.exclude("context") : targetBinder.exclude("context", "block");
            }
        } else {
            targetBinder = hasContext ? (hasBlock ? targetBinder.permute("self", "context", "arg*", "block") : targetBinder.permute("self", "context", "arg*")) : (hasBlock ? targetBinder.permute("self", "arg*", "block") : targetBinder.permute("self", "arg*"));
        }
        return targetBinder;
    }

    public static MethodHandle finishAdapting(SmartBinder binder, RubyModule implementationClass, String rubyName, MethodHandle method2, Class declaringClass, Ruby runtime2, boolean isStatic, boolean frame) {
        TypeDescriptor.OfField returnClass = method2.type().returnType();
        SmartBinder targetBinder = binder;
        if (returnClass != IRubyObject.class) {
            targetBinder = returnClass == Void.TYPE ? targetBinder.filterReturn(MethodHandles.constant(IRubyObject.class, runtime2.getNil())) : targetBinder.castReturn((Class<?>)returnClass);
        }
        if (!isStatic) {
            targetBinder = targetBinder.castArg("self", declaringClass);
        }
        SmartHandle smartTarget = targetBinder.invoke(method2);
        if (frame) {
            smartTarget = SmartHandle.from(smartTarget.signature(), InvocationLinker.wrapWithFrameOnly(binder.baseSignature(), implementationClass, rubyName, smartTarget.handle()));
        }
        MethodHandle target2 = smartTarget.handle();
        if (Options.DEBUG_FULLTRACE.load().booleanValue()) {
            MethodHandle traceCall = Binder.from(target2.type().changeReturnType(Void.TYPE)).permute(0, 3, 2).insert(1, new Object[]{RubyEvent.C_CALL}).invokeVirtualQuiet(LOOKUP, "trace");
            MethodHandle traceReturn = Binder.from(target2.type().changeReturnType(Void.TYPE)).permute(0, 3, 2).insert(1, new Object[]{RubyEvent.C_RETURN}).invokeVirtualQuiet(LOOKUP, "trace");
            target2 = Binder.from(target2.type()).foldVoid(traceCall).tryFinally(traceReturn).invoke(target2);
        }
        return target2;
    }

    public static Supplier<MethodHandle> adaptHandle(MethodHandle method2, Ruby runtime2, int actualRequired, int required, int optional, boolean rest, String rubyName, Class declaringClass, boolean isStatic, boolean hasContext, boolean hasBlock, boolean frame, RubyModule implementationClass) {
        return () -> {
            int specificArity = -1;
            if (optional == 0 && !rest) {
                if (required == 0) {
                    if (actualRequired <= 3) {
                        specificArity = actualRequired;
                    }
                } else if (required >= 0 && required <= 3) {
                    specificArity = required;
                }
            }
            SmartBinder targetBinder = InvokeDynamicMethodFactory.getBinder(specificArity, isStatic, hasContext, hasBlock);
            return InvokeDynamicMethodFactory.finishAdapting(targetBinder, implementationClass, rubyName, method2, declaringClass, runtime2, isStatic, frame);
        };
    }

    @Override
    public DynamicMethod getAnnotatedMethod(RubyModule implementationClass, JavaMethodDescriptor desc, String name2) {
        return this.getAnnotatedMethod(implementationClass, Collections.singletonList(desc), name2);
    }

    public static SmartBinder getBinder(int specific, boolean b1, boolean b2, boolean b3) {
        return BINDERS.get("" + specific + b1 + b2 + b3);
    }

    static {
        com.headius.invokebinder.Signature[] specifics = new com.headius.invokebinder.Signature[4];
        com.headius.invokebinder.Signature specific = com.headius.invokebinder.Signature.returning(IRubyObject.class).appendArg("context", ThreadContext.class).appendArg("self", IRubyObject.class).appendArg("class", RubyModule.class).appendArg("name", String.class);
        specifics[0] = specific.appendArg("block", Block.class);
        for (int i2 = 0; i2 < 3; ++i2) {
            specific = specific.appendArg("arg" + i2, IRubyObject.class);
            specifics[i2 + 1] = specific.appendArg("block", Block.class);
        }
        SPECIFIC_ARITY_SIGNATURES = specifics;
        SPREAD_BINDERS = new SmartBinder[4];
        for (int i3 = 0; i3 < 4; ++i3) {
            InvokeDynamicMethodFactory.SPREAD_BINDERS[i3] = SmartBinder.from(VARIABLE_ARITY_SIGNATURE).permute("context", "self", "block", "args").spread("arg", i3).permute("context", "self", "arg*", "block");
        }
        HashMap<String, SmartBinder> binders = new HashMap<String, SmartBinder>(40);
        for (int specific2 = -1; specific2 <= 3; ++specific2) {
            for (boolean b1 : new boolean[]{false, true}) {
                for (boolean b2 : new boolean[]{false, true}) {
                    for (boolean b3 : new boolean[]{false, true}) {
                        binders.put("" + specific2 + b1 + b2 + b3, InvokeDynamicMethodFactory.preAdaptHandle(specific2, b1, b2, b3));
                    }
                }
            }
        }
        BINDERS = binders;
    }
}

